
/*
 *      2D clipping of a triangle into a polygon using the clipping
 *      boundarys IE_globals.clipLeft, IE_globals.clipRight, IE_globals.clipTop and IE_globals.clipBottom.
 *
 *      The code is based on Sutherland-Hodgman algorithm where we
 *      clip the polygon against each clipping boundary in turn.
 *
 *      Note! This code is far from optimal but it does what it is
 *            supposed to do.
 *
 *      This source is part of the fatmap2.txt document by
 *      Mats Byggmastar, mri@penti.sit.fi
 *      17.4.1997 Jakobstad, Finland
 *
 *      Companies with self respect are encouraged to contact me if
 *      any of this code is to be used as part of a commercial product.
 */

#include <stdio.h>
#include "draw.hh"
#include "globals.hh"


inline int cliptestx(vertexclip * v)
{
    int bits = 0;
    if(v->x < IE_globals.clipLeft)     bits |= LEFT;
    if(v->x > IE_globals.clipRight)    bits |= RIGHT;
    return bits;
}

inline int cliptesty(vertexclip * v)
{
    int bits = 0;
    if(v->y < IE_globals.clipTop)      bits |= TOP;
    if(v->y > IE_globals.clipBottom)      bits |= BOT;
    return bits;
}

/*
 *      vbp is a pointer to a vertex array. The first 3 vertices in that
 *      array is our source vertices. The rest of the array will be used
 *      to hold new vertices created during clipping.
 *
 *      you can then access the new vertices using the *final variable
 *
 *      function returns the number of vertices in the resulting polygon
 */

int
ClipUV( vertexclip *** final, vertexclip * vbp )
{
    int max, n, dsti;
    static vertexclip * vp1[12], * vp2[12];     // vertex ptr buffers
    vertexclip ** src = vp1;
    vertexclip ** dst = vp2;
    vertexclip ** tmp;

    vp1[0] = vbp + 0;
    vp1[1] = vbp + 1;
    vp1[2] = vbp + 2;
    vp1[3] = vbp + 0;

    vbp += 3;       // Next free vertex

    dsti = 0;
    max = 3;

    // left clip

    for(n=0; n<max; n++) {
        vertexclip * src1 = src[n];             // current vertex
        vertexclip * src2 = src[n+1];           // next vertex      
        if((src1->visible & LEFT) == VISIBLE) {
            dst[dsti++] = src1;                 // add visible vertex to list
            if((src2->visible & LEFT) == VISIBLE)
                continue;
        } else
            if((src2->visible & LEFT) != VISIBLE)
                continue;
        float a = (IE_globals.clipLeft - src1->x) / (src2->x - src1->x);
        float ima = 1.0 - a;

        dst[dsti] = vbp++;                      // create new vertex
        dst[dsti]->y = src1->y*ima + src2->y*a;
        dst[dsti]->x = IE_globals.clipLeft;

        dst[dsti]->u = src1->u*ima + src2->u*a;
        dst[dsti]->v = src1->v*ima + src2->v*a;
        dst[dsti]->i = src1->i*ima + src2->i*a;
        dst[dsti]->f = src1->f*ima + src2->f*a;

        dst[dsti]->visible = cliptesty(dst[dsti]);
        dsti++;
    }
    dst[dsti] = dst[0];
    tmp = src; src = dst; dst = tmp;            // Swap src - dst buffers
    max = dsti;
    dsti = 0;

    // right clip

    for(n=0; n<max; n++) {
        vertexclip * src1 = src[n];             // current vertex
        vertexclip * src2 = src[n+1];           // next vertex      
        if((src1->visible & RIGHT) == VISIBLE) {
            dst[dsti++] = src1;                 // add visible vertex to list
            if((src2->visible & RIGHT) == VISIBLE)
                continue;
        } else
            if((src2->visible & RIGHT) != VISIBLE)
                continue;
        float a = (IE_globals.clipRight - src1->x) / (src2->x - src1->x);
        float ima = 1.0-a;

        dst[dsti] = vbp++;                      // create new vertex
        dst[dsti]->y = src1->y*ima + src2->y*a;
        dst[dsti]->x = IE_globals.clipRight;

        dst[dsti]->u = src1->u*ima + src2->u*a;
        dst[dsti]->v = src1->v*ima + src2->v*a;
        dst[dsti]->i = src1->i*ima + src2->i*a;
        dst[dsti]->f = src1->f*ima + src2->f*a;

        dst[dsti]->visible = cliptesty( dst[dsti] );
        dsti++;
    }
    dst[dsti] = dst[0];
    tmp = src; src = dst; dst = tmp;            // swap src - dst buffers
    max = dsti;
    dsti = 0;

    // top clip

    for(n=0; n<max; n++) {
        vertexclip * src1 = src[n];             // current vertex
        vertexclip * src2 = src[n+1];           // next vertex      
        if((src1->visible & TOP) == VISIBLE) {
            dst[dsti++] = src1;                 // add visible vertex to list
            if((src2->visible & TOP) == VISIBLE)
                continue;
        } else
            if((src2->visible & TOP) != VISIBLE)
                continue;
        float a = (IE_globals.clipTop - src1->y) / (src2->y - src1->y);
        float ima = 1.0-a;

        dst[dsti] = vbp++;                      // create new vertex
        dst[dsti]->x = src1->x*ima + src2->x*a;
        dst[dsti]->y = IE_globals.clipTop;

        dst[dsti]->u = src1->u*ima + src2->u*a;
        dst[dsti]->v = src1->v*ima + src2->v*a;
        dst[dsti]->i = src1->i*ima + src2->i*a;
        dst[dsti]->f = src1->f*ima + src2->f*a;

        dst[dsti]->visible = cliptestx(dst[dsti]);
        dsti++;
    }
    dst[dsti] = dst[0];
    tmp = src; src = dst; dst = tmp;            // swap src - dst buffers
    max = dsti;
    dsti = 0;

    // bot clip

    for(n=0; n<max; n++) {
        vertexclip * src1 = src[n];             // current vertex
        vertexclip * src2 = src[n+1];           // next vertex      
        if((src1->visible & BOT) == VISIBLE) {
            dst[dsti++] = src1;                 // add visible vertex to list
            if((src2->visible & BOT) == VISIBLE)
                continue;
        } else
            if((src2->visible & BOT) != VISIBLE)
                continue;
        float a = (IE_globals.clipBottom - src1->y) / (src2->y - src1->y);
        float ima = 1.0-a;

        dst[dsti] = vbp++;                      // create new vertex
        dst[dsti]->x = src1->x*ima + src2->x*a;
        dst[dsti]->y = IE_globals.clipBottom;

        dst[dsti]->u = src1->u*ima + src2->u*a;
        dst[dsti]->v = src1->v*ima + src2->v*a;
        dst[dsti]->i = src1->i*ima + src2->i*a;
        dst[dsti]->f = src1->f*ima + src2->f*a;

        dsti++;
    }

    *final = dst;
    
    return dsti;
}

int ClipUV2(vertexclip *** final, vertexclip * vbp)
{
    int max, n, dsti;
    static vertexclip * vp1[12], * vp2[12];     // vertex ptr buffers
    vertexclip ** src = vp1;
    vertexclip ** dst = vp2;
    vertexclip ** tmp;

    vp1[0] = vbp + 0;
    vp1[1] = vbp + 1;
    vp1[2] = vbp + 2;

    vbp += 3;       // Next free vertex

    dsti = 0;
    max = 3;

    
    vertexclip*  start;
    vertexclip*  end;

    // left clip
    start = src[2];

    for ( n = 0; n < max; n++ ) {
      end = src[n];
      
      if ( (end->visible & LEFT) == VISIBLE ) {
        if ( (start->visible & LEFT) == VISIBLE ) {
          // polygon edge is completely inside
          dst[dsti++] = end;
        } else {
          // end point is inside start point is outside
          float a = (IE_globals.clipLeft - start->x) / (end->x - start->x);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = start->y + (end->y - start->y) * a;
          dst[dsti]->x = IE_globals.clipLeft;
          dst[dsti]->u = start->u + (end->u - start->u) * a;
          dst[dsti]->v = start->v + (end->v - start->v) * a;
          dst[dsti]->i = start->i + (end->i - start->i) * a;
          dst[dsti]->visible = cliptesty(dst[dsti]);
          dsti++;
          
          dst[dsti++] = end;
        }
      } else {
        if ( (start->visible & LEFT) == VISIBLE ) {
          // start point is inside end point is outside
          float a = (IE_globals.clipLeft - end->x) / (start->x - end->x);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = end->y + (start->y - end->y) * a;
          dst[dsti]->x = IE_globals.clipLeft;
          dst[dsti]->u = end->u + (start->u - end->u) * a;
          dst[dsti]->v = end->v + (start->v - end->v) * a;
          dst[dsti]->i = end->i + (start->i - end->i) * a;
          dst[dsti]->visible = cliptesty(dst[dsti]);
          dsti++;
        }
      }
      start = end;
    }

    tmp = src; src = dst; dst = tmp;            // Swap src - dst buffers
    max = dsti;
    dsti = 0;


    // right clip
    start = src[max - 1];

    for ( n = 0; n < max; n++ ) {
      end = src[n];
      
      if ( (end->visible & RIGHT) == VISIBLE ) {
        if ( (start->visible & RIGHT) == VISIBLE ) {
          // polygon edge is completely inside
          dst[dsti++] = end;
        } else {
          // end point is inside start point is outside
          float a = (IE_globals.clipRight - start->x) / (end->x - start->x);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = start->y + (end->y - start->y) * a;
          dst[dsti]->x = IE_globals.clipRight;
          dst[dsti]->u = start->u + (end->u - start->u) * a;
          dst[dsti]->v = start->v + (end->v - start->v) * a;
          dst[dsti]->i = start->i + (end->i - start->i) * a;
          dst[dsti]->visible = cliptesty(dst[dsti]);
          dsti++;
          
          dst[dsti++] = end;
        }
      } else {
        if ( (start->visible & RIGHT) == VISIBLE ) {
          // start point is inside end point is outside
          float a = (IE_globals.clipRight - end->x) / (start->x - end->x);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = end->y + (start->y - end->y) * a;
          dst[dsti]->x = IE_globals.clipRight;
          dst[dsti]->u = end->u + (start->u - end->u) * a;
          dst[dsti]->v = end->v + (start->v - end->v) * a;
          dst[dsti]->i = end->i + (start->i - end->i) * a;
          dst[dsti]->visible = cliptesty(dst[dsti]);
          dsti++;
        }
      }
      start = end;
    }

    tmp = src; src = dst; dst = tmp;            // swap src - dst buffers
    max = dsti;
    dsti = 0;

    // top clip
    start = src[max - 1];

    for ( n = 0; n < max; n++ ) {
      end = src[n];
      
      if ( (end->visible & TOP) == VISIBLE ) {
        if ( (start->visible & TOP) == VISIBLE ) {
          // polygon edge is completely inside
          dst[dsti++] = end;
        } else {
          // end point is inside start point is outside
          float a = (IE_globals.clipTop - start->y) / (end->y - start->y);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = IE_globals.clipTop;
          dst[dsti]->x = start->x + (end->x - start->x) * a;
          dst[dsti]->u = start->u + (end->u - start->u) * a;
          dst[dsti]->v = start->v + (end->v - start->v) * a;
          dst[dsti]->i = start->i + (end->i - start->i) * a;
          dst[dsti]->visible = cliptestx(dst[dsti]);
          dsti++;
          
          dst[dsti++] = end;
        }
      } else {
        if ( (start->visible & TOP) == VISIBLE ) {
          // start point is inside end point is outside
          float a = (IE_globals.clipTop - end->y) / (start->y - end->y);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = IE_globals.clipTop;
          dst[dsti]->x = end->x + (start->x - end->x) * a;
          dst[dsti]->u = end->u + (start->u - end->u) * a;
          dst[dsti]->v = end->v + (start->v - end->v) * a;
          dst[dsti]->i = end->i + (start->i - end->i) * a;
          dst[dsti]->visible = cliptestx(dst[dsti]);
          dsti++;
        }
      }
      start = end;
    }

    tmp = src; src = dst; dst = tmp;            // swap src - dst buffers
    max = dsti;
    dsti = 0;

    // bot clip
    start = src[max - 1];

    for ( n = 0; n < max; n++ ) {
      end = src[n];
      
      if ( (end->visible & BOT) == VISIBLE ) {
        if ( (start->visible & BOT) == VISIBLE ) {
          // polygon edge is completely inside
          dst[dsti++] = end;
        } else {
          // end point is inside start point is outside
          float a = (IE_globals.clipBottom - start->y) / (end->y - start->y);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = IE_globals.clipBottom;
          dst[dsti]->x = start->x + (end->x - start->x) * a;
          dst[dsti]->u = start->u + (end->u - start->u) * a;
          dst[dsti]->v = start->v + (end->v - start->v) * a;
          dst[dsti]->i = start->i + (end->i - start->i) * a;
          dst[dsti]->visible = cliptestx(dst[dsti]);
          dsti++;
          
          dst[dsti++] = end;
        }
      } else {
        if ( (start->visible & BOT) == VISIBLE ) {
          // start point is inside end point is outside
          float a = (IE_globals.clipBottom - end->y) / (start->y - end->y);
        
          dst[dsti] = vbp++;                      // create new vertex
          dst[dsti]->y = IE_globals.clipBottom;
          dst[dsti]->x = end->x + (start->x - end->x) * a;
          dst[dsti]->u = end->u + (start->u - end->u) * a;
          dst[dsti]->v = end->v + (start->v - end->v) * a;
          dst[dsti]->i = end->i + (start->i - end->i) * a;
          dst[dsti]->visible = cliptestx(dst[dsti]);
          dsti++;
        }
      }
      start = end;
    }

    *final = dst;
    
    return dsti;
}

