#ifndef _TEXTURE_H
#define _TEXTURE_H

typedef unsigned short UWORD ;

#define PI (3.14159265359f)

#define CLIPNEAR			// define to enable software clipping to the near z plane 

#define MAXAREA			1024*2048		// maximum number of pixels of texture ram ever needed

#define RETURN_ERROR(call)				\
{										\
	HRESULT rval = (call);				\
	if(rval)							\
	{									\
		TRACE("d3d error = (%d)\n",rval); \
		trace_d3d_error(rval);			\
		return rval;					\
	}									\
}


#define CF_LEFT 1
#define CF_RIGHT 2
#define CF_TOP 4
#define CF_BOTTOM 8
#define CF_NEAR 16
//#define CF_FAR 32

#define MINZ 0.2f			// sets the minimum z value that will be z buffered correctly
#define MINZ2 (MINZ*1.001f)	// the z value that the near z clipper clips to
#define MAXZ 128.0f
#define MAXZBUF 1.f

#define DX_OK (0)
#define DX_ERROR (E_FAIL)			// unspecified error



#define TX_OK					 0
#define TX_ALREADYREMOVED		-1
#define TX_NOTEXTUREPAGES		-2
#define TX_NOTEXTURES			-3
#define TX_OUTOFRAM				-4
#define TX_LOCKED				-5
#define TX_NOTINCACHE			-6
#define TX_NOTLOCKED			-7
#define TX_ERROR				-8


#define	VPOOL_MIN	2048				// min size of vpool, power of 2!
#define	VPOOL_MAX	32767				// max size of vpool, power of 2!
#define VPOOL_DEFAULT (VPOOL_MIN)
#define VPOOL_UP	(VPOOL_MIN/2)		// size of increments to pool size
#define VPOOL_DOWN	(VPOOL_MIN)			// level of hysteresis to stop "continual" pool size changes

#define	IPOOL_MIN	2048				// min size of IPool, power of 2!
#define	IPOOL_MAX	32767				// max size of IPool, power of 2!
#define IPOOL_FLUSH (5400*3)			// MAX number of tris * 3 per texture page
										// that can be added between FlushAll calls
										// chosen so that twice this number is less than 32767 
										// (when my d3d cache falls over)
										// if you don't call flushall often enough it will (eventually) assert

#define IPOOL_DEFAULT (IPOOL_MIN)
#define IPOOL_UP	(IPOOL_MIN/2)		// size of increments to pool size
#define IPOOL_DOWN	(IPOOL_MIN)			// level of hysteresis to stop "continual" pool size changes

#define POOL_SAFETY	64					// max # of vs/is that can be added in one polygon
#define POOL_DOWNCOUNT 512				// number of calls the pool size must drop below thresh before buffer shrunk

typedef D3DTLVERTEX TVERTEX;
typedef signed short TINDEX;



int countbits(unsigned int a);
int countzeros(unsigned int a);


class CTexture
{
public:
	
	static HRESULT InitialiseAll(int softwarecull);
	static void	SetLens(double fov);
	

	static HRESULT GetNicePixelFormat(int bpp, int alpha,DDPIXELFORMAT **outpf);	// returns a nice texture format
	
	
	static HRESULT RestoreLostSurfaces();	
	static HRESULT DrawAll();
	static HRESULT FlushAll();
	static HRESULT UploadAll();
	
	
	static HRESULT DeleteAll();

	static HRESULT Deinit();		// called as a pair when d3d falls over
	static HRESULT Reinit();

	CTexture();
	~CTexture();
	HRESULT Alloc(DDPIXELFORMAT *pf, int wid, int hgt);
	
	HRESULT Draw();	
	HRESULT	Select();
	
	void	AddTri(TINDEX a, TINDEX b, TINDEX c);	
	HRESULT	DrawLine(TINDEX a, TINDEX b);
	TINDEX AddVertex(float x, float y, float z, float u, float v, D3DCOLOR color);
	TINDEX AddVertex(float x, float y, float z, D3DCOLOR color);

	
	HRESULT Restore();	
	static CTexture *mLastSelected;

	HRESULT	Upload();
	UWORD *Lock(int *pitch);
	HRESULT Unlock();
	
protected:
	static HRESULT InitialiseAllWork();
	TINDEX AddVertexCF(float x, float y, float z, float u, float v, D3DCOLOR color, int cf);
	static HRESULT CALLBACK EnumTextureFormatsCallback(DDSURFACEDESC *src,VOID *UserInfo);
	HRESULT AllocIt(DDPIXELFORMAT *pf);
	HRESULT AllocDevSurf();
	void	SetSize(int wid, int hgt);
	void	ResizeVPool(int vsize, int vcsize);	
	void	ResizeIPool(int size);
	


public:
	static float	mXLens;
	static float	mYLens;
	static float	mHalfScreenWidth;
	static float	mHalfScreenHeight;
	static float	mXOffset;
	static float	mYOffset;

	static DDPIXELFORMAT mTexFormat[64];
	static int mNumTexFormat;


	int		mUpload;			// set if needs (re)uploading
	int		mTextured;

//protected:
	// trilist stuff

	TVERTEX		*mVPool,*mVNext,*mVEnd,*mVStart,*mVCNext; // current pool
	int			mNumV;				// cur pool size
	int			mNumVC;				// cur pool size of clipped v's
	int			mVIdx;				// next index...
	int			mVCIdx;				// next clipped index
	int			mNumVDown;			// number of vertices needed to bump it up or down
	int			mNumVCDown;			// number of vertices needed to bump it up or down
	int			mVDownCount;

	TINDEX *mIPool,*mINext,*mIEnd,*mIFlush;
	int			mNumI;
	int			mNumIDown;			// number of vertices needed to bump it up or down
	int			mIDownCount;
	
	// cache stuff

	int 					mWidth,mHeight;			// dimensions of this page, max is (8*cellsize) square	
		
	// d3d stuff

	static int				mSoftwareCull;
	static int				mInSysRam;	// 0 if textures stored on card
	static IDirectDraw2		*mDD;
	static IDirect3DDevice2 *mD3DDevice;	
	static IDirect3D2		*mD3D;
		
	static D3DMATERIAL		mMaterialSettings;	

	static CTexture			*mFirst;
	CTexture				*mNext;

	DDPIXELFORMAT			mPixelFormat;
	
	IDirectDrawSurface		*mDevSurf,*mSysSurf;
	IDirect3DTexture2		*mDevTex;//,*mSysTex;
	IDirect3DMaterial2		*mDevMat;

	D3DTEXTUREHANDLE		mDevTexHandle;
	D3DMATERIALHANDLE		mDevMatHandle;
};




extern CTexture		*GOURAUD;



#endif