
#include	"common.h"

#define ONEOVERZ			// define this for 1/z buffer (ie correct)

// initialise static variables
int					 CTexture::mInSysRam;
IDirectDraw2		*CTexture::mDD=NULL;
IDirect3DDevice2	*CTexture::mD3DDevice=NULL;
IDirect3D2			*CTexture::mD3D=NULL;
D3DMATERIAL			 CTexture::mMaterialSettings;
int				     CTexture::mSoftwareCull;		// D3D cull mode (D3DCULL_NONE => Software cull)
CTexture		*CTexture::mFirst=NULL;
CTexture		*CTexture::mLastSelected=NULL;

float				 CTexture::mXLens=1;
float				 CTexture::mYLens=4.f/3.f;

float				CTexture::mHalfScreenWidth=10.f;
float				CTexture::mHalfScreenHeight=10.f;
float				CTexture::mXOffset=0.f;
float				CTexture::mYOffset=0.f;

DDPIXELFORMAT		CTexture::mTexFormat[64];
int					CTexture::mNumTexFormat=0;


CTexture		*GOURAUD;


HRESULT CTexture::InitialiseAll(int softwarecull)
{	
	SetLens(PI/2);
	mSoftwareCull=softwarecull;
	GOURAUD = new CTexture;
	RETURN_ERROR(GOURAUD->Alloc(NULL,0,0));
	RETURN_ERROR(InitialiseAllWork());	
	return OK;
}

HRESULT CTexture::InitialiseAllWork()
{
	mXOffset=mHalfScreenWidth=gD->mVM->mW/2;	
	mYOffset=mHalfScreenHeight=gD->mVM->mH/2;

	mDD=gD->mDD2;
	mD3DDevice=gD->mD3DD2;
	mD3D=gD->mD3D2;

	D3DDEVICEDESC HWDesc, HELDesc;
	memset(&HWDesc, 0, sizeof(HWDesc));
	HWDesc.dwSize = sizeof(HWDesc);
	memset(&HELDesc, 0, sizeof(HWDesc));
	HELDesc.dwSize = sizeof(HWDesc);
	//FTRACE("getting hardware caps\n");
	RETURN_ERROR(mD3DDevice->GetCaps(&HWDesc, &HELDesc));
	int hardware = HWDesc.dcmColorModel;
	mInSysRam=!hardware;
	memset(&mMaterialSettings, 0, sizeof(D3DMATERIAL));
	mMaterialSettings.dwSize = sizeof(D3DMATERIAL);
	mMaterialSettings.diffuse.r = (D3DVALUE)1.0;
	mMaterialSettings.diffuse.g = (D3DVALUE)1.0;
	mMaterialSettings.diffuse.b = (D3DVALUE)1.0;
	mMaterialSettings.diffuse.a = (D3DVALUE)1.0;
	mMaterialSettings.ambient.r = (D3DVALUE)1.0;
	mMaterialSettings.ambient.g = (D3DVALUE)1.0;
	mMaterialSettings.ambient.b = (D3DVALUE)1.0;
	mMaterialSettings.hTexture = 0;
	mMaterialSettings.dwRampSize = 16;	
	//FTRACE("setting cull state\n");
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_CULLMODE, mSoftwareCull );	
	//FTRACE("initallwork returns ok\n");
	return OK;
}

HRESULT CTexture::DeleteAll()
{
 	CTexture *cp=CTexture::mFirst;
	while (cp) 
	{
		CTexture *cp2=cp->mNext;
		delete cp;
		cp=cp2;
	}
	CTexture::mFirst=NULL;
	return OK;
}


HRESULT CTexture::Deinit()		// fall over with d3d
{		
	CTexture *cp=CTexture::mFirst;
	while (cp)
	{				
		// release all our d3d stuff
		if (cp->mDevSurf) cp->mUpload=1; // mark ones in ram
		RELEASE(cp->mDevMat);
		RELEASE(cp->mDevTex);		
		RELEASE(cp->mDevSurf);
		RELEASE(cp->mSysSurf);	
		cp=cp->mNext;
	}	
	// invalidate the object pointers
	mDD=NULL;
	mD3DDevice=NULL;
	mD3D=NULL;
	mLastSelected=NULL;	// invalidate last selected texture
	return OK;
}

HRESULT CTexture::Reinit()	// come back with d3d
{
	// recreate the d3d objects
	InitialiseAllWork();

	// and restore vital surfaces...
	CTexture *cp=CTexture::mFirst;
	while (cp)
	{
		RETURN_ERROR(cp->AllocIt(&cp->mPixelFormat));				
		cp=cp->mNext;
	}	
	return UploadAll();
}

HRESULT CTexture::UploadAll()
{
	CTexture *cp=CTexture::mFirst;
	while (cp) 
	{
		if (cp->mUpload) cp->Upload();		
		cp=cp->mNext;
	}
	return OK;
}


HRESULT CTexture::DrawAll()
{
	CTexture *cp=CTexture::mFirst;
	while (cp) 
	{
		cp->Draw();		
		cp=cp->mNext;
	}
	return OK;
}

HRESULT CTexture::FlushAll()
{
	CTexture *cp=CTexture::mFirst;
	while (cp) 
	{
		if (cp->mINext>cp->mIFlush) cp->Draw();		
		cp=cp->mNext;
	}
	return OK;
}





int countbits(unsigned int a)
{
	int c=0;
	while (a)
	{
		if (a&1) c++;
		a>>=1;
	}
	return c;
}
int countzeros(unsigned int a)
{
	int c=0;
	while ((a&1)==0 && a)
	{
		c++;
		a>>=1;
	}
	return c;
}


HRESULT CALLBACK CTexture::EnumTextureFormatsCallback(DDSURFACEDESC *src,VOID *UserInfo)
{	
	if (mNumTexFormat>=64) return DDENUMRET_CANCEL;
	memcpy(&mTexFormat[mNumTexFormat++],&src->ddpfPixelFormat,sizeof(DDPIXELFORMAT));
	return DDENUMRET_OK;
}


HRESULT CTexture::GetNicePixelFormat(int bpp, int alpha, DDPIXELFORMAT **outpf)	// returns a nice texture format
{	
	if (mNumTexFormat==0) 
	{
		RETURN_ERROR(mD3DDevice->EnumTextureFormats(CTexture::EnumTextureFormatsCallback,NULL));
	}
	DDPIXELFORMAT *pf=mTexFormat,*bpf=NULL;

	int c1,c2;
	c2=0;
	for (c1=0;c1<mNumTexFormat;c1++,pf++)
	{
		if ((pf->dwFlags&DDPF_RGB) && (pf->dwFlags&DDPF_PALETTEINDEXEDTO8 )==0 && pf->dwRGBBitCount<=bpp)
		{				
			int c=countbits(pf->dwRBitMask)+countbits(pf->dwGBitMask)+countbits(pf->dwBBitMask);
			if (c>c2 && countbits(pf->dwRGBAlphaBitMask)>=alpha)
			{
				c2=c;
				bpf=pf;				
			}
		}
	}
	pf=bpf;
	*outpf=pf;
	if (!bpf) return -1;
	
	TRACE("got pixelformat %d %d %d %d (%d)\n",countbits(pf->dwRBitMask),countbits(pf->dwGBitMask),countbits(pf->dwBBitMask),countbits(pf->dwRGBAlphaBitMask),pf->dwAlphaBitDepth);	
	return DD_OK;	
}

HRESULT CTexture::Upload()
{	
	//TRACE("texture page upload!\n");
	if (!mTextured) return 0;
	if (!mDevSurf) RETURN_ERROR(AllocDevSurf());
	if(!mInSysRam)
	{		
		RETURN_ERROR(mDevSurf->Blt(NULL, mSysSurf, NULL, DDBLT_WAIT, NULL));
	}
	mUpload=0;
	return OK;
}

HRESULT CTexture::RestoreLostSurfaces()
{	
	CTexture *cp=mFirst;
	int needreinit=0,res=OK;
	while (cp)
	{
		if (cp->mTextured)
		{
			IDirectDrawSurface *surf = cp->mDevSurf;
			HRESULT lost1=cp->mDevSurf?cp->mDevSurf->IsLost():0;
			HRESULT lost2=cp->mSysSurf->IsLost();			
			if (lost1==DDERR_SURFACELOST)
			{
				TRACE("dev texture surface lost... restoring\n");
				lost1=cp->mDevSurf->Restore();			
				cp->mUpload=1;
			}
			if (lost2==DDERR_SURFACELOST)
			{
				TRACE("sys texture surface lost... restoring\n");
				lost2=cp->mSysSurf->Restore();			
				if (cp->mDevSurf) cp->mUpload=1;
			}
			if (lost1!=DD_OK || lost2!=DD_OK) 
			{
				needreinit=1;
			}
		}
		cp=cp->mNext;
	}
	if (needreinit)
	{
		res=CTexture::Deinit();
		CTexture::Reinit();
	}
	return res;
}

HRESULT CTexture::AllocDevSurf()
{
	// also create device surface
	if (mInSysRam)
	{
			mDevSurf=mSysSurf;
			mDevSurf->AddRef();		
	}
	else
	{
		DDSURFACEDESC ddsd;
		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize = sizeof(DDSURFACEDESC);
		memcpy(&ddsd.ddpfPixelFormat,&mPixelFormat,sizeof(DDPIXELFORMAT));	
		ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
		ddsd.dwWidth=mWidth;
		ddsd.dwHeight=mHeight;
		
		ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY;// | (ALLOCONLOAD ? DDSCAPS_ALLOCONLOAD : 0);
		HRESULT res=mDD->CreateSurface(&ddsd, &mDevSurf, NULL);
		//FTRACE("create dev surf...\n");
		if (res==DDERR_OUTOFMEMORY || res==DDERR_OUTOFVIDEOMEMORY || res==DDERR_INVALIDPARAMS)
		{
			// oh dear... we dont want the sys surface either			
			return(DDERR_OUTOFVIDEOMEMORY);
		}
		else if (res!=DD_OK) return(res);			
	}
	/*
	// the act of just filling in this field enables colorkeying on some cards. LAME!
	DDCOLORKEY key;
	key.dwColorSpaceLowValue=key.dwColorSpaceHighValue=0;    
	RETURN_ERROR(mDevSurf->SetColorKey(DDCKEY_SRCBLT,&key));	//DDCKEY_SRCBLT
	  */
	// set up texture
	//FTRACE("query dev tex...\n");
	RETURN_ERROR(mDevSurf->QueryInterface(IID_IDirect3DTexture2, (LPVOID*)&mDevTex))	
	//FTRACE("dev tex handle...\n");
	RETURN_ERROR(mDevTex->GetHandle(mD3DDevice, &mDevTexHandle));	
	// Setup material and its handle
	mMaterialSettings.hTexture = mDevTexHandle;
	RETURN_ERROR(mD3D->CreateMaterial(&mDevMat, NULL));
	//FTRACE("set material...\n");
	RETURN_ERROR(mDevMat->SetMaterial(&mMaterialSettings))
	//FTRACE("get handle to material..\n");
	RETURN_ERROR(mDevMat->GetHandle(mD3DDevice, &mDevMatHandle));	
	//FTRACE("alloc it ok!\n");
	return OK;
}

HRESULT CTexture::AllocIt(DDPIXELFORMAT *pf)
{	
	if (pf==NULL) mTextured=0;
	if (mTextured)
	{
		// its a texture mapped page
		//ASSERT(pf);			// must pass a valid reference surface to derive the pixformat etc

		mDevMat=NULL;
		mDevTex=NULL;
		//mSysTex=NULL;	
		mDevSurf=NULL;
		mSysSurf=NULL;
		
		DDSURFACEDESC ddsd;
		memset(&ddsd, 0, sizeof(ddsd));
		ddsd.dwSize = sizeof(DDSURFACEDESC);
		memcpy(&ddsd.ddpfPixelFormat,pf,sizeof(DDPIXELFORMAT));	
		ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
		ddsd.dwWidth=mWidth;
		ddsd.dwHeight=mHeight;
		ddsd.ddsCaps.dwCaps = DDSCAPS_SYSTEMMEMORY | DDSCAPS_TEXTURE;
		//FTRACE("create sys surf...\n");
		RETURN_ERROR(mDD->CreateSurface(&ddsd, &mSysSurf, NULL));
		//RETURN_ERROR(mSysSurf->QueryInterface(IID_IDirect3DTexture2, (LPVOID *)&mSysTex));

		memcpy(&mPixelFormat,pf,sizeof(DDPIXELFORMAT));		
	}
	else
	{
		mDevMatHandle=gD->mHBlackMat;
	}
	//FTRACE("create material...\n");
	return OK;
}

void CTexture::SetSize(int wid, int hgt)
{	
	mWidth=wid;
	mHeight=hgt;	
}

HRESULT CTexture::Alloc(DDPIXELFORMAT *pf, int wid, int hgt)
{
	SetSize(wid,hgt);
	mTextured=(pf!=NULL);
	return(AllocIt(pf));	
}

CTexture::CTexture()
{	
	mUpload=0;	
	mNext=CTexture::mFirst;
	CTexture::mFirst=this;	
		
	mDevSurf=NULL;
	mSysSurf=NULL;
	mDevTex=NULL;
	//mSysTex=NULL;
	mDevMat=NULL;
	mDevTexHandle=0;
	mDevMatHandle=0;

	mNumV=VPOOL_DEFAULT;
	mNumVC=VPOOL_DEFAULT;
	mNumI=IPOOL_DEFAULT;
	mNumVDown=mNumV-VPOOL_DOWN;
	mNumIDown=mNumI-IPOOL_DOWN;
	mVStart=new TVERTEX [mNumV+mNumVC];
	mVCNext=mVNext=mVPool=mVStart+mNumVC;
	mINext=mIPool=new TINDEX [mNumI];	
		
	mVEnd=mVPool+mNumV;
	mIEnd=mIPool+mNumI;	
	mIFlush=mIPool+IPOOL_FLUSH;
	mVIdx=0;
	mVCIdx=0;
}


CTexture::~CTexture()
{
	RELEASE(mDevMat);
	RELEASE(mDevTex);
	//RELEASE(mSysTex);
	RELEASE(mDevSurf);
	RELEASE(mSysSurf);		
	delete [] mVStart;
	delete [] mIPool;
	
	// remove ourselves from the linked list of texture pages
	if (CTexture::mFirst==this)
	{
		CTexture::mFirst=mNext;		
	}
	else
	{		
		CTexture *cp=mFirst;
		while (cp->mNext!=this) 
		{
			cp=cp->mNext;
			//ASSERT(cp);		// oops! corrupt linked list
		}
		cp->mNext=mNext;
	}
}

void CTexture::SetLens(double fov)	// fov in radians
{
	fov/=2;
	if (fov<0.001) fov=0.001;
	if (fov>1.57) fov=1.57;	// pi/2-a bit
	mXLens=(float)(1./tan(fov));
	mYLens=mXLens*(4.f/3);
}

TINDEX CTexture::AddVertex(float x, float y, float z, float u, float v, D3DCOLOR color)
{		
	int cf;			
	if (mVCNext-POOL_SAFETY<=mVStart || mVNext+POOL_SAFETY>=mVEnd) ResizeVPool(mNumV+VPOOL_UP,mNumVC+VPOOL_UP);
	y*=mYLens;
	x*=mXLens;
	if (x<-z) cf=CF_LEFT; else 
	if (x> z) cf=CF_RIGHT; else cf=0;
	if (y<-z) cf|=CF_TOP; else
	if (y> z) cf|=CF_BOTTOM;		
#ifdef CLIPNEAR
	if (z<MINZ2) cf|=CF_NEAR;
#endif	
	if (cf)
	{	
		mVCNext--;			
		//ASSERTMSG(mVCNext>mVStart,"vc pool overrun!");
		mVCNext->sz = z;
		mVCNext->sx = x;
		mVCNext->sy = y;
		mVCNext->color=color;
		mVCNext->tu=u;
		mVCNext->tv=v;
		mVCNext->specular=cf;
		return(-(++mVCIdx));
	}
	else
	{	
		//ASSERTMSG(mVNext<mVEnd,"v pool overrun!");
		mVNext->sz = z;
		mVNext->sx = x;
		mVNext->sy = y;
		mVNext->color=color;
		mVNext->tu=u;
		mVNext->tv=v;
		mVNext->specular=0;		
		mVNext++;
		return(mVIdx++);
	}		
};

TINDEX CTexture::AddVertex(float x, float y, float z, D3DCOLOR color)
{		
	int cf;		
	if (mVCNext-POOL_SAFETY<=mVStart || mVNext+POOL_SAFETY>=mVEnd) ResizeVPool(mNumV+VPOOL_UP,mNumVC+VPOOL_UP);	
	y*=mYLens;
	x*=mXLens;
	if (x<-z) cf=CF_LEFT; else 
	if (x> z) cf=CF_RIGHT; else cf=0;
	if (y<-z) cf|=CF_TOP; else
	if (y> z) cf|=CF_BOTTOM;		
#ifdef CLIPNEAR
	if (z<MINZ2) cf|=CF_NEAR;
#endif	
	if (cf)
	{	
		mVCNext--;			
		//ASSERTMSG(mVCNext>mVStart,"vc pool overrun!");
		mVCNext->sz = z;
		mVCNext->sx = x;
		mVCNext->sy = y;
		mVCNext->color=color;
		mVCNext->specular=cf;			
		return(-(++mVCIdx));
	}
	else
	{	
		//ASSERTMSG(mVNext<mVEnd,"v pool overrun!");
		mVNext->sz = z;
		mVNext->sx = x;
		mVNext->sy = y;
		mVNext->color=color;
		mVNext->specular=0;		
		mVNext++;
		return(mVIdx++);
	}		
};

TINDEX CTexture::AddVertexCF(float x, float y, float z, float u, float v, D3DCOLOR color, int cf)
{				
	if (cf)
	{	
		mVCNext--;			
		//ASSERTMSG(mVCNext>mVStart,"vc pool overrun!");
		mVCNext->sz = z;
		mVCNext->sx = x;
		mVCNext->sy = y;
		mVCNext->color=color;
		mVCNext->tu=u;
		mVCNext->tv=v;
		mVCNext->specular=cf;			
		return(-(++mVCIdx));
	}
	else
	{			
		//ASSERTMSG(mVNext<mVEnd,"v pool overrun!");
		mVNext->sz = z;
		mVNext->sx = x;
		mVNext->sy = y;
		mVNext->color=color;
		mVNext->tu=u;
		mVNext->tv=v;
		mVNext->specular=0;		
		mVNext++;
		return(mVIdx++);
	}
}

ULONG interprgba(ULONG c1, ULONG c2, float f)
{		
	
	ULONG fi=ULONG(256.0f*f);
	return 
	(((c1>> 0)&0xff)+((int((c2>> 0)&0xff)-int((c1>> 0)&0xff))*fi>>8)<<0)|
	(((c1>> 8)&0xff)+((int((c2>> 8)&0xff)-int((c1>> 8)&0xff))*fi>>8)<<8)|
	(((c1>>16)&0xff)+((int((c2>>16)&0xff)-int((c1>>16)&0xff))*fi>>8)<<16)|
	c1&0xff000000;
	//(((c1>>24)&0xff)+((int((c2>>24)&0xff)-int((c1>>24)&0xff))*fi>>8)<<24);
}

#define INTERP(fcalc,zp,fleft,ftop,fright,fbottom)	{	\
					dx=curv->sx-oldv->sx;				\
					dy=curv->sy-oldv->sy;				\
					dz=curv->sz-oldv->sz;				\
					du=curv->tu-oldv->tu;				\
					dv=curv->tv-oldv->tv;				\
					f=(fcalc);							\
					xx=oldv->sx+f*dx;					\
					yy=oldv->sy+f*dy;					\
					zz=zp;								\
					if (fleft && xx<-(zz)) cf=CF_LEFT; else			\
					if (fright && xx> (zz)) cf=CF_RIGHT;				\
					if (ftop && yy<-(zz)) cf|=CF_TOP; else			\
					if (fbottom && yy> (zz)) cf|=CF_BOTTOM;			\
					icol=interprgba(oldv->color,curv->color,f);		\
					*idxout++=AddVertexCF(xx,yy,(zz), oldv->tu+f*du,oldv->tv+f*dv,icol,cf); \
							}

/*
#define INTERPLINE(fcalc,zz,fleft,ftop,fright,fbottom)	{	\
					dx=curv->sx-oldv->sx;				\
					dy=curv->sy-oldv->sy;				\
					dz=curv->sz-oldv->sz;				\
					du=curv->tu-oldv->tu;				\
					dv=curv->tv-oldv->tv;				\
					f=(fcalc);							\
					xx=oldv->sx+f*dx;					\
					yy=oldv->sy+f*dy;					\
					if (fleft && xx<-(zz)) cf=CF_LEFT; else			\
					if (fright && xx> (zz)) cf=CF_RIGHT;				\
					if (ftop && yy<-(zz)) cf|=CF_TOP; else			\
					if (fbottom && yy> (zz)) cf|=CF_BOTTOM;			\
					c=AddVertexCF(xx,yy,(zz), oldv->tu+f*du,oldv->tv+f*dv,oldv->color,cf); \
							}
*/

TINDEX idx1[8],idx2[8],*idx,*idxout;

HRESULT	CTexture::DrawLine(TINDEX a, TINDEX b)
{
	D3DTLVERTEX t[2];
	TINDEX i[2]={0,1};
	if (mVPool[a].sz<0 || mVPool[b].sz<0) return OK;	
	memcpy(&t[0],&mVPool[a],sizeof(t[0]));
	memcpy(&t[1],&mVPool[b],sizeof(t[0]));
	RETURN_ERROR(GOURAUD->Select());
	
	t[0].rhw=1.0f/t[0].sz;		// this value for perspective correct	
	t[0].sx=(t[0].sx*CTexture::mHalfScreenWidth*t[0].rhw+CTexture::mXOffset);
	t[0].sy=(t[0].sy*CTexture::mHalfScreenHeight*t[0].rhw+CTexture::mYOffset);
	t[0].rhw*=MINZ;
	t[0].sz=MAXZBUF-(t[0].rhw);		// this value goes into the z buffer, 0..1
	//t[0].color=t[0].col;
	t[0].specular=0;

	t[1].rhw=1.0f/t[1].sz;		// this value for perspective correct	
	t[1].sx=(t[1].sx*CTexture::mHalfScreenWidth*t[1].rhw+CTexture::mXOffset);
	t[1].sy=(t[1].sy*CTexture::mHalfScreenHeight*t[1].rhw+CTexture::mYOffset);
	t[1].rhw*=MINZ;
	t[1].sz=MAXZBUF-(t[1].rhw);		// this value goes into the z buffer, 0..1	
	//t[1].color=t[1].col;
	t[1].specular=0;

	RETURN_ERROR(mD3DDevice->DrawIndexedPrimitive(D3DPT_LINELIST,D3DVT_TLVERTEX,(D3DTLVERTEX*)t,2,(unsigned short*)i,2,0));
	return OK;
}

void	CTexture::AddTri(TINDEX a, TINDEX b, TINDEX c)
{		
	if (mSoftwareCull==D3DCULL_NONE)
	{
		FVector temp(mVPool[a].sx,mVPool[a].sy,mVPool[a].sz);
		if (((temp-FVector(mVPool[b].sx,mVPool[b].sy,mVPool[b].sz))^(temp-FVector(mVPool[c].sx,mVPool[c].sy,mVPool[c].sz)))*temp<0) return;
	}
	if (mINext+POOL_SAFETY>=mIEnd) ResizeIPool(mNumI+IPOOL_UP);
	//if (mVCNext-POOL_SAFETY<=mVStart || mVNext+POOL_SAFETY>=mVEnd) ResizeVPool(mNumV+VPOOL_UP,mNumVC+VPOOL_UP);
	if ((a|b|c)<0)	// any of them 0...
	{	
		// offscreen or clipped....
		if ((a&b&c)<0 && (mVPool[a].specular&mVPool[b].specular&mVPool[c].specular))	 return;
		// clipped!								
		TVERTEX *oldv,*curv;
		float f,dx,dy,dz,du,dv,xx,yy,zz;
		int numidx,cf;					
		int oldvcidx=mVCIdx;
		ULONG icol;
		TVERTEX *oldvcnext=mVCNext;

#ifdef CLIPNEAR
		idx2[0]=a;idx2[1]=b;idx2[2]=c;numidx=3;			
		//////////////////////////// near
		idxout=idx1;idx=idx2;			
		oldv=mVPool+c;
		for (;numidx--;idx++,oldv=curv)
		{	
			curv=mVPool+(*idx);			
			if ((curv->specular^oldv->specular)&CF_NEAR) {cf=0;INTERP((MINZ2-oldv->sz)/(dz),oldv->sz+f*dz,1,1,1,1);}
			if ((curv->specular&CF_NEAR)==0) *idxout++=*idx;																		
		}
		numidx=idxout-idx1;			

		//////////////////////////// left after near clip
		idxout=idx2;idx=idx1;			
		oldv=mVPool+idx[numidx-1];
#else
		idx1[0]=a;idx1[1]=b;idx1[2]=c;numidx=3;			
		//////////////////////////// left as first clip
		idxout=idx2;idx=idx1;			
		oldv=mVPool+c;
#endif
		for (;numidx--;idx++,oldv=curv)
		{	
			curv=mVPool+(*idx);			
			if ((curv->specular^oldv->specular)&CF_LEFT) {cf=0;INTERP((oldv->sx+oldv->sz)/(-dz-dx),-xx,0,1,1,1);}
			if ((curv->specular&CF_LEFT)==0) *idxout++=*idx;																		
		}
		numidx=idxout-idx2;			
	
		////////////////////////// top
		idxout=idx1;idx=idx2;
		oldv=mVPool+idx[numidx-1];		
		for (;numidx--;idx++,oldv=curv)
		{
			curv=mVPool+(*idx);						
			if ((curv->specular^oldv->specular)&CF_TOP) {cf=0;INTERP((oldv->sy+oldv->sz)/(-dz-dy),-yy,0,0,1,1);}
			if ((curv->specular&CF_TOP)==0) *idxout++=*idx;																		
		}
		numidx=idxout-idx1;

		//////////////////////////// right
		idxout=idx2;idx=idx1;			
		oldv=mVPool+idx[numidx-1];		
		for (;numidx--;idx++,oldv=curv)
		{
			curv=mVPool+(*idx);						
			if ((curv->specular^oldv->specular)&CF_RIGHT) {cf=0;INTERP((oldv->sx-oldv->sz)/(dz-dx),xx,0,0,0,1);}				
			if ((curv->specular&CF_RIGHT)==0) *idxout++=*idx;																		
		}
		numidx=idxout-idx2;			
		cf=0;
		////////////////////////// bottom
		idxout=idx1;idx=idx2;
		oldv=mVPool+idx[numidx-1];		
		for (;numidx--;idx++,oldv=curv)
		{
			curv=mVPool+(*idx);						
			if ((curv->specular^oldv->specular)&CF_BOTTOM) INTERP((oldv->sy-oldv->sz)/(dz-dy),yy,0,0,0,0);				
			if ((curv->specular&CF_BOTTOM)==0) *idxout++=*idx;																		
		}
		numidx=idxout-idx1;

		mVCIdx=oldvcidx;		// don't need to remember any "extra" clipped points
		mVCNext=oldvcnext;
					
		idx=idx1;
		a=idx[0];			
		//ASSERTMSG(mINext+numidx<mIEnd,"i pool overrun!");
		
		for (numidx-=2;numidx>0;numidx--,idx++)
		{
#ifndef NDEBUG
			if (a>=0 && idx[1]>=0 && idx[2]>=0) 
			{
#endif
				*(mINext++)=a;		
				*(mINext++)=idx[1];		
				*(mINext++)=idx[2];						
#ifndef NDEBUG
			}
			else
			{
				//FTRACE("oops! clipped point is outside");
			}
#endif
		}
		// hmm...		
	}
	else
	{
		// unclipped
		//ASSERTMSG(mINext+3<mIEnd,"i pool overrun!");
		*(mINext++)=a;		
		*(mINext++)=b;		
		*(mINext++)=c;		
	}
	// flush
	//if (mINext>=mIFlush) Draw();
};

void		CTexture::ResizeVPool(int vsize, int vcsize)
{		
	vsize=(vsize+VPOOL_UP-1)&(~(VPOOL_UP-1));
	vcsize=(vcsize+VPOOL_UP-1)&(~(VPOOL_UP-1));
	if (vsize<VPOOL_MIN) vsize=VPOOL_MIN;
	if (vcsize<VPOOL_MIN) vcsize=VPOOL_MIN;
	//ASSERTMSG(vsize<VPOOL_MAX,"v pool size too big for d3d");
	//ASSERTMSG(vcsize<VPOOL_MAX,"vc pool size too big for d3d");
	if (vsize==mNumV && vcsize==mNumVC) return;
	TRACE("resizing vpool to %d %d\n",vsize,vcsize);	
	mNumV=vsize;
	mNumVC=vcsize;	
	mNumVDown=vsize-VPOOL_DOWN;
	mNumVCDown=vcsize-VPOOL_DOWN;
	TVERTEX *temp=new TVERTEX [mNumV+mNumVC];
	//ASSERTMSG(temp,"out of ram for vpool");
	//ASSERT(mNumVC>mVCIdx);
	//ASSERT(mNumV>mVIdx);

	if (mVCIdx|mVIdx) memcpy(temp+mNumVC-mVCIdx,mVPool-mVCIdx,(mVCIdx+mVIdx)*sizeof(TVERTEX));
	delete [] mVStart;
	mVStart=temp;
	mVPool=temp+mNumVC;
	mVEnd=mVPool+mNumV;
	mVNext=mVPool+mVIdx;
	mVCNext=mVPool-mVCIdx;	
}

void		CTexture::ResizeIPool(int size)
{		
	size=(size+IPOOL_UP-1)&(~(IPOOL_UP-1));
	if (size<IPOOL_MIN) size=IPOOL_MIN;
	//ASSERTMSG(size<IPOOL_MAX,"i pool size too big for d3d");
	if (size==mNumI) return;
	TRACE("resizing ipool to %d\n",size);	
	mNumI=size;	
	mNumIDown=size-IPOOL_DOWN;
	TINDEX *temp=new TINDEX [mNumI];
	//ASSERTMSG(temp,"out of ram for ipool");
	int c=mINext-mIPool;
	if (c) memcpy(temp,mIPool,(c)*sizeof(TINDEX));
	delete [] mIPool;
	mIPool=temp;
	mIEnd=mIPool+mNumI;
	mIFlush=mIPool+IPOOL_FLUSH;
	mINext=mIPool+c;	
}

HRESULT		CTexture::Draw()
{
	if (mTextured && (!mDevSurf)) return -1;
	int nv=mVIdx;	
	int nvc=mVCIdx;
	int ni=mINext-mIPool;
	float hsw=CTexture::mHalfScreenWidth*(1.f/MINZ);
	float hsh=CTexture::mHalfScreenHeight*(1.f/MINZ);



	if (nv>=3 && ni>=3)
	{
		// perspective transform!
		TVERTEX *v=mVPool;
		for (;v<mVNext;v++)
		{
			v->rhw=MINZ/v->sz;		// this value for perspective correct
#ifdef ONEOVERZ
			v->sz=(MAXZBUF-v->rhw);		// this value goes into the z buffer, 0..1
#ifdef _DEBUG
			//if ((v->sz<0.0f)||(v->sz>1.0f))		CONSOLE.Printf("Z out of range: %f\n",v->sz);
#endif
#else			
			v->sz=1.f/v->rhw;
#endif
			v->sx=(v->sx*hsw*v->rhw+CTexture::mXOffset);
			v->sy=(v->sy*hsh*v->rhw+CTexture::mYOffset);						
		}
		// draw it
		if (mLastSelected!=this)
		{
			RETURN_ERROR(mD3DDevice->SetRenderState(D3DRENDERSTATE_TEXTUREHANDLE, mDevTexHandle));
			RETURN_ERROR(mD3DDevice->SetLightState(D3DLIGHTSTATE_MATERIAL, mDevMatHandle));
			mLastSelected=this;
		}
		RETURN_ERROR(mD3DDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,D3DVT_TLVERTEX,(D3DTLVERTEX*)mVPool,nv,(unsigned short*)mIPool,ni,0));//D3DDP_DONOTCLIP));
	}
	mVCNext=mVNext=mVPool;
	mINext=mIPool;
	mVCIdx=mVIdx=0;		
	if (nv<mNumVDown && nvc<mNumVCDown) 
	{
		mVDownCount++;
		if (mVDownCount>POOL_DOWNCOUNT) 
		{
			TRACE("shrinking v pool, count %d thresh %d curnum %d bufsize %d\n",mVDownCount,mNumVDown,nv,mNumV);
			ResizeVPool(mNumV-VPOOL_DOWN,mNumVC-VPOOL_DOWN);
		}
	} else mVDownCount=0;
	if (ni<mNumIDown) 
	{
		mIDownCount++;
		if (mIDownCount>POOL_DOWNCOUNT) 
		{
			TRACE("shrinking i pool, count %d thresh %d curnum %d bufsize %d\n",mIDownCount,mNumIDown,ni,mNumI);
			ResizeIPool(ni);
		}
	} else mIDownCount=0;
	return OK;
}

HRESULT	CTexture::Select()
{
	if (mLastSelected!=this)
	{
		if (mTextured)
		{
			RETURN_ERROR(mD3DDevice->SetRenderState(D3DRENDERSTATE_TEXTUREHANDLE, mDevTexHandle));		
		}
		else
		{
			RETURN_ERROR(mD3DDevice->SetRenderState(D3DRENDERSTATE_TEXTUREHANDLE, 0));		
		}		
		RETURN_ERROR(mD3DDevice->SetLightState(D3DLIGHTSTATE_MATERIAL, mDevMatHandle ));		
		mLastSelected=this;
	}
	return OK;
}



UWORD *CTexture::Lock(int *pitch)
{
	DDSURFACEDESC ddsd;			
	memset(&ddsd,0,sizeof(DDSURFACEDESC));
	ddsd.dwSize = sizeof(DDSURFACEDESC);
	if (!mSysSurf || mSysSurf->Lock(NULL, &ddsd, DDLOCK_SURFACEMEMORYPTR | DDLOCK_WAIT | DDLOCK_WRITEONLY,  NULL)!=D3D_OK) return NULL;
	*pitch=ddsd.lPitch/2;	
	return (UWORD*)ddsd.lpSurface;
}


HRESULT CTexture::Unlock()
{
	RETURN_ERROR(mSysSurf->Unlock(NULL));
	mUpload=1;
	return OK;
}
