#ifndef _PROFILE_H_
#define _PROFILE_H_

#define _PROFILE

#ifndef _PROFILE

#define RESULTS() 
#define START() 
#define PROFILE(x) 
#define PROFNAME(x,str)

#else

#define RESULTS() prof.results();
#define START() prof.start();
#define PROFILE(x) prof.profile(x);
#define PROFNAME(x,str) {prof.name[x]=str;prof.profile(x);}

struct Prof
{
	int lastt,lasti;
	int times[32];
	int count[32];
	char *name[32];

	int calls[32];
	float ms[32];
	float cpu[32];

	float maxcpu;

	int gettime()
	{
		int r;
		_asm
		{
			_emit 0x0f
			_emit 0x31
			shrd eax,edx,10
			mov r,eax
		}
		return r;
	}

	Prof()
	{
		memset(this,0,sizeof(*this));
		name[0]="other";
		maxcpu=1.;
	}

	void start()
	{
		memset(count,0,sizeof(count));		
		memset(times,0,sizeof(times));		
		lastt=gettime();
	}

	void profile(int i)
	{
		times[lasti]+=gettime()-lastt;
		count[lasti]++;
		lasti=i;
		lastt=gettime();
	}

#define MILLI (1024.f/300000.f)
	void results()
	{
		profile(0);
		int tot=0;
		int c1;
		maxcpu=0;
		for (c1=0;c1<32;c1++) tot+=times[c1];
		for (c1=0;c1<32;c1++) 
		{
			calls[c1]=count[c1];
			ms[c1]=times[c1]*MILLI;
			cpu[c1]=times[c1]*100.f/float(tot);
			if (cpu[c1]>maxcpu) maxcpu=cpu[c1];
		}
	}

};

extern Prof prof;


#endif

#endif