// "player" - interface between player and directsound interface in d3dmain

#include "common.h"
#include "mpeg.h"

extern FILE *hackf;
FILE *hackf=NULL;

int MP3CHANS=2;
int available=0;	// bytes of mpeg audio available
int mpegok=0;
char mpegbuf[18*32*16];
char *mpegbufp;
int subpi;
frame fr;

void killmpeg()
{
	if (!mpegok) return; 
	delete [] mp3bufbase;
	mpegok=0;
}

extern int InitMpegPlayer(char *fname);
int InitMpegPlayer(char *fname)
{
	if (mpegok) killmpeg();
	if (gD->mNoSound) return 1;
	FILE *f=fopen(fname,"rb");    
	int filesize;
	if (!f) return 0;
	fseek(f,0,SEEK_END);
	filesize=ftell(f);
	fseek(f,0,SEEK_SET);	
	mp3bufbase=mp3buf=new char[filesize+1024];		
	fread(mp3buf,filesize,1,f);
	fclose(f);

	unsigned char hbuf[8];
	((int*)(&hbuf))[0]=((int*)mp3buf)[0];
	unsigned long newhead = ((unsigned long) hbuf[0] << 24) | ((unsigned long) hbuf[1] << 16) |
            ((unsigned long) hbuf[2] << 8) | (unsigned long) hbuf[3];
	int mode      = ((newhead>>6)&0x3);
    MP3CHANS    = (mode == MPG_MD_MONO) ? 1 : 2;



    fr.single = -1; /* both channels */
    if (gD->mSM->mMixrate<=MP3MIXRATE/4)
	{
		fr.synth = synth_4to1;
		fr.synth_mono= synth_4to1_mono;
		fr.down_sample = 2;
		subpi=(MP3MIXRATE/4*65536)/gD->mSM->mMixrate-65536;
	}
	else if (gD->mSM->mMixrate<=MP3MIXRATE/2)
	{
		fr.synth = synth_2to1;
		fr.synth_mono= synth_2to1_mono;
		fr.down_sample = 1;
		subpi=(MP3MIXRATE/2*65536)/gD->mSM->mMixrate-65536;
	}
	else
	{
		fr.synth = synth_1to1;
		fr.synth_mono= synth_1to1_mono;
		fr.down_sample = 0;
		subpi=((MP3MIXRATE*32768)/gD->mSM->mMixrate)*2-65536;
	}	
	fr.block_size = 128>>fr.down_sample;
    pcm_sample = (unsigned char *) mpegbuf;
              
    make_decode_tables(32768);
    init_layer2(); /* inits also shared tables with layer1 */
    init_layer3(fr.down_sample);
    read_frame_init();	
	available=0;
	mpegok=1;

	/*
	
	if (!hackf)
	{
		hackf=fopen("4alex.raw","rb");
	}
	
	  */

	return 1;
}

int subp=0;

int getmpeg()
{
	mpegbufp=mpegbuf;
	if (!mpegok)
	{
		return 1024;
	}
	pcm_point=0;
	if (!read_frame(&fr))  {
		killmpeg();
		mpegok=0;
		memset(mpegbuf,0,1024);
		return 1024;
	}
	(fr.do_layer)(&fr);

	if (gD->mSM->mStereo==0)
	{
		// do a mono making pass
		short *in=(short*)mpegbuf;
		short *out=(short*)mpegbuf;
		pcm_point>>=1;
		for (int c1=0;c1<pcm_point;c1+=2,in+=2) *out++=(in[0]+in[1])>>1;
		if (subpi)
		{
			// do a resample 32->22 or whatever
			
			short *in=(short*)mpegbuf;
			short *out=(short*)mpegbuf;
			int c2=0;
			for (int c1=0;c1<pcm_point;)
			{
				out[0]=in[0];				
				subp+=subpi;
				if (subp>65536)
				{
					c1+=4;
					in+=2;out+=1;
					subp&=65535;
				}
				else
				{
					c1+=2;
					in++;out++;
				}
				c2++;
			}
			pcm_point=c2*2;
		}
	}
	else
	{
		if (subpi)
		{
			// do a resample 32->22 or whatever
			
			short *in=(short*)mpegbuf;
			short *out=(short*)mpegbuf;
			int c2=0;
			for (int c1=0;c1<pcm_point;)
			{
				out[0]=in[0];
				out[1]=in[1];
				subp+=subpi;
				if (subp>65536)
				{
					c1+=8;
					in+=4;out+=2;
					subp&=65535;
				}
				else
				{
					c1+=4;
					in+=2;out+=2;
				}
				c2++;
			}
			pcm_point=c2*4;
		}
	}
	//TRACE("got %d bytes of mpeg\n",pcm_point);
	return pcm_point;	// number of bytes written
}


void CD3D::WriteSound(char *dest, int bytes)
{
	
	if (hackf)
	{
		fread(dest,1,bytes,hackf);
		return;
	}

	//WriteSound(dest,bytes);return;
	int c1;
	while (bytes>0)
	{
		if (!available) available=getmpeg(); // unpack more mpeg;		
		c1=bytes;if (c1>available) c1=available;	
		memcpy(dest,mpegbufp,c1);
		mpegbufp+=c1;
		available-=c1;
		dest+=c1;
		bytes-=c1;
	}	
}

void CD3D::CleanUpSound()
{
	if (hackf) fclose(hackf);
	killmpeg();
}