#include <ctype.h>
#include <stdlib.h>
#include "mpeg.h"
#include "tables.h"

/* max = 1728 */
#define MAXFRAMESIZE 1792

#define SKIP_JUNK 1

int tabsel_123[2][3][16] = {
   { {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,},
     {0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,},
     {0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,} },

   { {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,} }
};

long freqs[7] = { 44100, 48000, 32000, 22050, 24000, 16000 , 11025 };

static int bitindex;
static unsigned char *wordpointer;

static int fsize=0,fsizeold=0,ssize;
static unsigned char bsspace[2][MAXFRAMESIZE+512]; /* MAXFRAMESIZE */
static unsigned char *bsbuf=bsspace[1],*bsbufold;
static int bsnum=0;
char *mp3buf;
char *mp3bufbase;


struct ibuf {
	struct ibuf *next;
	struct ibuf *prev;
	unsigned char *buf;
	unsigned char *pnt;
	int len;
	/* skip,time stamp */
};

struct ibuf ibufs[2];
struct ibuf *cibuf;
int ibufnum=0;

unsigned char *pcm_sample;
int pcm_point = 0;

static void get_II_stuff(struct frame *fr)
{
  static int translate[3][2][16] = 
   { { { 0,2,2,2,2,2,2,0,0,0,1,1,1,1,1,0 } ,
       { 0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,0 } } ,
     { { 0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0 } ,
       { 0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0 } } ,
     { { 0,3,3,3,3,3,3,0,0,0,1,1,1,1,1,0 } ,
       { 0,3,3,0,0,0,1,1,1,1,1,1,1,1,1,0 } } };

  int table,sblim;
  static struct al_table *tables[5] = 
       { alloc_0, alloc_1, alloc_2, alloc_3 , alloc_4 };
  static int sblims[5] = { 27 , 30 , 8, 12 , 30 };

  if(fr->lsf)
    table = 4;
  else
    table = translate[fr->sampling_frequency][2-fr->stereo][fr->bitrate_index];
  sblim = sblims[table];

  fr->alloc = tables[table];
  fr->II_sblimit = sblim;
}



static unsigned long oldhead = 0;
static unsigned long firsthead=0;

void read_frame_init (void)
{
    oldhead = 0;
    firsthead = 0;
}

#define HDRCMPMASK 0xfffffd00



int read_frame(struct frame *fr)
{
  static unsigned long newhead;

  static unsigned char ssave[34];
  unsigned char hbuf[8];
  static int framesize;

  //if(fread(hbuf,1,4,filept) != 4)  return 0;
  ((int*)(&hbuf))[0]=((int*)mp3buf)[0];
  mp3buf+=4;

  newhead = ((unsigned long) hbuf[0] << 24) | ((unsigned long) hbuf[1] << 16) |
            ((unsigned long) hbuf[2] << 8) | (unsigned long) hbuf[3];

  if(oldhead != newhead || !oldhead)
  {
    fr->header_change = 1;


    if( (newhead & 0xffe00000) != 0xffe00000) {           
        return (0);
    }
    if (!firsthead)
      firsthead = newhead;

    if( newhead & (1<<20) ) {
      fr->lsf = (newhead & (1<<19)) ? 0x0 : 0x1;
      fr->mpeg25 = 0;
    }
    else {
      fr->lsf = 1;
      fr->mpeg25 = 1;
    }
    
    if (!oldhead) {
      fr->lay = 4-((newhead>>17)&3);
      fr->bitrate_index = ((newhead>>12)&0xf);
      if( ((newhead>>10)&0x3) == 0x3) {
        //fprintf(stderr,"Stream error\n");
        //exit(1);
		  return 0;
      }
      if(fr->mpeg25)
        fr->sampling_frequency = 6;
      else
        fr->sampling_frequency = ((newhead>>10)&0x3) + (fr->lsf*3);
      fr->error_protection = ((newhead>>16)&0x1)^0x1;
    }

    fr->padding   = ((newhead>>9)&0x1);
    fr->extension = ((newhead>>8)&0x1);
    fr->mode      = ((newhead>>6)&0x3);
    fr->mode_ext  = ((newhead>>4)&0x3);
    fr->copyright = ((newhead>>3)&0x1);
    fr->original  = ((newhead>>2)&0x1);
    fr->emphasis  = newhead & 0x3;

    fr->stereo    = (fr->mode == MPG_MD_MONO) ? 1 : 2;

    oldhead = newhead;

    if(!fr->bitrate_index)
    {
      //fprintf(stderr,"Free format not supported.\n");
      return (0);
    }

    switch(fr->lay)
    {
      case 1:
		fr->do_layer = do_layer1;
        fr->jsbound = (fr->mode == MPG_MD_JOINT_STEREO) ? 
                         (fr->mode_ext<<2)+4 : 32;
        framesize  = (long) tabsel_123[fr->lsf][0][fr->bitrate_index] * 12000;
        framesize /= freqs[fr->sampling_frequency];
        framesize  = ((framesize+fr->padding)<<2)-4;
        break;
      case 2:
		fr->do_layer = do_layer2;

        get_II_stuff(fr);
        fr->jsbound = (fr->mode == MPG_MD_JOINT_STEREO) ?
                         (fr->mode_ext<<2)+4 : fr->II_sblimit;
        framesize = (long) tabsel_123[fr->lsf][1][fr->bitrate_index] * 144000;
        framesize /= freqs[fr->sampling_frequency];
        framesize += fr->padding - 4;
        break;
      case 3:
		fr->do_layer = do_layer3;
        if(fr->lsf)
          ssize = (fr->stereo == 1) ? 9 : 17;
        else
          ssize = (fr->stereo == 1) ? 17 : 32;
        if(fr->error_protection)
          ssize += 2;

          framesize  = (long) tabsel_123[fr->lsf][2][fr->bitrate_index] * 144000;
          framesize /= freqs[fr->sampling_frequency]<<(fr->lsf);
          framesize = framesize + fr->padding - 4;

        break; 
      default:
        //fprintf(stderr,"Sorry, unknown layer type.\n"); 
        return (0);
    }
  }
  else
    fr->header_change = 0;

  fsizeold=fsize;	/* for Layer3 */
  bsbufold = bsbuf;	
  bsbuf = bsspace[bsnum]+512;//(unsigned char*)mp3buf;//  
  bsnum = (bsnum + 1) & 1;

  fsize = framesize;
 
  
/*
int l;  
  if( (l=fread(bsbuf,1,fsize,filept)) != fsize)
  {
    if(l <= 0)
      return 0;
    memset(bsbuf+l,0,fsize-l);
  }
  */
  memcpy(bsbuf,mp3buf,fsize);
  mp3buf+=fsize;
  

  bitindex = 0;
  wordpointer = (unsigned char *) bsbuf;

  if (fr->error_protection) 
			{
				sackbits(16); /* crc */
			}

  return 1;
}

__inline void sackbits(int n)
{
	bitindex += n;    
    wordpointer += (bitindex>>3);
    bitindex &= 7;
}

__inline unsigned int getbits(int number_of_bits)
{
	_asm
	{		
		mov eax,number_of_bits		
		mov ebx,wordpointer		; ebx=pointer
		or eax,eax		
		mov esi,eax
		jz noway				
		mov ecx,bitindex		; ecx=bitindex
		mov eax,[ebx]		
		bswap eax
		mov edx,ecx				; edx=bitindex
		shl eax,cl				; rval<<=bitindex
		mov ecx,esi	; ecx=numbits		
		add edx,ecx				; edx=numbits+bitindex
		sub ecx,32				
		mov ebx,edx				; ebx=numbits+bitindex
		neg ecx					; ecx=16-numbits		
		shr eax,cl				; rval>>=16-numbits
		shr ebx,3
		and edx,7
		add wordpointer,ebx		
		mov bitindex,edx
noway:
	}
}

__inline unsigned int getbits_fast(int number_of_bits)
{
	_asm
	{		
		mov ebx,wordpointer		; ebx=pointer
		mov ecx,bitindex		; ecx=bitindex
		mov ah,[ebx]		
		mov al,[ebx+1]
		mov edx,ecx				; edx=bitindex
		shl eax,cl				; rval<<=bitindex
		mov ecx,number_of_bits	; ecx=numbits
		and eax,65535
		add edx,ecx				; edx=numbits+bitindex
		sub ecx,16				
		mov ebx,edx				; ebx=numbits+bitindex
		neg ecx					; ecx=16-numbits		
		shr eax,cl				; rval>>=16-numbits
		shr ebx,3
		and edx,7
		add wordpointer,ebx		
		mov bitindex,edx
	}
}



__inline unsigned int get1bitfast() 
{
	unsigned char i=(wordpointer[0]<<(bitindex++));
	wordpointer+=(bitindex>>3);bitindex&=7;
	return i&128;
}

__inline unsigned int get1bit() 
{
	unsigned char i=(wordpointer[0]<<(bitindex++));
	wordpointer+=(bitindex>>3);bitindex&=7;
	return i>>7;
}



void set_pointer(long backstep)
{
  wordpointer = bsbuf + ssize - backstep;
  if (backstep)
    memcpy(wordpointer,bsbufold+fsizeold-backstep,backstep);
  bitindex = 0; 
}

///////////////////////////////////////////////////////////////////////
// tabinit

real decwin[512+32];
static real cos64[16],cos32[8],cos16[4],cos8[2],cos4[1];
real *pnts[] = { cos64,cos32,cos16,cos8,cos4 };

static unsigned char conv16to8_buf[4096];
unsigned char *conv16to8 = conv16to8_buf + 2048;

static long intwinbase[] = {
     0,    -1,    -1,    -1,    -1,    -1,    -1,    -2,    -2,    -2,
    -2,    -3,    -3,    -4,    -4,    -5,    -5,    -6,    -7,    -7,
    -8,    -9,   -10,   -11,   -13,   -14,   -16,   -17,   -19,   -21,
   -24,   -26,   -29,   -31,   -35,   -38,   -41,   -45,   -49,   -53,
   -58,   -63,   -68,   -73,   -79,   -85,   -91,   -97,  -104,  -111,
  -117,  -125,  -132,  -139,  -147,  -154,  -161,  -169,  -176,  -183,
  -190,  -196,  -202,  -208,  -213,  -218,  -222,  -225,  -227,  -228,
  -228,  -227,  -224,  -221,  -215,  -208,  -200,  -189,  -177,  -163,
  -146,  -127,  -106,   -83,   -57,   -29,     2,    36,    72,   111,
   153,   197,   244,   294,   347,   401,   459,   519,   581,   645,
   711,   779,   848,   919,   991,  1064,  1137,  1210,  1283,  1356,
  1428,  1498,  1567,  1634,  1698,  1759,  1817,  1870,  1919,  1962,
  2001,  2032,  2057,  2075,  2085,  2087,  2080,  2063,  2037,  2000,
  1952,  1893,  1822,  1739,  1644,  1535,  1414,  1280,  1131,   970,
   794,   605,   402,   185,   -45,  -288,  -545,  -814, -1095, -1388,
 -1692, -2006, -2330, -2663, -3004, -3351, -3705, -4063, -4425, -4788,
 -5153, -5517, -5879, -6237, -6589, -6935, -7271, -7597, -7910, -8209,
 -8491, -8755, -8998, -9219, -9416, -9585, -9727, -9838, -9916, -9959,
 -9966, -9935, -9863, -9750, -9592, -9389, -9139, -8840, -8492, -8092,
 -7640, -7134, -6574, -5959, -5288, -4561, -3776, -2935, -2037, -1082,
   -70,   998,  2122,  3300,  4533,  5818,  7154,  8540,  9975, 11455,
 12980, 14548, 16155, 17799, 19478, 21189, 22929, 24694, 26482, 28289,
 30112, 31947, 33791, 35640, 37489, 39336, 41176, 43006, 44821, 46617,
 48390, 50137, 51853, 53534, 55178, 56778, 58333, 59838, 61289, 62684,
 64019, 65290, 66494, 67629, 68692, 69679, 70590, 71420, 72169, 72835,
 73415, 73908, 74313, 74630, 74856, 74992, 75038 };

void make_decode_tables(long scaleval)
{
  int i,j,k,kr,divv;
  real *table,*costab;

  for(i=0;i<5;i++)
  {
    kr=0x10>>i; divv=0x40>>i;
    costab = pnts[i];
    for(k=0;k<kr;k++)
      costab[k] = 1.0 / (2.0 * cos(M_PI * ((double) k * 2.0 + 1.0) / (double) divv));
  }

  table = decwin;
  scaleval = -scaleval;
  for(i=0,j=0;i<256;i++,j++,table+=32)
  {
    if(table < decwin+512+16)
      table[16] = table[0] = (double) intwinbase[j] / 65536.0 * (double) scaleval;
    if(i % 32 == 31)
      table -= 1023;
    if(i % 64 == 63)
      scaleval = - scaleval;
  }

  for( /* i=256 */ ;i<512;i++,j--,table+=32)
  {
    if(table < decwin+512+16)
      table[16] = table[0] = (double) intwinbase[j] / 65536.0 * (double) scaleval;
    if(i % 32 == 31)
      table -= 1023;
    if(i % 64 == 63)
      scaleval = - scaleval;
  }
}


