// d3d main.h
#ifndef _D3DMAIN_H_
#define _D3DMAIN_H_

#include <dsound.h>
#include <ddraw.h>
#include <d3d.h>

#define TICKSPERSEC 32000

#include	<d3dtypes.h>

#define RELEASE(x) {if (x) x->Release();x=NULL;}
void DDError(HRESULT error, char *context);
#define DDCHECK(x,s) {HRESULT r=(x); if (r!=DD_OK) {TRACE("error:");TRACE(s);trace_d3d_error(r);DDError(r,s);return r;}}

#define OK 0

extern HWND gHWnd;
extern char gQuit;
extern char gKeyDown[256];
extern int avi;
extern int avifps;
extern int gTime;

struct	CVM
{
	int		mW,mH,mB;
	int		mFullscreen;	
	char	*mName;
	void	Set(int w, int h, int b, int mfs, char *mn) {mW=w;mH=h;mB=b;mFullscreen=mfs;mName=new char[strlen(mn)+1];strcpy(mName,mn);}
	CVM() {mName=NULL;}
	~CVM() {delete [] mName;}
};

struct	CSM
{
	int		mMixrate;
	int		mStereo;
	int		m16Bit;	
	char	*mName;
	int		mByterate;
	void	Set(int mr, int st, int b) {mMixrate=mr, mStereo=st;m16Bit=b;delete []mName;mName=new char[128];sprintf(mName,"%dkHz %d bit %s",mr/1000,(b+1)*8,st?"stereo":"mono");}
	CSM() {mName=NULL;}
	~CSM() {delete [] mName;}
};


struct CGN
{
	GUID	*mGuid;
	char	*mName;
	D3DDEVICEDESC *hald,*held;

	void	Set(GUID *g, char *mn,LPD3DDEVICEDESC haldesc , LPD3DDEVICEDESC heldesc) 
	{
		delete mGuid;mGuid=NULL;if (g) {mGuid=new GUID;memcpy(mGuid,g,sizeof(GUID));}
		delete[]mName;mName=new char[strlen(mn)+1];
		strcpy(mName,mn);
		delete hald;
		delete held;
		hald=new D3DDEVICEDESC;
		held=new D3DDEVICEDESC;
		if (haldesc) memcpy(hald,haldesc,sizeof(D3DDEVICEDESC));
		if (heldesc) memcpy(held,heldesc,sizeof(D3DDEVICEDESC));
	}
	CGN() {mName=NULL;mGuid=NULL;hald=held=NULL;}
	~CGN() {delete [] mName;/*delete mGuid;*/}
};

int						GetMusicPos();	// to be used by democode

struct CD3D
{
	int Init();
	int EnumDDD();
	int EnumSD();
	int EnumSM();
	int EnumD3DD();
	int EnumVM();

	int InitScreen();
	int CloseScreen();
	int SetRenderStates();

	int InitSound();
	int StartSound();
	int CloseSound();
	void PollSound();

	void Clear();
	void Flip();
	void Blit();	// internal
	int Lock();
	int Unlock();
	int DoTick(int flags);	// calls blit, windows messages, and optionally flip and clear

#define DT_FLIP		1
#define DT_CLEAR	2
#define DT_FLIPCLEAR 3

	LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam );


	// dialog box stuff
	static CD3D *mThat;
	static BOOL CALLBACK Setup1Stub(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp);
	BOOL CALLBACK Setup1Proc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp);

	// mode number info
	int					mNumDDDs;	
	int					mNumD3DDs;
	int					mNumVMs;

	int					mNumSDs;
	int					mNumSMs;

	CVM*				mVMList;
	CGN*				mDDDList;
	CGN*				mD3DDList;

	CSM*				mSMList;

	char				mDDDName[128];
	char				mD3DDName[128];
	char				mVMName[128];

	char				mSDName[128];
	char				mSMName[128];

	CVM*				mVM;

	// combo box handles

	HWND				mHSD;
	HWND				mHSM;
	HWND				mHDDD;
	HWND				mHD3DD;
	HWND				mHVM;
	HWND				mHAVI,mHFPS;
	
	// direct draw stuff

	LPDIRECTDRAW			mDD;
	IDirectDraw2*			mDD2;
	IDirect3D2*				mD3D2;
	IDirect3DDevice2*		mD3DD2;
	
	GUID*					mDDGuid;
	GUID*					mD3DGuid;	
	BOOL					mHardware;
	D3DDEVICEDESC			mD3DCaps;
	char*					mScreenMem;
	int						mPitch;
	static HRESULT WINAPI	VMEnum( LPDDSURFACEDESC desc , void* param );
	static BOOL	WINAPI	DDEnum( GUID* guid , LPSTR desc , LPSTR name , void* param );
	static BOOL	WINAPI 	DSDEnum( GUID* guid , LPSTR desc , LPSTR name , void* param );
	static HRESULT	WINAPI	D3DEnum( GUID* guid , LPSTR desc , LPSTR name , LPD3DDEVICEDESC haldesc , LPD3DDEVICEDESC heldesc ,void* param );
	int Supported(LPDDSURFACEDESC desc);
	int AddVidMode(LPDDSURFACEDESC desc, int fs=1, int forcew=0, int forceh=0 );
	int AddSM(int mr, int st, int b);
	

	IDirectDrawSurface*		mBackSurf;
	IDirectDrawSurface*		mFrontSurf;
	IDirectDrawSurface*		mZBuf;
	IDirectDrawSurface*		mWinSurf;	
	DDPIXELFORMAT			mPixelFormat;
	IDirectDrawClipper*		mClipper;
	IDirect3DViewport2*		mViewport;
	IDirect3DMaterial2*		mBlackMat;
	D3DMATERIALHANDLE		mHBlackMat;
	


	// direct sound stuff
	
	int						mSD;
	CSM*					mSM;
	int						mNoSound;
	int						mInPoll;
	WAVEFORMATEX pcmwf;
	int coop;

	void					GetSD();
	int						CheckSM(WAVEFORMATEX *pcmwf);
	void					CleanUpSound();
	//int						GetMusicPos();	// to be used by democode
	int						GetTime();		// do NOT use, use gTime directly
	void					FastForward(int t);	// use this to skip forward
	static DWORD WINAPI 	SoundThread( CD3D *cd3d ) 	;
	void					SoundWork();
	void					WriteSound(char *dest, int bytes);
	void					XWriteSound(char *dest, int bytes);
	volatile int			mKillThread;
	HANDLE					mThread;
	DWORD					mThreadID;
	DWORD					mThreadCommand;

	volatile bool			mPause;

	D3DDEVICEDESC *hald,*held;


// WINDOWS mm stuff

	
	HWAVEOUT audioHandler;
	LPWAVEHDR pwh;
	int writebuf,ahead,unpacked;
	static void CALLBACK audioProc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);
	
	CD3D();
	~CD3D();
};


extern CD3D *gD;

void DbgTrace(char *format, ...);

void drawbox(short *o, int pitch, int x1, int y1, int x2, int y2, short c);
void drawstr(char *str, char *o, int pitch=gD->mPitch, int bits=gD->mVM->mB);

#ifdef _DEBUG
#define DEBUG
#define TRACE DbgTrace
#else
#define TRACE 
#endif

#endif