// d3d main.cpp

#define WAV_BUFS (64)
#define WAV_BUFL (16384)

//#define POLLONTICK
#define THREADSOUND

#include "common.h"
#include <direct.h>
#include "mpeg.h"
#include "crtdbg.h"

CD3D *CD3D::mThat=NULL;
CD3D *gD=NULL;

char gQuit=0;
char gKeyDown[256];

int gTime=0;
int avi=0;
int avifps=25;
int alttime=0;
int fftarget;

////////////////////////////////////////////////////////////////////////////////////////
// enumeration procs

int CD3D::Supported(LPDDSURFACEDESC desc)
{
	// Ignore paletted modes
	if ( desc->ddpfPixelFormat.dwFlags & DDPF_PALETTEINDEXED8 ) return 0;
	int i=desc->ddpfPixelFormat.dwRGBBitCount;
	if (i!=16 && i!=15 && i!=24 && i!=32)  return 0;
	//if (i!=16 && i!=15)  return 0;
	return 1;
}

int CD3D::AddVidMode(LPDDSURFACEDESC desc, int fs, int forcew, int forceh)
{
	int i=desc->ddpfPixelFormat.dwRGBBitCount;
	if (!fs && forcew) desc->dwWidth=forcew;
	if (!fs && forceh) desc->dwHeight=forceh;

	char temps[64];
	sprintf(temps,"%d x %d %d bit %s",desc->dwWidth,desc->dwHeight,i,fs?"Full Screen":"Windowed");
	mVMList[mNumVMs].Set(desc->dwWidth,desc->dwHeight,i,fs,temps);
	i=ComboBox_AddString(mHVM,mVMList[mNumVMs].mName);
	ComboBox_SetItemData(mHVM,i,&mVMList[mNumVMs]);
	mNumVMs++;
	return 0;
}

HRESULT WINAPI	CD3D::VMEnum( LPDDSURFACEDESC desc , void* param )
{
	CD3D*	This = (CD3D*) param;	
	if (This->Supported(desc))  This->AddVidMode(desc);	
	return DDENUMRET_OK;
}


BOOL	WINAPI	CD3D::DDEnum( GUID* guid , LPSTR desc , LPSTR name , void* param )
{
	CD3D*	This = (CD3D*) param;
	This->mDDDList[This->mNumDDDs].Set(guid,name,NULL,NULL); 		
	int i=ComboBox_AddString(This->mHDDD,This->mDDDList[This->mNumDDDs].mName);
	ComboBox_SetItemData(This->mHDDD,i,&This->mDDDList[This->mNumDDDs]);
	This->mNumDDDs++;	
	return DDENUMRET_OK;
}

HRESULT	WINAPI	CD3D::D3DEnum( GUID* guid , LPSTR desc , LPSTR name , LPD3DDEVICEDESC haldesc , LPD3DDEVICEDESC heldesc ,void* param )
{
	CD3D*	This = (CD3D*) param;
	This->mD3DDList[This->mNumD3DDs].Set(guid,name,haldesc,heldesc); 		
	int i=ComboBox_AddString(This->mHD3DD,This->mD3DDList[This->mNumD3DDs].mName);
	ComboBox_SetItemData(This->mHD3DD,i,&This->mD3DDList[This->mNumD3DDs]);
	This->mNumD3DDs++;	
	return D3DENUMRET_OK;
}

	

////////////////////////////////////////////////////////////////////////////////////////
// video init

int CD3D::CheckSM(WAVEFORMATEX *pcmwf)
{
	
	return (waveOutOpen(NULL,mSD,pcmwf,NULL,NULL,WAVE_FORMAT_QUERY)==MMSYSERR_NOERROR);
}

int CD3D::AddSM(int mr, int st, int b)
{
	int ba=(st+1)*(b+1);
	WAVEFORMATEX pcmwf={WAVE_FORMAT_PCM,st+1,mr,mr*ba,ba,b?16:8,0};	
	TRACE("add sound mode %d %d %d ",mr,st,b);
	if (mNoSound || CheckSM(&pcmwf))
	{
		TRACE("ok\n");	
		mSMList[mNumSMs].Set(mr,st,b);
		int i=ComboBox_AddString(mHSM,mSMList[mNumSMs].mName);
		ComboBox_SetItemData(mHSM,i,&mSMList[mNumSMs]);
		mNumSMs++;	
		return 1;	
	}
	TRACE("failed!\n");
	return 0;
}

int CD3D::EnumSM()
{
	mNumSMs=0;
	delete [] mSMList;
	mSMList=new CSM[64];
	ComboBox_ResetContent(mHSM);
		
	if (mNoSound)
	{
		TRACE("no sound...\n");
		AddSM(MP3MIXRATE,0,1);
	}
	else 
	{
		
		if (MP3MIXRATE==32000)
		{
			AddSM(32000,1,1);
			AddSM(32000,0,1);
			AddSM(22050,1,1);
			AddSM(22050,0,1);
			AddSM(16000,1,1);
			AddSM(16000,0,1);		
			AddSM(11025,1,1);					
			AddSM(11025,0,1);		
			AddSM( 8000,1,1);
			AddSM( 8000,0,1);		
		}
		else
		{
			AddSM(44100,1,1);
			AddSM(44100,0,1);
			AddSM(22050,1,1);
			AddSM(22050,0,1);
			AddSM(11025,1,1);					
			AddSM(11025,0,1);					
		}

		
	}

	if (ComboBox_SelectString(mHSM,-1,mSMName)==CB_ERR) ComboBox_SetCurSel(mHSM,0);
	int i=ComboBox_GetCurSel(mHSM);if (i<0) i=0;
	ComboBox_GetLBText(mHSM,i,mSMName);
	
	return 0;
}

int CD3D::EnumVM()
{
	mNumVMs=0;
	delete [] mVMList;
	mVMList=new CVM[64];
	ComboBox_ResetContent(mHVM);

	DDCHECK(mDD2->EnumDisplayModes( 0 , NULL , this , VMEnum ),"enumerate video modes");
	// add windowed modes if you are using the default display driver
	if (mDDGuid==NULL)
	{
		DDSURFACEDESC	desc;
		memset( &desc , 0 , sizeof(desc) );
		desc.dwSize = sizeof(desc);
		if (mDD2->GetDisplayMode( &desc ) == DD_OK  && Supported(&desc))		
		{				
				AddVidMode(&desc,0,320,240);
				AddVidMode(&desc,0,512,384);
				AddVidMode(&desc,0,640,480);
				AddVidMode(&desc,0,800,600);
				AddVidMode(&desc,0,1024,768);
		}
	}
	if (ComboBox_SelectString(mHVM,-1,mVMName)==CB_ERR) ComboBox_SetCurSel(mHVM,0);
	int i=ComboBox_GetCurSel(mHVM);if (i<0) i=0;
	ComboBox_GetLBText(mHVM,i,mVMName);

	return 0;
}

int CD3D::EnumD3DD()
{
	mNumD3DDs=0;
	delete [] mD3DDList;
	mD3DDList=new CGN[64];
	ComboBox_ResetContent(mHD3DD);
	
	DDCHECK(mD3D2->EnumDevices(D3DEnum,this), "enumerate d3d devices");	
	if (ComboBox_SelectString(mHD3DD,-1,mD3DDName)==CB_ERR) ComboBox_SetCurSel(mHD3DD,0);
	int i=ComboBox_GetCurSel(mHD3DD);if (i<0) i=0;
	ComboBox_GetLBText(mHD3DD,i,mD3DDName);

	DDCHECK(EnumVM(),"enumvm");
	return 0;
}



int CD3D::EnumDDD()
{
	mNumDDDs=0;
	delete [] mDDDList;
	mDDDList=new CGN[64];
	ComboBox_ResetContent(mHDDD);
	
	DDCHECK(DirectDrawEnumerate( DDEnum, this), "enumerate dd devices");
	if (ComboBox_SelectString(mHDDD,-1,mDDDName)==CB_ERR) ComboBox_SetCurSel(mHDDD,0);
	int i=ComboBox_GetCurSel(mHDDD);if (i<0) i=0;
	ComboBox_GetLBText(mHDDD,i,mDDDName);

	RELEASE(mDD);
	RELEASE(mDD2);
	RELEASE(mD3D2);	
	DDCHECK(DirectDrawCreate(mDDGuid=((CGN*)ComboBox_GetItemData(mHDDD,i))->mGuid, &mDD, NULL), "create dd");
	DDCHECK(mDD->QueryInterface(IID_IDirectDraw2, (void**) &mDD2), "query dd2");
	DDCHECK(mDD2->QueryInterface(IID_IDirect3D2, (void**) &mD3D2), "query d3d2");

	DDCHECK(EnumD3DD(),"enumd3d");
	return 0;
}

void CD3D::GetSD()
{
	if (avi) {mNoSound=1;return;}
	mNoSound=0;	
	mSD=ComboBox_GetItemData(mHSD,ComboBox_GetCurSel(mHSD));
	if (mSD==-2) mSD=WAVE_MAPPER; else if (mSD<0) mNoSound=1;
}

int CD3D::EnumSD()
{
	mNumSDs=0;
	ComboBox_ResetContent(mHSD);
	
	int i=ComboBox_AddString(mHSD,"No Sound");
	ComboBox_SetItemData(mHSD,i,-1);
	i=ComboBox_AddString(mHSD,"Wave Mapper");
	ComboBox_SetItemData(mHSD,i,-2);
	
	mNumSDs=waveOutGetNumDevs();

	
	for (i=0;i<mNumSDs;i++)
	{
		WAVEOUTCAPS woc;
		waveOutGetDevCaps(i,&woc,sizeof(woc));
		int j=ComboBox_AddString(mHSD,woc.szPname);
		ComboBox_SetItemData(mHSD,j,i);

	}
	
	if (ComboBox_SelectString(mHSD,-1,mSDName)==CB_ERR) ComboBox_SetCurSel(mHSD,0);
	GetSD();

	DDCHECK(EnumSM(),"enumsm");
	return 0;
}

HANDLE debugf;
	
	
int	CD3D::Init()
{
	mThat=this;
	gD=this;

	CRegistry *reg=new CRegistry("demo");
	reg->GetString("mDSDName",	mSDName,"Primary");
	reg->GetString("mSMName",	mSMName,"22kHz 16 bit stereo");
	reg->GetString("mDDDName",	mDDDName,"dd3dfx");
	reg->GetString("mD3DDName",	mD3DDName,"Direct3D HAL");
	reg->GetString("mVMName",	mVMName,"640 x 480 16");

	
	
	
	if (!DialogBox(gInst, MAKEINTRESOURCE(IDD_SETUP1), NULL, (DLGPROC)Setup1Stub)) 
	{
		delete reg;
		return -1;
	}
	
	

	reg->SetString("mDSDName",	mSDName);
	reg->SetString("mSMName",	mSMName);
	reg->SetString("mDDDName",	mDDDName);
	reg->SetString("mD3DDName",	mD3DDName);
	reg->SetString("mVMName",	mVMName);

	delete reg;
	return 0;
}



CD3D::CD3D()
{
#ifdef _DEBUG

	/*
	HANDLE f=CreateFile("log.txt",GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);	
	_CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_WARN, f);		//_CRTDBG_FILE_STDOUT
	_CrtSetReportMode(_CRT_ERROR, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_ERROR, f);
	_CrtSetReportMode(_CRT_ASSERT, _CRTDBG_MODE_FILE);
    _CrtSetReportFile(_CRT_ASSERT, f);	
	debugf=f;
	*/
#endif


	mDD=NULL;
	mDD2=NULL;
	mD3D2=NULL;
	mD3DD2=NULL;	
	
	mSMList=NULL;
	mDDDList=NULL;
	mD3DDList=NULL;
	mVMList=NULL;
	mNumDDDs=0;
	mNumVMs=0;
	mNumD3DDs=0;
	mNumSDs=0;
	mNumSMs=0;
	mNoSound=0;
	alttime=0;

	mPause=FALSE;

	mKillThread=0;
	mThread=NULL;
	mThreadCommand=0;
	mThreadID=0;

	mVM=NULL;
	mSM=NULL;
	mDDGuid=mD3DGuid=NULL;
	mScreenMem=NULL;
	mBackSurf=mFrontSurf=mZBuf=mWinSurf=NULL;
	mClipper=NULL;
	mBlackMat=NULL;
	mViewport=NULL;

	sprintf(mSDName,"");
	sprintf(mSMName,"");					
	sprintf(mDDDName,"");
	sprintf(mD3DDName,"");
	sprintf(mVMName,"");
}

CD3D::~CD3D()
{
	//CloseHandle(debugf);

	CloseScreen();
	CloseSound();

	delete [] mVMList;
	delete [] mDDDList;
	delete [] mD3DDList;
	delete [] mSMList;
	delete mVM;
	delete mSM;
	
	RELEASE(mD3DD2);
	RELEASE(mD3D2);
	
	RELEASE(mDD2);
	RELEASE(mDD);	
}

////////////////////////////////////////////////////////////////////////////////////////
// start up and close sound mode

int GetMusicPos()
{

	//-(WAV_BUFS*WAV_BUFL)/float(4*gD->mSM->mMixrate)*TICKSPERSEC
	// oh fuck here we go.
	// the music starts at 13.8 - 2.22 = 10.11 (10.44 seconds) at bar 7!!!
//#define MUSSTART 10.44f
#define MUSSTART 10.44


	float t=(gTime/float(TICKSPERSEC))-MUSSTART;

	if (t<((31-7)*4*60/108.f))
	{
		t=t/60*108 + 7*4;
	}
	else
	{
		t= (t-(31-7)*4*60/108.f) /60*100 + 31*4;
	}

	/*


	float b1=((gTime-(MUSSTART*TICKSPERSEC))/float(TICKSPERSEC*60))*108+ 7*4;
	// b1 is number of beats since the start of the music
	// adjust for bpm change at bar 31
	if (b1>31*4) 
	{
		b1=((gTime-(MUSSTART2*TICKSPERSEC))/float(TICKSPERSEC*60))*100+ 31*4;
	}
		//b1=31*4+ (b1-31*4)* (100.f/108.f);
	return b1*SPEED;
	*/
	return t*SPEED;
}

extern int firsttime;
int firsttime=-1;

int CD3D::GetTime()
{
	// use GetTickCount for nosound....?
	__int64 time;
	if (avi)
	{
		time=gTime;
	}
	else
	if (mNoSound || !alttime)
	{
		
		if (firsttime<0) firsttime=GetTickCount();
		time=GetTickCount()-firsttime;
		time=time*TICKSPERSEC/1000;
	}
	else
	{
		__int64 cb;
		MMTIME mmtime={TIME_BYTES};
		waveOutGetPosition(audioHandler,&mmtime,sizeof(mmtime));
		cb=unpacked-ahead*WAV_BUFL+(mmtime.u.cb%WAV_BUFL);
		// convert into milliseconds...
		time=cb*TICKSPERSEC/(mSM->mByterate);
	}
	if (time<gTime) time=gTime; else gTime=time;
	return gTime;
}

void CD3D::FastForward(int t)
{
	if (t<gTime) return;
	if (avi)
	{
		gTime=t;
	}
	else if (mNoSound)
	{
		firsttime=GetTickCount()-(((__int64)t)*1000/TICKSPERSEC);
		GetTime();
	}
	else
	{
		extern FILE *hackf;
		if (hackf)
		{
			fseek(hackf,4*int((44100.f*t)/TICKSPERSEC),SEEK_SET);
		}
		else
		{
			fftarget=t;
			mThreadCommand=3;
			while (((volatile)mThreadCommand)==3) ;
		}

		firsttime=GetTickCount()-((float(t)*1000.f)/TICKSPERSEC);
		GetTime();
	}
}


DWORD WINAPI CD3D::SoundThread( CD3D *cd3d ) 
{     

	if (cd3d) cd3d->SoundWork();
	return 0;
}


void CD3D::XWriteSound(char *dest, int bytes)
{
	static int c=0;
	POINT p;GetCursorPos(&p);
	while (bytes--) 
	{
		*dest++=rand()+c/4096;
		c+=p.x;
	}
}


void CD3D::SoundWork()
{		
	while ((volatile)(!mKillThread) || mThreadCommand)
	{
		//if (ahead<WAV_BUFS) 
		PollSound(); //
		//else 
			//Sleep(20);
		//if (!mPause) MessageBeep(0xFFFFFFFF);
	}	
	mKillThread=0;
	if (!mNoSound)
	{
		waveOutReset(audioHandler);
		int i;
		for(i=0;i<WAV_BUFS;i++)
			waveOutUnprepareHeader(audioHandler,pwh+i,sizeof(WAVEHDR));
		waveOutClose(audioHandler);
		GlobalFree(GlobalHandle(pwh));
	}
	TRACE("The death of the sound thread is NOW!\n");
}



void CD3D::PollSound()
{			
	if (mInPoll || mNoSound || avi) return;
	mInPoll=1;
	if (mThreadCommand==3)
	{
		// fast forward...
		waveOutPause(audioHandler);
		static char buf[8192];
		while (GetTime()<fftarget)
		{
			WriteSound((char*)buf,8192);
			unpacked+=8192;
		}
		waveOutRestart(audioHandler);
		mThreadCommand=0;
	}
	else
	if (mThreadCommand==1)
	{
		if (ahead==WAV_BUFS)
		{
			mThreadCommand=0;
			waveOutRestart(audioHandler);
		}
	}
	else if (mThreadCommand==2)
	{
		mThreadCommand=0;
		waveOutPause(audioHandler);
		mInPoll=0;
		return;
	}
	else
	{
		mThreadCommand=0;
	}

	if (ahead>=WAV_BUFS) {mInPoll=0;Sleep(20);return;}
	if (ahead<0) writebuf-=ahead-2;	// skip!!
	int i=(writebuf++)%WAV_BUFS;
	WriteSound((char*)pwh[i].lpData,WAV_BUFL);
	unpacked+=WAV_BUFL;
	ahead++;
	waveOutWrite(audioHandler,pwh+i,sizeof(WAVEHDR));
	//TRACE("%5d ahead, %d b\n",ahead,writebuf);

	mInPoll=0;
}

void CALLBACK CD3D::audioProc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2){
	if(uMsg==WOM_DONE) {
		((CD3D*)dwInstance)->ahead--;
		//TRACE("buffer free!\n");
	}
}




int CD3D::InitSound()
{
	unpacked=ahead=0;
	writebuf=0;
		
	mInPoll=0;
	if (avi)
	{
		mNoSound=0;
		mSM->mMixrate=MP3MIXRATE;
		mSM->mStereo=MP3CHANS-1;
		mSM->m16Bit=1;
		mSM->mByterate=MP3MIXRATE*2*MP3CHANS;
	}
	else
	if (mNoSound)
	{
		
	}
	else
	{
		// recreate buffer from scratch (just in case)

		int i;
		char *pwd;
		WAVEFORMATEX outFormatex;

		outFormatex.wFormatTag=WAVE_FORMAT_PCM;
		outFormatex.nChannels=(mSM->mStereo ? 2 : 1);
		outFormatex.nSamplesPerSec=mSM->mMixrate;
		outFormatex.nAvgBytesPerSec=mSM->mMixrate*(mSM->mStereo ? 2 : 1)*16/8;
		outFormatex.nBlockAlign=(mSM->mStereo ? 2 : 1)*16/8;
		outFormatex.wBitsPerSample=16;

		waveOutOpen(&audioHandler, mSD, &outFormatex, (DWORD)audioProc, (DWORD)this, CALLBACK_FUNCTION);

		pwh=(LPWAVEHDR)GlobalLock(GlobalAlloc(GPTR, sizeof(WAVEHDR)*WAV_BUFS+WAV_BUFL*WAV_BUFS));
		for(i=0;i<WAV_BUFS;i++) {
			pwd=((char*)(pwh))+sizeof(WAVEHDR)*WAV_BUFS+i*WAV_BUFL;
			pwh[i].lpData=pwd;
			pwh[i].dwBufferLength=WAV_BUFL;
			waveOutPrepareHeader(audioHandler,pwh+i,sizeof(WAVEHDR));
		}

		
		waveOutPause(audioHandler);
		mSM->mByterate=outFormatex.nAvgBytesPerSec;
	}
	GetTime();	// start off the timer...
	return OK;
}

int CD3D::StartSound()
{
	if (avi)
	{

	}
	else
	if (!mNoSound)
	{
		TRACE("start sound\n");
		// start sound thread
		mThreadCommand=0;
#ifdef THREADSOUND
		mThread=CreateThread(NULL,0,(unsigned long (__stdcall *)(void*))SoundThread,this,0,&mThreadID);
		DDCHECK((mThread==0),"create thread");				
		SetThreadPriority(mThread,THREAD_PRIORITY_ABOVE_NORMAL);
#endif		
		// start sound
		mThreadCommand=0;				
		PollSound();PollSound();		
		mThreadCommand=1;
		PollSound();
	}
	return OK;
}


int CD3D::CloseSound()
{
	
	if (mNoSound)
	{

	}
	else
	{
		
		mThreadCommand=2;		
		
	}

	if (mThread)
	{
		mKillThread=1;
		while ((volatile)mKillThread);
		//CloseHandle(mThread);	
		mThread=0;
	}

	if (avi)
	{
	}
	
	CleanUpSound();
	return OK;
}

////////////////////////////////////////////////////////////////////////////////////////
// start up and close video mode


int CD3D::InitScreen()
{
	if (avi)
	{
		
		static char buf[_MAX_PATH];
		_getcwd( buf,_MAX_PATH);
		
		static char fname[1024]="";
		OPENFILENAME of={sizeof(of),gHWnd,NULL,"AVI Files\0*.AVI\0\0\0",
						NULL,0,0,fname,1024,NULL,0,NULL,
						"Select AVI file to write to",
						OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,
						0,0,"AVI",NULL,NULL,NULL};
		if (!GetSaveFileName(&of)) return -1;
		initavi(mVM->mW,mVM->mH,avifps,fname);
		_chdir(buf);
	}

	RELEASE(mDD);
	RELEASE(mDD2);
	RELEASE(mD3D2);		
	DDCHECK(DirectDrawCreate(mDDGuid, &mDD, NULL), "create dd");
	DDCHECK(mDD->QueryInterface(IID_IDirectDraw2, (void**) &mDD2), "query dd2");
	DDCHECK(mDD2->QueryInterface(IID_IDirect3D2, (void**) &mD3D2), "query d3d2");

	// Get caps of D3D device
	/*
	static D3DFINDDEVICESEARCH D3DFDS;
	memset( &D3DFDS , 0 , sizeof(D3DFDS) );
	D3DFDS.dwSize = sizeof(D3DFDS);
	D3DFDS.dwFlags = D3DFDS_GUID;
	if (mD3DGuid) memcpy(&D3DFDS.guid , mD3DGuid, sizeof(GUID));
	static D3DFINDDEVICERESULT D3DFDR;
	memset( &D3DFDR , 0 , sizeof(D3DFDR) );
	D3DFDR.dwSize = sizeof(D3DFDR);
	DDCHECK(mD3D2->FindDevice( &D3DFDS , &D3DFDR ), "Find d3d device");
	//mD3D2->FindDevice( &D3DFDS , &D3DFDR );
	*/

	//mHardware=D3DFDR.ddHwDesc.dcmColorModel != 0);
	//mD3DCaps = mHardware ? D3DFDR.ddHwDesc : D3DFDR.ddSwDesc;

	mHardware=hald->dcmColorModel != 0;
	memcpy(&mD3DCaps, mHardware ? hald : held,sizeof(mD3DCaps));

	DDCHECK(( !mD3DCaps.dwDeviceZBufferBitDepth ), "Z buffer check");
	// init window and change video mode	
	if (mVM->mFullscreen)  ShowWindow(gHWnd,SW_MAXIMIZE|SW_SHOW); else ShowWindow(gHWnd,SW_SHOW);
	CloseScreen();
	
	// coop level
	DDSURFACEDESC		desc;
	desc.dwSize = sizeof(desc);
	if ( mVM->mFullscreen )
	{
		DDCHECK(mDD2->SetCooperativeLevel(gHWnd,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN ),"set coop level1");
		DDCHECK(mDD2->SetDisplayMode(mVM->mW,mVM->mH,mVM->mB, 0, 0),"set video mode");
		DDCHECK(mDD2->SetCooperativeLevel(gHWnd,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN ),"set coop level2");
	}
	else
	{
		DDCHECK(mDD2->SetCooperativeLevel(gHWnd,DDSCL_NORMAL ),"set coop level1");
		DDCHECK(mDD2->CreateClipper(0,&mClipper,NULL),"create clipper");
		DDCHECK(mClipper->SetHWnd(0,gHWnd),"set clipper");
		DDCHECK(mDD2->SetCooperativeLevel(gHWnd,DDSCL_NORMAL ),"set coop level2");
	}
	// surfaces
	if ( mVM->mFullscreen )	// front and back attached to front
	{
		desc.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		desc.dwBackBufferCount = 1;
		desc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_PRIMARYSURFACE | DDSCAPS_COMPLEX | DDSCAPS_FLIP | DDSCAPS_VIDEOMEMORY;
		DDCHECK(mDD2->CreateSurface( &desc , &mFrontSurf , NULL ) ,"create front");
		desc.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
		DDCHECK(mFrontSurf->GetAttachedSurface( &desc.ddsCaps , &mBackSurf ),"get back");
	}
	else	// window surface and back surface
	{
		desc.dwFlags = DDSD_CAPS;
		desc.ddsCaps.dwCaps= DDSCAPS_PRIMARYSURFACE;
		DDCHECK(mDD2->CreateSurface( &desc , &mWinSurf , NULL ) ,"create front");
		memset( &desc , 0 , sizeof(desc) );
		desc.dwSize = sizeof(desc);
		desc.dwWidth = mVM->mW;
		desc.dwHeight = mVM->mH;
		desc.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT ;
		desc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE;// | DDSCAPS_SYSTEMMEMORY ;
		DDCHECK(mDD2->CreateSurface( &desc , &mBackSurf , NULL ) ,"create back");
		mFrontSurf=mWinSurf;
	}
	// Get pixel format of back surface
	memset( &desc , 0 , sizeof(DDSURFACEDESC) );
	desc.dwSize = sizeof(DDSURFACEDESC);
	DDCHECK(mBackSurf->GetSurfaceDesc(&desc),"Get back surface pixformat");
	mPixelFormat = desc.ddpfPixelFormat;
	// z buffer
    memset(&desc , 0 , sizeof(desc) );
    desc.dwSize = sizeof(desc);
    desc.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS | DDSD_ZBUFFERBITDEPTH;
    desc.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
    desc.dwWidth = mVM->mW;
    desc.dwHeight = mVM->mH;
	desc.ddsCaps.dwCaps |= mHardware ? DDSCAPS_VIDEOMEMORY : DDSCAPS_SYSTEMMEMORY;
    int	zd = mD3DCaps.dwDeviceZBufferBitDepth;
    if ( zd & DDBD_32) desc.dwZBufferBitDepth = 32;
    else if ( zd & DDBD_24) desc.dwZBufferBitDepth = 24;
    else if ( zd & DDBD_16) desc.dwZBufferBitDepth = 16;
    else if ( zd & DDBD_8)  desc.dwZBufferBitDepth = 8;
	else return 1;
    DDCHECK(mDD2->CreateSurface(&desc, &mZBuf, NULL), "create zbuf");
	DDCHECK(mBackSurf->AddAttachedSurface(mZBuf),"attach zbuf");
	// set window size
	RECT rc = { 0 , 0 , mVM->mW , mVM->mH };if (mVM->mFullscreen) rc.right=rc.bottom=10;
	AdjustWindowRectEx( &rc , GetWindowLong( gHWnd , GWL_STYLE ),0,GetWindowLong( gHWnd , GWL_EXSTYLE ) );		
	SetWindowPos( gHWnd , NULL , 0 , 0 , rc.right-rc.left,rc.bottom-rc.top ,  SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
	if (mVM->mFullscreen) ShowWindow(gHWnd,SW_MAXIMIZE);
	// Create D3D device and background and viewport
	DDCHECK(mD3D2->CreateDevice(*mD3DGuid, mBackSurf,&mD3DD2),"Create d3d device");
	DDCHECK(mD3D2->CreateMaterial(&mBlackMat,NULL),"create black");
	D3DMATERIAL blackmat;
	memset( &blackmat , 0, sizeof(D3DMATERIAL));
    blackmat.dwSize = sizeof(D3DMATERIAL);
    blackmat.diffuse.a = (D3DVALUE)1.0;
	DDCHECK(mBlackMat->SetMaterial(&blackmat),"Setup black");
	DDCHECK(mBlackMat->GetHandle( mD3DD2 , &mHBlackMat ),"get material handle");
	DDCHECK(mD3D2->CreateViewport(&mViewport,NULL),"create viewport");
	DDCHECK(mD3DD2->AddViewport(mViewport),"add viewport");
	// Setup viewport (clip to whole screen)
	D3DVIEWPORT2 vp_desc;
	memset(&vp_desc, 0 , sizeof(vp_desc));
	vp_desc.dwSize = sizeof(vp_desc);
    vp_desc.dwX = 0; vp_desc.dwY = 0;
    vp_desc.dwWidth = mVM->mW; vp_desc.dwHeight = mVM->mH;
	vp_desc.dvClipX = 0.0f;	vp_desc.dvClipY = 0.0f;
	vp_desc.dvClipWidth = float(mVM->mW);vp_desc.dvClipHeight = float(mVM->mH);
	vp_desc.dvMinZ = 0.0f;vp_desc.dvMaxZ = 1.0f;
	DDCHECK(mViewport->SetViewport2(&vp_desc),"set viewport");
	DDCHECK(mD3DD2->SetCurrentViewport(mViewport),"set current viewport");
	DDCHECK(mViewport->SetBackground(mHBlackMat),"set viewport background");
	// set render states
	DDCHECK(SetRenderStates(),"set default render states");
	// the end! phew! updatet the window and hide the mouse
	UpdateWindow(gHWnd);
	if (mVM->mFullscreen)
	{
		SetCapture(gHWnd);
		SetCursor(NULL);
		//ShowWindow(gHWnd,SW_HIDE);	
	}

	Clear();
	return FALSE;
}

int CD3D::CloseScreen()
{
	
	if (mZBuf)
	{
		mBackSurf->DeleteAttachedSurface(NULL,mZBuf);
		RELEASE(mZBuf);
	}
	RELEASE(mBlackMat);
	RELEASE(mViewport);
	if (mClipper && mFrontSurf) mFrontSurf->SetClipper(NULL);
	RELEASE(mD3DD2);
	if (mVM && !mVM->mFullscreen) RELEASE(mBackSurf);	
	RELEASE(mFrontSurf);
	RELEASE(mClipper);
	mZBuf=mBackSurf=mFrontSurf=mWinSurf=NULL;
	if (mDD2) 
	{
		mDD2->SetCooperativeLevel( 0 , DDSCL_NORMAL );
		mDD2->RestoreDisplayMode();
	}
	return 0;
}

int CD3D::SetRenderStates()
{	
	if (!mD3DD2) return 1;
	mD3DD2->SetRenderState( D3DRENDERSTATE_ANTIALIAS , D3DANTIALIAS_NONE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESS , D3DTADDRESS_WRAP );
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREPERSPECTIVE , TRUE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_WRAPU , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_WRAPV , FALSE );	
	mD3DD2->SetRenderState( D3DRENDERSTATE_CULLMODE, D3DCULL_CCW );		// cw
	mD3DD2->SetRenderState( D3DRENDERSTATE_FILLMODE , D3DFILL_SOLID );
	mD3DD2->SetRenderState( D3DRENDERSTATE_SHADEMODE , D3DSHADE_GOURAUD );
	mD3DD2->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE , TRUE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_LASTPIXEL , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREMAG , D3DFILTER_LINEAR );
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREMIN , D3DFILTER_NEAREST );
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREMAPBLEND , D3DTBLEND_MODULATE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_ZFUNC , D3DCMP_LESSEQUAL );
	mD3DD2->SetRenderState( D3DRENDERSTATE_DITHERENABLE , TRUE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_FOGENABLE , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_SPECULARENABLE , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_SUBPIXEL , TRUE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_EDGEANTIALIAS , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_COLORKEYENABLE , FALSE );
	mD3DD2->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE , FALSE );	
	mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREHANDLE , NULL );
	mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );	
	mD3DD2->SetLightState( D3DLIGHTSTATE_MATERIAL , mHBlackMat );
	return 0;
}


////////////////////////////////////////////////////////////////////////////////////////
// setup dialog boxes

BOOL CALLBACK DialogStub(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg)
	{
	case WM_INITDIALOG:
		return false;
		break;
	case WM_COMMAND:		
		switch (LOWORD(wp))
		{		
	
		case IDCANCEL:
				EndDialog(hwnd, false);
				return true;
		case IDOK:
				EndDialog(hwnd, true);
				return true;			
		}
		break;
	}
	return false;
}

BOOL CALLBACK CD3D::Setup1Stub(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{
	return mThat->Setup1Proc(hwnd,msg,wp,lp);
}

BOOL CALLBACK CD3D::Setup1Proc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{		
	switch (msg)
	{
	case WM_INITDIALOG:
		{
			mHDDD=GetDlgItem(hwnd,IDC_GFXDEV);
			mHD3DD=GetDlgItem(hwnd,IDC_3DDEV);
			mHVM=GetDlgItem(hwnd,IDC_VIDMODE);
			mHSM=GetDlgItem(hwnd,IDC_SNDMODE);
			mHSD=GetDlgItem(hwnd,IDC_SNDDEV);			
			mHAVI=GetDlgItem(hwnd,IDC_AVI);
			mHFPS=GetDlgItem(hwnd,IDC_FPS);

			SetDlgItemInt(hwnd,IDC_FPS,avifps,0);
			CheckDlgButton(hwnd,IDC_AVI,avi?BST_CHECKED:BST_UNCHECKED);
			CheckDlgButton(hwnd,IDC_ALT,alttime?BST_CHECKED:BST_UNCHECKED);

			if (EnumDDD()) 
			{
				EndDialog(hwnd, false);
				return true;		
			}
			if (EnumSD()) 
			{
				EndDialog(hwnd, false);
				return true;		
			}
			return false;
		}
		break;
	case WM_COMMAND:		
		switch (LOWORD(wp))
		{		
		case IDC_ABOUT:
			DialogBox(gInst, MAKEINTRESOURCE(IDD_ABOUT), hwnd, (DLGPROC)DialogStub);
			break;
		case IDC_README:
			DialogBox(gInst, MAKEINTRESOURCE(IDD_README), hwnd, (DLGPROC)DialogStub);
			break;
		case IDC_GFXDEV:
			if (HIWORD(wp)==CBN_SELCHANGE) 
			{				
				ComboBox_GetLBText(mHDDD,ComboBox_GetCurSel(mHDDD),mDDDName);
				//sprintf(mD3DDName,"Direct3D HAL");
				//sprintf(mVMName,"640 x 480 16");
				if (EnumDDD()) 
				{
					EndDialog(hwnd, false);
					return true;
				}
			}
			break;	
		case IDC_SNDDEV:
			if (HIWORD(wp)==CBN_SELCHANGE) 
			{				
				ComboBox_GetLBText(mHSD,ComboBox_GetCurSel(mHSD),mSDName);
				//sprintf(mSMName,"22kHz 16 bit stereo");				
				if (EnumSD()) 
				{
					EndDialog(hwnd, false);
					return true;
				}
			}
			break;	
		case IDOK:
			{
				avi=(IsDlgButtonChecked(hwnd,IDC_AVI)==BST_CHECKED)?1:0;
				alttime=(IsDlgButtonChecked(hwnd,IDC_ALT)==BST_CHECKED)?1:0;
				BOOL fpsok;
				int out=GetDlgItemInt(hwnd,IDC_FPS,&fpsok,0);
				if (fpsok) avifps=out;
				if (avifps<1) avifps=1;
				if (avifps>80) avifps=80;

				ComboBox_GetLBText(mHD3DD,ComboBox_GetCurSel(mHD3DD),mD3DDName);
				ComboBox_GetLBText(mHDDD,ComboBox_GetCurSel(mHDDD),mDDDName);
				ComboBox_GetLBText(mHSD,ComboBox_GetCurSel(mHSD),mSDName);
				ComboBox_GetLBText(mHVM,ComboBox_GetCurSel(mHVM),mVMName);
				ComboBox_GetLBText(mHSM,ComboBox_GetCurSel(mHSM),mSMName);
				GetSD();
				
				mDDGuid=((CGN*)ComboBox_GetItemData(mHDDD,ComboBox_GetCurSel(mHDDD)))->mGuid;
				mD3DGuid=((CGN*)ComboBox_GetItemData(mHD3DD,ComboBox_GetCurSel(mHD3DD)))->mGuid;

				hald=((CGN*)ComboBox_GetItemData(mHD3DD,ComboBox_GetCurSel(mHD3DD)))->hald;
				held=((CGN*)ComboBox_GetItemData(mHD3DD,ComboBox_GetCurSel(mHD3DD)))->held;
								
				CVM *lVM=((CVM*)ComboBox_GetItemData(mHVM,ComboBox_GetCurSel(mHVM)));
				CSM *lSM=((CSM*)ComboBox_GetItemData(mHSM,ComboBox_GetCurSel(mHSM)));
				mVM=new CVM;mVM->Set(lVM->mW,lVM->mH,lVM->mB,lVM->mFullscreen,"Current Video Mode");
				mSM=new CSM;mSM->Set(lSM->mMixrate,lSM->mStereo,lSM->m16Bit);
				EndDialog(hwnd, true);
				return true;
			}
		case IDCANCEL:
			EndDialog(hwnd, false);
			return true;
		}
	}
	return false;
}

void	CD3D::Blit()
{
	if(!mBackSurf || !mFrontSurf) return;
	POINT tl={0,0};ClientToScreen(gHWnd,&tl);
	RECT rc;GetClientRect( gHWnd , &rc );
	RECT winrect={tl.x, tl.y,winrect.left + rc.right,winrect.top + rc.bottom};	
	int w=(winrect.right-winrect.left);
	int h=(winrect.bottom-winrect.top);
	if ( w && h )
	{		
		if ( mVM->mFullscreen ) ;//mFrontSurf->Flip( mBackSurf , DDFLIP_WAIT );
		else {	
			mFrontSurf->SetClipper( mClipper );
			RECT br = { 0 , 0 , w,h };
			HRESULT r=mFrontSurf->Blt( &winrect , mBackSurf , &br , 0 , 0 );
		}
	}
}

void	CD3D::Flip()
{
	if (mVM->mFullscreen) 
	{
		if (mFrontSurf->Flip( mBackSurf , 0 )!=DD_OK)
			trace_d3d_error(mFrontSurf->Flip( mBackSurf , DDFLIP_WAIT ));
	}
	else
	{
		if ( gHWnd != NULL && mVM->mFullscreen==0) InvalidateRect( gHWnd , NULL , FALSE );	
	}
}

void	CD3D::Clear()
{
	if ( mViewport )
	{
		D3DRECT	rect;
		rect.x1 = rect.y1 = 0;
		rect.x2 = mVM->mW;rect.y2 = mVM->mH;
		trace_d3d_error(mViewport->Clear( 1 , &rect , D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER ));			
	}
}

int	CD3D::Lock()
{
	static DDSURFACEDESC desc={sizeof(DDSURFACEDESC)};
	if (!mBackSurf) return FALSE;
	HRESULT r=mBackSurf->Lock(NULL,&desc,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
	if (r==DDERR_SURFACELOST)
	{
		mBackSurf->Restore();
		r=mBackSurf->Lock(NULL,&desc,DDLOCK_SURFACEMEMORYPTR|DDLOCK_WAIT,NULL);
	}
	if (r) return r;
	mScreenMem=(char*)desc.lpSurface;
	mPitch=desc.lPitch;
	if (mPitch==0 || mScreenMem==0) return -1;
	return DD_OK;
}

int CD3D::Unlock()
{
	return mBackSurf->Unlock(mScreenMem);
}


int CD3D::DoTick(int flags)
{
	int gt=gTime;
	if (avi)
	{
		int wid=mVM->mW;
		int hgt=mVM->mH;
		char *avibuf=new char[wid*hgt*3+32000];
		

		// unpack the next bit of audio and write it out...
		
		writeaviaudio(avibuf,this);
		
		// lock the surface and write it out to the avi file...
		if (!gD->Lock())
		{
			char *src=(char*)mScreenMem;
			int numbytes=(mPixelFormat.dwRGBBitCount+7)/8;
			int redsh=countzeros(mPixelFormat.dwRBitMask);
			int grnsh=countzeros(mPixelFormat.dwGBitMask);
			int blush=countzeros(mPixelFormat.dwBBitMask);
			int redsh2=8-countbits(mPixelFormat.dwRBitMask);
			int grnsh2=8-countbits(mPixelFormat.dwGBitMask);
			int blush2=8-countbits(mPixelFormat.dwBBitMask);
			char *dst=avibuf;
			for (int y=0;y<hgt;y++)
			{
				src=(char*)mScreenMem+(hgt-1-y)*mPitch;
				for (int x=0;x<wid;x++)
				{
					unsigned int i=*((unsigned int*)src);src+=numbytes;
					*dst++=((i>>blush)<<blush2);
					*dst++=((i>>grnsh)<<grnsh2);
					*dst++=((i>>redsh)<<redsh2);
				}
				
			}
			// print a message on the screen
			char str[256];
			sprintf(str,"Rendering to disk.\nWARNING! Not realtime!\n\nTime = %6.3fs",gTime/float(TICKSPERSEC));
			drawstr(str,mScreenMem+mPitch*(hgt/3),mPitch,numbytes*8);
			
			gD->Unlock();
			writeavivideo(avibuf);
		} else MessageBox(gHWnd,"Cannot lock the surface for reading!","error",MB_OK|MB_ICONSTOP);
		delete [] avibuf;
		// increment time
		gTime+=TICKSPERSEC/avifps;
	}
#ifdef POLLONTICK
	PollSound();
#endif

#ifdef DEBUG	
	if (!gD->Lock())
	{
		char ss[1024];											
		float m=GetMusicPos()/float(SPEED);
		sprintf(ss,"\n\npos: %3d:%d . %2d",int(m/4),1+(int(m)&3), int((m-int(m))*100.f));		
		drawstr(ss,gD->mScreenMem);
		gD->Unlock();
	}
#endif
	

	if (mFrontSurf->IsLost()) {TRACE("lost front!\n");mFrontSurf->Restore();}
	if (mBackSurf->IsLost()) {TRACE("lost back!\n");mBackSurf->Restore();	}
	if (mZBuf->IsLost()) {TRACE("lost zbuf!\n");mZBuf->Restore();}
	
	if (flags&DT_FLIP) Flip();	
	MSG msg;
	while ( PeekMessage( &msg , gHWnd , 0 , 0 , PM_REMOVE ) )
	{
		TranslateMessage( &msg ) ;
			DispatchMessage( &msg );
	}
	
	if (flags&DT_CLEAR) Clear();
	return GetTime()-gt;
}

LRESULT CALLBACK CD3D::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam )
{
    PAINTSTRUCT		ps;
	if ( hWnd != gHWnd ) return DefWindowProc( hWnd , message , wParam , lParam );
    switch( message )
	{		
		case WM_PAINT:            
            BeginPaint( hWnd , &ps );
			Blit();
            EndPaint( hWnd , &ps );
            return TRUE;		
		//case WM_QUIT:
		//case WM_CLOSE:
		case WM_DESTROY:
			ReleaseCapture();
			SetCursor(LoadCursor(NULL,IDC_ARROW));
			PostQuitMessage(0);			
			return TRUE;
		case WM_SETFOCUS:
			//mAppActive = TRUE;
			if (!avi)
			{
				mPause=FALSE;
				mThreadCommand=1;
			}
            break;
		case WM_KILLFOCUS:
			//mAppActive = FALSE;
			if (!avi)
			{
				mPause=TRUE;
				mThreadCommand=2;
			}
			break;
		case WM_KEYDOWN:
			if (wParam<256) gKeyDown[wParam]=1;
			break;
		case WM_KEYUP:
			if (wParam<256) gKeyDown[wParam]=0;
			break;
	}
    return DefWindowProc( hWnd , message , wParam , lParam );
}



////////////////////////////////////////////////////////////////////////////////////////
// debug

void DbgTrace(char *format, ...)
{
	
	char buf[1024];
	char *arg=(char*)&format+sizeof(format);
	vsprintf(buf,format,arg);
	_RPT0(_CRT_WARN,buf);
}


void drawbox(short *o, int pitch, int x1, int y1, int x2, int y2, short c)
{
	short *o2;
	int x,y;
	for (y=y1;y<y2;y++)
	{
		o2=o+x1+y*pitch;
		for (x=x1;x<x2;x++) *o2++=c;
	}
}

int coltab[4]={0,10+(20<<5)+(10<<11),20+(40<<5)+(20<<11),-1};

void drawstr(char *str, char *o, int pitch, int bits)
{
	return;
	bits/=8;
	int x,x2,y,m,m2,i;
	static int j=0;
	static char font[256][8];
	if (!j)
	{
		j=1;
		
		memset(font,0,256*8);
	}
	char *o2=o;
	while (*str)
	{
		if (*str==13 || *str==10)
		{	
			o2+=pitch*8;
			o=o2;
			str++;
			continue;
		}
		char *b=font[*str++];
		for (y=0;y<8;y++,b++)
		{
			m=*b;			
			for (x=0;x<8;x++,m<<=1,o+=bits) 
			{
				i=0;
				if (m&128) i++;
				if (i)
				{					
					for (x2=0;x2<bits;x2++) o[x2]=-1;				
				}
			}
			o+=pitch-bits*8;
		}
		o-=pitch*8-bits*8;
	}
}

