#include "common.h"
#include "d3derr.h"
//
// Traces the appropriate direct draw error.
//

#define FTRACE TRACE

void trace_dd_error(HRESULT dd_err)
{
	if (!dd_err) return;
	FTRACE("Direct Draw Error: ");

	switch(dd_err)
	{
		case	DDERR_ALREADYINITIALIZED:			FTRACE("DDERR_ALREADYINITIALIZED");break;
		case	DDERR_CANNOTATTACHSURFACE:			FTRACE("DDERR_CANNOTATTACHSURFACE");break;
		case	DDERR_CANNOTDETACHSURFACE:			FTRACE("DDERR_CANNOTDETACHSURFACE");break;
		case	DDERR_CURRENTLYNOTAVAIL:			FTRACE("DDERR_CURRENTLYNOTAVAIL");break;
		case	DDERR_EXCEPTION:					FTRACE("DDERR_EXCEPTION");break;
		case	DDERR_GENERIC:						FTRACE("DDERR_GENERIC");break;
		case	DDERR_HEIGHTALIGN:					FTRACE("DDERR_HEIGHTALIGN");break;
		case	DDERR_INCOMPATIBLEPRIMARY:			FTRACE("DDERR_INCOMPATIBLEPRIMARY");break;
		case	DDERR_INVALIDCAPS:					FTRACE("DDERR_INVALIDCAPS");break;
		case	DDERR_INVALIDCLIPLIST:				FTRACE("DDERR_INVALIDCLIPLIST");break;
		case	DDERR_INVALIDMODE:					FTRACE("DDERR_INVALIDMODE");break;
		case	DDERR_INVALIDOBJECT:				FTRACE("DDERR_INVALIDOBJECT");break;
		case	DDERR_INVALIDPARAMS:				FTRACE("DDERR_INVALIDPARAMS");break;
		case	DDERR_INVALIDPIXELFORMAT:			FTRACE("DDERR_INVALIDPIXELFORMAT");break;
		case	DDERR_INVALIDRECT:					FTRACE("DDERR_INVALIDRECT");break;
		case	DDERR_LOCKEDSURFACES:				FTRACE("DDERR_LOCKEDSURFACES");break;
		case	DDERR_NO3D:							FTRACE("DDERR_NO3D");break;
		case	DDERR_NOALPHAHW:					FTRACE("DDERR_NOALPHAHW");break;
		case	DDERR_NOCLIPLIST:					FTRACE("DDERR_NOCLIPLIST");break;
		case	DDERR_NOCOLORCONVHW:				FTRACE("DDERR_NOCOLORCONVHW");break;
		case	DDERR_NOCOOPERATIVELEVELSET:		FTRACE("DDERR_NOCOOPERATIVELEVELSET");break;
		case	DDERR_NOCOLORKEY:					FTRACE("DDERR_NOCOLORKEY");break;
		case	DDERR_NOCOLORKEYHW:					FTRACE("DDERR_NOCOLORKEYHW");break;
		case	DDERR_NODIRECTDRAWSUPPORT:			FTRACE("DDERR_NODIRECTDRAWSUPPORT");break;
		case	DDERR_NOEXCLUSIVEMODE:				FTRACE("DDERR_NOEXCLUSIVEMODE");break;
		case	DDERR_NOFLIPHW:						FTRACE("DDERR_NOFLIPHW");break;
		case	DDERR_NOGDI:						FTRACE("DDERR_NOGDI");break;
		case	DDERR_NOMIRRORHW:					FTRACE("DDERR_NOMIRRORHW");break;
		case	DDERR_NOTFOUND:						FTRACE("DDERR_NOTFOUND");break;
		case	DDERR_NOOVERLAYHW:					FTRACE("DDERR_NOOVERLAYHW");break;
		case	DDERR_NORASTEROPHW:					FTRACE("DDERR_NORASTEROPHW");break;
		case	DDERR_NOROTATIONHW:					FTRACE("DDERR_NOROTATIONHW");break;
		case	DDERR_NOSTRETCHHW:					FTRACE("DDERR_NOSTRETCHHW");break;
		case	DDERR_NOT4BITCOLOR:					FTRACE("DDERR_NOT4BITCOLOR");break;
		case	DDERR_NOT4BITCOLORINDEX:			FTRACE("DDERR_NOT4BITCOLORINDEX");break;
		case	DDERR_NOT8BITCOLOR:					FTRACE("DDERR_NOT8BITCOLOR");break;
		case	DDERR_NOTEXTUREHW:					FTRACE("DDERR_NOTEXTUREHW");break;
		case	DDERR_NOVSYNCHW:					FTRACE("DDERR_NOVSYNCHW");break;
		case	DDERR_NOZBUFFERHW:					FTRACE("DDERR_NOZBUFFERHW");break;
		case	DDERR_NOZOVERLAYHW:					FTRACE("DDERR_NOZOVERLAYHW");break;
		case	DDERR_OUTOFCAPS:					FTRACE("DDERR_OUTOFCAPS");break;
		case	DDERR_OUTOFMEMORY:					FTRACE("DDERR_OUTOFMEMORY");break;
		case	DDERR_OUTOFVIDEOMEMORY:				FTRACE("DDERR_OUTOFVIDEOMEMORY");break;
		case	DDERR_OVERLAYCANTCLIP:				FTRACE("DDERR_OVERLAYCANTCLIP");break;
		case	DDERR_OVERLAYCOLORKEYONLYONEACTIVE:	FTRACE("DDERR_OVERLAYCOLORKEYONLYONEACTIVE");break;
		case	DDERR_PALETTEBUSY:					FTRACE("DDERR_PALETTEBUSY");break;
		case	DDERR_COLORKEYNOTSET:				FTRACE("DDERR_COLORKEYNOTSET");break;
		case	DDERR_SURFACEALREADYATTACHED:		FTRACE("DDERR_SURFACEALREADYATTACHED");break;
		case	DDERR_SURFACEALREADYDEPENDENT:		FTRACE("DDERR_SURFACEALREADYDEPENDENT");break;
		case	DDERR_SURFACEBUSY:					FTRACE("DDERR_SURFACEBUSY");break;
		case	DDERR_CANTLOCKSURFACE:				FTRACE("DDERR_CANTLOCKSURFACE");break;
		case	DDERR_SURFACEISOBSCURED:			FTRACE("DDERR_SURFACEISOBSCURED");break;
		case	DDERR_SURFACELOST:					FTRACE("DDERR_SURFACELOST");break;
		case	DDERR_SURFACENOTATTACHED:			FTRACE("DDERR_SURFACENOTATTACHED");break;
		case	DDERR_TOOBIGHEIGHT:					FTRACE("DDERR_TOOBIGHEIGHT");break;
		case	DDERR_TOOBIGSIZE:					FTRACE("DDERR_TOOBIGSIZE");break;
		case	DDERR_TOOBIGWIDTH:					FTRACE("DDERR_TOOBIGWIDTH");break;
		case	DDERR_UNSUPPORTED:					FTRACE("DDERR_UNSUPPORTED");break;
		case	DDERR_UNSUPPORTEDFORMAT:			FTRACE("DDERR_UNSUPPORTEDFORMAT");break;
		case	DDERR_UNSUPPORTEDMASK:				FTRACE("DDERR_UNSUPPORTEDMASK");break;
		case	DDERR_VERTICALBLANKINPROGRESS:		FTRACE("DDERR_VERTICALBLANKINPROGRESS");break;
		case	DDERR_WASSTILLDRAWING:				FTRACE("DDERR_WASSTILLDRAWING");break;
		case	DDERR_XALIGN:						FTRACE("DDERR_XALIGN");break;
		case	DDERR_INVALIDDIRECTDRAWGUID:		FTRACE("DDERR_INVALIDDIRECTDRAWGUID");break;
		case	DDERR_DIRECTDRAWALREADYCREATED:		FTRACE("DDERR_DIRECTDRAWALREADYCREATED");break;
		case	DDERR_NODIRECTDRAWHW:				FTRACE("DDERR_NODIRECTDRAWHW");break;
		case	DDERR_PRIMARYSURFACEALREADYEXISTS:	FTRACE("DDERR_PRIMARYSURFACEALREADYEXISTS");break;
		case	DDERR_NOEMULATION:					FTRACE("DDERR_NOEMULATION");break;
		case	DDERR_REGIONTOOSMALL:				FTRACE("DDERR_REGIONTOOSMALL");break;
		case	DDERR_CLIPPERISUSINGHWND:			FTRACE("DDERR_CLIPPERISUSINGHWND");break;
		case	DDERR_NOCLIPPERATTACHED:			FTRACE("DDERR_NOCLIPPERATTACHED");break;
		case	DDERR_NOHWND:						FTRACE("DDERR_NOHWND");break;
		case	DDERR_HWNDSUBCLASSED:				FTRACE("DDERR_HWNDSUBCLASSED");break;
		case	DDERR_HWNDALREADYSET:				FTRACE("DDERR_HWNDALREADYSET");break;
		case	DDERR_NOPALETTEATTACHED:			FTRACE("DDERR_NOPALETTEATTACHED");break;
		case	DDERR_NOPALETTEHW:					FTRACE("DDERR_NOPALETTEHW");break;
		case	DDERR_BLTFASTCANTCLIP:				FTRACE("DDERR_BLTFASTCANTCLIP");break;
		case	DDERR_NOBLTHW:						FTRACE("DDERR_NOBLTHW");break;
		case	DDERR_NODDROPSHW:					FTRACE("DDERR_NODDROPSHW");break;
		case	DDERR_OVERLAYNOTVISIBLE:			FTRACE("DDERR_OVERLAYNOTVISIBLE");break;
		case	DDERR_NOOVERLAYDEST:				FTRACE("DDERR_NOOVERLAYDEST");break;
		case	DDERR_INVALIDPOSITION:				FTRACE("DDERR_INVALIDPOSITION");break;
		case	DDERR_NOTAOVERLAYSURFACE:			FTRACE("DDERR_NOTAOVERLAYSURFACE");break;
		case	DDERR_EXCLUSIVEMODEALREADYSET:		FTRACE("DDERR_EXCLUSIVEMODEALREADYSET");break;
		case	DDERR_NOTFLIPPABLE:					FTRACE("DDERR_NOTFLIPPABLE");break;
		case	DDERR_CANTDUPLICATE:				FTRACE("DDERR_CANTDUPLICATE");break;
		case	DDERR_NOTLOCKED:					FTRACE("DDERR_NOTLOCKED");break;
		case	DDERR_CANTCREATEDC:					FTRACE("DDERR_CANTCREATEDC");break;
		case	DDERR_NODC:							FTRACE("DDERR_NODC");break;
		case	DDERR_WRONGMODE:					FTRACE("DDERR_WRONGMODE");break;
		case	DDERR_IMPLICITLYCREATED:			FTRACE("DDERR_IMPLICITLYCREATED");break;
		case	DDERR_NOTPALETTIZED:				FTRACE("DDERR_NOTPALETTIZED");break;
		case	DDERR_UNSUPPORTEDMODE:				FTRACE("DDERR_UNSUPPORTEDMODE");break;
		case	DDERR_NOMIPMAPHW:					FTRACE("DDERR_NOMIPMAPHW");break;
		case	DDERR_INVALIDSURFACETYPE:			FTRACE("DDERR_INVALIDSURFACETYPE");break;
		case	DDERR_NOOPTIMIZEHW:					FTRACE("DDERR_NOOPTIMIZEHW");break;
		case	DDERR_NOTLOADED:					FTRACE("DDERR_NOTLOADED");break;
		case	DDERR_DCALREADYCREATED:				FTRACE("DDERR_DCALREADYCREATED");break;
		case	DDERR_NONONLOCALVIDMEM:				FTRACE("DDERR_NONONLOCALVIDMEM");break;
		case	DDERR_CANTPAGELOCK:					FTRACE("DDERR_CANTPAGELOCK");break;
		case	DDERR_CANTPAGEUNLOCK:				FTRACE("DDERR_CANTPAGEUNLOCK");break;
		case	DDERR_NOTPAGELOCKED:				FTRACE("DDERR_NOTPAGELOCKED");break;
		case	DDERR_MOREDATA:						FTRACE("DDERR_MOREDATA");break;
		case	DDERR_VIDEONOTACTIVE:				FTRACE("DDERR_VIDEONOTACTIVE");break;
		case	DDERR_DEVICEDOESNTOWNSURFACE:		FTRACE("DDERR_DEVICEDOESNTOWNSURFACE");break;
		case	DDERR_NOTINITIALIZED:				FTRACE("DDERR_NOTINITIALIZED");break;
		default:									FTRACE("Unknown - %ld",dd_err&0xffff);
	}

	FTRACE("\n");
}


//
// Traces the appropriate direct 3d error.
//

void trace_d3d_error(HRESULT dd_err)
{
	if (!dd_err) return;
	FTRACE("Direct Draw Error: ");

	if (dd_err) 
	{
		TRACE("oh:");
	}
	switch(dd_err)
	{
		case	D3DERR_BADMAJORVERSION:			FTRACE("D3DERR_BADMAJORVERSION");break;
		case	D3DERR_BADMINORVERSION:			FTRACE("D3DERR_BADMINORVERSION");break;
		case	D3DERR_INVALID_DEVICE:			FTRACE("D3DERR_INVALID_DEVICE");break;
		case	D3DERR_EXECUTE_CREATE_FAILED:	FTRACE("D3DERR_EXECUTE_CREATE_FAILED");break;
		case	D3DERR_EXECUTE_DESTROY_FAILED:	FTRACE("D3DERR_EXECUTE_DESTROY_FAILED");break;
		case	D3DERR_EXECUTE_LOCK_FAILED:		FTRACE("D3DERR_EXECUTE_LOCK_FAILED");break;
		case	D3DERR_EXECUTE_UNLOCK_FAILED:	FTRACE("D3DERR_EXECUTE_UNLOCK_FAILED");break;
		case	D3DERR_EXECUTE_LOCKED:			FTRACE("D3DERR_EXECUTE_LOCKED");break;
		case	D3DERR_EXECUTE_NOT_LOCKED:		FTRACE("D3DERR_EXECUTE_NOT_LOCKED");break;
		case	D3DERR_EXECUTE_FAILED:			FTRACE("D3DERR_EXECUTE_FAILED");break;
		case	D3DERR_EXECUTE_CLIPPED_FAILED:	FTRACE("D3DERR_EXECUTE_CLIPPED_FAILED");break;
		case	D3DERR_TEXTURE_NO_SUPPORT:		FTRACE("D3DERR_TEXTURE_NO_SUPPORT");break;
		case	D3DERR_TEXTURE_CREATE_FAILED:	FTRACE("D3DERR_TEXTURE_CREATE_FAILED");break;
		case	D3DERR_TEXTURE_DESTROY_FAILED:	FTRACE("D3DERR_TEXTURE_DESTROY_FAILED");break;
		case	D3DERR_TEXTURE_LOCK_FAILED:		FTRACE("D3DERR_TEXTURE_LOCK_FAILED");break;
		case	D3DERR_TEXTURE_UNLOCK_FAILED:	FTRACE("D3DERR_TEXTURE_UNLOCK_FAILED");break;
		case	D3DERR_TEXTURE_LOAD_FAILED:		FTRACE("D3DERR_TEXTURE_LOAD_FAILED");break;
		case	D3DERR_TEXTURE_SWAP_FAILED:		FTRACE("D3DERR_TEXTURE_SWAP_FAILED");break;
		case	D3DERR_TEXTURE_LOCKED:			FTRACE("D3DERR_TEXTURE_LOCKED");break;
		case	D3DERR_TEXTURE_NOT_LOCKED:		FTRACE("D3DERR_TEXTURE_NOT_LOCKED");break;
		case	D3DERR_TEXTURE_GETSURF_FAILED:	FTRACE("D3DERR_TEXTURE_GETSURF_FAILED");break;
		case	D3DERR_MATRIX_CREATE_FAILED:	FTRACE("D3DERR_MATRIX_CREATE_FAILED");break;
		case	D3DERR_MATRIX_DESTROY_FAILED:	FTRACE("D3DERR_MATRIX_DESTROY_FAILED");break;
		case	D3DERR_MATRIX_SETDATA_FAILED:	FTRACE("D3DERR_MATRIX_SETDATA_FAILED");break;
		case	D3DERR_MATRIX_GETDATA_FAILED:	FTRACE("D3DERR_MATRIX_GETDATA_FAILED");break;
		case	D3DERR_SETVIEWPORTDATA_FAILED:	FTRACE("D3DERR_SETVIEWPORTDATA_FAILED");break;
		case	D3DERR_MATERIAL_CREATE_FAILED:	FTRACE("D3DERR_MATERIAL_CREATE_FAILED");break;
		case	D3DERR_MATERIAL_DESTROY_FAILED:	FTRACE("D3DERR_MATERIAL_DESTROY_FAILED");break;
		case	D3DERR_MATERIAL_SETDATA_FAILED:	FTRACE("D3DERR_MATERIAL_SETDATA_FAILED");break;
		case	D3DERR_MATERIAL_GETDATA_FAILED:	FTRACE("D3DERR_MATERIAL_GETDATA_FAILED");break;
		case	D3DERR_LIGHT_SET_FAILED:		FTRACE("D3DERR_LIGHT_SET_FAILED");break;
		case	D3DERR_SCENE_IN_SCENE:			FTRACE("D3DERR_SCENE_IN_SCENE");break;
		case	D3DERR_SCENE_NOT_IN_SCENE:		FTRACE("D3DERR_SCENE_NOT_IN_SCENE");break;
		case	D3DERR_SCENE_BEGIN_FAILED:		FTRACE("D3DERR_SCENE_BEGIN_FAILED");break;
		case	D3DERR_SCENE_END_FAILED:		FTRACE("D3DERR_SCENE_END_FAILED");break;
		case	D3DERR_INBEGIN:					FTRACE("D3DERR_INBEGIN");break;
		case	D3DERR_NOTINBEGIN:				FTRACE("D3DERR_NOTINBEGIN");break;
		case	D3DERR_NOVIEWPORTS:				FTRACE("D3DERR_NOVIEWPORTS");break;
		case	D3DERR_VIEWPORTDATANOTSET:		FTRACE("D3DERR_VIEWPORTDATANOTSET");break;
		case	D3DERR_INVALIDCURRENTVIEWPORT:	FTRACE("D3DERR_INVALIDCURRENTVIEWPORT");break;
		case	D3DERR_INVALIDPRIMITIVETYPE:	FTRACE("D3DERR_INVALIDPRIMITIVETYPE");break;
		case	D3DERR_INVALIDVERTEXTYPE:		FTRACE("D3DERR_INVALIDVERTEXTYPE");break;
		case	D3DERR_TEXTURE_BADSIZE:			FTRACE("D3DERR_TEXTURE_BADSIZE");break;
		default:								trace_dd_error(dd_err);
	}

	FTRACE("\n");
}

