#ifndef _3D_H_
#define _3D_H_

struct CFace;
struct CObject;

struct CColour
{
	int r,g,b;
	void Reset() {r=g=b=0;}
	long operator+(const CColour a) const {return RGB_MAKE(r+a.r>255?255:r+a.r,g+a.g>255?255:g+a.g,b+a.b>255?255:b+a.b);}
};

struct CVInfo
{
	float u,v;
	CTexture *m;
	CColour fixcol,dyncol;
	FVector n;	
	TINDEX idx;
};

struct CPoint
{	
	FVector p,rp;	
	float weight;		// negative if marked for deletion	
	
	CPoint *next;		// next point (either active or inactive or other parent)
	CPoint *child;		// child if not active or NULL if active
	CPoint *parent;		// pointer to parent 
	CPoint *parent2;		// pointer to parent 
	
	union
	{
		CPoint *next2;		// chain of deletion pointers	
		CFace *nextf;		// chain of polys to reinstate with this point	
	};
	union
	{
		int matid;
		char mat[4];
	};
	int nummat;
	CVInfo nfo[4];
};


struct CFace
{	
	CPoint **v[3];
	char mat[4];
	CFace *next;
};

struct CCam
{
	FVector mCentre;
	FMatrix mAxes;

	CCam() {mCentre=FVector(0,0,-100);mAxes.MakeID();}
};

#define MAXEC 512

struct ECL
{
	CPoint *a,*b;
};



struct CLight
{	
	FVector pos;
	int r,g,b;

	virtual void Light(CObject *o) {};

	CLight() {r=g=b=255;pos=FVector(0,0,0);}
	CLight(float rr,float gg,float bb,FVector &p) {r=rr;g=gg;b=bb;pos=p;}
};

struct CBasicLight : public CLight
{
	virtual void Light(CObject *o);

	CBasicLight() {CLight();}
	CBasicLight(float rr,float gg,float bb,FVector &p) {r=rr;g=gg;b=bb;pos=p;}
};

#define LBUFX 32
#define LBUFY 32
#define LBUFMINZ 0.1f

struct CVolLight : public CLight
{
	CVolLight() {CLight();reset();}
	CVolLight(float rr,float gg,float bb,FVector &p) 
	{
		r=rr;g=gg;b=bb;pos=p;
		reset();
	}

	void LookAt(FVector ds)
	{
		axes.Row[2]=ds-pos;
		axes.Normalise();
	}


	int buf[LBUFY][LBUFX];
	
	FMatrix axes;
	float scale,zscale;
	
	//void traceedge(int x1,int y1,int x2,int y2, int mxy);
	void clearbuf() {memset(buf,0,sizeof(buf));}
	void reset() {axes.MakeID();scale=70.f;clearbuf();}
	void renderobj(CObject *o);
	virtual void Light(CObject *o);

	void initforlight(CCam *cam, CVolLight *nxt);
	int CalcLight(int x, int y, int ocol);
	CVolLight *next;	
	FVector vec1;
	FVector zvec;
	FVector xvec;
	FVector yvec;
};


struct CObject
{
	int	mNumF;	
	int mNumV,mNumAV,mNumV2;
	CPoint **mVIdx;
	CPoint *mV;
	CFace *mF;
	CPoint *mV2,*mV2F;	// pool of points for generated points

	CPoint *mAV;		// active vertex head
	CFace *mAF;			// active face list

	int numec;
	ECL ecl[MAXEC];

	FVector mCentre;
	FMatrix mAxes;

	void Draw1(CCam *cam);
	void Draw2();
	void Draw3();
	

	CObject() 
	{
		mCentre=FVector(0,0,0);
		mAxes.MakeID();
		mF=NULL;
		mV=mV2=NULL;
		mVIdx=NULL;
		mAF=NULL;
		mAV=NULL;
	}

	~CObject()
	{
		delete [] mV;
		delete [] mV2;
		delete [] mF;
		delete [] mVIdx;
	}

};


void test3d();


#endif