#ifndef	__FIXED_H__
#define	__FIXED_H__

typedef	long	fixed;

#define	FIX_ABS( a )		((a) < 0 ? -(a) : (a))
#define	FIX_XCHG( a, b )	((a) ^= (b) ^= (a) ^= (b))
#define	FLT_FIX( a )		((fixed)((a) * 65536.0f))
#define	FIX_FLT( a )		((float)(a) / 65536.0f)
#define	DBL_FIX( a )		((fixed)((a) * 65536.0))
#define	FIX_DBL( a )		((double)(a) / 65536.0)
#define	FIX_INT( a )		((a) >> 16)
#define	INT_FIX( a )		((fixed)(a) << 16)
#define	FixCeil( a )		(((a) + 0xffff) & 0xffff0000)
#define	FixIntCeil( a )		(((a) + 0xffff) >> 16)
#define	FixFloor( a )		((a) & 0xffff0000)
#define	FixIntFloor( a )	((a) >> 16)

/*inline fixed FixBicubic( fixed a )
{
	return FixMul( FixSquare( a ), INT_FIX( 3 ) - (a << 1) );
}*/

fixed FixBicubic( fixed );
#pragma aux FixBicubic =	\
	"mov	ebx, eax"	\
	"mov	ecx, 0x30000"	\
	"shl	ebx, 1"		\
	"imul	eax"		\
	"shrd	eax, edx, 16"	\
	"sub	ecx, ebx"	\
	"imul	ecx"		\
	"shrd	eax, edx, 16"	\
	parm [eax]		\
	value [eax]		\
	modify [edx];

fixed FixSquare( fixed );
#pragma aux FixSquare =		\
	"imul	eax"		\
	"shrd	eax, edx, 16"	\
	parm [eax]		\
	value [eax]		\
	modify [edx];

fixed FixMul( fixed, fixed );
#pragma aux FixMul =		\
	"imul	ebx"		\
	"shrd	eax, edx, 16"	\
	parm [eax] [ebx]	\
	value [eax]		\
	modify [edx];

fixed FixDiv( fixed, fixed );
#pragma aux FixDiv =		\
	"mov	edx, eax"	\
	"sar	edx, 16"	\
	"shl	eax, 16"	\
	"idiv	ebx"		\
	parm [eax] [ebx]	\
	modify exact [eax edx]	\
	value [eax];

#endif
