#ifndef	__TRI_H__
#define	__TRI_H__

typedef	long	fixed;

#define	FIX_ABS( a )		((a) < 0 ? -(a) : (a))
#define	FIX_XCHG( a, b )	((a) ^= (b) ^= (a) ^= (b))
#define	FLT_FIX( a )		((fixed)((a) * 65536.0f))
#define	FIX_FLT( a )		((float)(a) / 65536.0f)
#define	FIX_INT( a )		((a) >> 16)
#define	INT_FIX( a )		((fixed)(a) << 16)
//#define	FixDiv( a, b )		((fixed)(((__int64)(a) << 16) / (b)))
#define	FixCeil( a )		(((a) + 0xffff) & 0xffff0000)
#define	FixIntCeil( a )		(((a) + 0xffff) >> 16)
#define	FixFloor( a )		((a) & 0xffff0000)
#define	FixIntFloor( a )	((a) >> 16)

fixed FixMul( fixed, fixed );
#pragma aux FixMul =		\
	"imul	ebx"		\
	"shrd	eax, edx, 16"	\
	parm [eax] [ebx]	\
	value [eax]		\
	modify [edx];

fixed FixDiv( fixed, fixed );
#pragma aux FixDiv =		\
	"mov	edx, eax"	\
	"sar	edx, 16"	\
	"shl	eax, 16"	\
	"idiv	ebx"		\
	parm [eax] [ebx]	\
	modify exact [eax edx]	\
	value [eax];

typedef struct _tri_vertex {
	fixed	x, y, z;
	union {	fixed	r;
		fixed	s;
	};
	fixed	g, b;
	fixed	u, v;
} tri_vertex;

void tri_init( void );
void tri_set_back( long * );
void tri_set_zbuff( fixed * );
void tri_set_texture( long * );
void tri_set_clip( int, int, int, int );
void tri_z_texbl_gs( tri_vertex *, tri_vertex *, tri_vertex * );
void tri_antialias_edge( tri_vertex *, tri_vertex * );

#endif
