#include <malloc.h>
#include <mem.h>
#include <dos.h>
#include "vbe.h"

static struct _RMI {
  unsigned long		EDI;
  unsigned long		ESI;
  unsigned long		EBP;
  unsigned long		reserved;
  unsigned long		EBX;
  unsigned long		EDX;
  unsigned long		ECX;
  unsigned long		EAX;
  unsigned short	flags;
  unsigned short	ES, DS, FS, GS, IP, CS, SP, SS;
} RMI;

union REGS	regs;
struct SREGS	sregs;

int CreateVBEClass( LPVBECLS *lplpVBE )
{
	*lplpVBE = new VBECLS;
	if ( *lplpVBE == NULL ) return 0;
	(*lplpVBE)->cur_page = 0;
	(*lplpVBE)->GetVBEInfo( &(*lplpVBE)->info );
	return (*lplpVBE)->info.VbeVersion;
}

void DestroyVBEClass( LPVBECLS lpVBE )
{
	delete [] lpVBE;
}

static int DPMI_SimulateRMInterrupt( int i )
{
	regs.w.ax = 0x0300;	// Simulate Real-Mode interrupt
	regs.w.bx = i & 0xff;
	regs.w.cx = 0;
	sregs.es = FP_SEG( &RMI );
	regs.x.edi = FP_OFF( &RMI );
	int386x( 0x31, &regs, &regs, &sregs );
	if ( regs.x.cflag ) return 1;
	return 0;
}

static void *DPMI_MapPhysicalAddress( unsigned long phys_mem, long size )
{
	regs.w.ax = 0x800;
	regs.w.cx = phys_mem & 0xffff;
	regs.w.bx = phys_mem >> 16;
	regs.w.di = size & 0xffff;
	regs.w.si = size >> 16;
	int386( 0x31, &regs, &regs );
	return (void *)((long)(regs.w.bx) << 16 | (long)(regs.w.cx));
}

static int DPMI_AllocDosMem( unsigned short bytes, unsigned short *segment )
{
	regs.w.ax = 0x0100;
	regs.w.bx = (bytes + 15) >> 4;
	int386( 0x31, &regs, &regs );
	if ( regs.x.cflag ) return 1;
	*segment = regs.w.ax;
	return 0;
}

int VBECLS::GetVBEInfo( vbe_info *info )
{
	unsigned short	rm_seg;
	if ( DPMI_AllocDosMem( 512, &rm_seg ) ) return 1;
	RMI.EAX = 0x4f00;		// Get SVGA-Mode Information
	RMI.ES  = rm_seg;		// Segment of realmode data
	RMI.EDI = 0;			// offset of realmode data
	DPMI_SimulateRMInterrupt( 0x10 );
	memcpy( info, (void *)((unsigned long)rm_seg << 4), 512 );
	return 0;
}

int VBECLS::GetModeInfo( int mode, vbe_modeinfo *mi )
{
	unsigned short	rm_seg;
	if ( DPMI_AllocDosMem( 256, &rm_seg ) ) return 1;
	RMI.EAX = 0x4f01;		// Get SVGA-Mode Information
	RMI.ECX = mode;
	RMI.ES  = rm_seg;		// Segment of realmode data
	RMI.EDI = 0;			// offset of realmode data
	DPMI_SimulateRMInterrupt( 0x10 );
	memcpy( mi, (void *)((unsigned long)rm_seg << 4), 256 );
	return 0;
}

long VBECLS::GetPhysBase( void )
{
	return cur_mode.PhysBasePtr;
}

int VBECLS::InitMode( int mode, unsigned long *linear )
{
	if ( mode == 0 ) {
		__asm	mov	ax, 3
		__asm	int	0x10
		return 0;
	}
	if ( GetModeInfo( mode, &cur_mode ) ) return 1;
	regs.w.ax = 0x4f02;
	regs.w.bx = mode;
	int386( 0x10, &regs, &regs );
	if ( regs.h.ah != 0 ) return 2;
	scr_size = cur_mode.XResolution * cur_mode.YResolution *
				((cur_mode.BitsPerPixel + 1) >> 3);
	scr_linear = (unsigned long)DPMI_MapPhysicalAddress( cur_mode.PhysBasePtr, scr_size );
	if ( mode & 0x4000 ) *linear = scr_linear;
	return 0;
}

int VBECLS::SetDisplayStart( short x, short y )
{
	RMI.EAX = 0x4f07;
	RMI.EBX = 0;
	RMI.ECX = x;
	RMI.EDX = y;
	DPMI_SimulateRMInterrupt( 0x10 );
	return 0;
}

int VBECLS::GetCurrentPage( void )
{
	return cur_page;
}

int VBECLS::SetPage( int page )
{
	cur_page = page;
	SetDisplayStart( 0, cur_mode.YResolution * page );
	return 0;
}

int VBECLS::SwapPages( void )
{
	cur_page ^= 1;
	SetPage( cur_page );
	return 0;
}

void VBECLS::WaitVSync( void )
{
	__asm {	mov	dx, 0x3da
wvsl0:		in	al, dx
		test	al, 8
		jnz	wvsl0
wvsl1:		in	al, dx
		test	al, 8
		jz	wvsl1
	}
}

void VBECLS::Blit( void *src )
{
	long	ls = scr_size;
	long	ll = scr_linear;
	__asm {	mov	esi, src
		mov	ecx, ls
		mov	edi, ll
		shr	ecx, 4
inner:		fild	qword ptr [esi]
		fild	qword ptr [esi + 8]
		fxch
		fistp	qword ptr [edi]
		fistp	qword ptr [edi + 8]
		add	esi, 16
		add	edi, 16
		dec	ecx
		jnz	inner
	}
}
