; +======================================================================+
; | 1+5 lines Sync-scroll / Hard-scroll routines                         |
; +======================================================================+
; | Copyright (c) 2015-2017 Frederic Poeydomenge <dyno@aldabase.com>     |
; +----------------------------------------------------------------------+
; | This program is free software: you can redistribute it and/or modify |
; | it under the terms of the GNU General Public License as published by |
; | the Free Software Foundation, either version 3 of the License, or    |
; | (at your option) any later version.                                  |
; |                                                                      |
; | This program is distributed in the hope that it will be useful,      |
; | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
; | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         |
; | GNU General Public License for more details.                         |
; |                                                                      |
; | You should have received a copy of the GNU General Public License    |
; | along with this program. If not, see <http://www.gnu.org/licenses/>. |
; +======================================================================+

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 SECTION TEXT
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
start_sync:

;#===================#
;# Setup Sync-scroll #
;#===================#

sync_scroll:

	move.l	sync_logical(pc),d0
	add.l	sync_logical_offset(pc),d0

	; Check if STF/STE
	lea	is_ste(pc),a1
	tst.w	(a1)
	bne.s	.is_ste
.is_stf:
	; Fix screen address
	addq.l	#2,d0

	; 4-bit shift : decrement screen address
	; (4b: -1.w, 8b: -2.w, 12b: -3.w)
	clr.l	d1
	move.w	shift4b(pc),d1
	lsr.l	#1,d1
	sub.l	d1,d0
.is_ste:
	; Finds corresponding sync-scroll lines combination
	moveq	#-2,d3		; d3 = Line 0 - Regular 160b line
	clr.l	d1
	move.b	d0,d1		; d1.l = lower byte of logical screen address
	lea	sync_table(pc),a1
	move.w	(a1,d1.l),d2	; d2 = sync-scroll line combination
	bge.s	.normal		; Bit #15 = 1 :
	moveq	#-1,d3		; Line 0 = Right Overscan 204b line
.normal:
	; Push @ of sync-scroll routines for the 1+5 lines
	clr.l	d7		; offset = 0
	lea	sync_exec(pc),a3
	moveq	#6-1,d6
	bra.s	.firstline
	
.sync_loop:	move.w	d2,d3
	lsr.w	#3,d2
	and.w	#$0007,d3		; rout number
.firstline:	move.b	size_routs(pc,d3.w),d1	; size of rout
	add.l	d1,d7		; add offset
	add.w	d3,d3		; rout number x2
	lea	sync_base(pc),a4
	add.w	sync_routs(pc,d3.w),a4
	move.l	a4,(a3)+
	dbra	d6,.sync_loop

	; Push @ of 4-bit buffer
	move.w	shift4b(pc),d2
	lea	buffer4b(pc),a2
	move.l	(a2,d2.w),(a3)+

	; Substract offset from logical screen address
	sub.l	d7,d0

	; Set physical screen address
	lsr.w	#8,d0
	move.l	d0,VIDEO_ADR_HIGH-1.w

	rts

;#==========================#
;# LUT Sync-scroll routines #
;#==========================#

sync_routs_L0:	dc.w sync_F160-sync_base
		dc.w sync_F204-sync_base
sync_routs:		dc.w sync_L54-sync_base
		dc.w sync_L80-sync_base
		dc.w sync_L158-sync_base
		dc.w sync_L160-sync_base
		dc.w sync_L184-sync_base
		dc.w sync_L186-sync_base
		dc.w sync_L204-sync_base
		dc.w sync_L230-sync_base

size_routs_L0:	dc.b 160,204
size_routs:		dc.b 54,80,158,160,184,186,204,230

;#======================#
;# Sync-scroll routines #
;#======================#
sync_base:

;+---------------+
;| 54 bytes line |
;+---------------+
; (DE activated at 60, deactivated at 168. (168-60)/2 = 54)
;
; If we switch to monochrome at position 40, with the left border not removed,
; we obtain line lenght of 80-26 = 54 bytes, corresponding to the 80 bytes of
; each high resolution line - 26 bytes of left border.
;

sync_L54:	fill_nop_41			; [41]
	switch_res_hi_low		; [ 5] Switch to monochrome
	fill_nop_53			; [77]
	sync_pal_load		;     -[11]
	sync_pal_set1		;     -[ 7]
	sync_pal_set2		;     -[ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;+---------------+
;| 80 bytes line |
;+---------------+
; (DE activated at 8, deactivated at 168. (168-8)/2 = 80)
;
; If we switch to monochrome at position 40, with the left border removed,
; we obtain line lenght of 80 bytes, corresponding to the 80 bytes of
; each high resolution line
;

sync_L80:	switch_res_hi_low6		; [ 6] Left border (6 nops)
	fill_nop_35			; [35]
	switch_res_hi_low		; [ 5] Switch to monochrome
	fill_nop_38			; [49]
	sync_pal_load		;     -[11]
	switch_freq_60_50		; [ 4] Right border
	fill_nop_6			; [13]
	sync_pal_set1		;     -[ 7]
	stabilisator		; [ 5] Stabilisator
	sync_pal_set2		; [ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;+--------------------------+
;| Regular line [- 2 bytes] |
;+--------------------------+
; (DE activated at 60, deactivated at 376. (376-60)/2 = 158)
;
; We obtain 158 byte line by switching to 60Hz at position 93 (trying to open
; the right border 1 nop before a full overscan), thus enabling the 60Hz end
; of line detection. The line is shorter by a word.
;

sync_L158:	fill_nop_83			; [94]
	sync_pal_load		;     -[11]
	switch_freq_60_50		; [ 4] Early right border switch
	fill_nop_12			; [25]
	sync_pal_set1		;     -[ 7]
	sync_pal_set2		;     -[ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;+--------------+
;| Regular line |
;+--------------+
; (DE activated at 56, deactivated at 376. (376-56)/2 = 160)
;
; A regular 160 byte line.
;

sync_L160:	fill_nop_67			; [123]
sync_F160:	fill_nop_32			;      -[32]
	sync_pal_load		;      -[11]
	sync_pal_set1		;      -[ 7]
	sync_pal_set2		;      -[ 6]
	move.l	(a6)+,a5		; [  3] Next line
	jmp	(a5)		; [  2]

;+---------------------------+
;| Left overscan [- 2 bytes] |
;+---------------------------+
; (DE activated at 8, deactivated at 376. (376-8)/2 = 184)
;
; We obtain 184 byte line by switching to 60Hz at position 93 (trying to open
; the right border 1 nop before a full overscan), thus enabling the 60Hz end
; of line detection. The line is shorter by a word.
;

sync_L184:	switch_res_hi_low6		; [ 6] Left border (6 nops)
	fill_nop_77			; [88]
	sync_pal_load		;     -[11]
	switch_freq_60_50		; [ 4] Early right border switch
	fill_nop_7			; [14]
	sync_pal_set1		;     -[ 7]
	stabilisator		; [ 5] Stabilisator
	sync_pal_set2		; [ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;+---------------+
;| Left overscan |
;+---------------+
; (DE activated at 8, deactivated at 380. (380-8)/2 = 186)
;

sync_L186:	switch_res_hi_low6		; [  6] Left border (6 nops)
	fill_nop_88			; [106]
	sync_pal_load		;      -[11]
	sync_pal_set1		;      -[ 7]
	stabilisator		; [  5] Stabilisator
	sync_pal_set2		; [  6]
	move.l	(a6)+,a5		; [  3] Next line
	jmp	(a5)		; [  2]

;+----------------+
;| Right Overscan |
;+----------------+
; (DE activated at 60, deactivated at 468. (468-60)/2 = 204)
;
; Enable Right Overscan by switching to 60Hz at position 94, overiding
; the 50Hz end-of-useable-line detection, and then returning to 50Hz.
;

sync_L204:	fill_nop_67			; [95]
sync_F204:	fill_nop_17			;     -[17]
	sync_pal_load		;     -[11]
	switch_freq_60_50		; [ 4] Right border
	fill_nop_11			; [24]
	sync_pal_set1		;     -[ 7]
	sync_pal_set2		;     -[ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;+-------------------+
;| Complete Overscan |
;+-------------------+
; (DE activated at 8, deactivated at 468. (468-8)/2 = 230)
;

sync_L230:	switch_res_hi_low6		; [ 6] Left border (6 nops)
	fill_nop_78			; [89]
	sync_pal_load		;     -[11]
	switch_freq_60_50		; [ 4] Right border
	fill_nop_6			; [13]
	sync_pal_set1		;     -[ 7]
	stabilisator		; [ 5] Stabilisator
	sync_pal_set2		; [ 6]
	move.l	(a6)+,a5		; [ 3] Next line
	jmp	(a5)		; [ 2]

;#===================#
;# Sync-scroll table #
;#===================#

sync_table:	dc.w (0<<15)+(4<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $4480 - Offset   0 : 160,  54,  54, 158, 158, 184
	dc.w (0<<15)+(5<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $5480 - Offset   2 : 160,  54,  54, 158, 158, 186
	dc.w (0<<15)+(5<<12)+(3<<9)+(2<<6)+(0<<3)+0	; $5680 - Offset   4 : 160,  54,  54, 158, 160, 186
	dc.w (0<<15)+(5<<12)+(3<<9)+(3<<6)+(0<<3)+0	; $56C0 - Offset   6 : 160,  54,  54, 160, 160, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(2<<3)+2	; $5B12 - Offset   8 : 160, 158, 158, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(2<<3)+2	; $5B52 - Offset  10 : 160, 158, 158, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(6<<6)+(2<<3)+0	; $7F90 - Offset  12 : 160,  54, 158, 204, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(0<<6)+(0<<3)+0	; $7E00 - Offset  14 : 160,  54,  54,  54, 230, 230
	dc.w (1<<15)+(7<<12)+(4<<9)+(4<<6)+(4<<3)+0	; $F920 - Offset  16 : 204,  54, 184, 184, 184, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+0	; $7F20 - Offset  18 : 160,  54, 184, 184, 230, 230
	dc.w (0<<15)+(6<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $6480 - Offset  20 : 160,  54,  54, 158, 158, 204
	dc.w (0<<15)+(2<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $2000 - Offset  22 : 160,  54,  54,  54,  54, 158
	dc.w (0<<15)+(3<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $3000 - Offset  24 : 160,  54,  54,  54,  54, 160
	dc.w (0<<15)+(4<<12)+(4<<9)+(2<<6)+(0<<3)+0	; $4880 - Offset  26 : 160,  54,  54, 158, 184, 184
	dc.w (0<<15)+(5<<12)+(4<<9)+(2<<6)+(0<<3)+0	; $5880 - Offset  28 : 160,  54,  54, 158, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(2<<6)+(0<<3)+0	; $5A80 - Offset  30 : 160,  54,  54, 158, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(3<<6)+(0<<3)+0	; $5AC0 - Offset  32 : 160,  54,  54, 160, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(4<<3)+2	; $5B22 - Offset  34 : 160, 158, 184, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(4<<3)+2	; $5B62 - Offset  36 : 160, 158, 184, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(2<<3)+0	; $7FD0 - Offset  38 : 160,  54, 158, 230, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(1<<6)+(0<<3)+0	; $7E40 - Offset  40 : 160,  54,  54,  80, 230, 230
	dc.w (1<<15)+(7<<12)+(4<<9)+(4<<6)+(4<<3)+1	; $F921 - Offset  42 : 204,  80, 184, 184, 184, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+1	; $7F21 - Offset  44 : 160,  80, 184, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $7480 - Offset  46 : 160,  54,  54, 158, 158, 230
	dc.w (0<<15)+(4<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $4000 - Offset  48 : 160,  54,  54,  54,  54, 184
	dc.w (0<<15)+(5<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $5000 - Offset  50 : 160,  54,  54,  54,  54, 186
	dc.w (0<<15)+(4<<12)+(4<<9)+(4<<6)+(0<<3)+0	; $4900 - Offset  52 : 160,  54,  54, 184, 184, 184
	dc.w (0<<15)+(5<<12)+(4<<9)+(4<<6)+(0<<3)+0	; $5900 - Offset  54 : 160,  54,  54, 184, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(0<<3)+0	; $5B00 - Offset  56 : 160,  54,  54, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(0<<3)+0	; $5B40 - Offset  58 : 160,  54,  54, 186, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(4<<3)+4	; $5B24 - Offset  60 : 160, 184, 184, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(4<<3)+4	; $5B64 - Offset  62 : 160, 184, 184, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(4<<3)+0	; $7FE0 - Offset  64 : 160,  54, 184, 230, 230, 230
	dc.w (0<<15)+(6<<12)+(6<<9)+(2<<6)+(0<<3)+0	; $6C80 - Offset  66 : 160,  54,  54, 158, 204, 204
	dc.w (0<<15)+(6<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $6000 - Offset  68 : 160,  54,  54,  54,  54, 204
	dc.w (0<<15)+(7<<12)+(7<<9)+(2<<6)+(2<<3)+2	; $7E92 - Offset  70 : 160, 158, 158, 158, 230, 230
	dc.w (0<<15)+(7<<12)+(4<<9)+(2<<6)+(0<<3)+0	; $7880 - Offset  72 : 160,  54,  54, 158, 184, 230
	dc.w (0<<15)+(4<<12)+(1<<9)+(0<<6)+(0<<3)+0	; $4200 - Offset  74 : 160,  54,  54,  54,  80, 184
	dc.w (0<<15)+(5<<12)+(1<<9)+(0<<6)+(0<<3)+0	; $5200 - Offset  76 : 160,  54,  54,  54,  80, 186
	dc.w (0<<15)+(4<<12)+(4<<9)+(4<<6)+(1<<3)+0	; $4908 - Offset  78 : 160,  54,  80, 184, 184, 184
	dc.w (0<<15)+(5<<12)+(4<<9)+(4<<6)+(1<<3)+0	; $5908 - Offset  80 : 160,  54,  80, 184, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(1<<3)+0	; $5B08 - Offset  82 : 160,  54,  80, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(1<<3)+0	; $5B48 - Offset  84 : 160,  54,  80, 186, 186, 186
	dc.w (0<<15)+(3<<12)+(3<<9)+(3<<6)+(3<<3)+0	; $36D8 - Offset  86 : 160,  54, 160, 160, 160, 160
	dc.w (1<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+1	; $FF21 - Offset  88 : 204,  80, 184, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(4<<3)+1	; $7FE1 - Offset  90 : 160,  80, 184, 230, 230, 230
	dc.w (0<<15)+(7<<12)+(6<<9)+(2<<6)+(0<<3)+0	; $7C80 - Offset  92 : 160,  54,  54, 158, 204, 230
	dc.w (0<<15)+(7<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $7000 - Offset  94 : 160,  54,  54,  54,  54, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(2<<3)+2	; $7F12 - Offset  96 : 160, 158, 158, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(4<<9)+(4<<6)+(0<<3)+0	; $7900 - Offset  98 : 160,  54,  54, 184, 184, 230
	dc.w (0<<15)+(4<<12)+(1<<9)+(1<<6)+(0<<3)+0	; $4240 - Offset 100 : 160,  54,  54,  80,  80, 184
	dc.w (0<<15)+(5<<12)+(1<<9)+(1<<6)+(0<<3)+0	; $5240 - Offset 102 : 160,  54,  54,  80,  80, 186
	dc.w (0<<15)+(4<<12)+(2<<9)+(2<<6)+(2<<3)+0	; $4490 - Offset 104 : 160,  54, 158, 158, 158, 184
	dc.w (0<<15)+(5<<12)+(2<<9)+(2<<6)+(2<<3)+0	; $5490 - Offset 106 : 160,  54, 158, 158, 158, 186
	dc.w (0<<15)+(5<<12)+(3<<9)+(2<<6)+(2<<3)+0	; $5690 - Offset 108 : 160,  54, 158, 158, 160, 186
	dc.w (0<<15)+(5<<12)+(3<<9)+(3<<6)+(2<<3)+0	; $56D0 - Offset 110 : 160,  54, 158, 160, 160, 186
	dc.w (0<<15)+(6<<12)+(6<<9)+(6<<6)+(0<<3)+0	; $6D80 - Offset 112 : 160,  54,  54, 204, 204, 204
	dc.w (1<<15)+(7<<12)+(7<<9)+(2<<6)+(2<<3)+2	; $FE92 - Offset 114 : 204, 158, 158, 158, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(6<<6)+(2<<3)+2	; $7F92 - Offset 116 : 160, 158, 158, 204, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(2<<6)+(0<<3)+0	; $7E80 - Offset 118 : 160,  54,  54, 158, 230, 230
	dc.w (0<<15)+(7<<12)+(1<<9)+(0<<6)+(0<<3)+0	; $7200 - Offset 120 : 160,  54,  54,  54,  80, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+2	; $7F22 - Offset 122 : 160, 158, 184, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(4<<9)+(4<<6)+(1<<3)+0	; $7908 - Offset 124 : 160,  54,  80, 184, 184, 230
	dc.w (0<<15)+(2<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $2400 - Offset 126 : 160,  54,  54,  54, 158, 158
	dc.w (0<<15)+(3<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $3400 - Offset 128 : 160,  54,  54,  54, 158, 160
	dc.w (0<<15)+(3<<12)+(3<<9)+(0<<6)+(0<<3)+0	; $3600 - Offset 130 : 160,  54,  54,  54, 160, 160
	dc.w (0<<15)+(5<<12)+(4<<9)+(2<<6)+(2<<3)+0	; $5890 - Offset 132 : 160,  54, 158, 158, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(2<<6)+(2<<3)+0	; $5A90 - Offset 134 : 160,  54, 158, 158, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(3<<6)+(2<<3)+0	; $5AD0 - Offset 136 : 160,  54, 158, 160, 186, 186
	dc.w (0<<15)+(7<<12)+(6<<9)+(6<<6)+(0<<3)+0	; $7D80 - Offset 138 : 160,  54,  54, 204, 204, 230
	dc.w (1<<15)+(7<<12)+(7<<9)+(4<<6)+(2<<3)+2	; $FF12 - Offset 140 : 204, 158, 158, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(2<<3)+2	; $7FD2 - Offset 142 : 160, 158, 158, 230, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(0<<3)+0	; $7F00 - Offset 144 : 160,  54,  54, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(1<<9)+(1<<6)+(0<<3)+0	; $7240 - Offset 146 : 160,  54,  54,  80,  80, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+4	; $7F24 - Offset 148 : 160, 184, 184, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(2<<9)+(2<<6)+(2<<3)+0	; $7490 - Offset 150 : 160,  54, 158, 158, 158, 230
	dc.w (0<<15)+(4<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $4400 - Offset 152 : 160,  54,  54,  54, 158, 184
	dc.w (0<<15)+(5<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $5400 - Offset 154 : 160,  54,  54,  54, 158, 186
	dc.w (0<<15)+(5<<12)+(3<<9)+(0<<6)+(0<<3)+0	; $5600 - Offset 156 : 160,  54,  54,  54, 160, 186
	dc.w (0<<15)+(5<<12)+(4<<9)+(4<<6)+(2<<3)+0	; $5910 - Offset 158 : 160,  54, 158, 184, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(2<<3)+0	; $5B10 - Offset 160 : 160,  54, 158, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(2<<3)+0	; $5B50 - Offset 162 : 160,  54, 158, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(6<<6)+(0<<3)+0	; $7F80 - Offset 164 : 160,  54,  54, 204, 230, 230
	dc.w (1<<15)+(7<<12)+(7<<9)+(4<<6)+(4<<3)+2	; $FF22 - Offset 166 : 204, 158, 184, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(4<<3)+2	; $7FE2 - Offset 168 : 160, 158, 184, 230, 230, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(1<<3)+0	; $7F08 - Offset 170 : 160,  54,  80, 184, 230, 230
	dc.w (0<<15)+(6<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $6400 - Offset 172 : 160,  54,  54,  54, 158, 204
	dc.w (0<<15)+(0<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $0000 - Offset 174 : 160,  54,  54,  54,  54,  54
	dc.w (0<<15)+(7<<12)+(4<<9)+(2<<6)+(2<<3)+0	; $7890 - Offset 176 : 160,  54, 158, 158, 184, 230
	dc.w (0<<15)+(4<<12)+(4<<9)+(0<<6)+(0<<3)+0	; $4800 - Offset 178 : 160,  54,  54,  54, 184, 184
	dc.w (0<<15)+(5<<12)+(4<<9)+(0<<6)+(0<<3)+0	; $5800 - Offset 180 : 160,  54,  54,  54, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(0<<6)+(0<<3)+0	; $5A00 - Offset 182 : 160,  54,  54,  54, 186, 186
	dc.w (0<<15)+(5<<12)+(4<<9)+(4<<6)+(4<<3)+0	; $5920 - Offset 184 : 160,  54, 184, 184, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(4<<3)+0	; $5B20 - Offset 186 : 160,  54, 184, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(4<<3)+0	; $5B60 - Offset 188 : 160,  54, 184, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(0<<3)+0	; $7FC0 - Offset 190 : 160,  54,  54, 230, 230, 230
	dc.w (0<<15)+(3<<12)+(3<<9)+(3<<6)+(3<<3)+3	; $36DB - Offset 192 : 160, 160, 160, 160, 160, 160
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(4<<3)+4	; $7FE4 - Offset 194 : 160, 184, 184, 230, 230, 230
	dc.w (0<<15)+(7<<12)+(6<<9)+(2<<6)+(2<<3)+0	; $7C90 - Offset 196 : 160,  54, 158, 158, 204, 230
	dc.w (0<<15)+(7<<12)+(2<<9)+(0<<6)+(0<<3)+0	; $7400 - Offset 198 : 160,  54,  54,  54, 158, 230
	dc.w (0<<15)+(1<<12)+(0<<9)+(0<<6)+(0<<3)+0	; $1000 - Offset 200 : 160,  54,  54,  54,  54,  80
	dc.w (0<<15)+(7<<12)+(4<<9)+(4<<6)+(2<<3)+0	; $7910 - Offset 202 : 160,  54, 158, 184, 184, 230
	dc.w (0<<15)+(4<<12)+(4<<9)+(1<<6)+(0<<3)+0	; $4840 - Offset 204 : 160,  54,  54,  80, 184, 184
	dc.w (0<<15)+(5<<12)+(4<<9)+(1<<6)+(0<<3)+0	; $5840 - Offset 206 : 160,  54,  54,  80, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(1<<6)+(0<<3)+0	; $5A40 - Offset 208 : 160,  54,  54,  80, 186, 186
	dc.w (0<<15)+(5<<12)+(4<<9)+(4<<6)+(4<<3)+1	; $5921 - Offset 210 : 160,  80, 184, 184, 184, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(4<<6)+(4<<3)+1	; $5B21 - Offset 212 : 160,  80, 184, 184, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(5<<6)+(4<<3)+1	; $5B61 - Offset 214 : 160,  80, 184, 186, 186, 186
	dc.w (0<<15)+(7<<12)+(7<<9)+(7<<6)+(1<<3)+0	; $7FC8 - Offset 216 : 160,  54,  80, 230, 230, 230
	dc.w (0<<15)+(6<<12)+(6<<9)+(0<<6)+(0<<3)+0	; $6C00 - Offset 218 : 160,  54,  54,  54, 204, 204
	dc.w (1<<15)+(7<<12)+(4<<9)+(2<<6)+(2<<3)+0	; $F890 - Offset 220 : 204,  54, 158, 158, 184, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(2<<6)+(2<<3)+0	; $7E90 - Offset 222 : 160,  54, 158, 158, 230, 230
	dc.w (0<<15)+(7<<12)+(4<<9)+(0<<6)+(0<<3)+0	; $7800 - Offset 224 : 160,  54,  54,  54, 184, 230
	dc.w (0<<15)+(1<<12)+(1<<9)+(0<<6)+(0<<3)+0	; $1200 - Offset 226 : 160,  54,  54,  54,  80,  80
	dc.w (0<<15)+(7<<12)+(4<<9)+(4<<6)+(4<<3)+0	; $7920 - Offset 228 : 160,  54, 184, 184, 184, 230
	dc.w (0<<15)+(2<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $2480 - Offset 230 : 160,  54,  54, 158, 158, 158
	dc.w (0<<15)+(3<<12)+(2<<9)+(2<<6)+(0<<3)+0	; $3480 - Offset 232 : 160,  54,  54, 158, 158, 160
	dc.w (0<<15)+(3<<12)+(3<<9)+(2<<6)+(0<<3)+0	; $3680 - Offset 234 : 160,  54,  54, 158, 160, 160
	dc.w (0<<15)+(3<<12)+(3<<9)+(3<<6)+(0<<3)+0	; $36C0 - Offset 236 : 160,  54,  54, 160, 160, 160
	dc.w (0<<15)+(5<<12)+(5<<9)+(2<<6)+(2<<3)+2	; $5A92 - Offset 238 : 160, 158, 158, 158, 186, 186
	dc.w (0<<15)+(5<<12)+(5<<9)+(3<<6)+(2<<3)+2	; $5AD2 - Offset 240 : 160, 158, 158, 160, 186, 186
	dc.w (0<<15)+(7<<12)+(6<<9)+(6<<6)+(2<<3)+0	; $7D90 - Offset 242 : 160,  54, 158, 204, 204, 230
	dc.w (0<<15)+(7<<12)+(6<<9)+(0<<6)+(0<<3)+0	; $7C00 - Offset 244 : 160,  54,  54,  54, 204, 230
	dc.w (1<<15)+(7<<12)+(4<<9)+(4<<6)+(2<<3)+0	; $F910 - Offset 246 : 204,  54, 158, 184, 184, 230
	dc.w (0<<15)+(7<<12)+(7<<9)+(4<<6)+(2<<3)+0	; $7F10 - Offset 248 : 160,  54, 158, 184, 230, 230
	dc.w (0<<15)+(7<<12)+(4<<9)+(1<<6)+(0<<3)+0	; $7840 - Offset 250 : 160,  54,  54,  80, 184, 230
	dc.w (0<<15)+(1<<12)+(1<<9)+(1<<6)+(0<<3)+0	; $1240 - Offset 252 : 160,  54,  54,  80,  80,  80
	dc.w (0<<15)+(7<<12)+(4<<9)+(4<<6)+(4<<3)+1	; $7921 - Offset 254 : 160,  80, 184, 184, 184, 230

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 SECTION BSS
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

;#========================#
;# Screen logical address #
;#========================#

sync_logical:	ds.l 1
sync_logical_offset:	ds.l 1

;#=================================#
;# Sync-scroll routines to execute #
;#=================================#

sync_exec:		ds.l 6
sync_exec_buffer:	ds.l 1

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 SECTION TEXT
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
end_sync: