*********************************
*
*  void interrupt IO_CheckInput()
*
* Read from the Atari's keyboard system
*	
*********************************

		section	text
IO_CheckInput	movem.l	d0/a0,-(sp)

		lea.l	$fffffc02.w,a0	; keyboard ACIA

		moveq.l	#0,d0
		move.b	(a0),d0		; ACIA data
				
		lea.l	IO_ButtonState(pc),a0

		bclr.l	#7,d0
		bne.s	.clr_key	; key released ?

		st.b	(a0,d0.w)	; otherwise flag it

		movem.l	(sp)+,d0/a0
		rte

.clr_key	clr.b	(a0,d0.w)

.eoi		movem.l	(sp)+,d0/a0
		rte

IO_ButtonState	dcb.b	128,0		; table of keys active at the moment




*********************************
*
*  void IO_SetUpDisplay()
*
* Set up IO_DisplayViewBuffer
*
*********************************

MAXX		= 160		; Max offscreen width, height in doublepixels
MAXY		= 80

		section text
xsize		dc.w	SCREENX&-32
ysize		dc.w 	SCREENY&-2

detail		dc.b	0	; Detail level ($00:low, $ff:high)
		even
		
IO_SetUpDisplay	tas.b	.firstcall	; Run this on first call only
		bne.s	.called
		
		lea.l	.build(pc),a0	; Generate 8(4)bpp->4bpl conversion table
		lea.l	$1010.w,a1
		
		moveq.l	#0,d0

.gentable	move.w	d0,d1
		move.w	d0,d2
		move.w	d0,d3
		move.w	d0,d4

		lsr.w	#2,d1		; Left pixel
		andi.w	#$3c,d1
		lsl.w	#2,d2		; Right pixel
		andi.w	#$3c,d2

		move.l	(a0,d2.w),d2	; Bitplane data
		ror.l	#2,d2
		or.l	(a0,d1.w),d2

		andi.b	#$f,d3		; Compute table index
		lsl.w	#2,d3
		andi.b	#$f0,d4
		lsl.w	#4+2,d4
		or.w	d4,d3		; d0.b (xy) -> d3.w ($0x0y << 2)


		move.l	d2,64(a1,d3.w)
		ror.l	#4,d2
		move.l	d2,(a1,d3.w)


		addq.b	#1,d0
		bne.s	.gentable
	
					; now generate the codetable according to the values
					; given by xsize, ysize

.called		lea.l	.template(pc),a0
		lea.l	IO_DisplayViewBuffer,a1
	
	rept	3	
		move.l	(a0)+,(a1)+	; "lea.l   ViewBuffer,a0 ..."
	endr		
		movem.w	xsize(pc),d0/d1
		move.w	(a0)+,(a1)+	; "move.w  #ysize-1,d7"
		move.w	d1,(a1)
		subq.w	#1,(a1)+
		
		move.w	#PHYSX,d4	; Yinc
		sub.w	d0,d4
		
		move.w	(a0)+,(a1)+	; "lea.l   Center(a1),a1"

		move.w	#MAXX,d2	; Center destination window
		sub.w	d0,d2
		lsr.w	d2
		move.w	#MAXY,d3

		move.b	detail(pc),d7	; Check detail
		beq.s	.lo
		lsr.w	d1

		sub.w	d1,d3
		mulu.w	#MAXX,d3
		move.w	d3,(a1)+
		bra.s	.hi

.lo		sub.w	d1,d3
		mulu.w	#MAXX,d3
		add.w	d2,d3
		move.w	d3,(a1)+

		moveq.l	#0,d2		; Destination offset

.hi		movea.l	a1,a3		; Save .yloop label



		move.w	d0,d1		; Number of 8 pixel chunks
		lsr.w	#3,d1
		subq.w	#1,d1
		
.xloop		movea.l	a0,a2
	rept	4
		move.l	(a2)+,(a1)+	; "movem.w (a0)+,a2-a5 ..."
	endr
		move.w	(a2)+,(a1)+	; "movep.l d0,dst(a1) ..."
		move.w	d2,(a1)+
		addq.w	#1,d2
		move.w	(a2)+,(a1)+
		move.w	d2,(a1)+
		addq.w	#7,d2

		dbra	d1,.xloop
		

		tst.b	d7		; Check my detail level
		bne.s	.skipldbl

		lsr.w	#5,d0		; Number of 32 byte chunks-1
		subq.w	#1,d0
		
.linedouble	movea.l	a2,a0	
		move.l	(a0)+,(a1)+	; "movem.l (a1)+,d0-d6/a2"
		move.l	(a0)+,(a1)+	; "movem.l d0-d6/a1,160-32(a1)"
		move.w	(a0)+,(a1)+
		dbra	d0,.linedouble
		bra.s	.dstskip

.skipldbl	lea.l	10(a2),a0	; Skip line doubling code in hi detail mode
		move.w	#PHYSX/2,d4	; and reset destination skip value

.dstskip	move.w	(a0)+,(a1)+	; "lea.l   Yinc(a1),a1"
		move.w	d4,(a1)+


		move.w	(a0)+,(a1)+	; "dbra  d7,.yloop"
		suba.l	a1,a3
		move.w	a3,(a1)+
		move.w	(a0)+,(a1)	; "rts"

	
		movem.w	xsize(pc),d0/d1	; Length of offscreen buffer
		mulu.w	d0,d1
		move.w	d1,IO_BufferLength



		lea.l	xscale,a0	; Rescale angle conversion table
		
		move.l	#DEG360*(-(FOV/2)<<16/360),d2	; Initial angle, 16.16
		moveq.l	#1,d1
		swap.w	d1		; Stepsize, 16.16
		divu.w	d0,d1
		mulu.w	#DEG360*FOV/360,d1


		subq.w	#1,d0

		swap.w	d1
		swap.w	d2
		add.l	d2,d1
		sub.w	d2,d1

.xscale		move.w	d2,(a0)+	; Store (int)Scale
		addx.l	d1,d2		; Scale += Stepsize
		dbra	d0,.xscale

		rts

.firstcall	dc.w	0


.build		dc.l	$00000000	; Bitplane encoded colors
		dc.l	$c0000000
		dc.l	$00c00000
		dc.l	$c0c00000
		dc.l	$0000c000
		dc.l	$c000c000
		dc.l	$00c0c000
		dc.l	$c0c0c000
		dc.l	$000000c0
		dc.l	$c00000c0
		dc.l	$00c000c0
		dc.l	$c0c000c0
		dc.l	$0000c0c0
		dc.l	$c000c0c0
		dc.l	$00c0c0c0
		dc.l	$c0c0c0c0

.template	lea.l	ViewBuffer,a0
		movea.l	ScreenAdr2,a1
		dc.w	$3e3c		; "move.w	#ysize-1,d7"
		dc.w	$43e9		; "lea.l Center(a1),a1"
	
		movem.w	(a0)+,a2-a5	; Fetch 8 pixels, 8(4)bpp
		move.l	64(a2),d0	; Convert to 4bpl
		or.l	(a3),d0
		move.l	64(a4),d1
		or.l	(a5),d1
		dc.w	$01c9		; "movep.l d0,dst(a1)"
		dc.w	$03c9		; "movep.l d1,dst+1(a1)"

		movem.l	(a1)+,d0-d6/a2	; Linedoubling
		movem.l	d0-d6/a2,160-32(a1)
		
		dc.w	$43e9		; "lea.l Yinc(a1),a1"
		dc.w	$51cf		; "dbra	d7,.yloop"
op_rts		rts



*********************************
*
*  void IO_DisplayViewBuffer()
*
* Blit the backbuffer into a physical screenarea.
* This routine get generated by IO_SetUpDisplay
*
*********************************

		section	bss
IO_DisplayViewBuffer
		ds.w	300

ViewBuffer	ds.b	2*MAXX*MAXY




*********************************
*
*  void IO_ClearViewBuffer()
*
* Erase the ViewBuffer to ceiling/floor colors
*
*********************************

CEILING_COLOR	=	$06060606	; Ceiling color
FLOOR_COLOR	=	$01010101	; Floor color

		section	text
IO_BufferLength	ds.w   1

IO_ClearViewBuffer
		lea.l	ViewBuffer,a0
		movem.w	IO_BufferLength(pc),d0
		lsr.w	d0
		move.l	d0,-(sp)
		move.l	#CEILING_COLOR<<2+$10101010,d1
		bsr.w	ClearBlock

		lea.l	ViewBuffer,a0
		move.l	(sp)+,d0
		adda.l	d0,a0
		move.l	#FLOOR_COLOR<<2+$10101010,d1
		bra.w	ClearBlock	