		; List of bad guy sprites
		section	data
DKnightSprs	dc.l	S_DKNIGHT_ATK1
		dc.l	S_DKNIGHT_ATK2
		dc.l	S_DKNIGHT_ATK3
		dc.l	S_DKNIGHT_ATK4
		dc.l	S_DKNIGHT_WLK1
		dc.l	S_DKNIGHT_WLK2
		dc.l	S_DKNIGHT_WLK3
		dc.l	S_DKNIGHT_WLK4
		dc.l	S_DKNIGHT_DTH1
		dc.l	S_DKNIGHT_DTH2
		dc.l	S_DKNIGHT_DTH3
		dc.l	S_G_KEY,0

DogSprs		dc.l	S_DOG_ATK1
		dc.l	S_DOG_ATK2
		dc.l	S_DOG_ATK3
		dc.l	S_DOG_WLK1
		dc.l	S_DOG_WLK2
		dc.l	S_DOG_WLK3
		dc.l	S_DOG_WLK4
		dc.l	S_DOG_DTH1
		dc.l	S_DOG_DTH2
		dc.l	S_DOG_DTH3,0

NaziSprs	dc.l	S_GUARD_ATK1
		dc.l	S_GUARD_ATK2
		dc.l	S_GUARD_ATK3
		dc.l	S_GUARD_WLK1
		dc.l	S_GUARD_WLK2
		dc.l	S_GUARD_WLK3
		dc.l	S_GUARD_WLK4
		dc.l	S_GUARD_PAIN
		dc.l	S_GUARD_DTH1
		dc.l	S_GUARD_DTH2
		dc.l	S_GUARD_DTH3
		dc.l	S_AMMO,0

HansSprs	dc.l	S_HANS_ATK1
		dc.l	S_HANS_ATK2
		dc.l	S_HANS_ATK3
		dc.l	S_HANS_WLK1
		dc.l	S_HANS_WLK2
		dc.l	S_HANS_WLK3
		dc.l	S_HANS_WLK4
		dc.l	S_HANS_DTH1
		dc.l	S_HANS_DTH2
		dc.l	S_HANS_DTH3
		dc.l	S_G_KEY,0

HitlerSprs	dc.l	S_HITLER_ATK1
		dc.l	S_HITLER_ATK2
		dc.l	S_HITLER_ATK3
		dc.l	S_HITLER_WLK1
		dc.l	S_HITLER_WLK2
		dc.l	S_HITLER_WLK3
		dc.l	S_HITLER_WLK4
		dc.l	S_HITLER_DTH1
		dc.l	S_HITLER_DTH2
		dc.l	S_HITLER_DTH3
		dc.l	S_MHITLER_ATK1
		dc.l	S_MHITLER_ATK2
		dc.l	S_MHITLER_ATK3
		dc.l	S_MHITLER_DIE1
		dc.l	S_MHITLER_DIE2
		dc.l	S_MHITLER_DIE3
		dc.l	S_MHITLER_DIE4
		dc.l	S_MHITLER_WLK1
		dc.l	S_MHITLER_WLK2
		dc.l	S_MHITLER_WLK3
		dc.l	S_MHITLER_WLK4,0

UberSprs	dc.l	S_UBER_ATK1
		dc.l	S_UBER_ATK2
		dc.l	S_UBER_ATK3
		dc.l	S_UBER_ATK4
		dc.l	S_UBER_WLK1
		dc.l	S_UBER_WLK2
		dc.l	S_UBER_WLK3
		dc.l	S_UBER_WLK4
		dc.l	S_UBER_DTH1
		dc.l	S_UBER_DTH2
		dc.l	S_UBER_DTH3
		dc.l	S_G_KEY,0

MutantSprs	dc.l	S_MUTANT_ATK1
		dc.l	S_MUTANT_ATK2
		dc.l	S_MUTANT_ATK3
		dc.l	S_MUTANT_WLK1
		dc.l	S_MUTANT_WLK2
		dc.l	S_MUTANT_WLK3
		dc.l	S_MUTANT_WLK4
		dc.l	S_MUTANT_PAIN
		dc.l	S_MUTANT_DTH1
		dc.l	S_MUTANT_DTH2
		dc.l	S_MUTANT_DTH3
		dc.l	S_AMMO,0

OfficerSprs	dc.l	S_OFFICER_ATK1
		dc.l	S_OFFICER_ATK2
		dc.l	S_OFFICER_ATK3
		dc.l	S_OFFICER_WLK1
		dc.l	S_OFFICER_WLK2
		dc.l	S_OFFICER_WLK3
		dc.l	S_OFFICER_WLK4
		dc.l	S_OFFICER_PAIN
		dc.l	S_OFFICER_DTH1
		dc.l	S_OFFICER_DTH2
		dc.l	S_OFFICER_DTH3
		dc.l	S_AMMO,0

SchabbsSpr	dc.l	S_SCHABBS_ATK1
		dc.l	S_SCHABBS_ATK2
		dc.l	S_SCHABBS_WLK1
		dc.l	S_SCHABBS_WLK2
		dc.l	S_SCHABBS_WLK3
		dc.l	S_SCHABBS_WLK4
		dc.l	S_SCHABBS_DTH1
		dc.l	S_SCHABBS_DTH2
		dc.l	S_SCHABBS_DTH3
		dc.l	S_G_KEY,0

SSSprs		dc.l	S_SS_ATK1
		dc.l	S_SS_ATK2
		dc.l	S_SS_ATK3
		dc.l	S_SS_WLK1
		dc.l	S_SS_WLK2
		dc.l	S_SS_WLK3
		dc.l	S_SS_WLK4
		dc.l	S_SS_PAIN
		dc.l	S_SS_DTH1
		dc.l	S_SS_DTH2
		dc.l	S_SS_DTH3
		dc.l	S_MACHINEGUN
		dc.l	S_AMMO,0

TransSprs	dc.l	S_TRANS_ATK1
		dc.l	S_TRANS_ATK2
		dc.l	S_TRANS_ATK3
		dc.l	S_TRANS_WLK1
		dc.l	S_TRANS_WLK2
		dc.l	S_TRANS_WLK3
		dc.l	S_TRANS_WLK4
		dc.l	S_TRANS_DTH1
		dc.l	S_TRANS_DTH2
		dc.l	S_TRANS_DTH3
		dc.l	S_G_KEY,0



EnemySprs	dc.l	NaziSprs		; This list MUST match class_t!
		dc.l	OfficerSprs
		dc.l	SSSprs
		dc.l	DogSprs
		dc.l	MutantSprs
		dc.l	HansSprs
		dc.l	SchabbsSpr
		dc.l	TransSprs
		dc.l	UberSprs
		dc.l	DKnightSprs
		dc.l	HitlerSprs
		dc.l	HitlerSprs

S_DKNIGHT_ATK1
S_DKNIGHT_ATK2
S_DKNIGHT_ATK3
S_DKNIGHT_ATK4
S_DKNIGHT_WLK1
S_DKNIGHT_WLK2
S_DKNIGHT_WLK3
S_DKNIGHT_WLK4
S_DKNIGHT_DTH1
S_DKNIGHT_DTH2
S_DKNIGHT_DTH3

S_DOG_ATK1
S_DOG_ATK2
S_DOG_ATK3
S_DOG_WLK1
S_DOG_WLK2
S_DOG_WLK3
S_DOG_WLK4
S_DOG_DTH1
S_DOG_DTH2
S_DOG_DTH3

S_GUARD_ATK1	incbin	'temp\sprites\34.raw'
S_GUARD_ATK2	incbin	'temp\sprites\35.raw'
S_GUARD_ATK3	incbin	'temp\sprites\36.raw'
S_GUARD_WLK1	incbin	'temp\sprites\37.raw'
S_GUARD_WLK2	incbin	'temp\sprites\38.raw'
S_GUARD_WLK3	incbin	'temp\sprites\39.raw'
S_GUARD_WLK4	incbin	'temp\sprites\40.raw'
S_GUARD_PAIN	incbin	'temp\sprites\41.raw'
S_GUARD_DTH1	incbin	'temp\sprites\42.raw'
S_GUARD_DTH2	incbin	'temp\sprites\43.raw'
S_GUARD_DTH3	incbin	'temp\sprites\44.raw'

S_HANS_ATK1
S_HANS_ATK2
S_HANS_ATK3
S_HANS_WLK1
S_HANS_WLK2
S_HANS_WLK3
S_HANS_WLK4
S_HANS_DTH1
S_HANS_DTH2
S_HANS_DTH3

S_HITLER_ATK1
S_HITLER_ATK2
S_HITLER_ATK3
S_HITLER_WLK1
S_HITLER_WLK2
S_HITLER_WLK3
S_HITLER_WLK4
S_HITLER_DTH1
S_HITLER_DTH2
S_HITLER_DTH3
S_MHITLER_ATK1
S_MHITLER_ATK2
S_MHITLER_ATK3
S_MHITLER_DIE1
S_MHITLER_DIE2
S_MHITLER_DIE3
S_MHITLER_DIE4
S_MHITLER_WLK1
S_MHITLER_WLK2
S_MHITLER_WLK3
S_MHITLER_WLK4

S_UBER_ATK1
S_UBER_ATK2
S_UBER_ATK3
S_UBER_ATK4
S_UBER_WLK1
S_UBER_WLK2
S_UBER_WLK3
S_UBER_WLK4
S_UBER_DTH1
S_UBER_DTH2
S_UBER_DTH3

S_MUTANT_ATK1
S_MUTANT_ATK2
S_MUTANT_ATK3
S_MUTANT_WLK1
S_MUTANT_WLK2
S_MUTANT_WLK3
S_MUTANT_WLK4
S_MUTANT_PAIN
S_MUTANT_DTH1
S_MUTANT_DTH2
S_MUTANT_DTH3

S_OFFICER_ATK1
S_OFFICER_ATK2
S_OFFICER_ATK3
S_OFFICER_WLK1
S_OFFICER_WLK2
S_OFFICER_WLK3
S_OFFICER_WLK4
S_OFFICER_PAIN
S_OFFICER_DTH1
S_OFFICER_DTH2
S_OFFICER_DTH3

S_SCHABBS_ATK1
S_SCHABBS_ATK2
S_SCHABBS_WLK1
S_SCHABBS_WLK2
S_SCHABBS_WLK3
S_SCHABBS_WLK4
S_SCHABBS_DTH1
S_SCHABBS_DTH2
S_SCHABBS_DTH3

S_SS_ATK1
S_SS_ATK2
S_SS_ATK3
S_SS_WLK1
S_SS_WLK2
S_SS_WLK3
S_SS_WLK4
S_SS_PAIN
S_SS_DTH1
S_SS_DTH2
S_SS_DTH3

S_TRANS_ATK1
S_TRANS_ATK2
S_TRANS_ATK3
S_TRANS_WLK1
S_TRANS_WLK2
S_TRANS_WLK3
S_TRANS_WLK4
S_TRANS_DTH1
S_TRANS_DTH2
S_TRANS_DTH3


		; List of static sprites
StaticArt	dc.l	S_WATER_PUDDLE
		dc.l	S_GREEN_BARREL
		dc.l	S_CHAIR_TABLE
		dc.l	S_FLOOR_LAMP
		dc.l	S_CHANDELIER
		dc.l	S_DOG_FOOD
		dc.l	S_COLUMN
		dc.l	S_POTTED_TREE
		dc.l	S_FLAG
		dc.l	S_POTTED_PLANT
		dc.l	S_BLUE_POT
		dc.l	S_DEBRIS1
		dc.l	S_LIGHT
		dc.l	S_BUCKET
		dc.l	S_ARMOUR
		dc.l	S_CAGE
		dc.l	S_G_KEY
		dc.l	S_S_KEY
		dc.l	S_BANDOLIER
		dc.l	S_AMMOCASE
		dc.l	S_FOOD
		dc.l	S_HEALTH
		dc.l	S_AMMO
		dc.l	S_MACHINEGUN
		dc.l	S_CHAINGUN
		dc.l	S_CROSS
		dc.l	S_CHALICE
		dc.l	S_CHEST
		dc.l	S_CROWN
		dc.l	S_ONEUP
		dc.l	S_WOOD_BARREL
		dc.l	S_WATER_WELL
		dc.l	S_FLAMETHROWER 
		dc.l	S_GASCAN
		dc.l	S_LAUNCHER
		dc.l	S_MISSILES

		** temp!!
S_WATER_PUDDLE	incbin	'temp\statics\139.lz'
S_GREEN_BARREL	incbin	'temp\statics\140.lz'
S_CHAIR_TABLE	incbin	'temp\statics\141.lz'
S_FLOOR_LAMP	incbin	'temp\statics\142.lz'
S_CHANDELIER	incbin	'temp\statics\143.lz'
S_DOG_FOOD	incbin	'temp\statics\144.lz'
S_COLUMN	incbin	'temp\statics\145.lz'
S_POTTED_TREE	incbin	'temp\statics\146.lz'
S_FLAG		incbin	'temp\statics\147.lz'
S_POTTED_PLANT	incbin	'temp\statics\148.lz'
S_BLUE_POT	incbin	'temp\statics\149.lz'
S_DEBRIS1	incbin	'temp\statics\150.lz'
S_LIGHT		incbin	'temp\statics\151.lz'
S_BUCKET	incbin	'temp\statics\152.lz'
S_ARMOUR	incbin	'temp\statics\153.lz'
S_CAGE		incbin	'temp\statics\154.lz'
S_G_KEY		incbin	'temp\statics\155.lz'
S_S_KEY		incbin	'temp\statics\156.lz'
S_BANDOLIER	incbin	'temp\statics\157.lz'
S_AMMOCASE	incbin	'temp\statics\158.lz'
S_FOOD		incbin	'temp\statics\159.lz'
S_HEALTH	incbin	'temp\statics\160.lz'
S_AMMO		incbin	'temp\statics\161.lz'
S_MACHINEGUN	incbin	'temp\statics\162.lz'
S_CHAINGUN	incbin	'temp\statics\163.lz'
S_CROSS		incbin	'temp\statics\164.lz'
S_CHALICE	incbin	'temp\statics\165.lz'
S_CHEST		incbin	'temp\statics\166.lz'
S_CROWN		incbin	'temp\statics\167.lz'
S_ONEUP		incbin	'temp\statics\168.lz'
S_WOOD_BARREL	incbin	'temp\statics\169.lz'
S_WATER_WELL	incbin	'temp\statics\170.lz'
S_FLAMETHROWER 	incbin	'temp\statics\171.lz'
S_GASCAN	incbin	'temp\statics\172.lz'
S_LAUNCHER	incbin	'temp\statics\173.lz'
S_MISSILES	incbin	'temp\statics\174.lz'
		even


		; List of wall shapes
		section	data
WallArt		dc.l	._01
		dc.l	._02
		dc.l	._03
		dc.l	._04
		dc.l	._05
		dc.l	._06
		dc.l	._07
		dc.l	._08
		dc.l	._09
		dc.l	._10
		dc.l	._11
		dc.l	._12
		dc.l	._13
		dc.l	._14
		dc.l	._15
		dc.l	._16
		dc.l	._17
		dc.l	._18
		dc.l	._19
		dc.l	._20
		dc.l	._21
		dc.l	._22
		dc.l	._23
		dc.l	._24
		dc.l	._25
		dc.l	._26
		dc.l	._27
		dc.l	._28
		dc.l	._29
		dc.l	._30
		dc.l	._31
		dc.l	._32
		dc.l	._33
		dc.l	._34
		dc.l	._35
		dc.l	._36
		dc.l	._37
		dc.l	._38

		** temp
._01		incbin	'temp\walls\01.lz'
._02		incbin	'temp\walls\02.lz'
._03		incbin	'temp\walls\03.lz'
._04		incbin	'temp\walls\04.lz'
._05		incbin	'temp\walls\05.lz'
._06		incbin	'temp\walls\06.lz'
._07		incbin	'temp\walls\07.lz'
._08		incbin	'temp\walls\08.lz'
._09		incbin	'temp\walls\09.lz'
._10		incbin	'temp\walls\10.lz'
._11		incbin	'temp\walls\11.lz'
._12		incbin	'temp\walls\12.lz'
._13		incbin	'temp\walls\13.lz'
._14		incbin	'temp\walls\14.lz'
._15		incbin	'temp\walls\15.lz'
._16		incbin	'temp\walls\16.lz'
._17		incbin	'temp\walls\17.lz'
._18		incbin	'temp\walls\18.lz'
._19		incbin	'temp\walls\19.lz'
._20		incbin	'temp\walls\20.lz'
._21		incbin	'temp\walls\21.lz'
._22		incbin	'temp\walls\22.lz'
._23		incbin	'temp\walls\23.lz'
._24		incbin	'temp\walls\24.lz'
._25		incbin	'temp\walls\25.lz'
._26		incbin	'temp\walls\26.lz'
._27		incbin	'temp\walls\27.lz'
._28		incbin	'temp\walls\28.lz'
._29		incbin	'temp\walls\29.lz'
._30		incbin	'temp\walls\30.lz'
._31		incbin	'temp\walls\31.lz'
._32		incbin	'temp\walls\32.lz'
._33		incbin	'temp\walls\33.lz'
._34		incbin	'temp\walls\34.lz'
._35		incbin	'temp\walls\35.lz'
._36		incbin	'temp\walls\36.lz'
._37		incbin	'temp\walls\37.lz'
._38		incbin	'temp\walls\38.lz'



		rsreset
mtilemap	rs.b	64*64
mareasndnum	rs.b	64
mnumspawn	rs.w	1	; Must be short
mspawnlistofs	rs.w	1	; Must be short
mnumnodes	rs.w	1	; Must be short
nodelistofs	rs.w	1	; Must be short
loadmap_t	=	__RS


***********************************
*
*  void SpawnStatic(d0.w x, d1.w y, d2.l shapenum)
*
* Spawn a static object at x,y
*
***********************************
		section	text
NumStatics	dc.w	-1		; Number of statics-1

SpawnStatic	move.w	NumStatics(pc),d3

		cmpi.w	#MAXSTATICS-1,d3; Oh oh!!
		beq.s	.break
		
		lea.l	Statics,a6	; Get the static record
		addq.w	#1,d3
		mulu.w	#thing_t,d3
		adda.w	d3,a6
		movea.l	a6,a5		; Save the pointer

		clr.b	(a6)+

		subi.b	#23,d2		; Get the shapenum
		moveq.l	#1<<TI_THING,d3
		move.b	.staticflags(pc,d2.l),d4
		or.b	d4,d3
		move.b	d3,(a6)+	; Set the attributes


		move.l	d2,(a6)+	; Store shape index

		moveq.l	#$80,d3
		move.b	d0,(a6)+	; Set the pixel x, y
		move.b	d3,(a6)+
		move.b	d1,(a6)+
		move.b	d3,(a6)+

		; Inform the rendering engine about a static here
		lea.l	Tilemap,a6
		lsl.w	#6,d0
		add.b	d1,d0
		adda.w	d0,a6

		btst.l	#TI_GETABLE,d4	; Is this a bonus item?
		beq.s	.no_bonus
		bset.b	#TI_GETABLE,64*64(a6)

.no_bonus	addq.b	#1,(a6)			; Tilemap[tile] = 1
		bset.b	#TI_THING,64*64(a6)	; Actorat[tile] |= 1<<TI_THING
		
		lea.l	Actors,a6	; Actors[tile] = ThingPtr
		add.w	d0,d0
		add.w	d0,d0
		adda.w	d0,a6
		move.l	a5,(a6)
		

	ifeq	1
		shape += S_WATER_PUDDLE;	/* Init the shape number */
		WallHits[shape] = 1;		/* Load in this shape */
		StatPtr->pic = shape;		/* Set the object's shape */
		switch (shape) {
		case S_CROSS:
		case S_CHALICE:
		case S_CHEST:
		case S_CROWN:
		case S_ONEUP:
		++gamestate.treasuretotal;	/* Mark this as treasure */
		}
	endc

		addq.w	#1,NumStatics	; I have one more item

		move.l	d2,d1		; Force the shape to load
		bra.w	LoadStaticShape

.break		rts


.staticflags	dc.b	0		; S_WATER_PUDDLE
		dc.b	1<<TI_BLOCKMOVE	; S_GREEN_BARREL
		dc.b	1<<TI_BLOCKMOVE	; S_CHAIR_TABLE
		dc.b	1<<TI_BLOCKMOVE	; S_FLOOR_LAMP
		dc.b	0		; S_CHANDELIER
		dc.b	1<<TI_GETABLE	; S_DOG_FOOD
		dc.b	1<<TI_BLOCKMOVE	; S_COLUMN
		dc.b	1<<TI_BLOCKMOVE	; S_POTTED_TREE

		dc.b	1<<TI_BLOCKMOVE	; S_FLAG
		dc.b	1<<TI_BLOCKMOVE	; S_POTTED_PLANT
		dc.b	1<<TI_BLOCKMOVE	; S_BLUE_POT
		dc.b	0		; S_DEBRIS1
		dc.b	0		; S_LIGHT
		dc.b	0		; S_BUCKET
		dc.b	1<<TI_BLOCKMOVE	; S_ARMOUR
		dc.b	1<<TI_BLOCKMOVE	; S_CAGE

		dc.b	1<<TI_GETABLE	; S_G_KEY
		dc.b	1<<TI_GETABLE	; S_S_KEY
		dc.b	1<<TI_GETABLE	; S_BANDOLIER
		dc.b	1<<TI_GETABLE	; S_AMMOCASE
		dc.b	1<<TI_GETABLE	; S_FOOD
		dc.b	1<<TI_GETABLE	; S_HEALTH
		dc.b	1<<TI_GETABLE	; S_AMMO
		dc.b	1<<TI_GETABLE	; S_MACHINEGUN

		dc.b	1<<TI_GETABLE	; S_CHAINGUN
		dc.b	1<<TI_GETABLE	; S_CROSS
		dc.b	1<<TI_GETABLE	; S_CHALICE
		dc.b	1<<TI_GETABLE	; S_CHEST
		dc.b	1<<TI_GETABLE	; S_CROWN
		dc.b	1<<TI_GETABLE	; S_ONEUP
		dc.b	1<<TI_BLOCKMOVE	; S_WOOD_BARREL
		dc.b	1<<TI_BLOCKMOVE	; S_WATER_WELL
		dc.b	1<<TI_GETABLE	; S_FLAMETHROWER 
		dc.b	1<<TI_GETABLE	; S_GASCAN
		dc.b	1<<TI_GETABLE	; S_LAUNCHER
		dc.b	1<<TI_GETABLE	; S_MISSILES
		even


		section	bss
Actors		ds.l	4096		; List of actor pointers
Statics		ds.b	MAXSTATICS*thing_t


***********************************
*
*  void SpawnPlayer(d0.b x,d1.b y,d2.b dir)
*
* Spawn the player at x,y
*
***********************************
		section	text
SpawnPlayer	subi.b	#19,d2		; Get the basic viewing angle
		ext.w	d2
		mulu.w	#ANGLES/4,d2
		addi.w	#40,d2		** Temporary workaroung, fix the trig tables!!
		move.w	d2,gamestate.viewangle 

		lea.l	player.x,a6
		lsl.w	#8,d0
		move.b	#$80,d0
		lsl.w	#8,d1
		move.b	#$80,d1

		move.w	d0,(a6)+	; Save the x, y coords
		move.w	d1,(a6)
		rts

***********************************
*
*  void SpawnDoor(d0.w x, d1.w y, d2.b type)
*
* Spawn a door at the specified x,y
*
***********************************

SpawnDoor	move.w	numdoors(pc),d3

		cmpi.w	#MAXDOORS-1,d3	; Too many doors?
		beq.s	.break

		lea.l	Tilemap,a5
		lsl.w	#6,d0
		add.b	d1,d0
		adda.w	d0,a5

		addq.w	#1,d3
		moveq.l	#1<<TI_DOOR,d4	; Mask in doorflag and door number
		or.b	d3,d4	
		move.b	d4,(a5)
		ori.b	#(1<<TI_BLOCKMOVE)|(1<<TI_BLOCKSIGHT),64*64(a5)

		lea.l	doors,a6	; Pointer to door record
		lsl.w	#3,d3
		adda.w	d3,a6

		move.w	#DR_CLOSED<<8,(a6)+	; Doors start out fully closed
		clr.w	(a6)+		; ticcount
		move.w	d0,(a6)+	; tile
		subi.b	#90,d2
		lsr.b	d2		; Set the door slider

		bcc.s	.vertical

		bset.b	#TI_DOORSIDE,1(a5)
		bset.b	#TI_DOORSIDE,-1(a5)
		bra.s	.continue

.vertical	bset.b	#TI_DOORSIDE,64(a5)
		bset.b	#TI_DOORSIDE,-64(a5)

.continue	move.b	d2,1(a6)	; Set the door type

		addq.w	#1,numdoors
.break		rts


***********************************
*
*  void SpawnPushwall(d0.w x, d1.w y)
*
* Spawn a pushwall at the specified x,y
*
***********************************

SpawnPushwall	lea.l	Tilemap,a6	; Get the tile
		lsl.w	#6,d0
		add.b	d1,d0
		adda.w	d0,a6
		ori.b	#(1<<TI_BLOCKMOVE)|(1<<TI_BLOCKSIGHT)|(1<<TI_PUSHWALL),64*64(a6)

	ifeq	1
		; Secret area!
		addq.w	#1,gamestate.secrettotal
	endc

		; Set the texture (search in the 4 surrounding tiles)
		tst.b	1(a6)
		beq.s	.vertical
		tst.b	-1(a6)
		beq.s	.vertical

		move.b	2*64(a6),d2
		beq.s	.next_h
		move.b	d2,(a6)
		rts

.next_h		move.b	-2*64(a6),(a6)
		rts

.vertical	move.b	2(a6),d2
		beq.s	.next_v
		move.b	d2,(a6)
		rts

.next_v		move.b	-2(a6),(a6)
		rts

	ifeq	1
/**********************************

	Spawn an elevator at the specified x,y

**********************************/

void SpawnElevator(Word x,Word y)
{
	elevatorx = x;	/* for easy mode cheating*/
	elevatory = y;
	tilemap[y][x] |= TI_BLOCKMOVE | TI_SWITCH;
}

/**********************************

	Spawn the outside at the specified x,y

**********************************/

void SpawnOut(Word x,Word y)
{
	/*tilemap[y][x] |= TI_BLOCKMOVE | TI_SWITCH;*/
}

/**********************************

	Spawn a secret item at the specified x,y

**********************************/

void SpawnSecret(Word x,Word y)
{
	tilemap[y][x] |= TI_BLOCKMOVE | TI_SECRET;
}
	endc


***********************************
*
*  void SpawnStand(d0.w x,d1.w y,d2.l class_t which)
*
* Spawn an actor at a specific x,y
*
***********************************

NumActors	dc.w	-1	; Number of actors-1

SpawnStand	move.w	NumActors(pc),d3

		cmpi.w	#MAXACTORS-1,d3	; Too many actors already?
		beq.s	.break		; Exit
	
	ifeq	1
	EnemyHits[which] = 1;
	info = &classinfo[which];	/* Get the pointer to the basic info */
	state = info->standstate;	/* Get the state logic value */
	ActorPtr = &actors[numactors];	/* Get the pointer to the new actor entry */
	TilePtr = &tilemap[y][x];	/* Pointer to the current tile */
	tile = TilePtr[0];			/* What's in the tile? */
	endc

		lea.l	ActorList+actor_t,a5	; Choose the actor record
		mulu.w	#actor_t,d3
		adda.l	d3,a5
		movea.l	a5,a4

		** temporary **
		move.w	#1<<TI_BLOCKMOVE|1<<TI_ACTOR,(a5)+
		move.l	#S_GUARD_ATK1,(a5)+

		moveq.l	#$80,d3		; Init the x and y
		move.b	d0,(a5)+
		move.b	d3,(a5)+
		move.b	d1,(a5)+
		move.b	d3,(a5)+
		addq.l	#4,a5

		clr.w	(a5)+		; Time before motion
		move.l	#CL_GUARD,(a5)+	; Actor class
		move.w	#ST_GRD_STND,(a5)+	; Initial state
		move.w	#$ff,(a5)+	; Direction

		addq.w	#6,a5
		move.w	#100,(a5)	; Time in tics before motion
		**

		addq.w	#1,NumActors	; I now add one more actor to the list

	ifeq	1
	ActorPtr->pic = states[state].shapenum;	/* What picture to display? */
	ActorPtr->ticcount = states[state].tictime;	/* Initial tick count */
	ActorPtr->state = state;
	ActorPtr->flags = FL_SHOOTABLE | FL_NOTMOVING;	/* You can shoot it */
	ActorPtr->distance = 0;			/* No distance to travel */
	ActorPtr->dir = nodir;				/* No direction of travel */
	ActorPtr->areanumber = tile&TI_NUMMASK;	/* Area in */
	ActorPtr->reacttime = 0;	/* Reaction time */
	TilePtr[0] = tile | TI_ACTOR;	/* Mark as a bad guy */
	MapPtr->tilemap[y][x] = numactors;	/* Save the actor # */
	ActorPtr->class = which;	/* Actor type */

	ActorPtr->speed = info->speed;	/* Basic speed */
	ActorPtr->hitpoints = info->hitpoints;	/* Starting hit points */
	++gamestate.killtotal;		/* Another critter must die! */
	endc

		lea.l	Tilemap,a6	; Inform the rendering engine about the actor
		lsl.w	#6,d0
		add.b	d1,d0
		adda.w	d0,a6

		addq.b	#1,(a6)			; Tilemap[x][y] = 1
		bset.b	#TI_THING,64*64(a6)	; Actorat[x][y] |= 1<<TI_THING

		lea.l	Actors,a6	; Actors[x][y] = &Actor
		lsl.w	#2,d0
		move.l	a4,(a6,d0.w)
.break		rts

		section	bss
ActorList	ds.b	MAXACTORS*actor_t	; List of thinking actors


***********************************
*
*  void SpawnThings(a0.l *Map)
*
* Spawn all actors and mark down special places
* A spawn record is (x,y,type)
*	
***********************************
		section	text
SpawnThings	*memset(EnemyHits,0,sizeof(EnemyHits));

		; Point to spawn table

		move.w	mnumspawn(a0),d7
		subq.w	#1,d7		; Any items to spawn?
		bmi.s	.break

		adda.w	mspawnlistofs(a0),a0

.spawnloop	moveq.l	#0,d0
		moveq.l	#0,d1
		move.b	(a0)+,d1	; Get the x
		moveq.l	#63,d0		; Get the y
		sub.b	(a0)+,d0
		move.b	(a0)+,d2	; Get the type

		cmpi.b	#19,d2		; No item / <19
		blo.s	.continue

		cmpi.b	#22,d2		; Player / 19-22
		bhi.s	.no_player
		bsr.w	SpawnPlayer
		bra.s	.continue

.no_player	cmpi.b	#58,d2		; Static / 23-58
		bhi.s	.no_static

		bsr.w	SpawnStatic
		bra.s	.continue

.no_static	cmpi.b	#90,d2		; No item / 59-89
		blo.s	.continue

		cmpi.b	#97,d2		; Door / 90-97
		bhi.s	.no_door
		bsr.w	SpawnDoor
		bra.s	.continue

.no_door	cmpi.b	#98,d2		; Pushwall / 98
		bne.s	.no_pushwall
		bsr.w	SpawnPushwall
		addq.l	#1,a0

.no_pushwall
	ifeq	1
		} else if (type == 99) {	/* 99 */
			SpawnOut(x,y);
		} else if (type == 100) {	/* 100 */
			SpawnElevator(x,y);
		} else if (type == 101) {	/* 101 */
			SpawnSecret(x,y);
		} else if (type<108) {		/* 102-107 */
			continue;
	endc	
		cmpi.w	#108,d2	****
		blo.s	.no_stand **
		cmpi.w	#123,d2		; Actor / 108-123
		bhi.s	.no_stand
		
		subi.b	#108,d2
		bsr.w	SpawnStand
		bra.s	.continue
.no_stand
	ifeq	1

		} else if (type<126) {		/* 123-125 */
			continue;
		} else if (type<140) {		/* 126-139 */
			SpawnAmbush(x,y,(class_t) (type-126));	
		}
	endc
.continue	dbra	d7,.spawnloop

	ifeq	1
	Count = 0;
	do {
		if (EnemyHits[Count]) {
			x = 0;
			EnemyPtr = EnemySprs[Count];
			do {
				WallHits[EnemyPtr[x]] = 1;
				++x;
			} while (EnemyPtr[x]);
		}
	} while (++Count<16);
	endc
.break		rts


	ifeq	0
*************************************
*
*  void LoadStaticShape(d1.w index)
*
* Load in a single sprite shape
*
* **Load from disk later on!!**
*************************************

LoadStaticShape	moveq.l	#0,d2
		move.w	StaticArtCount(pc),d2

		lea.l	WallHits,a1	; Build translation table
		adda.w	d1,a1
		tst.b	(a1)		; Has this shape occured yet?
		bne.s	.break		; Yes, so skip it

		addq.w	#1,StaticArtCount
		move.b	d2,(a1)

		lea.l	StaticArtIndex,a2	; Store shape pointer
		lsl.w	#2,d2
		adda.w	d2,a2

		lea.l	StaticArtBuffer,a1	; *dest = StaticArtBuffer[count*4096] **use malloc() later on!!**
		moveq.l	#10,d3
		lsl.l	d3,d2
		adda.l	d2,a1
		move.l	a1,(a2)

		move.l	a0,-(sp)
		lea.l	StaticArt,a0	; *source = StaticArt[index]
		lsl.w	#2,d1
		movea.l	(a0,d1.w),a0

		bsr.w	d_lz77		; Expand shape
		movea.l	(sp)+,a0

.break		rts

StaticArtCount	dc.w	0		; Number of shapes used by the current stage
		even

		section	bss
StaticArtIndex	ds.l	36
StaticArtBuffer	ds.b	36*4096		** temporary, use malloc() later on!!**
	endc



*************************************
*
*  void LoadWallShape(d1.w index)
*
* Load in a single wall shape
*
* **Load from disk later on!!**
*************************************
		section	text
LoadWallShape	moveq.l	#0,d2
		move.w	WallArtCount(pc),d2

		lea.l	WallHits,a1	; Build translation table
		tst.b	-1(a1,d1.w)	; Has this shape occured yet?
		bne.s	.break		; Yes, so skip it

		addq.w	#1,WallArtCount	; Count number of walls loaded in yet
		move.b	d2,-1(a1,d1.w)

		lea.l	WallArtIndex-4,a2	; Store shape pointer
		lsl.w	#2,d2
		adda.w	d2,a2

		lea.l	WallArtBuffer-4096,a1	; *dest = WallArtBuffer[count*4096] **use malloc() later on!!**
		moveq.l	#10,d3
		lsl.l	d3,d2
		adda.l	d2,a1
		move.l	a1,(a2)
		
		lea.l	WallArt,a0	; *source = WallArt[index]
		lsl.w	#2,d1
		movea.l	-4(a0,d1.w),a0

		bra.w	d_lz77		; Expand shape
.break		rts

WallArtCount	dc.w	1		; Number of shapes used by the current stage


		section	bss
WallHits	ds.b	256		; Wall index translation table

WallArtIndex	ds.l	38
WallArtBuffer	ds.b	38*4096		** temporary, use malloc() later on!!**