************************************************
*	 THE 3D VECTORS SCREEN 19-3-90
************************************************

*	CLR.L -(SP)
*	MOVE.W #$20,-(SP)
*	TRAP #1
*	ADD.L #6,SP
*	
	MOVE.L A7,OLDSSP
	LEA MYSTACK,A7

	MOVEQ #$12,D0
	BSR IKBD
	MOVEQ #$1A,D0
	BSR IKBD
	LEA    $70000,A0		CLEARSCREEN(S)
	MOVE.W #$4000,D0
CLLOOP1	CLR.L (A0)+
	DBF D0,CLLOOP1
	MOVEM.L PALETTE,D0-D7
	MOVEM.L D0-D7,$FFFF8240.W
	MOVEQ #2,D0
	JSR MUSIC
	JSR HBLON
	BSR DO_POINTS
	BSR MAKEUPSTARS

MAINLOOP
	MOVE.L #$70000,D0
	MOVE.L #$70000,LOGBASE
	LSR.W #8,D0
	MOVE.L D0,$FFFF8200.W
	BSR ERASE_BIT
	MOVE.L #OLDSTARS,OLDSTARPOINT
	BSR ERASESUB			ERASE STARS SUBROUTINE
	BSR STARSSUB			DRAW STARS ROUTINE
	BSR DO_SCROLL
	BSR PLOTSHAPE

VBLOOP	TST.W VBLIND
	BEQ.S VBLOOP
	CLR.W VBLIND

	MOVE.L #$78000,D0
	MOVE.L #$78000,LOGBASE
	LSR.W #8,D0
	MOVE.L D0,$FFFF8200.W

	BSR ERASE_BIT
	MOVE.L #OLDSTARS1,OLDSTARPOINT
	BSR ERASESUB			ERASE STARS SUBROUTINE
	BSR STARSSUB			DRAW STARS ROUTINE
	BSR DO_SCROLL1
	BSR PLOTSHAPE


VBLOOP1	TST.W VBLIND
	BEQ.S VBLOOP1
	CLR.W VBLIND

	CMP.B #$39,KBUFF
	BEQ QUIT
	BRA MAINLOOP


**********************************
* STANDARD TIMER ROUTINES AND KEY VECTOR
**********************************

QUIT
	MOVE.W #$2700,SR
	MOVE.L OLDSSP,A7
	JSR HBLOFF
	LEA $FFFF8800.W,A1
	MOVE.L #$8080000,(A1)
	MOVE.L #$9090000,(A1)
	MOVE.L #$A0A0000,(A1)
	MOVE.W #$2300,SR
	MOVEQ #$16,D0
	BSR IKBD
	MOVEQ #$8,D0
	BSR IKBD
	RTS

*	MOVE.W #$300,SR
*	CLR.W -(SP)
*	TRAP #1

HBLON
	MOVE.L $FFFF8200.W,OLDPHYS
	MOVE.L $120.W,OLDTB		SAVE INTERRUPTS
	MOVE.L $70.W,OLDVBL
	MOVE.L $118.W,OLDKEY
	MOVE.B $FFFFFA07.W,OLD07
	MOVE.B $FFFFFA09.W,OLD09
	MOVE.B $FFFFFA0F.W,OLD0F
	MOVE.B $FFFFFA11.W,OLD11
	MOVE.B $FFFFFA1B.W,OLD1B
	AND.B #$DF,$FFFFFA09.W		THEN SET UP OURS
	AND.B #$FE,$FFFFFA07.W
	MOVE.L #NEWTB2,$120.W
	MOVE.L #VBL,$70.W
	OR.B #1,$FFFFFA07.W
	OR.B #1,$FFFFFA13.W
	BCLR #6,$FFFFFA09.W			PUT IN OUR NEW 
	MOVE.L #KEYVECTOR,$118.W		KEY VECTOR
	BSET #6,$FFFFFA09.W
	RTS

HBLOFF	MOVE.W SR,-(SP)			TAKE OUT ALL OF OUR INTS
	MOVE.W #$2700,SR
	MOVE.B OLD07,$FFFFFA07.W
	MOVE.B OLD09,$FFFFFA09.W
	MOVE.B OLD0F,$FFFFFA0F.W
	MOVE.B OLD11,$FFFFFA11.W
	MOVE.B OLD1B,$FFFFFA1B.W
	MOVE.L OLDTB,$120.W
	MOVE.L OLDVBL,$70.W
	MOVE.L OLDKEY,$118.W
	MOVE.L OLDPHYS,$FFFF8200.W
	MOVE.W (SP)+,SR
	RTS


IKBD	LEA $FFFFFC00.W,A1
IKLOOP	MOVE.B (A1),D1
	BTST #1,D1
	BEQ.S IKLOOP
	MOVE.B D0,2(A1)
	RTS

KEYVECTOR			*THE NEW KEY VECTOR
	MOVE.W D2,-(SP)
	MOVE.B $FFFFFC00.W,D2
	BTST #7,D2
	BEQ.S	VECTOREND
	MOVE.B $FFFFFC02.W,D2
	MOVE.B D2,KBUFF
	BCLR #6,$FFFFFA11.W
VECTOREND
	MOVE.W (SP)+,D2
	RTE

VBL
	MOVEM.L D0-D7/A0-A6,-(A7)
	CLR.B $FFFFFA1B.W
	MOVE.B #8,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	JSR MUSIC+8
	MOVEM.L (A7)+,D0-D7/A0-A6
	MOVE.L #NEWTB2,$120.W
	LEA COLTAB(PC),A6
	ST VBLIND
	RTE

VBLIND	DC.W 0

NEWTB2	
	MOVE.W (A6),$FFFF8250.W
	MOVE.W (A6),$FFFF8254.W
	MOVE.W (A6),$FFFF8258.W
	MOVE.W (A6)+,$FFFF825C.W
	BCLR #0,$FFFFFA0F.W
	RTE

	
COLTAB
	DC.W $005,$006,$007,$017,$027,$037,$047,$057,$047,$037
	DC.W $027,$017,$007,$107,$207,$307,$407,$507,$407,$307,$207
	DC.W $107,$007,$006,$005,$004,$003,$002,$001,$000


LOGBASE	DC.L 0
OLDSSP	DC.L 0				ALL THE VARIOUS
OLDPHYS	DC.L 0				THINGS TO BE SAVED
OLDVBL	DC.L 0
OLDTB	DC.L 0
OLDKEY	DC.L 0
KBUFF	DC.W 0
OLD07	DC.B 0
OLD09	DC.B 0
OLD0F	DC.B 0
OLD11	DC.B 0
OLD1B   DC.B 0
	even
	DS.L 100
MYSTACK

*****************************
* THIS ERASE ROUTINE ERASES ONLY EXACTLY THE AREA
* COVERED BY THE SIGN SO IT IS 100% OPTIMIZED
******************************

ERASE_BIT
	MOVE.L LOGBASE(PC),A0
	LEA 3840(A0),A0
	MOVEQ #0,D0

ADDIT	SET 0
	REPT 2
	MOVE.W D0,ADDIT+80(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 4
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 7
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 31
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 17
	MOVE.W D0,ADDIT+48(A0)
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 4
	MOVE.W D0,ADDIT+48(A0)
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 5
	MOVE.W D0,ADDIT+48(A0)
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 13
	MOVE.W D0,ADDIT+48(A0)
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
	MOVE.W D0,ADDIT+112(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 4
	MOVE.W D0,ADDIT+48(A0)
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
	MOVE.W D0,ADDIT+112(A0)
	MOVE.W D0,ADDIT+120(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 20
	MOVE.W D0,ADDIT+56(A0)
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
	MOVE.W D0,ADDIT+112(A0)
	MOVE.W D0,ADDIT+120(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 5
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
	MOVE.W D0,ADDIT+112(A0)
	MOVE.W D0,ADDIT+120(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 20
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
	MOVE.W D0,ADDIT+112(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 4
	MOVE.W D0,ADDIT+64(A0)
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 8
	MOVE.W D0,ADDIT+72(A0)
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 2
	MOVE.W D0,ADDIT+80(A0)
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
	MOVE.W D0,ADDIT+104(A0)
ADDIT	SET 	ADDIT+160
	ENDR
	REPT 3
	MOVE.W D0,ADDIT+88(A0)
	MOVE.W D0,ADDIT+96(A0)
ADDIT	SET 	ADDIT+160
	ENDR

	RTS

 
	
*****************************************************	
*	THIS IS THE COORDINATE CALCULATION ROUTINE
*****************************************************

DO_POINTS
*******************************
* MAKE UP MATRIX
*******************************
		MOVE.L #COORDATA,STORE_AT
		
DO_IT
		MOVE.L TRACKPOINT(PC),A2
		MOVE.W (A2)+,XANGLE
		MOVE.W (A2)+,YANGLE
		MOVE.W (A2)+,ZANGLE
		MOVE.W (A2)+,ZOFF
		MOVE.L A2,TRACKPOINT

		LEA TRIGBUFF(PC),A2	
		LEA SINTAB(PC),A0	sine table
		LEA 180(A0),A1		cos=sin+90 deg
		MOVEM.W ANGLETABLE(PC),D0-D2    	
xd		ADD D0,D0
		MOVE.W (A0,D0),(A2)+
		MOVE.W (A1,D0),(A2)+
yd		ADD D1,D1
		MOVE.W (A0,D1),(A2)+
		MOVE.W (A1,D1),(A2)+	
zd		ADD D2,D2
		MOVE.W (A0,D2),(A2)+
		MOVE.W (A1,D2),(A2)
		LEA -10(A2),A0		sin & cos values

		LEA MATRIX(PC),A1		storage place
* sinz*sinx(used twice) - D3
		MOVE 8(A0),D0		sinz
		MOVE (A0),D3		sinx
		MULS D0,D3
		ADD.L D3,D3
		SWAP D3
* sinz*cosx(used twice) - D4
		MOVE 2(A0),D4 		cosx(d0=sinz already)
		MULS D0,D4
		ADD.L D4,D4
		SWAP D4
* Matrix(1,1) cosy*cosx-siny*sinz*sinx
		MOVE 6(A0),D0  		cosy
		MOVE 2(A0),D1  		cosx
		MULS D1,D0			cosy*cosx
		MOVE 4(A0),D1		siny
		MULS D3,D1			
		SUB.L D1,D0
		ADD.L D0,D0
		SWAP D0			siny*(sinz*sinx)
		MOVE D0,(A1)+
* Matrix(2,1) siny*cosx+cosy*sinz*sinx 
		MOVE 4(A0),D0		siny
		MOVE 2(A0),D1		cosx
		MULS D1,D0			siny*cosx
		MOVE 6(A0),D1		cosy
		MULS D3,D1			
		ADD.L D1,D0
		ADD.L D0,D0
		SWAP D0			cosy*(sinz*sinx)
		MOVE D0,(A1)+
* Matrix(3,1) -cosz*sinx
		MOVE 10(A0),D0		cosz
		NEG D0
		MOVE (A0),D1		sinx
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			cosz*sinx
		MOVE D0,(A1)+
* Matrix(1,2) -siny*cosz
		MOVE 4(A0),D0		siny
		NEG D0			-siny
		MOVE 10(A0),D1		cosz
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			siny*cosz
		MOVE D0,(A1)+
* Matrix(2,2) cosy*cosz		
		MOVE 6(A0),D0		cosy
		MOVE 10(A0),D1		cosz
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0
		MOVE D0,(A1)+
* Matrix(3,2) sinz 
		MOVE 8(A0),(A1)+
* Matrix(1,3) cosy*sinx+siny*sinz*cosx
		MOVE 6(A0),D0		cosy
		MOVE (A0),D1		sinx
		MULS D1,D0			cosy*sinx
		MOVE 4(A0),D1		siny
		MULS D4,D1
		ADD.L D1,D0
		ADD.L D0,D0
		SWAP D0			siny*(sinz*cosx)
		MOVE D0,(A1)+
* Matrix(2,3) siny*sinx-cosy*sinz*cosx
		MOVE 4(A0),D0		siny
		MOVE (A0),D1		sinx
		MULS D1,D0			siny*sinx		
		MOVE 6(A0),D1		cosy
		MULS D4,D1	
		SUB.L D1,D0
		ADD.L D0,D0
		SWAP D0			cosy*(sinz*cosx)
		MOVE D0,(A1)+
* Matrix(3,3) cosz*cosx
		MOVE 10(A0),D0		cosz
		MOVE 2(A0),D1		cosx
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			cosz*cosx
		MOVE D0,(A1)

Trans_verts	LEA MATRIX(PC),A2		matrix pointer
		MOVEA #160,A3		centre x
		MOVEA #100,A4		centre y
		MOVEQ #7,D6
		MOVE.W #39,D7		POINTS
		LEA GRPOINTS(PC),A0
		LEA OFFSETTABLE(PC),A5
		MOVE.L STORE_AT,A1

trans_lp	MOVEM.W (A0),D0-D2	x,y,z
		MOVE D0,D3	
		MOVE D1,D4			dup
		MOVE D2,D5
* Calculate x co-ordinate		
		MULS (A2)+,D0			
		MULS (A2)+,D1		mat mult
		MULS (A2)+,D2
		ADD.L D1,D0
		ADD.L D2,D0
		ADD.L D0,D0
		SWAP D0			D0 = x
		ADD.W (A5),D0
* Calculate y co-ordinate		
		MULS (A2)+,D3
		MULS (A2)+,D4		mat mult
		MULS (A2)+,D5
		ADD.L D4,D3
		ADD.L D5,D3
		ADD.L D3,D3
		SWAP D3			D3 = y
		ADD.W 2(A5),D3
* Calculate z co-ordinate
		MOVEM.W (A0)+,D1/D2/D4
		MULS (A2)+,D1
		MULS (A2)+,D2		mat mult
		MULS (A2)+,D4
		ADD.L D1,D4
		ADD.L D2,D4
		ADD.L D4,D4
		SWAP D4			D4 = z
		ADD.W 4(A5),D4
* Combine and Perspect
		EXT.L D0			sign extend
		EXT.L D3			ready for divide
		ASL.L D6,D0			x*dist
		ASL.L D6,D3			y*dist
		DIVS D4,D0			x/z+dist
		DIVS D4,D3			y/z+dist
		ADD.W A3,D0
		ADD.W A4,D3
		MOVE.W D0,(A1)+
		MOVE.W D3,(A1)+
		LEA -18(A2),A2		mat(1,1)
		DBF D7,trans_lp
		MOVE.L A1,STORE_AT
		MOVE.L TRACKPOINT(PC),A2
		CMP.L #TRACKEND,A2
		BEQ.S ALL_FINISH
		BRA DO_IT
ALL_FINISH
		MOVE.L A1,DISP_END

		RTS

GETNEXT
		MOVE.L TABLEPOINT(PC),A0
BA		MOVE.L (A0),D0
		CMP.L #-1,D0
		BNE.S OKL
		LEA TABLE(PC),A0
OKL		MOVE.L (A0)+,DISPLAYPOS
		MOVE.L (A0)+,DISP_END
		MOVE.L A0,TABLEPOINT
		RTS

TABLEPOINT	DC.L TABLE
TABLE
		DC.L NORMAL,NORMAL_END
		DC.L NORMAL,NORMAL_END
		DC.L NORMAL,NORMAL_END
		DC.L NORMAL,NORMAL_END
		DC.L NORMAL,NORMAL_END
		DC.L GO_OUT,GO_OUT_END
		DC.L GO_IN,GO_IN_END
		DC.L -1,-1

DISPLAYPOS	DC.L GO_IN
DISP_END	DC.L GO_IN_END
STORE_AT	DC.L COORDATA

PLOTSHAPE
	MOVE.L DISPLAYPOS(PC),A3
	LEA 160(A3),A3
	MOVE.L DISP_END(PC),A0
	CMP.L A0,A3
	BNE.S MISSIT
	BSR 	GETNEXT
	MOVE.L DISPLAYPOS(PC),A3
	BRA.S MISSIT_IT
MISSIT
	MOVE.L A3,DISPLAYPOS
MISSIT_IT
	LEA GRLINE,A0
	MOVE.L LOGBASE(PC),A4
	MOVE.W #33,D7
ROUT1
	MOVE.W (A0)+,D0
	MOVE.W (A0)+,D2
	MOVE.W 2(A3,D0.W),D1
	MOVE.W 0(A3,D0.W),D0
	MOVE.W 2(A3,D2.W),D3
	MOVE.W 0(A3,D2.W),D2

	MOVE.W D7,-(A7)

	SUB.W D0,D2		
	SUB.W D1,D3
	MULU #160,D1
*	X%=D0
*	Y%=D1
*	A%=D2
*	B%=D3
*	DX=D4
*	DY=D5
*	DXNON=D6
*	DYNON=D7

	TST.W D2
	BPL.S AVOID1
	NEG.W D2
	MOVEQ #-1,D4
	BRA.S NEXT1
AVOID1	
	MOVEQ #1,D4
NEXT1

	TST.W D3
	BPL.S AVOID2
	NEG.W D3
	MOVE.L #-160,A2
	BRA.S NEXT2
AVOID2	
	MOVE.L #160,A2
NEXT2

	CMP.W D2,D3
	BLT.S AVOID3
	EXG D2,D3
	MOVEQ #0,D6
	MOVE.W A2,D7
	BRA.S NEXT3
AVOID3
	MOVE.W D4,D6
	MOVEQ #0,D7
NEXT3

*	NONDIAGINC=D3

	ADD.W D3,D3
	MOVE.W D3,A5
	SUB.W D2,A5
	MOVE.W A5,A1
	SUB.W D2,A1
	MOVE.L D2,D5

DRAWLOOP

*	X IN D0
*	Y IN D1

	MOVE.L D0,-(SP)
	MOVE.L D1,-(SP)

	MOVE.W	D0,D2
	AND.W	#15,D2		*GET FRAME NUMBER
	ADD.W D2,D2
	MOVE.W  TABLEDOT(PC,D2.W),D2

	ANDI.W	#$FFF0,D0	*GET WORD ON X LINE
	LSR.W	#1,D0
	ADD.W	D0,D1		*GET WORD
	OR.W D2,(A4,D1.W)
	MOVE.L (SP)+,D1
	MOVE.L (SP)+,D0

	MOVE.W A5,D2	
	BPL.S AVOID5

	ADD.W D6,D0
	ADD.W D7,D1
	ADD.W D3,D2
	BRA.S NEXT5
AVOID5
	ADD.W D4,D0
	ADD.W A2,D1

	ADD.W A1,D2
NEXT5
	MOVE.W D2,A5

	DBF D5,DRAWLOOP

	MOVE.W (A7)+,D7
	DBF D7,ROUT1

	RTS


TABLEDOT

	DC.W %1100000000000000
	DC.W %0110000000000000
	DC.W %0011000000000000
	DC.W %0001100000000000
	DC.W %0000110000000000
	DC.W %0000011000000000
	DC.W %0000001100000000
	DC.W %0000000110000000
	DC.W %0000000011000000
	DC.W %0000000001100000
	DC.W %0000000000110000
	DC.W %0000000000011000
	DC.W %0000000000001100
	DC.W %0000000000000110
	DC.W %0000000000000011
	DC.W %0000000000000001


************************
* THE SIN TABLE DATA IN RANGE -32767 TO 32767
*************************

SINTAB	
	INCBIN "DATA\SIN_TAB.DAT"


OFFSETTABLE
XOFF	DC.W -50
YOFF	DC.W -50
ZOFF	DC.W 700

ANGLETABLE
XANGLE	DC.W 0		ROTATED ANGLE OF OBJECT
YANGLE	DC.W 0
ZANGLE	DC.W 0

TRIGBUFF	
	DS.W 6
MATRIX
	DS.W 9

GRPOINTS
	DC.W -256,-64,-60		L
	DC.W -256,64,-60	
	DC.W -200,64,-60

	DC.W -192,64,-20		O
	DC.W -192,-64,-20
	DC.W -136,64,-20
	DC.W -136,-64,-20

	DC.W -128,64,20		S
	DC.W -72,64,20
	DC.W -72,32,20
	DC.W -128,-32,20
	DC.W -128,-64,20
	DC.W -72,-64,20

	DC.W -64,-64,60		T
	DC.W -8,-64,60
	DC.W -36,-64,60
	DC.W -36,64,60

	DC.W 64,-64,100		B
	DC.W 64,64,100
	DC.W 120,64,100
	DC.W 120,32,100
	DC.W 64,0,100
	DC.W 120,-32,100
	DC.W 120,-64,100

	DC.W 128,64,140		O
	DC.W 128,-64,140
	DC.W 184,-64,140
	DC.W 184,64,140

	DC.W 192,-64,180		Y
	DC.W 192,-32,180
	DC.W 248,-32,180
	DC.W 220,0,180
	DC.W 248,-64,180
	DC.W 220,64,180

	DC.W 256,64,220		S
	DC.W 312,64,220
	DC.W 312,32,220
	DC.W 256,-32,220
	DC.W 256,-64,220
	DC.W 312,-64,220


GRLINE
	DC.W 0*4,1*4,1*4,2*4			L
	DC.W 4*4,6*4,6*4,5*4,5*4,3*4,3*4,4*4		O
	DC.W 12*4,11*4,11*4,10*4,10*4,9*4,9*4,8*4,8*4,7*4	S
	DC.W 13*4,14*4,15*4,16*4		T
	DC.W 17*4,23*4,23*4,22*4,22*4,21*4,21*4,20*4,20*4,19*4,19*4,18*4,18*4,17*4	B
	DC.W 25*4,26*4,26*4,27*4,27*4,24*4,24*4,25*4	O
	DC.W 28*4,29*4,29*4,31*4,31*4,30*4,30*4,32*4,31*4,33*4	Y
	DC.W 39*4,38*4,38*4,37*4,37*4,36*4,36*4,35*4,35*4,34*4	S
LINEEND
TRACK	INCBIN "\DATA\TRACK.DAT"
	INCBIN "\DATA\TRACK_IN.DAT"
TRACKEND
TRACKPOINT
	DC.L TRACK	

****ERASE OLD STARS
ERASESUB

	MOVE.L OLDSTARPOINT,A0
	MOVEQ #0,D1
	REPT 200
	MOVE.L (A0)+,A1		GET POSITION
	MOVE.W D1,(A1)		WIPE EM OUT
	ENDR
	RTS

STARSSUB
	LEA STARS(PC),A0
	MOVE.L LOGBASE(PC),A1
	MOVE.L OLDSTARPOINT(PC),A5
	MOVE.W #199,D0
	MOVE.W #$FFFF,D1
DRAWLOOPB
	MOVE.L (A0)+,A2
	MOVE.W (A2)+,D2
	CMP.W D1,D2
	BNE.S CONT
	MOVE.L (A0),-(A0)
	BRA.S DRAWLOOPB
CONT
	MOVE.W (A2)+,D3
	MOVE.L A2,-(A0)
	LEA 8(A0),A0
	LEA (A1,D3.W),A3
	OR.W D2,(A3)
	MOVE.L A3,(A5)+
	DBF D0,DRAWLOOPB
	RTS

MAKEUPSTARS
	LEA STARS(PC),A0
	MOVEQ #0,D0
	MOVE.W #85,D1
CVLOOP
	MOVE.L (A0),A1
	ADD.L D0,A1
	MOVE.L A1,(A0)
	LEA 8(A0),A0
	MOVE.L (A0),A1
	ADD.L D0,A1
	MOVE.L A1,(A0)
	LEA 8(A0),A0
	ADD.L #4,D0
	DBF D1,CVLOOP

	MOVEQ #0,D0
	MOVE.W #27,D1
CVLOOP1
	MOVE.L (A0),A1
	ADD.L D0,A1
	MOVE.L A1,(A0)
	LEA 8(A0),A0
	ADD.L #12,D0
	DBF D1,CVLOOP1
	RTS

PALETTE	DC.W $000,$770,$666,$770,$333,$770,$666,$770
	DC.W $007,$770,$007,$770,$007,$770,$007,$770

************************************
* THE BIG SCROLL ROUTINE FOR THE 2 *
* LAYER PARALLAX SCREEN BY MANIKIN *
* OF THE LOST BOYS 6TH OCTOBER '89 *
************************************

DO_SCROLL
	LEA SCROLLBUFF,A0
	REPT 10
	MOVEM.L (A0)+,D0-D7/A1-A5
	MOVE.W D0,-52(A0)
	MOVEM.L D1-D7/A1-A5,-50(A0)
	MOVE.L (A0)+,-6(A0)
	MOVE.L (A0)+,-6(A0)
	ENDR
	SUB.W #1,COUNT
	TST.W	COUNT
	BNE DRAWSCROLL
	MOVE.W #10,COUNT
	MOVEQ #0,D2
	MOVE.L SCROLLPOINT,A0
LOOPBACK
	MOVE.B (A0)+,D2
	CMP.B #$FF,D2
	BNE.S CONTY
	LEA SCROLLINE,A0
	BRA.S LOOPBACK
CONTY
	MOVE.L A0,SCROLLPOINT
	SUB.B #32,D2
	MULU #200,D2
	LEA FONT,A0
	ADD.L D2,A0

	LEA SCROLLBUFF+40,A1
ADDIT	SET 0
	REPT 5
	MOVEM.L (A0)+,D0-D7/A2-A3
	MOVEM.L D0-D4,ADDIT(A1)
	MOVEM.L D5-D7/A2-A3,ADDIT+60(A1)
ADDIT	SET ADDIT+120
	ENDR
DRAWSCROLL
	MOVE.L LOGBASE(PC),A0

	MOVE.L OFF(PC),D0
	MOVE.W IND(PC),D1
	TST.W D1
	BNE.S UPM2
	ADD.L #160,D0
	LEA 6(A0,D0.W),A0
	LEA -320(A0),A1
	CMP.L #19200,D0
	BNE.S STARTUP1
	NOT.W IND
	BRA.S STARTUP1

UPM2 	SUB.L #160,D0
	LEA 6(A0,D0.W),A0
	LEA 12800(A0),A1
	TST.W D0
	BNE.S STARTUP1
	NOT.W IND

STARTUP1
	MOVE.L D0,OFF

	MOVEQ #0,D4

	MOVE.W D4,(A1)
	MOVE.W D4,8(A1)
	MOVE.W D4,16(A1)
	MOVE.W D4,24(A1)
	MOVE.W D4,32(A1)
	MOVE.W D4,40(A1)
	MOVE.W D4,48(A1)
	MOVE.W D4,56(A1)
	MOVE.W D4,64(A1)
	MOVE.W D4,72(A1)
	MOVE.W D4,80(A1)
	MOVE.W D4,88(A1)
	MOVE.W D4,96(A1)
	MOVE.W D4,104(A1)
	MOVE.W D4,112(A1)
	MOVE.W D4,120(A1)
	MOVE.W D4,128(A1)
	MOVE.W D4,136(A1)
	MOVE.W D4,144(A1)
	MOVE.W D4,152(A1)

	MOVE.W D4,160(A1)
	MOVE.W D4,160+8(A1)
	MOVE.W D4,160+16(A1)
	MOVE.W D4,160+24(A1)
	MOVE.W D4,160+32(A1)
	MOVE.W D4,160+40(A1)
	MOVE.W D4,160+48(A1)
	MOVE.W D4,160+56(A1)
	MOVE.W D4,160+64(A1)
	MOVE.W D4,160+72(A1)
	MOVE.W D4,160+80(A1)
	MOVE.W D4,160+88(A1)
	MOVE.W D4,160+96(A1)
	MOVE.W D4,160+104(A1)
	MOVE.W D4,160+112(A1)
	MOVE.W D4,160+120(A1)
	MOVE.W D4,160+128(A1)
	MOVE.W D4,160+136(A1)
	MOVE.W D4,160+144(A1)
	MOVE.W D4,160+152(A1)

	LEA SCROLLBUFF(PC),A1
	MOVEQ #-1,D5

	MOVEQ #9,D2
LOOP2
	MOVEQ #19,D1
LOOP1
	MOVE.W (A1)+,D0
	BEQ BLANKB
	CMP.W #1,D0
	BEQ	DRAWIT
	CMP.W #2,D0
	BEQ DIAG2
	CMP.W #3,D0
	BEQ DIAG3
	CMP.W #4,D0
	BEQ DIAG4
DIAG5
	LEA GDIAG5(PC),A2
	MOVE.W (A2)+,D7
	MOVE.W D7,(A0)
	MOVE.W D7,160(A0)
	MOVE.W D7,320(A0)
	MOVE.W D7,480(A0)
	MOVE.W (A2)+,D7
	MOVE.W D7,640(A0)
	MOVE.W D7,800(A0)
	MOVE.W D7,960(A0)
	MOVE.W D7,1120(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2
	BRA THEEND
DIAG4
	LEA GDIAG4(PC),A2
	MOVE.W (A2)+,D7
	MOVE.W D7,(A0)
	MOVE.W D7,160(A0)
	MOVE.W D7,320(A0)
	MOVE.W D7,480(A0)
	MOVE.W (A2)+,D7
	MOVE.W D7,640(A0)
	MOVE.W D7,800(A0)
	MOVE.W D7,960(A0)
	MOVE.W D7,1120(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2
	BRA THEEND
DIAG3
	LEA GDIAG3(PC),A2
	MOVE.W (A2)+,D7
	MOVE.W D7,(A0)
	MOVE.W D7,160(A0)
	MOVE.W D7,320(A0)
	MOVE.W D7,480(A0)
	MOVE.W (A2)+,D7
	MOVE.W D7,640(A0)
	MOVE.W D7,800(A0)
	MOVE.W D7,960(A0)
	MOVE.W D7,1120(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2
	BRA THEEND
DIAG2
	LEA GDIAG2(PC),A2
	MOVE.W (A2)+,D7
	MOVE.W D7,(A0)
	MOVE.W D7,160(A0)
	MOVE.W D7,320(A0)
	MOVE.W D7,480(A0)
	MOVE.W (A2)+,D7
	MOVE.W D7,640(A0)
	MOVE.W D7,800(A0)
	MOVE.W D7,960(A0)
	MOVE.W D7,1120(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2
	BRA THEEND

BLANKB	MOVE.W D4,(A0)
	MOVE.W D4,160(A0)
	MOVE.W D4,320(A0)
	MOVE.W D4,480(A0)
	MOVE.W D4,640(A0)
	MOVE.W D4,800(A0)
	MOVE.W D4,960(A0)
	MOVE.W D4,1120(A0)

	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2
	BRA.S THEEND
DRAWIT
	MOVE.W D5,(A0)
	MOVE.W D5,160(A0)
	MOVE.W D5,320(A0)
	MOVE.W D5,480(A0)
	MOVE.W D5,640(A0)
	MOVE.W D5,800(A0)
	MOVE.W D5,960(A0)
	MOVE.W D5,1120(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1
	LEA 1120(A0),A0
	LEA 20(A1),A1
	DBF D2,LOOP2

THEEND
	RTS
OFF	DC.L 0
IND	DC.W 0		DOWN
DO_SCROLL1
	MOVE.L LOGBASE(PC),A0

	MOVE.L OFF(PC),D0
	MOVE.W IND(PC),D1
	TST.W D1
	BNE.S UPM
	ADD.L #160,D0
	LEA 6(A0,D0.W),A0
	LEA -320(A0),A1
	CMP.L #19200,D0
	BNE.S STARTUP
	NOT.W IND
	BRA.S STARTUP

UPM 	SUB.L #160,D0
	LEA 6(A0,D0.W),A0
	LEA 12800(A0),A1
	TST.W D0
	BNE.S STARTUP
	NOT.W IND

STARTUP
	MOVE.L D0,OFF
	MOVEQ #0,D4

	MOVE.W D4,(A1)
	MOVE.W D4,8(A1)
	MOVE.W D4,16(A1)
	MOVE.W D4,24(A1)
	MOVE.W D4,32(A1)
	MOVE.W D4,40(A1)
	MOVE.W D4,48(A1)
	MOVE.W D4,56(A1)
	MOVE.W D4,64(A1)
	MOVE.W D4,72(A1)
	MOVE.W D4,80(A1)
	MOVE.W D4,88(A1)
	MOVE.W D4,96(A1)
	MOVE.W D4,104(A1)
	MOVE.W D4,112(A1)
	MOVE.W D4,120(A1)
	MOVE.W D4,128(A1)
	MOVE.W D4,136(A1)
	MOVE.W D4,144(A1)
	MOVE.W D4,152(A1)

	MOVE.W D4,160(A1)
	MOVE.W D4,160+8(A1)
	MOVE.W D4,160+16(A1)
	MOVE.W D4,160+24(A1)
	MOVE.W D4,160+32(A1)
	MOVE.W D4,160+40(A1)
	MOVE.W D4,160+48(A1)
	MOVE.W D4,160+56(A1)
	MOVE.W D4,160+64(A1)
	MOVE.W D4,160+72(A1)
	MOVE.W D4,160+80(A1)
	MOVE.W D4,160+88(A1)
	MOVE.W D4,160+96(A1)
	MOVE.W D4,160+104(A1)
	MOVE.W D4,160+112(A1)
	MOVE.W D4,160+120(A1)
	MOVE.W D4,160+128(A1)
	MOVE.W D4,160+136(A1)
	MOVE.W D4,160+144(A1)
	MOVE.W D4,160+152(A1)

	LEA SCROLLBUFF(PC),A1
	MOVEQ #-1,D5

	MOVEQ #9,D2
LOOP2T
	MOVE.W (A1)+,D0
	BEQ BLANKT1
	CMP.W #1,D0
	BEQ DRAWITT1
	CMP.W #2,D0
	BEQ DIAG2T1
	CMP.W #3,D0
	BEQ DIAG3T1
	CMP.W #4,D0
	BEQ DIAG4T1
DIAG5T1
	LEA GDIAG5+1(PC),A2
	MOVE.B (A2),(A0)+
	MOVE.B 2(A2),639(A0)
GETBACK1
	MOVEQ #18,D1
LOOP1T
	MOVE.W (A1)+,D0
	BEQ BLANKT2
	CMP.W #1,D0
	BEQ DRAWITT2
	CMP.W #2,D0
	BEQ DIAG2T2
	CMP.W #3,D0
	BEQ DIAG3T2
	CMP.W #4,D0
	BEQ DIAG4T2
DIAG5T2
	LEA GDIAG5(PC),A2
	MOVE.B (A2)+,(A0)
	MOVE.B (A2)+,7(A0)
	MOVE.B (A2)+,640(A0)
	MOVE.B (A2)+,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T

	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3

DIAG4T2
	LEA GDIAG4(PC),A2
	MOVE.B (A2)+,(A0)
	MOVE.B (A2)+,7(A0)
	MOVE.B (A2)+,640(A0)
	MOVE.B (A2)+,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T

	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3
DIAG3T2
	LEA GDIAG3(PC),A2
	MOVE.B (A2)+,(A0)
	MOVE.B (A2)+,7(A0)
	MOVE.B (A2)+,640(A0)
	MOVE.B (A2)+,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T

	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3
DIAG2T2
	LEA GDIAG2(PC),A2
	MOVE.B (A2)+,(A0)
	MOVE.B (A2)+,7(A0)
	MOVE.B (A2)+,640(A0)
	MOVE.B (A2)+,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T
	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3

BLANKT2
	MOVE.B D4,(A0)
	MOVE.B D4,7(A0)
	MOVE.B D4,640(A0)
	MOVE.B D4,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T
	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3
DRAWITT2
	MOVE.B D5,(A0)
	MOVE.B D5,7(A0)
	MOVE.B D5,640(A0)
	MOVE.B D5,647(A0)
	LEA 8(A0),A0
	DBF D1,LOOP1T
	MOVE.W (A1)+,D0
	BEQ BLANKT3
	CMP.W #1,D0
	BEQ	DRAWITT3
	CMP.W #2,D0
	BEQ DIAG2T3
	CMP.W #3,D0
	BEQ DIAG3T3
	CMP.W #4,D0
	BEQ DIAG4T3
	CMP.W #5,D0
	BEQ DIAG5T3
ENDBACK1
****************************************
	LEA -1280(A0),A4
	REPT 20
	MOVE.W (A4),D7
	MOVE.W D7,160(A4)
	MOVE.W D7,320(A4)
	MOVE.W D7,480(A4)
	MOVE.W 640(A4),D7
	MOVE.W D7,800(A4)
	MOVE.W D7,960(A4)
	MOVE.W D7,1120(A4)
	LEA 8(A4),A4
	ENDR
	LEA 18(a1),A1
	DBF D2,LOOP2T

THEEND1
	RTS
DIAG5T3
	LEA GDIAG5(PC),A2
	MOVE.B (A2),(A0)
	MOVE.B 2(A2),640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1
DIAG4T3
	LEA GDIAG4(PC),A2
	MOVE.B (A2),(A0)
	MOVE.B 2(A2),640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1
DIAG3T3
	LEA GDIAG3(PC),A2
	MOVE.B (A2),(A0)
	MOVE.B 2(A2),640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1
DIAG2T3
	LEA GDIAG2+1(PC),A2
	MOVE.B (A2),(A0)
	MOVE.B 2(A2),640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1

BLANKT3	MOVE.B D4,(A0)
	MOVE.B D4,640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1
DRAWITT3
	MOVE.B D5,(A0)
	MOVE.B D5,640(A0)
	LEA 1127(A0),A0
	BRA ENDBACK1

DIAG4T1
	LEA GDIAG4+1(PC),A2
	MOVE.B (A2),(A0)+
	MOVE.B 2(A2),639(A0)
	BRA GETBACK1
DIAG3T1
	LEA GDIAG3+1(PC),A2
	MOVE.B (A2),(A0)+
	MOVE.B 2(A2),639(A0)
	BRA GETBACK1
DIAG2T1
	LEA GDIAG2+1(PC),A2
	MOVE.B (A2),(A0)+
	MOVE.B 2(A2),639(A0)
	BRA GETBACK1

BLANKT1	MOVE.B D4,(A0)+
	MOVE.B D4,639(A0)
	BRA GETBACK1
DRAWITT1
	MOVE.B D5,(A0)+
	MOVE.B D5,639(A0)
	BRA GETBACK1


**********************
* THE FONT	     *
**********************

FONT
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,2,1,3,0,0,0,0	!
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,2,1,3,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0

	DC.W 	0,2,1,3,0,2,1,3,0,0	"
	DC.W 	0,1,1,1,0,1,1,1,0,0
	DC.W 	0,4,1,1,0,4,1,1,0,0
	DC.W 	0,0,2,5,0,0,2,5,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	#
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	$
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	%
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	&
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	
	DC.W 	0,0,0,2,1,3,0,0,0,0	'
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,1,0,0,0,0
	DC.W 	0,0,0,0,2,5,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,2,1,1,5,0	(
	DC.W 	0,0,0,0,2,1,1,5,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,4,1,1,3,0,0
	DC.W 	0,0,0,0,0,4,1,1,3,0

	DC.W 	4,1,1,3,0,0,0,0,0,0	)
	DC.W 	0,4,1,1,3,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,1,0,0,0,0,0
	DC.W 	0,2,1,1,5,0,0,0,0,0
	DC.W 	2,1,1,5,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	*
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,2,1,3,0,0,0,0	+
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	,
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,2,1,3,0,0,0,0,0,0
	DC.W 	0,1,1,1,0,0,0,0,0,0
	DC.W 	0,4,1,1,0,0,0,0,0,0
	DC.W 	0,0,2,5,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	-
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	.
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,2,1,3,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	/
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,2,1,1,1,3,0,0,0	0
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,3,0,0,1,1,1,0
	DC.W 	1,1,1,4,3,0,1,1,1,0
	DC.W 	1,1,1,0,4,3,1,1,1,0
	DC.W 	1,1,1,0,0,4,1,1,1,0
	DC.W 	4,1,1,3,0,2,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0
	DC.W 	0,0,4,1,1,1,5,0,0,0

	DC.W 	0,0,0,1,1,1,0,0,0,0	1
	DC.W 	0,0,2,1,1,1,0,0,0,0
	DC.W 	0,0,1,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0

	DC.W 	0,2,1,1,1,1,1,3,0,0	2
	DC.W 	2,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,1,1,0,0,2,1,0,0
	DC.W 	0,0,0,0,0,2,1,5,0,0
	DC.W 	0,0,0,0,2,1,5,0,0,0
	DC.W 	0,0,0,2,1,5,0,0,0,0
	DC.W 	0,0,2,1,5,0,0,0,0,0
	DC.W 	0,2,1,5,0,0,1,1,1,0
	DC.W 	2,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,1,1,1,1,1,1,0

	DC.W 	0,0,2,1,1,1,3,0,0,0	3
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	0,0,0,0,0,2,1,1,1,0
	DC.W 	0,0,1,1,1,1,1,1,0,0
	DC.W 	0,0,0,0,0,4,1,1,3,0
	DC.W 	0,0,0,0,0,0,1,1,1,0
	DC.W 	1,1,1,3,0,2,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	1,1,1,0,1,1,1,0,0,0	4
	DC.W 	1,1,1,0,1,1,1,0,0,0
	DC.W 	1,1,1,0,1,1,1,0,0,0
	DC.W 	1,1,1,0,1,1,1,0,0,0
	DC.W 	1,1,1,0,1,1,1,0,0,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0

	DC.W 	1,1,1,1,1,1,1,1,1,0	5
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,1,1,1,1,0,0,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	0,0,0,0,0,4,1,1,1,0
	DC.W 	0,0,0,0,0,2,1,1,1,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,1,1,1,1,1,0,0,0

	DC.W 	0,0,2,1,1,1,1,3,0,0	6
	DC.W 	0,2,1,1,1,1,1,1,3,0
	DC.W 	2,1,1,5,0,0,4,1,1,0
	DC.W 	1,1,1,3,0,0,0,0,0,0
	DC.W 	1,1,1,1,1,1,1,3,0,0
	DC.W 	1,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,3,0,2,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	1,1,1,1,1,1,1,1,1,0	7
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,0,0,2,1,1,5,0
	DC.W 	0,0,0,0,2,1,1,5,0,0
	DC.W 	0,0,0,2,1,1,5,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0

	DC.W 	0,0,2,1,1,1,3,0,0,0	8
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,3,0,2,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,3,0,2,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	0,2,1,1,1,1,1,3,0,0	8
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,1,5,0,4,1,1,1,0
	DC.W 	1,1,1,3,0,2,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,1,0
	DC.W 	0,4,1,1,1,1,1,1,1,0
	DC.W 	0,0,0,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,2,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	:
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,2,1,3,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,2,1,3,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	;
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,2,1,3,0,0,0,0,0,0
	DC.W 	0,1,1,1,0,0,0,0,0,0
	DC.W 	0,4,1,5,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,2,1,3,0,0,0,0,0,0
	DC.W 	0,1,1,1,0,0,0,0,0,0
	DC.W 	0,4,1,1,0,0,0,0,0,0
	DC.W 	0,0,2,5,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	<
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	=
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	>
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,2,1,1,1,1,3,0,0	?
	DC.W 	0,2,1,1,5,4,1,1,3,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,0,0,0,0,0,1,1,1,0
	DC.W 	0,0,0,0,0,2,1,1,5,0
	DC.W 	0,0,0,0,2,1,1,5,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,2,1,3,0,0,0
	DC.W 	0,0,0,0,1,1,1,0,0,0
	DC.W 	0,0,0,0,4,1,5,0,0,0

	DC.W 	0,0,0,0,0,0,0,0,0,0	@
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0
	DC.W 	0,0,0,0,0,0,0,0,0,0

	DC.W 	0,0,0,2,1,3,0,0,0,0
	DC.W 	0,0,2,1,1,1,3,0,0,0
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	0,1,1,5,0,4,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	0,1,1,1,1,1,1,3,0,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	0,1,1,1,0,4,1,1,0,0
	DC.W 	0,0,1,1,0,0,1,5,0,0
	DC.W 	0,0,1,1,1,1,1,3,0,0
	DC.W 	0,0,1,1,0,4,1,1,3,0
	DC.W 	0,0,1,1,0,0,4,1,1,0
	DC.W 	0,1,1,1,0,0,2,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,5,0

	DC.W 	0,0,2,1,1,1,1,3,0,0
	DC.W 	0,2,1,1,1,1,1,1,3,0
	DC.W 	2,1,1,1,5,4,1,1,1,0
	DC.W 	1,1,1,5,0,0,4,1,1,0
	DC.W 	1,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,3,0,0,2,1,1,0
	DC.W 	4,1,1,1,3,2,1,1,1,0
	DC.W 	0,4,1,1,1,1,1,1,5,0
	DC.W 	0,0,4,1,1,1,1,5,0,0

	DC.W 	0,1,1,1,1,1,1,3,0,0
	DC.W 	0,1,1,1,1,1,1,1,3,0
	DC.W 	0,1,1,1,0,4,1,1,1,0
	DC.W 	0,0,1,1,0,0,4,1,1,0
	DC.W 	0,0,1,1,0,0,0,1,1,0
	DC.W 	0,0,1,1,0,0,0,1,1,0
	DC.W 	0,0,1,1,0,0,0,1,1,0
	DC.W 	0,1,1,1,0,0,2,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,5,0

	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0

	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,1,1,1,1,0,0,0,0,0
	DC.W 	0,1,1,1,1,0,0,0,0,0
	DC.W 	0,1,1,1,1,0,0,0,0,0

	DC.W 	0,0,2,1,1,1,1,3,0,0
	DC.W 	0,2,1,1,1,1,1,1,3,0
	DC.W 	2,1,1,5,0,4,1,1,1,0
	DC.W 	1,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,0,0,1,1,1,1,0
	DC.W 	1,1,1,0,0,1,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	4,1,1,3,0,2,1,1,1,0
	DC.W 	0,4,1,1,1,1,1,1,5,0
	DC.W 	0,0,4,1,1,1,1,5,0,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0

	DC.W 	0,0,0,0,0,1,1,1,1,0
	DC.W 	0,0,0,0,0,1,1,1,1,0
	DC.W 	0,0,0,0,0,1,1,1,1,0
	DC.W 	0,0,0,0,0,0,1,1,0,0
	DC.W 	0,0,0,0,0,0,1,1,0,0
	DC.W 	1,1,1,1,0,0,1,1,0,0
	DC.W 	1,1,1,1,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,2,1,1,0,0
	DC.W 	0,4,1,1,1,1,1,1,0,0
	DC.W 	0,0,4,1,1,1,1,5,0,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,5,0
	DC.W 	0,1,1,0,0,2,1,5,0,0
	DC.W 	0,1,1,1,1,1,5,0,0,0
	DC.W 	0,1,1,0,4,1,3,0,0,0
	DC.W 	0,1,1,0,0,4,1,3,0,0
	DC.W 	1,1,1,1,0,1,1,1,3,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	0,1,1,1,1,0,0,0,0,0
	DC.W 	0,1,1,1,1,0,0,0,0,0
	DC.W 	0,1,1,1,1,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,0,1,1,0,0,0,0,0,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0

	DC.W 	1,1,3,0,0,2,1,1,0,0
	DC.W 	1,1,1,3,2,1,1,1,0,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,4,1,1,5,1,1,0,0
	DC.W 	1,1,0,4,5,0,1,1,0,0
	DC.W 	1,1,0,0,0,0,1,1,0,0
	DC.W 	1,1,1,0,0,1,1,1,0,0
	DC.W 	1,1,1,0,0,1,1,1,0,0
	DC.W 	1,1,1,0,0,1,1,1,0,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,1,3,0,1,1,0,0
	DC.W 	0,1,1,1,1,3,1,1,0,0
	DC.W 	0,1,1,4,1,1,1,1,0,0
	DC.W 	0,1,1,0,4,1,1,1,0,0
	DC.W 	1,1,1,0,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	0,0,2,1,1,1,3,0,0,0
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	4,1,1,3,0,2,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0
	DC.W 	0,0,4,1,1,1,5,0,0,0

	DC.W 	1,1,1,1,1,1,1,3,0,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,1,0,0,4,1,1,0,0
	DC.W 	0,1,1,0,0,2,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,5,0,0
	DC.W 	0,1,1,0,0,0,0,0,0,0
	DC.W 	1,1,1,1,0,0,0,0,0,0
	DC.W 	1,1,1,1,0,0,0,0,0,0
	DC.W 	1,1,1,1,0,0,0,0,0,0

	DC.W 	0,0,2,1,1,1,3,0,0,0
	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,5,0,4,1,1,3,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,1,3,1,1,1,0
	DC.W 	1,1,1,0,4,1,1,1,1,0
	DC.W 	4,1,1,3,0,4,1,1,0,0
	DC.W 	0,4,1,1,1,1,1,1,3,0
	DC.W 	0,0,4,1,1,1,0,4,1,3

	DC.W 	1,1,1,1,1,1,1,3,0,0
	DC.W 	1,1,1,1,1,1,1,1,0,0
	DC.W 	1,1,1,0,0,4,1,1,0,0
	DC.W 	0,1,1,0,0,2,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,5,0,0
	DC.W 	0,1,1,1,1,1,1,3,0,0
	DC.W 	0,1,1,0,0,0,1,1,3,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	0,2,1,1,1,1,1,3,0,0
	DC.W 	2,1,1,1,1,1,1,1,3,0
	DC.W 	1,1,5,0,0,0,4,1,1,0
	DC.W 	1,1,3,0,0,0,0,0,0,0
	DC.W 	4,1,1,1,1,1,1,3,0,0
	DC.W 	0,4,1,1,1,1,1,1,3,0
	DC.W 	0,0,0,0,0,0,4,1,1,0
	DC.W 	1,1,3,0,0,0,2,1,1,0
	DC.W 	4,1,1,1,1,1,1,1,5,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,0,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0
	DC.W 	0,0,0,1,1,1,1,0,0,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,3,0,2,1,1,0,0
	DC.W 	0,1,1,1,1,1,1,1,0,0
	DC.W 	0,4,1,1,1,1,1,5,0,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,1,1,0,0,0,1,1,0,0
	DC.W 	0,4,1,3,0,2,1,5,0,0
	DC.W 	0,0,4,1,1,1,5,0,0,0
	DC.W 	0,0,0,4,1,5,0,0,0,0

	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,1,0,0,1,1,1,0
	DC.W 	0,1,1,0,0,0,0,1,1,0
	DC.W 	0,1,1,0,2,3,0,1,1,0
	DC.W 	0,1,1,2,1,1,3,1,1,0
	DC.W 	0,1,1,1,1,1,1,1,1,0
	DC.W 	0,1,1,1,5,4,1,1,1,0
	DC.W 	0,1,1,5,0,0,4,1,1,0
	DC.W 	0,1,5,0,0,0,0,4,1,0

	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	4,1,1,1,0,1,1,1,5,0
	DC.W 	0,4,1,3,0,2,1,5,0,0
	DC.W 	0,0,4,1,1,1,5,0,0,0
	DC.W 	0,0,2,1,1,1,3,0,0,0
	DC.W 	0,2,1,5,0,4,1,3,0,0
	DC.W 	2,1,1,1,0,1,1,1,3,0
	DC.W 	1,1,1,1,0,1,1,1,1,0
	DC.W 	1,1,1,1,0,1,1,1,1,0

	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	1,1,1,0,0,0,1,1,1,0
	DC.W 	4,1,3,0,0,0,2,1,5,0
	DC.W 	0,4,1,3,0,2,1,5,0,0
	DC.W 	0,0,4,1,1,1,5,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,0,1,1,1,0,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0
	DC.W 	0,0,1,1,1,1,1,0,0,0

	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,1,0,0,2,1,5,0
	DC.W 	0,0,0,0,0,2,1,5,0,0
	DC.W 	0,0,0,0,2,1,5,0,0,0
	DC.W 	0,0,0,2,1,5,0,0,0,0
	DC.W 	0,0,2,1,5,0,0,0,0,0
	DC.W 	0,2,1,5,0,0,1,1,1,0
	DC.W 	2,1,1,1,1,1,1,1,1,0
	DC.W 	1,1,1,1,1,1,1,1,1,0

GDIAG2
	DC.W %0000000011111111
	DC.W %1111111111111111

GDIAG3
	DC.W %1111111100000000
	DC.W %1111111111111111

GDIAG4
	DC.W %1111111111111111
	DC.W %0000000011111111

GDIAG5
	DC.W %1111111111111111
	DC.W %1111111100000000
	DS.W 10
SCROLLBUFF
	DS.W 	300

SCROLLPOINT
	DC.L SCROLLINE
SCROLLINE
	DC.B "     OH MY GOD!, ITS FULL OF STARS.          WELL THATS PRETTY DAMN ORIGINAL ISN'T IT?     NO THIS ISN'T 2010 IT THE LOST BOYS VECTORS SCREEN. SLIGHTLY HIDDEN ON THE MINDBOMB DEMO.  YOU EITHER FIND YOUR WAY ONTO THIS SCREEN EASILY OR IF "
	DC.B "YOU ARE PARTIALLY STUPID (YOU CAN'T BE TOTALLY STUPID COS YOUR HERE NOW!  OR DID SOMEONE TELL YOU HOW TO GET HERE?!!) THEN YOU MAY HAVE FOUND THAT IT TOOK YOU QUITE A WHILE TO FIND OUT THAT YOU CAN WALK THROUGH THE TOP OF COLUMNS AND THEN"
	DC.B " FALL DOWN THE LENGTH OF THEM ON MY MAIN MENU! STILL I HOPE YOU THINK ITS WORTH THE TROUBLE. I WAS GOING TO DO A FEW MORE SHAPES AND STUFF IN THIS SCREEN BUT I HAVE JUST SEEN A SCREEN THAT IS RATHER TO SIMILAR TO THIS FOR MY LIKING "
	DC.B " BY AN COOL OF THE CAREBEARS AND SINCE EVERYONE IS GOING TO THINK THAT I COPIED HIM ANYWAY, I REALLY CAN'T BE BOTHERED. I AM QUITE PLEASED THAT I WROTE THE LINE PLOT ROUTINE ANYWAY AS IT BASICALLY SOLVES THE PROGRAMMING PROJECT THAT "
	DC.B "I HAVE BEEN SET FOR NEXT TERM IN UNIVERSITY. IT WAS SUPPOSED TO TAKE US ABOUT 15 HOURS, BUT I FINSHED IT IN 1 HOUR!!! PRETTY GOOD HUH!! AT THE MOMENT I AM BEING TAUGHT A COURSE ON 68000 ASSEMBLER AT UNIVERSITY, BUT I THINK I PROBABLY "
	DC.B "KNOW MORE ABOUT 68000 PROGRAMMING THAN THE BLOODY LECTURER SO ITS REALLY PRETTY BORING. ARRRGGGHHHH SHIT WHAT THE HELL IS THAT!!     SAMMY JOE HAS JUST PUT A REALLY CRAPPY RECORD ON, ITS CALLED RIDE THE LIGHTENING BY METTALICA, THE "
	DC.B "SONG IS CALLED FIGHT FIRE WITH FIRE AND IT BASICALLY CONSISTS OF SOMEBODY TWANGING A GUITAR AND SOMEBODY ELSE GROWLING SOME SHITTY LIRICKS ALONG WITH IT! IT IS UTTER SHITE! TODAY WE BOUGHT A RECORD CALLED 'ENJOY THE SILENCE' BY DEPECHE "
	DC.B "MODE AND WE ARE THINKING OF DOING A SAMPLE DEMO OF IT. IT HAS EMERGED AS A VAGUE POSSIBILITY THAT I WILL HAVE MORE SCREENS FOR THIS DEMO THAN I CAN FIT ONTO 1 DOUBLE SIDED DISK AND SO WE MAY HAVE TO USE A 2ND DISK FOR SOME EXTRA SCREENS "
	DC.B " AND THE SAMPLE WILL THERFORE BE USED AS A SPACE FILLER.  THE TROUBLE WITH THIS DEMO HAS ALWAYS BEEN THAT JUST WHEN I THINK IT IS FINISHED FOR GOOD SOMETHING OR SOMEONE POINTS ME TO A BUG OR GIVES ME ANOTHER SCREEN. TODAY WAS ONE OF THOSE"
	DC.B " DAYS, I WAS HAPPILY FINISHING MY DISK OFF WHEN STEFAN ANNOUNCED THAT HE HAD IN FACT FINISHED HIS THIRD DIGITAL INSANITY SCREEN. ALSO AENIGMATICA HAVE OFFERED US A SCREEN AND SO HAVE A NORWEGIAN GROUP! ALSO TO TOP IT ALL OFF SPAZ HAS JUST "
	DC.B " PRODUCED A REALLY EXCELLENT 4 TRACK SONG (AFTER I HAVE JUST FINISHED AND PACKED THE SYNTH SCREEN!!) AND I NOW WOULD REALLY LIKE TO PUT THIS IN THE DEMO AS WELL!  IS THERE NO END TO MY PROBLEMS.  OF COURSE NOT! TO ADD FURTHER PROBLEMS "
	DC.B " LAST WEEK WE BORROWED AN STE FOR A FEW HOURS SO THAT WE COULD TRY AND MAKE THE DEMO COMPATIBLE WITH THE STE, AFTER ABOUT 20 MINUTES OF TRYING WE SUCCEEDED ONLY TO FIND THAT OF ALL THINGS THE LOADER ROUTINE DIDN'T WORK ANY MORE! "
	DC.B " NOT THE FUCKING BORDERS OR THE SYNC SCROLLING BUT THE FUCKING SHITTY LITTLE LOADER!!!!!  ARRRRRRGGGGGGHHHHHHH!!!!   IF I HADN'T SPENT SO LONG ON THIS DEMOI WOULD PROBABLY  KICK THE LIVING SHIT OUT OF THIS COMPUTER AND ALL MY RUDDY"
	DC.B " DATA DISKS!!!        BEFORE I EXPLODE LETS WRAP!!!!!       "
	DC.B $FF
	
	EVEN
COUNT	DC.W 1

*************************************
* VARIABLES ETC FOR THE STARS
*************************************

OLDSTARPOINT	DC.L 0

OLDSTARS	
	REPT 200
	DC.L $78000
	ENDR

OLDSTARS1
	REPT 200
	DC.L $78000
	ENDR

STARS	
ADDIT	SET 0
	REPT 200
	DC.L DEFSTARS+ADDIT,DEFSTARS+ADDIT
ADDIT	SET ADDIT+360
	ENDR
MUSIC	INCBIN "DATA\MADMAX_8.DAT"
DEFSTARS	INCBIN "\STARS\STARS.DAT"
		DC.W $FFFF,$FFFF
COORDATA
NORMAL		EQU COORDATA
NORMAL_END	EQU COORDATA+38400
GO_OUT		EQU NORMAL_END
GO_OUT_END	EQU NORMAL_END+19200
GO_IN		EQU GO_OUT_END
GO_IN_END	EQU GO_OUT_END+19200
