************************************************
* THE NEW 3D SPRITE ROUTINE BY MANIKIN OF TLB  *
* BASED ON THE RED SECTOR DEMO ON THE AMIGA    *
* CODED FROM SCRATCH IN LATE JANUARY 1990      *
************************************************

	CLR.L 	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP 	#1
	ADD.L	#6,SP

	MOVE.L D0,OLDSSP
	LEA MYSTACK,A7

	MOVEQ #$12,D0
	BSR IKBD
	MOVEQ #$1A,D0
	BSR IKBD
	MOVEQ #0,D0
	BSR PREDOSPRITES
	BSR PREDOBIGSPRITES
	BSR MAKEHELI			SOME WAVES MUST BE MADE UP
* IN THIS CASE THE SPINNING ROTORS ARE ADDED TO THE ORIGINAL HELICOPTER DESIGN!


	MOVEQ #3,D0			INIT MUSIC
	JSR MUSIC

	LEA    $63800,A0		CLEARSCREEN(S)
	MOVE.W #$7200,D0
CLLOOP1	CLR.L (A0)+
	DBF D0,CLLOOP1
	JSR HBLON

MAINLOOP
	MOVE.L #$63800,D0
	MOVE.L #$6D000,LOGBASE
	LSR.W #8,D0
	MOVE.L D0,$FFFF8200.W
	MOVE.L #OLD1,OLDSTORE
	MOVE.L #BOLD1,BIGOLDSTORE
	BSR CHOOSEWAVE
	BSR DO_DOTS

	MOVE.L #$6D000,D0
	MOVE.L #$76800,LOGBASE
	LSR.W #8,D0
	MOVE.L D0,$FFFF8200.W
	MOVE.L #OLD2,OLDSTORE
	MOVE.L #BOLD2,BIGOLDSTORE

	BSR CHOOSEWAVE
	BSR DO_DOTS

	MOVE.L #$76800,D0
	MOVE.L #$63800,LOGBASE
	LSR.W #8,D0
	MOVE.L D0,$FFFF8200.W
	MOVE.L #OLD3,OLDSTORE
	MOVE.L #BOLD3,BIGOLDSTORE
	BSR CHOOSEWAVE
	BSR DO_DOTS

	CMP.B #$39,KBUFF
	BEQ QUIT
	BRA MAINLOOP

CHOOSEWAVE

**********************
* TEXT CHANGER
**********************

	LEA TEXTLIST,A0
	SUB.W #1,8(A0)
	BNE.S GO
	MOVE.L 4(A0),A1
	MOVE.W (A1)+,8(A0)
	MOVE.L A1,4(A0)
	MOVE.L (A0),A1
	LEA 7*40(A1),A1
	MOVE.L A1,(A0)

**********************
* ROTATION CHANGER
**********************
* THE ROTATION ANGLE IN X,Y,Z PLANES
* THE X,Y,Z OFFSET FROM CENTRE
* AND THE VELOCITY AT WHICH THE OBJECT ROTATES ARE ALL CONTROLLABLE
* AND THIS ROUTINE(S) DEALS WITH THIS ASPECT OF THE BALLS
* ALSO THE FRAME CAN BE ANIMATED IF SO REQUIRED

GO
	LEA VELOCITYTABLE(PC),A0
	LEA ANGLETABLE(PC),A1
	MOVE.W #360,D6
	MOVEM.W (A0),D0-D5
	ADD.W D0,D3
	ADD.W D1,D4
	ADD.W D2,D5
	MOVEM.W D3-D5,6(A0)
	CMP.W D6,D3
	BLT.S DOY
	SUB.W D6,D3
	BRA.S DOY1
DOY	TST.W D3
	BPL.S DOY1
	ADD.W D6,D3
DOY1
	CMP.W D6,D4
	BLT.S DOYB
	SUB.W D6,D4
	BRA.S DOY1B
DOYB	TST.W D4
	BPL.S DOY1B
	ADD.W D6,D4
DOY1B
	CMP.W D6,D5
	BLT.S DOYC
	SUB.W D6,D5
	BRA.S DOY1C
DOYC	TST.W D5
	BPL.S DOY1C
	ADD.W D6,D5
DOY1C
	MOVEM.W D3-D5,6(A0)

**********************
* OFFSET CHANGER
*********************

	LEA OFFPOINT(PC),A2
	SUB.W #1,12(A2)
	TST.W 12(A2)
	BNE.S COORDS
	MOVE.L 14(A2),A0
	CMP.L #OFFTABLEEND,A0
	BNE.S COR
	LEA OFFTABLE(PC),A0
	LEA WAVETABLE(PC),A3
	LEA WAVEPOINT(PC),A4
	MOVE.L (A3),(A4)+
	MOVE.L (A3)+,(A4)+
	MOVE.L (A3)+,(A4)+
	MOVE.L (A3)+,(A4)+
	MOVE.W (A3)+,(A4)+
	MOVE.L (A3)+,(A4)+
	MOVE.L A3,(A4)+
	LEA ANGLETABLE(PC),A4
	CLR.L (A4)+
	CLR.W (A4)+
	LEA TEXTLIST,A5
	MOVE.L #TEXT-(7*40),(A5)+
	MOVE.L #TEXTABLE,(A5)+
	MOVE.W #1,(A5)+
COR
	LEA VELOCITYTABLE(PC),A5
	MOVE.L (A0),(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.W (A0)+,(A2)+
	MOVE.L (A0)+,(A5)+
	MOVE.W (A0)+,(A5)+
	MOVE.L A0,(A2)+
	LEA -18(A2),A2
COORDS
	MOVE.L (A2),A0
	CMP.L 8(A2),A0
	BNE.S CH45
	MOVE.L 4(A2),A0
CH45
	LEA OFFSETTABLE(PC),A1
	MOVE.W (A0)+,(A1)+
	MOVE.W (A0)+,(A1)+
	MOVE.W (A0)+,(A1)+
	MOVE.L A0,(A2)

*******************
* FRAME CHANGER
*******************

	LEA WAVEPOINT(PC),A0
	SUB.W #1,12(A0)
	TST.W 12(A0)
	BNE.S BYPASS
	MOVE.L 22(A0),A1
	CMP.L #WTABEND,A1
	BNE.S CONTCH
	LEA WAVETABLE(PC),A1
CONTCH
	MOVE.W 16(A0),D7
	MOVE.L (A1),(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.W (A1)+,(A0)+
	MOVE.L (A1)+,(A0)+
	MOVE.L A1,(A0)+
	LEA -26(A0),A0
	MOVE.W 16(A0),D6
	CMP.W D6,D7
	BNE.S BLANKCOORS
	RTS
BYPASS
	MOVEQ #0,D0
	MOVE.W 14(A0),D0
	MOVE.L (A0),D1
	ADD.L D0,D1
	CMP.L 8(A0),D1
	BNE.S BYPASS2
	MOVE.L 4(A0),D1
BYPASS2
	MOVE.L D1,(A0)

ENDIT

	RTS

BLANKCOORS
	LEA COORDATA,A0
	LEA BOLD1(PC),A1
	LEA BOLD2(PC),A2
	LEA BOLD3(PC),A3
	LEA OLD1(PC),A4
	LEA OLD2(PC),A5
	LEA OLD3(PC),A6
	MOVEQ #63,D0
	MOVE.L #$6D800,D1
LKJ	CLR.L (A0)+
	CLR.L (A0)+
	MOVE.L D1,(A1)+
	MOVE.L D1,(A2)+
	MOVE.L D1,(A3)+
	MOVE.L D1,(A4)+
	MOVE.L D1,(A5)+
	MOVE.L D1,(A6)+
	DBF D0,LKJ
	CLR.W BIGCOUNT
	RTS

WAVEPOINT
CURWAVE	DC.L SQUARE
CURWAVESTORE
	DC.L SQUARE
CUREND	DC.L SQUAREND
WCOUNT	DC.W 1
WINC	DC.W 0
NUM	DC.W 0
CURPAL	DC.L CUBEPAL
	DC.L WAVETABLE
* THIS TABLE SHOWS FIRST THE WAVE FORM START,END TO BE DISPLAYED
*	THEN THE NUMBER OF FRAMES, AMOUNT OF DATA TO BE ADDED TO FRAMEPOINTER
* THIS ALLOWS FOR ANIMATION (ROUTINE CHECKS FOR END AND RESTARTS), AND FINALLY NUMBER OF OBJECTS TO BE DISPLAYED

WAVETABLE

	DC.L SQUARE,SQUAREND
	DC.W 120,0,64
	DC.L AFTERPAL

	DC.L RIPP_IN,RIPP_INEND
	DC.W 9,512,64
	DC.L AFTERPAL

	DC.L RIPPLE,RIPPLEND
	DC.W 211,512,64
	DC.L AFTERPAL

	DC.L RIPP_OUT,RIPP_OUTEND
	DC.W 9,512,64
	DC.L AFTERPAL

	DC.L SQUARE,SQUAREND
	DC.W 3,0,64
	DC.L AFTERPAL

	DC.L SQUARE,SQUAREND
	DC.W 2,0,64
	DC.L AFTERPAL1

	DC.L SQUARE,SQUAREND
	DC.W 2,0,64
	DC.L AFTERPAL2

	DC.L SQUARE,SQUAREND
	DC.W 2,0,64
	DC.L AFTERPAL3

	DC.L SQUARE,SQUAREND
	DC.W 2,0,64
	DC.L AFTERPAL4

	DC.L MERGE,MERGEND
	DC.W 20,512,64
	DC.L AFTERPAL5

	DC.L SPHERE,SPHEREND
	DC.W 190,0,64
	DC.L AFTERPAL5

	DC.L MERGE2,MERGE2END
	DC.W 20,512,64
	DC.L AFTERPAL5

	DC.L TUBE,TUBE_END
	DC.W 100,0,64
	DC.L AFTERPAL5

	DC.L TUBE,TUBE_END
	DC.W 2,0,64
	DC.L AFTERPAL4

	DC.L TUBE,TUBE_END
	DC.W 2,0,64
	DC.L AFTERPAL3

	DC.L TUBE,TUBE_END
	DC.W 2,0,64
	DC.L AFTERPAL2

	DC.L TUBE,TUBE_END
	DC.W 2,0,64
	DC.L AFTERPAL1

	DC.L TUBE,TUBE_END
	DC.W 112,0,64
	DC.L AFTERPAL

	DC.L MERGE3,MERGE3END
	DC.W 20,512,64
	DC.L AFTERPAL

	DC.L SQUARE,SQUAREND
	DC.W 100,0,64
	DC.L AFTERPAL


	DC.L HELI,HELI_END
	DC.W 520,512,64
	DC.L HELIPAL

	DC.L ANIMAL,ANIMAL_END
	DC.W 465,0,37
	DC.L ANIMALPAL

	DC.L BUBBS,BUBBSEND
	DC.W 240,0,40
	DC.L BUBBSPAL

	DC.L MAN,MAN_END
	DC.W 450,0,37
	DC.L MANPAL

	DC.L WOMAN,WOMAN_END
	DC.W 525,0,39
	DC.L WOMANPAL

	DC.L TARDIS,TARDISEND
	DC.W 40,0,1
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 30,0,5
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 20,0,13
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 10,0,21
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 5,0,29
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 5,0,37
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 5,0,45
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 5,0,54
	DC.L TARDISPAL

	DC.L TARDIS,TARDISEND
	DC.W 362,0,54
	DC.L TARDISPAL

	DC.L SPIDER,SPIDEREND
	DC.W 403,0,58
	DC.L SPIDERPAL

	DC.L CUBE,CUBEND
	DC.W 210,0,27
	DC.L CUBEPAL

	DC.L MERGE4,MERGE4END
	DC.W 20,216,27
	DC.L CUBEPAL

	DC.L SPACECUBE,SPACECUBEND
	DC.W 210,0,27
	DC.L CUBEPAL
WTABEND

**********************************
* STANDARD TIMER ROUTINES AND KEY VECTOR
**********************************

QUIT
	MOVE.W #$2700,SR
	MOVE.L OLDSSP,A7
	JSR HBLOFF
	LEA $FFFF8800.W,A1
	MOVE.L #$8080000,(A1)
	MOVE.L #$9090000,(A1)
	MOVE.L #$A0A0000,(A1)
	MOVE.W #$2300,SR
	MOVEQ #$16,D0
	BSR IKBD
	MOVEQ #$8,D0
	BSR IKBD
	RTS

HBLON
	MOVE.L $FFFF8200.W,OLDPHYS
	MOVE.L $120.W,OLDTB		SAVE INTERRUPTS
	MOVE.L $70.W,OLDVBL
	MOVE.L $118.W,OLDKEY
	MOVE.B $FFFFFA07.W,OLD07
	MOVE.B $FFFFFA09.W,OLD09
	MOVE.B $FFFFFA0F.W,OLD0F
	MOVE.B $FFFFFA11.W,OLD11
	MOVE.B $FFFFFA1B.W,OLD1B
	AND.B #$DF,$FFFFFA09.W		THEN SET UP OURS
	AND.B #$FE,$FFFFFA07.W
	MOVE.L #NEWTB2,$120.W
	MOVE.L #VBL,$70.W
	OR.B #1,$FFFFFA07.W
	OR.B #1,$FFFFFA13.W
	BCLR #6,$FFFFFA09.W			PUT IN OUR NEW 
	MOVE.L #KEYVECTOR,$118.W		KEY VECTOR
	BSET #6,$FFFFFA09.W
	RTS

HBLOFF	MOVE.W SR,-(SP)			TAKE OUT ALL OF OUR INTS
	MOVE.W #$2700,SR
	MOVE.B OLD07,$FFFFFA07.W
	MOVE.B OLD09,$FFFFFA09.W
	MOVE.B OLD0F,$FFFFFA0F.W
	MOVE.B OLD11,$FFFFFA11.W
	MOVE.B OLD1B,$FFFFFA1B.W
	MOVE.L OLDTB,$120.W
	MOVE.L OLDVBL,$70.W
	MOVE.L OLDKEY,$118.W
	MOVE.L OLDPHYS,$FFFF8200.W
	MOVE.W (SP)+,SR
	RTS


IKBD	LEA $FFFFFC00.W,A1
IKLOOP	MOVE.B (A1),D1
	BTST #1,D1
	BEQ.S IKLOOP
	MOVE.B D0,2(A1)
	RTS

KEYVECTOR			*THE NEW KEY VECTOR
	MOVE.W D2,-(SP)
	MOVE.B $FFFFFC00.W,D2
	BTST #7,D2
	BEQ.S	VECTOREND
	MOVE.B $FFFFFC02.W,D2
	MOVE.B D2,KBUFF
	BCLR #6,$FFFFFA11.W
VECTOREND
	MOVE.W (SP)+,D2
	RTE

VBL
	MOVEM.L D0-D7/A0-A6,-(A7)
	MOVE.L CURPAL(PC),A0
	MOVEM.L (A0)+,D0-D7
	MOVEM.L D0-D7,$FFFF8240.W
	CLR.B $FFFFFA1B.W
	MOVE.B #189,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUE1,$120.W
	MOVE.L TEXTLIST,A0
	LEA OLDPHYSTORE(PC),A1
	MOVE.L $FFFF8200.W,D0
	LSL.W #8,D0
	CMP.L (A1),D0
	BEQ DOMUS
	MOVE.L D0,(A1)
	MOVE.L D0,A1
	REPT 7				*PUTS TEXT ON TOP LINE
	MOVEM.W (A0)+,D0-D7/A2-A3
	MOVE.W D0,(a1)+
	MOVE.W D0,(a1)+
	MOVE.W D0,(a1)+
	MOVE.W D0,(a1)+
	MOVE.W D1,(a1)+
	MOVE.W D1,(a1)+
	MOVE.W D1,(a1)+
	MOVE.W D1,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	MOVEM.W (A0)+,D0-D7/A2-A3
	MOVE.W D0,(A1)+
	MOVE.W D0,(A1)+
	MOVE.W D0,(A1)+
	MOVE.W D0,(A1)+
	MOVE.W D1,(A1)+
	MOVE.W D1,(A1)+
	MOVE.W D1,(A1)+
	MOVE.W D1,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D2,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D5,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D6,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A2,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	MOVE.W A3,(A1)+
	ENDR

DOMUS
	JSR MUSIC+8			MUSIC
	MOVEM.L (SP)+,D0-D7/A0-A6
	RTE

OLDPHYSTORE
	DC.L 0

BLUE1			* THE BLUE FADE AT THE BOTTOM
	MOVE.W #$1,$FFFF8240.W
	CLR.B $FFFFFA1B.W
	MOVE.B #2,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUE1B,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE
BLUE1B
	MOVE.W #$2,$FFFF8240.W
	CLR.B $FFFFFA1B.W
	MOVE.B #1,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUE1C,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE
BLUE1C
	MOVE.W #$1,$FFFF8240.W
	MOVE.L #BLUE2,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE
BLUE2
	MOVE.W #$2,$FFFF8240.W
	CLR.B $FFFFFA1B.W
	MOVE.B #4,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUE2B,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE
BLUE2B
	MOVE.W #$3,$FFFF8240.W
	CLR.B $FFFFFA1B.W
	MOVE.B #1,$FFFFFA21.W
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUE2C,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE
BLUE2C
	MOVE.W #$2,$FFFF8240.W
	MOVE.L #NEWTB2,$120.W
	BCLR #0,$FFFFFA0F.W
	RTE

NEWTB2	CLR.B $FFFFFA1B	.W		BOTTOM BORDER HBL
	MOVEM.L D0/A0-A1,-(SP)
	MOVE.W #$FA21,A1
	MOVE.B #41,(A1)
	MOVE.B #8,$FFFFFA1B.W
	MOVE.L #BLUEOUT,$120.W
	MOVE.B (A1),D0
WAIT	CMP.B (A1),D0
	BEQ WAIT
	CLR.B $FF820A			60 HZ
	
	MOVEQ #2,D0			WAIT A BIT
NOPI2	NOP
	DBF D0,NOPI2	
	MOVE.B #2,$FF820A		THEN BACK TO 50HZ
	LEA $FFFF8240.W,A1
	MOVE.L CURPAL,A0
	LEA 32(A0),A0
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVE.L (A0)+,(A1)+
	MOVEM.L (SP)+,D0/A0-A1
	BCLR #0,$FFFA0F
	RTE

BLUEOUT
	MOVE.L D0,-(A7)
	MOVE.L A0,-(A7)
	MOVE.L #$00030003,D0
	LEA $FFFF8240.W,A0
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L D0,(A0)+
	MOVE.L (A7)+,A0
	MOVE.L (A7)+,D0
	BCLR #0,$FFFFFA0F.W
	RTE

LOGBASE	DC.L 0
OLDSSP	DC.L 0				ALL THE VARIOUS
OLDPHYS	DC.L 0				THINGS TO BE SAVED
OLDVBL	DC.L 0
OLDTB	DC.L 0
OLDKEY	DC.L 0
KBUFF	DC.W 0
OLD07	DC.B 0
OLD09	DC.B 0
OLD0F	DC.B 0
OLD11	DC.B 0
OLD1B   DC.B 0
	even
	DS.L 100
MYSTACK
BLANK	DS.L 16

***********************************
* END OF STANDARD ROUTINES
************************************

*****************************************************	
*	THIS IS THE COORDINATE CALCULATION ROUTINE
*****************************************************
BIGERASE		* ERASE BIG SPRITES (IF THERE ARE ANY)

		MOVE.W D6,D7
		SUB.W #1,D7

		MOVE.L BIGOLDSTORE(PC),A0
ERASELOOP1
ADDIT		SET 0
		MOVE.L (A0)+,A1
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D5,ADDIT(A1)
ADDIT		SET ADDIT+160
		DBF D7,ERASELOOP1
		BRA.S RETPOINT
	
DO_DOTS
		MOVEM.L BLANK(PC),D0-D5
		MOVE.W BIGCOUNT,D6
		TST.W D6		BIG SPRITES TO ERASE?
		BNE BIGERASE
RETPOINT
		MOVE.W NUM(PC),D7	NOW ERASE THE REST
		SUB.W D6,D7
		TST.W D7
		BEQ.S BYPASS3
		SUBQ.W #1,D7
		MOVE.L OLDSTORE(PC),A0
ERASELOOP
ADDIT		SET 0
		MOVE.L (A0)+,A1
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		MOVEM.L D0-D3,ADDIT(A1)
ADDIT		SET ADDIT+160
		DBF D7,ERASELOOP
BYPASS3

		LEA TRIGBUFF(PC),A2	
		LEA SINTAB(PC),A0	sine table
		LEA 180(A0),A1		cos=sin+90 deg
		MOVEM.W ANGLETABLE(PC),D0-D2    	
xd		ADD D0,D0
		MOVE.W (A0,D0),(A2)+
		MOVE.W (A1,D0),(A2)+
yd		ADD D1,D1
		MOVE.W (A0,D1),(A2)+
		MOVE.W (A1,D1),(A2)+	
zd		ADD D2,D2
		MOVE.W (A0,D2),(A2)+
		MOVE.W (A1,D2),(A2)
		LEA -10(A2),A0		sin & cos values

		LEA MATRIX(PC),A1		storage place
* sinz*sinx(used twice) - D3
		MOVE 8(A0),D0		sinz
		MOVE (A0),D3		sinx
		MULS D0,D3
		ADD.L D3,D3
		SWAP D3
* sinz*cosx(used twice) - D4
		MOVE 2(A0),D4 		cosx(d0=sinz already)
		MULS D0,D4
		ADD.L D4,D4
		SWAP D4
* Matrix(1,1) cosy*cosx-siny*sinz*sinx
		MOVE 6(A0),D0  		cosy
		MOVE 2(A0),D1  		cosx
		MULS D1,D0			cosy*cosx
		MOVE 4(A0),D1		siny
		MULS D3,D1			
		SUB.L D1,D0
		ADD.L D0,D0
		SWAP D0			siny*(sinz*sinx)
		MOVE D0,(A1)+
* Matrix(2,1) siny*cosx+cosy*sinz*sinx 
		MOVE 4(A0),D0		siny
		MOVE 2(A0),D1		cosx
		MULS D1,D0			siny*cosx
		MOVE 6(A0),D1		cosy
		MULS D3,D1			
		ADD.L D1,D0
		ADD.L D0,D0
		SWAP D0			cosy*(sinz*sinx)
		MOVE D0,(A1)+
* Matrix(3,1) -cosz*sinx
		MOVE 10(A0),D0		cosz
		NEG D0
		MOVE (A0),D1		sinx
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			cosz*sinx
		MOVE D0,(A1)+
* Matrix(1,2) -siny*cosz
		MOVE 4(A0),D0		siny
		NEG D0			-siny
		MOVE 10(A0),D1		cosz
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			siny*cosz
		MOVE D0,(A1)+
* Matrix(2,2) cosy*cosz		
		MOVE 6(A0),D0		cosy
		MOVE 10(A0),D1		cosz
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0
		MOVE D0,(A1)+
* Matrix(3,2) sinz 
		MOVE 8(A0),(A1)+
* Matrix(1,3) cosy*sinx+siny*sinz*cosx
		MOVE 6(A0),D0		cosy
		MOVE (A0),D1		sinx
		MULS D1,D0			cosy*sinx
		MOVE 4(A0),D1		siny
		MULS D4,D1
		ADD.L D1,D0
		ADD.L D0,D0
		SWAP D0			siny*(sinz*cosx)
		MOVE D0,(A1)+
* Matrix(2,3) siny*sinx-cosy*sinz*cosx
		MOVE 4(A0),D0		siny
		MOVE (A0),D1		sinx
		MULS D1,D0			siny*sinx		
		MOVE 6(A0),D1		cosy
		MULS D4,D1	
		SUB.L D1,D0
		ADD.L D0,D0
		SWAP D0			cosy*(sinz*cosx)
		MOVE D0,(A1)+
* Matrix(3,3) cosz*cosx
		MOVE 10(A0),D0		cosz
		MOVE 2(A0),D1		cosx
		MULS D1,D0
		ADD.L D0,D0
		SWAP D0			cosz*cosx
		MOVE D0,(A1)

Trans_verts	LEA MATRIX(PC),A2		matrix pointer
		MOVEA #160,A3		centre x
		MOVEA #100,A4		centre y
		MOVEQ #7,D6
		MOVE.W NUM(PC),D7
		SUB.W #1,D7
		MOVE.L CURWAVE(PC),A0
		LEA OFFSETTABLE(PC),A5
		LEA COORDATA,A1

trans_lp	MOVEM.W (A0),D0-D2	x,y,z
		MOVE D0,D3	
		MOVE D1,D4			dup
		MOVE D2,D5
* Calculate x co-ordinate		
		MULS (A2)+,D0			
		MULS (A2)+,D1		mat mult
		MULS (A2)+,D2
		ADD.L D1,D0
		ADD.L D2,D0
		ADD.L D0,D0
		SWAP D0			D0 = x
		ADD.W (A5),D0
* Calculate y co-ordinate		
		MULS (A2)+,D3
		MULS (A2)+,D4		mat mult
		MULS (A2)+,D5
		ADD.L D4,D3
		ADD.L D5,D3
		ADD.L D3,D3
		SWAP D3			D3 = y
		ADD.W 2(A5),D3
* Calculate z co-ordinate
		MOVEM.W (A0)+,D1/D2/D4/D5
		MULS (A2)+,D1
		MULS (A2)+,D2		mat mult
		MULS (A2)+,D4
		ADD.L D1,D4
		ADD.L D2,D4
		ADD.L D4,D4
		SWAP D4			D4 = z
		ADD.W 4(A5),D4
* Combine and Perspect
		EXT.L D0			sign extend
		EXT.L D3			ready for divide
		ASL.L D6,D0			x*dist
		ASL.L D6,D3			y*dist
		DIVS D4,D0			x/z+dist
		DIVS D4,D3			y/z+dist
		MOVE.W D0,(A1)+
		MOVE.W D3,(A1)+
		MOVE.W D5,(A1)+
		MOVE.W D4,(A1)+
		LEA -18(A2),A2		mat(1,1)
		DBF D7,trans_lp

************************************
* SORT COORDINATES ACCORDING TO Z (DEPTH)
* USES BUBBLE SORT ALGORITHM. I TRIED SOME OTHERS
* BUT THIS SEEMED TO BE THE FASTEST ONE.
* WEIRD HUH?????!!!!!!	
************************************

		MOVE.W  NUM(PC),D6		NUMBER TO SORT
		SUBQ.W #1,D6
LOP1
		LEA	COORDATA,A4	ITEMS TO SORT
		MOVE.W 	D6,D1
LOP2
		MOVEM.L (A4),D2-D5
		CMP.W D5,D3
		BGE.S OK1
				*IF SO THEN SWOP
		MOVE.L D4,(A4)+
		MOVE.L D5,(A4)+
		MOVE.L D2,(A4)
		MOVE.L D3,4(A4)
		DBF D1,SWOPLOP2		REPEAT
		DBF D6,LOP1
		BRA.S SHOWTIME
OK1		LEA 8(A4),A4
		DBF D1,LOP2		REPEAT
		BRA.S SHOWTIME

SWOPLOP2
		MOVEM.L (A4),D2-D5
		CMP.W D5,D3
		BGE.S OK2
				*IF SO THEN SWOP
		MOVE.L D4,(A4)+
		MOVE.L D5,(A4)+
		MOVE.L D2,(A4)
		MOVE.L D3,4(A4)
		DBF D1,SWOPLOP2		REPEAT
		DBF D6,LOP1
		BRA.S SHOWTIME
OK2		LEA 8(A4),A4
		DBF D1,SWOPLOP2		REPEAT
		DBF D6,LOP1

SHOWTIME			*ALL SORTED LARGEST Z FIRST SMALLEST Z LAST

		CLR.W BIGCOUNT
		LEA COORDATA,A0
		LEA JUMPTABLE(PC),A1
		MOVE.L LOGBASE(PC),A3
		MOVE.L OLDSTORE(PC),A5
		MOVE.L BIGOLDSTORE(PC),A2
		MOVE.W #160,D7
		MOVE.W NUM(PC),D0
		SUB.W #1,D0
SPLOOP
		MOVE.W 4(A0),D1
		LSL.W #3,D1
		LEA JUMPTABLE(PC,D1.W),A4
		MOVE.L (A4)+,A6
		MOVE.L (A4)+,A4
		JMP (A6)
RETURN	
		DBF D0,SPLOOP
		BSR DO_COPPER		COPY REFLECTION
		RTS
*	A LOOK UP TABLE FOR THE DIFFERENT SPRITE TYPES
*	FIRST FIGURE GIVES SPRITE ROUTINE TO JUMP TO
* SECONG IS THE SPRITE DATA TO BE USED
* 	THE 1ST COMMENT FIGURE IS THE SPRITES SIZE IN PIXELS
*	THE SECOND IS ITS REFERENCE NUMBER AS USED IN THE CONSTRUCTION
* OF THE OBJECTS. WHERE THERE ARE 3 OF THE SAME SIZE THESE ARE THE 3
* DIFFERENT COLOR PALETTES AVAILABLE 5 COLORS PER BALL (5 +5 +5 + BACKGROUND)

JUMPTABLE
		DC.L S1,SPRITE1		16*16	0
		DC.L S1,SPRITE2		16*16	1
		DC.L S1,SPRITE3		16*16	2
		DC.L S2,BIG1		32*32	3
		DC.L S2,BIG2		32*32	4
		DC.L S2,BIG3		32*32	5
		DC.L S2,BIG4		32*32	6
		DC.L S3,SPRITE4		14*14	7
		DC.L S3,SPRITE5		14*14	8
		DC.L S3,SPRITE6		14*14	9
		DC.L S4,SPRITE7		12*12	10
		DC.L S4,SPRITE8		12*12	11
		DC.L S4,SPRITE9		12*12	12
		DC.L S5,SPRITE10	10*10	13
		DC.L S5,SPRITE11	10*10	14
		DC.L S5,SPRITE12	10*10	15
		DC.L S6,SPRITE13	8*8	16
		DC.L S6,SPRITE14	8*8	17
		DC.L S6,SPRITE15	8*8	18
		DC.L S7,SPRITE16	6*6	19
		DC.L S7,SPRITE17	6*6	20
		DC.L S7,SPRITE18	6*6	21

NO_SPRITE1
		LEA 4(A0),A0
		MOVE.L #$76c60,(A5)+
		BRA RETURN
*	NOW FOLLOWS THE CUSTOM ROUTINES FOR DRAWING THE SPRITES 
* EACH SPRITE SIZE HAS ITS OWN ROUTINE
 

S1
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #92,D2
		TST.W D2
		BMI.S NO_SPRITE1
		CMP.W #200,D2
		BGT.S NO_SPRITE1
		ADD.W #152,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 16
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
NO_SPRITE
		LEA 4(A0),A0
		MOVE.L #$76c60,(A2)+
		BRA RETURN

S2
		ADD.W #1,BIGCOUNT
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #86,D2
		TST.W D2
		BMI.S NO_SPRITE
		CMP.W #200,D2
		BGT.S NO_SPRITE
		ADD.W #146,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #3888,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A2)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 27
		MOVEM.L ADDIT(A6),D1-D6
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		AND.L (A4),D5
		AND.L (A4)+,D6
		OR.L  (A4)+,D5
		OR.L (A4)+,D6
		MOVEM.L D1-D6,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
S3
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #93,D2
		TST.W D2
		BMI NO_SPRITE1
		CMP.W #200,D2
		BGT NO_SPRITE1
		ADD.W #153,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 14
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
S4
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #94,D2
		TST.W D2
		BMI NO_SPRITE1
		CMP.W #200,D2
		BGT NO_SPRITE1
		ADD.W #154,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 12
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
S5
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #95,D2
		TST.W D2
		BMI NO_SPRITE1
		CMP.W #200,D2
		BGT NO_SPRITE1
		ADD.W #155,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 10
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
S6
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #96,D2
		TST.W D2
		BMI NO_SPRITE1
		CMP.W #200,D2
		BGT NO_SPRITE1
		ADD.W #156,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 8
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN
S7
		MOVE.W (A0)+,D1
		MOVE.W (A0)+,D2
		ADD.W #97,D2
		TST.W D2
		BMI NO_SPRITE1
		CMP.W #200,D2
		BGT NO_SPRITE1
		ADD.W #157,D1
		MOVE.W D1,D6
		MULU D7,D2
		MOVEQ #15,D4
		AND.W D4,D1
		NOT.W D4
		MULU #4752,D1
		AND.W D4,D6
		LSR.W #1,D6
		ADD.W D6,D2
		ADD.L D1,A4
		MOVE.L A3,A6
		ADD.W D2,A6
		MOVE.L A6,(A5)+
		LEA 4(A0),A0
ADDIT		SET 0
		REPT 6
		MOVEM.L ADDIT(A6),D1-D4
		AND.L (A4),D1
		AND.L (A4)+,D2
		OR.L  (A4)+,D1
		OR.L (A4)+,D2
		AND.L (A4),D3
		AND.L (A4)+,D4
		OR.L  (A4)+,D3
		OR.L (A4)+,D4
		MOVEM.L D1-D4,ADDIT(A6)
ADDIT		SET ADDIT+160
		ENDR
		BRA RETURN

******************************************
* THE AMIGA HAS A COPPERLIST WHICH IT CAN
* USE TO MAKE UP A REFLECTION FOR THE SPRITES
* THE ST DOES NOT SP THIS IS THE ROOT TO 
* EMULATE THIS FEATURE
* IT JUST TAKES EVERY THIRD LINE AND PUTS IT ON THE SCREEN
******************************************

DO_COPPER
		LEA 32000(A3),A2
		LEA 31680(A3),A3

ADDIT		SET 0
ADDIT1		SET 0
		REPT 40
		MOVEM.L ADDIT+8(A3),D2-D7/A0-A1/A4-A6
		MOVEM.L D2-D7/A0-A1/A4-A6,ADDIT1+8(A2)
		MOVEM.L ADDIT+52(A3),D0-D7/A0-A1/A4-A6
		MOVEM.L D0-D7/A0-A1/A4-A6,ADDIT1+52(A2)
		MOVEM.L ADDIT+104(A3),D0-D7/A0-A1/A4-A5
		MOVEM.L D0-D7/A0-A1/A4-A5,ADDIT1+104(A2)
ADDIT		SET ADDIT-480
ADDIT1		SET ADDIT1+160
		ENDR
		RTS
* THIS ROUTINE PRESHIFTS THE SPRITE FRAMES

PREDOSPRITES
	LEA SPRITES,A2
	LEA SPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #197,D0
MASKLOOP
	MOVE.W D0,-(A7)
	MOVEM.W (A0)+,D0-D7
	OR.W D0,D3
	OR.W D1,D3
	OR.W D2,D3
	NOT.W D3
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	OR.W D4,D7
	OR.W D5,D7
	OR.W D6,D7
	NOT.W D7
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W (A7)+,D0
	DBF D0,MASKLOOP

	MOVE.W #15,D7
WHOLELOOP
	MOVE.W D7,-(A7)
	LEA SPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #197,D0
MAKELOOP
	MOVE.L (A1)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A1)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	DBF D0,MAKELOOP

	LEA SPDATA,A0
	MOVE.W #197,D0
ROTLOOP
	ROXR.W (A0)
	ROXR.W 8(A0)
	ROXR.W 2(A0)
	ROXR.W 10(A0)
	ROXR.W 4(A0)
	ROXR.W 12(A0)
	ROXR.W 6(A0)
	ROXR.W 14(A0)
	LEA 16(A0),A0
	DBF D0,ROTLOOP

	LEA SPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #197,D0
MASKLOOP1
	MOVE.W D0,-(A7)
	MOVEM.W (A0)+,D0-D7
	OR.W D0,D3
	OR.W D1,D3
	OR.W D2,D3
	NOT.W D3
	MOVE.W D3,(A1)+
	MOVE.W D3,(A1)+
	OR.W D4,D7
	OR.W D5,D7
	OR.W D6,D7
	NOT.W D7
	MOVE.W D7,(A1)+
	MOVE.W D7,(A1)+
	MOVE.W (A7)+,D0
	DBF D0,MASKLOOP1
	MOVE.W (A7)+,D7
	DBF D7,WHOLELOOP
	RTS

* PRE SHIFTER FOR BIGSPRITES

PREDOBIGSPRITES
	LEA BIG1,A2
	LEA BIGSPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #107,D0
MASKLOOP11
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	DBF D0,MASKLOOP11

	MOVE.W #15,D7
WHOLELOOP2
	MOVE.W D7,-(A7)
	LEA BIGSPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #107,D0
MAKELOOP2
	MOVE.L (A1)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A1)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A1)+,(A2)+
	MOVE.L (A0)+,(A2)+
	MOVE.L (A0)+,(A2)+
	DBF D0,MAKELOOP2

	LEA BIGSPDATA,A0
	MOVE.W #107,D0
ROTLOOP2
	ROXR.W (A0)
	ROXR.W 8(A0)
	ROXR.W 16(A0)

	ROXR.W 2(A0)
	ROXR.W 10(A0)
	ROXR.W 18(A0)

	ROXR.W 4(A0)
	ROXR.W 12(A0)
	ROXR.W 20(A0)

	ROXR.W 6(A0)
	ROXR.W 14(A0)
	ROXR.W 22(A0)

	LEA 24(A0),A0

	DBF D0,ROTLOOP2

	LEA BIGSPDATA,A0
	LEA TEMPBUFF,A1
	MOVE.W #107,D0
MASKLOOP12
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	MOVEM.W (A0)+,D1-D4
	OR.W D1,D4
	OR.W D2,D4
	OR.W D3,D4
	NOT.W D4
	MOVE.W D4,(A1)+
	MOVE.W D4,(A1)+
	DBF D0,MASKLOOP12
	MOVE.W (A7)+,D7
	DBF D7,WHOLELOOP2
	RTS

************************
* THE SIN TABLE DATA IN RANGE -32767 TO 32767
*************************

SINTAB	
	INCBIN "DATA\SIN_TAB.DAT"


OFFSETTABLE
XOFFSET	DC.W 0
YOFFSET	DC.W 0
ZOFFSET	DC.W 800

VELOCITYTABLE
XVEL	DC.W 0
YVEL	DC.W 0
ZVEL	DC.W 0
ANGLETABLE
XANGLE	DC.W 0		ROTATED ANGLE OF OBJECT
YANGLE	DC.W 0
ZANGLE	DC.W 0

TRIGBUFF	
	DS.W 6
MATRIX
	DS.W 9

CUBEPAL	DC.W $000,$300,$400,$500,$600,$700,$033,$044
	DC.W $055,$066,$077,$333,$444,$555,$666,$777
	DC.W $003,$100,$200,$300,$400,$500,$011,$022
	DC.W $033,$044,$055,$111,$222,$333,$444,$555
AFTERPAL
	DC.W $000,$302,$403,$504,$605,$706,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$100,$201,$302,$403,$504,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555
AFTERPAL1
	DC.W $000,$311,$412,$513,$614,$715,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$010,$110,$211,$312,$413,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555
AFTERPAL2
	DC.W $000,$320,$321,$522,$623,$724,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$010,$120,$220,$321,$422,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555
AFTERPAL3
	DC.W $000,$230,$330,$431,$532,$733,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$010,$120,$230,$330,$431,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555
AFTERPAL4
	DC.W $000,$230,$340,$440,$541,$651,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$010,$120,$230,$340,$440,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555
AFTERPAL5
	DC.W $000,$230,$340,$450,$560,$670,$230,$340
	DC.W $450,$560,$670,$777,$777,$777,$777,$777
	DC.W $003,$010,$120,$230,$340,$450,$010,$120
	DC.W $230,$340,$450,$555,$555,$555,$555,$555

HELIPAL	DC.W $000,$030,$040,$050,$060,$070,$320,$430
	DC.W $540,$650,$760,$333,$444,$555,$666,$777
	DC.W $003,$010,$020,$030,$040,$050,$100,$210
	DC.W $320,$430,$540,$111,$222,$333,$444,$555

ANIMALPAL
	DC.W $000,$013,$014,$015,$026,$027,$320,$430
	DC.W $540,$650,$760,$333,$444,$555,$666,$777
	DC.W $003,$001,$002,$013,$014,$015,$100,$210
	DC.W $320,$430,$540,$111,$222,$333,$444,$555

BUBBSPAL
	DC.W $000,$023,$034,$045,$056,$067,$777,$777
	DC.W $777,$777,$777,$777,$777,$777,$777,$777
	DC.W $003,$001,$012,$023,$045,$056,$777,$777
	DC.W $777,$777,$777,$777,$777,$777,$777,$777

MANPAL	DC.W $000,$522,$533,$644,$755,$766,$033,$044
	DC.W $055,$066,$077,$777,$777,$777,$777,$777
	DC.W $003,$300,$311,$422,$533,$533,$011,$022
	DC.W $033,$044,$055,$777,$777,$777,$777,$777

WOMANPAL
	DC.W $000,$522,$533,$644,$755,$766,$320,$430
	DC.W $540,$650,$760,$777,$777,$777,$777,$777
	DC.W $003,$300,$311,$422,$533,$533,$100,$210
	DC.W $320,$430,$540,$777,$777,$777,$777,$777
TARDISPAL
	DC.W $000,$013,$014,$015,$026,$027,$300,$400
	DC.W $500,$600,$700,$333,$444,$555,$666,$777
	DC.W $003,$001,$002,$013,$014,$015,$100,$200
	DC.W $300,$400,$500,$111,$222,$333,$444,$555

SPIDERPAL
	DC.W $000,$130,$240,$350,$460,$570,$300,$400
	DC.W $500,$600,$700,$333,$444,$555,$666,$777
	DC.W $003,$010,$020,$130,$240,$350,$100,$200
	DC.W $300,$400,$500,$111,$222,$333,$444,$555


OLDSTORE	DC.L OLD1
OLD1	REPT 64
	DC.L $76c60
	ENDR
OLD2	REPT 64
	DC.L $76c60
	ENDR
OLD3	REPT 64
	DC.L $76c60
	ENDR

BIGOLDSTORE	DC.L BOLD1
BOLD1	REPT 64
	DC.L $76c60
	ENDR
BOLD2	REPT 64
	DC.L $76c60
	ENDR
BOLD3	REPT 64
	DC.L $76c60
	ENDR

MAKEHELI
	LEA HELIDAT,A0
	LEA HELI+512-64,A1
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.W #18,D0
MAKE_ROOT
	LEA HELI,A2
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D7/A3-A6
	MOVEM.L D1-D7/A3-A6,(A1)
	LEA 44(A1),A1
	MOVEM.L (A2)+,D1-D2
	MOVEM.L D1-D2,(A1)
	LEA 8(A1),A1
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	MOVE.L 	(A0)+,(A1)+
	DBF D0,MAKE_ROOT
	RTS

******************************
* OFFSETTABLES
******************************

OFFPOINT	DC.L Z_150
OFFOLD		DC.L Z_150
OFFEND		DC.L Z_150END
OFFLOOP		DC.W 1
OFFTABLEPOINT	DC.L OFFTABLE
OFFTABLE

*	THE FOLLOWING TABLE CONTAINS THE MOVEMENT DATA FOR THE OBJECTS
*	THE FIRST TWO LONG WORDS POINT TO A LIST OF COORDINATES
* THESE GIVE THE OBJECT AN X ,Y AND Z OFFSET FROM THE CENTRE POINT
* THE THE FIRST WORD GIVES THE DURATION OF THE MOVEMENT (IN FRAMES)
* THE 2ND,3RD AND 4TH WORDS GIVE THE VELOCITY FOR THE ANGLE CHANGE IN EACH PLANE

		DC.L DOWN_600,DOWN_600END
		DC.W 45,3,3,3
		DC.L Z_STATIC,Z_STATICEND
		DC.W 75,3,3,3
		DC.L Z_150,Z_150END
		DC.W 120,3,3,3
		DC.L Z_STATIC,Z_STATICEND
		DC.W 120,3,3,3
		DC.L Z_STATIC,Z_STATICEND
		DC.W 45,4,4,4
		DC.L Z_STATIC,Z_STATICEND
		DC.W 120,3,3,3
		DC.L Z_150,Z_150END
		DC.W 240,3,3,3
		DC.L Z_STATIC,Z_STATICEND
		DC.W 120,3,3,3
		DC.L UP_600,UP_600END
		DC.W 45,4,4,4
		DC.L DOWN_600,DOWN_600END
		DC.W 45,0,0,0
		DC.L Z_STATIC,Z_STATICEND
		DC.W 60,0,0,0
		DC.L Z_STATIC,Z_STATICEND
		DC.W 90,3,0,0
		DC.L Z_STATIC,Z_STATICEND
		DC.W 20,0,-1,1
		DC.L Z_350,Z_350END
		DC.W 120,-6,0,0
		DC.L Z_350,Z_350END
		DC.W 120,-6,0,6
		DC.L Z_STATIC,Z_STATICEND
		DC.W 20,0,1,-1
		DC.L UP_600,UP_600END
		DC.W 45,0,0,0
		DC.L DOWN_600,DOWN_600END
		DC.W 45,4,4,0
		DC.L Z_STATIC,Z_STATICEND
		DC.W 180,3,0,0
		DC.L ANI_230,ANI_230END
		DC.W 120,3,3,3
		DC.L SUBMERGE,SUBMERGEEND
		DC.W 120,3,3,3
		DC.L BUBBLES,BUBBLESEND
		DC.W 240,3,0,0

		DC.L DOWN_600,DOWN_600END
		DC.W 45,4,0,0

		DC.L Z_STATIC,Z_STATICEND
		DC.W 360,4,2,2

		DC.L UP_600,UP_600END
		DC.W 45,4,2,2

		DC.L DOWN_600,DOWN_600END
		DC.W 45,4,-2,-2

		DC.L Z_STATIC,Z_STATICEND
		DC.W 360,4,2,0

		DC.L SUBMERGE,SUBMERGEEND
		DC.W 120,4,3,3

		DC.L Z_STATIC,Z_STATICEND
		DC.W 240,3,0,0
		DC.L Z_150,Z_150END
		DC.W 120,3,3,0
		DC.L SUBMERGE,SUBMERGEEND
		DC.W 120,3,3,0

		DC.L BOUNCE,BOUNCEEND
		DC.W 210,3,0,0

		DC.L Z_STATIC,Z_STATICEND
		DC.W 150,3,0,0

		DC.L UP_600,UP_600END
		DC.W 45,2,0,0

		DC.L DOWN_600,DOWN_600END
		DC.W 45,4,4,4
		DC.L Z_STATIC,Z_STATICEND
		DC.W 350,3,3,3
		DC.L UP_600,UP_600END
		DC.W 45,4,4,4

OFFTABLEEND

****************************
* ROTORS FOR HELICOPTER
****************************

HELIDAT	INCBIN "DATA\HELI_ROT.DAT"

*******************************
* THE OBJECTS
* THE FORMAT IS XPOS,YPOS,ZPOS,SPRITETYPE (ALL WORDS)
*******************************

SQUARE	INCBIN "DATA\SQUARE.DAT"
SQUAREND
RIPP_IN	INCBIN "DATA\RIPP_IN.DAT"
RIPP_INEND
RIPPLE	INCBIN "DATA\RIPPLE.DAT"
RIPPLEND
RIPP_OUT
	INCBIN "DATA\RIPP_OUT.DAT"
RIPP_OUTEND
SPHERE	INCBIN "DATA\SPHERE.DAT"
SPHEREND
MERGE	INCBIN "DATA\MERGE.DAT"
MERGEND
TUBE	INCBIN "DATA\TUBE.DAT"
TUBE_END
MERGE2	INCBIN "DATA\MERGE2.DAT"
MERGE2END
MERGE3	INCBIN "DATA\MERGE3.DAT"
MERGE3END

ANIMAL
	DC.W 0,0,-70,3		BODY
	DC.W 0,0,70,3
	DC.W 0,0,150,14		TAIL
	DC.W 0,-40,190,17
	DC.W 0,-70,230,20

	DC.W 0,60,-130,8	NECK
	DC.W 0,110,-170,8
	DC.W 0,160,-220,8
	DC.W 0,210,-300,3	HEAD

	DC.W 50,260,-300,14	HORNS
	DC.W -50,260,-300,14
	DC.W 70,280,-300,17
	DC.W -70,280,-300,17
	DC.W 90,295,-300,20
	DC.W -90,295,-300,20

	DC.W 30,220,-360,14	EYES
	DC.W -30,220,-360,14
	
	DC.W 90,-40,70,8	LEGS
	DC.W 110,-90,90,8
	DC.W 120,-150,110,8
	DC.W 120,-210,125,8
	DC.W 120,-300,140,3

	DC.W -90,-40,70,8	LEGS
	DC.W -110,-90,90,8
	DC.W -120,-150,110,8
	DC.W -120,-210,125,8
	DC.W -120,-300,140,3

	DC.W 90,-40,-70,8	LEGS
	DC.W 110,-90,-80,8
	DC.W 120,-150,-90,8
	DC.W 120,-210,-95,8
	DC.W 120,-300,-100,3

	DC.W -90,-40,-70,8	LEGS
	DC.W -110,-90,-80,8
	DC.W -120,-150,-90,8
	DC.W -120,-210,-95,8
	DC.W -120,-300,-100,3

ANIMAL_END

MAN
	DC.W 0,210,0,3		HEAD
	DC.W 30,230,-60,14	EYES
	DC.W -30,230,-60,14
	DC.W 0,200,-70,11	NOSE

	DC.W 0,120,0,7		NECK
	DC.W 0,30,0,3		BODY
	DC.W 0,-60,0,3
	DC.W 0,-150,0,3

	DC.W 40,-190,-60,13	BALLS
	DC.W -40,-190,-60,13	
	DC.W 0,-170,-70,16
	DC.W 0,-190,-80,16
	DC.W 0,-230,-85,16

	DC.W 90,-190,0,7	LEGS
	DC.W 110,-240,0,7
	DC.W 120,-300,0,7
	DC.W 120,-360,0,7
	DC.W 120,-450,0,3

	DC.W -90,-190,0,7	LEGS
	DC.W -110,-240,0,7
	DC.W -120,-300,0,7
	DC.W -120,-360,0,7
	DC.W -120,-450,0,3

	DC.W 100,30,0,7		ARMS
	DC.W 130,-20,20,7
	DC.W 150,-70,40,7
	DC.W 160,-130,40,7

	DC.W -100,30,0,7
	DC.W -130,-20,20,7
	DC.W -150,-70,40,7
	DC.W -160,-130,40,7

	DC.W 160,-140,0,10
	DC.W 150,-145,-40,13
	DC.W 145,-150,-80,16

	DC.W -160,-140,0,10
	DC.W -150,-145,-40,13
	DC.W -145,-150,-80,16

MAN_END

WOMAN
	DC.W 0,210,0,3		HEAD
	DC.W 30,230,-60,14	EYES
	DC.W -30,230,-60,14
	DC.W 0,200,-70,11	NOSE

	DC.W 0,120,0,7		NECK
	DC.W 0,30,0,3		BODY
	DC.W 0,-60,0,3
	DC.W 0,-150,0,3

	DC.W 50,0,-70,3		TITS
	DC.W -50,0,-70,3
	DC.W 50,0,-130,20	NIPPS
	DC.W -50,0,-130,20

	DC.W 40,-190,-50,14	VAG
	DC.W -40,-190,-50,14
	DC.W 0,-230,-40,14


	DC.W 90,-190,0,7	LEGS
	DC.W 110,-240,0,7
	DC.W 120,-300,0,7
	DC.W 120,-360,0,7
	DC.W 120,-450,0,3

	DC.W -90,-190,0,7	LEGS
	DC.W -110,-240,0,7
	DC.W -120,-300,0,7
	DC.W -120,-360,0,7
	DC.W -120,-450,0,3

	DC.W 100,30,0,7		ARMS
	DC.W 130,-20,20,7
	DC.W 150,-70,40,7
	DC.W 160,-130,40,7

	DC.W -100,30,0,7
	DC.W -130,-20,20,7
	DC.W -150,-70,40,7
	DC.W -160,-130,40,7

	DC.W 160,-140,0,10
	DC.W 150,-145,-40,13
	DC.W 145,-150,-80,16

	DC.W -160,-140,0,10
	DC.W -150,-145,-40,13
	DC.W -145,-150,-80,16

WOMAN_END
	
BUBBS	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
	DC.W 40,-160,0,10
	DC.W -20,-80,0,0
	DC.W 50,0,0,0
	DC.W -30,-60,0,13
BUBBSEND
CUBE
	DC.W 140,140,140,6
	DC.W 0,140,140,6
	DC.W -140,140,140,6
	DC.W 140,0,140,6
	DC.W 0,0,140,6
	DC.W -140,0,140,6
	DC.W 140,-140,140,6
	DC.W 0,-140,140,6
	DC.W -140,-140,140,6
	DC.W 140,140,0,6
	DC.W 0,140,0,6
	DC.W -140,140,0,6
	DC.W 140,0,0,6
	DC.W 0,0,0,6
	DC.W -140,0,0,6
	DC.W 140,-140,0,6
	DC.W 0,-140,0,6
	DC.W -140,-140,0,6
	DC.W 140,140,-140,6
	DC.W 0,140,-140,6
	DC.W -140,140,-140,6
	DC.W 140,0,-140,6
	DC.W 0,0,-140,6
	DC.W -140,0,-140,6
	DC.W 140,-140,-140,6
	DC.W 0,-140,-140,6
	DC.W -140,-140,-140,6
CUBEND

HELI	DC.W 240,100,160,0	SKIDRIGHT
	DC.W 240,100,80,0
	DC.W 240,100,0,0
	DC.W 240,100,0,0
	DC.W 240,100,-70,7
	DC.W 240,100,-130,10
	DC.W 240,100,-180,13

	DC.W -240,100,160,0	SKIDLEFT
	DC.W -240,100,80,0
	DC.W -240,100,0,0
	DC.W -240,100,0,0
	DC.W -240,100,-70,7
	DC.W -240,100,-130,10
	DC.W -240,100,-180,13

	DC.W -180,60,40,13
	DC.W -180,60,-40,13

	DC.W 180,60,40,13
	DC.W 180,60,-40,13
	
	DC.W 0,10,-180,10	BOTTOM
	DC.W 0,30,-100,0
	DC.W 0,30,-20,0
	DC.W 0,30,60,0
	DC.W 0,10,120,10

	DC.W 80,10,-180,10
	DC.W 80,30,-100,0
	DC.W 80,30,-20,0
	DC.W 80,30,60,0
	DC.W 80,10,120,10

	DC.W -80,10,-180,10
	DC.W -80,30,-100,0
	DC.W -80,30,-20,0
	DC.W -80,30,60,0
	DC.W -80,10,120,10

	DC.W 80,-50,-180,0
	DC.W 80,-50,-100,0
	DC.W 80,-50,-20,0
	DC.W 80,-50,60,2
	DC.W 0,-50,60,2

	DC.W -80,-50,-180,0
	DC.W -80,-50,-100,0
	DC.W -80,-50,-20,0
	DC.W -80,-50,60,2

	DC.W 70,-120,-180,7
	DC.W 80,-130,-100,0
	DC.W 80,-130,-20,2

	DC.W -70,-120,-180,7
	DC.W -80,-130,-100,0
	DC.W -80,-130,-20,2

	DC.W 0,-130,-180,0
	DC.W 0,-130,-100,0
	DC.W 0,-130,-20,2
	
	DC.W 0,-50,-220,0
	DC.W 0,-60,-290,7
	DC.W 0,-70,-350,10
	DC.W 0,-80,-400,13

	DC.W 0,-170,-100,11
	DS.W 32
	DS.B 512*19	
HELI_END
TARDIS
	DC.W 0,280,0,1

	DC.W -40,200,-40,0
	DC.W -40,200,40,0
	DC.W 40,200,-40,0
	DC.W 40,200,40,0

	DC.W -80,120,-80,0
	DC.W -80,120,0,0
	DC.W -80,120,80,0
	DC.W 80,120,-80,0
	DC.W 80,120,0,0
	DC.W 80,120,80,0
	DC.W 0,120,-80,0
	DC.W 0,120,80,0

	DC.W -70,40,-70,7
	DC.W -70,40,0,7
	DC.W -70,40,70,7
	DC.W 70,40,-70,7
	DC.W 70,40,0,7
	DC.W 70,40,70,7
	DC.W 0,40,-70,7
	DC.W 0,40,70,7

	DC.W -70,-40,-70,7
	DC.W -70,-40,0,9
	DC.W -70,-40,70,7
	DC.W 70,-40,-70,7
	DC.W 70,-40,0,9
	DC.W 70,-40,70,7
	DC.W 0,-40,-70,9
	DC.W 0,-40,70,9

	DC.W -70,-120,-70,7
	DC.W -70,-120,0,7
	DC.W -70,-120,70,7
	DC.W 70,-120,-70,7
	DC.W 70,-120,0,7
	DC.W 70,-120,70,7
	DC.W 0,-120,-70,7
	DC.W 0,-120,70,7

	DC.W -70,-200,-70,7
	DC.W -70,-200,0,7
	DC.W -70,-200,70,7
	DC.W 70,-200,-70,7
	DC.W 70,-200,0,7
	DC.W 70,-200,70,7
	DC.W 0,-200,-70,7
	DC.W 0,-200,70,7

	DC.W -70,-280,-70,7
	DC.W -70,-280,0,7
	DC.W -70,-280,70,7
	DC.W 70,-280,-70,7
	DC.W 70,-280,0,7
	DC.W 70,-280,70,7
	DC.W 0,-280,-70,7
	DC.W 0,-280,70,7
	DC.W 0,-280,0,7

TARDISEND

SPIDER
		DC.W 0,0,-80,3		*SPIDER
		DC.W 0,0,80,3
		
		DC.W 40,13,150,1
		DC.W -40,13,150,1

		DC.W 120,0,-108,0
		DC.W 165,60,-118,0
		DC.W 210,0,-138,0
		DC.W 255,-60,-158,0
		DC.W 288,-120,-178,0

		DC.W -120,0,-108,0
		DC.W -165,60,-118,0
		DC.W -210,0,-138,0
		DC.W -255,-60,-158,0
		DC.W -288,-120,-178,0

		DC.W 120,0,70,0
		DC.W 165,60,93,0
		DC.W 210,0,100,0
		DC.W 255,-60,120,0
		DC.W 288,-120,140,0

		DC.W -120,0,70,0
		DC.W -165,60,93,0
		DC.W -210,0,100,0
		DC.W -255,-60,120,0
		DC.W -288,-120,140,0

		DC.W 120,0,12,0
		DC.W 165,60,12,0
		DC.W 210,0,12,0
		DC.W 255,-60,12,0
		DC.W 288,-120,12,0

		DC.W -120,0,12,0
		DC.W -165,60,12,0
		DC.W -210,0,12,0
		DC.W -255,-60,12,0
		DC.W -288,-120,12,0		 

		DC.W 120,0,-63,0
		DC.W 165,60,-63,0
		DC.W 210,0,-63,0
		DC.W 255,-60,-63,0
		DC.W 288,-120,-63,0

		DC.W -120,0,-63,0
		DC.W -165,60,-63,0
		DC.W -210,0,-63,0
		DC.W -255,-60,-63,0
		DC.W -288,-120,-63,0

		DC.W 0,60,0,18
		DC.W 0,140,0,18
		DC.W 0,220,0,18
		DC.W 0,300,0,18
		DC.W 0,380,0,18
		DC.W 0,460,0,18
		DC.W 0,540,0,18
		DC.W 0,620,0,18
		DC.W 0,700,0,18
		DC.W 0,780,0,18
		DC.W 0,860,0,18
		DC.W 0,940,0,18
		DC.W 0,1020,0,18
		DC.W 0,1100,0,18

SPIDEREND

SPACECUBE
	DC.W 140,140,0,6
	DC.W 0,140,0,6
	DC.W -140,140,0,6
	DC.W 140,0,0,6
	DC.W 0,0,0,6
	DC.W -140,0,0,6
	DC.W 140,-140,0,6
	DC.W 0,-140,0,6
	DC.W -140,-140,0,6	*9
	DC.W 0,0,140,6
	DC.W 0,0,-140,6
	DC.W -280,0,0,6
	DC.W 280,0,0,6
	DC.W -420,0,0,6
	DC.W 420,0,0,6
	DC.W 0,0,280,6
	DC.W 0,0,-280,6
	DC.W 0,-280,0,6		*18
	DC.W 0,-420,0,6
	DC.W 0,280,0,6
	DC.W 0,420,0,6
	DC.W 140,420,0,6
	DC.W -140,420,0,6
	DC.W 140,-420,0,6
	DC.W -140,-420,0,6
	DC.W 0,0,420,6
	DC.W 0,0,-420,6

	
SPACECUBEND
MERGE4
	INCBIN "DATA\MERGE4.DAT"
MERGE4END

BIGCOUNT	DC.W 0

* HERE FOLLOWS THE MOVEMENT DATA FOR THE VARIOUS EFFECTS WHICH THE OBJECTS UNDERGO

ANI_230	INCBIN "DATA\ANI_230.DAT"
ANI_230END
SUBMERGE	INCBIN "DATA\SUBMERGE.DAT"
SUBMERGEEND

Z_150	INCBIN "DATA\Z_150.DAT"
Z_150END
Z_350	INCBIN "DATA\Z_350.DAT"
Z_350END
Z_STATIC	DC.W 0,0,850
Z_STATICEND
UP_600	INCBIN "DATA\UP_600.DAT"
UP_600END
DOWN_600	INCBIN "DATA\DOWN_600.DAT"
DOWN_600END
BUBBLES	INCBIN "DATA\BUBBLES.DAT"
BUBBLESEND
BOUNCE	INCBIN "DATA\BOUNCE"
BOUNCEEND
******************************
* MUSIC BY MAD MAX
******************************

MUSIC	INCBIN "MUSIC\MUSIC.DAT"

******************************
* THE TEXT
* THIS TABLE SHOWS THE NUMBER OF FRAMES THAT EACH TEXT LINE IS DISPLAYED FOR
******************************

TEXTABLE
	DC.W 96,96,96,96,96,96,96,96,96,96,100
	DC.W 170,240,200
	DC.W 250,240,300
	DC.W 200,475,170,90,90,180,102,102,102,102,5000

TEXTLIST
	DC.L TEXT-(7*40)
TEXTPOINT	DC.L TEXTABLE
TCOUNT	DC.W 1
	DS.W 	7*20
TEXT	INCBIN "DATA\TEXT.DAT"

*******************************
* THE SPRITES
*******************************

COORDATA
BIGSPDATA	INCBIN "DATA\BIGBALLS.DAT"
SPDATA	INCBIN "DATA\BALLS.DAT"
BIG1		EQU SPDATA
BIG2		EQU BIG1+972
BIG3		EQU BIG2+972
BIG4		EQU BIG3+972

*******************************
* THE STORED COORDATA
*******************************

SPRITES		EQU SPDATA+62208
SPRITE1		EQU	SPRITES		16*16
SPRITE2		EQU SPRITE1+384		16*16
SPRITE3		EQU SPRITE2+384		16*16
SPRITE4		EQU SPRITE3+384		14*14
SPRITE5		EQU SPRITE4+336		14*14
SPRITE6		EQU SPRITE5+336		14*14
SPRITE7		EQU SPRITE6+336		12*12
SPRITE8		EQU SPRITE7+288		12*12
SPRITE9		EQU SPRITE8+288		12*12
SPRITE10	EQU SPRITE9+288		10*10
SPRITE11	EQU SPRITE10+240	10*10
SPRITE12	EQU SPRITE11+240	10*10
SPRITE13	EQU SPRITE12+240	8*8
SPRITE14 	EQU SPRITE13+192	8*8
SPRITE15	EQU SPRITE14+192	8*8
SPRITE16 	EQU SPRITE15+192	6*6
SPRITE17	EQU SPRITE16+144	6*6
SPRITE18	EQU SPRITE17+144	6*6


TEMPBUFF	EQU SPRITES+76032
