;*******************************
;*COPYRIGHT(C)1992 RALPH RUDZKI*
;*******************************
	JMP	START
	DC.B	"_IDEA/CODING/MUSIC COMPOSING: RALPH RUDZKI (WARSAW'92)_"
	even
PIC:	INCBIN	\GAME.S\SLALOM.PI1

START:	PEA	0
	MOVE.W	#$20,-(A7)
	TRAP	#1
	LEA	6(A7),A7
	MOVE.L	A7,SSR+2
	MOVE.L	USP,A5 
	MOVE.L	A5,USR+2
	MOVE.B	#$13,D0
	BSR	OUTPUT
	MOVE.W	#$2700,SR
	LEA	MY_STACK,A7
	MOVE.B	$FFFF8260.W,D5
	AND.W	#$3,D5
	CMP.W	#2,D5
	BEQ	QUIT
	MOVE.W	D5,RES+2
	MOVE.L	$44E.W,LOG+2
	MOVE.L	$44E.W,PHY+2
	MOVE.B	$FFFF820A.W,SYNC+3
	MOVE.L	$FFFF8240.W,COL1+2
	MOVE.L	$FFFF8244.W,COL2+2
	MOVE.L	$FFFF8248.W,COL3+2
	MOVE.L	$FFFF824C.W,COL4+2
	MOVE.L	$FFFF8250.W,COL5+2
	MOVE.L	$FFFF8254.W,COL6+2
	MOVE.L	$FFFF8258.W,COL7+2
	MOVE.L	$FFFF825C.W,COL8+2
	MOVE.B	$FFFFFA07.W,MFP07+3
	MOVE.B	$FFFFFA09.W,MFP09+3
	MOVE.B	$FFFFFA13.W,MFP13+3
	MOVE.B	$FFFFFA15.W,MFP15+3
	MOVE.B	$FFFFFA17.W,MFP17+3
	MOVE.B	$FFFFFA1B.W,MFP1B+3
	MOVE.B	$FFFFFA1D.W,D7
	AND.B	#$F,D7
	MOVE.B	D7,MFP1D+3
	MOVE.B	$FFFFFA21.W,MFP21+3
	MOVE.B	$FFFFFA25.W,MFP25+3
	MOVE.L	$70.W,OLDVBL+2
	MOVE.L	$110.W,OLDDIG+2
	MOVE.L	$118.W,OLDKBD+2
	MOVE.L	$120.W,OLDHBL+2
	MOVE.L	$404.W,OLDERR+2

	MOVE.L	#$31415926,$426.W
	MOVE.L	#RESET,$42A.W
	MOVE.L	#ERROR,$404.W
	MOVE.L	#INT,$70.W
	MOVE.L	#DIGIDRUMS,$110.W
	MOVE.L	#KBD,$118.W
	MOVE.L	#RET,$120.W

	MOVE.B	#1,$FFFFFA07.W
	MOVE.B	#64,$FFFFFA09.W
	MOVE.B	#1,$FFFFFA13.W
	MOVE.B	#64,$FFFFFA15.W
	BCLR	#3,$FFFFFA17.W
	CLR.B	$FFFFFA1B.W
	AND.B	#$F0,$FFFFFA1D.W
	OR.B	#1,$FFFFFA1D.W
	CLR.B	$FFFFFA21.W
	MOVE.B	#$3C,$FFFFFA25.W
	CLR.B	$485.W
	MOVE.W	#$2300,SR
	MOVE.B	#$14,D0
	BSR	OUTPUT
	MOVE.B	#$12,D0
	BSR	OUTPUT
	MOVE.B	#$11,D0
	BSR	OUTPUT
	BSR	INPUT
	MOVE.W	#37,-(A7)
	TRAP	#14
	LEA	2(A7),A7
	MOVE.B	#2,$FFFF820A.W
	CLR.W	-(A7)
	PEA	$70000
	PEA	$70000
	MOVE.W	#5,-(A7)
	TRAP	#14
	LEA	12(A7),A7
	LEA	$FFFF8240.W,A5
	MOVE.W	(A5),D5
	AND.W	#$777,D5
	CMP.W	#$777,D5
	BNE	CASIO
	BSR	ANDROMEDA
CASIO:	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	CLR.L	(A5)+
	BSR	PRINT
	BSR	FLASH
	CLR.W	-(A7)
	PEA	$78000
	PEA	$78000
	MOVE.W	#5,-(A7)
	TRAP	#14
	LEA	12(A7),A7

	JMP	GAME
GAME_OVER:
	MOVE.L	#INT,$70.W
	BCLR	#4,$FFFFFA09.W
	BCLR	#4,$FFFFFA15.W
	MOVE.L	#$08080000,$FFFF8840.W
	MOVE.L	#$09090000,$FFFF8840.W
	MOVE.L	#$0A0A0000,$FFFF8840.W
RES:	MOVE.W	#0,-(A7)
LOG:	MOVE.L	#0,-(A7)
PHY:	MOVE.L	#0,-(A7)
	MOVE.W	#5,-(A7)
	TRAP	#14
	LEA	12(A7),A7
	BSR	BSAVE
	CLR.L	$426.W
	MOVE.W	#37,-(A7)
	TRAP	#14
	LEA	2(A7),A7
SYNC:	MOVE.B	#0,$FFFF820A.W
	MOVE.B	#$13,D0
	BSR	OUTPUT
	MOVE.W	#$2700,SR
OLDERR:	MOVE.L	#0,$404.W
OLDVBL:	MOVE.L	#0,$70.W
OLDDIG:	MOVE.L	#0,$110.W
OLDKBD:	MOVE.L	#0,$118.W
OLDHBL:	MOVE.L	#0,$120.W
MFP07:	MOVE.B	#0,$FFFFFA07.W
MFP09:	MOVE.B	#0,$FFFFFA09.W
MFP13:	MOVE.B	#0,$FFFFFA13.W
MFP15:	MOVE.B	#0,$FFFFFA15.W
MFP17:	MOVE.B	#0,$FFFFFA17.W
MFP1B:	MOVE.B	#0,$FFFFFA1B.W
	AND.B	#$F0,$FFFFFA1D.W
MFP1D:	OR.B	#0,$FFFFFA1D.W
MFP21:	MOVE.B	#0,$FFFFFA21.W
MFP25:	MOVE.B	#0,$FFFFFA25.W
COL1:	MOVE.L	#0,$FFFF8240.W
COL2:	MOVE.L	#0,$FFFF8244.W
COL3:	MOVE.L	#0,$FFFF8248.W
COL4:	MOVE.L	#0,$FFFF824C.W
COL5:	MOVE.L	#0,$FFFF8250.W
COL6:	MOVE.L	#0,$FFFF8254.W
COL7:	MOVE.L	#0,$FFFF8258.W
COL8:	MOVE.L	#0,$FFFF825C.W
QUIT:	MOVE.W	#$2300,SR
	MOVE.B	#$08,D0
	BSR	OUTPUT
	MOVE.B	#$11,D0
	BSR	OUTPUT
	BSR	INPUT
USR:	MOVE.L	#0,A5
	MOVE.L	A5,USP
SSR:	MOVE.L	#0,A7
	PEA	0
	MOVE.W	#$20,-(A7)
	TRAP	#1
	LEA	6(A7),A7
	CLR.W	-(A7)
	TRAP	#1

KEY:	DC.B	0
JOY:	DC.B	0
KBD:	MOVE.W	#$2500,SR
	MOVE.B	$FFFFFC02.W,$485.W
	CMP.B	#$FE,$485.W
	BEQ	STK1
	CMP.B	#$FF,$485.W
	BEQ	STK2
	MOVE.B	$485.W,KEY
	TST.B	NOPASS+3
	BEQ	CTO0
	RTE

CTO0:	CMP.B	#29,KEY
	BNE	CTO1
	ST	A_G+3
	CLR.B	A_D+3
CTO1:	CMP.B	#128+29,KEY
	BNE	CTO2
	CLR.B	A_G+3
CTO2:	CMP.B	#56,KEY
	BNE	CTO3
	CLR.B	A_G+3
	ST	A_D+3
CTO3:	CMP.B	#128+56,KEY
	BNE	CTO4
	CLR.B	A_D+3
CTO4:
	CMP.B	#74,KEY
	BNE	CTO5
	ST	B_G+3
	CLR.B	B_D+3
CTO5:	CMP.B	#128+74,KEY
	BNE	CTO6
	CLR.B	B_G+3
CTO6:	CMP.B	#114,KEY
	BNE	CTO7
	CLR.B	B_G+3
	ST	B_D+3
CTO7:	CMP.B	#128+114,KEY
	BNE	CTO8
	CLR.B	B_D+3
CTO8:	RTE

STK1:	MOVE.L	#KBD1,$118.W
	RTE
STK2:	MOVE.L	#KBD2,$118.W
	RTE

KBD1:	MOVE.W	#$2500,SR
	MOVE.B	$FFFFFC02.W,$485.W
	MOVE.L	#KBD,$118.W
	RTE
KBD2:	MOVE.W	#$2500,SR
	MOVE.B	$FFFFFC02.W,JOY
	MOVE.L	#KBD,$118.W
	RTE

INPUT:	BTST	#0,$FFFFFC00.W
	BEQ	IRET
	MOVE.B	$FFFFFC02.W,D0
	BRA	INPUT
IRET:	RTS

OUTPUT:	BTST	#1,$FFFFFC00.W
	BEQ	OUTPUT
	MOVE.B	D0,$FFFFFC02.W
	RTS

ONE1:	DC.L	$78000+160*8
TWO2:	DC.L	$70000+160*8
CHANGE:	MOVEM.L	ONE1,A5/A6
	EXG.L	A5,A6
	MOVEM.L	A5/A6,ONE1
	MOVE.L	A5,D5
	SUB.L	#160*8,D5
	LSR.L	#8,D5
	MOVE.B	D5,$FFFF8203.W	
	LSR.L	#8,D5
	MOVE.B	D5,$FFFF8201.W
	MOVE.L	$466.W,D6
BLINK:	CMP.L	$466.W,D6
	BEQ	BLINK
	RTS

ERROR:	MOVEQ	#-1,D0
	RTS
FNAME:	DC.B	'SLALOM.INF',0
	EVEN
BLOAD:	MOVE.W	#2,-(A7)
	PEA	FNAME
	MOVE.W	#$3D,-(A7)
	TRAP	#1
	LEA	8(A7),A7
	TST.W	D0
	BMI	BL
	MOVE.W	D0,CLOSE+2
	PEA	SAVE
	PEA	60
	MOVE.W	D0,-(A7)
	MOVE.W	#$3F,-(A7)
	TRAP	#1
	LEA	12(A7),A7
	TST.L	D0
	BMI	BL
CLOSE:	MOVE.W	#0,-(A7)
	MOVE.W	#$3E,-(A7)
	TRAP	#1
	LEA	4(A7),A7
	BSR	XOR
BL:	RTS

BSAVE:	BSR	XOR
	CLR.W	-(A7)
	PEA	FNAME
	MOVE.W	#$3C,-(A7)
	TRAP	#1
	LEA	8(A7),A7
	TST.W	D0
	BMI	BS
	MOVE.W	D0,CLOSED+2
	PEA	SAVE
	PEA	60
	MOVE.W	D0,-(A7)
	MOVE.W	#$40,-(A7)
	TRAP	#1
	LEA	12(A7),A7
	TST.L	D0
	BMI	BS
CLOSED:	MOVE.W	#0,-(A7)
	MOVE.W	#$3E,-(A7)
	TRAP	#1
	LEA	4(A7),A7
BS:	RTS

XOR:	LEA	HI_SCORES,A5
	MOVEQ	#24,D5
EXOR:	EOR.W	#$1992,(A5)+
	DBF	D5,EXOR
	RTS

RESET:	CLR.B	$FFFFFA07.W
	CLR.B	$FFFFFA09.W
	MOVE.L	#INT,$70.W
	LEA	MY_STACK,A7
	MOVE.W	#$2300,SR
	LEA	$70000,A0
	MOVE.L	A0,$FFFF8200.W
	MOVE.L	$466.W,D7
SET0:	CMP.L	$466.W,D7
	BEQ	SET0
	MOVE.B	#2,$FFFF820A.W
	MOVE.W	#32000/4-1,D7
SET1:	CLR.L	(A0)+
	DBF	D7,SET1
	CLR.L	$FFFF8240.W
	CLR.L	$FFFF8244.W
	CLR.L	$FFFF8248.W
	CLR.L	$FFFF824C.W
	CLR.L	$FFFF8250.W
	CLR.L	$FFFF8254.W
	CLR.L	$FFFF8258.W
	CLR.L	$FFFF825C.W
	MOVE.L	#BYE,PRINT+2
	CLR.L	ATH
	BSR	PRINT
	BSR	GANIMEDE
	CLR.L	$426.W
SET3:	CMP.B	#$39,$FFFFFC02.W
	BNE	SET3
	MOVE.L	$4.W,A0
	JMP	(A0)
	RTE

BYE:	DC.B	' IT`S BETTER TO EXIT THIS PROGRAM USING',13,10
	DC.B	' "ESC" BECAUSE THEN, ALL RECORDS ARE',13,10
	DC.B	' SAVED TO DISK (SLALOM.INF).',13,10,10,10
	DC.B	'             ** ** ** ** **',13,10,10,10
	DC.B	'****************************************'
	DC.B	'* SOON COMING FROM BUDGIE:             *'
	DC.B	'*  SINCLAIR ZX SPECTRUM EMULATOR ON ST *'
	DC.B	'*  (SOME CLASSIC ZX GAMES INCLUDED !!) *'
	DC.B	'****************************************'
	DC.B	10,10,10,10,10,10,10,10,10,10,10,13
	DC.B	'                                    R.R.',0

TIMER:	DC.W	5
TIME:	SUB.W	#0,TIMER
	TST.W	TIMER
	BEQ	DEG1
	RTS
DEG1:	MOVE.W	#5,TIMER
	ADDQ.W	#1,DG5
	CMP.W	#10,DG5
	BEQ	DEG2
	RTS
DEG2:	CLR.W	DG5
	ADDQ.W	#1,DG4
	CMP.W	#10,DG4
	BEQ	DEG3
	RTS
DEG3:	CLR.W	DG4
	ADDQ.W	#1,DG3
	CMP.W	#6,DG3
	BEQ	DEG4
	RTS
DEG4:	CLR.W	DG3
	ADDQ.W	#1,DG2
	CMP.W	#10,DG2
	BEQ	DEG5
	RTS
DEG5:	CLR.W	DG2
	ADDQ.W	#1,DG1
	CMP.W	#6,DG1
	BEQ	DEG6
	RTS
DEG6:	CLR.W	DG1
	RTS

VBL:	CLR.B	$FFFFFA1B.W
	MOVE.B	#7,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#HBL,$120.W
	MOVE.L	#$00000702,$FFFF8240.W
	MOVE.L	#$06020502,$FFFF8244.W
	MOVE.L	#$04020302,$FFFF8248.W
	MOVE.L	#$02020102,$FFFF824C.W
	MOVE.L	#$07640775,$FFFF8250.W
	MOVE.L	#$07750775,$FFFF8254.W
	MOVE.L	#$07750775,$FFFF8258.W
	MOVE.L	#$07750775,$FFFF825C.W

	MOVEM.L	D0-D7/A1-A6,-(A7)
	BSR	MADMAX
	BSR	SCROLLINE

	MOVE.L	POS_Y,D5
	ADD.L	#160000,D5
	MOVE.L	D5,D6
	DIVU	#160,D5
	MULU	#160,D5
	SUB.L	D5,D6

	CMP.L	#120,D6
	BMI	NO120
	MOVE.L	#LIGHT2,OFF0+2
	MOVE.L	#160,D7
	SUB.L	D6,D7
	MOVE.B	#40,OFF1+3
	MOVE.B	#40,OFF2+3
	MOVE.B	#40,OFF3+3
	MOVE.B	D7,OFF4+3
	BRA	NO0
NO120:	CMP.L	#80,D6
	BMI	NO80
	MOVE.L	#DARK2,OFF0+2
	MOVEQ	#120,D7
	SUB.L	D6,D7
	MOVE.B	#40,OFF1+3
	MOVE.B	#40,OFF2+3
	MOVE.B	D7,OFF3+3
	MOVE.B	#40,OFF4+3
	BRA	NO0
NO80:	CMP.L	#40,D6
	BMI	NO40
	MOVE.L	#LIGHT1,OFF0+2
	MOVEQ	#80,D7
	SUB.L	D6,D7
	MOVE.B	#40,OFF1+3
	MOVE.B	D7,OFF2+3
	MOVE.B	#40,OFF3+3
	MOVE.B	#40,OFF4+3
	BRA	NO0
NO40:	MOVE.L	#DARK1,OFF0+2
	MOVEQ	#40,D7
	SUB.L	D6,D7
	MOVE.B	D7,OFF1+3
	MOVE.B	#40,OFF2+3
	MOVE.B	#40,OFF3+3
	MOVE.B	#40,OFF4+3
NO0:
	MOVEM.L	(A7)+,D0-D7/A1-A6

	CMP.B	#$1,KEY
	BNE	INT
	MOVE.L	#GAME_OVER,2(A7)
INT:	ADDQ.L	#1,$466.W
	RTE
	
HBL:	MOVEM.L	A5/A6,-(A7)
	LEA	PIC+12,A5
	LEA	$FFFF824A.W,A6
	MOVE.W	(A5)+,(A6)+
	MOVE.L	(A5)+,(A6)+
	MOVE.L	(A5)+,(A6)+
	MOVE.L	(A5)+,(A6)+
	MOVE.L	(A5)+,(A6)+
	MOVE.L	(A5)+,(A6)+
	MOVEM.L	(A7)+,A5/A6
	CLR.B	$FFFFFA1B.W
	MOVE.B	#1,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
OFF0:	MOVE.L	#DARK1,$120.W
RET:	RTE

DARK1:	MOVE.L	#$00030005,$FFFF8242.W
	MOVE.L	#$00070117,$FFFF8246.W
	MOVE.W	#$0227,$FFFF824A.W
	CLR.B	$FFFFFA1B.W
OFF1:	MOVE.B	#40,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#LIGHT1,$120.W
	MOVE.B	#40,OFF1+3
	RTE

DARK2:	MOVE.L	#$01000200,$FFFF8242.W
	MOVE.L	#$03000310,$FFFF8246.W
	MOVE.W	#$0320,$FFFF824A.W
	CLR.B	$FFFFFA1B.W
OFF3:	MOVE.B	#40,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#LIGHT2,$120.W
	MOVE.B	#40,OFF3+3
	RTE

LIGHT1:	MOVE.L	#$03030405,$FFFF8242.W
	MOVE.L	#$04070417,$FFFF8246.W
	MOVE.W	#$0527,$FFFF824A.W
	CLR.B	$FFFFFA1B.W
OFF2:	MOVE.B	#40,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#DARK2,$120.W
	MOVE.B	#40,OFF2+3
	RTE

LIGHT2:	MOVE.L	#$02200321,$FFFF8242.W
	MOVE.L	#$03310432,$FFFF8246.W
	MOVE.W	#$0442,$FFFF824A.W
	CLR.B	$FFFFFA1B.W
OFF4:	MOVE.B	#40,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#DARK1,$120.W
	MOVE.B	#40,OFF4+3
	RTE

		DS.L	396
MY_STACK:	DS.L	4

GAME:	LEA	PIC+34,A3
	LEA	DATA,A4
	MOVEQ	#63,D7
TRANS:	MOVEM.L	(A3),A5-A6/D1-D6
	MOVEM.L	D1-D6/A5-A6,(A4)
	MOVEM.L	D1-D6/A5-A6,32(A4)
	MOVEM.L	D1-D6/A5-A6,4096(A4)
	MOVEM.L	D1-D6/A5-A6,4128(A4)
	LEA	160(A3),A3
	LEA	64(A4),A4
	DBF	D7,TRANS

	MOVEQ	#1,D7
	LEA	DATA+8192,A4

	MOVEQ	#14,D6	
COPY1:	LEA	DATA,A3
	MOVEQ	#127,D5
COPY2:	MOVEQ	#6,D4
COPY3:	MOVE.W	(A3),D1
	SWAP	D1
	MOVE.W	8(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	2(A3),D1
	SWAP	D1
	MOVE.W	10(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	4(A3),D1
	SWAP	D1
	MOVE.W	12(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	6(A3),D1
	SWAP	D1
	MOVE.W	14(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	LEA	8(A3),A3
	DBF	D4,COPY3
	MOVE.W	56(A3),D1
	SWAP	D1
	MOVE.W	(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	58(A3),D1
	SWAP	D1
	MOVE.W	2(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	60(A3),D1
	SWAP	D1
	MOVE.W	4(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	MOVE.W	62(A3),D1
	SWAP	D1
	MOVE.W	6(A3),D1
	LSL.L	D7,D1
	SWAP	D1
	MOVE.W	D1,(A4)+
	LEA	8(A3),A3
	DBF	D5,COPY2
	ADDQ.L	#1,D7
	DBF	D6,COPY1

	LEA	PIC+32034-1280,A3
	LEA	$70000,A4
	LEA	$78000,A5
	MOVE.W	#319,D6
ROZDZ:	MOVE.L	(A3),(A4)+
	MOVE.L	(A3)+,(A5)+
	DBF	D6,ROZDZ

	MOVEM.W	HI_SCORES,D1-D5
	MOVEM.W	D1-D5,DGG1

	JSR	CONV
	MOVE.L	#VBL,$70.W
	BSET	#4,$FFFFFA09.W
	BSET	#4,$FFFFFA15.W
	BSR	NUMER1
	BSR	NUMER2
	BSR	NUMER3
	JSR	NUMER4
	BRA	SLALOM

POS_X:	DC.L	400-(160-16)
POS_Y:	DC.L	9900

text:	dc.b	"****************************************"
	dc.b	"*          BUDGIE UK PRESENTS:         *"
	dc.b	"*          -- ATARI SLALOM --          *"
	dc.b	"****************************************"
	dc.b	"* WRITTEN BY RALPH RUDZKI (IDEA,CODING,*"
	dc.b	"*      GRAPHICS,MUSIC COMPOSING).      *"
	dc.b	"****************************************",10,13
	dc.b	"USE JOYSTICK TO CONTROL YOUR MOUSE (?),",10,13
	dc.b	"(FIRE TO FREEZE FORWARD VELOCITY).",10,10,13
	dc.b	"USE THE FOLLOWING KEYS:",10,13
	dc.b	"* `F1` - `F5` TO CHOOSE A ROUTE,",10,13
	dc.b	"* `SPACE` TO FREEZE ACTION,",10,13
	dc.b	"* `H` TO SHOW/HIDE HIDDEN GAME,",10,13
	dc.b	"* `CTRL`, `ALT`, `-`, `ENTER` TO CONTROL"
	dc.b	"    HIDDEN GAME,",10,13
	dc.b	"* `P` TO RUN/PAUSE HIDDEN GAME,",10,13
	dc.b	"* CUROSOR KEYS TO MOVE HIDDEN GAME,",10,13
	dc.b	"* `ESC` TO EXIT THE GAME.",10,10,13
	dc.b	"@1993 BUDGIE UK LICENCEWARE.",10,10,10,13
	dc.b	"************ PRESS *** FIRE ************",0

ATH:	DC.W	0
ATV:	DC.W	0
PRINT:	lea	text,a2
prr:	moveq	#0,d1
	move.b	(a2)+,d1
	tst.b	d1
	beq	eot
	cmp.b	#10,d1
	beq	line
	cmp.b	#13,d1
	beq	enter
	sub.b	#32,d1
	tst.b	d1
	bmi	prr
	cmp.b	#80,d1
	bge	prr
	move.l	d1,d0
	divu	#40,d0
	move.w	d0,d2
	mulu	#1280,d0
	mulu	#40,d2
	sub.w	d2,d1
	move.w	d1,d2
	lsr.w	#1,d1
	lsl.w	#3,d1
	and.w	#1,d2	
	lea	PIC+32034-3*1280,a1
	adda.w	d0,a1
	adda.w	d1,a1
	adda.w	d2,a1
	lea	$70000,a3
	move.w	ATV,d0
	move.w	ATH,d1
	move.w	d1,d2
	mulu	#1280,d0
	lsr.w	#1,d1
	lsl.w	#3,d1
	and.w	#1,d2
	adda.w	d0,a3
	adda.w	d1,a3
	adda.w	d2,a3
	move.b	(a1),(a3)
	move.b	160(a1),160(a3)
	move.b	320(a1),320(a3)
	move.b	480(a1),480(a3)
	move.b	640(a1),640(a3)
	move.b	800(a1),800(a3)
	move.b	960(a1),960(a3)
	move.b	1120(a1),1120(a3)
	addq.w	#1,ATH
	cmp.w	#40,ATH
	bmi	prr
	clr.w	ATH
	addq.w	#1,ATV
	cmp.w	#25,ATV
	bmi	prr
eot:	rts
line:	addq.w	#1,ATV
	cmp.w	#25,ATV
	beq	eot
	bra	prr
enter:	clr.w	ATH
	bra	prr

FLASH:	CLR.W	$FFFF8242.W
	MOVEQ	#6,D7
AGA1:	BSR	ALF
	ADD.W	#$100,$FFFF8242.W
	DBF	D7,AGA1
	MOVEQ	#6,D7
AGA2:	BSR	ALF
	ADD.W	#$010,$FFFF8242.W
	DBF	D7,AGA2
	MOVEQ	#6,D7
AGA3:	BSR	ALF
	ADD.W	#$001,$FFFF8242.W
	DBF	D7,AGA3
	BSR	BLOAD
RED:	BTST	#7,JOY
	BEQ	RED
	MOVEQ	#6,D7
AGA4:	BSR	ALF
	SUB.W	#$100,$FFFF8242.W
	DBF	D7,AGA4
	MOVEQ	#6,D7
AGA5:	BSR	ALF
	SUB.W	#$010,$FFFF8242.W
	DBF	D7,AGA5
	MOVEQ	#6,D7
AGA6:	BSR	ALF
	SUB.W	#$001,$FFFF8242.W
	DBF	D7,AGA6
	RTS

ANDROMEDA:
	MOVEQ	#6,D7
AGA7:	BSR	ALF
	SUB.W	#$100,$FFFF8240.W
	DBF	D7,AGA7
	MOVEQ	#6,D7
AGA8:	BSR	ALF
	SUB.W	#$010,$FFFF8240.W
	DBF	D7,AGA8
	MOVEQ	#6,D7
AGA9:	BSR	ALF
	SUB.W	#$001,$FFFF8240.W
	DBF	D7,AGA9
	RTS

GANIMEDE:
	MOVEQ	#6,D7
AGA10:	BSR	ALF
	ADD.W	#$111,$FFFF8240.W
	DBF	D7,AGA10
	RTS

ALF:	MOVEQ	#3,D6
ALF0:	MOVE.L	$466.W,D5
ALF00:	CMP.L	$466.W,D5
	BEQ	ALF00
	DBF	D6,ALF0
	RTS

pnt:	dc.w	tex0-tex
pix:	dc.w	1

SCROLLINE:
	lea	tex,a2
	move.w	pnt,d0
	moveq	#0,d1
	move.b	0(a2,d0.w),d1
	sub.b	#32,d1
	move.l	d1,d0
	divu	#40,d0
	move.w	d0,d2
	mulu	#1280,d0
	mulu	#40,d2
	sub.w	d2,d1
	move.w	d1,d2
	lsr.w	#1,d1
	mulu	#8,d1
	and.w	#1,d2	
	lea	PIC+32034-3*1280,a1
	adda.w	d0,a1
	adda.w	d1,a1
	adda.w	d2,a1
	move.w	pix,d1

	addq.w	#1,pix
	cmp.w	#9,pix
	bne	same
	move.w	#1,pix
	addq.w	#1,pnt
	lea	tex,a2
	move.w	pnt,d0
	adda.w	d0,a2
	tst.b	(a2)
	bne	same
	clr.w	pnt
same:	
	LEA	$70006,A5
	LEA	$78006,A6
		MOVE.B	(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*0+104(A5)
	ROXL.W	160*0+096(A5)
	ROXL.W	160*0+088(A5)
	ROXL.W	160*0+080(A5)
		MOVE.B	160(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*1+104(A5)
	ROXL.W	160*1+096(A5)
	ROXL.W	160*1+088(A5)
	ROXL.W	160*1+080(A5)
		MOVE.B	160*2(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*2+104(A5)
	ROXL.W	160*2+096(A5)
	ROXL.W	160*2+088(A5)
	ROXL.W	160*2+080(A5)
		MOVE.B	160*3(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*3+104(A5)
	ROXL.W	160*3+096(A5)
	ROXL.W	160*3+088(A5)
	ROXL.W	160*3+080(A5)
		MOVE.B	160*4(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*4+104(A5)
	ROXL.W	160*4+096(A5)
	ROXL.W	160*4+088(A5)
	ROXL.W	160*4+080(A5)
		MOVE.B	160*5(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*5+104(A5)
	ROXL.W	160*5+096(A5)
	ROXL.W	160*5+088(A5)
	ROXL.W	160*5+080(A5)
		MOVE.B	160*6(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*6+104(A5)
	ROXL.W	160*6+096(A5)
	ROXL.W	160*6+088(A5)
	ROXL.W	160*6+080(A5)
		MOVE.B	(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*0+104(A6)
	ROXL.W	160*0+096(A6)
	ROXL.W	160*0+088(A6)
	ROXL.W	160*0+080(A6)
		MOVE.B	160(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*1+104(A6)
	ROXL.W	160*1+096(A6)
	ROXL.W	160*1+088(A6)
	ROXL.W	160*1+080(A6)
		MOVE.B	160*2(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*2+104(A6)
	ROXL.W	160*2+096(A6)
	ROXL.W	160*2+088(A6)
	ROXL.W	160*2+080(A6)
		MOVE.B	160*3(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*3+104(A6)
	ROXL.W	160*3+096(A6)
	ROXL.W	160*3+088(A6)
	ROXL.W	160*3+080(A6)
		MOVE.B	160*4(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*4+104(A6)
	ROXL.W	160*4+096(A6)
	ROXL.W	160*4+088(A6)
	ROXL.W	160*4+080(A6)
		MOVE.B	160*5(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*5+104(A6)
	ROXL.W	160*5+096(A6)
	ROXL.W	160*5+088(A6)
	ROXL.W	160*5+080(A6)
		MOVE.B	160*6(A1),D0
		LSL.B	D1,D0
	ROXL.W	160*6+104(A6)
	ROXL.W	160*6+096(A6)
	ROXL.W	160*6+088(A6)
	ROXL.W	160*6+080(A6)
	RTS

tex:	dc.b	"                                                                "
tex0:	dc.b	"BUDGIE UK PROUDLY PRESENTS:   'ATARI SLALOM', THE DISKFILLER WHICH CAN BE TREATED AS A GAME IF YOU WANT IT VERY MUCH (THIS IS WHAT I CALL CODING FOR CODING). MY NAME IS RALPH RUDZKI AND I AM THE AUTHOR OF THIS STUPID PRODUCTION. "
	dc.b	"I'VE JUST FINISHED MY FIRST YEAR ON THE UNIVERSITY AND I FEEL REALLY EXHAUSTED. FIRST OF ALL SOME EXAMS WERE PRETTY HARD (PARTICULARLY ECONOMICAL HISTORY, LUCKILY FOR THE LAST TIME IN MY LIFE). BESIDES, I HAVEN'T BEEN USING MY "
	dc.b	"COMPUTER ALMOST FOR A YEAR (IT NEVER HAPPEND EARLIER). THUS, I HAD TO REMIND MYSELF HOW TO SWITCH ON/OFF MY ST. AND AFTER I HAD DONE IT I WROTE THIS HOPELESS PROGRAM (NO MATTER IT FEATURES ONE-VBL, BIDIRECTIONAL, FLEXIBLE SCROLLING, " 
	dc.b	"MORE THAN 32 COLOURS ON SCREEN AT THE SAME TIME, DIGIDRUMS SOUNDTRACK AND AN ADDITIONAL MINI-GAME). ANYWAY, ALTHOUGH IT HAS NO SENSE AT ALL, IT GIVES YOU A GREAT FEELING OF MOVEMENT. AS FAR AS I AM CONCERNED THIS AND ONLY THIS ALLOWS "
	dc.b	"TO TREAT THIS PROGRAM AS A GAME AND THEREFORE IT WAS PUBLISHED.                     IT IS WHAT HAPPENS WITH THE CODER AFTER A ONE YEAR BREAK. ANYWAY, I GUESS I'LL MAKE SOMETHING ORIGINAL & USEFUL IN NEAR FUTURE AND I HOPE YOU WILL "
	dc.b	"LIKE IT. BUT FOR THE TIME BEING LET'S SAY 'BYE-BYE' TO EACH OTHER. AND BEFORE THIS TEXT WILL WRAP I WOULD LIKE TO TELL YOU THAT AT THE MOMENT IT IS 18:32.07, FRIDAY 18-06-1993 AND I AM WRITING THESE WORDS AT MY HOME IN WARSAW (POLAND). "
	dc.b	"IF YOU HAVE SOME TROUBLES WITH THIS PROGRAM READ THE INTRO PAGE ONCE MORE. NO GREETINGS THIS TIME...                                         SEE YOU SOON !!!                                                  ",0
tex1:	dc.b	"        UNFORTUNATELY YOU'VE MADE A MISTAKE. TRY AGAIN !  ",0
tex2:	dc.b	"        WELL DONE !  YOU'VE JUST FINISHED THE ROUTE. TRY THIS ONE AGAIN, OR CHOOSE ANOTHER ONE.  ",0
tex3:	dc.b	"        CONGRATULATIONS! BRAVO! YOU'VE JUST MADE A NEW RECORD !!!      ANYWAY, TRY AGAIN !  ",0
SLALOM:	LEA	DATA,A3
	MOVE.L	TWO2,A4

	MOVE.L	POS_X,D1
	MOVE.L	D1,D2
	AND.L	#15,D1
	MULU	#8192,D1
	ADD.L	D1,A3
	LSR.L	#4,D2
	AND.L	#3,D2
	LSL.L	#3,D2
	ADD.L	D2,A3

	MOVE.L	POS_Y,D1
	AND.L	#63,D1
	LSL.L	#6,D1
	ADD.L	D1,A3

	MOVEQ	#63,D7
SCROLL:	MOVEM.L	(A3),D1-D6/A5-A6
	MOVEM.L	D1-D6/A5-A6,(A4)
	MOVEM.L	D1-D6/A5-A6,32(A4)
	MOVEM.L	D1-D6/A5-A6,64(A4)
	MOVEM.L	D1-D6/A5-A6,96(A4)
	MOVEM.L	D1-D6/A5-A6,128(A4)
	MOVEM.L	D1-D6/A5-A6,64*160(A4)
	MOVEM.L	D1-D6/A5-A6,64*160+32(A4)
	MOVEM.L	D1-D6/A5-A6,64*160+64(A4)
	MOVEM.L	D1-D6/A5-A6,64*160+96(A4)
	MOVEM.L	D1-D6/A5-A6,64*160+128(A4)
	MOVEM.L	D1-D6/A5-A6,128*160(A4)
	MOVEM.L	D1-D6/A5-A6,128*160+32(A4)
	MOVEM.L	D1-D6/A5-A6,128*160+64(A4)
	MOVEM.L	D1-D6/A5-A6,128*160+96(A4)
	MOVEM.L	D1-D6/A5-A6,128*160+128(A4)
	LEA	64(A3),A3
	LEA	160(A4),A4
	DBF	D7,SCROLL

RACE:	LEA	RACE0,A2
	MOVE.L	POS_Y,D2
	TST.L	D2
	BMI	MM
	DIVU	#200,D2
	MULU	#12*4,D2
	ADD.L	D2,A2
MM:	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB
	MOVEM.L	(A2)+,D0/D6/D7
	BSR	MOB

KADR:	LEA	PIC+34+64*160,A3
	MOVE.L	TWO2,A4
	ADD.L	#72+128*160,A4
	MOVEQ	#31,D6
HERO:	MOVE.L	(A3)+,D2
	MOVE.L	(A3)+,D3
	MOVE.L	(A3)+,D4
	MOVE.L	(A3)+,D5
	MOVE.L	(A3),D0
	MOVE.L	8(A3),D1
	AND.L	D0,(A4)
	OR.L	D2,(A4)+
	AND.L	D0,(A4)
	OR.L	D3,(A4)+
	AND.L	D1,(A4)
	OR.L	D4,(A4)+
	AND.L	D1,(A4)
	OR.L	D5,(A4)+
	LEA	160-16(A3),A3
	LEA	160-16(A4),A4
	DBF	D6,HERO

	MOVEQ	#0,D7
	SUB.L	POS_X,D7
	TST.L	D7
	BMI	NLEFT
	CMP.L	#320,D7
	BGE	NLEFT
	BRA	ROPE
NLEFT:	MOVE.L	#800,D7
	SUB.L	POS_X,D7
	TST.L	D7
	BMI	NRIGHT
	CMP.L	#320,D7
	BGE	NRIGHT
ROPE:	MOVE.L	TWO2,A3
	MOVE.L	#$80008000,D3
	MOVE.L	D7,D6
	LSR.L	#4,D6
	LSL.L	#3,D6
	ADD.L	D6,A3
	MOVE.L	POS_Y,D6
	NOT.L	D6
	AND.L	#$3,D6
	MULU	#160,D6
	ADD.L	D6,A3
	AND.W	#$F,D7
	LSR.L	D7,D3
	NOT.L	D3

	AND.L	D3,160*4*00+0(A3)
	AND.L	D3,160*4*00+4(A3)
	AND.L	D3,160*4*01+0(A3)
	AND.L	D3,160*4*01+4(A3)
	AND.L	D3,160*4*02+0(A3)
	AND.L	D3,160*4*02+4(A3)
	AND.L	D3,160*4*03+0(A3)
	AND.L	D3,160*4*03+4(A3)
	AND.L	D3,160*4*04+0(A3)
	AND.L	D3,160*4*04+4(A3)
	AND.L	D3,160*4*05+0(A3)
	AND.L	D3,160*4*05+4(A3)
	AND.L	D3,160*4*06+0(A3)
	AND.L	D3,160*4*06+4(A3)
	AND.L	D3,160*4*07+0(A3)
	AND.L	D3,160*4*07+4(A3)
	AND.L	D3,160*4*08+0(A3)
	AND.L	D3,160*4*08+4(A3)
	AND.L	D3,160*4*09+0(A3)
	AND.L	D3,160*4*09+4(A3)
	AND.L	D3,160*4*10+0(A3)
	AND.L	D3,160*4*10+4(A3)
	AND.L	D3,160*4*11+0(A3)
	AND.L	D3,160*4*11+4(A3)
	AND.L	D3,160*4*12+0(A3)
	AND.L	D3,160*4*12+4(A3)
	AND.L	D3,160*4*13+0(A3)
	AND.L	D3,160*4*13+4(A3)
	AND.L	D3,160*4*14+0(A3)
	AND.L	D3,160*4*14+4(A3)
	AND.L	D3,160*4*15+0(A3)
	AND.L	D3,160*4*15+4(A3)
	AND.L	D3,160*4*16+0(A3)
	AND.L	D3,160*4*16+4(A3)
	AND.L	D3,160*4*17+0(A3)
	AND.L	D3,160*4*17+4(A3)
	AND.L	D3,160*4*18+0(A3)
	AND.L	D3,160*4*18+4(A3)
	AND.L	D3,160*4*19+0(A3)
	AND.L	D3,160*4*19+4(A3)
	AND.L	D3,160*4*20+0(A3)
	AND.L	D3,160*4*20+4(A3)
	AND.L	D3,160*4*21+0(A3)
	AND.L	D3,160*4*21+4(A3)
	AND.L	D3,160*4*22+0(A3)
	AND.L	D3,160*4*22+4(A3)
	AND.L	D3,160*4*23+0(A3)
	AND.L	D3,160*4*23+4(A3)
	AND.L	D3,160*4*24+0(A3)
	AND.L	D3,160*4*24+4(A3)
	AND.L	D3,160*4*25+0(A3)
	AND.L	D3,160*4*25+4(A3)
	AND.L	D3,160*4*26+0(A3)
	AND.L	D3,160*4*26+4(A3)
	AND.L	D3,160*4*27+0(A3)
	AND.L	D3,160*4*27+4(A3)
	AND.L	D3,160*4*28+0(A3)
	AND.L	D3,160*4*28+4(A3)
	AND.L	D3,160*4*29+0(A3)
	AND.L	D3,160*4*29+4(A3)
	AND.L	D3,160*4*30+0(A3)
	AND.L	D3,160*4*30+4(A3)
	AND.L	D3,160*4*31+0(A3)
	AND.L	D3,160*4*31+4(A3)
	AND.L	D3,160*4*32+0(A3)
	AND.L	D3,160*4*32+4(A3)
	AND.L	D3,160*4*33+0(A3)
	AND.L	D3,160*4*33+4(A3)
	AND.L	D3,160*4*34+0(A3)
	AND.L	D3,160*4*34+4(A3)
	AND.L	D3,160*4*35+0(A3)
	AND.L	D3,160*4*35+4(A3)
	AND.L	D3,160*4*36+0(A3)
	AND.L	D3,160*4*36+4(A3)
	AND.L	D3,160*4*37+0(A3)
	AND.L	D3,160*4*37+4(A3)
	AND.L	D3,160*4*38+0(A3)
	AND.L	D3,160*4*38+4(A3)
	AND.L	D3,160*4*39+0(A3)
	AND.L	D3,160*4*39+4(A3)
	AND.L	D3,160*4*40+0(A3)
	AND.L	D3,160*4*40+4(A3)
	AND.L	D3,160*4*41+0(A3)
	AND.L	D3,160*4*41+4(A3)
	AND.L	D3,160*4*42+0(A3)
	AND.L	D3,160*4*42+4(A3)
	AND.L	D3,160*4*43+0(A3)
	AND.L	D3,160*4*43+4(A3)
	AND.L	D3,160*4*44+0(A3)
	AND.L	D3,160*4*44+4(A3)
	AND.L	D3,160*4*45+0(A3)
	AND.L	D3,160*4*45+4(A3)
	AND.L	D3,160*4*46+0(A3)
	AND.L	D3,160*4*46+4(A3)
	AND.L	D3,160*4*47+0(A3)
	AND.L	D3,160*4*47+4(A3)
	LEA	160(A3),A3
	AND.L	D3,160*4*00+0(A3)
	AND.L	D3,160*4*00+4(A3)
	AND.L	D3,160*4*01+0(A3)
	AND.L	D3,160*4*01+4(A3)
	AND.L	D3,160*4*02+0(A3)
	AND.L	D3,160*4*02+4(A3)
	AND.L	D3,160*4*03+0(A3)
	AND.L	D3,160*4*03+4(A3)
	AND.L	D3,160*4*04+0(A3)
	AND.L	D3,160*4*04+4(A3)
	AND.L	D3,160*4*05+0(A3)
	AND.L	D3,160*4*05+4(A3)
	AND.L	D3,160*4*06+0(A3)
	AND.L	D3,160*4*06+4(A3)
	AND.L	D3,160*4*07+0(A3)
	AND.L	D3,160*4*07+4(A3)
	AND.L	D3,160*4*08+0(A3)
	AND.L	D3,160*4*08+4(A3)
	AND.L	D3,160*4*09+0(A3)
	AND.L	D3,160*4*09+4(A3)
	AND.L	D3,160*4*10+0(A3)
	AND.L	D3,160*4*10+4(A3)
	AND.L	D3,160*4*11+0(A3)
	AND.L	D3,160*4*11+4(A3)
	AND.L	D3,160*4*12+0(A3)
	AND.L	D3,160*4*12+4(A3)
	AND.L	D3,160*4*13+0(A3)
	AND.L	D3,160*4*13+4(A3)
	AND.L	D3,160*4*14+0(A3)
	AND.L	D3,160*4*14+4(A3)
	AND.L	D3,160*4*15+0(A3)
	AND.L	D3,160*4*15+4(A3)
	AND.L	D3,160*4*16+0(A3)
	AND.L	D3,160*4*16+4(A3)
	AND.L	D3,160*4*17+0(A3)
	AND.L	D3,160*4*17+4(A3)
	AND.L	D3,160*4*18+0(A3)
	AND.L	D3,160*4*18+4(A3)
	AND.L	D3,160*4*19+0(A3)
	AND.L	D3,160*4*19+4(A3)
	AND.L	D3,160*4*20+0(A3)
	AND.L	D3,160*4*20+4(A3)
	AND.L	D3,160*4*21+0(A3)
	AND.L	D3,160*4*21+4(A3)
	AND.L	D3,160*4*22+0(A3)
	AND.L	D3,160*4*22+4(A3)
	AND.L	D3,160*4*23+0(A3)
	AND.L	D3,160*4*23+4(A3)
	AND.L	D3,160*4*24+0(A3)
	AND.L	D3,160*4*24+4(A3)
	AND.L	D3,160*4*25+0(A3)
	AND.L	D3,160*4*25+4(A3)
	AND.L	D3,160*4*26+0(A3)
	AND.L	D3,160*4*26+4(A3)
	AND.L	D3,160*4*27+0(A3)
	AND.L	D3,160*4*27+4(A3)
	AND.L	D3,160*4*28+0(A3)
	AND.L	D3,160*4*28+4(A3)
	AND.L	D3,160*4*29+0(A3)
	AND.L	D3,160*4*29+4(A3)
	AND.L	D3,160*4*30+0(A3)
	AND.L	D3,160*4*30+4(A3)
	AND.L	D3,160*4*31+0(A3)
	AND.L	D3,160*4*31+4(A3)
	AND.L	D3,160*4*32+0(A3)
	AND.L	D3,160*4*32+4(A3)
	AND.L	D3,160*4*33+0(A3)
	AND.L	D3,160*4*33+4(A3)
	AND.L	D3,160*4*34+0(A3)
	AND.L	D3,160*4*34+4(A3)
	AND.L	D3,160*4*35+0(A3)
	AND.L	D3,160*4*35+4(A3)
	AND.L	D3,160*4*36+0(A3)
	AND.L	D3,160*4*36+4(A3)
	AND.L	D3,160*4*37+0(A3)
	AND.L	D3,160*4*37+4(A3)
	AND.L	D3,160*4*38+0(A3)
	AND.L	D3,160*4*38+4(A3)
	AND.L	D3,160*4*39+0(A3)
	AND.L	D3,160*4*39+4(A3)
	AND.L	D3,160*4*40+0(A3)
	AND.L	D3,160*4*40+4(A3)
	AND.L	D3,160*4*41+0(A3)
	AND.L	D3,160*4*41+4(A3)
	AND.L	D3,160*4*42+0(A3)
	AND.L	D3,160*4*42+4(A3)
	AND.L	D3,160*4*43+0(A3)
	AND.L	D3,160*4*43+4(A3)
	AND.L	D3,160*4*44+0(A3)
	AND.L	D3,160*4*44+4(A3)
	AND.L	D3,160*4*45+0(A3)
	AND.L	D3,160*4*45+4(A3)
	AND.L	D3,160*4*46+0(A3)
	AND.L	D3,160*4*46+4(A3)
	AND.L	D3,160*4*47+0(A3)
	AND.L	D3,160*4*47+4(A3)
NRIGHT:

	MOVE.L	#-100,D7
	SUB.L	POS_Y,D7
	TST.L	D7
	BMI	NFAR
	CMP.L	#192,D7
	BGE	NFAR
	CMP.L	#128,D7
	BLT	NRAF
	TST.W	NEW+2
	BNE	NRAF
	CLR.W	TIME+2
	CLR.B	CON+3
	MOVE.W	#-1,NEW+2
	BSR	NEW_RECORD
NRAF:
	BRA	LINE
NFAR:	MOVE.L	#10000,D7
	SUB.L	POS_Y,D7
	TST.L	D7
	BMI	NCLOSE
	CMP.L	#192,D7
	BGE	NCLOSE
	CMP.L	#128,D7
	BLT	LINE
	MOVE.W	#1,TIME+2
LINE:	MOVE.L	TWO2,A3
	MULU	#160,D7
	ADD.L	D7,A3
	MOVEQ	#0,D3

	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
	MOVE.L	D3,(A3)+
NCLOSE:

NEW:	MOVE.W	#1,D0
	BEQ	NEW_GAME
	cmp.w	#1,d0
	bne	again
	MOVE.L	ONE1,A1
	MOVE.L	TWO2,A2
	LEA	12*1280(A1),A1
	LEA	12*1280(A2),A2
	MOVE.L	A1,A3
	MOVE.L	A2,A4
	MOVE.W	#95,D0
GAS_P:	MOVE.L	$466.W,D1
BLK_P:	CMP.L	$466.W,D1
	BEQ	BLK_P
	MOVEQ	#39,D1
JED_P:	MOVE.L	(A2)+,(A1)+
	MOVE.L	-(A4),-(A3)
	DBF	D1,JED_P
	JSR	HIDDEN_GAME
	DBF	D0,GAS_P
	CLR.L	DG1
	CLR.L	DG3
	CLR.W	DG5
	CLR.W	TIME+2
	MOVE.W	#5,TIMER
	CLR.W	NEW+2
	MOVE.B	#$8F,CON+3
	BRA	NEW_GAME

again:	TST.L	ADX+2
	BNE	NEW_GAME
	TST.L	ADY+2
	BNE	NEW_GAME

	MOVE.L	ONE1,A1
	LEA	1280*24(A1),A2
	MOVE.W	#95,D0
GAS:	MOVE.L	$466.W,D1
BLK:	CMP.L	$466.W,D1
	BEQ	BLK
	MOVEQ	#39,D1
JED:	CLR.L	(A1)+
	CLR.L	-(A2)
	DBF	D1,JED
	JSR	HIDDEN_GAME
	DBF	D0,GAS

	MOVE.L	#400-(160-16),POS_X
	MOVE.L	#9900,POS_Y
	MOVE.W	#1,NEW+2
	BRA	SLALOM
NEW_GAME:
	BSR	CHANGE
	JSR	HIDDEN_GAME
	CMP.B	#$39,KEY
	BNE	NOPA
	CLR.B	KEY
	NOT.B	NOPA+3
NOPA:	MOVE.B	#0,D0
	BNE	PAUSE
	BSR	TIME
	BSR	NUMER2
	BSR	CONTROL
PAUSE:	BRA	SLALOM

CONTROL:
	MOVE.B	JOY,D7
CON:	AND.B	#$8F,D7

	MOVE.L	#PIC+34+64*160,KADR+2	

	BTST	#0,D7
	BEQ	NO_U
	SUBQ.L	#1,ADY+2
	BRA	YES_U
NO_U:	BTST	#7,D7
	BNE	YES_U
	TST.L	ADY+2
	BGE	YES_U
	ADDQ.L	#1,ADY+2
YES_U:	
	BTST	#1,D7
	BEQ	NO_D
	ADDQ.L	#1,ADY+2
	BRA	YES_D
NO_D:	TST.L	ADY+2
	BLE	YES_D
	SUBQ.L	#1,ADY+2
YES_D:	
	BTST	#2,D7
	BEQ	NO_L
	MOVE.L	#PIC+34+96*160,KADR+2	
	SUBQ.L	#1,ADX+2
	BRA	YES_L
NO_L:	TST.L	ADX+2
	BGE	YES_L
	ADDQ.L	#1,ADX+2
YES_L:
	BTST	#3,D7
	BEQ	NO_R
	MOVE.L	#PIC+34+128*160,KADR+2	
	ADDQ.L	#1,ADX+2
	BRA	YES_R
NO_R:	TST.L	ADX+2
	BLE	YES_R
	SUBQ.L	#1,ADX+2
YES_R:	

	CMP.L	#-(160-16),POS_X
	BGE	LOD
	TST.L	ADX+2
	BGE	LOD
	MOVE.L	ADX+2,D7
	NOT.L	D7
	ADDQ.L	#1,D7
	LSR.L	#1,D7
	MOVE.L	D7,ADX+2
LOD:	
	CMP.L	#800-(160+16),POS_X
	BLE	ROD
	TST.L	ADX+2
	BLE	ROD
	MOVE.L	ADX+2,D7
	LSR.L	#1,D7
	NOT.L	D7
	ADDQ.L	#1,D7
	MOVE.L	D7,ADX+2
ROD:

ADX:	MOVE.L	#0,D1
ADY:	MOVE.L	#0,D2
	LSR.L	#2,D1
	LSR.L	#4,D2
	EXT.L	D1
	EXT.L	D2
	ADD.L	D1,POS_X
	ADD.L	D2,POS_Y

	TST.W	NEW+2
	BNE	NZDU
	CMP.L	#9900,POS_Y
	BMI	ZDU
	BCLR	#1,CON+3
	TST.W	TIME+2
	BNE	NZDU
	BSR	NEW_ROUTE
	BRA	NZDU
ZDU:	BSET	#1,CON+3
NZDU:
	RTS

MOB:	SUB.L	POS_X,D6
	SUB.L	POS_Y,D7

	CMP.L	#120,D7
	BLE	SRODEK
	CMP.L	#144,D7
	BGE	SRODEK
	TST.W	D0
	BNE	LEWO
	CMP.L	#136,D6
	BLE	PRAWO
	CLR.B	CON+3
	MOVE.W	#-1,NEW+2
	move.w	#tex1-tex,pnt
	BRA	PRAWO
LEWO:	CMP.L	#168,D6
	BGE	SRODEK
	CLR.B	CON+3
	MOVE.W	#-1,NEW+2
	move.w	#tex1-tex,pnt
PRAWO:
SRODEK:
	CMP.L	#-16,D6
	BLE	NO_MOB
	CMP.L	#320,D6
	BGE	NO_MOB
	CMP.L	#-16,D7
	BLE	NO_MOB
	CMP.L	#192,D7
	BGE	NO_MOB

	LEA	PIC+34+32,A3
	LSL.L	#6,D0
	ADD.L	D0,A3
	MOVE.L	TWO2,A4
	MOVEQ	#15,D5

	TST.L	D7
	BGE	TOP
	NOT.L	D7
	ADDQ.L	#1,D7
	SUB.L	D7,D5
	MULU	#160,D7
	ADD.L	D7,A3
	MOVEQ	#0,D7
TOP:
	CMP.L	#176,D7
	BLE	BOTTOM
	MOVE.L	#191,D5
	SUB.L	D7,D5
BOTTOM:
	MULU	#160,D7
	ADD.L	D7,A4
	MOVE.L	D6,D7
	BTST	#15,D7
	BEQ	LTZ
	SUBI.L	#16,D7
LTZ:	
	DIVS	#16,D7
	MULS	#8,D7
	ADD.L	D7,A4
	MOVE.L	D6,D7
	LSR.L	#1,D7
	AND.W	#7,D7
	MULU	#2560,D7
	ADD.L	D7,A3
	BTST	#0,D6
	BEQ	NOONE
	LEA	16(A3),A3
NOONE:
	MOVE.L	D5,D7
	LEA	8(A3),A5
	LEA	8(A4),A6

	TST.L	D6
	BMI	LOOP2
LOOP1:	MOVE.L	(A3)+,D1
	MOVE.L	(A3)+,D2
	MOVE.L	24(A3),D0
	AND.L	D0,(A4)
	OR.L	D1,(A4)+
	AND.L	D0,(A4)
	OR.L	D2,(A4)+
	LEA	160-8(A3),A3
	LEA	160-8(A4),A4
	DBF	D5,LOOP1
	CMP.L	#304,D6
	BGE	LOOP3
LOOP2:	MOVE.L	(A5)+,D1
	MOVE.L	(A5)+,D2
	MOVE.L	24(A5),D0
	AND.L	D0,(A6)
	OR.L	D1,(A6)+
	AND.L	D0,(A6)
	OR.L	D2,(A6)+
	LEA	160-8(A5),A5
	LEA	160-8(A6),A6
	DBF	D7,LOOP2
LOOP3:
NO_MOB:	RTS

D11:	DC.W	0
D22:	DC.W	1
NUMER1:	LEA	$70006+8,A1
	LEA	$78006+8,A2
	LEA	CYFRY,A3

	MOVE.W	D11,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+01(A1)
	MOVE.B	1(A3,D2.W),160*1+01(A1)
	MOVE.B	2(A3,D2.W),160*2+01(A1)
	MOVE.B	3(A3,D2.W),160*3+01(A1)
	MOVE.B	4(A3,D2.W),160*4+01(A1)
	MOVE.B	5(A3,D2.W),160*5+01(A1)
	MOVE.B	6(A3,D2.W),160*6+01(A1)
	MOVE.B	0(A3,D2.W),160*0+01(A2)
	MOVE.B	1(A3,D2.W),160*1+01(A2)
	MOVE.B	2(A3,D2.W),160*2+01(A2)
	MOVE.B	3(A3,D2.W),160*3+01(A2)
	MOVE.B	4(A3,D2.W),160*4+01(A2)
	MOVE.B	5(A3,D2.W),160*5+01(A2)
	MOVE.B	6(A3,D2.W),160*6+01(A2)
	MOVE.W	D22,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+08(A1)
	MOVE.B	1(A3,D2.W),160*1+08(A1)
	MOVE.B	2(A3,D2.W),160*2+08(A1)
	MOVE.B	3(A3,D2.W),160*3+08(A1)
	MOVE.B	4(A3,D2.W),160*4+08(A1)
	MOVE.B	5(A3,D2.W),160*5+08(A1)
	MOVE.B	6(A3,D2.W),160*6+08(A1)
	MOVE.B	0(A3,D2.W),160*0+08(A2)
	MOVE.B	1(A3,D2.W),160*1+08(A2)
	MOVE.B	2(A3,D2.W),160*2+08(A2)
	MOVE.B	3(A3,D2.W),160*3+08(A2)
	MOVE.B	4(A3,D2.W),160*4+08(A2)
	MOVE.B	5(A3,D2.W),160*5+08(A2)
	MOVE.B	6(A3,D2.W),160*6+08(A2)
	RTS

DG1:	DC.W	0
DG2:	DC.W	0

DG3:	DC.W	0
DG4:	DC.W	0

DG5:	DC.W	0
NUMER2:	LEA	$70006+32,A1
	LEA	$78006+32,A2
	LEA	CYFRY,A3

	MOVE.W	DG1,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+00(A1)
	MOVE.B	1(A3,D2.W),160*1+00(A1)
	MOVE.B	2(A3,D2.W),160*2+00(A1)
	MOVE.B	3(A3,D2.W),160*3+00(A1)
	MOVE.B	4(A3,D2.W),160*4+00(A1)
	MOVE.B	5(A3,D2.W),160*5+00(A1)
	MOVE.B	6(A3,D2.W),160*6+00(A1)
	MOVE.B	0(A3,D2.W),160*0+00(A2)
	MOVE.B	1(A3,D2.W),160*1+00(A2)
	MOVE.B	2(A3,D2.W),160*2+00(A2)
	MOVE.B	3(A3,D2.W),160*3+00(A2)
	MOVE.B	4(A3,D2.W),160*4+00(A2)
	MOVE.B	5(A3,D2.W),160*5+00(A2)
	MOVE.B	6(A3,D2.W),160*6+00(A2)
	MOVE.W	DG2,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+01(A1)
	MOVE.B	1(A3,D2.W),160*1+01(A1)
	MOVE.B	2(A3,D2.W),160*2+01(A1)
	MOVE.B	3(A3,D2.W),160*3+01(A1)
	MOVE.B	4(A3,D2.W),160*4+01(A1)
	MOVE.B	5(A3,D2.W),160*5+01(A1)
	MOVE.B	6(A3,D2.W),160*6+01(A1)
	MOVE.B	0(A3,D2.W),160*0+01(A2)
	MOVE.B	1(A3,D2.W),160*1+01(A2)
	MOVE.B	2(A3,D2.W),160*2+01(A2)
	MOVE.B	3(A3,D2.W),160*3+01(A2)
	MOVE.B	4(A3,D2.W),160*4+01(A2)
	MOVE.B	5(A3,D2.W),160*5+01(A2)
	MOVE.B	6(A3,D2.W),160*6+01(A2)

	MOVE.W	DG3,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+09(A1)
	MOVE.B	1(A3,D2.W),160*1+09(A1)
	MOVE.B	2(A3,D2.W),160*2+09(A1)
	MOVE.B	3(A3,D2.W),160*3+09(A1)
	MOVE.B	4(A3,D2.W),160*4+09(A1)
	MOVE.B	5(A3,D2.W),160*5+09(A1)
	MOVE.B	6(A3,D2.W),160*6+09(A1)
	MOVE.B	0(A3,D2.W),160*0+09(A2)
	MOVE.B	1(A3,D2.W),160*1+09(A2)
	MOVE.B	2(A3,D2.W),160*2+09(A2)
	MOVE.B	3(A3,D2.W),160*3+09(A2)
	MOVE.B	4(A3,D2.W),160*4+09(A2)
	MOVE.B	5(A3,D2.W),160*5+09(A2)
	MOVE.B	6(A3,D2.W),160*6+09(A2)
	MOVE.W	DG4,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+16(A1)
	MOVE.B	1(A3,D2.W),160*1+16(A1)
	MOVE.B	2(A3,D2.W),160*2+16(A1)
	MOVE.B	3(A3,D2.W),160*3+16(A1)
	MOVE.B	4(A3,D2.W),160*4+16(A1)
	MOVE.B	5(A3,D2.W),160*5+16(A1)
	MOVE.B	6(A3,D2.W),160*6+16(A1)
	MOVE.B	0(A3,D2.W),160*0+16(A2)
	MOVE.B	1(A3,D2.W),160*1+16(A2)
	MOVE.B	2(A3,D2.W),160*2+16(A2)
	MOVE.B	3(A3,D2.W),160*3+16(A2)
	MOVE.B	4(A3,D2.W),160*4+16(A2)
	MOVE.B	5(A3,D2.W),160*5+16(A2)
	MOVE.B	6(A3,D2.W),160*6+16(A2)

	MOVE.W	DG5,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+24(A1)
	MOVE.B	1(A3,D2.W),160*1+24(A1)
	MOVE.B	2(A3,D2.W),160*2+24(A1)
	MOVE.B	3(A3,D2.W),160*3+24(A1)
	MOVE.B	4(A3,D2.W),160*4+24(A1)
	MOVE.B	5(A3,D2.W),160*5+24(A1)
	MOVE.B	6(A3,D2.W),160*6+24(A1)
	MOVE.B	0(A3,D2.W),160*0+24(A2)
	MOVE.B	1(A3,D2.W),160*1+24(A2)
	MOVE.B	2(A3,D2.W),160*2+24(A2)
	MOVE.B	3(A3,D2.W),160*3+24(A2)
	MOVE.B	4(A3,D2.W),160*4+24(A2)
	MOVE.B	5(A3,D2.W),160*5+24(A2)
	MOVE.B	6(A3,D2.W),160*6+24(A2)
	RTS

DGG1:	DC.W	0
DGG2:	DC.W	0

DGG3:	DC.W	0
DGG4:	DC.W	0

DGG5:	DC.W	0
NUMER3:	LEA	$70006+128,A1
	LEA	$78006+128,A2
	LEA	CYFRY,A3

	MOVE.W	DGG1,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+01(A1)
	MOVE.B	1(A3,D2.W),160*1+01(A1)
	MOVE.B	2(A3,D2.W),160*2+01(A1)
	MOVE.B	3(A3,D2.W),160*3+01(A1)
	MOVE.B	4(A3,D2.W),160*4+01(A1)
	MOVE.B	5(A3,D2.W),160*5+01(A1)
	MOVE.B	6(A3,D2.W),160*6+01(A1)
	MOVE.B	0(A3,D2.W),160*0+01(A2)
	MOVE.B	1(A3,D2.W),160*1+01(A2)
	MOVE.B	2(A3,D2.W),160*2+01(A2)
	MOVE.B	3(A3,D2.W),160*3+01(A2)
	MOVE.B	4(A3,D2.W),160*4+01(A2)
	MOVE.B	5(A3,D2.W),160*5+01(A2)
	MOVE.B	6(A3,D2.W),160*6+01(A2)
	MOVE.W	DGG2,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+08(A1)
	MOVE.B	1(A3,D2.W),160*1+08(A1)
	MOVE.B	2(A3,D2.W),160*2+08(A1)
	MOVE.B	3(A3,D2.W),160*3+08(A1)
	MOVE.B	4(A3,D2.W),160*4+08(A1)
	MOVE.B	5(A3,D2.W),160*5+08(A1)
	MOVE.B	6(A3,D2.W),160*6+08(A1)
	MOVE.B	0(A3,D2.W),160*0+08(A2)
	MOVE.B	1(A3,D2.W),160*1+08(A2)
	MOVE.B	2(A3,D2.W),160*2+08(A2)
	MOVE.B	3(A3,D2.W),160*3+08(A2)
	MOVE.B	4(A3,D2.W),160*4+08(A2)
	MOVE.B	5(A3,D2.W),160*5+08(A2)
	MOVE.B	6(A3,D2.W),160*6+08(A2)

	MOVE.W	DGG3,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+16(A1)
	MOVE.B	1(A3,D2.W),160*1+16(A1)
	MOVE.B	2(A3,D2.W),160*2+16(A1)
	MOVE.B	3(A3,D2.W),160*3+16(A1)
	MOVE.B	4(A3,D2.W),160*4+16(A1)
	MOVE.B	5(A3,D2.W),160*5+16(A1)
	MOVE.B	6(A3,D2.W),160*6+16(A1)
	MOVE.B	0(A3,D2.W),160*0+16(A2)
	MOVE.B	1(A3,D2.W),160*1+16(A2)
	MOVE.B	2(A3,D2.W),160*2+16(A2)
	MOVE.B	3(A3,D2.W),160*3+16(A2)
	MOVE.B	4(A3,D2.W),160*4+16(A2)
	MOVE.B	5(A3,D2.W),160*5+16(A2)
	MOVE.B	6(A3,D2.W),160*6+16(A2)
	MOVE.W	DGG4,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+17(A1)
	MOVE.B	1(A3,D2.W),160*1+17(A1)
	MOVE.B	2(A3,D2.W),160*2+17(A1)
	MOVE.B	3(A3,D2.W),160*3+17(A1)
	MOVE.B	4(A3,D2.W),160*4+17(A1)
	MOVE.B	5(A3,D2.W),160*5+17(A1)
	MOVE.B	6(A3,D2.W),160*6+17(A1)
	MOVE.B	0(A3,D2.W),160*0+17(A2)
	MOVE.B	1(A3,D2.W),160*1+17(A2)
	MOVE.B	2(A3,D2.W),160*2+17(A2)
	MOVE.B	3(A3,D2.W),160*3+17(A2)
	MOVE.B	4(A3,D2.W),160*4+17(A2)
	MOVE.B	5(A3,D2.W),160*5+17(A2)
	MOVE.B	6(A3,D2.W),160*6+17(A2)

	MOVE.W	DGG5,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),160*0+25(A1)
	MOVE.B	1(A3,D2.W),160*1+25(A1)
	MOVE.B	2(A3,D2.W),160*2+25(A1)
	MOVE.B	3(A3,D2.W),160*3+25(A1)
	MOVE.B	4(A3,D2.W),160*4+25(A1)
	MOVE.B	5(A3,D2.W),160*5+25(A1)
	MOVE.B	6(A3,D2.W),160*6+25(A1)
	MOVE.B	0(A3,D2.W),160*0+25(A2)
	MOVE.B	1(A3,D2.W),160*1+25(A2)
	MOVE.B	2(A3,D2.W),160*2+25(A2)
	MOVE.B	3(A3,D2.W),160*3+25(A2)
	MOVE.B	4(A3,D2.W),160*4+25(A2)
	MOVE.B	5(A3,D2.W),160*5+25(A2)
	MOVE.B	6(A3,D2.W),160*6+25(A2)
	RTS

ROUTE:	DC.W	1

NEW_ROUTE:
	MOVE.B	KEY,D7
	CMP.B	#59,D7
	BLT	OLD_ROUTE
	CMP.B	#63,D7
	BGT	OLD_ROUTE
	LEA	HI_SCORES,A6
	MOVE.W	ROUTE,D6
	SUBQ.W	#1,D6
	MULU	#10,D6
	MOVEM.W	DGG1,D1-D5
	MOVEM.W	D1-D5,0(A6,D6.L)
	SUB.B	#58,D7
	AND.L	#$FF,D7
	MOVE.W	D7,ROUTE
	MOVE.L	D7,D11
	CMP.W	#10,D7
	BNE	NO10
	MOVE.L	#$10000,D11
NO10:	SUBQ.L	#1,D7
	MOVE.L	D7,D6
	LSL.L	#2,D6
	LEA	VECTORS,A5
	MOVE.L	0(A5,D6.L),RACE+2
	MULU	#10,D7
	MOVEM.W	0(A6,D7.L),D1-D5
	MOVEM.W	D1-D5,DGG1
	BSR	NUMER1
	BSR	NUMER3
OLD_ROUTE:
	RTS

VECTORS:
	DC.L	RACE0
	DC.L	RACE1
	DC.L	RACE2
	DC.L	RACE3
	DC.L	RACE4

SAVE:	DC.B	"R.R."
HI_SCORES:
	DC.W	0,1,3,5,5
	DC.W	0,0,4,8,4
	DC.W	0,1,5,9,9
	DC.W	0,0,5,3,0
	DC.W	0,0,5,3,9
	DC.B	"261273"
	
NEW_RECORD:
	move.w	#tex2-tex,pnt
	MOVEM.W	DG1,D1-D5
	MULU	#10000,D1
	MULU	#1000,D2
	MULU	#100,D3
	MULU	#10,D4
	MOVEQ	#0,D6
	ADD.L	D1,D6
	ADD.L	D2,D6
	ADD.L	D3,D6
	ADD.L	D4,D6
	ADD.L	D5,D6
	MOVEM.W	DGG1,D1-D5
	MULU	#10000,D1
	MULU	#1000,D2
	MULU	#100,D3
	MULU	#10,D4
	ADD.L	D1,D5
	ADD.L	D2,D5
	ADD.L	D3,D5
	ADD.L	D4,D5
	CMP.L	D5,D6
	BGE	NOR
	MOVEM.W	DG1,D1-D5
	MOVEM.W	D1-D5,DGG1
	BSR	NUMER3
	move.w	#tex3-tex,pnt
NOR:	RTS

CYFRY:	DC.B	%0111110
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0000000
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	0


	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000000
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000001
	DC.B	0

	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0111110
	DC.B	%1000000
	DC.B	%1000000
	DC.B	%0111110
	DC.B	0

	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0111110
	DC.B	0

	DC.B	%1000001
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000001
	DC.B	0

	DC.B	%0111110
	DC.B	%1000000
	DC.B	%1000000
	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0111110
	DC.B	0

	DC.B	%0111110
	DC.B	%1000000
	DC.B	%1000000
	DC.B	%0111110
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	0

	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000000
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0000001
	DC.B	0

	DC.B	%0111110
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	0

	DC.B	%0111110
	DC.B	%1000001
	DC.B	%1000001
	DC.B	%0111110
	DC.B	%0000001
	DC.B	%0000001
	DC.B	%0111110
	DC.B	0

RACE0:	DC.L	0,400,200*00+050
	DC.L	0,400,200*00+050
	DC.L	1,400,200*00+150
	DC.L	1,400,200*00+150

	DC.L	0,401,200*01+050
	DC.L	0,401,200*01+050
	DC.L	1,403,200*01+150
	DC.L	1,403,200*01+150

	DC.L	0,406,200*02+050
	DC.L	0,406,200*02+050
	DC.L	1,410,200*02+150
	DC.L	1,410,200*02+150

	DC.L	0,415,200*03+050
	DC.L	0,415,200*03+050
	DC.L	1,425,200*03+150
	DC.L	1,425,200*03+150

	DC.L	0,440,200*04+050
	DC.L	0,440,200*04+050
	DC.L	1,440,200*04+150
	DC.L	1,440,200*04+150

	DC.L	0,440,200*05+050
	DC.L	0,440,200*05+050
	DC.L	1,440,200*05+150
	DC.L	1,440,200*05+150

	DC.L	0,440,200*06+050
	DC.L	0,440,200*06+050
	DC.L	1,440,200*06+150
	DC.L	1,440,200*06+150

	DC.L	0,420,200*07+050
	DC.L	0,420,200*07+050
	DC.L	1,400,200*07+150
	DC.L	1,400,200*07+150

	DC.L	0,380,200*08+050
	DC.L	0,380,200*08+050
	DC.L	1,360,200*08+150
	DC.L	1,360,200*08+150

	DC.L	0,340,200*09+050
	DC.L	0,340,200*09+050
	DC.L	1,320,200*09+150
	DC.L	1,320,200*09+150

	DC.L	0,300,200*10+050
	DC.L	0,300,200*10+050
	DC.L	1,290,200*10+150
	DC.L	1,290,200*10+150

	DC.L	0,280,200*11+050
	DC.L	0,280,200*11+050
	DC.L	1,270,200*11+150
	DC.L	1,270,200*11+150

	DC.L	0,260,200*12+050
	DC.L	0,260,200*12+050
	DC.L	1,250,200*12+150
	DC.L	1,250,200*12+150

	DC.L	0,240,200*13+050
	DC.L	0,240,200*13+050
	DC.L	1,240,200*13+150
	DC.L	1,240,200*13+150

	DC.L	0,240,200*14+050
	DC.L	0,240,200*14+050
	DC.L	1,240,200*14+150
	DC.L	1,240,200*14+150

	DC.L	0,240,200*15+050
	DC.L	0,240,200*15+050
	DC.L	1,240,200*15+150
	DC.L	1,240,200*15+150

	DC.L	0,240,200*16+050
	DC.L	0,240,200*16+050
	DC.L	1,240,200*16+150
	DC.L	1,240,200*16+150

	DC.L	0,240,200*17+050
	DC.L	0,240,200*17+050
	DC.L	1,240,200*17+150
	DC.L	1,240,200*17+150

	DC.L	0,240,200*18+050
	DC.L	0,240,200*18+050
	DC.L	1,240,200*18+150
	DC.L	1,240,200*18+150

	DC.L	0,235,200*19+050
	DC.L	0,235,200*19+050
	DC.L	1,230,200*19+150
	DC.L	1,230,200*19+150

	DC.L	0,220,200*20+050
	DC.L	0,220,200*20+050
	DC.L	1,210,200*20+150
	DC.L	1,210,200*20+150

	DC.L	0,200,200*21+050
	DC.L	0,200,200*21+050
	DC.L	1,190,200*21+150
	DC.L	1,190,200*21+150

	DC.L	0,180,200*22+050
	DC.L	0,180,200*22+050
	DC.L	1,170,200*22+150
	DC.L	1,170,200*22+150

	DC.L	0,160,200*23+050
	DC.L	0,160,200*23+050
	DC.L	1,150,200*23+150
	DC.L	1,150,200*23+150

	DC.L	0,140,200*24+050
	DC.L	0,140,200*24+050
	DC.L	1,130,200*24+150
	DC.L	1,130,200*24+150

	DC.L	0,120,200*25+050
	DC.L	0,120,200*25+050
	DC.L	1,110,200*25+150
	DC.L	1,110,200*25+150

	DC.L	0,100,200*26+050
	DC.L	0,100,200*26+050
	DC.L	1,100,200*26+150
	DC.L	1,100,200*26+150

	DC.L	0,090,200*27+050
	DC.L	0,090,200*27+050
	DC.L	1,080,200*27+150
	DC.L	1,080,200*27+150

	DC.L	0,070,200*28+050
	DC.L	0,070,200*28+050
	DC.L	1,070,200*28+150
	DC.L	1,070,200*28+150

	DC.L	0,070,200*29+050
	DC.L	0,070,200*29+050
	DC.L	1,070,200*29+150
	DC.L	1,070,200*29+150

	DC.L	0,070,200*30+050
	DC.L	0,070,200*30+050
	DC.L	1,070,200*30+150
	DC.L	1,070,200*30+150

	DC.L	0,070,200*31+050
	DC.L	0,070,200*31+050
	DC.L	1,070,200*31+150
	DC.L	1,070,200*31+150

	DC.L	0,070,200*32+050
	DC.L	0,070,200*32+050
	DC.L	1,070,200*32+150
	DC.L	1,070,200*32+150

	DC.L	0,070,200*33+050
	DC.L	0,070,200*33+050
	DC.L	1,070,200*33+150
	DC.L	1,070,200*33+150

	DC.L	0,070,200*34+050
	DC.L	0,070,200*34+050
	DC.L	1,080,200*34+150
	DC.L	1,080,200*34+150

	DC.L	0,100,200*35+050
	DC.L	0,100,200*35+050
	DC.L	1,120,200*35+150
	DC.L	1,120,200*35+150

	DC.L	0,150,200*36+050
	DC.L	0,150,200*36+050
	DC.L	1,180,200*36+150
	DC.L	1,180,200*36+150

	DC.L	0,200,200*37+050
	DC.L	0,200,200*37+050
	DC.L	1,220,200*37+150
	DC.L	1,220,200*37+150

	DC.L	0,240,200*38+050
	DC.L	0,240,200*38+050
	DC.L	1,260,200*38+150
	DC.L	1,260,200*38+150

	DC.L	0,280,200*39+050
	DC.L	0,280,200*39+050
	DC.L	1,300,200*39+150
	DC.L	1,300,200*39+150

	DC.L	0,320,200*40+050
	DC.L	0,320,200*40+050
	DC.L	1,340,200*40+150
	DC.L	1,340,200*40+150

	DC.L	0,360,200*41+050
	DC.L	0,360,200*41+050
	DC.L	1,380,200*41+150
	DC.L	1,380,200*41+150

	DC.L	0,400,200*42+050
	DC.L	0,400,200*42+050
	DC.L	1,420,200*42+150
	DC.L	1,420,200*42+150

	DC.L	0,440,200*43+050
	DC.L	0,440,200*43+050
	DC.L	1,460,200*43+150
	DC.L	1,460,200*43+150

	DC.L	0,480,200*44+050
	DC.L	0,480,200*44+050
	DC.L	1,500,200*44+150
	DC.L	1,500,200*44+150

	DC.L	0,520,200*45+050
	DC.L	0,520,200*45+050
	DC.L	1,540,200*45+150
	DC.L	1,540,200*45+150

	DC.L	0,560,200*46+050
	DC.L	0,560,200*46+050
	DC.L	1,580,200*46+150
	DC.L	1,580,200*46+150

	DC.L	0,560,200*47+050
	DC.L	0,560,200*47+050
	DC.L	1,580,200*47+150
	DC.L	1,580,200*47+150

	DC.L	0,560,200*48+050
	DC.L	0,560,200*48+050
	DC.L	1,580,200*48+150
	DC.L	1,580,200*48+150

	DC.L	0,560,200*49+050
	DC.L	0,560,200*49+050
	DC.L	1,580,200*49+150
	DC.L	1,580,200*49+150

	DS.L	100

RACE1:	DC.L	0,250,200*00+150
	DC.L	0,250,200*00+150
	DC.L	0,250,200*00+150
	DC.L	0,250,200*00+150

	DC.L	1,270,200*01+150
	DC.L	1,270,200*01+150
	DC.L	1,270,200*01+150
	DC.L	1,270,200*01+150

	DC.L	0,250,200*02+150
	DC.L	0,250,200*02+150
	DC.L	0,250,200*02+150
	DC.L	0,250,200*02+150

	DC.L	1,300,200*03+150
	DC.L	1,300,200*03+150
	DC.L	1,300,200*03+150
	DC.L	1,300,200*03+150

	DC.L	0,350,200*04+150
	DC.L	0,350,200*04+150
	DC.L	0,350,200*04+150
	DC.L	0,350,200*04+150

	DC.L	1,400,200*05+150
	DC.L	1,400,200*05+150
	DC.L	1,400,200*05+150
	DC.L	1,400,200*05+150

	DC.L	0,450,200*06+150
	DC.L	0,450,200*06+150
	DC.L	0,450,200*06+150
	DC.L	0,450,200*06+150

	DC.L	1,500,200*07+150
	DC.L	1,500,200*07+150
	DC.L	1,500,200*07+150
	DC.L	1,500,200*07+150

	DC.L	0,550,200*08+150
	DC.L	0,550,200*08+150
	DC.L	0,550,200*08+150
	DC.L	0,550,200*08+150

	DC.L	1,600,200*09+150
	DC.L	1,600,200*09+150
	DC.L	1,600,200*09+150
	DC.L	1,600,200*09+150

	DC.L	0,650,200*10+150
	DC.L	0,650,200*10+150
	DC.L	0,650,200*10+150
	DC.L	0,650,200*10+150

	DC.L	1,690,200*11+150
	DC.L	1,690,200*11+150
	DC.L	1,690,200*11+150
	DC.L	1,690,200*11+150

	DC.L	0,720,200*12+150
	DC.L	0,720,200*12+150
	DC.L	0,720,200*12+150
	DC.L	0,720,200*12+150

	DC.L	1,740,200*13+150
	DC.L	1,740,200*13+150
	DC.L	1,740,200*13+150
	DC.L	1,740,200*13+150

	DC.L	0,730,200*14+150
	DC.L	0,730,200*14+150
	DC.L	0,730,200*14+150
	DC.L	0,730,200*14+150

	DC.L	1,740,200*15+150
	DC.L	1,740,200*15+150
	DC.L	1,740,200*15+150
	DC.L	1,740,200*15+150

	DC.L	0,730,200*16+150
	DC.L	0,730,200*16+150
	DC.L	0,730,200*16+150
	DC.L	0,730,200*16+150

	DC.L	1,740,200*17+150
	DC.L	1,740,200*17+150
	DC.L	1,740,200*17+150
	DC.L	1,740,200*17+150

	DC.L	0,730,200*18+150
	DC.L	0,730,200*18+150
	DC.L	0,730,200*18+150
	DC.L	0,730,200*18+150

	DC.L	1,740,200*19+150
	DC.L	1,740,200*19+150
	DC.L	1,740,200*19+150
	DC.L	1,740,200*19+150

	DC.L	0,730,200*20+150
	DC.L	0,730,200*20+150
	DC.L	0,730,200*20+150
	DC.L	0,730,200*20+150

	DC.L	1,740,200*21+150
	DC.L	1,740,200*21+150
	DC.L	1,740,200*21+150
	DC.L	1,740,200*21+150

	DC.L	0,730,200*22+150
	DC.L	0,730,200*22+150
	DC.L	0,730,200*22+150
	DC.L	0,730,200*22+150

	DC.L	1,740,200*23+150
	DC.L	1,740,200*23+150
	DC.L	1,740,200*23+150
	DC.L	1,740,200*23+150

	DC.L	0,740,200*24+150
	DC.L	0,740,200*24+150
	DC.L	0,740,200*24+150
	DC.L	0,740,200*24+150

	DC.L	1,735,200*25+150
	DC.L	1,735,200*25+150
	DC.L	1,735,200*25+150
	DC.L	1,735,200*25+150

	DC.L	0,730,200*26+150
	DC.L	0,730,200*26+150
	DC.L	0,730,200*26+150
	DC.L	0,730,200*26+150

	DC.L	1,720,200*27+150
	DC.L	1,720,200*27+150
	DC.L	1,720,200*27+150
	DC.L	1,720,200*27+150

	DC.L	0,700,200*28+150
	DC.L	0,700,200*28+150
	DC.L	0,700,200*28+150
	DC.L	0,700,200*28+150

	DC.L	1,680,200*29+150
	DC.L	1,680,200*29+150
	DC.L	1,680,200*29+150
	DC.L	1,680,200*29+150

	DC.L	0,650,200*30+150
	DC.L	0,650,200*30+150
	DC.L	0,650,200*30+150
	DC.L	0,650,200*30+150

	DC.L	1,620,200*31+150
	DC.L	1,620,200*31+150
	DC.L	1,620,200*31+150
	DC.L	1,620,200*31+150

	DC.L	0,590,200*32+150
	DC.L	0,590,200*32+150
	DC.L	0,590,200*32+150
	DC.L	0,590,200*32+150

	DC.L	1,560,200*33+150
	DC.L	1,560,200*33+150
	DC.L	1,560,200*33+150
	DC.L	1,560,200*33+150

	DC.L	0,530,200*34+150
	DC.L	0,530,200*34+150
	DC.L	0,530,200*34+150
	DC.L	0,530,200*34+150

	DC.L	1,500,200*35+150
	DC.L	1,500,200*35+150
	DC.L	1,500,200*35+150
	DC.L	1,500,200*35+150

	DC.L	0,480,200*36+150
	DC.L	0,480,200*36+150
	DC.L	0,480,200*36+150
	DC.L	0,480,200*36+150

	DC.L	1,460,200*37+150
	DC.L	1,460,200*37+150
	DC.L	1,460,200*37+150
	DC.L	1,460,200*37+150

	DC.L	0,440,200*38+150
	DC.L	0,440,200*38+150
	DC.L	0,440,200*38+150
	DC.L	0,440,200*38+150

	DC.L	1,420,200*39+150
	DC.L	1,420,200*39+150
	DC.L	1,420,200*39+150
	DC.L	1,420,200*39+150

	DC.L	0,400,200*40+150
	DC.L	0,400,200*40+150
	DC.L	0,400,200*40+150
	DC.L	0,400,200*40+150

	DC.L	1,420,200*41+150
	DC.L	1,420,200*41+150
	DC.L	1,420,200*41+150
	DC.L	1,420,200*41+150

	DC.L	0,400,200*42+150
	DC.L	0,400,200*42+150
	DC.L	0,400,200*42+150
	DC.L	0,400,200*42+150

	DC.L	1,420,200*43+150
	DC.L	1,420,200*43+150
	DC.L	1,420,200*43+150
	DC.L	1,420,200*43+150

	DC.L	0,400,200*44+150
	DC.L	0,400,200*44+150
	DC.L	0,400,200*44+150
	DC.L	0,400,200*44+150

	DC.L	1,420,200*45+150
	DC.L	1,420,200*45+150
	DC.L	1,420,200*45+150
	DC.L	1,420,200*45+150

	DC.L	0,400,200*46+150
	DC.L	0,400,200*46+150
	DC.L	0,400,200*46+150
	DC.L	0,400,200*46+150

	DC.L	1,400,200*47+150
	DC.L	1,400,200*47+150
	DC.L	1,400,200*47+150
	DC.L	1,400,200*47+150

	DC.L	0,400,200*48+150
	DC.L	0,400,200*48+150
	DC.L	0,400,200*48+150
	DC.L	0,400,200*48+150

	DC.L	1,400,200*49+150
	DC.L	1,400,200*49+150
	DC.L	1,400,200*49+150
	DC.L	1,400,200*49+150

	DS.L	100

RACE2:	DC.L	0,500,200*00+050
	DC.L	0,500,200*00+070
	DC.L	1,500,200*00+150
	DC.L	1,500,200*00+170

	DC.L	0,500,200*01+050
	DC.L	0,500,200*01+070
	DC.L	1,500,200*01+150
	DC.L	1,500,200*01+170

	DC.L	0,500,200*02+050
	DC.L	0,500,200*02+070
	DC.L	1,500,200*02+150
	DC.L	1,500,200*02+170

	DC.L	0,500,200*03+050
	DC.L	0,500,200*03+070
	DC.L	1,500,200*03+150
	DC.L	1,500,200*03+170

	DC.L	0,505,200*04+050
	DC.L	0,510,200*04+070
	DC.L	1,515,200*04+150
	DC.L	1,520,200*04+170

	DC.L	0,530,200*05+050
	DC.L	0,530,200*05+070
	DC.L	1,540,200*05+150
	DC.L	1,540,200*05+170

	DC.L	0,560,200*06+050
	DC.L	0,560,200*06+070
	DC.L	1,580,200*06+150
	DC.L	1,580,200*06+170

	DC.L	0,600,200*07+050
	DC.L	0,600,200*07+070
	DC.L	1,600,200*07+150
	DC.L	1,600,200*07+170

	DC.L	0,620,200*08+050
	DC.L	0,620,200*08+070
	DC.L	1,640,200*08+150
	DC.L	1,640,200*08+170

	DC.L	0,660,200*09+050
	DC.L	0,660,200*09+070
	DC.L	1,680,200*09+150
	DC.L	1,680,200*09+170

	DC.L	0,700,200*10+050
	DC.L	0,700,200*10+070
	DC.L	1,700,200*10+150
	DC.L	1,700,200*10+170

	DC.L	0,700,200*11+050
	DC.L	0,700,200*11+070
	DC.L	1,700,200*11+150
	DC.L	1,700,200*11+170

	DC.L	0,700,200*12+050
	DC.L	0,700,200*12+070
	DC.L	1,700,200*12+150
	DC.L	1,700,200*12+170

	DC.L	0,700,200*13+050
	DC.L	0,700,200*13+070
	DC.L	1,700,200*13+150
	DC.L	1,700,200*13+170

	DC.L	0,700,200*14+050
	DC.L	0,700,200*14+070
	DC.L	1,700,200*14+150
	DC.L	1,700,200*14+170

	DC.L	0,700,200*15+050
	DC.L	0,700,200*15+070
	DC.L	1,700,200*15+150
	DC.L	1,700,200*15+170

	DC.L	0,700,200*16+050
	DC.L	0,705,200*16+070
	DC.L	1,710,200*16+150
	DC.L	1,715,200*16+170

	DC.L	0,720,200*17+050
	DC.L	0,720,200*17+070
	DC.L	1,720,200*17+150
	DC.L	1,720,200*17+170

	DC.L	0,690,200*18+050
	DC.L	0,690,200*18+070
	DC.L	1,590,200*18+150
	DC.L	1,590,200*18+170

	DC.L	0,560,200*19+050
	DC.L	0,560,200*19+070
	DC.L	1,530,200*19+150
	DC.L	1,530,200*19+170

	DC.L	0,500,200*20+050
	DC.L	0,490,200*20+070
	DC.L	1,480,200*20+150
	DC.L	1,470,200*20+170

	DC.L	0,460,200*21+050
	DC.L	0,450,200*21+070
	DC.L	1,440,200*21+150
	DC.L	1,430,200*21+170

	DC.L	0,420,200*22+050
	DC.L	0,420,200*22+070
	DC.L	1,420,200*22+150
	DC.L	1,420,200*22+170

	DC.L	0,420,200*23+050
	DC.L	0,420,200*23+070
	DC.L	1,420,200*23+150
	DC.L	1,420,200*23+170

	DC.L	0,410,200*24+050
	DC.L	0,400,200*24+070
	DC.L	1,390,200*24+150
	DC.L	1,380,200*24+170

	DC.L	0,360,200*25+050
	DC.L	0,360,200*25+070
	DC.L	1,340,200*25+150
	DC.L	1,340,200*25+170

	DC.L	0,320,200*26+050
	DC.L	0,320,200*26+070
	DC.L	1,300,200*26+150
	DC.L	1,300,200*26+170

	DC.L	0,310,200*27+050
	DC.L	0,320,200*27+070
	DC.L	1,330,200*27+150
	DC.L	1,340,200*27+170

	DC.L	0,350,200*28+050
	DC.L	0,360,200*28+070
	DC.L	1,370,200*28+150
	DC.L	1,370,200*28+170

	DC.L	0,380,200*29+050
	DC.L	0,380,200*29+070
	DC.L	1,390,200*29+150
	DC.L	1,390,200*29+170

	DC.L	0,400,200*30+050
	DC.L	0,400,200*30+070
	DC.L	1,400,200*30+150
	DC.L	1,400,200*30+170

	DC.L	0,400,200*31+050
	DC.L	0,400,200*31+070
	DC.L	1,400,200*31+150
	DC.L	1,400,200*31+170

	DC.L	0,380,200*32+050
	DC.L	0,380,200*32+070
	DC.L	1,380,200*32+150
	DC.L	1,380,200*32+170

	DC.L	0,370,200*33+050
	DC.L	0,370,200*33+070
	DC.L	1,390,200*33+150
	DC.L	1,390,200*33+170

	DC.L	0,380,200*34+050
	DC.L	0,380,200*34+070
	DC.L	1,360,200*34+150
	DC.L	1,360,200*34+170

	DC.L	0,340,200*35+050
	DC.L	0,340,200*35+070
	DC.L	1,350,200*35+150
	DC.L	1,350,200*35+170

	DC.L	0,320,200*36+050
	DC.L	0,320,200*36+070
	DC.L	1,300,200*36+150
	DC.L	1,300,200*36+170

	DC.L	0,280,200*37+050
	DC.L	0,280,200*37+070
	DC.L	1,260,200*37+150
	DC.L	1,260,200*37+170

	DC.L	0,280,200*38+050
	DC.L	0,280,200*38+070
	DC.L	1,260,200*38+150
	DC.L	1,260,200*38+170

	DC.L	0,280,200*39+050
	DC.L	0,280,200*39+070
	DC.L	1,260,200*39+150
	DC.L	1,260,200*39+170

	DC.L	0,280,200*40+050
	DC.L	0,280,200*40+070
	DC.L	1,260,200*40+150
	DC.L	1,260,200*40+170

	DC.L	0,280,200*41+050
	DC.L	0,280,200*41+070
	DC.L	1,260,200*41+150
	DC.L	1,260,200*41+170

	DC.L	0,280,200*42+050
	DC.L	0,280,200*42+070
	DC.L	1,260,200*42+150
	DC.L	1,260,200*42+170

	DC.L	0,280,200*43+050
	DC.L	0,280,200*43+070
	DC.L	1,260,200*43+150
	DC.L	1,260,200*43+170

	DC.L	0,280,200*44+050
	DC.L	0,280,200*44+070
	DC.L	1,300,200*44+150
	DC.L	1,300,200*44+170

	DC.L	0,320,200*45+050
	DC.L	0,320,200*45+070
	DC.L	1,340,200*45+150
	DC.L	1,340,200*45+170

	DC.L	0,360,200*46+050
	DC.L	0,360,200*46+070
	DC.L	1,380,200*46+150
	DC.L	1,380,200*46+170

	DC.L	0,360,200*47+050
	DC.L	0,360,200*47+070
	DC.L	1,380,200*47+150
	DC.L	1,380,200*47+170

	DC.L	0,360,200*48+050
	DC.L	0,360,200*48+070
	DC.L	1,380,200*48+150
	DC.L	1,380,200*48+170

	DC.L	0,360,200*49+050
	DC.L	0,360,200*49+070
	DC.L	1,380,200*49+150
	DC.L	1,380,200*49+170

	DS.L	100

RACE3:	DC.L	0,450,200*00+110
	DC.L	0,450,200*00+130
	DC.L	0,450,200*00+150
	DC.L	0,450,200*00+170

	DC.L	1,500,200*01+110
	DC.L	1,500,200*01+130
	DC.L	1,500,200*01+150
	DC.L	1,500,200*01+170

	DC.L	0,500,200*02+110
	DC.L	0,500,200*02+130
	DC.L	0,500,200*02+150
	DC.L	0,500,200*02+170

	DC.L	1,600,200*03+110
	DC.L	1,600,200*03+130
	DC.L	1,600,200*03+150
	DC.L	1,600,200*03+170

	DC.L	0,610,200*04+110
	DC.L	0,620,200*04+130
	DC.L	0,630,200*04+150
	DC.L	0,640,200*04+170

	DC.L	1,630,200*05+110
	DC.L	1,640,200*05+130
	DC.L	1,650,200*05+150
	DC.L	1,660,200*05+170

	DC.L	0,670,200*06+110
	DC.L	0,680,200*06+130
	DC.L	0,690,200*06+150
	DC.L	0,700,200*06+170

	DC.L	1,720,200*07+110
	DC.L	1,720,200*07+130
	DC.L	1,720,200*07+150
	DC.L	1,720,200*07+170

	DC.L	0,740,200*08+110
	DC.L	0,740,200*08+130
	DC.L	0,740,200*08+150
	DC.L	0,740,200*08+170

	DC.L	1,740,200*09+110
	DC.L	1,740,200*09+130
	DC.L	1,740,200*09+150
	DC.L	1,740,200*09+170

	DC.L	0,730,200*10+110
	DC.L	0,720,200*10+130
	DC.L	0,710,200*10+150
	DC.L	0,700,200*10+170

	DC.L	1,630,200*11+110
	DC.L	1,620,200*11+130
	DC.L	1,610,200*11+150
	DC.L	1,600,200*11+170

	DC.L	0,530,200*12+110
	DC.L	0,520,200*12+130
	DC.L	0,510,200*12+150
	DC.L	0,500,200*12+170

	DC.L	1,430,200*13+110
	DC.L	1,420,200*13+130
	DC.L	1,410,200*13+150
	DC.L	1,400,200*13+170

	DC.L	0,330,200*14+110
	DC.L	0,320,200*14+130
	DC.L	0,310,200*14+150
	DC.L	0,300,200*14+170

	DC.L	1,250,200*15+110
	DC.L	1,250,200*15+130
	DC.L	1,250,200*15+150
	DC.L	1,250,200*15+170

	DC.L	0,200,200*16+110
	DC.L	0,200,200*16+130
	DC.L	0,200,200*16+150
	DC.L	0,200,200*16+170

	DC.L	1,160,200*17+110
	DC.L	1,160,200*17+130
	DC.L	1,160,200*17+150
	DC.L	1,160,200*17+170

	DC.L	0,130,200*18+110
	DC.L	0,130,200*18+130
	DC.L	0,130,200*18+150
	DC.L	0,130,200*18+170

	DC.L	1,100,200*19+110
	DC.L	1,100,200*19+130
	DC.L	1,100,200*19+150
	DC.L	1,100,200*19+170

	DC.L	0,080,200*20+110
	DC.L	0,080,200*20+130
	DC.L	0,080,200*20+150
	DC.L	0,080,200*20+170

	DC.L	1,100,200*21+110
	DC.L	1,100,200*21+130
	DC.L	1,100,200*21+150
	DC.L	1,100,200*21+170

	DC.L	0,080,200*22+110
	DC.L	0,080,200*22+130
	DC.L	0,080,200*22+150
	DC.L	0,080,200*22+170

	DC.L	1,100,200*23+110
	DC.L	1,100,200*23+130
	DC.L	1,100,200*23+150
	DC.L	1,100,200*23+170

	DC.L	0,080,200*24+110
	DC.L	0,080,200*24+130
	DC.L	0,080,200*24+150
	DC.L	0,080,200*24+170

	DC.L	1,090,200*25+110
	DC.L	1,090,200*25+130
	DC.L	1,090,200*25+150
	DC.L	1,090,200*25+170

	DC.L	0,100,200*26+110
	DC.L	0,100,200*26+130
	DC.L	0,100,200*26+150
	DC.L	0,100,200*26+170

	DC.L	1,110,200*27+110
	DC.L	1,110,200*27+130
	DC.L	1,110,200*27+150
	DC.L	1,110,200*27+170

	DC.L	0,120,200*28+110
	DC.L	0,120,200*28+130
	DC.L	0,120,200*28+150
	DC.L	0,120,200*28+170

	DC.L	1,130,200*29+110
	DC.L	1,130,200*29+130
	DC.L	1,130,200*29+150
	DC.L	1,130,200*29+170

	DC.L	0,140,200*30+110
	DC.L	0,140,200*30+130
	DC.L	0,140,200*30+150
	DC.L	0,140,200*30+170

	DC.L	1,150,200*31+110
	DC.L	1,150,200*31+130
	DC.L	1,150,200*31+150
	DC.L	1,150,200*31+170

	DC.L	0,170,200*32+110
	DC.L	0,170,200*32+130
	DC.L	0,170,200*32+150
	DC.L	0,170,200*32+170

	DC.L	1,200,200*33+110
	DC.L	1,200,200*33+130
	DC.L	1,200,200*33+150
	DC.L	1,200,200*33+170

	DC.L	0,230,200*34+110
	DC.L	0,230,200*34+130
	DC.L	0,230,200*34+150
	DC.L	0,230,200*34+170

	DC.L	1,260,200*35+110
	DC.L	1,260,200*35+130
	DC.L	1,260,200*35+150
	DC.L	1,260,200*35+170

	DC.L	0,280,200*36+110
	DC.L	0,280,200*36+130
	DC.L	0,280,200*36+150
	DC.L	0,280,200*36+170

	DC.L	1,300,200*37+110
	DC.L	1,300,200*37+130
	DC.L	1,300,200*37+150
	DC.L	1,300,200*37+170

	DC.L	0,310,200*38+110
	DC.L	0,310,200*38+130
	DC.L	0,310,200*38+150
	DC.L	0,310,200*38+170

	DC.L	1,320,200*39+110
	DC.L	1,320,200*39+130
	DC.L	1,320,200*39+150
	DC.L	1,320,200*39+170

	DC.L	0,300,200*40+110
	DC.L	0,300,200*40+130
	DC.L	0,300,200*40+150
	DC.L	0,300,200*40+170

	DC.L	1,320,200*41+110
	DC.L	1,320,200*41+130
	DC.L	1,320,200*41+150
	DC.L	1,320,200*41+170

	DC.L	0,300,200*42+110
	DC.L	0,300,200*42+130
	DC.L	0,300,200*42+150
	DC.L	0,300,200*42+170

	DC.L	1,320,200*43+110
	DC.L	1,320,200*43+130
	DC.L	1,320,200*43+150
	DC.L	1,320,200*43+170

	DC.L	0,300,200*44+110
	DC.L	0,300,200*44+130
	DC.L	0,300,200*44+150
	DC.L	0,300,200*44+170

	DC.L	1,320,200*45+110
	DC.L	1,320,200*45+130
	DC.L	1,320,200*45+150
	DC.L	1,320,200*45+170

	DC.L	0,300,200*46+110
	DC.L	0,300,200*46+130
	DC.L	0,300,200*46+150
	DC.L	0,300,200*46+170

	DC.L	1,300,200*47+110
	DC.L	1,300,200*47+130
	DC.L	1,300,200*47+150
	DC.L	1,300,200*47+170

	DC.L	0,300,200*48+110
	DC.L	0,300,200*48+130
	DC.L	0,300,200*48+150
	DC.L	0,300,200*48+170

	DC.L	1,300,200*49+110
	DC.L	1,300,200*49+130
	DC.L	1,300,200*49+150
	DC.L	1,300,200*49+170

	DS.L	100

RACE4:	DC.L	0,600,200*00+110
	DC.L	0,600,200*00+130
	DC.L	1,700,200*00+110
	DC.L	1,700,200*00+130

	DC.L	0,600,200*01+110
	DC.L	0,600,200*01+130
	DC.L	1,700,200*01+110
	DC.L	1,700,200*01+130

	DC.L	0,600,200*02+110
	DC.L	0,600,200*02+130
	DC.L	1,700,200*02+110
	DC.L	1,700,200*02+130

	DC.L	0,600,200*03+110
	DC.L	0,600,200*03+130
	DC.L	1,700,200*03+110
	DC.L	1,700,200*03+130

	DC.L	0,600,200*04+110
	DC.L	0,600,200*04+130
	DC.L	1,700,200*04+110
	DC.L	1,700,200*04+130

	DC.L	0,600,200*05+110
	DC.L	0,600,200*05+130
	DC.L	1,700,200*05+110
	DC.L	1,700,200*05+130

	DC.L	0,600,200*06+110
	DC.L	0,600,200*06+130
	DC.L	1,700,200*06+110
	DC.L	1,700,200*06+130

	DC.L	0,440,200*07+110
	DC.L	0,440,200*07+130
	DC.L	1,540,200*07+110
	DC.L	1,540,200*07+130

	DC.L	0,370,200*08+110
	DC.L	0,370,200*08+130
	DC.L	1,470,200*08+110
	DC.L	1,470,200*08+130

	DC.L	0,300,200*09+110
	DC.L	0,300,200*09+130
	DC.L	1,400,200*09+110
	DC.L	1,400,200*09+130

	DC.L	0,280,200*10+110
	DC.L	0,280,200*10+130
	DC.L	1,380,200*10+110
	DC.L	1,380,200*10+130

	DC.L	0,260,200*11+110
	DC.L	0,260,200*11+130
	DC.L	1,360,200*11+110
	DC.L	1,360,200*11+130

	DC.L	0,240,200*12+110
	DC.L	0,240,200*12+130
	DC.L	1,340,200*12+110
	DC.L	1,340,200*12+130

	DC.L	0,220,200*13+110
	DC.L	0,220,200*13+130
	DC.L	1,320,200*13+110
	DC.L	1,320,200*13+130

	DC.L	0,200,200*14+110
	DC.L	0,200,200*14+130
	DC.L	1,300,200*14+110
	DC.L	1,300,200*14+130

	DC.L	0,220,200*15+110
	DC.L	0,220,200*15+130
	DC.L	1,320,200*15+110
	DC.L	1,320,200*15+130

	DC.L	0,190,200*16+110
	DC.L	0,190,200*16+130
	DC.L	1,290,200*16+110
	DC.L	1,290,200*16+130

	DC.L	0,180,200*17+110
	DC.L	0,180,200*17+130
	DC.L	1,280,200*17+110
	DC.L	1,280,200*17+130

	DC.L	0,170,200*18+110
	DC.L	0,170,200*18+130
	DC.L	1,270,200*18+110
	DC.L	1,270,200*18+130

	DC.L	0,190,200*19+110
	DC.L	0,190,200*19+130
	DC.L	1,290,200*19+110
	DC.L	1,290,200*19+130

	DC.L	0,160,200*20+110
	DC.L	0,160,200*20+130
	DC.L	1,260,200*20+110
	DC.L	1,260,200*20+130

	DC.L	0,150,200*21+110
	DC.L	0,150,200*21+130
	DC.L	1,250,200*21+110
	DC.L	1,250,200*21+130

	DC.L	0,170,200*22+110
	DC.L	0,170,200*22+130
	DC.L	1,270,200*22+110
	DC.L	1,270,200*22+130

	DC.L	0,150,200*23+110
	DC.L	0,150,200*23+130
	DC.L	1,250,200*23+110
	DC.L	1,250,200*23+130

	DC.L	0,140,200*24+110
	DC.L	0,140,200*24+130
	DC.L	1,240,200*24+110
	DC.L	1,240,200*24+130

	DC.L	0,120,200*25+110
	DC.L	0,120,200*25+130
	DC.L	1,220,200*25+110
	DC.L	1,220,200*25+130

	DC.L	0,100,200*26+110
	DC.L	0,100,200*26+130
	DC.L	1,200,200*26+110
	DC.L	1,200,200*26+130

	DC.L	0,110,200*27+110
	DC.L	0,110,200*27+130
	DC.L	1,210,200*27+110
	DC.L	1,210,200*27+130

	DC.L	0,120,200*28+110
	DC.L	0,120,200*28+130
	DC.L	1,220,200*28+110
	DC.L	1,220,200*28+130

	DC.L	0,130,200*29+110
	DC.L	0,130,200*29+130
	DC.L	1,230,200*29+110
	DC.L	1,230,200*29+130

	DC.L	0,140,200*30+110
	DC.L	0,140,200*30+130
	DC.L	1,240,200*30+110
	DC.L	1,240,200*30+130

	DC.L	0,150,200*31+110
	DC.L	0,150,200*31+130
	DC.L	1,250,200*31+110
	DC.L	1,250,200*31+130

	DC.L	0,170,200*32+110
	DC.L	0,170,200*32+130
	DC.L	1,270,200*32+110
	DC.L	1,270,200*32+130

	DC.L	0,200,200*33+110
	DC.L	0,200,200*33+130
	DC.L	1,300,200*33+110
	DC.L	1,300,200*33+130

	DC.L	0,230,200*34+110
	DC.L	0,230,200*34+130
	DC.L	1,330,200*34+110
	DC.L	1,330,200*34+130

	DC.L	0,260,200*35+110
	DC.L	0,260,200*35+130
	DC.L	1,360,200*35+110
	DC.L	1,360,200*35+130

	DC.L	0,280,200*36+110
	DC.L	0,280,200*36+130
	DC.L	1,380,200*36+110
	DC.L	1,380,200*36+130

	DC.L	0,300,200*37+110
	DC.L	0,300,200*37+130
	DC.L	1,400,200*37+110
	DC.L	1,400,200*37+130

	DC.L	0,310,200*38+110
	DC.L	0,310,200*38+130
	DC.L	1,410,200*38+110
	DC.L	1,410,200*38+130

	DC.L	0,320,200*39+110
	DC.L	0,320,200*39+130
	DC.L	1,420,200*39+110
	DC.L	1,420,200*39+130

	DC.L	0,300,200*40+110
	DC.L	0,300,200*40+130
	DC.L	1,400,200*40+110
	DC.L	1,400,200*40+130

	DC.L	0,320,200*41+110
	DC.L	0,320,200*41+130
	DC.L	1,420,200*41+110
	DC.L	1,420,200*41+130

	DC.L	0,300,200*42+110
	DC.L	0,300,200*42+130
	DC.L	1,400,200*42+110
	DC.L	1,400,200*42+130

	DC.L	0,320,200*43+110
	DC.L	0,320,200*43+130
	DC.L	1,420,200*43+110
	DC.L	1,420,200*43+130

	DC.L	0,300,200*44+110
	DC.L	0,300,200*44+130
	DC.L	1,400,200*44+110
	DC.L	1,400,200*44+130

	DC.L	0,300,200*45+110
	DC.L	0,300,200*45+130
	DC.L	1,400,200*45+110
	DC.L	1,400,200*45+130

	DC.L	0,320,200*46+110
	DC.L	0,320,200*46+130
	DC.L	1,420,200*46+110
	DC.L	1,420,200*46+130

	DC.L	0,340,200*47+110
	DC.L	0,340,200*47+130
	DC.L	1,440,200*47+110
	DC.L	1,440,200*47+130

	DC.L	0,350,200*48+110
	DC.L	0,350,200*48+130
	DC.L	1,450,200*48+110
	DC.L	1,450,200*48+130

	DC.L	0,350,200*49+110
	DC.L	0,350,200*49+130
	DC.L	1,450,200*49+110
	DC.L	1,450,200*49+130

	DS.L	100

CLEAR:	LEA	ANOTE(PC),A6
	CLR.L	6(A6)
	CLR.W	10(A6)
	MOVE.W	#1,18(A6)
	CLR.L	20(A6)
	RTS

ANOTE:	DC.W	0
BNOTE:	DC.W	0
CNOTE:	DC.W	0
A_INS:	DC.W	0
B_INS:	DC.W	0
C_INS:	DC.W	0
A_POS:	DC.W	0
B_POS:	DC.W	0
C_POS:	DC.W	0
TEMPOS:	DC.W	1
M_POS:	DC.L	0

SEND:	DC.L	$00000000
	DC.L	$01010000
	DC.L	$02020000
	DC.L	$03030000
	DC.L	$04040000
	DC.L	$05050000
	DC.L	$06060000
	DC.L	$07070000
ONE:	DC.L	$08080000
	DC.L	$09090000
	DC.L	$0A0A0000
	DC.L	$0B0B0000
	DC.L	$0C0C0000
	DC.L	$0D0D0A00

MADMAX:
	LEA	ANOTE(PC),A3
	LEA	SEND(PC),A4
	SUBQ.W	#1,18(A3)
	BNE	WAIT
	MOVE.W	#6,18(A3)
	LEA	DRUMS,A5
	LEA	SID+6600(PC),A6
	MOVE.L	20(A3),D5
	MOVE.L	D5,D6
	ADDQ.L	#1,20(A3)
	LSL.L	#3,D6
	CMP.B	#-1,(A6,D6.L)
	BNE	NOTYET
	MOVE.L	#1,20(A3)
	CLR.L	D5
	CLR.L	D6
NOTYET:	
	BSR	SAMPLE
	TST.W	0(A6,D6.L)
	BEQ	NOS1
	CLR.W	12(A3)
	MOVE.B	0(A6,D6.L),1(A3)
	MOVE.B	1(A6,D6.L),7(A3)
NOS1:	TST.W	2(A6,D6.L)
	BEQ	NOS2
	CLR.W	14(A3)
	MOVE.B	2(A6,D6.L),3(A3)
	MOVE.B	3(A6,D6.L),9(A3)
NOS2:	TST.W	4(A6,D6.L)
	BEQ	NOS3
	CLR.W	16(A3)
	MOVE.B	4(A6,D6.L),5(A3)
	MOVE.B	5(A6,D6.L),11(A3)
NOS3:	
	MOVE.B	6(A6,D6.L),26(A4)
	MOVE.B	7(A6,D6.L),46(A4)

WAIT:	BSR	DIGI
THREE:	MOVE.B	#$F8,30(A4)
	LEA	YAMAHA(PC),A5

	LEA	SID(PC),A6
	MOVE.W	6(A3),D6
	MULU	#200,D6
	ADDA.W	D6,A6
	MOVE.W	12(A3),D6
	LSL.W	#2,D6
	ADDA.W	D6,A6
	MOVE.W	(A3),D5
	ADD.B	1(A6),D5
	LSL.W	#1,D5
	MOVE.W	0(A5,D5.W),D5
	ADD.W	2(A6),D5
	MOVE.B	D5,2(A4)
	LSR.W	#8,D5
	MOVE.B	D5,6(A4)
	MOVE.B	0(A6),D5
	MOVE.B	D5,D6
	LSR.B	#4,D5
	AND.B	#3,D6
	MOVE.B	D5,34(A4)
	BTST	#0,D6
	BEQ	N1
	BCLR	#3,30(A4)
N1:	BTST	#1,D6
	BEQ	S1
	MOVE.B	#$10,34(A4)
S1:	TST.B	34(A4)
	BNE	V1
	CLR.B	2(A4)
	CLR.B	6(A4)
V1:	ADDQ.W	#1,12(A3)
	CMP.W	#50,12(A3)
	BNE	ST1
	CLR.W	6(A3)
	CLR.W	12(A3)
ST1:
	LEA	SID(PC),A6
	MOVE.W	8(A3),D6
	MULU	#200,D6
	ADDA.W	D6,A6
	MOVE.W	14(A3),D6
	LSL.W	#2,D6
	ADDA.W	D6,A6
	MOVE.W	2(A3),D5
	ADD.B	1(A6),D5
	LSL.W	#1,D5
	MOVE.W	0(A5,D5.W),D5
	ADD.W	2(A6),D5
	MOVE.B	D5,10(A4)
	LSR.W	#8,D5
	MOVE.B	D5,14(A4)
	MOVE.B	0(A6),D5
	MOVE.B	D5,D6
	LSR.B	#4,D5
	AND.B	#3,D6
	MOVE.B	D5,38(A4)
	BTST	#0,D6
	BEQ	N2
	BCLR	#4,30(A4)
N2:	BTST	#1,D6
	BEQ	S2
	MOVE.B	#$10,38(A4)
S2:	TST.B	38(A4)
	BNE	V2
	CLR.B	10(A4)
	CLR.B	14(A4)
V2:	ADDQ.W	#1,14(A3)
	CMP.W	#50,14(A3)
	BNE	ST2
	CLR.W	8(A3)
	CLR.W	14(A3)
ST2:	
	LEA	SID(PC),A6
	MOVE.W	10(A3),D6
	MULU	#200,D6
	ADDA.W	D6,A6
	MOVE.W	16(A3),D6
	LSL.W	#2,D6
	ADDA.W	D6,A6
	MOVE.W	4(A3),D5
	ADD.B	1(A6),D5
	LSL.W	#1,D5
	MOVE.W	0(A5,D5.W),D5
	ADD.W	2(A6),D5
	MOVE.B	D5,18(A4)
	LSR.W	#8,D5
	MOVE.B	D5,22(A4)
	MOVE.B	0(A6),D5
	MOVE.B	D5,D6
	LSR.B	#4,D5
	AND.B	#3,D6
	MOVE.B	D5,42(A4)
	BTST	#0,D6
	BEQ	N3
	BCLR	#5,30(A4)
N3:	BTST	#1,D6
	BEQ	S3
	MOVE.B	#$10,42(A4)
S3:	TST.B	42(A4)
	BNE	V3
	CLR.B	18(A4)
	CLR.B	22(A4)
V3:	ADDQ.W	#1,16(A3)
	CMP.W	#50,16(A3)
	BNE	ST3
	CLR.W	10(A3)
	CLR.W	16(A3)
ST3:	
	TST.B	46(A4)
	BEQ	NOWAVE
	MOVEM.L	44(A4),D4-D6
	MOVE.L	#SKIP,$110.W
	MOVEM.L	D4-D6,$FFFF8840.W
	CLR.B	46(A4)
NOWAVE:
	MOVEM.L	(A4),D1-D6/A2-A6
	MOVE.L	#SKIP,$110.W
	MOVEM.L	D1-D6/A2-A6,$FFFF8840.W
TWO:	MOVE.B	#$10,$FFFF8840.W
	MOVE.L	#DIGIDRUMS,$110.W
	RTS

YAMAHA:
	DC.B	14,240,14,22,13,78,12,140,11,220,11,45,10,140,9,250,9,102,8,230,8,100,7,232
	DC.B	7,120,7,9,6,163,6,62,5,240,5,148,5,74,4,248,4,180,4,111,4,50,3,243
	DC.B	3,187,3,134,3,84,3,53,2,246,2,203,2,163,2,125,2,90,2,56,2,24,1,250
	DC.B	1,221,1,195,1,169,1,145,1,123,1,101,1,81,1,62,1,45,1,28,1,12,0,253
	DC.B	0,238,0,225,0,212,0,200,0,189,0,179,0,168,0,159,0,150,0,142,0,134,0,126
	DC.B	0,119,0,112,0,106,0,100,0,94,0,89,0,84,0,79,0,75,0,71,0,67,0,63,0,59
	DS.B	22;0
	DS.B	24;0
	DS.B	24;0
	DS.B	24;0

SID:	INCBIN	\GAME.S\SLALOM._B_

DIGIDRUMS:
	MOVE.B	(A0)+,$FFFF8842.W
SKIP:	RTE

DIGI:	CMP.L	#LAST-250,A0
	BMI	OB
	MOVE.W	#$0808,ONE
	MOVE.B	#$10,TWO+3
	BCLR	#0,THREE+3
OB:	RTS

SAMPLE:	CMP.B	#1,0(A5,D5.L)
	BNE	SAM1
	LEA	BASS,A0
	MOVE.L	#SNARE-250,DIGI+2
	MOVE.W	#$1010,ONE
	MOVE.B	#$08,TWO+3
	BSET	#0,THREE+3
SAM1:	CMP.B	#2,0(A5,D5.L)
	BNE	SAM2
	LEA	SNARE,A0
	MOVE.L	#LAST-250,DIGI+2
	MOVE.W	#$1010,ONE
	MOVE.B	#$08,TWO+3
	BSET	#0,THREE+3
SAM2:	RTS

DRUMS:	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,2,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,2,2,0,2,2,0,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,2,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,2,2,2,1,2,2,2,2

	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,2,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,2,2,0,2,2,0,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,2,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,1,0,0,1,1,2,0,2,2
	DC.B	1,0,0,0,2,0,0,1,0,0,1,0,2,0,0,0
	DC.B	1,0,0,0,2,2,0,1,2,2,2,2,2,2,2,2

	DC.B	1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
	DC.B	1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
	DC.B	1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0
	DC.B	1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0

	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,2,0,2
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,2,2,0,2,2,0,2
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,2,2
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,0,2,0,0,0,1,2,2,0,2,0,2,2

	DC.B	1,0,0,2,0,0,1,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,2,0,0,1,0,1,0,0,1,2,0,2,2
	DC.B	1,0,0,2,0,1,1,0,1,0,0,1,2,0,0,0
	DC.B	1,0,0,2,0,1,0,1,2,1,2,1,2,2,2,2
	DC.B	1,0,0,2,0,0,1,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,2,0,0,1,0,1,0,0,1,2,0,2,2
	DC.B	1,0,0,2,0,1,1,0,1,0,0,1,2,0,0,0
	DC.B	1,0,0,2,0,1,0,1,2,1,2,1,2,2,2,2
	DC.B	1,0,0,2,0,0,1,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,2,0,0,1,0,1,0,0,1,2,0,2,2
	DC.B	1,0,0,2,0,1,1,0,1,0,0,1,2,0,0,0
	DC.B	1,0,0,2,0,1,0,1,2,1,2,1,2,2,2,2
	DC.B	1,0,0,2,0,0,1,0,1,0,0,0,2,0,0,0
	DC.B	1,0,0,2,0,0,1,0,1,0,0,1,2,0,2,2
	DC.B	1,0,0,2,0,1,1,0,1,0,0,1,2,0,0,0
	DC.B	1,0,0,2,0,1,0,1,2,2,2,2,2,2,2,2

BASS:	INCBIN	\GAME.S\BASSDRUM
SNARE:	INCBIN	\GAME.S\SNARE
LAST:

CONV:	LEA	BASS,A1
	LEA	LAST,A2
CO:	MOVEQ	#0,D1
	MOVE.B	(A1),D1
	LSL.W	#2,D1
	MOVE.B	TAB+1(PC,D1.W),D2
	MOVE.B	TAB+3(PC,D1.W),D1
	ADD.B	D2,D1
	LSR.B	#1,D1
	MOVE.B	D1,(A1)+
	CMP.L	A1,A2
	BNE	CO
	RTS

TAB:	INCBIN	\GAME.S\YAMAHA

HIDDEN_GAME:
	MOVEM.L	D0-D7/A1-A6,-(A7)

	TST.W	NEW+2
	BNE	NOPASS
	BSR	MOVE_IT
	CMP.B	#35,KEY
	BNE	NOPASS
	CLR.B	KEY
	NOT.B	NOPASS+3
	TST.B	NOPASS+3
	BNE	NOPASS
	MOVE.W	#23,A_Y
	MOVE.W	#23,B_Y
	MOVE.W	#32,C_X
	MOVE.W	#24,C_Y
SPR:	MOVE.W	#1,X_C
	MOVE.W	#-1,Y_C
	NOT.W	SPR+2
	ADDQ.W	#1,SPR+2
	CLR.L	WN1
	CLR.L	WN2
	BSR	NUMER4
	MOVE.B	#-1,NOPAUZA+3
NOPASS:	MOVE.B	#-1,D0
	BNE	HIDDEN

	LEA	L1,A1
	MOVE.L	ONE1,A2
PLACE:	LEA	2568(A2),A2
	LEA	160*15(A2),A3

	MOVEM.L	(A1)+,D1-D6/A5-A6
	MOVEM.L	D1-D6/A5-A6,160*00(A2)
	MOVEM.L	D1-D6/A5-A6,160*01(A2)
	MOVEM.L	D1-D6/A5-A6,160*13(A2)
	MOVEM.L	D1-D6/A5-A6,160*14(A2)
	MOVEM.L	D1-D6/A5-A6,160*62(A2)
	MOVEM.L	D1-D6/A5-A6,160*63(A2)
	MOVEM.L	(A1)+,D1-D6/A5-A6
	MOVEM.L	D1-D6/A5-A6,160*02(A2)
	MOVEM.L	D1-D6/A5-A6,160*03(A2)
	MOVEM.L	D1-D6/A5-A6,160*11(A2)
	MOVEM.L	D1-D6/A5-A6,160*12(A2)
	MOVEM.L	D1-D6/A5-A6,160*15(A2)
	MOVEM.L	D1-D6/A5-A6,160*16(A2)
	MOVEM.L	D1-D6/A5-A6,160*17(A2)
	MOVEM.L	D1-D6/A5-A6,160*18(A2)
	MOVEM.L	D1-D6/A5-A6,160*19(A2)
	MOVEM.L	D1-D6/A5-A6,160*20(A2)
	MOVEM.L	D1-D6/A5-A6,160*21(A2)
	MOVEM.L	D1-D6/A5-A6,160*22(A2)
	MOVEM.L	D1-D6/A5-A6,160*23(A2)
	MOVEM.L	D1-D6/A5-A6,160*24(A2)
	MOVEM.L	D1-D6/A5-A6,160*25(A2)
	MOVEM.L	D1-D6/A5-A6,160*26(A2)
	MOVEM.L	D1-D6/A5-A6,160*27(A2)
	MOVEM.L	D1-D6/A5-A6,160*28(A2)
	MOVEM.L	D1-D6/A5-A6,160*29(A2)
	MOVEM.L	D1-D6/A5-A6,160*30(A2)
	MOVEM.L	D1-D6/A5-A6,160*31(A2)
	MOVEM.L	D1-D6/A5-A6,160*32(A2)
	MOVEM.L	D1-D6/A5-A6,160*33(A2)
	MOVEM.L	D1-D6/A5-A6,160*34(A2)
	MOVEM.L	D1-D6/A5-A6,160*35(A2)
	MOVEM.L	D1-D6/A5-A6,160*36(A2)
	MOVEM.L	D1-D6/A5-A6,160*37(A2)
	MOVEM.L	D1-D6/A5-A6,160*38(A2)
	MOVEM.L	D1-D6/A5-A6,160*39(A2)
	MOVEM.L	D1-D6/A5-A6,160*40(A2)
	MOVEM.L	D1-D6/A5-A6,160*41(A2)
	MOVEM.L	D1-D6/A5-A6,160*42(A2)
	MOVEM.L	D1-D6/A5-A6,160*43(A2)
	MOVEM.L	D1-D6/A5-A6,160*44(A2)
	MOVEM.L	D1-D6/A5-A6,160*45(A2)
	MOVEM.L	D1-D6/A5-A6,160*46(A2)
	MOVEM.L	D1-D6/A5-A6,160*47(A2)
	MOVEM.L	D1-D6/A5-A6,160*48(A2)
	MOVEM.L	D1-D6/A5-A6,160*49(A2)
	MOVEM.L	D1-D6/A5-A6,160*50(A2)
	MOVEM.L	D1-D6/A5-A6,160*51(A2)
	MOVEM.L	D1-D6/A5-A6,160*52(A2)
	MOVEM.L	D1-D6/A5-A6,160*53(A2)
	MOVEM.L	D1-D6/A5-A6,160*54(A2)
	MOVEM.L	D1-D6/A5-A6,160*55(A2)
	MOVEM.L	D1-D6/A5-A6,160*56(A2)
	MOVEM.L	D1-D6/A5-A6,160*57(A2)
	MOVEM.L	D1-D6/A5-A6,160*58(A2)
	MOVEM.L	D1-D6/A5-A6,160*59(A2)
	MOVEM.L	D1-D6/A5-A6,160*60(A2)
	MOVEM.L	D1-D6/A5-A6,160*61(A2)

	LEA	160*4(A2),A2
	MOVEQ	#6,D3
AGA:	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	MOVE.L	(A1)+,(A2)+
	LEA	160-32(A2),A2
	DBF	D3,AGA

	LEA	(A3),A4
	LEA	24(A3),A5
	MOVE.W	A_Y,D1
	MULU	#160,D1
	ADD.L	D1,A4
	MOVE.W	B_Y,D2
	MULU	#160,D2
	ADD.L	D2,A5
	MOVE.L	#$C300C300,D3
	MOVE.L	D3,160(A4)
	MOVE.L	D3,160*2(A4)
	MOVE.L	D3,160*3(A4)
	MOVE.L	D3,160*4(A4)
	MOVE.L	D3,160*5(A4)
	MOVE.L	D3,160*6(A4)
	MOVE.L	D3,160*7(A4)
	MOVE.L	D3,160*8(A4)
	MOVE.L	D3,160*9(A4)
	MOVE.L	D3,160*10(A4)
	MOVE.L	D3,160*11(A4)
	MOVE.L	D3,160*12(A4)
	MOVE.L	D3,160*13(A4)
	MOVE.L	D3,164(A4)
	MOVE.L	D3,160*2+4(A4)
	MOVE.L	D3,160*3+4(A4)
	MOVE.L	D3,160*4+4(A4)
	MOVE.L	D3,160*5+4(A4)
	MOVE.L	D3,160*6+4(A4)
	MOVE.L	D3,160*7+4(A4)
	MOVE.L	D3,160*8+4(A4)
	MOVE.L	D3,160*9+4(A4)
	MOVE.L	D3,160*10+4(A4)
	MOVE.L	D3,160*11+4(A4)
	MOVE.L	D3,160*12+4(A4)
	MOVE.L	D3,160*13+4(A4)
	MOVE.L	#$00C300C3,D3
	MOVE.L	D3,160(A5)
	MOVE.L	D3,160*2(A5)
	MOVE.L	D3,160*3(A5)
	MOVE.L	D3,160*4(A5)
	MOVE.L	D3,160*5(A5)
	MOVE.L	D3,160*6(A5)
	MOVE.L	D3,160*7(A5)
	MOVE.L	D3,160*8(A5)
	MOVE.L	D3,160*9(A5)
	MOVE.L	D3,160*10(A5)
	MOVE.L	D3,160*11(A5)
	MOVE.L	D3,160*12(A5)
	MOVE.L	D3,160*13(A5)
	MOVE.L	D3,164(A5)
	MOVE.L	D3,160*2+4(A5)
	MOVE.L	D3,160*3+4(A5)
	MOVE.L	D3,160*4+4(A5)
	MOVE.L	D3,160*5+4(A5)
	MOVE.L	D3,160*6+4(A5)
	MOVE.L	D3,160*7+4(A5)
	MOVE.L	D3,160*8+4(A5)
	MOVE.L	D3,160*9+4(A5)
	MOVE.L	D3,160*10+4(A5)
	MOVE.L	D3,160*11+4(A5)
	MOVE.L	D3,160*12+4(A5)
	MOVE.L	D3,160*13+4(A5)

	MOVE.W	C_Y,D1
	MULU	#160,D1
	ADDA.W	D1,A3
	MOVE.W	C_X,D1
	MOVE.W	D1,D2
	LSR.W	#4,D1
	LSL.W	#3,D1
	ADDA.W	D1,A3
	AND.W	#$F,D2

	MOVE.L	#$C0000000,D0
	LSR.L	D2,D0
	MOVE.L	#$00010000,D4
	MOVE.L	#$20000000,D5
	LSR.L	D2,D4
	LSR.L	D2,D5

	MOVE.W	-160(A3),D1
	SWAP	D1
	MOVE.W	8-160(A3),D1
	AND.L	D0,D1
	BEQ	NOGA
	MOVE.W	#1,Y_C
NOGA:	MOVE.W	320(A3),D1
	SWAP	D1
	MOVE.W	320+8(A3),D1
	AND.L	D0,D1
	BEQ	NODA
	MOVE.W	#-1,Y_C
NODA:	MOVE.W	-8(A3),D1
	SWAP	D1
	MOVE.W	(A3),D1
	MOVE.W	160-8(A3),D2
	SWAP	D2
	MOVE.W	160(A3),D2
	OR.L	D2,D1
	AND.L	D4,D1
	BEQ	NOLA
	MOVE.W	#1,X_C
NOLA:	MOVE.W	(A3),D1
	SWAP	D1
	MOVE.W	8(A3),D1
	MOVE.W	160(A3),D2
	SWAP	D2
	MOVE.W	168(A3),D2
	OR.L	D2,D1
	AND.L	D5,D1
	BEQ	NORA
	MOVE.W	#-1,X_C
NORA:	
	OR.W	D0,8+0(A3)
	OR.W	D0,8+2(A3)
	OR.W	D0,8+4(A3)
	OR.W	D0,8+6(A3)
	OR.W	D0,8+160(A3)
	OR.W	D0,8+162(A3)
	OR.W	D0,8+164(A3)
	OR.W	D0,8+166(A3)
	SWAP	D0
	OR.W	D0,0(A3)
	OR.W	D0,2(A3)
	OR.W	D0,4(A3)
	OR.W	D0,6(A3)
	OR.W	D0,160(A3)
	OR.W	D0,162(A3)
	OR.W	D0,164(A3)
	OR.W	D0,166(A3)

	CMP.B	#25,KEY
	BNE	NOPAUZA
	CLR.B	KEY
	NOT.B	NOPAUZA+3
NOPAUZA:MOVE.B	#0,D0
	BNE	PAUZA

	CMP.W	#60,C_X
	BNE	AAA
	ADDQ.W	#1,WN1+2
	CMP.W	#10,WN1+2
	BNE	AA
	CLR.W	WN1+2
	ADDQ.W	#1,WN1
	CMP.W	#10,WN1
	BNE	AA
	CLR.W	WN1
AA:	BSR	NUMER4
AAA:	CMP.W	#2,C_X
	BNE	BBB
	ADDQ.W	#1,WN2+2
	CMP.W	#10,WN2+2
	BNE	BB
	CLR.W	WN2+2
	ADDQ.W	#1,WN2
	CMP.W	#10,WN2
	BNE	BB
	CLR.W	WN2
BB:	BSR	NUMER4
BBB:
	MOVE.W	X_C,D7
	ADD.W	D7,C_X
	MOVE.W	Y_C,D7
	ADD.W	D7,C_Y

A_G:	MOVE.B	#0,D0
	BEQ	A_D
	CMP.W	#3,A_Y
	BEQ	A_D
	SUBQ.W	#2,A_Y
A_D:	MOVE.B	#0,D0
	BEQ	B_G
	CMP.W	#29,A_Y
	BEQ	B_G
	ADDQ.W	#2,A_Y
B_G:	MOVE.B	#0,D0
	BEQ	B_D
	CMP.W	#3,B_Y
	BEQ	B_D
	SUBQ.W	#2,B_Y
B_D:	MOVE.B	#0,D0
	BEQ	C_C
	CMP.W	#29,B_Y
	BEQ	C_C
	ADDQ.W	#2,B_Y
C_C:
HIDDEN:
PAUZA:	MOVEM.L	(A7)+,D0-D7/A1-A6
	RTS

M_X:	DC.W	1
M_Y:	DC.W	2
MOVE_IT:
	MOVE.B	KEY,D7
	CMP.B	#72,D7
	BNE	NOK1
	TST.W	M_Y
	BEQ	NOK1
	SUBQ.W	#1,M_Y
NOK1:	CMP.B	#80,D7
	BNE	NOK2
	CMP.W	#16,M_Y
	BEQ	NOK2
	ADDQ.W	#1,M_Y
NOK2:	CMP.B	#75,D7
	BNE	NOK3
	TST.W	M_X
	BEQ	NOK3
	SUBQ.W	#1,M_X
NOK3:	CMP.B	#77,D7
	BNE	NOK4
	CMP.W	#16,M_X
	BEQ	NOK4
	ADDQ.W	#1,M_X
NOK4:	MOVE.W	M_Y,D1
	MULU	#1280,D1
	MOVE.W	M_X,D2
	LSL.W	#3,D2
	ADD.W	D2,D1
	MOVE.W	D1,PLACE+2
	RTS

A_Y:	DC.W	23
B_Y:	DC.W	23

C_X:	DC.W	32
C_Y:	DC.W	24

X_C:	DC.W	1
Y_C:	DC.W	-1

L1:	DC.L	-1,-1,-1,-1,-1,-1,-1,-1
	DC.L	$C000C000,$C000C000,0,0,0,0,$30003,$30003

L2:	DC.L	$C000C000,$C000C000,0,0,$00000000,$00000000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$C000C000,$C000C000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$C000C000,$C000C000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$00000000,$00000000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$C000C000,$C000C000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$C000C000,$C000C000,$30003,$30003
	DC.L	$C000C000,$C000C000,0,0,$00000000,$00000000,$30003,$30003

WN1:	DC.W	0,0
WN2:	DC.W	0,0
NUMER4:	LEA	CYFRY,A3

	LEA	L2+1,A2
	MOVE.W	WN1,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),32*0+0(A2)
	MOVE.B	1(A3,D2.W),32*1+0(A2)
	MOVE.B	2(A3,D2.W),32*2+0(A2)
	MOVE.B	3(A3,D2.W),32*3+0(A2)
	MOVE.B	4(A3,D2.W),32*4+0(A2)
	MOVE.B	5(A3,D2.W),32*5+0(A2)
	MOVE.B	6(A3,D2.W),32*6+0(A2)
	MOVE.B	0(A3,D2.W),32*0+2(A2)
	MOVE.B	1(A3,D2.W),32*1+2(A2)
	MOVE.B	2(A3,D2.W),32*2+2(A2)
	MOVE.B	3(A3,D2.W),32*3+2(A2)
	MOVE.B	4(A3,D2.W),32*4+2(A2)
	MOVE.B	5(A3,D2.W),32*5+2(A2)
	MOVE.B	6(A3,D2.W),32*6+2(A2)
	MOVE.B	0(A3,D2.W),32*0+4(A2)
	MOVE.B	1(A3,D2.W),32*1+4(A2)
	MOVE.B	2(A3,D2.W),32*2+4(A2)
	MOVE.B	3(A3,D2.W),32*3+4(A2)
	MOVE.B	4(A3,D2.W),32*4+4(A2)
	MOVE.B	5(A3,D2.W),32*5+4(A2)
	MOVE.B	6(A3,D2.W),32*6+4(A2)
	MOVE.B	0(A3,D2.W),32*0+6(A2)
	MOVE.B	1(A3,D2.W),32*1+6(A2)
	MOVE.B	2(A3,D2.W),32*2+6(A2)
	MOVE.B	3(A3,D2.W),32*3+6(A2)
	MOVE.B	4(A3,D2.W),32*4+6(A2)
	MOVE.B	5(A3,D2.W),32*5+6(A2)
	MOVE.B	6(A3,D2.W),32*6+6(A2)

	LEA	L2+8,A2
	MOVE.W	WN1+2,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),32*0+0(A2)
	MOVE.B	1(A3,D2.W),32*1+0(A2)
	MOVE.B	2(A3,D2.W),32*2+0(A2)
	MOVE.B	3(A3,D2.W),32*3+0(A2)
	MOVE.B	4(A3,D2.W),32*4+0(A2)
	MOVE.B	5(A3,D2.W),32*5+0(A2)
	MOVE.B	6(A3,D2.W),32*6+0(A2)
	MOVE.B	0(A3,D2.W),32*0+2(A2)
	MOVE.B	1(A3,D2.W),32*1+2(A2)
	MOVE.B	2(A3,D2.W),32*2+2(A2)
	MOVE.B	3(A3,D2.W),32*3+2(A2)
	MOVE.B	4(A3,D2.W),32*4+2(A2)
	MOVE.B	5(A3,D2.W),32*5+2(A2)
	MOVE.B	6(A3,D2.W),32*6+2(A2)
	MOVE.B	0(A3,D2.W),32*0+4(A2)
	MOVE.B	1(A3,D2.W),32*1+4(A2)
	MOVE.B	2(A3,D2.W),32*2+4(A2)
	MOVE.B	3(A3,D2.W),32*3+4(A2)
	MOVE.B	4(A3,D2.W),32*4+4(A2)
	MOVE.B	5(A3,D2.W),32*5+4(A2)
	MOVE.B	6(A3,D2.W),32*6+4(A2)
	MOVE.B	0(A3,D2.W),32*0+6(A2)
	MOVE.B	1(A3,D2.W),32*1+6(A2)
	MOVE.B	2(A3,D2.W),32*2+6(A2)
	MOVE.B	3(A3,D2.W),32*3+6(A2)
	MOVE.B	4(A3,D2.W),32*4+6(A2)
	MOVE.B	5(A3,D2.W),32*5+6(A2)
	MOVE.B	6(A3,D2.W),32*6+6(A2)

	LEA	L2+17,A2
	MOVE.W	WN2,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),32*0+0(A2)
	MOVE.B	1(A3,D2.W),32*1+0(A2)
	MOVE.B	2(A3,D2.W),32*2+0(A2)
	MOVE.B	3(A3,D2.W),32*3+0(A2)
	MOVE.B	4(A3,D2.W),32*4+0(A2)
	MOVE.B	5(A3,D2.W),32*5+0(A2)
	MOVE.B	6(A3,D2.W),32*6+0(A2)
	MOVE.B	0(A3,D2.W),32*0+2(A2)
	MOVE.B	1(A3,D2.W),32*1+2(A2)
	MOVE.B	2(A3,D2.W),32*2+2(A2)
	MOVE.B	3(A3,D2.W),32*3+2(A2)
	MOVE.B	4(A3,D2.W),32*4+2(A2)
	MOVE.B	5(A3,D2.W),32*5+2(A2)
	MOVE.B	6(A3,D2.W),32*6+2(A2)
	MOVE.B	0(A3,D2.W),32*0+4(A2)
	MOVE.B	1(A3,D2.W),32*1+4(A2)
	MOVE.B	2(A3,D2.W),32*2+4(A2)
	MOVE.B	3(A3,D2.W),32*3+4(A2)
	MOVE.B	4(A3,D2.W),32*4+4(A2)
	MOVE.B	5(A3,D2.W),32*5+4(A2)
	MOVE.B	6(A3,D2.W),32*6+4(A2)
	MOVE.B	0(A3,D2.W),32*0+6(A2)
	MOVE.B	1(A3,D2.W),32*1+6(A2)
	MOVE.B	2(A3,D2.W),32*2+6(A2)
	MOVE.B	3(A3,D2.W),32*3+6(A2)
	MOVE.B	4(A3,D2.W),32*4+6(A2)
	MOVE.B	5(A3,D2.W),32*5+6(A2)
	MOVE.B	6(A3,D2.W),32*6+6(A2)

	LEA	L2+24,A2
	MOVE.W	WN2+2,D2
	LSL.W	#3,D2
	MOVE.B	0(A3,D2.W),32*0+0(A2)
	MOVE.B	1(A3,D2.W),32*1+0(A2)
	MOVE.B	2(A3,D2.W),32*2+0(A2)
	MOVE.B	3(A3,D2.W),32*3+0(A2)
	MOVE.B	4(A3,D2.W),32*4+0(A2)
	MOVE.B	5(A3,D2.W),32*5+0(A2)
	MOVE.B	6(A3,D2.W),32*6+0(A2)
	MOVE.B	0(A3,D2.W),32*0+2(A2)
	MOVE.B	1(A3,D2.W),32*1+2(A2)
	MOVE.B	2(A3,D2.W),32*2+2(A2)
	MOVE.B	3(A3,D2.W),32*3+2(A2)
	MOVE.B	4(A3,D2.W),32*4+2(A2)
	MOVE.B	5(A3,D2.W),32*5+2(A2)
	MOVE.B	6(A3,D2.W),32*6+2(A2)
	MOVE.B	0(A3,D2.W),32*0+4(A2)
	MOVE.B	1(A3,D2.W),32*1+4(A2)
	MOVE.B	2(A3,D2.W),32*2+4(A2)
	MOVE.B	3(A3,D2.W),32*3+4(A2)
	MOVE.B	4(A3,D2.W),32*4+4(A2)
	MOVE.B	5(A3,D2.W),32*5+4(A2)
	MOVE.B	6(A3,D2.W),32*6+4(A2)
	MOVE.B	0(A3,D2.W),32*0+6(A2)
	MOVE.B	1(A3,D2.W),32*1+6(A2)
	MOVE.B	2(A3,D2.W),32*2+6(A2)
	MOVE.B	3(A3,D2.W),32*3+6(A2)
	MOVE.B	4(A3,D2.W),32*4+6(A2)
	MOVE.B	5(A3,D2.W),32*5+6(A2)
	MOVE.B	6(A3,D2.W),32*6+6(A2)
	RTS

DATA:
	DC.B	" HI THERE,ALL THE HACKERS! BEST REGARDS!               YOURS, AUTHOR. "
