; Projet de modularit de 'RMV Player'

; Ce fichier s'adresse aux programmeurs.

; Stabylo / The Removers
; 2 aot 1998 - 31 octobre 1998

**********************************************
* modules codecs
**********************************************

; Table des matires.
;--------------------
;	Introduction
;	Routine d'installation : 'init_module'.
;		Arguments, Action, Retours
;		Tableau d'entre
;		Tableau de retour
;	Cration de prcalculs
;	Libration de prcalculs
;	Routine dcodeuse
;	Routine de libration du module.

***************
* Introduction.
***************

; Afin d'intgrer plus facilement de nouveaux types de fichiers d'animation,
; Animator est modulaire. Nous dcrirons ici toutes les rgles de programmation
;  respecter pour construire soi-mme un module. Le but de cette
; description est vident : des personnes autres que l'auteur peuvent
; amliorer Animator en crivant des modules pour ce dernier.

; L'lment fondateur de la complication de ces rgles de programmation,
; c'est la gestion de la mmoire. En effet, chaque module a le droit
; d'allouer de la mmoire, par exemple pour faire des prcalculs, mais
; dans le cas o Animator doit faire appel  plusieurs modules, pour
; jouer une srie d'animations, n'est-il pas dommage de devoir toujours
; recalculer ce qui a dja t fait ?

; Par ailleurs, si on choisi de conserver ces prcalculs (comme le faisait
; AviPlayer) il serait dommage d'en venir  manquer de mmoire, alors qu'il
; est probable que certains d'entre eux ne sont plus en service et qu'il
; constituent un bloc de mmoire consquent.

; C'est pour rpondre  la fois  ces deux problmes qu'a t mise en
; place une micro bibliothque de fonctions mises  la disposition du
; programmeur de modules.

; Les modules doivent donc dclarer leurs prcalculs au noyau au moyen
; de routines transmises en paramtres lors de l'initialisation du module.
; De mme, l'allocation de mmoire se fera par le biais d'une fonction
; du noyau, afin de librer un prcalcul inutilis en cas de manque de
; mmoire. De surcrot, Animator se chargera de gnrer un message d'erreur
; si rien n'a pu tre fait pour allouer un bloc. En reprennant la main, le
; noyau cesse le parcours de l'animation en cours et effectue un retour au
; burean GEM, sauf si l'erreur n'tait pas fatale et que l'option
; 'NoFail' a t active dans la ligne de commande.

; Si une erreur survient lors de la dcompression d'une image ou d'un son,
; la routine 'erreur_survenue' permet de le signaler au noyau. Une telle
; erreur n'affecte aucunement le noyau dans la restitution de l'animation.

; Enfin, lorsqu'Animator a fini d'utiliser un module, il appelle une
; routine de ce dernier qui de charge de signaler que les prcalculs
; compterons un utilisateur de moins.

; En effet, il se peut qu' un instant donn, plusieurs modules cohabient
; en mmoire en utilisant les mmes prcalculs ! Cela se produit pour
; les fichiers AVI comportant plusieurs flux video. C'est pourquoi
; Animator compte le nombre d'utilisateurs d'un prcalcul donn plutt
; que de signaler si un prcalcul est utilis ou non.

; Bien entendu, afin d'viter que deux modules ne crent deux fois le
; mme prcalcul - celui de conversion YUV->RGB, par exemple -, il est
; associ un identifiant  chaque prcalcul. Cet identifiant comporte
; quatre caractres : c'est un mot long du type '_YUV' ou bien 'HCCV'
; (Hi Color ConVert) ou 'RSMP' (ReSaMPle).



*************************
* Routine d'installation : 'init_module'.
*************************

; Bien sr, elle initialise le module. Elle est situe au dbut de
; celui-ci de telle sorte que l'on puisse l'appeler en sautant  la
; premire instruction de la zone TEXT. Comme toutes les routines du
; module, elle se termine par l'instruction 'RTS'


; En gros.
;---------
; La routine d'initialistion
;	- prends connaissance de certaines variables cruciales pour le codec
;	- vrifie qu'elle est appele  bon escient.
;	- signale quels sont les prcalculs qu'elle utilise.
;	- cr des pralculs si besoin.
;	- retourne les adresses des routines principales du module.

; En dtail.
;-----------

; 'init_module' est appele par un saut (JSR) sur le dbut du module.
; Elle doit donc se situer AU DBUT de la zone TEXT du module.

; Arguments.
;-----------
; d0.l : contient la longueur en octets du tableau d'entre.
; a0.l : contient l'adresse d'un tableau d'entre dcrit plus loin.

; Rgles de programation.
;------------------------
; 'init_module' n'a le droit de modifier QUE les registres d0/a0
; ( pour transmettre les valeurs de retour ).
; En cas d'erreur, elle s'occuppe de dsallouer les blocs qu'elle
; a rserv le cas chant : la routine de libration du module
; n'est pas transmise, donc elle ne sera pas appele.

; La routine DOIT VRIFIER QUE LE TABLEAU EST ASSEZ GRAND pour comporter
; les variables dont elle a besoin ( voir le retour d'erreurs ci-dessous ).
; Ceci permettra d'allonger ce tableau plus tard sans pnaliser les codecs
; crits auparavant.

; Cette routine a la possibilit de crer des prcalculs ( voir mthode
; dtaille plus loin )  l'aide de ces variables. Les adresses des
; prcalculs crs peuvent tre gardes dans des variables internes au
; module pour tre utilis plus simplement, mais elles doivent
; systmatiquement tre rinitialise par 'init_module'.

****** Important ******
; Elle a l'obligation de copier toutes les valeurs qui peuvent lui tre
; utile par la suite, car le contenu du tableau de paramres est suceptible
; d'tre modifi sans pravis.

; Les valeurs ainsi copies bnficieront en outre d'un accs plus simple
; et plus rapide pour le module.


; retours
;--------
INIT_MOD_OK		equ	0
INIT_MOD_BAD_COMP	equ	-1
INIT_MOD_TOO_FEW_ARGS	equ	-2
INIT_MOD_UNWAITED_ERROR	equ	-3
; d0=0 : autorisation d'utiliser le module
; d0<>0 : utilisation du module interdite : erreur d'initialisation.
;	d0=-1 : compression non reconnue
; 	d0=-2 : pas assez de paramtres
;	d0=-3 : erreur inattendue ( valeurs incohrentes... )

; a0 : adresse du tabeau de retour ( dcrit plus loin )



; tableau d'entre.
;------------------
info_init_codec		rsstruct
chemin_application	rs.l	1
adr_recherche_precalc	rs.l	1	; \
adr_mem_alloc		rs.l	1	; |-> dtaills ci-dessous
adr_libere_precalc	rs.l	1	; |
adr_erreur_survenue	rs.l	1	; /
type			rs.b	4
sizeof			rs	0
RESET_SIZEOF		equ	6*4

; Voici des explication sur ces vriables gnrales :

; adr_recherche_precalc
; C'est l'adresse d'une routine qui recherche le prcalcul correspondant
;  l'identificateur pass en argument.
; Arguments.
;	d0 : identificateur FOURCC du prcalcul.
; Retour.
; Deux cas se prsentent pour le retour.
;	d0=0 : prcalcul inexistant
;		a0 : pointe sur un decripteur vide prt  tre rempli.
;		( structure dtaille plus loin)
;	d0>0 : prcalcul trouv
;		a0 : pointe sur le descripteur du prcalcul correspondant.
;	d0<0 : cration de prcalcul impossible (erreur fatale dja produite)



; adr_mem_alloc
; Routine d'allocation de mmoire.
; Arguments.
;	d0>0 : taille du bloc  rserver. Produit une erreur le cas chant.
;	d0<0 : ne pas utiliser cette possibilit.
;	d0=0 : voir remarques
;	d1.w : mode de Mxalloc
;		0=STramOnly, 1=TTramOnly, 2=PrefSTram, 3=PrefTTram.
; Retours.
;	d0=0  : plus de mmoire disponible.
;	d0<>0 : adresse du bloc allou.
; Elle est appele ainsi :
;	...
;	move.l	taille,d0
;	jsr	mem_alloc
;	tst.l	d0
;	beq	allocation_impossible
;	...
**** Remarques importantes. ****
; Si en argument d0=0, la taille du plus grand bloc disponible est retourne
; dans d0.
; Comme pour la routine du GEMDOS, les registres d0-d2, et a0-a2 peuvent tre
; modifis sans crier gare.



; adr_libere_precalc
; C'est l'adresse d'une routine qui recherche le prcalcul correspondant
;  l'identificateur pass en argument. S'il existe, elle le signale
; comme non utilis.
; Arguments.
;	d0 : identificateur FOURCC du prcalcul.
; But.
;	prvenir que le module n'utilise plus le prcalcul.
; Retours.
;	Aucun



; adr_erreur_survenue
; Cette routine signale au noyau qu'une erreur s'est produite lors de
; la dcompression d'une image. Cette routine ne fait que prendre
; note de l'erreur survenue ; elle ne constitue en aucun cas une manire
; d'interrompre la dcompression.
; Puisqu'une erreur sur une image n'est pas sense affecter le dcodage
; de la suivante, le noyau continuera  jouer l'animation tant que lui-mme
; ne rencontrera de difficult majeure.
; Arguments.
;	d0 : code d'erreur  signaler
; But.
; 	Signaler une erreur survenue, sans modifier l'excution en squence
;	du programme.
; Retours.
;	Aucun

	; si le type vaut 'vids' (flux vido)
compression		rs.b	4	; dtaill ci-dessous
bits_par_pixel		rs.w	1	; 2, 4, 8, 16, 24, 32 ...
largeur			rs.w	1	; dimensions du flux video
hauteur			rs.w	1
adr_ecran_centre	rs.l	1	; dtaill ci-dessous
x_ecran			rs.w	1	; dimensions de l'cran
y_ecran			rs.w	1
adr_palette		rs.l	1
video_sizeof		rs	0

; Voici des explication sur ces vriables spcifiques  la video :

; compression
; c'est le FOURCC (four character code) qui identifie la compression.
; Pour viter d'ventuelles erreurs de la part du noyau, 'init_module'
; DOIT VRIFIER qu'il s'agit bien d'une compression qu'elle reconnat.

; adr_ecran_centree
; C'est est l'adresse du pixel situ au coin suprieur gauche de
; l'animation, calcule de manire  obtenir un affichage centr.
; Dans le cas d'une dcompression de haut en bas, il s'agit l de
; l'adresse  partir de laquelle la dcompression se fait.


	; si le type vaut 'auds' (flux audio)
			rsset	info_init_codec.sizeof
format			rs.w	1	; 0=inconnu, 1=PCM, 2=ADPCM, ....
nb_voies		rs.b	1	; 1=mono, 2=stro
bits_par_sample		rs.b	1	; en gnral gal  4, 8 ou 16.
frequence		rs.l	1	; en gnral gal  11025, 22050 ou 44100 (voire 88200)
format_sortie		rs.w	1	; voir dtails ci-dessous
nb_voies_sortie		rs.b	1
bits_sortie		rs.b	1
frequence_sortie	rs.w	1
audio_sizeof		rs	0
			rsend


; Voici des explication sur ces vriables spcifiques  l'audio :

; Les variables 'format_sortie', 'nb_voies_sortie', 'bits_sortie' et
; 'frequence_sortie' dfinissent le format du son en entre.

; Les variables 'format_sortie', 'nb_voies_sortie', 'bits_sortie' et
; 'frequence_sortie' dfinissent le format du son en sortie.

; format_sortie
; La routine dcodeuse interprete le format PCM=1 8 bits en sortie comme
; sign ( format PCM sur Atari ) et en entre comme non sign ( format
; PCM sur PC ).

; La routine encodeuse interprte  l'inverse : le PCM 8 bit est sign en
; entre et non sign en sortie. Ceci permet la conversion au format PCM
; lors de la cration d'un fichier AVI.



; tableau de retour.
;-------------------

; L'adresse de ce tableau est retourne dans a0.
information_module	rsstruct
adr_decodeur		rs.l	1
adr_encodeur		rs.l	1
adr_libere_module	rs.l	1
sizeof			rs	0
			rsend

; Si l'une des deux premires routines est absente du module, alors
; l'adresse correspondante doit tre mise  zro ( NULL ).

; Si une erreur s'est produite lors de l'initialisation, on peut
; positionner 'adr_libere_module'  0 ( NULL ).



*************************
* Cration de prcalculs
*************************

; Cette cration se fait  l'aide des routines 'recherche_precalc' et
; 'mem_alloc'.

; Dans le cas o le prcalcul est dj prsent ( d0<>0 ), il est  la charge
; de 'init_module' d'incrmenter d'une unit le nombre d'utilisateurs de ce
; prcalcul pour signaler l'utilisation de ce dernier par le module.

; Dans le cas o le prcalcul n'est pas dj en mmoire ( d0=0 ), la routine
; d'initialisation doit remplir le descripteur vide point par a0.

descripteur_precalc	rsstruct
identificateur		rs.b	4
adresse_bloc		rs.l	1
nb_utilisateurs		rs.w	1
sizeof			rs	0
			rsend

; exemple de descripteur frachement cr.
;	dc.b	'_YUV'		; Conversion YUV->RGB
;	dc.l	$35df54		; adresse du prcalcul
;	dc.w	1		; un seul utilisateur

; Remarques importantes.
;-----------------------
; Un prcalcul est inutilis si 'nb_utilisateurs' vaut 0
; Un descripteur est dit VIDE si 'adresse_bloc' vaut 0 ( NULL ).
; Un descripteur dont l'identificateur est nul signale la fin de la liste.



**************************
* Libration de prcalculs
**************************

; IMPORTANT
; Les BLOCS allous pour les prcalculs ne sont jamais explicitement librs
; par le module.
; C'est le gestionnaire de mmoire s'en occupe selon les besoins auxquels il
; fait face.

; Le module signale qu'il cesse d'utiliser un prcalcul en appelant la
; routine 'libere_precalc' qui diminue d'une unit le nombre d'utilisateurs
; du prcalcul.

*************************
* Routine dcodeuse
*************************

; Codecs video.
;--------------
; Arguments
;	a0 : adresse du bloc  dcompresser.
;	d0 : longueur de ce bloc.

; Format video dcompress.
;	Le dcodeur crit  l'adresse indique lors de l'initialisation
;	l'image dcompresse au format ATARI True Color ( ou plutt HiColor ).
;	Les champs RVB occupent respectivement 5, 6, et 5 bits d'un mot au
;	format Motorola, et s'y succdent dans cet ordre.

; Retours.
;	Aucun
;	TOUS les registres peuvent tre modifis par la routine dcodeuse.



; Codecs audio.
;--------------
; Arguments
;	d0 : longueur du bloc source.
;	a0 : adresse du bloc source  dcompresser.
;	a1 : adresse du bloc destination o dcompresser le son.

; Format audio dcompress.
;	Le format de sortie est prcis  l'initialisation.
;	Le dcodeur crit  l'adresse indique en paramtre le bloc de
;	son dcompress et rchantionn  la frquence demande.

; Retours.
;	d0 : longueur du bloc destination
;	TOUS les registres peuvent tre modifis par la routine dcodeuse.



*************************
* Routine encodeuse
*************************

; Pas de spcifications. Ne pas se servir de cette possibilit.



**********************************
* Routine de libration du module.
**********************************

; Elle a pour rle essentiel de librer chaque prcalcul par un appel
;  la routine 'libere_precalc'.


; En gros.
;---------
;	- Elle signale que les prcalculs dont le module avait besoin
;	  ne sont plus utiliss.
;	- Elle libre la mmoire ventuellement alloue par le module.

; Rgles de programation.
;------------------------

; CHAQUE prcalcul utilis par le module DOIT tre l'objet d'un appel 
; 'libere_precalc'.

; Toute mmoire alloue en douce avec le GEMDOS doit tre libre.
; ( Nota : prfrez 'Mxalloc #3' au traditionnel Malloc pour les allouer )

; Seuls les registres d0/a0 peuvent tre modifis.




**********************************************
* modules de format de fichier
**********************************************

; Contient
;	une routine reconnaissant le type du fichier.
;	une routine jouant l'animation
;	une routine de libration









