*
*	THIS SOURCE CAN BE SPREAD TO ANYONE AS LONG AS IT IS NOT
*	CHANGED. IF YOU INCLUDE THE SOURCE OR ANY PART OF IT IN ANY
*	KIND OF PROGRAM AND THEN RELEASE THE SOURCE TO THAT PROGRAM
*	THEN MAKE SURE THAT A BIG AND VISUAL NOTE OF WHO MADE THE
*	ORIGINAL SCROLLINGCODE IS INCLUDED.
*	IF THIS SOURCE OR ANY PART OF IT IS USED IN ANY KIND OF
*	PROGRAM THE FOLLOWING SENTENCE MUST BE INCLUDED ON A PLACE
*	IN THE PROGRAM WHERE IT IS EASILY READ:
*	"HARDWARE/SYNC-SCROLLER BY THE ONE OF VECTOR/PHALANX"
*
*	HARDWARESCROLLER (ALSO KNOWN AS 'SYNCSCROLLER') FOR NORMAL
*	ST:S (AND STE:S).
*	WRITTEN BY DANIEL ERIKSSON (-THE ONE- OF VECTOR).
*	THIS  'GIVE AWAY v1.0'  WAS FINISHED 1990-10-25
*	SHOULD WORK FINE ON MOST ST:S, BUT SOME COMPUTERS HAS
*	BROKEN MMU:S WHICH CAUSES SLOWER ADDRESSING. THIS ROUT WILL
*	NOT WORK ON SUCH COMPUTERS.
*
*	IT TAKES 11 SCREENLINES, LEAVING YOU WITH 189 SCREENLINES WHEN THE
*	LOWER BORDER IS NORMAL AND (189+45) LINES WHEN THE LOWER BORDER
*	IS REMOVED.
*	189 LINES * 160 BYTES/LINE = 30240 BYTES  (NORMAL)
*	234 LINES * 160 BYTES/LINE = 37440 BYTES  (LOWER BORDER REMOVED)
*
*	IT TAKES AN AVERAGE TIME OF ABOUT 6 SCANLINES (1.9%).
*	6 SCANLINES * 512 CLOCKPERIODS/SCANLINE = 3072 CLOCKPERIODS
*
*	PHALANX RULES!!!
*
*	WRITTEN IN/FOR DEVPAC 2.09
*
*	IF ANY PROBLEMS OCCOUR THEN CONTACT ME AT THIS ADDRESS:
*		DANIEL ERIKSSON
*		GAARDSKAERSVAEGEN 6B	GRDSKRSVGEN 6B
*		S-81493 SKUTSKAER	S-81493 SKUTSKR
*	OR IF YOU WANT TO CALL ME (ASK FOR DANIEL IN SWEDISH OR ENGLISH):
*		(Nat.) 026-72901	(Internat.) + 46 26 72901
*

TIME_LINE	EQU 1	;[1-ON  0-OFF]  A LINE TO SHOW TIME LEFT EACH VBL.
LOWER_BORDER	EQU 0	;[1-ON  0-OFF]  REMOVES LOWER BORDER IF ON.

	BRA	STARTUP

****************
*** MAINLOOP ***
****************
MAIN:
	TST.B	VSYNC
	BEQ	MAIN			; WAIT FOR VBL-INTERRUPT
	SF.B	VSYNC
	CMP.B	#$39,$FFFFFC02.W	; SPACEBAR?
	BEQ	EXIT

*
* SET THE SCREEN-ADDRESS FOR THE NEXT VBL HERE.
* REMEMBER THAT THE ADDRESS MUST BE SET BEFORE
* THE LOWER-BORDER-ROUT (TIMERB3).
* THAT MEANS THAT THE FLEXIBLE SYNC IS SOMEWATT RESTRICTED.
* YOU CAN'T HAVE A SYNC THAT TAKES MORE THAN ABOUT 1.7 NORMAL SYNCS.
* THAT'S BECAUSE I INITIALIZE IT THERE.
* USE YOUR OWN ADDRESS INSTEAD OF '#SCREEN'.
*

	CMP.W	#1,EXAMPLEWAY
	BEQ	UP
	SUB.L	#160,EXAMPLECOUNTER
	CMP.L	#0,EXAMPLECOUNTER
	BNE	DOWN
	MOVE.W	#1,EXAMPLEWAY
	BRA	DOWN
UP:
	ADD.L	#160,EXAMPLECOUNTER
	CMP.L	#100*160,EXAMPLECOUNTER
	BNE	DOWN
	MOVE.W	#0,EXAMPLEWAY
DOWN:
	MOVE.L	EXAMPLECOUNTER,D0
	ADD.L	#EXAMPLESCREEN,D0
	MOVE.L	D0,TEMP_SCREEN


*
* THE ADDRESS THAT YOU HAVE SET WILL BE THE SCREENADDRESS THAT WILL
* BE SET DURING THE NEXT VBL.
* IT'S THE ADDRESS THAT YOU SHOULD WRITE YOUR GRAPHICS TO.
*

**********************************
*** PUT ALL NORMAL ROUTS HERE! ***
**********************************


* TIMING-LINE *
	IFNE	TIME_LINE
	MOVE.W	#$777,$FFFF8240.W
	DCB.W	124,$4E71
	MOVE.W	#$000,$FFFF8240.W
	ENDC

	BRA	MAIN



***************
*** STARTUP ***
***************
STARTUP:
*** CLEAR BSS-AREA ***
	MOVE.L	#BSS_START,A0
	MOVE.L	#BSS_END,A1
	MOVEQ	#0,D0
BSS_LOOP:
	REPT	16
	MOVE.L	D0,(A0)+
	ENDR
	CMP.L	A0,A1
	BGE	BSS_LOOP

*** SET SUPERVISOR MODE ***
	CLR.L	-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	LEA	6(SP),SP
	MOVE.L	D0,USP_SAVE

*** MOVE THE PICTURE TO THE SCREEN-AREA ***
	LEA	PICTURE+34,A0
	LEA	EXAMPLESCREEN+99*160,A1
	MOVE.W	#7999,D0
MLOOP:
	MOVE.L	(A0)+,(A1)+
	DBRA	D0,MLOOP
	MOVE.L	#100*160,EXAMPLECOUNTER

*** SAVE COLORS ***
	MOVEM.L	$FFFF8240.W,D0-D7
	MOVEM.L	D0-D7,OLD_PAL

*** SET COLORS TO BLACK DURING SETUP ***
	MOVEM.L	BLACK,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

*** CHECK IF IT'S A STE ***
	MOVE.W	#1,STE
	MOVE.B	$FFFF820D.W,D0
	SUB.B	#10,D0
	MOVE.B	D0,$FFFF820D.W
	CMP.B	$FFFF820D.W,D0
	BEQ	STE_CHECK
	CLR.W	STE
STE_CHECK:

*** SAVE AND SET THE SR ***
	MOVE.W	SR,SR_SAVE
	MOVE.W	#$2700,SR

*** SAVE SHIFTER-SETUP ***
	MOVE.B	$FFFF820A.W,OLD_HZ
	MOVE.B	$FFFF8260.W,OLD_RES
	MOVE.B	$FFFF8201.W,OLD_SCR
	MOVE.B	$FFFF8203.W,OLD_SCR+1
	MOVE.B	$FFFF820D.W,OLD_SCR+2

*** SAVE MFP SETTINGS AND VECTORS ***
	MOVE.B	$FFFFFA07.W,OLD_07
	MOVE.B	$FFFFFA09.W,OLD_09
	MOVE.B	$FFFFFA13.W,OLD_13
	MOVE.B	$FFFFFA15.W,OLD_15
	MOVE.B	$FFFFFA1B.W,OLD_1B
	MOVE.L	$70.W,OLD_VBL
	MOVE.L	$120.W,OLD_TB

*** SET MFP SETTINGS AND VECTORS ***
	CLR.B	$FFFFFA1B.W		; TIMER B CONTROL
	CLR.B	$FFFFFA09.W		; INTERRUPT ENABLE B
	MOVE.L	#TIMERB,$120.W		; TIMER B VECTOR
	MOVE.B	#1,$FFFFFA07.W		; INTERRUPT ENABLE A
	MOVE.B	#1,$FFFFFA13.W		; INTERRUPT MASK A
	CLR.B	$FFFFFA15.W		; INTERRUPT MASK B
	MOVE.B	#255,$FFFFFA21.W	; TIMER B DATA
	MOVE.B	#8,$FFFFFA1B.W		; TIMER B CONTROL
	MOVE.L	#VBL,$70.W		; VBL VECTOR
	MOVE.L	#BSS_START,TEMP_SCREEN
	MOVE.W	#$2300,SR
WAIT_FOR_SYNC
	TST.B	VSYNC
	BEQ	WAIT_FOR_SYNC
	MOVE.B	#0,$FFFF8260.W		; SET LOW RESOLUTION
	MOVE.B	#2,$FFFF820A.W		; SET 50 HZ
	BRA	MAIN

****************
*** VBL-ROUT ***
****************
VBL:
	MOVEM.L	D0-A6,-(SP)
	CLR.B	$FFFFFA1B.W
	MOVE.B	#1,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W

* SET ALL COLOURS TO BLACK DURING HARDWARE-SCROLLER *
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D4
	MOVEQ	#0,D5
	MOVEQ	#0,D6
	MOVEQ	#0,D7
	MOVEM.L	D0-D7,$FFFF8240.W

*
* HERE CAN YOU PUT A VBL-ROUT.
* DON'T PUT THE MAIN CODE HERE. IT'S BETTER TO PUT IT IN THE MAIN-LOOP.
* IF YOU PUT IT HERE YOU CAN'T USE THE FLEXIBLE SYNC
*

	MOVEM.L	(SP)+,D0-A6
	ST.B	VSYNC
	RTE

**********************************
*** TIMER B - HARDWARESCROLLER ***
**********************************
TIMERB:
	MOVE.W	#$2700,SR		; NO INTERRUPTS DURING BORDER-ROUTS
	MOVEM.L	D0-D1/A0-A2,-(SP)
	CLR.B	$FFFFFA1B.W
	MOVE.B	#9,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#TIMERB2,$120.W
	CMP.W	#1,STE
	BEQ	OFF_RET			; BRANCH IF STE DETECTED
	MOVE.B	$FFFFFA21.W,D0
LINEND	CMP.B	$FFFFFA21.W,D0
	BEQ	LINEND			; WAIT FOR END OF LINE
	MOVEQ	#11,D0
GRAPHST	DBRA	D0,GRAPHST		; WAIT FOR GRAPHIX (DUMMY)
SYNC	MOVE.B	$FFFF8209.W,D0
	BEQ	SYNC
	AND.B	#$3F,D0
	MOVEQ	#63,D1
	SUB.B	D0,D1
	LSR.W	D1,D0			; SYNCRONIZE
	MOVE.L	#$FF820A,A1
	MOVE.L	#$FF8260,A2
	MOVEQ	#0,D0
	MOVEQ	#2,D1
	DCB.W	33,$4E71
	MOVE.L	OFFSET,A0
	JMP	(A0)			; JUMP TO THE RIGHT BORDER-ROUT
OFF_RET	MOVEM.L	(SP)+,D0-D1/A0-A2
	BCLR	#0,$FFFFFA0F.W
	RTE

****************************
*** TIMER B - COLOR ROUT ***
****************************
TIMERB2:
	MOVE.W	#$2700,SR
	MOVEM.L	D0-D7,-(SP)
	CLR.B	$FFFFFA1B.W
	MOVE.B	#189,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#TIMERB3,$120.W
	MOVE.B	$FFFFFA21.W,D0
	MOVEM.L	PAL1+4,D1-D7
LINEND2	CMP.B	$FFFFFA21.W,D0
	BEQ	LINEND2			; WAIT FOR END OF LINE 11
	MOVE.L	PAL1,D0
	MOVEM.L	D0-D7,$FFFF8240.W	; SET ALL COLORS TO NORMAL
	MOVEM.L	(SP)+,D0-D7
	BCLR	#0,$FFFFFA0F.W
	RTE

********************************************************************
*** TIMER B - REMOVE LOWER BORDER AND CALCULATE HARDWARESCROLLER ***
********************************************************************
TIMERB3:
	MOVE.W	#$2700,SR
	MOVE.L	#TIMERB,$120.W
	CLR.B	$FFFFFA1B.W
	MOVE.B	#255,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVEM.L	D0/D7/A0,-(SP)
	MOVE.L	#$FFFFFA21,A0
	MOVE.B	(A0),D0
NO_TAB	CMP.B	(A0),D0
	BEQ	NO_TAB

	IFNE	LOWER_BORDER
	CLR.B	$FFFF820A.W		;60 HZ
	DCB.W	17,$4E71
	MOVE.B	#2,$FFFF820A.W		;50 HZ - LOWER BORDER GONE
	ENDC

* HARDWARESCROLLER CALCULATION *
	MOVE.L	TEMP_SCREEN,D7
	AND.B	#254,D7			; CLEAR LOWEST BIT
	CMP.W	#1,STE
	BNE	NO_STE			; BRANCH IF NORMAL ST DETECTED
	SUB.L	#11*160,D7
	MOVE.L	D7,TEMP
	MOVE.B	TEMP+1,$FFFF8201.W
	MOVE.B	TEMP+2,$FFFF8203.W
	MOVE.B	TEMP+3,$FFFF820D.W	; USE THE BUILT-IN HARDWARESCROLLER
	BRA	A_STE
NO_STE	MOVE.W	SR,TEMP_SR		; SAVE SR
	MOVE.W	#$2700,SR		; NO INTERRUPTS DURING CALCULATION
	MOVEQ	#0,D0
	SUB.L	#640,D7
	MOVE.B	D7,D0
	LEA	HARDTABLE,A0
	ADD.W	D0,D0
	ADD.W	D0,D0
	ADD.W	D0,A0
	MOVE.L	(A0)+,D0
	SUB.L	D0,D7
	MOVE.L	D7,TEMP
	MOVE.B	TEMP+1,$FFFF8201.W
	MOVE.B	TEMP+2,$FFFF8203.W
	MOVE.L	(A0),OFFSET
	MOVE.W	TEMP_SR,SR		; RESET SR
A_STE:
	MOVEM.L	(SP)+,D0/D7/A0

	BCLR	#0,$FFFFFA0F.W
	RTE

*****************
*** SUB-ROUTS ***
*****************
O96:
	BRA	OFF_RET

O94:
	BSR	L158
	BRA	OFF_RET

O120:
	BSR	L184
	BRA	OFF_RET

O122:
	BSR	L186
	BRA	OFF_RET

O140:
	BSR	L204
	BRA	OFF_RET

O166:
	BSR	L230
	BRA	OFF_RET

O92:
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O118:
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O138:
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O164:
	BSR	L230
	BSR	L158
	BRA	OFF_RET

O144:
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O146:
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O190:
	BSR	L230
	BSR	L184
	BRA	OFF_RET

O148:
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O192:
	BSR	L230
	BSR	L186
	BRA	OFF_RET

O184:
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O210:
	BSR	L230
	BSR	L204
	BRA	OFF_RET

O236:
	BSR	L230
	BSR	L230
	BRA	OFF_RET

O90:
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O116:
	BSR	L184
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O136:
		BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O162:
	BSR	L230
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O142:
	BSR	L184
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O188:
	BSR	L230
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O182:
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O208:
	BSR	L230
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O234:
	BSR	L230
	BSR	L230
	BSR	L158
	BRA	OFF_RET

O168:
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O170:
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O214:
	BSR	L230
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O172:
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O216:
	BSR	L230
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O4:
	BSR	L230
	BSR	L230
	BSR	L184
	BRA	OFF_RET

O174:
	BSR	L186
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O218:
	BSR	L230
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O6:
	BSR	L230
	BSR	L230
	BSR	L186
	BRA	OFF_RET

O228:
	BSR	L204
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O254:
	BSR	L230
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O24:
	BSR	L230
	BSR	L230
	BSR	L204
	BRA	OFF_RET

O50:
	BSR	L230
	BSR	L230
	BSR	L230
	BRA	OFF_RET

O88:
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O114:
	BSR	L184
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O134:
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O160:
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O186:
	BSR	L230
	BSR	L184
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O180:
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O206:
	BSR	L230
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O232:
	BSR	L230
	BSR	L230
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O212:
	BSR	L230
	BSR	L184
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O2:
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O226:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O252:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O22:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O48:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L158
	BRA	OFF_RET

O194:
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O238:
	BSR	L230
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O196:
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O240:
	BSR	L230
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O28:
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O198:
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O242:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O30:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O74:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L184
	BRA	OFF_RET

O200:
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O244:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O32:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O76:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BRA	OFF_RET

O16:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O42:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O68:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O86:
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O112:
	BSR	L184
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O132:
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O158:
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O178:
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O204:
	BSR	L230
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O230:
	BSR	L230
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O0:
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O224:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O250:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O20:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O46:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O26:
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O72:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L158
	BRA	OFF_RET

O14:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O40:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O66:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BRA	OFF_RET

O220:
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O8:
	BSR	L230
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O52:
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O222:
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O10:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O54:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O98:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O12:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O56:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O100:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O58:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O102:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O60:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O84:
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O110:
	BSR	L184
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O130:
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O156:
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O176:
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O202:
	BSR	L230
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O248:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O18:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O44:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O70:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L184
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O38:
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O64:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O246:
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O34:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O78:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L184
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O36:
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O80:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O124:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O82:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O126:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET

O128:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BRA	OFF_RET

O104:
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BSR	L204
	BRA	OFF_RET

O108:
	BSR	L184
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O154:
	BSR	L230
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O62:
	BSR	L230
	BSR	L230
	BSR	L204
	BSR	L204
	BSR	L158
	BSR	L158
	BSR	L158
	BRA	OFF_RET

O106:
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O150:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L184
	BSR	L184
	BRA	OFF_RET

O152:
	BSR	L230
	BSR	L230
	BSR	L230
	BSR	L186
	BSR	L186
	BSR	L186
	BSR	L184
	BRA	OFF_RET


L158	DCB.W	109,$4E71
	MOVE.B	D0,(A1)
	MOVE.B	D1,(A1)
	DCB.W	6,$4E71
	RTS

L184	MOVE.B	D1,(A2)
	NOP
	MOVE.B	D0,(A2)
	DCB.W	13,$4E71
	MOVE.B	D1,(A2)
	MOVE.B	D0,(A2)
	DCB.W	87,$4E71
	MOVE.B	D0,(A1)
	MOVE.B	D1,(A1)
	DCB.W	6,$4E71
	RTS

L186	NOP
	MOVE.B	D1,(A2)
	NOP
	MOVE.B	D0,(A2)
	DCB.W	12,$4E71
	MOVE.B	D1,(A2)
	MOVE.B	D0,(A2)
	DCB.W	97,$4E71
	RTS

L204	DCB.W	111,$4E71
	MOVE.B	D0,(A1)
	MOVE.B	D1,(A1)
	DCB.W	4,$4E71
	RTS

L230	NOP
	MOVE.B	D1,(A2)
	NOP
	MOVE.B	D0,(A2)
	DCB.W	12,$4E71
	MOVE.B	D1,(A2)
	MOVE.B	D0,(A2)
	DCB.W	89,$4E71
	MOVE.B	D0,(A1)
	MOVE.B	D1,(A1)
	DCB.W	4,$4E71
	RTS

*****************
*** TERMINATE ***
*****************
EXIT:
	MOVE.B	#0,$FFFFFA07.W
	MOVE.B	#0,$FFFFFA09.W
	TST.B	VSYNC
	BEQ	EXIT
	MOVE.W	#$2700,SR
	MOVE.B	OLD_RES,$FFFF8260.W
	MOVE.B	OLD_HZ,$FFFF820A.W
	MOVE.L	OLD_VBL,$70.W
	MOVE.B	OLD_1B,$FFFFFA1B.W
	MOVE.B	OLD_09,$FFFFFA09.W
	MOVE.L	OLD_TB,$120.W
	MOVE.B	OLD_07,$FFFFFA07.W
	MOVE.B	OLD_13,$FFFFFA13.W
	MOVE.B	OLD_15,$FFFFFA15.W
	MOVE.B	OLD_SCR+0,$FFFF8201.W
	MOVE.B	OLD_SCR+1,$FFFF8203.W
	MOVE.B	OLD_SCR+2,$FFFF820D.W
	MOVE.W	SR_SAVE,SR
	MOVEM.L	OLD_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVE.B	#7,$FFFF8800.W
	MOVE.B	#255,$FFFF8802.W
FLUSH	BTST.B	#0,$FFFFFC00.W		;FLUSH KEYBOARD
	BEQ	KEYB_OK
	MOVE.B	$FFFFFC02.W,D0
	BRA	FLUSH
KEYB_OK	MOVE.L	USP_SAVE,-(SP)
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	CLR.W	-(SP)
	MOVE.W	#$4C,-(SP)
	TRAP	#1

*****************
*** DATA-AREA ***
*****************
	SECTION	DATA
PAL1	DC.W	$000,$777,$745,$333,$444,$555,$666,$777
	DC.W	$000,$111,$222,$333,$444,$555,$666,$333

PICTURE	INCBIN	"HARDWARE.PI1"

OFFSET		DC.L	O0

HARDTABLE:
	DC.L	1280,O0,1280,O2,1280,O4,1280,O6,1280,O8,1280,O10,1280,O12,1280,O14
	DC.L	1280,O16,1280,O18,1280,O20,1280,O22,1280,O24,1280,O26,1280,O28,1280,O30
	DC.L	1280,O32,1280,O34,1280,O36,1280,O38,1280,O40,1280,O42,1280,O44,1280,O46
	DC.L	1280,O48,1280,O50,1280,O52,1280,O54,1280,O56,1280,O58,1280,O60,1280,O62
	DC.L	1280,O64,1280,O66,1280,O68,1280,O70,1280,O72,1280,O74,1280,O76,1280,O78
	DC.L	1280,O80,1280,O82,1024,O84,1024,O86,1024,O88,1024,O90,1024,O92,1024,O94
	DC.L	1024,O96,1280,O98,1280,O100,1280,O102,1280,O104,1280,O106,1024,O108,1024,O110
	DC.L	1024,O112,1024,O114,1024,O116,1024,O118,1024,O120,1024,O122,1280,O124,1280,O126
	DC.L	1280,O128,1024,O130,1024,O132,1024,O134,1024,O136,1024,O138,1024,O140,1024,O142
	DC.L	1024,O144,1024,O146,1024,O148,1280,O150,1280,O152,1024,O154,1024,O156,1024,O158
	DC.L	1024,O160,1024,O162,1024,O164,1024,O166,1024,O168,1024,O170,1024,O172,1024,O174
	DC.L	1024,O176,1024,O178,1024,O180,1024,O182,1024,O184,1024,O186,1024,O188,1024,O190
	DC.L	1024,O192,1024,O194,1024,O196,1024,O198,1024,O200,1024,O202,1024,O204,1024,O206
	DC.L	1024,O208,1024,O210,1024,O212,1024,O214,1024,O216,1024,O218,1024,O220,1024,O222
	DC.L	1024,O224,1024,O226,1024,O228,1024,O230,1024,O232,1024,O234,1024,O236,1024,O238
	DC.L	1024,O240,1024,O242,1024,O244,1024,O246,1024,O248,1024,O250,1024,O252,1024,O254

****************
*** BSS-AREA ***
****************
BSS_START:
	SECTION	BSS
	EVEN
OLD_VBL		DS.L	1
OLD_TB		DS.L	1
OLD_SCR		DS.L	1
USP_SAVE	DS.L	1
OLD_RES		DS.W	1
OLD_HZ		DS.W	1
SR_SAVE		DS.W	1
OLD_07		DS.B	1
OLD_09		DS.B	1
OLD_13		DS.B	1
OLD_15		DS.B	1
OLD_1B		DS.B	1
TEMP_SR		DS.W	1
OLD_PAL		DS.W	16
BLACK		DS.W	16

EXAMPLEWAY	DS.W	1
EXAMPLECOUNTER	DS.L	1
EXAMPLESCREEN	DS.B	2*189*160

	IFNE	LOWER_BORDER
SCREEN		DS.B	(189+45)*160
	ENDC
	IFEQ	LOWER_BORDER
SCREEN		DS.B	189*160
	ENDC
SCR_AD		DS.L	1
TEMP_SCREEN	DS.L	1
TEMP		DS.L	1
STE		DS.W	1
VSYNC		DS.W	1

BSS_END		DS.L	17

	END
