;; mp2.asm
;;
;; COPYRIGHT (c) 1996, 1997 & 1998 by Fredrik Noring
;;
;; DSP56001 MPEG audio layer 2 decoder.

	include	"equates.asm"

HEADER_ID		equ	19
HEADER_LAYER		equ	17
HEADER_PROTECTION	equ	16
HEADER_BITRATE	equ	12
HEADER_FREQUENCY	equ	10
HEADER_PADDING	equ	9
HEADER_PRIVATE	equ	8
HEADER_MODE		equ	6
HEADER_EXTMODE	equ	4
HEADER_COPYRIGHT	equ	3
HEADER_ORIGINAL	equ	2
HEADER_EMPHASIS	equ	0

MODE_STEREO		equ	0
MODE_JOINT		equ	1
MODE_DUAL		equ	2
MODE_MONO		equ	3

REPLAY_BUFFER_SIZE	equ	2304

	org X:$0000	;; Internal RAM (lower half).
frame_header		ds	1
frame_size		ds	1
frame_payload_size	ds	1
frame_channels	ds	1
frame_frequency	ds	1
frame_bitrate		ds	1
frame_sblimit		ds	1
frame_jsbound		ds	1

stream_available 	ds	1

getbits_cntlp		ds	1
getbits_framep	ds	1

replay_logic		ds	1
replay_physic		ds	1
replay_frequency_conversion	ds	1
replay_dsp_load	ds	1
replay_average_dsp_load	ds	1

decoder_scfsis	ds	1
decoder_sfp		ds	1
decoder_quantizations	ds	1
decoder_nbals		ds	1
decoder_scalefactor_granule	ds	1
decoder_joint_countdown	ds	1

decoder_audiop	dc	decoder_audio
decoder_audio_mask	ds	1
decoder_audio_delta	ds	1

decoder_pcmp		ds	1

decoder_imfct_fractionp	ds	1
decoder_imfct_delta	ds	1

	org X:$0200	;; External RAM.
decoder_bitalloc	ds	2*32
decoder_scfsi		ds	2*32
decoder_scalefactor	ds	2*32*3
decoder_fraction	ds	2*32*3
decoder_old_samples	ds	3

	org X:$1000	;; External RAM.
decoder_audio		ds	2048
frame		ds	1024

	org X:$2000	;; External RAM.
replay_buffer		ds	2*2534
decoder_pcm		ds	2304

	org Y:$0000	;; Internal RAM (lower half).

	org L:$0040	;; Internal RAM.
;;;	org L:$00c0	;; Internal RAM (upper half).
decoder_imfct		dsm	64

	org L:$0f00	;; External RAM.

DMA_r_save_A		ds	1
DMA_r_save_B		ds	1
DMA_r_save_x1		ds	1
DMA_r_save_y		ds	1
DMA_r_save_r0		ds	1
DMA_r_save_n0		ds	1
DMA_r_has_byte	dc	0
DMA_r_stored_byte	dc	0
DMA_r_state		dc	$c00000

	org Y:$0080
table_window		dc	$000000,$fff8c1,$003540,$ff8d41,$01fd40,$faf7c1,$066b80,$db63c1
		dc	$494780,$249c40,$066b80,$050840,$01fd40,$0072c0,$003540,$000740
		dc	$ffffc1,$fff841,$003680,$ff7e41,$01f400,$fa9cc1,$05d1c0,$d99601
		dc	$493c00,$22ce00,$06f780,$04ad00,$0203c0,$006440,$003400,$000680
		dc	$ffffc1,$fff741,$003780,$ff6ec1,$01e800,$fa4241,$052a00,$d7ca01
		dc	$491a00,$20ffc0,$077600,$045240,$020800,$0056c0,$003280,$000600
		dc	$ffffc1,$fff681,$003840,$ff5ec1,$01d940,$f9e8c1,$047440,$d60081
		dc	$48e180,$1f32c0,$07e700,$03f7c0,$0209c0,$004980,$003100,$000540
		dc	$ffffc1,$fff5c1,$0038c0,$ff4e41,$01c780,$f990c1,$03b000,$d43ac1
		dc	$489240,$1d6800,$084b00,$039e40,$020940,$003d00,$002f80,$0004c0
		dc	$ffffc1,$fff4c1,$003900,$ff3d41,$01b2c0,$f93a41,$02ddc0,$d279c1
		dc	$482d00,$1ba040,$08a200,$0345c0,$0206c0,$003140,$002dc0,$000440
		dc	$ffffc1,$fff3c1,$003900,$ff2c01,$019b00,$f8e641,$01fd40,$d0be81
		dc	$47b1c0,$19dc80,$08ecc0,$02ef00,$020240,$002640,$002c00,$000400
		dc	$ffff81,$fff2c1,$0038c0,$ff1a41,$017fc0,$f894c1,$010e80,$cf09c1
		dc	$4720c0,$181d80,$092b40,$0299c0,$01fc00,$001bc0,$002a40,$000380
		dc	$ffff81,$fff181,$003800,$ff0841,$016180,$f84681,$001180,$cd5cc1
		dc	$467a40,$166440,$095e00,$024680,$01f440,$001200,$002840,$000340
		dc	$ffff81,$fff041,$003740,$fef601,$014000,$f7fbc1,$ff0681,$cbb881
		dc	$45bf00,$14b140,$098580,$01f580,$01ea80,$000900,$002680,$0002c0
		dc	$ffff81,$ffef01,$0035c0,$fee3c1,$011ac0,$f7b541,$fded81,$ca1d81
		dc	$44ef80,$130580,$09a1c0,$01a700,$01dfc0,$000080,$0024c0,$000280
		dc	$ffff41,$ffedc1,$003400,$fed181,$00f280,$f77341,$fcc701,$c88d81
		dc	$440bc0,$1161c0,$09b3c0,$015b00,$01d380,$fff8c1,$0022c0,$000240
		dc	$ffff41,$ffec41,$003200,$febf41,$00c680,$f73681,$fb92c1,$c708c1
		dc	$431500,$0fc6c0,$09bb80,$0111c0,$01c640,$fff1c1,$002100,$000200
		dc	$ffff01,$ffeac1,$002f40,$fead01,$009740,$f6ff41,$fa5181,$c59081
		dc	$420b40,$0e3500,$09b9c0,$00cb80,$01b7c0,$ffeb41,$001f40,$0001c0
		dc	$ffff01,$ffe941,$002c40,$fe9b01,$006480,$f6ce01,$f90381,$c425c1
		dc	$40ef80,$0cad00,$09af00,$008840,$01a880,$ffe581,$001d40,$0001c0
		dc	$fffec1,$ffe7c1,$0028c0,$fe8981,$002e40,$f6a3c1,$f7a901,$c2c901
		dc	$3fc280,$0b2fc0,$099b80,$004800,$019880,$ffe041,$001bc0,$000180
		dc	$fffec1,$ffe601,$002480,$fe7841,$fff4c1,$f68041,$f64241,$c17b41
		dc	$3e84c0,$09bdc0,$097fc0,$000b40,$0187c0,$ffdb81,$001a00,$000140
		dc	$fffe81,$ffe441,$001fc0,$fe6781,$ffb801,$f66481,$f4d041,$c03d81
		dc	$3d3700,$085700,$095c40,$ffd1c1,$017680,$ffd741,$001840,$000140
		dc	$fffe41,$ffe2c1,$001a80,$fe5781,$ff77c1,$f65101,$f35301,$bf1081
		dc	$3bda40,$06fc80,$093200,$ff9b81,$016500,$ffd3c1,$0016c0,$000100
		dc	$fffe41,$ffe0c1,$0014c0,$fe4841,$ff3481,$f64641,$f1cb01,$bdf4c1
		dc	$3a6f80,$05ae80,$0900c0,$ff68c1,$015300,$ffd0c1,$001540,$000100
		dc	$fffe01,$ffdf01,$000e40,$fe39c1,$feee41,$f64481,$f03941,$bceb01
		dc	$38f740,$046d40,$08c980,$ff3981,$0140c0,$ffce01,$0013c0,$0000c0
		dc	$fffdc1,$ffdd41,$000740,$fe2c81,$fea501,$f64c41,$ee9e41,$bbf441
		dc	$377280,$033900,$088cc0,$ff0d81,$012e80,$ffcc01,$001240,$0000c0
		dc	$fffd81,$ffdb41,$ffff81,$fe2041,$fe5901,$f65e41,$ecfa81,$bb1081
		dc	$35e280,$021280,$084ac0,$fee541,$011c40,$ffca41,$001100,$000080
		dc	$fffd41,$ffd981,$fff701,$fe1581,$fe0a81,$f67a81,$eb4ec1,$ba4101
		dc	$344780,$00f980,$080440,$fec001,$010a00,$ffc8c1,$000fc0,$000080
		dc	$fffcc1,$ffd7c1,$ffee01,$fe0bc1,$fdb981,$f6a201,$e99bc1,$b985c1
		dc	$32a340,$ffee81,$07b980,$fe9e81,$00f7c0,$ffc801,$000e80,$000080
		dc	$fffc81,$ffd5c1,$ffe441,$fe0401,$fd6641,$f6d4c1,$e7e281,$b8df41
		dc	$30f640,$fef181,$076b40,$fe8041,$00e5c0,$ffc741,$000d40,$000080
		dc	$fffc01,$ffd401,$ffd9c1,$fdfdc1,$fd1101,$f71341,$e62381,$b84e41
		dc	$2f4180,$fe02c1,$0719c0,$fe6501,$00d400,$ffc701,$000c40,$000040
		dc	$fffbc1,$ffd241,$ffcec1,$fdf941,$fcba41,$f75e01,$e45fc1,$b7d301
		dc	$2d8640,$fd2241,$06c5c0,$fe4d41,$00c2c0,$ffc701,$000b40,$000040
		dc	$fffb41,$ffd081,$ffc301,$fdf6c1,$fc61c1,$f7b501,$e29801,$b76dc1
		dc	$2bc540,$fc5001,$066f40,$fe3881,$00b1c0,$ffc741,$000a40,$000040
		dc	$fffac1,$ffcf01,$ffb681,$fdf641,$fc0841,$f81901,$e0cd41,$b71e81
		dc	$29ff80,$fb8bc1,$061740,$fe26c1,$00a140,$ffc7c1,$000980,$000040
		dc	$fffa01,$ffcd81,$ffa941,$fdf801,$fbadc1,$f88a01,$df0041,$b6e601
		dc	$283600,$fad601,$05bdc0,$fe1801,$009140,$ffc881,$0008c0,$000040
		dc	$fff981,$ffcc01,$ff9bc1,$fdfc41,$fb5301,$f90881,$dd3201,$b6c401
		dc	$266a00,$fa2e41,$056340,$fe0c01,$0081c0,$ffc981,$0007c0,$000040

	org Y:$1000	;; External RAM.
table_sinx		dc	0.000000,0.049068,0.098017,0.146730
		dc	0.195090,0.242980,0.290285,0.336890
		dc	0.382683,0.427555,0.471397,0.514103
		dc	0.555570,0.595699,0.634393,0.671559
		dc	0.707107,0.740951,0.773010,0.803208
		dc	0.831470,0.857729,0.881921,0.903989
		dc	0.923880,0.941544,0.956940,0.970031
		dc	0.980785,0.989177,0.995185,0.998795
		dc	0.999999,0.998795,0.995185,0.989177
		dc	0.980785,0.970031,0.956940,0.941544
		dc	0.923880,0.903989,0.881921,0.857729
		dc	0.831470,0.803208,0.773010,0.740951
		dc	0.707107,0.671559,0.634393,0.595699
		dc	0.555570,0.514103,0.471397,0.427555
		dc	0.382683,0.336890,0.290285,0.242980
		dc	0.195090,0.146730,0.098017,0.049068

table_cosx		dc	0.999999,0.998795,0.995185,0.989177
		dc	0.980785,0.970031,0.956940,0.941544
		dc	0.923880,0.903989,0.881921,0.857729
		dc	0.831470,0.803208,0.773010,0.740951
		dc	0.707107,0.671559,0.634393,0.595699
		dc	0.555570,0.514103,0.471397,0.427555
		dc	0.382683,0.336890,0.290285,0.242980
		dc	0.195090,0.146730,0.098017,0.049068
		dc	0.000000,-0.049068,-0.098017,-0.146730
		dc	-0.195090,-0.242980,-0.290285,-0.336890
		dc	-0.382683,-0.427555,-0.471397,-0.514103
		dc	-0.555570,-0.595699,-0.634393,-0.671559
		dc	-0.707107,-0.740951,-0.773010,-0.803208
		dc	-0.831470,-0.857729,-0.881921,-0.903989
		dc	-0.923880,-0.941544,-0.956940,-0.970031
		dc	-0.980785,-0.989177,-0.995185,-0.998795

table_rsinx		dc	0.000000,0.999999,0.707107,0.707107
		dc	0.382683,0.923880,0.923880,0.382683
		dc	0.195090,0.980785,0.831470,0.555570
		dc	0.555570,0.831470,0.980785,0.195090
		dc	0.098017,0.995185,0.773010,0.634393
		dc	0.471397,0.881921,0.956940,0.290285
		dc	0.290285,0.956940,0.881921,0.471397
		dc	0.634393,0.773010,0.995185,0.098017

table_rcosx		dc	0.999999,0.000000,0.707107,-0.707107
		dc	0.923880,-0.382683,0.382683,-0.923880
		dc	0.980785,-0.195090,0.555570,-0.831470
		dc	0.831470,-0.555570,0.195090,-0.980785
		dc	0.995185,-0.098017,0.634393,-0.773010
		dc	0.881921,-0.471397,0.290285,-0.956940
		dc	0.956940,-0.290285,0.471397,-0.881921
		dc	0.773010,-0.634393,0.098017,-0.995185

table_rpc		dc	rpc_debug
		dc	rpc_call
		dc	rpc_acknowledge_dsp
		dc	rpc_acknowledge_dma
		dc	rpc_setup_replay
		dc	rpc_setup_replay_with_frequency_conversion
		dc	rpc_setup_dma
		dc	rpc_dsp_load
		dc	rpc_average_dsp_load
		dc	rpc_stream_available

;; Frequencies and bitrates.
table_frequencies	dc	44100,48000,32000,0
table_bitrates	dc	0,32000,48000,56000,64000,80000
		dc	96000,112000,128000,160000,192000
		dc	224000,256000,320000,384000,0

;; Tables for nbals.
table_nbals_01	dc	4,4,3,3,3,3,3,3,3,3,3,3,0,0,0,0
		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
table_nbals_23	dc	4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3
		dc	3,3,3,3,3,3,3,2,2,2,2,2,2,2,0,0

;; Tables for nbal categories and sblimits.
table_nbal_categories	dc	0
		dc	table_nbal_categories_1
		dc	table_nbal_categories_2
table_nbal_categories_1	dc	0,1,1,3,3,3,4,4,4,4,4,0,0,0,0,0
		dc	0,1,1,3,3,3,3,3,3,3,3,0,0,0,0,0
		dc	0,2,2,3,3,3,4,4,4,4,4,0,0,0,0,0
		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
table_nbal_categories_2	dc	0,0,0,0,1,0,1,3,3,3,4,4,4,4,4,4
		dc	0,0,0,0,1,0,1,3,3,3,3,3,3,3,3,3
		dc	0,0,0,0,2,0,2,3,3,3,4,4,4,4,4,4
		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
table_sblimits	dc	0,8,12,27,30

table_framesizes	dc	0,104,156,182,208,261,313,365,417,522,626,731,835,1044,1253,0
		dc	0,96,144,168,192,240,288,336,384,480,576,672,768,960,1152,0
		dc	0,144,216,252,288,360,432,504,576,720,864,1008,1152,1440,1728,0
		dc	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

table_dma_acknowledge	dc	$ff,$4e,$6f,$43,$72,$65,$77
		dc	$20,$72,$75,$6c,$65,$73,$21

;; Sampling grouping tables.
table_grouping	dc	table_quantization_group_0
		dc	table_quantization_group_1
		dc	0
		dc	table_quantization_group_3
table_quantization_group_0	dc	$d55557,$d55557,$d55557,$000000,$d55557,$d55557,$2aaaaa,$d55557,$d55557,$d55557,$000000,$d55557
		dc	$000000,$000000,$d55557,$2aaaaa,$000000,$d55557,$d55557,$2aaaaa,$d55557,$000000,$2aaaaa,$d55557
		dc	$2aaaaa,$2aaaaa,$d55557,$d55557,$d55557,$000000,$000000,$d55557,$000000,$2aaaaa,$d55557,$000000
		dc	$d55557,$000000,$000000,$000000,$000000,$000000,$2aaaaa,$000000,$000000,$d55557,$2aaaaa,$000000
		dc	$000000,$2aaaaa,$000000,$2aaaaa,$2aaaaa,$000000,$d55557,$d55557,$2aaaaa,$000000,$d55557,$2aaaaa
		dc	$2aaaaa,$d55557,$2aaaaa,$d55557,$000000,$2aaaaa,$000000,$000000,$2aaaaa,$2aaaaa,$000000,$2aaaaa
		dc	$d55557,$2aaaaa,$2aaaaa,$000000,$2aaaaa,$2aaaaa,$2aaaaa,$2aaaaa,$2aaaaa,$d55557,$d55557,$d55557
		dc	$000000,$d55557,$d55557,$2aaaaa,$d55557,$d55557,$d55557,$000000,$d55557,$000000,$000000,$d55557
table_quantization_group_1	dc	$ccccce,$ccccce,$ccccce,$e66668,$ccccce,$ccccce,$000000,$ccccce,$ccccce,$199999,$ccccce,$ccccce
		dc	$333333,$ccccce,$ccccce,$ccccce,$e66668,$ccccce,$e66668,$e66668,$ccccce,$000000,$e66668,$ccccce
		dc	$199999,$e66668,$ccccce,$333333,$e66668,$ccccce,$ccccce,$000000,$ccccce,$e66668,$000000,$ccccce
		dc	$000000,$000000,$ccccce,$199999,$000000,$ccccce,$333333,$000000,$ccccce,$ccccce,$199999,$ccccce
		dc	$e66668,$199999,$ccccce,$000000,$199999,$ccccce,$199999,$199999,$ccccce,$333333,$199999,$ccccce
		dc	$ccccce,$333333,$ccccce,$e66668,$333333,$ccccce,$000000,$333333,$ccccce,$199999,$333333,$ccccce
		dc	$333333,$333333,$ccccce,$ccccce,$ccccce,$e66668,$e66668,$ccccce,$e66668,$000000,$ccccce,$e66668
		dc	$199999,$ccccce,$e66668,$333333,$ccccce,$e66668,$ccccce,$e66668,$e66668,$e66668,$e66668,$e66668
		dc	$000000,$e66668,$e66668,$199999,$e66668,$e66668,$333333,$e66668,$e66668,$ccccce,$000000,$e66668
		dc	$e66668,$000000,$e66668,$000000,$000000,$e66668,$199999,$000000,$e66668,$333333,$000000,$e66668
		dc	$ccccce,$199999,$e66668,$e66668,$199999,$e66668,$000000,$199999,$e66668,$199999,$199999,$e66668
		dc	$333333,$199999,$e66668,$ccccce,$333333,$e66668,$e66668,$333333,$e66668,$000000,$333333,$e66668
		dc	$199999,$333333,$e66668,$333333,$333333,$e66668,$ccccce,$ccccce,$000000,$e66668,$ccccce,$000000
		dc	$000000,$ccccce,$000000,$199999,$ccccce,$000000,$333333,$ccccce,$000000,$ccccce,$e66668,$000000
		dc	$e66668,$e66668,$000000,$000000,$e66668,$000000,$199999,$e66668,$000000,$333333,$e66668,$000000
		dc	$ccccce,$000000,$000000,$e66668,$000000,$000000,$000000,$000000,$000000,$199999,$000000,$000000
		dc	$333333,$000000,$000000,$ccccce,$199999,$000000,$e66668,$199999,$000000,$000000,$199999,$000000
		dc	$199999,$199999,$000000,$333333,$199999,$000000,$ccccce,$333333,$000000,$e66668,$333333,$000000
		dc	$000000,$333333,$000000,$199999,$333333,$000000,$333333,$333333,$000000,$ccccce,$ccccce,$199999
		dc	$e66668,$ccccce,$199999,$000000,$ccccce,$199999,$199999,$ccccce,$199999,$333333,$ccccce,$199999
		dc	$ccccce,$e66668,$199999,$e66668,$e66668,$199999,$000000,$e66668,$199999,$199999,$e66668,$199999
		dc	$333333,$e66668,$199999,$ccccce,$000000,$199999,$e66668,$000000,$199999,$000000,$000000,$199999
		dc	$199999,$000000,$199999,$333333,$000000,$199999,$ccccce,$199999,$199999,$e66668,$199999,$199999
		dc	$000000,$199999,$199999,$199999,$199999,$199999,$333333,$199999,$199999,$ccccce,$333333,$199999
		dc	$e66668,$333333,$199999,$000000,$333333,$199999,$199999,$333333,$199999,$333333,$333333,$199999
		dc	$ccccce,$ccccce,$333333,$e66668,$ccccce,$333333,$000000,$ccccce,$333333,$199999,$ccccce,$333333
		dc	$333333,$ccccce,$333333,$ccccce,$e66668,$333333,$e66668,$e66668,$333333,$000000,$e66668,$333333
		dc	$199999,$e66668,$333333,$333333,$e66668,$333333,$ccccce,$000000,$333333,$e66668,$000000,$333333
		dc	$000000,$000000,$333333,$199999,$000000,$333333,$333333,$000000,$333333,$ccccce,$199999,$333333
		dc	$e66668,$199999,$333333,$000000,$199999,$333333,$199999,$199999,$333333,$333333,$199999,$333333
		dc	$ccccce,$333333,$333333,$e66668,$333333,$333333,$000000,$333333,$333333,$199999,$333333,$333333
		dc	$333333,$333333,$333333,$ccccce,$ccccce,$ccccce,$e66668,$ccccce,$ccccce,$000000,$ccccce,$ccccce
table_quantization_group_3	dc	$c71c73,$c71c73,$c71c73,$d55557,$c71c73,$c71c73,$e38e3a,$c71c73,$c71c73,$f1c71e,$c71c73,$c71c73
		dc	$000000,$c71c73,$c71c73,$0e38e3,$c71c73,$c71c73,$1c71c7,$c71c73,$c71c73,$2aaaaa,$c71c73,$c71c73
		dc	$38e38e,$c71c73,$c71c73,$c71c73,$d55557,$c71c73,$d55557,$d55557,$c71c73,$e38e3a,$d55557,$c71c73
		dc	$f1c71e,$d55557,$c71c73,$000000,$d55557,$c71c73,$0e38e3,$d55557,$c71c73,$1c71c7,$d55557,$c71c73
		dc	$2aaaaa,$d55557,$c71c73,$38e38e,$d55557,$c71c73,$c71c73,$e38e3a,$c71c73,$d55557,$e38e3a,$c71c73
		dc	$e38e3a,$e38e3a,$c71c73,$f1c71e,$e38e3a,$c71c73,$000000,$e38e3a,$c71c73,$0e38e3,$e38e3a,$c71c73
		dc	$1c71c7,$e38e3a,$c71c73,$2aaaaa,$e38e3a,$c71c73,$38e38e,$e38e3a,$c71c73,$c71c73,$f1c71e,$c71c73
		dc	$d55557,$f1c71e,$c71c73,$e38e3a,$f1c71e,$c71c73,$f1c71e,$f1c71e,$c71c73,$000000,$f1c71e,$c71c73
		dc	$0e38e3,$f1c71e,$c71c73,$1c71c7,$f1c71e,$c71c73,$2aaaaa,$f1c71e,$c71c73,$38e38e,$f1c71e,$c71c73
		dc	$c71c73,$000000,$c71c73,$d55557,$000000,$c71c73,$e38e3a,$000000,$c71c73,$f1c71e,$000000,$c71c73
		dc	$000000,$000000,$c71c73,$0e38e3,$000000,$c71c73,$1c71c7,$000000,$c71c73,$2aaaaa,$000000,$c71c73
		dc	$38e38e,$000000,$c71c73,$c71c73,$0e38e3,$c71c73,$d55557,$0e38e3,$c71c73,$e38e3a,$0e38e3,$c71c73
		dc	$f1c71e,$0e38e3,$c71c73,$000000,$0e38e3,$c71c73,$0e38e3,$0e38e3,$c71c73,$1c71c7,$0e38e3,$c71c73
		dc	$2aaaaa,$0e38e3,$c71c73,$38e38e,$0e38e3,$c71c73,$c71c73,$1c71c7,$c71c73,$d55557,$1c71c7,$c71c73
		dc	$e38e3a,$1c71c7,$c71c73,$f1c71e,$1c71c7,$c71c73,$000000,$1c71c7,$c71c73,$0e38e3,$1c71c7,$c71c73
		dc	$1c71c7,$1c71c7,$c71c73,$2aaaaa,$1c71c7,$c71c73,$38e38e,$1c71c7,$c71c73,$c71c73,$2aaaaa,$c71c73
		dc	$d55557,$2aaaaa,$c71c73,$e38e3a,$2aaaaa,$c71c73,$f1c71e,$2aaaaa,$c71c73,$000000,$2aaaaa,$c71c73
		dc	$0e38e3,$2aaaaa,$c71c73,$1c71c7,$2aaaaa,$c71c73,$2aaaaa,$2aaaaa,$c71c73,$38e38e,$2aaaaa,$c71c73
		dc	$c71c73,$38e38e,$c71c73,$d55557,$38e38e,$c71c73,$e38e3a,$38e38e,$c71c73,$f1c71e,$38e38e,$c71c73
		dc	$000000,$38e38e,$c71c73,$0e38e3,$38e38e,$c71c73,$1c71c7,$38e38e,$c71c73,$2aaaaa,$38e38e,$c71c73
		dc	$38e38e,$38e38e,$c71c73,$c71c73,$c71c73,$d55557,$d55557,$c71c73,$d55557,$e38e3a,$c71c73,$d55557
		dc	$f1c71e,$c71c73,$d55557,$000000,$c71c73,$d55557,$0e38e3,$c71c73,$d55557,$1c71c7,$c71c73,$d55557
		dc	$2aaaaa,$c71c73,$d55557,$38e38e,$c71c73,$d55557,$c71c73,$d55557,$d55557,$d55557,$d55557,$d55557
		dc	$e38e3a,$d55557,$d55557,$f1c71e,$d55557,$d55557,$000000,$d55557,$d55557,$0e38e3,$d55557,$d55557
		dc	$1c71c7,$d55557,$d55557,$2aaaaa,$d55557,$d55557,$38e38e,$d55557,$d55557,$c71c73,$e38e3a,$d55557
		dc	$d55557,$e38e3a,$d55557,$e38e3a,$e38e3a,$d55557,$f1c71e,$e38e3a,$d55557,$000000,$e38e3a,$d55557
		dc	$0e38e3,$e38e3a,$d55557,$1c71c7,$e38e3a,$d55557,$2aaaaa,$e38e3a,$d55557,$38e38e,$e38e3a,$d55557
		dc	$c71c73,$f1c71e,$d55557,$d55557,$f1c71e,$d55557,$e38e3a,$f1c71e,$d55557,$f1c71e,$f1c71e,$d55557
		dc	$000000,$f1c71e,$d55557,$0e38e3,$f1c71e,$d55557,$1c71c7,$f1c71e,$d55557,$2aaaaa,$f1c71e,$d55557
		dc	$38e38e,$f1c71e,$d55557,$c71c73,$000000,$d55557,$d55557,$000000,$d55557,$e38e3a,$000000,$d55557
		dc	$f1c71e,$000000,$d55557,$000000,$000000,$d55557,$0e38e3,$000000,$d55557,$1c71c7,$000000,$d55557
		dc	$2aaaaa,$000000,$d55557,$38e38e,$000000,$d55557,$c71c73,$0e38e3,$d55557,$d55557,$0e38e3,$d55557
		dc	$e38e3a,$0e38e3,$d55557,$f1c71e,$0e38e3,$d55557,$000000,$0e38e3,$d55557,$0e38e3,$0e38e3,$d55557
		dc	$1c71c7,$0e38e3,$d55557,$2aaaaa,$0e38e3,$d55557,$38e38e,$0e38e3,$d55557,$c71c73,$1c71c7,$d55557
		dc	$d55557,$1c71c7,$d55557,$e38e3a,$1c71c7,$d55557,$f1c71e,$1c71c7,$d55557,$000000,$1c71c7,$d55557
		dc	$0e38e3,$1c71c7,$d55557,$1c71c7,$1c71c7,$d55557,$2aaaaa,$1c71c7,$d55557,$38e38e,$1c71c7,$d55557
		dc	$c71c73,$2aaaaa,$d55557,$d55557,$2aaaaa,$d55557,$e38e3a,$2aaaaa,$d55557,$f1c71e,$2aaaaa,$d55557
		dc	$000000,$2aaaaa,$d55557,$0e38e3,$2aaaaa,$d55557,$1c71c7,$2aaaaa,$d55557,$2aaaaa,$2aaaaa,$d55557
		dc	$38e38e,$2aaaaa,$d55557,$c71c73,$38e38e,$d55557,$d55557,$38e38e,$d55557,$e38e3a,$38e38e,$d55557
		dc	$f1c71e,$38e38e,$d55557,$000000,$38e38e,$d55557,$0e38e3,$38e38e,$d55557,$1c71c7,$38e38e,$d55557
		dc	$2aaaaa,$38e38e,$d55557,$38e38e,$38e38e,$d55557,$c71c73,$c71c73,$e38e3a,$d55557,$c71c73,$e38e3a
		dc	$e38e3a,$c71c73,$e38e3a,$f1c71e,$c71c73,$e38e3a,$000000,$c71c73,$e38e3a,$0e38e3,$c71c73,$e38e3a
		dc	$1c71c7,$c71c73,$e38e3a,$2aaaaa,$c71c73,$e38e3a,$38e38e,$c71c73,$e38e3a,$c71c73,$d55557,$e38e3a
		dc	$d55557,$d55557,$e38e3a,$e38e3a,$d55557,$e38e3a,$f1c71e,$d55557,$e38e3a,$000000,$d55557,$e38e3a
		dc	$0e38e3,$d55557,$e38e3a,$1c71c7,$d55557,$e38e3a,$2aaaaa,$d55557,$e38e3a,$38e38e,$d55557,$e38e3a
		dc	$c71c73,$e38e3a,$e38e3a,$d55557,$e38e3a,$e38e3a,$e38e3a,$e38e3a,$e38e3a,$f1c71e,$e38e3a,$e38e3a
		dc	$000000,$e38e3a,$e38e3a,$0e38e3,$e38e3a,$e38e3a,$1c71c7,$e38e3a,$e38e3a,$2aaaaa,$e38e3a,$e38e3a
		dc	$38e38e,$e38e3a,$e38e3a,$c71c73,$f1c71e,$e38e3a,$d55557,$f1c71e,$e38e3a,$e38e3a,$f1c71e,$e38e3a
		dc	$f1c71e,$f1c71e,$e38e3a,$000000,$f1c71e,$e38e3a,$0e38e3,$f1c71e,$e38e3a,$1c71c7,$f1c71e,$e38e3a
		dc	$2aaaaa,$f1c71e,$e38e3a,$38e38e,$f1c71e,$e38e3a,$c71c73,$000000,$e38e3a,$d55557,$000000,$e38e3a
		dc	$e38e3a,$000000,$e38e3a,$f1c71e,$000000,$e38e3a,$000000,$000000,$e38e3a,$0e38e3,$000000,$e38e3a
		dc	$1c71c7,$000000,$e38e3a,$2aaaaa,$000000,$e38e3a,$38e38e,$000000,$e38e3a,$c71c73,$0e38e3,$e38e3a
		dc	$d55557,$0e38e3,$e38e3a,$e38e3a,$0e38e3,$e38e3a,$f1c71e,$0e38e3,$e38e3a,$000000,$0e38e3,$e38e3a
		dc	$0e38e3,$0e38e3,$e38e3a,$1c71c7,$0e38e3,$e38e3a,$2aaaaa,$0e38e3,$e38e3a,$38e38e,$0e38e3,$e38e3a
		dc	$c71c73,$1c71c7,$e38e3a,$d55557,$1c71c7,$e38e3a,$e38e3a,$1c71c7,$e38e3a,$f1c71e,$1c71c7,$e38e3a
		dc	$000000,$1c71c7,$e38e3a,$0e38e3,$1c71c7,$e38e3a,$1c71c7,$1c71c7,$e38e3a,$2aaaaa,$1c71c7,$e38e3a
		dc	$38e38e,$1c71c7,$e38e3a,$c71c73,$2aaaaa,$e38e3a,$d55557,$2aaaaa,$e38e3a,$e38e3a,$2aaaaa,$e38e3a
		dc	$f1c71e,$2aaaaa,$e38e3a,$000000,$2aaaaa,$e38e3a,$0e38e3,$2aaaaa,$e38e3a,$1c71c7,$2aaaaa,$e38e3a
		dc	$2aaaaa,$2aaaaa,$e38e3a,$38e38e,$2aaaaa,$e38e3a,$c71c73,$38e38e,$e38e3a,$d55557,$38e38e,$e38e3a
		dc	$e38e3a,$38e38e,$e38e3a,$f1c71e,$38e38e,$e38e3a,$000000,$38e38e,$e38e3a,$0e38e3,$38e38e,$e38e3a
		dc	$1c71c7,$38e38e,$e38e3a,$2aaaaa,$38e38e,$e38e3a,$38e38e,$38e38e,$e38e3a,$c71c73,$c71c73,$f1c71e
		dc	$d55557,$c71c73,$f1c71e,$e38e3a,$c71c73,$f1c71e,$f1c71e,$c71c73,$f1c71e,$000000,$c71c73,$f1c71e
		dc	$0e38e3,$c71c73,$f1c71e,$1c71c7,$c71c73,$f1c71e,$2aaaaa,$c71c73,$f1c71e,$38e38e,$c71c73,$f1c71e
		dc	$c71c73,$d55557,$f1c71e,$d55557,$d55557,$f1c71e,$e38e3a,$d55557,$f1c71e,$f1c71e,$d55557,$f1c71e
		dc	$000000,$d55557,$f1c71e,$0e38e3,$d55557,$f1c71e,$1c71c7,$d55557,$f1c71e,$2aaaaa,$d55557,$f1c71e
		dc	$38e38e,$d55557,$f1c71e,$c71c73,$e38e3a,$f1c71e,$d55557,$e38e3a,$f1c71e,$e38e3a,$e38e3a,$f1c71e
		dc	$f1c71e,$e38e3a,$f1c71e,$000000,$e38e3a,$f1c71e,$0e38e3,$e38e3a,$f1c71e,$1c71c7,$e38e3a,$f1c71e
		dc	$2aaaaa,$e38e3a,$f1c71e,$38e38e,$e38e3a,$f1c71e,$c71c73,$f1c71e,$f1c71e,$d55557,$f1c71e,$f1c71e
		dc	$e38e3a,$f1c71e,$f1c71e,$f1c71e,$f1c71e,$f1c71e,$000000,$f1c71e,$f1c71e,$0e38e3,$f1c71e,$f1c71e
		dc	$1c71c7,$f1c71e,$f1c71e,$2aaaaa,$f1c71e,$f1c71e,$38e38e,$f1c71e,$f1c71e,$c71c73,$000000,$f1c71e
		dc	$d55557,$000000,$f1c71e,$e38e3a,$000000,$f1c71e,$f1c71e,$000000,$f1c71e,$000000,$000000,$f1c71e
		dc	$0e38e3,$000000,$f1c71e,$1c71c7,$000000,$f1c71e,$2aaaaa,$000000,$f1c71e,$38e38e,$000000,$f1c71e
		dc	$c71c73,$0e38e3,$f1c71e,$d55557,$0e38e3,$f1c71e,$e38e3a,$0e38e3,$f1c71e,$f1c71e,$0e38e3,$f1c71e
		dc	$000000,$0e38e3,$f1c71e,$0e38e3,$0e38e3,$f1c71e,$1c71c7,$0e38e3,$f1c71e,$2aaaaa,$0e38e3,$f1c71e
		dc	$38e38e,$0e38e3,$f1c71e,$c71c73,$1c71c7,$f1c71e,$d55557,$1c71c7,$f1c71e,$e38e3a,$1c71c7,$f1c71e
		dc	$f1c71e,$1c71c7,$f1c71e,$000000,$1c71c7,$f1c71e,$0e38e3,$1c71c7,$f1c71e,$1c71c7,$1c71c7,$f1c71e
		dc	$2aaaaa,$1c71c7,$f1c71e,$38e38e,$1c71c7,$f1c71e,$c71c73,$2aaaaa,$f1c71e,$d55557,$2aaaaa,$f1c71e
		dc	$e38e3a,$2aaaaa,$f1c71e,$f1c71e,$2aaaaa,$f1c71e,$000000,$2aaaaa,$f1c71e,$0e38e3,$2aaaaa,$f1c71e
		dc	$1c71c7,$2aaaaa,$f1c71e,$2aaaaa,$2aaaaa,$f1c71e,$38e38e,$2aaaaa,$f1c71e,$c71c73,$38e38e,$f1c71e
		dc	$d55557,$38e38e,$f1c71e,$e38e3a,$38e38e,$f1c71e,$f1c71e,$38e38e,$f1c71e,$000000,$38e38e,$f1c71e
		dc	$0e38e3,$38e38e,$f1c71e,$1c71c7,$38e38e,$f1c71e,$2aaaaa,$38e38e,$f1c71e,$38e38e,$38e38e,$f1c71e
		dc	$c71c73,$c71c73,$000000,$d55557,$c71c73,$000000,$e38e3a,$c71c73,$000000,$f1c71e,$c71c73,$000000
		dc	$000000,$c71c73,$000000,$0e38e3,$c71c73,$000000,$1c71c7,$c71c73,$000000,$2aaaaa,$c71c73,$000000
		dc	$38e38e,$c71c73,$000000,$c71c73,$d55557,$000000,$d55557,$d55557,$000000,$e38e3a,$d55557,$000000
		dc	$f1c71e,$d55557,$000000,$000000,$d55557,$000000,$0e38e3,$d55557,$000000,$1c71c7,$d55557,$000000
		dc	$2aaaaa,$d55557,$000000,$38e38e,$d55557,$000000,$c71c73,$e38e3a,$000000,$d55557,$e38e3a,$000000
		dc	$e38e3a,$e38e3a,$000000,$f1c71e,$e38e3a,$000000,$000000,$e38e3a,$000000,$0e38e3,$e38e3a,$000000
		dc	$1c71c7,$e38e3a,$000000,$2aaaaa,$e38e3a,$000000,$38e38e,$e38e3a,$000000,$c71c73,$f1c71e,$000000
		dc	$d55557,$f1c71e,$000000,$e38e3a,$f1c71e,$000000,$f1c71e,$f1c71e,$000000,$000000,$f1c71e,$000000
		dc	$0e38e3,$f1c71e,$000000,$1c71c7,$f1c71e,$000000,$2aaaaa,$f1c71e,$000000,$38e38e,$f1c71e,$000000
		dc	$c71c73,$000000,$000000,$d55557,$000000,$000000,$e38e3a,$000000,$000000,$f1c71e,$000000,$000000
		dc	$000000,$000000,$000000,$0e38e3,$000000,$000000,$1c71c7,$000000,$000000,$2aaaaa,$000000,$000000
		dc	$38e38e,$000000,$000000,$c71c73,$0e38e3,$000000,$d55557,$0e38e3,$000000,$e38e3a,$0e38e3,$000000
		dc	$f1c71e,$0e38e3,$000000,$000000,$0e38e3,$000000,$0e38e3,$0e38e3,$000000,$1c71c7,$0e38e3,$000000
		dc	$2aaaaa,$0e38e3,$000000,$38e38e,$0e38e3,$000000,$c71c73,$1c71c7,$000000,$d55557,$1c71c7,$000000
		dc	$e38e3a,$1c71c7,$000000,$f1c71e,$1c71c7,$000000,$000000,$1c71c7,$000000,$0e38e3,$1c71c7,$000000
		dc	$1c71c7,$1c71c7,$000000,$2aaaaa,$1c71c7,$000000,$38e38e,$1c71c7,$000000,$c71c73,$2aaaaa,$000000
		dc	$d55557,$2aaaaa,$000000,$e38e3a,$2aaaaa,$000000,$f1c71e,$2aaaaa,$000000,$000000,$2aaaaa,$000000
		dc	$0e38e3,$2aaaaa,$000000,$1c71c7,$2aaaaa,$000000,$2aaaaa,$2aaaaa,$000000,$38e38e,$2aaaaa,$000000
		dc	$c71c73,$38e38e,$000000,$d55557,$38e38e,$000000,$e38e3a,$38e38e,$000000,$f1c71e,$38e38e,$000000
		dc	$000000,$38e38e,$000000,$0e38e3,$38e38e,$000000,$1c71c7,$38e38e,$000000,$2aaaaa,$38e38e,$000000
		dc	$38e38e,$38e38e,$000000,$c71c73,$c71c73,$0e38e3,$d55557,$c71c73,$0e38e3,$e38e3a,$c71c73,$0e38e3
		dc	$f1c71e,$c71c73,$0e38e3,$000000,$c71c73,$0e38e3,$0e38e3,$c71c73,$0e38e3,$1c71c7,$c71c73,$0e38e3
		dc	$2aaaaa,$c71c73,$0e38e3,$38e38e,$c71c73,$0e38e3,$c71c73,$d55557,$0e38e3,$d55557,$d55557,$0e38e3
		dc	$e38e3a,$d55557,$0e38e3,$f1c71e,$d55557,$0e38e3,$000000,$d55557,$0e38e3,$0e38e3,$d55557,$0e38e3
		dc	$1c71c7,$d55557,$0e38e3,$2aaaaa,$d55557,$0e38e3,$38e38e,$d55557,$0e38e3,$c71c73,$e38e3a,$0e38e3
		dc	$d55557,$e38e3a,$0e38e3,$e38e3a,$e38e3a,$0e38e3,$f1c71e,$e38e3a,$0e38e3,$000000,$e38e3a,$0e38e3
		dc	$0e38e3,$e38e3a,$0e38e3,$1c71c7,$e38e3a,$0e38e3,$2aaaaa,$e38e3a,$0e38e3,$38e38e,$e38e3a,$0e38e3
		dc	$c71c73,$f1c71e,$0e38e3,$d55557,$f1c71e,$0e38e3,$e38e3a,$f1c71e,$0e38e3,$f1c71e,$f1c71e,$0e38e3
		dc	$000000,$f1c71e,$0e38e3,$0e38e3,$f1c71e,$0e38e3,$1c71c7,$f1c71e,$0e38e3,$2aaaaa,$f1c71e,$0e38e3
		dc	$38e38e,$f1c71e,$0e38e3,$c71c73,$000000,$0e38e3,$d55557,$000000,$0e38e3,$e38e3a,$000000,$0e38e3
		dc	$f1c71e,$000000,$0e38e3,$000000,$000000,$0e38e3,$0e38e3,$000000,$0e38e3,$1c71c7,$000000,$0e38e3
		dc	$2aaaaa,$000000,$0e38e3,$38e38e,$000000,$0e38e3,$c71c73,$0e38e3,$0e38e3,$d55557,$0e38e3,$0e38e3
		dc	$e38e3a,$0e38e3,$0e38e3,$f1c71e,$0e38e3,$0e38e3,$000000,$0e38e3,$0e38e3,$0e38e3,$0e38e3,$0e38e3
		dc	$1c71c7,$0e38e3,$0e38e3,$2aaaaa,$0e38e3,$0e38e3,$38e38e,$0e38e3,$0e38e3,$c71c73,$1c71c7,$0e38e3
		dc	$d55557,$1c71c7,$0e38e3,$e38e3a,$1c71c7,$0e38e3,$f1c71e,$1c71c7,$0e38e3,$000000,$1c71c7,$0e38e3
		dc	$0e38e3,$1c71c7,$0e38e3,$1c71c7,$1c71c7,$0e38e3,$2aaaaa,$1c71c7,$0e38e3,$38e38e,$1c71c7,$0e38e3
		dc	$c71c73,$2aaaaa,$0e38e3,$d55557,$2aaaaa,$0e38e3,$e38e3a,$2aaaaa,$0e38e3,$f1c71e,$2aaaaa,$0e38e3
		dc	$000000,$2aaaaa,$0e38e3,$0e38e3,$2aaaaa,$0e38e3,$1c71c7,$2aaaaa,$0e38e3,$2aaaaa,$2aaaaa,$0e38e3
		dc	$38e38e,$2aaaaa,$0e38e3,$c71c73,$38e38e,$0e38e3,$d55557,$38e38e,$0e38e3,$e38e3a,$38e38e,$0e38e3
		dc	$f1c71e,$38e38e,$0e38e3,$000000,$38e38e,$0e38e3,$0e38e3,$38e38e,$0e38e3,$1c71c7,$38e38e,$0e38e3
		dc	$2aaaaa,$38e38e,$0e38e3,$38e38e,$38e38e,$0e38e3,$c71c73,$c71c73,$1c71c7,$d55557,$c71c73,$1c71c7
		dc	$e38e3a,$c71c73,$1c71c7,$f1c71e,$c71c73,$1c71c7,$000000,$c71c73,$1c71c7,$0e38e3,$c71c73,$1c71c7
		dc	$1c71c7,$c71c73,$1c71c7,$2aaaaa,$c71c73,$1c71c7,$38e38e,$c71c73,$1c71c7,$c71c73,$d55557,$1c71c7
		dc	$d55557,$d55557,$1c71c7,$e38e3a,$d55557,$1c71c7,$f1c71e,$d55557,$1c71c7,$000000,$d55557,$1c71c7
		dc	$0e38e3,$d55557,$1c71c7,$1c71c7,$d55557,$1c71c7,$2aaaaa,$d55557,$1c71c7,$38e38e,$d55557,$1c71c7
		dc	$c71c73,$e38e3a,$1c71c7,$d55557,$e38e3a,$1c71c7,$e38e3a,$e38e3a,$1c71c7,$f1c71e,$e38e3a,$1c71c7
		dc	$000000,$e38e3a,$1c71c7,$0e38e3,$e38e3a,$1c71c7,$1c71c7,$e38e3a,$1c71c7,$2aaaaa,$e38e3a,$1c71c7
		dc	$38e38e,$e38e3a,$1c71c7,$c71c73,$f1c71e,$1c71c7,$d55557,$f1c71e,$1c71c7,$e38e3a,$f1c71e,$1c71c7
		dc	$f1c71e,$f1c71e,$1c71c7,$000000,$f1c71e,$1c71c7,$0e38e3,$f1c71e,$1c71c7,$1c71c7,$f1c71e,$1c71c7
		dc	$2aaaaa,$f1c71e,$1c71c7,$38e38e,$f1c71e,$1c71c7,$c71c73,$000000,$1c71c7,$d55557,$000000,$1c71c7
		dc	$e38e3a,$000000,$1c71c7,$f1c71e,$000000,$1c71c7,$000000,$000000,$1c71c7,$0e38e3,$000000,$1c71c7
		dc	$1c71c7,$000000,$1c71c7,$2aaaaa,$000000,$1c71c7,$38e38e,$000000,$1c71c7,$c71c73,$0e38e3,$1c71c7
		dc	$d55557,$0e38e3,$1c71c7,$e38e3a,$0e38e3,$1c71c7,$f1c71e,$0e38e3,$1c71c7,$000000,$0e38e3,$1c71c7
		dc	$0e38e3,$0e38e3,$1c71c7,$1c71c7,$0e38e3,$1c71c7,$2aaaaa,$0e38e3,$1c71c7,$38e38e,$0e38e3,$1c71c7
		dc	$c71c73,$1c71c7,$1c71c7,$d55557,$1c71c7,$1c71c7,$e38e3a,$1c71c7,$1c71c7,$f1c71e,$1c71c7,$1c71c7
		dc	$000000,$1c71c7,$1c71c7,$0e38e3,$1c71c7,$1c71c7,$1c71c7,$1c71c7,$1c71c7,$2aaaaa,$1c71c7,$1c71c7
		dc	$38e38e,$1c71c7,$1c71c7,$c71c73,$2aaaaa,$1c71c7,$d55557,$2aaaaa,$1c71c7,$e38e3a,$2aaaaa,$1c71c7
		dc	$f1c71e,$2aaaaa,$1c71c7,$000000,$2aaaaa,$1c71c7,$0e38e3,$2aaaaa,$1c71c7,$1c71c7,$2aaaaa,$1c71c7
		dc	$2aaaaa,$2aaaaa,$1c71c7,$38e38e,$2aaaaa,$1c71c7,$c71c73,$38e38e,$1c71c7,$d55557,$38e38e,$1c71c7
		dc	$e38e3a,$38e38e,$1c71c7,$f1c71e,$38e38e,$1c71c7,$000000,$38e38e,$1c71c7,$0e38e3,$38e38e,$1c71c7
		dc	$1c71c7,$38e38e,$1c71c7,$2aaaaa,$38e38e,$1c71c7,$38e38e,$38e38e,$1c71c7,$c71c73,$c71c73,$2aaaaa
		dc	$d55557,$c71c73,$2aaaaa,$e38e3a,$c71c73,$2aaaaa,$f1c71e,$c71c73,$2aaaaa,$000000,$c71c73,$2aaaaa
		dc	$0e38e3,$c71c73,$2aaaaa,$1c71c7,$c71c73,$2aaaaa,$2aaaaa,$c71c73,$2aaaaa,$38e38e,$c71c73,$2aaaaa
		dc	$c71c73,$d55557,$2aaaaa,$d55557,$d55557,$2aaaaa,$e38e3a,$d55557,$2aaaaa,$f1c71e,$d55557,$2aaaaa
		dc	$000000,$d55557,$2aaaaa,$0e38e3,$d55557,$2aaaaa,$1c71c7,$d55557,$2aaaaa,$2aaaaa,$d55557,$2aaaaa
		dc	$38e38e,$d55557,$2aaaaa,$c71c73,$e38e3a,$2aaaaa,$d55557,$e38e3a,$2aaaaa,$e38e3a,$e38e3a,$2aaaaa
		dc	$f1c71e,$e38e3a,$2aaaaa,$000000,$e38e3a,$2aaaaa,$0e38e3,$e38e3a,$2aaaaa,$1c71c7,$e38e3a,$2aaaaa
		dc	$2aaaaa,$e38e3a,$2aaaaa,$38e38e,$e38e3a,$2aaaaa,$c71c73,$f1c71e,$2aaaaa,$d55557,$f1c71e,$2aaaaa
		dc	$e38e3a,$f1c71e,$2aaaaa,$f1c71e,$f1c71e,$2aaaaa,$000000,$f1c71e,$2aaaaa,$0e38e3,$f1c71e,$2aaaaa
		dc	$1c71c7,$f1c71e,$2aaaaa,$2aaaaa,$f1c71e,$2aaaaa,$38e38e,$f1c71e,$2aaaaa,$c71c73,$000000,$2aaaaa
		dc	$d55557,$000000,$2aaaaa,$e38e3a,$000000,$2aaaaa,$f1c71e,$000000,$2aaaaa,$000000,$000000,$2aaaaa
		dc	$0e38e3,$000000,$2aaaaa,$1c71c7,$000000,$2aaaaa,$2aaaaa,$000000,$2aaaaa,$38e38e,$000000,$2aaaaa
		dc	$c71c73,$0e38e3,$2aaaaa,$d55557,$0e38e3,$2aaaaa,$e38e3a,$0e38e3,$2aaaaa,$f1c71e,$0e38e3,$2aaaaa
		dc	$000000,$0e38e3,$2aaaaa,$0e38e3,$0e38e3,$2aaaaa,$1c71c7,$0e38e3,$2aaaaa,$2aaaaa,$0e38e3,$2aaaaa
		dc	$38e38e,$0e38e3,$2aaaaa,$c71c73,$1c71c7,$2aaaaa,$d55557,$1c71c7,$2aaaaa,$e38e3a,$1c71c7,$2aaaaa
		dc	$f1c71e,$1c71c7,$2aaaaa,$000000,$1c71c7,$2aaaaa,$0e38e3,$1c71c7,$2aaaaa,$1c71c7,$1c71c7,$2aaaaa
		dc	$2aaaaa,$1c71c7,$2aaaaa,$38e38e,$1c71c7,$2aaaaa,$c71c73,$2aaaaa,$2aaaaa,$d55557,$2aaaaa,$2aaaaa
		dc	$e38e3a,$2aaaaa,$2aaaaa,$f1c71e,$2aaaaa,$2aaaaa,$000000,$2aaaaa,$2aaaaa,$0e38e3,$2aaaaa,$2aaaaa
		dc	$1c71c7,$2aaaaa,$2aaaaa,$2aaaaa,$2aaaaa,$2aaaaa,$38e38e,$2aaaaa,$2aaaaa,$c71c73,$38e38e,$2aaaaa
		dc	$d55557,$38e38e,$2aaaaa,$e38e3a,$38e38e,$2aaaaa,$f1c71e,$38e38e,$2aaaaa,$000000,$38e38e,$2aaaaa
		dc	$0e38e3,$38e38e,$2aaaaa,$1c71c7,$38e38e,$2aaaaa,$2aaaaa,$38e38e,$2aaaaa,$38e38e,$38e38e,$2aaaaa
		dc	$c71c73,$c71c73,$38e38e,$d55557,$c71c73,$38e38e,$e38e3a,$c71c73,$38e38e,$f1c71e,$c71c73,$38e38e
		dc	$000000,$c71c73,$38e38e,$0e38e3,$c71c73,$38e38e,$1c71c7,$c71c73,$38e38e,$2aaaaa,$c71c73,$38e38e
		dc	$38e38e,$c71c73,$38e38e,$c71c73,$d55557,$38e38e,$d55557,$d55557,$38e38e,$e38e3a,$d55557,$38e38e
		dc	$f1c71e,$d55557,$38e38e,$000000,$d55557,$38e38e,$0e38e3,$d55557,$38e38e,$1c71c7,$d55557,$38e38e
		dc	$2aaaaa,$d55557,$38e38e,$38e38e,$d55557,$38e38e,$c71c73,$e38e3a,$38e38e,$d55557,$e38e3a,$38e38e
		dc	$e38e3a,$e38e3a,$38e38e,$f1c71e,$e38e3a,$38e38e,$000000,$e38e3a,$38e38e,$0e38e3,$e38e3a,$38e38e
		dc	$1c71c7,$e38e3a,$38e38e,$2aaaaa,$e38e3a,$38e38e,$38e38e,$e38e3a,$38e38e,$c71c73,$f1c71e,$38e38e
		dc	$d55557,$f1c71e,$38e38e,$e38e3a,$f1c71e,$38e38e,$f1c71e,$f1c71e,$38e38e,$000000,$f1c71e,$38e38e
		dc	$0e38e3,$f1c71e,$38e38e,$1c71c7,$f1c71e,$38e38e,$2aaaaa,$f1c71e,$38e38e,$38e38e,$f1c71e,$38e38e
		dc	$c71c73,$000000,$38e38e,$d55557,$000000,$38e38e,$e38e3a,$000000,$38e38e,$f1c71e,$000000,$38e38e
		dc	$000000,$000000,$38e38e,$0e38e3,$000000,$38e38e,$1c71c7,$000000,$38e38e,$2aaaaa,$000000,$38e38e
		dc	$38e38e,$000000,$38e38e,$c71c73,$0e38e3,$38e38e,$d55557,$0e38e3,$38e38e,$e38e3a,$0e38e3,$38e38e
		dc	$f1c71e,$0e38e3,$38e38e,$000000,$0e38e3,$38e38e,$0e38e3,$0e38e3,$38e38e,$1c71c7,$0e38e3,$38e38e
		dc	$2aaaaa,$0e38e3,$38e38e,$38e38e,$0e38e3,$38e38e,$c71c73,$1c71c7,$38e38e,$d55557,$1c71c7,$38e38e
		dc	$e38e3a,$1c71c7,$38e38e,$f1c71e,$1c71c7,$38e38e,$000000,$1c71c7,$38e38e,$0e38e3,$1c71c7,$38e38e
		dc	$1c71c7,$1c71c7,$38e38e,$2aaaaa,$1c71c7,$38e38e,$38e38e,$1c71c7,$38e38e,$c71c73,$2aaaaa,$38e38e
		dc	$d55557,$2aaaaa,$38e38e,$e38e3a,$2aaaaa,$38e38e,$f1c71e,$2aaaaa,$38e38e,$000000,$2aaaaa,$38e38e
		dc	$0e38e3,$2aaaaa,$38e38e,$1c71c7,$2aaaaa,$38e38e,$2aaaaa,$2aaaaa,$38e38e,$38e38e,$2aaaaa,$38e38e
		dc	$c71c73,$38e38e,$38e38e,$d55557,$38e38e,$38e38e,$e38e3a,$38e38e,$38e38e,$f1c71e,$38e38e,$38e38e
		dc	$000000,$38e38e,$38e38e,$0e38e3,$38e38e,$38e38e,$1c71c7,$38e38e,$38e38e,$2aaaaa,$38e38e,$38e38e
		dc	$38e38e,$38e38e,$38e38e,$c71c73,$c71c73,$c71c73,$d55557,$c71c73,$c71c73,$e38e3a,$c71c73,$c71c73
		dc	$f1c71e,$c71c73,$c71c73,$000000,$c71c73,$c71c73,$0e38e3,$c71c73,$c71c73,$1c71c7,$c71c73,$c71c73
		dc	$2aaaaa,$c71c73,$c71c73,$38e38e,$c71c73,$c71c73,$c71c73,$d55557,$c71c73,$d55557,$d55557,$c71c73
		dc	$e38e3a,$d55557,$c71c73,$f1c71e,$d55557,$c71c73,$000000,$d55557,$c71c73,$0e38e3,$d55557,$c71c73
		dc	$1c71c7,$d55557,$c71c73,$2aaaaa,$d55557,$c71c73,$38e38e,$d55557,$c71c73,$c71c73,$e38e3a,$c71c73
		dc	$d55557,$e38e3a,$c71c73,$e38e3a,$e38e3a,$c71c73,$f1c71e,$e38e3a,$c71c73,$000000,$e38e3a,$c71c73
		dc	$0e38e3,$e38e3a,$c71c73,$1c71c7,$e38e3a,$c71c73,$2aaaaa,$e38e3a,$c71c73,$38e38e,$e38e3a,$c71c73
		dc	$c71c73,$f1c71e,$c71c73,$d55557,$f1c71e,$c71c73,$e38e3a,$f1c71e,$c71c73,$f1c71e,$f1c71e,$c71c73
		dc	$000000,$f1c71e,$c71c73,$0e38e3,$f1c71e,$c71c73,$1c71c7,$f1c71e,$c71c73,$2aaaaa,$f1c71e,$c71c73
		dc	$38e38e,$f1c71e,$c71c73,$c71c73,$000000,$c71c73,$d55557,$000000,$c71c73,$e38e3a,$000000,$c71c73
		dc	$f1c71e,$000000,$c71c73,$000000,$000000,$c71c73,$0e38e3,$000000,$c71c73,$1c71c7,$000000,$c71c73
		dc	$2aaaaa,$000000,$c71c73,$38e38e,$000000,$c71c73,$c71c73,$0e38e3,$c71c73,$d55557,$0e38e3,$c71c73
		dc	$e38e3a,$0e38e3,$c71c73,$f1c71e,$0e38e3,$c71c73,$000000,$0e38e3,$c71c73,$0e38e3,$0e38e3,$c71c73
		dc	$1c71c7,$0e38e3,$c71c73,$2aaaaa,$0e38e3,$c71c73,$38e38e,$0e38e3,$c71c73,$c71c73,$1c71c7,$c71c73
		dc	$d55557,$1c71c7,$c71c73,$e38e3a,$1c71c7,$c71c73,$f1c71e,$1c71c7,$c71c73,$000000,$1c71c7,$c71c73
		dc	$0e38e3,$1c71c7,$c71c73,$1c71c7,$1c71c7,$c71c73,$2aaaaa,$1c71c7,$c71c73,$38e38e,$1c71c7,$c71c73
		dc	$c71c73,$2aaaaa,$c71c73,$d55557,$2aaaaa,$c71c73,$e38e3a,$2aaaaa,$c71c73,$f1c71e,$2aaaaa,$c71c73
		dc	$000000,$2aaaaa,$c71c73,$0e38e3,$2aaaaa,$c71c73,$1c71c7,$2aaaaa,$c71c73,$2aaaaa,$2aaaaa,$c71c73
		dc	$38e38e,$2aaaaa,$c71c73,$c71c73,$38e38e,$c71c73,$d55557,$38e38e,$c71c73,$e38e3a,$38e38e,$c71c73
		dc	$f1c71e,$38e38e,$c71c73,$000000,$38e38e,$c71c73,$0e38e3,$38e38e,$c71c73,$1c71c7,$38e38e,$c71c73
		dc	$2aaaaa,$38e38e,$c71c73,$38e38e,$38e38e,$c71c73,$c71c73,$c71c73,$d55557,$d55557,$c71c73,$d55557
		dc	$e38e3a,$c71c73,$d55557,$f1c71e,$c71c73,$d55557,$000000,$c71c73,$d55557,$0e38e3,$c71c73,$d55557
		dc	$1c71c7,$c71c73,$d55557,$2aaaaa,$c71c73,$d55557,$38e38e,$c71c73,$d55557,$c71c73,$d55557,$d55557
		dc	$d55557,$d55557,$d55557,$e38e3a,$d55557,$d55557,$f1c71e,$d55557,$d55557,$000000,$d55557,$d55557
		dc	$0e38e3,$d55557,$d55557,$1c71c7,$d55557,$d55557,$2aaaaa,$d55557,$d55557,$38e38e,$d55557,$d55557
		dc	$c71c73,$e38e3a,$d55557,$d55557,$e38e3a,$d55557,$e38e3a,$e38e3a,$d55557,$f1c71e,$e38e3a,$d55557
		dc	$000000,$e38e3a,$d55557,$0e38e3,$e38e3a,$d55557,$1c71c7,$e38e3a,$d55557,$2aaaaa,$e38e3a,$d55557
		dc	$38e38e,$e38e3a,$d55557,$c71c73,$f1c71e,$d55557,$d55557,$f1c71e,$d55557,$e38e3a,$f1c71e,$d55557
		dc	$f1c71e,$f1c71e,$d55557,$000000,$f1c71e,$d55557,$0e38e3,$f1c71e,$d55557,$1c71c7,$f1c71e,$d55557
		dc	$2aaaaa,$f1c71e,$d55557,$38e38e,$f1c71e,$d55557,$c71c73,$000000,$d55557,$d55557,$000000,$d55557
		dc	$e38e3a,$000000,$d55557,$f1c71e,$000000,$d55557,$000000,$000000,$d55557,$0e38e3,$000000,$d55557
		dc	$1c71c7,$000000,$d55557,$2aaaaa,$000000,$d55557,$38e38e,$000000,$d55557,$c71c73,$0e38e3,$d55557
		dc	$d55557,$0e38e3,$d55557,$e38e3a,$0e38e3,$d55557,$f1c71e,$0e38e3,$d55557,$000000,$0e38e3,$d55557
		dc	$0e38e3,$0e38e3,$d55557,$1c71c7,$0e38e3,$d55557,$2aaaaa,$0e38e3,$d55557,$38e38e,$0e38e3,$d55557
		dc	$c71c73,$1c71c7,$d55557,$d55557,$1c71c7,$d55557,$e38e3a,$1c71c7,$d55557,$f1c71e,$1c71c7,$d55557
		dc	$000000,$1c71c7,$d55557,$0e38e3,$1c71c7,$d55557,$1c71c7,$1c71c7,$d55557,$2aaaaa,$1c71c7,$d55557
		dc	$38e38e,$1c71c7,$d55557,$c71c73,$2aaaaa,$d55557,$d55557,$2aaaaa,$d55557,$e38e3a,$2aaaaa,$d55557
		dc	$f1c71e,$2aaaaa,$d55557,$000000,$2aaaaa,$d55557,$0e38e3,$2aaaaa,$d55557,$1c71c7,$2aaaaa,$d55557
		dc	$2aaaaa,$2aaaaa,$d55557,$38e38e,$2aaaaa,$d55557,$c71c73,$38e38e,$d55557,$d55557,$38e38e,$d55557
		dc	$e38e3a,$38e38e,$d55557,$f1c71e,$38e38e,$d55557,$000000,$38e38e,$d55557,$0e38e3,$38e38e,$d55557
		dc	$1c71c7,$38e38e,$d55557,$2aaaaa,$38e38e,$d55557,$38e38e,$38e38e,$d55557,$c71c73,$c71c73,$e38e3a
		dc	$d55557,$c71c73,$e38e3a,$e38e3a,$c71c73,$e38e3a,$f1c71e,$c71c73,$e38e3a,$000000,$c71c73,$e38e3a
		dc	$0e38e3,$c71c73,$e38e3a,$1c71c7,$c71c73,$e38e3a,$2aaaaa,$c71c73,$e38e3a,$38e38e,$c71c73,$e38e3a
		dc	$c71c73,$d55557,$e38e3a,$d55557,$d55557,$e38e3a,$e38e3a,$d55557,$e38e3a,$f1c71e,$d55557,$e38e3a
		dc	$000000,$d55557,$e38e3a,$0e38e3,$d55557,$e38e3a,$1c71c7,$d55557,$e38e3a,$2aaaaa,$d55557,$e38e3a
		dc	$38e38e,$d55557,$e38e3a,$c71c73,$e38e3a,$e38e3a,$d55557,$e38e3a,$e38e3a,$e38e3a,$e38e3a,$e38e3a
		dc	$f1c71e,$e38e3a,$e38e3a,$000000,$e38e3a,$e38e3a,$0e38e3,$e38e3a,$e38e3a,$1c71c7,$e38e3a,$e38e3a
		dc	$2aaaaa,$e38e3a,$e38e3a,$38e38e,$e38e3a,$e38e3a,$c71c73,$f1c71e,$e38e3a,$d55557,$f1c71e,$e38e3a
		dc	$e38e3a,$f1c71e,$e38e3a,$f1c71e,$f1c71e,$e38e3a,$000000,$f1c71e,$e38e3a,$0e38e3,$f1c71e,$e38e3a
		dc	$1c71c7,$f1c71e,$e38e3a,$2aaaaa,$f1c71e,$e38e3a,$38e38e,$f1c71e,$e38e3a,$c71c73,$000000,$e38e3a
		dc	$d55557,$000000,$e38e3a,$e38e3a,$000000,$e38e3a,$f1c71e,$000000,$e38e3a,$000000,$000000,$e38e3a
		dc	$0e38e3,$000000,$e38e3a,$1c71c7,$000000,$e38e3a,$2aaaaa,$000000,$e38e3a,$38e38e,$000000,$e38e3a
		dc	$c71c73,$0e38e3,$e38e3a,$d55557,$0e38e3,$e38e3a,$e38e3a,$0e38e3,$e38e3a,$f1c71e,$0e38e3,$e38e3a
		dc	$000000,$0e38e3,$e38e3a,$0e38e3,$0e38e3,$e38e3a,$1c71c7,$0e38e3,$e38e3a,$2aaaaa,$0e38e3,$e38e3a
		dc	$38e38e,$0e38e3,$e38e3a,$c71c73,$1c71c7,$e38e3a,$d55557,$1c71c7,$e38e3a,$e38e3a,$1c71c7,$e38e3a
		dc	$f1c71e,$1c71c7,$e38e3a,$000000,$1c71c7,$e38e3a,$0e38e3,$1c71c7,$e38e3a,$1c71c7,$1c71c7,$e38e3a
		dc	$2aaaaa,$1c71c7,$e38e3a,$38e38e,$1c71c7,$e38e3a,$c71c73,$2aaaaa,$e38e3a,$d55557,$2aaaaa,$e38e3a
		dc	$e38e3a,$2aaaaa,$e38e3a,$f1c71e,$2aaaaa,$e38e3a,$000000,$2aaaaa,$e38e3a,$0e38e3,$2aaaaa,$e38e3a
		dc	$1c71c7,$2aaaaa,$e38e3a,$2aaaaa,$2aaaaa,$e38e3a,$38e38e,$2aaaaa,$e38e3a,$c71c73,$38e38e,$e38e3a
		dc	$d55557,$38e38e,$e38e3a,$e38e3a,$38e38e,$e38e3a,$f1c71e,$38e38e,$e38e3a,$000000,$38e38e,$e38e3a
		dc	$0e38e3,$38e38e,$e38e3a,$1c71c7,$38e38e,$e38e3a,$2aaaaa,$38e38e,$e38e3a,$38e38e,$38e38e,$e38e3a
		dc	$c71c73,$c71c73,$f1c71e,$d55557,$c71c73,$f1c71e,$e38e3a,$c71c73,$f1c71e,$f1c71e,$c71c73,$f1c71e
		dc	$000000,$c71c73,$f1c71e,$0e38e3,$c71c73,$f1c71e,$1c71c7,$c71c73,$f1c71e,$2aaaaa,$c71c73,$f1c71e
		dc	$38e38e,$c71c73,$f1c71e,$c71c73,$d55557,$f1c71e,$d55557,$d55557,$f1c71e,$e38e3a,$d55557,$f1c71e
		dc	$f1c71e,$d55557,$f1c71e,$000000,$d55557,$f1c71e,$0e38e3,$d55557,$f1c71e,$1c71c7,$d55557,$f1c71e
		dc	$2aaaaa,$d55557,$f1c71e,$38e38e,$d55557,$f1c71e,$c71c73,$e38e3a,$f1c71e,$d55557,$e38e3a,$f1c71e
		dc	$e38e3a,$e38e3a,$f1c71e,$f1c71e,$e38e3a,$f1c71e,$000000,$e38e3a,$f1c71e,$0e38e3,$e38e3a,$f1c71e
		dc	$1c71c7,$e38e3a,$f1c71e,$2aaaaa,$e38e3a,$f1c71e,$38e38e,$e38e3a,$f1c71e,$c71c73,$f1c71e,$f1c71e
		dc	$d55557,$f1c71e,$f1c71e,$e38e3a,$f1c71e,$f1c71e,$f1c71e,$f1c71e,$f1c71e,$000000,$f1c71e,$f1c71e
		dc	$0e38e3,$f1c71e,$f1c71e,$1c71c7,$f1c71e,$f1c71e,$2aaaaa,$f1c71e,$f1c71e,$38e38e,$f1c71e,$f1c71e
		dc	$c71c73,$000000,$f1c71e,$d55557,$000000,$f1c71e,$e38e3a,$000000,$f1c71e,$f1c71e,$000000,$f1c71e
		dc	$000000,$000000,$f1c71e,$0e38e3,$000000,$f1c71e,$1c71c7,$000000,$f1c71e,$2aaaaa,$000000,$f1c71e
		dc	$38e38e,$000000,$f1c71e,$c71c73,$0e38e3,$f1c71e,$d55557,$0e38e3,$f1c71e,$e38e3a,$0e38e3,$f1c71e
		dc	$f1c71e,$0e38e3,$f1c71e,$000000,$0e38e3,$f1c71e,$0e38e3,$0e38e3,$f1c71e,$1c71c7,$0e38e3,$f1c71e

;; Sampling tables.
table_quantizations_01	dc	00,00,01,03,04,05,06,07,08,09,10,11,12,13,14,15
		dc	00,00,01,03,04,05,06,07,08,09,10,11,12,13,14,15
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
		dc	00,00,01,03,04,05,06,07,00,00,00,00,00,00,00,00
table_quantizations_23	dc	00,00,02,04,05,06,07,08,09,10,11,12,13,14,15,16
		dc	00,00,02,04,05,06,07,08,09,10,11,12,13,14,15,16
		dc	00,00,02,04,05,06,07,08,09,10,11,12,13,14,15,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,06,07,08,09,10,11,12,13,16
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,02,03,04,05,16,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00
		dc	00,00,01,16,00,00,00,00,00,00,00,00,00,00,00,00

;; A combination of the x, d and c tables. The `m' stands
;; for the multiplicator using 1.0/x. NOTE: Table c is
;; subtracted by 1.0.
table_xmdc		dc	$000001,$100000,$200000,$2aaaab
		dc	$000003,$080000,$200000,$4ccccd
		dc	$000003,$080000,$100000,$124925
		dc	$000007,$040000,$200000,$638e39
		dc	$000007,$040000,$080000,$088889
		dc	$00000f,$020000,$040000,$042108
		dc	$00001f,$010000,$020000,$020821
		dc	$00003f,$008000,$010000,$010204
		dc	$00007f,$004000,$008000,$008081
		dc	$0000ff,$002000,$004000,$004020
		dc	$0001ff,$001000,$002000,$002008
		dc	$0003ff,$000800,$001000,$001002
		dc	$0007ff,$000400,$000800,$000801
		dc	$000fff,$000200,$000400,$000400
		dc	$001fff,$000100,$000200,$000200
		dc	$003fff,$000080,$000100,$000100
		dc	$007fff,$000040,$000080,$000080

;; The `multiply' table used in the last step of sample
;; requantization. NOTE: All values are divided by two.
table_multiple	dc	$7fffff,$6597fb,$50a28c,$400000
		dc	$32cbfd,$285146,$200000,$1965ff
		dc	$1428a3,$100000,$0cb2ff,$0a1451
		dc	$080000,$065980,$050a29,$040000
		dc	$032cc0,$028514,$020000,$019660
		dc	$01428a,$010000,$00cb30,$00a145
		dc	$008000,$006598,$0050a3,$004000
		dc	$0032cc,$002851,$002000,$001966
		dc	$001429,$001000,$000cb3,$000a14
		dc	$000800,$000659,$00050a,$000400
		dc	$00032d,$000285,$000200,$000196
		dc	$000143,$000100,$0000cb,$0000a1
		dc	$000080,$000066,$000051,$000040
		dc	$000033,$000028,$000020,$000019
		dc	$000014,$000010,$00000d,$00000a
		dc	$000008,$000006,$000005,$000000

table_bits		dc	5,7,3,10,4,5,6,7,8,9
		dc	10,11,12,13,14,15,16

	org X:$3f00
getbits_cntl		dc	0,0,0,0,0,0,0,0
		dc	1,1,1,1,1,1,1,1
		dc	2,2,2,2,2,2,2,2
getbits_mask		dc	$000000,$000001,$000003,$000007
		dc	$00000f,$00001f,$00003f,$00007f
		dc	$0000ff,$0001ff,$0003ff,$0007ff
		dc	$000fff,$001fff,$003fff,$007fff

	org Y:$3f00
		dc	$000001,$000002,$000004,$000008
		dc	$000010,$000020,$000040,$000080
		ds	16
		dc	$000000,$000001,$000002,$000004
		dc	$000008,$000010,$000020,$000040
		dc	$000080,$000100,$000200,$000400
		dc	$000800,$001000,$002000,$004000

	org P:$0000
	jmp	<start

	org P:$000c
	nop

	org P:$10
	movep	X:(r7)+,X:<<M_TX

;;
;; Some macros.
;;
check_rpc	macro
	jsset	#0,X:<<M_HSR,rpc
	endm

check_pause	macro
	jsset	#3,X:$ffe9,pause
	endm

check_fast_forward	macro
	jclr	#4,X:$ffe9,_fast_forward
	do	#20-1,_fast_forward
	jsr	read_frame
	nop
_fast_forward
		endm

;;;;
;;;;
;;;; PROGRAM CODE LOCATED IN INTERNAL MEMORY.
;;;;
;;;;

;;
;; Decoder bootstrap.
;;
	org P:$40
start	;; Default setup.
	jsr	rpc_setup_replay
	jsr	rpc_setup_dma
	jmp	main

;;
;; Inverse modified cosine transform.
;;
;; Takes a 32 word array in r0 as input.
imfct	macro	buffer,delta,result
	move	buffer,r0
	move	delta,n0
	move	result,r3

	;; Perform first butterfly pass.
	move	#decoder_imfct,r1
	move	#decoder_imfct,r5
	move	#0.7071067812,y0   ; cos(pi/4.0)
	move	          X:(r0)+n0,x0
	do	#32/4,_bfy1
	mpyr	 x0,y0,A  X:(r0)+n0,x0
	mpyr	-x0,y0,A  A,X:(r1)+  A,Y:(r5)+
	move	          A,X:(r1)+
	mpyr	 x0,y0,A  X:(r0)+n0,x0
	mpyr	-x0,y0,A  X:(r0)+n0,x0  A,Y:(r5)+
	mpyr	 x0,y0,A  A,X:(r1)+     A,Y:(r5)+
	mpyr	-x0,y0,A  A,X:(r1)+
	move	          X:(r0)+n0,x0  A,Y:(r5)+
_bfy1
	;; Perform second butterfly pass.
	move	#decoder_imfct+0*16,r0
	move	#decoder_imfct+1*16,r4
	move	#decoder_imfct+2*16,r6
	move	#decoder_imfct+3*16,r5
	do	#16,_bfy2
	move	      X:(r0),B   Y:(r4),y0
	add	y0,B  X:(r4),x1  Y:(r0),A
	sub	x1,A  B,X:(r5)   Y:(r0),B
	add	x1,B  X:(r0),A   A,Y:(r5)+
	sub	y0,A  X:(r0),B   B,Y:(r6)
	sub	x1,B  A,X:(r6)+  Y:(r0),A
	sub	y0,A  B,X:(r4)   Y:(r0),B
	add	y0,B  A,Y:(r4)+  X:(r0),A
	add	x1,A  B,Y:(r0)
	move	      A,X:(r0)+
_bfy2
	;; Perform the rest of the butterfly passes.
	move	#8,n0	; Butterflies per group (32>>2).
	move	#4,n2	; Groups per pass (1<<2).

	do	#6-2,_pass
	move	#decoder_imfct,r0
	move	#table_rcosx,r6
	move	#table_rsinx,r1

	do	n2,_grp
	lua	(r0)+n0,r5
	move	r0,r4
	move	r5,r2

	move	                      Y:(r1)+,x0
	move	          X:(r0),B    Y:(r5),y1
	mac	-x0,y1,B  X:(r2)+,x1  Y:(r6)+,y0
	;; Butterfly kernel.
	do	n0,_bfy
	macr	 y0,x1,B  X:(r0),A
	subl	B,A       B,X:(r0)    Y:(r4)+,B
	mac	 y0,y1,B  A,X:(r5)    Y:(r2),y1
	macr	 x0,x1,B              Y:(r0),A
	subl	B,A       X:(r4),B    B,Y:(r0)+
	mac	-x0,y1,B  X:(r2)+,x1  A,Y:(r5)+

_bfy	move	(r0)+n0

_grp	move	n0,B1
	lsr	B      n2,A1   ; Divide butterflies per group by two.
	lsl	A      B1,n0   ; Multiply groups per pass by two.
	move	A1,n2
_pass
	;; Unscrambling and final adjustments.
	move	#decoder_imfct,r0
	move	#table_cosx,r4
	move	#table_sinx,r6
	move	#0,m0	; Bit-reversed addressing.
	move	#64/2,n0
	
	move	X:(r0),x1            Y:(r6)+,y0
	move	Y:(r4)+,y1
	do	#64,_unscramble
	mpy	 y1,x1,A             Y:(r0)+n0,y1
	macr	-y0,y1,A  X:(r0),x1  Y:(r6)+,y0
	move	          A,X:(r3)+  Y:(r4)+,y1
_unscramble	move	#-1,m0	; Linear addressing.
	endm

;;
;; Decode subbands.
;;
decode_subbands
	move	#>decoder_fraction,x0
	move	x0,X:<decoder_imfct_fractionp
	
	do	#3,_tr_loop
	do	X:<frame_channels,_ch_loop
	
	;; Perform inverse fast modified cosine transform.
	imfct	X:<decoder_imfct_fractionp,X:<decoder_imfct_delta,X:<decoder_audiop

	;; Window audio data.
	jsr	window
	
	;; Update pointer to next channel.
	move	      #>3,x0
	move	      X:<decoder_imfct_fractionp,A
	add	x0,A  #>2,x0
	move	      A,X:<decoder_imfct_fractionp

	move	      #>64,y0
	move	      X:<decoder_audiop,B
	add	y0,B
	move	      B,X:<decoder_audiop
	
_ch_loop	;; Update pointer to next triplet and previous channel,
	;; and update audio buffer pointers.
	move	      X:<decoder_audiop,r0
	jclr	#1,X:<frame_channels,_mono_skip
	move	      #>2+3,x0
_mono_skip
	sub	x0,A  X:<decoder_audio_delta,n0
	move	      A,X:<decoder_imfct_fractionp
	move	(r0)-n0
	nop
	move	      X:<decoder_audio_mask,m0
	nop
	nop
	move	(r0)-n0
	move	      r0,X:<decoder_audiop
	move	#-1,m0

_tr_loop	rts

;;
;; Window.
;;
window	;; Setup address registers.
	move	X:<decoder_audiop,r0
	move	X:<decoder_audiop,r1
	move	X:<decoder_pcmp,r2
	
	;; And some corresponding modifiers.
	move	X:<decoder_audio_mask,m0
	move	X:<decoder_audio_mask,m1

	;; Calculate some deltas and modifiers.
	move	      #>32,x0
	move	      X:<decoder_audio_delta,A
	add	x0,A  X:<decoder_audio_delta,B
	move	A,n1
	lsl	B     #table_window,r4
	move	(r1)+n1
	move	B1,n0
	move	B1,n1

	;; Perform windowing.
	do	#32,_sb_loop
	move	         X:(r0)+n0,x0  Y:(r4)+,y0
	mpy	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r0)+n0,x0  Y:(r4)+,y0
	mac	x0,y0,A  X:(r1)+n1,x0  Y:(r4)+,y0
	macr	x0,y0,A  (r0)+
	move	         (r1)+
	move	A,X:(r2)+
_sb_loop
	;; Save pcm address.
	move	r2,X:<decoder_pcmp

	;; Restore registers to linear mode.
	move	#-1,m0
	move	#-1,m1
	rts

;;
;; Copy pcm audio to replay buffers.
;;
copy_replay	move	#>2,x0
	move	X:<frame_channels,A
	cmp	x0,A
	jeq	_stereo

_mono	move	#decoder_pcm,r0
	move	X:<replay_logic,r1
	do	#1152,_copy_mono
	move	   X:(r0)+,A
	asl	A
	asl	A
	asl	A
	move	   A,X:(r1)+
	move	   A,X:(r1)+
_copy_mono	rts

_stereo	move	#decoder_pcm+0*32,r0	; Left.
	move	#decoder_pcm+1*32,r1	; Right.
	move	X:<replay_logic,r2
	move	#32-1,n0
	move	#32-1,n1
	move	#>$000080,x0	;; Rounding.

	do	#3*12,_copy_stereo

	move	   X:(r0)+,A
	asl	A  X:(r1)+,y0
	do	#32,_copy_mix
	asl	A  y0,B
	asl	A  X:(r0)+,y0
	add	x0,A	;; Rounding.
	asl	B  A,X:(r2)+
	asl	B  y0,A
	asl	B  X:(r1)+,y0
	add	x0,B	;; Rounding.
	asl	A  B,X:(r2)+
_copy_mix	move	(r0)+n0
	move	(r1)+n1

_copy_stereo	rts

;;
;; Read arbitrary (1-16) number of bits
;; from the frame buffer.
;;
getbits	move	x0,n5
	move	x0,n4
	move	#>$7,A
	and	x0,A     X:(r5+n5),n6
	move	A1,n5
	move	         X:(r6)+n6,A
	lsr	A        Y:(r5),y1
	move	A1,x1
	mpy	x1,y1,A  Y:(r4+n4),y1
	move	#8-1,m5
	move	A0,x1
	mpy	x1,y1,A  X:(r4+n4),x1
	and	x1,A     (r5)+n5
	move	A1,A
	move	#-1,m5
	rts

;;
;; Decode samples.
;;
decode_samples
	check_rpc

	jsr	getbits_init
	
	move	#decoder_bitalloc,r0
	move	#decoder_fraction,r1
	move	#2,n1
	move	X:<decoder_quantizations,r2
	move	#16,n2

	move	X:<frame_jsbound,A
	asl	A  X:<decoder_scalefactor_granule,x0
	move	   x0,X:<decoder_sfp
	move	A,X:<decoder_joint_countdown

	do	X:<frame_sblimit,_sb_loop
	do	X:<frame_channels,_ch_loop
	;; Update joint-stereo counter and check bitalloc.
	move	#>1,x0
	move	      X:<decoder_joint_countdown,B
	sub	x0,B  X:(r0)+,A
	tst	A     B,X:<decoder_joint_countdown
	jne	_samples

_zero	;; Fill with zeroes.
	clr	A
	move	A,X:(r1)+
	move	A,X:(r1)+
	move	A,X:(r1)+
	jmp	_resume

_samples	;; Check if joint-stereo applies.
	jclr	#23,X:<decoder_joint_countdown,_no_joint
	jset	#0,X:<decoder_joint_countdown,_no_joint

_joint	;; Copy old samples for joint-stereo.
	move	#decoder_old_samples,r3
	nop
	move	X:(r3)+,x0
	move	x0,X:(r1)+
	move	X:(r3)+,x0
	move	x0,X:(r1)+
	move	X:(r3)+,x0
	move	x0,X:(r1)-n1
	jmp	_scalefactor_adjust

_no_joint	;; Decode samples.
	move	A,n2
	move	#table_bits,r3
	move	Y:(r2+n2),n3	; quantization
	move	#16,n2
	move	Y:(r3+n3),x0	; bits

	clr	A     n3,y0
	cmp	y0,A  #>1,A
	jeq	_fetch_grouping
	cmp	y0,A  #>3,A
	jeq	_fetch_grouping
	cmp	y0,A
	jeq	_fetch_grouping

	;; No grouping, fetch triplet.
	move	n3,A
	asl	A
	asl	A  #table_xmdc,r3
	move	A,n3
	nop
	move	(r3)+n3
	move	#3,n3

	do	#3,_tr_loop
	jsr	getbits

	;; Remove greatest bit and check
	;; if the accumulator should be 0.0 or -1.0.
	clr	B     A,x1  Y:(r3)+,y0   ; x
	and	y0,A  #-0.5,y1
	cmp	x1,A  A,x1  Y:(r3)+,y0   ; m
	teq	y1,B

	;; Add constant `d', multiply with
	;; the inverse, thus normalize sample,
	;; and multiply with the constant `c'.
	mpy	y0,x1,A  Y:(r3)+,y0     ; d
	add	y0,B     A0,y1
	add	y1,B     Y:(r3)-n3,y0   ; c
	move	         B,y1
	macr	y0,y1,B	; Remember that c is subtracted by 1.0!
	move	B,X:(r1)+
_tr_loop
	move	(r1)-n1
	move	(r1)-

_scalefactor_adjust
	;; Multiply samples with the
	;; corresponding scalefactors.
	move	X:<decoder_sfp,r3
	move	#3,n3
	nop
	move	X:(r3)+n3,n3
	move	r3,X:<decoder_sfp
	move	#table_multiple,r3
	move	         X:(r1)+,x1
	move                   Y:(r3+n3),y0
	move	#decoder_old_samples,r3
	mpyr	x1,y0,A  X:(r1)-,x0
	move	         x1,X:(r3)+   ; Old samples.
	move	         x0,X:(r3)+   ; Old samples.
	mpyr	x0,y0,A  A,X:(r1)+n1
	move	         X:(r1)-,x0
	move	         x0,X:(r3)+   ; Old samples.
	mpyr	x0,y0,A  A,X:(r1)+
	move	         A,X:(r1)+

_resume	nop
_ch_loop	move	(r2)+n2	; Update next to quantization.
_sb_loop	jsr	getbits_exit
	rts

_fetch_grouping
	;; Fetch grouped triplet.
	move	#table_grouping,r3
	jsr	getbits
	move	Y:(r3+n3),r3
	asl	A     A,x0
	add	x0,A
	move	A,n3
	nop
	move	(r3)+n3
	move	Y:(r3)+,x0
	move	x0,X:(r1)+
	move	Y:(r3)+,x0
	move	x0,X:(r1)+
	move	Y:(r3)+,x0
	move	x0,X:(r1)-n1
	jmp	_scalefactor_adjust

;;;;
;;;;
;;;; PROGRAM CODE LOCATED IN EXTERNAL MEMORY.
;;;;
;;;;
	org P:$300

;;
;; Decode scales.
;;
decode_scales	jsr	getbits_init

	;;
	;; Fetch bit allocation table.
	;;
	clr	B	; scfsis
	move	X:<decoder_nbals,r0
	move	#decoder_bitalloc,r1
	
	;; Stereo, dual channel and mono.
	move	Y:(r0)+,y0	; nbal
	do	X:<frame_jsbound,_sb_loop0
	do	X:<frame_channels,_ch_loop0
	move	y0,x0
	jsr	getbits	; Read nbal bits.
	move	     #>1,x1
	add	x1,B   B,x1
	tst	A           A,X:(r1)+
	teq	x1,B
_ch_loop0	move	Y:(r0)+,y0	; nbal
_sb_loop0
	;; Joint-stereo.
	move	X:<frame_sblimit,A
	move	X:<frame_jsbound,x0
	sub	x0,A	; Check if joint-
	jeq	_sb_loop1	; stereo is applicable.
	do	A,_sb_loop1
	move	y0,x0
	jsr	getbits	; Read nbal bits.
	move	     #>2,x1
	add	x1,B   A,X:(r1)+  B,y0
	tst	A      A,X:(r1)+
	teq	y0,B
	move	Y:(r0)+,y0	; nbal
_sb_loop1
	move	B,X:<decoder_scfsis

	;;
	;; Fetch scalefactor selection information.
	;;
	move	#decoder_scfsi,r0
	do	B,_sf_loop0
	move	#>2,x0
	jsr	getbits
	move	A,X:(r0)+
_sf_loop0
	;;
	;; Fetch scale factors.
	;;
	move	#decoder_scfsi,r0
	move	#decoder_scalefactor,r1
	do	B,_sf_loop1
	move	X:(r0)+,y0
	move	      #>0,A

_c0	cmp	y0,A  #>1,A
	jne	_c1
	move	#>6,x0
	jsr	getbits
	move	A,X:(r1)+
	jsr	getbits
	move	A,X:(r1)+
	jsr	getbits
	move	A,X:(r1)+
	jmp	_resume

_c1	cmp	y0,A  #>2,A
	jne	_c2
	move	#>6,x0
	jsr	getbits
	move	A,X:(r1)+
	move	A,X:(r1)+
	jsr	getbits
	move	A,X:(r1)+
	jmp	_resume

_c2	cmp	y0,A
	jne	_c3
	move	#>6,x0
	jsr	getbits
	move	A,X:(r1)+
	move	A,X:(r1)+
	move	A,X:(r1)+
	jmp	_resume

_c3	move	#>6,x0
	jsr	getbits
	move	A,X:(r1)+
	jsr	getbits
	move	A,X:(r1)+
	move	A,X:(r1)+

_resume	nop	
_sf_loop1
	jsr	getbits_exit
	rts

;;
;; Decode a granule.
;;
;; This is a macro in order to avoid using
;; too much stack-space. The cosine transform
;; consumes 3 nested do-loops, which added
;; with decoder_subbands becomes 5. The
;; maximum allowed level is 7.
decode_granule	macro
	move	x0,X:<decoder_scalefactor_granule
	jsr	decode_samples
	jsr	decode_subbands
	jsr	decode_samples
	jsr	decode_subbands
	jsr	decode_samples
	jsr	decode_subbands
	jsr	decode_samples
	jsr	decode_subbands
		endm

decode_frame	;; Read the whole frame
	;; into main memory.
	check_fast_forward
	jsr	read_frame
	jclr	#0,x0,_bad_frame

	;; Setup some internal parameters.
	jsr	decoder_setup

	;; Decode scale factors.
	jsr	decode_scales

	;; Decode samples and subbands.	
	move	#>decoder_scalefactor+0,x0
	decode_granule
	move	#>decoder_scalefactor+1,x0
	decode_granule
	move	#>decoder_scalefactor+2,x0
	decode_granule

	move	#>1,x0
	rts
_bad_frame	jsr	silence
	rts

;;
;; Zero the fraction array.
;;
decoder_setup	;; Compute audio buffer modifiers.
	move	#>$7ff,x0
	move	#>128,x1
	move	#>2,y0
	move	X:<frame_channels,B
	move	      #>$3ff,A
	cmp	y0,B  #>64,B
	teq	x0,A
	teq	x1,B
	move	A,X:<decoder_audio_mask
	move	B,X:<decoder_audio_delta

	;; Calculate deltas for the cosine transform.
	move	X:<frame_channels,A
	asl	A     A,y0
	add	y0,A
	move	A,X:<decoder_imfct_delta
	
	;; Make sure that the cosine transform
	;; does not get garbage data.
	clr	A #decoder_fraction,r0
	do	#2*32*3,_clear
	move	A,X:(r0)+
_clear
	move	#>decoder_pcm,x0
	move	x0,X:<decoder_pcmp
	rts

;;
;; Methods for start and stop using getbits.
;;
getbits_init	move	#getbits_mask,r4
	move	X:<getbits_cntlp,r5
	move	X:<getbits_framep,r6
	rts

getbits_exit	move	r5,X:<getbits_cntlp
	move	r6,X:<getbits_framep
	rts

;;
;; Read one entire frame into the internal buffers.
;;
;; The following parameters are stored:
;; 
;;   frame       (payload contents of the frame)
;;
;; The internal structure for frame is suited for
;; use with the function getbits.
;;
read_frame	jsr	read_header
	jsr	parse_header
	jclr	#0,x0,_bad_frame

	; Read frame into internal memory.
	; Prepare the structure for getbits.
	clr	A #frame,r0
	jsr	read_stream
	move	x0,y0
	jsr	read_stream
	move	x0,x1
	jsr	read_stream
	move	x0,A0
	move	y0,x0
	move	        #>$008000,y0
	mac	x0,y0,A #>$000080,y0
	mac	x1,y0,A X:<frame_payload_size,B
	move	A0,X:(r0)+

	move	#>3,y1
	sub	y1,B
	do	B,_read
	clr	A A0,x0
	move	x0,y1
	jsr	read_stream
	move	x0,A0
	move	y1,x0
	mac	x0,y0,A
	move	A0,X:(r0)+
_read
	do	#5,_read_finish
	clr	A A0,x0
	move	x0,y1
	move	#0,x0
	move	x0,A0
	move	y1,x0
	mac	x0,y0,A
	move	A0,X:(r0)+
_read_finish
	; Setup getbits pointers.
	move	#getbits_cntl,r5
	move	#frame,r6
	move	r5,X:<getbits_cntlp
	move	r6,X:<getbits_framep
	
	move	#>1,x0
_bad_frame	rts

;;
;; Read header from MPEG stream.
;;
;; The following parameters are stored:
;;
;;   frame_header  (header bits 0-24 of 32)
;;
;; The routine tries to find the
;; syncword by scanning if it is lost.
;;
read_header	; Read 32 bit header (12 sync + 20 status bits) and
	; check that the syncword is correct ('1111 1111 1111').
	jsr	read_stream
	move	        #>$ff,A
	cmp	x0,A
	jne	_sync_lost
	jsr	read_stream
_sync_found	move	        #>$f0,A
	and	x0,A    A,y0
	cmp	y0,A    #>$010000,y0
	jne	_sync_lost
	mpy	x0,y0,A #>$000100,y0
	jsr	read_stream
	mac	x0,y0,A #>$000001,y0
	jsr	read_stream
	mac	x0,y0,A
	asr	A
	move	A0,X:<frame_header
	rts

_sync_lost
_detect_sync	; Try to find the syncword.
	move	#>$ff,y0
_search_ff	jsr	read_stream
	move	x0,A
	and	y0,A
	cmp	y0,A
	jne	_search_ff

	move	#>$f0,y0
_search_f0	jsr	read_stream
	move	x0,A
	and	y0,A
	cmp	y0,A
	jne	_detect_sync

	move	#>$ff,B
	jmp	<_sync_found

;;
;; Parse audio frame header.
;;
parse_header	; Check layer.
	jclr	#HEADER_LAYER+1,X:<frame_header,_bad_frame
	jset	#HEADER_LAYER+0,X:<frame_header,_bad_frame

	; Calculate number of channels and joint-stereo bound.
	move	#>2,x0
	move	#>-1,y0
	jclr	#HEADER_MODE+0,X:<frame_header,_two_channels
	jset	#HEADER_MODE+1,X:<frame_header,_one_channel
_joint	; Compute joint-stereo bound.
	move	#>4,A
	move	#>8,y0
	jclr	#HEADER_EXTMODE+1,X:<frame_header,_no_jadd0
	add	y0,A
_no_jadd0	move	#>4,y0
	jclr	#HEADER_EXTMODE+0,X:<frame_header,_no_jadd1
	add	y0,A
_no_jadd1	move	A,y0
	jmp	_two_channels
_one_channel	move	#>1,x0
_two_channels	move	x0,X:<frame_channels
	move	y0,X:<frame_jsbound
	
	; Set frequency index.
	clr	A     #>$000c00,x0
	move	X:<frame_header,A1
	and	x0,A  #>$002000,x0
	move	A,y0
	mpy	x0,y0,A
	move	A1,X:<frame_frequency

	; Set bitrate index.
	clr	A     #>$00f000,x0
	move	X:<frame_header,A1
	and	x0,A  #>$000800,x0
	move	A,y0
	mpy	x0,y0,A
	move	A1,X:<frame_bitrate
	
	; Set subband-limit and joint-stereo-bound.
	move	#table_nbal_categories,r0
	move	      X:<frame_channels,n0
	move	      X:<frame_frequency,A
	asl	A     Y:(r0+n0),r0
	asl	A     X:<frame_bitrate,x0
	asl	A     #table_sblimits,r1
	asl	A     #table_framesizes,r2
	add	x0,A
	move	A1,n0
	move	A1,n2
	move	Y:(r0+n0),n1
	move	Y:(r0+n0),A   ; Selected nbal category.
	move	Y:(r1+n1),B
	tst	B     B1,X:<frame_sblimit
	jeq	_bad_frame
	move	#>2,x0
	move	      #>table_nbals_01,B
	move	      #>table_quantizations_01,r1
	move	      #>table_quantizations_23,r0
	cmp	x0,A  #>table_nbals_23,x0
	tgt	x0,B  r0,r1
	move	B,X:<decoder_nbals
	move	r1,X:<decoder_quantizations

	; Check frame size.
	move	Y:(r2+n2),A
	tst	A  A,x0
	jeq	_bad_frame

	; Calculate frame size.
	move	#>1,A
	add	x0,A
	btst	#HEADER_PADDING,X:<frame_header
	tcc	x0,A	; Store padding, if applicable.
	move	A,X:<frame_size
	move	#>4,x0	; Remove header size.
	sub	x0,A

	; Take care of any checksums.
	jset	#HEADER_PROTECTION,X:<frame_header,_no_crc
	jsr	read_stream
	jsr	read_stream
	move	#>2,x0
	sub	x0,A
_no_crc
	; Store frame payload size.
	move	A,X:<frame_payload_size

	;; Check if joint-stereo bound is invalid.
	;; If so, set it to the subband limit instead.
	jclr	#23,X:<frame_jsbound,_jsbound_ok
	move	X:<frame_sblimit,x0
	move	x0,X:<frame_jsbound
_jsbound_ok
	move	#>1,x0
	rts
_bad_frame	move	#>0,x0
	rts

;;
;; Main loop.
;;
main	check_pause

	jsr	flipp
	jsr	synchronize
	jsr	decode_frame
	jsr	copy_replay
	jmp	<main

;;
;; Synchronize DMA replay buffers.
;;
synchronize	;; Calculate statistics.
	move	r7,A
	move	X:<replay_logic,x0
	sub	x0,A  #0.0434027778,y0
	move	      #0.0394632991,B
	btst	#0,X:<replay_frequency_conversion
	tcc	y0,B
	move	A,x0
	move	B,y0
	mpyr	x0,y0,A
	
	;; DSP load.
	move	A,X:<replay_dsp_load
	
	;; Average DSP load.
	move	A,y1
	move	         #0.8999,x0
	move	X:<replay_average_dsp_load,y0
	mpy	x0,y0,A  #0.1,x1
	macr	x1,y1,A
	move	A,X:<replay_average_dsp_load

_wait	;; Synchronize.
	check_rpc

	move	#>32,x0
	move	X:<replay_physic,B
	add	x0,B  B,A
	move	r7,x0
	cmp	x0,A
	jpl	_wait
	cmp	x0,B
	jmi	_wait
	rts

;;
;; Flipp active replay buffers.
;;
flipp	move	X:<replay_physic,x0
	move	X:<replay_logic,x1
	move	x1,X:<replay_physic
	move	x0,X:<replay_logic
	rts

;;
;; Silence.
;;
silence	;; Clear audio buffer.
	clr	A  #decoder_audio,r0
	do	#2048,_clear_audio
	move	A,X:(r0)+
_clear_audio
	;; Clear pcm buffer.
	clr	A  #decoder_pcm,r0
	do	#2304,_clear_pcm
	move	A,X:(r0)+
_clear_pcm
	;; Clear replay buffer.
	clr	A  #replay_buffer,r0
	do	#2534,_clear_replay
	move	A,X:(r0)+
	move	A,X:(r0)+
_clear_replay	rts

;;
;; Pause.
;;
pause	jsr	silence
	jset	#3,X:$ffe9,*
	rts

;;
;; DMA handshake and host DSP/030 I/O routines.
;;
Host_get	jclr	#0,X:<<M_HSR,*
	movep	X:<<M_HRX,x0
	rts
Host_send	jclr	#1,X:<<M_HSR,*
	movep	x0,X:<<M_HTX
	rts
Host_send_x0	jclr	#1,X:<<M_HSR,*
	movep	x0,X:<<M_HTX
	rts
Host_send_x1	jclr	#1,X:<<M_HSR,*
	movep	x1,X:<<M_HTX
	rts
Host_send_y0	jclr	#1,X:<<M_HSR,*
	movep	y0,X:<<M_HTX
	rts
Host_send_y1	jclr	#1,X:<<M_HSR,*
	movep	y1,X:<<M_HTX
	rts
Host_send_A	jclr	#1,X:<<M_HSR,*
	movep	A1,X:<<M_HTX
	rts
Host_send_B	jclr	#1,X:<<M_HSR,*
	movep	B1,X:<<M_HTX
	rts
DMA_send	bset	#5,x:<<M_PCD	; start frame sync
	movep	x0,x:<<M_TX
	jclr	#6,x:<<M_SR,*
	bclr	#5,x:<<M_PCD	; stop frame sync
	rts

;;
;; Read one byte of MPEG audio stream from DMA into x0.
;; Only register x0 is affected.
;;
;; Note that the DMA reads 16 bits of data, hence
;; the data is split into two separate bytes.
;;
read_stream	;;; jmp	Host_get

	; Check if there is a stored byte saved.
	move	Y:DMA_r_has_byte,x0
	jset	#0,x0,_have_byte

	; Save used registers.
	move	A,L:DMA_r_save_A
	move	x1,X:DMA_r_save_x1

	; Subtract one word from the number
	; of available words in the stream.
	move	X:<stream_available,A
	move	#>1,x1
	sub	x1,A
	move	A,X:<stream_available

	; Check stream.
_check_stream	jset	#23,X:<stream_available,_underflow

	; Read 16 bits from DMA and
	; perform special bit-shifting
	; to compensate for read skewness.
	bset	#4,X:<<M_PCD        ; Start frame sync.
_wait	jclr	#7,X:<<M_SR,_wait   ; RDF
	bclr	#4,X:<<M_PCD        ; Stop frame sync.
	movep	X:<<M_RX,A
	lsr	A
	lsr	A        Y:DMA_r_state,x0
	or	x0,A     #>$010000,x1
	lsr	A
	move	A1,x0
	mpy	x0,x1,A  #>$ffff,x0
	and	x0,A     A0,Y:DMA_r_state
	move	A1,x0

	; Set byte store flag, store
	; low byte and shift high byte.
	move	#>$ff,A
	move	A,Y:DMA_r_has_byte
	and	x0,A     #>$008000,x1
	mpy	x0,x1,A  A1,Y:DMA_r_stored_byte
	move	A1,x0

	; Restore registers.
	move	L:DMA_r_save_A,A
	move	X:DMA_r_save_x1,x1
	rts
_have_byte	; Read stored byte and clear byte store flag.
	bclr	#0,Y:DMA_r_has_byte
	move	Y:DMA_r_stored_byte,x0
	rts

_underflow	move	r0,X:DMA_r_save_r0
	move	n0,X:DMA_r_save_n0
	move	B,L:DMA_r_save_B
	move	y,L:DMA_r_save_y
	jsr	silence
	check_rpc
	move	X:DMA_r_save_r0,r0
	move	X:DMA_r_save_n0,n0
	move	L:DMA_r_save_B,B
	move	L:DMA_r_save_y,y
	jmp	_check_stream
	

;;
;; Remote procedure calls (RPC) module.
;;
;; RPC calls are made using the RPC table.
rpc	jsr	Host_get
	
	; Check if new frames are available in the stream.
	jset	#23,x0,_rpc_ok
	move	X:<stream_available,A
	add	x0,A
	move	A,X:<stream_available
	rts

_rpc_ok	; Call remote procedure.
	move	#table_rpc-1,r0
	move	x0,n0
	nop
	move	(r0)-n0
	move	Y:(r0),r0
	nop
	jmp	(r0)

;;
;; Debugger.
;;
rpc_debug	jsr	Host_get	; Memory type (x=0, y=1, p=2).
	move	x0,y0
	jsr	Host_get	; Address.
	move	x0,r0
	clr	A    #>0,x0
	move	     #>0,A
_x	cmp	y0,A #>1,A
	jne	_y
	move	X:(r0),x0
_y	cmp	y0,A #>2,A
	jne	_p
	move	Y:(r0),x0
_p	cmp	y0,A
	jne	_nada
	move	P:(r0),x0
_nada	jsr	Host_send	; Value on address.
	rts

;;
;; Call an arbitrary address.
;;
rpc_call	jsr	Host_get
	move	x0,r0
	nop
	jsr	(r0)
	rts

;;
;; Decoder restart.
;;
rpc_restart	move	#0,sp
	jmp	<start

;;
;; DSP acknownledge.
;;
rpc_acknowledge_dsp
	move	#>$6d7032,x0	; Send "mp2".
	jsr	Host_send
	rts

;;
;; DMA acknownledge.
;;
rpc_acknowledge_dma
	;; Read some bytes via DMA.
	move	#>$646d61,B	; Send "dma".
	move	#table_dma_acknowledge,r0
	do	#14,_loop
	jsr	read_stream
	move	Y:(r0)+,y0
	cmp	y0,A  #>0,y0	; Send zero.
	tne	y0,B
_loop	move	B1,x0

	;; Check that the replay loop is up & running.
	move	r7,A
	move	r7,y0
_wait	cmp	y0,A  r7,y0
	jeq	_wait

	;; Acknowledge.
	jsr	Host_send
	rts

;;
;; Setup generic replay.
;;
rpc_setup_replay
	jsr	silence

	; Setup replay registers.
	clr	A  #>0,x0
	move	x0,X:<replay_frequency_conversion
	move	A,X:<replay_average_dsp_load

	move	#replay_buffer,r7
	move	#2*2304-1,m7

	move	#replay_buffer+0*2304,x0
	move	x0,X:<replay_physic
	move	#replay_buffer+1*2304,x0
	move	x0,X:<replay_logic
	rts

;;
;; Setup replay with frequency conversion.
;;
rpc_setup_replay_with_frequency_conversion
	jsr	silence

	; Setup replay registers.
	clr	A  #>1,x0
	move	x0,X:<replay_frequency_conversion
	move	A,X:<replay_average_dsp_load

	move	#replay_buffer,r7
	move	#2*2534-1,m7

	move	#replay_buffer+0*2534,x0
	move	x0,X:<replay_physic
	move	#replay_buffer+1*2534,x0
	move	x0,X:<replay_logic
	rts

;;
;; Setup DMA.
;;
rpc_setup_dma	movep	#%000000000,x:<<M_PCC ; SSI reset.
	movep	#%0100000100000000,x:<<M_CRA
	movep	#%0111100000001000,x:<<M_CRB
	movep	#%111100000,x:<<M_PCC ; Port C control register.
	movep	#%000010000,x:<<M_PCDDR
	movep	#%000000000,x:<<M_PCD ; Clear frame syncs.
	movep	#$3000,X:<<M_IPR
	andi	#<$FC,MR
	clr	A
	move	A,X:<stream_available
	rts

;;
;; Statistics, current DSP load.
;;
rpc_dsp_load	move	X:<replay_dsp_load,x0
	jsr	Host_send
	rts

;;
;; Statistics, average DSP load.
;;
rpc_average_dsp_load
	move	X:<replay_average_dsp_load,x0
	jsr	Host_send
	rts

;;
;; Amount of available data in the stream.
;;
rpc_stream_available
	move	X:<stream_available,x0
	jsr	Host_send
	rts

	end
