******************************************
* TRACEUR DE FRACTALES (JULIA ET MANDEL) *
******************************************
	TEXT
SCR	EQU	$70000		* ECRAN 1 (INTERFACE)
SCR2	EQU	$78000		* ECRAN 2 (FRACTALE)

	clr.l	-(sp)
	move.w	#32,-(sp)
	trap	#1
	addq.l	#6,sp
	
	MOVE.W	#$2700,SR

	CLR.B	$FFFF8260.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$0,$FFFF8203.W

	MOVEM.L	IMG+2,D0-D7	* INIT PALETTE
	MOVEM.L	D0-D7,$FFFF8240.W
	
	LEA	SCR,A0		* AFFICHE IMAGE INTERFACE
	LEA	IMG+34,A1
	MOVE.W	#7999,D1
AFF_SCR
	MOVE.L	(A1)+,(A0)+
	DBRA	D1,AFF_SCR

	MOVEQ	#0,D2
	BSR	AFF_COL

	MOVE.W	#256,D0		* INVERSE BOUTON MANDEL
	MOVE.W	#122*160,D1	* (PAR DEFAUT)
	MOVE.W	#308,D2
	MOVE.W	#137*160,D3
	BSR	INVERT

	MOVE.W	#32,D0
	MOVE.W	#70*160,D1
	MOVE.W	#63,D2
	MOVE.W	#85*160,D3
	BSR	INVERT

	BSR	AFF_PARAMS

          LEA	SAVE,A0
          MOVE.L  	$70.w,(A0)+
	MOVE.L  	$118.W,(A0)+
          MOVE.L  	$0120.w,(A0)+
          MOVE.L  	$0134.w,(A0)+
          MOVE.B  	$FFFFFA07.w,(A0)+
          MOVE.B  	$FFFFFA09.w,(A0)+
          MOVE.B  	$FFFFFA13.w,(A0)+
          MOVE.B  	$FFFFFA15.w,(A0)+
          MOVE.B  	$FFFFFA17.w,(A0)+
          MOVE.B  	$FFFFFA19.w,(A0)+
          MOVE.B  	$FFFFFA1F.w,(A0)+
          MOVE.B  	$FFFFFA1B.W,(A0)+
          MOVE.B  	$FFFFFA21.W,(A0)+

          MOVE.B  	#1,$FFFFFA07.W
          MOVE.B  	#1,$FFFFFA13.W
          MOVE.B  	#$40,$FFFA09
          MOVE.B  	#$40,$FFFA15
          BCLR    	#3,$FFFFFA17.W
          MOVE.L  	#NEW_VBL,$70.w
	BSR	INIT_MOUSE
          MOVE    	#$2300,SR

WAIT
	MOVE.W	XMOUSE,D5		* XMOUSE
	MOVE.W	YMOUSE,D6		* YMOUSE
	MOVE.B	BOUTON,D4		* BOUTON
	CMP.B	#4,D4		* BOUTON APPUYE ?
	BNE.S	WAIT

	BSR	TEST_COORDS	* TEST SI SUR UNE BOITE

	CMP.W	#-1,D7		* -1 = PAS FONCTION
	BEQ.S	WAIT

	CMP.W	#35*8,D7		* CLIQUE SUR QUIT ?
	BEQ	QUIT

	LSR.W	#1,D7
	MOVE.W	D7,FONCTION

WAIT_2
	CMP.B	#4,BOUTON
	BEQ	WAIT_2
	
	LEA	TAB_FONC,A0
	MOVE.W	FONCTION,D7
	MOVE.L	(A0,D7.W),A1
	JSR	(A1)

	BRA	WAIT

AFF_PARAMS
	MOVE.W	X1,D0		* AFFICHE LES PARAMETRES
	MOVE.W	#4,D1		* D1=Y TEXTE
	MOVE.W	#40,D2		* D2=X TEXT
	BSR	AFF_CHIFF

	MOVE.W	Y1,D0
	MOVE.W	#20,D1		* D1=Y TEXTE
	MOVE.W	#40,D2		* D2=X TEXT
	BSR	AFF_CHIFF

	MOVE.W	PJUL,D0
	MOVE.W	#36,D1		* D1=Y TEXTE
	MOVE.W	#40,D2		* D2=X TEXT
	BSR	AFF_CHIFF

	MOVE.W	X2,D0
	MOVE.W	#4,D1
	MOVE.W	#200,D2
	BSR	AFF_CHIFF

	MOVE.W	Y2,D0
	MOVE.W	#20,D1
	MOVE.W	#200,D2
	BSR	AFF_CHIFF

	MOVE.W	QJUL,D0
	MOVE.W	#36,D1
	MOVE.W	#200,D2
	BSR	AFF_CHIFF
	RTS

TEST_COORDS
	LEA	TAB_CORD,A0
	MOVEQ	#0,D7
TEST_M
	MOVE.W	(A0,D7.W),D0	* X1
	MOVE.W	2(A0,D7.W),D1	* Y1
	MOVE.W	4(A0,D7.W),D2	* X2
	MOVE.W	6(A0,D7.W),D3	* Y2
	CMP.W	D5,D0
	BGT.S	PAS_GOOD
	CMP.W	D5,D2
	BLT.S	PAS_GOOD
	CMP.W	D6,D1
	BGT.S	PAS_GOOD
	CMP.W	D6,D3
	BLT.S	PAS_GOOD
	BRA.S	OK
PAS_GOOD
	ADDQ.W	#8,D7
	CMP.W	#45*8,D7
	BNE.S	TEST_M
	MOVE.W	#-1,D7
OK
	RTS
QUIT
	      MOVE    #$2700,SR
                LEA     SAVE,A0
                MOVE.L  (A0)+,$70.w
	      MOVE.L  (A0)+,$118.W
                MOVE.L  (A0)+,$0120.w
                MOVE.L  (A0)+,$0134.w
                MOVE.B  (A0)+,$FFFFFA07.w
                MOVE.B  (A0)+,$FFFFFA09.w
                MOVE.B  (A0)+,$FFFFFA13.w
                MOVE.B  (A0)+,$FFFFFA15.w
                MOVE.B  (A0)+,$FFFFFA17.w
                MOVE.B  (A0)+,$FFFFFA19.w
                MOVE.B  (A0)+,$FFFFFA1F.w
                MOVE.B  (A0)+,$FFFFFA1B.w
                MOVE.B  (A0)+,$FFFFFA21.w

	MOVE.W	#$3FFF,D1
BC_NOP
	DIVU	#1,D0
	DBRA	D1,BC_NOP

	MOVE.B	#$8,$FFFC02
	
	MOVEM.L	OLD_PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	ILLEGAL

NEW_VBL
	MOVE.B	#$D,$FFFC02
	MOVE.W	#1,VBL_FLAG
	CLR.B	$FFFFFA1B.W
	MOVE.B	#70,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#HBL_1,$120.W
	MOVEM.L	D0-D7/A0-A6,-(SP)
	BSR	REST_M
	BSR	AFF_MOUSE
	MOVEM.L	(SP)+,D0-D7/A0-A6
	RTE
VBL_FLAG
	DC.W	0
REST_M
	LEA	BUF,A0
	MOVE.L	(A0)+,A1
	MOVEQ	#5,D6
REST_1
	MOVE.W	(A0)+,6(A1)
	MOVE.W	(A0)+,14(A1)
	LEA	160(A1),A1
	DBRA	D6,REST_1
NULL
	RTS
AFF_MOUSE
	MOVE.W	XMOUSE,D0
	MOVE.W	YMOUSE,D1
PEK_SCR_M
	MOVE.L	#SCR,A0
	LEA	MOUSE_SPR,A1
	LEA	BUF,A2
	MULU	#160,D1
	ADD.W	D1,A0
	MOVE.W	D0,D1
	AND.W	#$FFF0,D0
	LSR.W	#1,D0
	ADD.W	D0,A0
	MOVE.L	A0,(A2)+
	AND.W	#$F,D1
	MOVEQ	#5,D6
AFF_SPRM
	MOVE.W	6(A0),(A2)+
	MOVE.W	14(A0),(A2)+
	MOVE.L	(A1)+,D0
	LSR.L	D1,D0
	EOR.W	D0,14(A0)
	SWAP	D0
	EOR.W	D0,6(A0)
	LEA	160(A0),A0
	DBRA	D6,AFF_SPRM
	RTS
HBL_1
	MOVEM.L	D0-D3,-(SP)
	MOVEM.L	PAL_JULIA,D0-D3
	MOVEM.L	D0-D3,$FFFF8248.W
	MOVEM.L	(SP)+,D0-D3
	CLR.B	$FFFFFA1B.W
	MOVE.B	#14,$FFFFFA21.W
	MOVE.B	#8,$FFFFFA1B.W
	MOVE.L	#HBL_2,$120.W
	RTE
HBL_2
	MOVEM.L	D0-D3,-(SP)
	MOVEM.L	PAL_JULIA+16,D0-D3
	MOVEM.L	D0-D3,$FFFF8248.W
	MOVEM.L	(SP)+,D0-D3
	CLR.B	$FFFFFA1B.W
	RTE
INVERT
	LEA	SCR,A0
	MOVE.L	A0,A1
	ADD.W	D1,A0
	ADD.W	D3,A1
	MOVEQ	#0,D4
	MOVE.W	D0,D4
	AND.W	#$F,D4
	AND.W	#$FFF0,D0
	LSR.W	#1,D0
	ADD.W	D0,A0
	MOVE.W	D2,D5
	AND.W	#$FFF0,D2
	AND.W	#$F,D5
	LSR.W	#1,D2
	ADD.W	D2,A1
	SUB.W	D0,D2
	BEQ.S	MELANGE
	CMP.W	#8,D2
	BEQ	ONLY_ONE
OTHER
	LEA	SCR,A3
	ADD.W	D3,A3
	ADD.W	D0,A3

	LSR.W	#3,D2
	SUBQ	#2,D2
	MOVE	D2,D6

	LEA	TAB_D,A2
	ADD.W	D4,D4
	ADD.W	D5,D5
	MOVE.W	(A2,D4.W),D4
	MOVE.W	(A2,D5.W),D5
	NOT.W	D4

	MOVE.W	D4,D0
	SWAP	D0
	MOVE.W	D4,D0
	MOVE.L	D0,D4
	NOT.L	D4

	MOVE.W	D5,D1
	SWAP	D1
	MOVE.W	D5,D1
	MOVE.L	D1,D5
	NOT.L	D5

LOOP4
	LEA	8(A0),A2
	MOVE.L	(A0),D2
	MOVE.L	D2,D3
	AND.L	D4,D2
	SWAP	D2
	AND.L	D0,D3
	OR.L	D3,D2
	MOVE.L	D2,(A0)

	MOVE	D6,D2
LOOP5
	MOVE.L	(A2),D3
	SWAP	D3
	MOVE.L	D3,(A2)
	ADDQ.L	#8,A2
	DBRA	D2,LOOP5

	MOVE.L	(A2),D2
	MOVE.L	D2,D3
	AND.L	D5,D2
	SWAP	D2
	AND.L	D1,D3
	OR.L	D3,D2
	MOVE.L	D2,(A2)
	
	LEA	160(A0),A0
	CMP.L	A0,A3
	BNE.S	LOOP4
	RTS
	RTS
MELANGE
	LEA	TAB_D,A2
	ADD.W	D4,D4
	ADD.W	D5,D5
	MOVE.W	(A2,D5.W),D5
	MOVE.W	(A2,D4.W),D4
	NOT.W	D4
	EOR.W	D4,D5
	MOVE.W	D5,D0
	SWAP	D0
	MOVE.W	D5,D0
	MOVE.L	D0,D5
	NOT.L	D5
.LOOP
	MOVE.L	(A0),D2
	MOVE.L	D2,D1
	AND.L	D5,D2
	SWAP	D2
	AND.L	D0,D1
	OR.L	D2,D1
	MOVE.L	D1,(A0)
	LEA	160(A0),A0
	CMP.L	A0,A1
	BNE.S	.LOOP
	RTS
ONLY_ONE
	SUBQ	#8,A1
	LEA	TAB_D,A2
	ADD.W	D4,D4
	ADD.W	D5,D5
	MOVE.W	(A2,D4.W),D4
	MOVE.W	(A2,D5.W),D5
	NOT.W	D4

	MOVE.W	D4,D0
	SWAP	D0
	MOVE.W	D4,D0
	MOVE.L	D0,D4
	NOT.L	D4

	MOVE.W	D5,D1
	SWAP	D1
	MOVE.W	D5,D1
	MOVE.L	D1,D5
	NOT.L	D5
.LOOP2
	MOVE.L	(A0),D2
	MOVE.L	D2,D3
	AND.L	D4,D2
	SWAP	D2
	AND.L	D0,D3
	OR.L	D3,D2
	MOVE.L	D2,(A0)

	MOVE.L	8(A0),D2
	MOVE.L	D2,D3
	AND.L	D5,D2
	SWAP	D2
	AND.L	D1,D3
	OR.L	D3,D2
	MOVE.L	D2,8(A0)
	LEA	160(A0),A0
	CMP.L	A0,A1
	BNE.S	.LOOP2
	RTS

SEL_COLX
	MOVE.W	FONCTION,D7
	SUB.W	#48,D7
	LSR.W	#1,D7
	MOVE.W	CUR_COL,D6
	CMP.W	D6,D7
	BEQ.S	FIN_SEL_COLX
	MOVE.L	D7,-(SP)
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT
	MOVE.W	CUR_COL,D7
	LSL.W	#2,D7
	ADD.W	#12*8,D7
	LEA	TAB_CORD,A0
	ADD.W	D7,A0
	MOVE.W	(A0)+,D0
	MOVE.W	(A0)+,D1
	MOVE.W	(A0)+,D2
	MOVE.W	(A0)+,D3
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT
	MOVE.L	(SP)+,D7
	MOVE.W	D7,CUR_COL
	LEA	PAL_JULIA,A0
	MOVE.W	(A0,D7.W),D2
	BSR	AFF_COL
FIN_SEL_COLX
	RTS
CUR_COL
	DC.W	0
SEL_JULIA
	CMP.B	#'J',TYPE
	BEQ.S	RIEN_1
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	#256,D0
	MOVE.W	#122*160,D1
	MOVE.W	#308,D2
	MOVE.W	#137*160,D3
	BSR	INVERT
	MOVE.B	#'J',TYPE
RIEN_1
	RTS
SEL_MANDEL
	CMP.B	#'M',TYPE
	BEQ.S	RIEN_2
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT
	MOVE.W	#16,D0
	MOVE.W	#122*160,D1
	MOVE.W	#56,D2
	MOVE.W	#137*160,D3
	BSR	INVERT
	MOVE.B	#'M',TYPE
RIEN_2
	RTS

VIEW
	MOVE.W	#$2700,SR
	MOVE.L	#$78000,PEK_SCR_M+2
	MOVE.L	#VBL_FRAC2,$70.W
	MOVE.W	#$2300,SR
	MOVE.W	#0,VBL_FLAG
WAIT_MCS_EN_SUEDE2
	TST.W	VBL_FLAG
	BEQ.S	WAIT_MCS_EN_SUEDE2

	MOVEM.L	PAL_JULIA,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$80,$FFFF8203.W

WAIT_MAG2
	CMP.B	#8,BOUTON
	BNE.S	WAIT_MAG2

	MOVEM.L	IMG+2,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$0,$FFFF8203.W

	MOVE.W	#$2700,SR
	MOVE.L	#$70000,PEK_SCR_M+2
	MOVE.L	#NEW_VBL,$70.W
	MOVE.W	#$2300,SR

	RTS


ZOOM
	MOVE.W	#$2700,SR
	MOVE.L	#$78000,PEK_SCR_M+2
	MOVE.L	#VBL_FRAC2,$70.W
	MOVE.W	#$2300,SR
	MOVE.W	#0,VBL_FLAG
WAIT_MCS_EN_SUEDE
	TST.W	VBL_FLAG
	BEQ.S	WAIT_MCS_EN_SUEDE

	MOVEM.L	PAL_JULIA,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$80,$FFFF8203.W

WAIT_MAG
	CMP.B	#4,BOUTON
	BNE.S	WAIT_MAG

	MOVE.W	XMOUSE,D0
	MOVE.W	INCX,D1
	MULU	D1,D0
	ADD.W	X1,D0
	MOVE.W	D0,D4

	MOVE.W	YMOUSE,D0
	MOVE.W	INCY,D1
	MULU	D1,D0
	ADD.W	Y1,D0
	MOVE.W	D0,D5
WAIT_MAG3
	CMP.B	#8,BOUTON
	BNE.S	WAIT_MAG3

	MOVE.W	XMOUSE,D0
	MOVE.W	INCX,D1
	MULU	D1,D0
	ADD.W	X1,D0
	MOVE.W	D0,X2

	MOVE.W	YMOUSE,D0
	MOVE.W	INCY,D1
	MULU	D1,D0
	ADD.W	Y1,D0
	MOVE.W	D0,Y2
	MOVE.W	D4,X1
	MOVE.W	D5,Y1

	MOVEM.L	IMG+2,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	BSR	AFF_PARAMS

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$0,$FFFF8203.W

	MOVE.W	#$2700,SR
	MOVE.L	#$70000,PEK_SCR_M+2
	MOVE.L	#NEW_VBL,$70.W
	MOVE.W	#$2300,SR

	RTS

VBL_FRAC2
	MOVE.W	#1,VBL_FLAG
	MOVE.B	#$D,$FFFC02
	MOVEM.L	D0-D7/A0-A6,-(SP)
	BSR	REST_M
	BSR	AFF_MOUSE
	MOVEM.L	(SP)+,D0-D7/A0-A6
	RTE

P_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	PJUL,D7		* D7=CHIFFRE
	MOVE.W	#1700*8,D6	* D6=MAX
	MOVE.W	#36,D1		* Y
	MOVE.W	#40,D2		* X
	BSR	MAGNUM_PLUS
	MOVE.W	D7,PJUL

	MOVE.W	#22,D0
	MOVE.W	#32*160,D1
	MOVE.W	#35,D2
	MOVE.W	#47*160,D3
	BSR	INVERT
	RTS
P_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	PJUL,D7
	MOVE.W	#-1700*8,D6
	MOVE.W	#36,D1
	MOVE.W	#40,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,PJUL

	MOVE.W	#146,D0
	MOVE.W	#32*160,D1
	MOVE.W	#159,D2
	MOVE.W	#47*160,D3
	BSR	INVERT
	RTS
Q_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	QJUL,D7		* D7=CHIFFRE
	MOVE.W	#1700*8,D6	* D6=MAX
	MOVE.W	#36,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_PLUS
	MOVE.W	D7,QJUL

	MOVE.W	#182,D0
	MOVE.W	#32*160,D1
	MOVE.W	#195,D2
	MOVE.W	#47*160,D3
	BSR	INVERT
	RTS
Q_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	QJUL,D7
	MOVE.W	#-1700*8,D6
	MOVE.W	#36,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,QJUL

	MOVE.W	#306,D0
	MOVE.W	#32*160,D1
	MOVE.W	#319,D2
	MOVE.W	#47*160,D3
	BSR	INVERT
	RTS
Y1_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	Y1,D7		* D7=CHIFFRE
	MOVE.W	#1600*8,D6	* D6=MAX
	MOVE.W	#20,D1
	MOVE.W	#40,D2
	BSR	MAGNUM_PLUS
	MOVE.W	D7,Y1

	MOVE.W	#22,D0
	MOVE.W	#16*160,D1
	MOVE.W	#35,D2
	MOVE.W	#31*160,D3
	BSR	INVERT
	RTS
Y1_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	Y1,D7
	MOVE.W	#-1600*8,D6
	MOVE.W	#20,D1
	MOVE.W	#40,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,Y1

	MOVE.W	#146,D0
	MOVE.W	#16*160,D1
	MOVE.W	#159,D2
	MOVE.W	#31*160,D3
	BSR	INVERT
	RTS
Y2_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	Y2,D7		* D7=CHIFFRE
	MOVE.W	#1600*8,D6	* D6=MAX
	MOVE.W	#20,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_PLUS
	MOVE.W	D7,Y2

	MOVE.W	#182,D0
	MOVE.W	#16*160,D1
	MOVE.W	#195,D2
	MOVE.W	#31*160,D3
	BSR	INVERT
	RTS
Y2_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	Y2,D7
	MOVE.W	#-1600*8,D6
	MOVE.W	#20,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,Y2

	MOVE.W	#306,D0
	MOVE.W	#16*160,D1
	MOVE.W	#319,D2
	MOVE.W	#31*160,D3
	BSR	INVERT
	RTS
X1_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	X1,D7		* D7=CHIFFRE
	MOVE.W	#1600*8,D6	* D6=MAX
	MOVE.W	#4,D1
	MOVE.W	#40,D2
	BSR	MAGNUM_PLUS
	MOVE.W	D7,X1

	MOVE.W	#22,D0
	MOVE.W	#0,D1
	MOVE.W	#35,D2
	MOVE.W	#15*160,D3
	BSR	INVERT
	RTS
X1_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	X1,D7
	MOVE.W	#-1600*8,D6
	MOVE.W	#4,D1
	MOVE.W	#40,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,X1

	MOVE.W	#146,D0
	MOVE.W	#0,D1
	MOVE.W	#159,D2
	MOVE.W	#15*160,D3
	BSR	INVERT
	RTS
X2_PLUS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	X2,D7		* D7=CHIFFRE
	MOVE.W	#1600*8,D6	* D6=MAX
	MOVE.W	#4,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_PLUS
	MOVE.W	D7,X2

	MOVE.W	#182,D0
	MOVE.W	#0,D1
	MOVE.W	#195,D2
	MOVE.W	#15*160,D3
	BSR	INVERT
	RTS
X2_MOINS
	MULU	#160,D1
	MULU	#160,D3
	BSR	INVERT

	MOVE.W	X2,D7
	MOVE.W	#-1600*8,D6
	MOVE.W	#4,D1
	MOVE.W	#200,D2
	BSR	MAGNUM_MOINS
	MOVE.W	D7,X2

	MOVE.W	#306,D0
	MOVE.W	#0,D1
	MOVE.W	#319,D2
	MOVE.W	#15*160,D3
	BSR	INVERT
	RTS

MAGNUM_PLUS
	CMP.B	#$36,KEY
	BEQ	P_PL_FAST
P_PL_SLOW
	TST.W	VBL_FLAG
	BEQ.S	P_PL_SLOW
	MOVE.W	#0,VBL_FLAG

	CMP.W	D6,D7
	BGE.S	FIN_PPLUS_SLOW
	ADDQ.W	#8,D7

	MOVEQ	#0,D0
	MOVE.W	D7,D0
	MOVEM.L	D1-D2/D6-D7,-(SP)
	BSR	AFF_CHIFF
	MOVEM.L	(SP)+,D1-D2/D6-D7

	CMP.B	#$2A,KEY
	BEQ.S	P_PL_SLOW
FIN_PPLUS_SLOW
	RTS
P_PL_FAST
	TST.W	VBL_FLAG
	BEQ.S	P_PL_FAST
	MOVE.W	#0,VBL_FLAG

	CMP.W	D6,D7
	BGE.S	FIN_PPLUS_FAST
	ADD.W	#80,D7

	MOVEQ	#0,D0
	MOVE.W	D7,D0
	MOVEM.L	D1-D2/D6-D7,-(SP)
	BSR	AFF_CHIFF
	MOVEM.L	(SP)+,D1-D2/D6-D7

	CMP.B	#$36,KEY
	BEQ.S	P_PL_FAST
FIN_PPLUS_FAST
	RTS

MAGNUM_MOINS
	CMP.B	#$36,KEY
	BEQ	P_MO_FAST
P_MO_SLOW
	TST.W	VBL_FLAG
	BEQ.S	P_MO_SLOW
	MOVE.W	#0,VBL_FLAG

	CMP.W	D6,D7
	BLE.S	FIN_PMOINS_SLOW
	SUBQ.W	#8,D7

	MOVEQ	#0,D0
	MOVE.W	D7,D0
	MOVEM.L	D1-D2/D6-D7,-(SP)
	BSR	AFF_CHIFF
	MOVEM.L	(SP)+,D1-D2/D6-D7

	CMP.B	#$2A,KEY
	BEQ.S	P_MO_SLOW
FIN_PMOINS_SLOW
	RTS
P_MO_FAST
	TST.W	VBL_FLAG
	BEQ.S	P_MO_FAST
	MOVE.W	#0,VBL_FLAG

	CMP.W	D6,D7
	BLE.S	FIN_PMOINS_FAST
	SUB.W	#80,D7

	MOVEQ	#0,D0
	MOVE.W	D7,D0
	MOVEM.L	D1-D2/D6-D7,-(SP)
	BSR	AFF_CHIFF
	MOVEM.L	(SP)+,D1-D2/D6-D7

	CMP.B	#$36,KEY
	BEQ.S	P_MO_FAST
FIN_PMOINS_FAST
	RTS
AFF_CHIFF
	LEA	CHIF_TO_PRINT,A1
	MOVE.W	D2,X_TXT
	TST.W	D0
	BPL	D0_POSITIF
	NOT.W	D0
	MOVE.W	#13,(A1)+
	BRA.S	SUITE_CHIFF
D0_POSITIF
	MOVE.W	#14,(A1)+
SUITE_CHIFF
	DIVU	#8,D0
	LEA	SCR,A0
	MULU	#160,D1
	ADD.W	D1,A0
	MOVE.W	D0,D1
	DIVU	#1000,D1
	MOVE.W	D1,(A1)+
	MOVE.W	#10,(A1)+
	MULU	#1000,D1
	SUB.W	D1,D0
	MOVE.W	D0,D1
	DIVU	#100,D1
	MOVE.W	D1,(A1)+
	MULU	#100,D1
	SUB.W	D1,D0
	MOVE.W	D0,D1
	DIVU	#10,D1
	MOVE.W	D1,(A1)+
	MULU	#10,D1
	SUB.W	D1,D0
	MOVE.W	D0,D1
	MOVE.W	D1,(A1)+
	LEA	CHIF_TO_PRINT,A1
	LEA	FNT_09,A2
	MOVEQ	#5,D6
DO_CHIFF
	MOVE.W	X_TXT,D2
	MOVE.W	D2,D3
	AND.W	#$F,D3
	AND.W	#$FFF0,D2
	LSR.W	#1,D2

	MOVE.W	(A1)+,D0
	MULU	#8*7,D0	* A2+D0=ADRESSE CHIFFRE
	REPT	7
	MOVEM.L	(A2,D0.W),D4-D5
	LSR.L	D3,D4
	LSR.L	D3,D5
	MOVE.L	D4,D7
	OR.L	D5,D7
	NOT.L	D7
	AND.W	D7,8(A0,D2.W)
	AND.W	D7,10(A0,D2.W)
	OR.W	D4,8(A0,D2.W)
	OR.W	D5,10(A0,D2.W)
	SWAP	D7
	SWAP	D4
	SWAP	D5
	AND.W	D7,(A0,D2.W)
	AND.W	D7,2(A0,D2.W)
	OR.W	D4,(A0,D2.W)
	OR.W	D5,2(A0,D2.W)
	ADD.W	#160,D2
	ADD.W	#8,D0
	ENDR
	ADD.W	#7,X_TXT
	DBRA	D6,DO_CHIFF
	RTS
X_TXT
	DC.W	0
CHIF_TO_PRINT
	DS.W	10

R_PLUS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F00,D1
	CMP.W	#$700,D1
	BEQ.S	PAS_R_PLUS
	ADD.W	#$100,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_R_PLUS
	RTS
R_MOINS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F00,D1
	TST.W	D1
	BEQ.S	PAS_R_MOINS
	SUB.W	#$100,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_R_MOINS
	RTS

V_PLUS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
 	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F0,D1
	CMP.W	#$70,D1
	BEQ.S	PAS_V_PLUS
	ADD.W	#$10,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_V_PLUS
	RTS
V_MOINS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F0,D1
	TST.W	D1
	BEQ.S	PAS_V_MOINS
	SUB.W	#$10,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_V_MOINS
	RTS
B_PLUS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F,D1
	CMP.W	#$7,D1
	BEQ.S	PAS_B_PLUS
	ADDQ.W	#$1,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_B_PLUS
	RTS
B_MOINS
	MOVE.W	CUR_COL,D0
	LEA	PAL_JULIA,A0
	ADD.W	D0,A0
	MOVE.W	(A0),D2
	MOVE.W	D2,D1
	AND.W	#$F,D1
	TST.W	D1
	BEQ.S	PAS_V_MOINS
	SUBQ.W	#$1,D2
	MOVE.W	D2,(A0)
	BSR	AFF_COL
PAS_B_MOINS
	RTS
AFF_COL
	MOVEQ	#0,D7
	MOVE.W	D2,D7		* SAUVE COULEUR
	AND.W	#$700,D7		* ISOLE ROUGE
	DIVU	#$100,D7		* PAS ME FAIRE CHIER NON PLUS
	MOVE.W	#106*160,D6	* D6=Y
	LEA	BUF_RED,A3
	BSR	AFF_ASCENCEUR
	MOVEQ	#0,D7
	MOVE.W	D2,D7		* SAUVE COULEUR
	AND.W	#$70,D7		* ISOLE VERT
	DIVU	#$10,D7		* PAS ME FAIRE CHIER NON PLUS
	MOVE.W	#122*160,D6	* D6=Y
	LEA	BUF_GREEN,A3
	BSR	AFF_ASCENCEUR
	MOVEQ	#0,D7
	MOVE.W	D2,D7		* SAUVE COULEUR
	AND.W	#$7,D7		* ISOLE BLEU
	MOVE.W	#138*160,D6	* D6=Y
	LEA	BUF_BLUE,A3
	BSR	AFF_ASCENCEUR
	RTS

AFF_ASCENCEUR
	MOVE.L	A3,A0
	MOVE.L	(A0)+,A1
	MOVEQ	#8,D3
EFF_COL
	MOVEM.L	(A0)+,D4-D5

	MOVE.W	D4,8(A1)
	SWAP	D4
	MOVE.W	D4,(A1)

	MOVE.W	D5,10(A1)
	SWAP	D5
	MOVE.W	D5,2(A1)

	LEA	160(A1),A1
	DBRA	D3,EFF_COL

	MOVE.L	A3,A2
	LEA	SCR,A0
	ADD.W	D6,A0
	LEA	TAB_X_ASC,A1
	ADD.W	D7,D7
	MOVE.W	(A1,D7.W),D7	* X ASCENCEUR
	MOVEQ	#0,D6
	MOVE.W	D7,D6
	AND.W	#$FFF0,D7
	LSR.W	#1,D7
	ADD.W	D7,A0
	MOVE.L	A0,(A2)+
	AND.W	#$F,D6
	LEA	ASCENCEUR,A1
	MOVEQ	#8,D5
DO_ASC
	MOVE.W	(A0),D0
	SWAP	D0
	MOVE.W	8(A0),D0
	MOVE.W	2(A0),D1
	SWAP	D1
	MOVE.W	10(A0),D1
	MOVEM.L	D0-D1,(A2)
	ADDQ.L	#8,A2
	MOVEM.L	(A1)+,D0-D1
	LSR.L	D6,D0
	LSR.L	D6,D1

	MOVE.L	D0,D3
	OR.L	D1,D3
	NOT.L	D3
	AND.W	D3,8(A0)
	AND.W	D3,10(A0)
	SWAP	D3
	AND.W	D3,(A0)
	AND.W	D3,2(A0)

	OR.W	D0,8(A0)
	SWAP	D0
	OR.W	D0,(A0)
	OR.W	D1,10(A0)
	SWAP	D1
	OR.W	D1,2(A0)
	LEA	160(A0),A0
	DBRA	D5,DO_ASC
	RTS
INIT_COORDS
	MOVE.W	#-1600*8,X1
	MOVE.W	#1600*8,X2
	MOVE.W	#-8000,Y1
	MOVE.W	#8000,Y2
	BSR	AFF_PARAMS
	RTS

************ FRACTAL PART **********
LIG_MAX	EQU	199
COL_MAX	EQU	319
LIMI	EQU	32

DRAW_FRACT
	MOVE.W	#0,ABORT

	MOVE.W	#$2700,SR
	MOVE.L	#VBL_FRAC,$70.W
	MOVE.W	#$2300,SR

	BSR.S	INIT

	CMP.B	#'M',TYPE
	BEQ.S	DO_MANDEL
	BSR	JULIA
	BRA.S	WAIT_FR
DO_MANDEL
	BSR	MANDEL
WAIT_FR
	CMP.B	#$39,$FFFC02
	BNE.S	WAIT_FR

	MOVEM.L	IMG+2,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$0,$FFFF8203.W

	MOVE.W	#$2700,SR
	MOVE.L	#NEW_VBL,$70.W
	MOVE.W	#$2300,SR

	RTS
INIT
	LEA	SCR2,A0
	MOVEQ	#0,D0
	MOVE.W	#7999,D1
EFF_SCR2
	MOVE.L	D0,(A0)+
	DBRA	D1,EFF_SCR2

	MOVE.W	PJUL,P * -940   300  -200 -1300
	MOVE.W	QJUL,Q	 * -300  -630  -899    90

	MOVE.W	X2,D0
	SUB.W	X1,D0
	DIVU	#320,D0
	MULU	#320,D0
	DIVU	#320,D0
	MOVE.W	D0,INCX
	MOVE.W	Y2,D0
	SUB.W	Y1,D0
	DIVU	#200,D0
	MOVE.W	D0,INCY

	MOVEM.L	PAL_JULIA,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W

	MOVE.B	#$7,$FFFF8201.W
	MOVE.B	#$80,$FFFF8203.W

	RTS

JULIA
	LEA	SCR2,A2
	LEA	TAB_160(PC),A3
	MOVEQ	#0,D7	* D7=COLONNE
WHILE_1
	CMP.W	#COL_MAX,D7
	BGT.S	WEND1

	MOVEQ	#0,D6		* D6=LIGNE
WHILE_2
	CMP.W	#LIG_MAX,D6
	BGT.S	WEND2
	MOVEQ	#0,D0
	MOVE.W	INCX(PC),D0
	MULS	D7,D0
	ADD.W	X1(PC),D0		* D0=X*100=(X1+COLONNE*INCX)*100

	MOVEQ	#0,D1
	MOVE.W	INCY(PC),D1
	MULS	D6,D1
	ADD.W	Y1(PC),D1		* D1=Y*100=(Y1+LIGNE*INCY)*100

	MOVEQ	#0,D2
	MOVEQ	#0,D4
WHILE_3
	CMP.W	#LIMI,D2
	BGT.S	WEND3
	CMP.L	#32000,D4
	BGT.S	WEND3

	MOVE.L	D0,D4		* 	D4=AUX
	MOVE.L	D1,D5
	ADD.L	D4,D5		* X+Y
	SUB.L	D1,D0		* X-Y
	MULS	D5,D0		* (X+Y)*(X-Y)
	LSR.L	#7,D0
	LSR.L	#6,D0

	ADD.W	P(PC),D0		* D0=(X*X-Y*Y+P)*100

	MULS	D4,D1		* D1=Y*AUX
	LSR.L	#7,D1
	LSR.L	#5,D1
	ADD.W	Q(PC),D1

	MOVE.L	D1,D4		* D4=Y
	MULS	D4,D4		* D4=Y^2

	MOVE.L	D0,D5
	MULS	D5,D5
	ADD.L	D5,D4		* D4=X^2+Y^2
	LSR.L	#7,D4
	LSR.L	#6,D4
	ADDQ.W	#1,D2		* COMPT=COMPT+1
	BRA.S	WHILE_3
WEND3
	CMP.L	#32000,D4
	BLE.S	_ENDIF_1
	BSR.S	PLOT_IT
_ENDIF_1
	ADDQ.W	#1,D6
	BRA.S	WHILE_2
WEND2
	TST.W	ABORT
	BNE.S	WEND1
	ADDQ.W	#1,D7
	BRA.S	WHILE_1
WEND1
	RTS
ABORT
	DC.W	0
************ D1 = COULEUR *********
************ D4 = X       *********
************ D5 = Y       *********
PLOT_IT
	MOVEM.L	D0-D7/A0-A6,-(SP)
	MOVE.W	D2,D1
	AND.W	#$F,D1
	MOVE.W	D7,D4		* D6=X
	MOVE.W	D6,D5		* D5=Y
	ADD.W	D5,D5		* D5=Y*2
	MOVE.W	(A3,D5.W),D5	* D5=Y*160
	BSR.S	PLOT		* AFFICHE POINT
	MOVEM.L	(SP)+,D0-D7/A0-A6
	RTS
PLOT
	LEA	TAB_COL,A0
	ADD.W	D1,D1
	ADD.W	D1,D1
	MOVE.L	(A0,D1.W),A6
	
	ADD.W	D4,D4	* X*2
	ADD.W	D4,D4	* X*4

	LEA	TAB_PUT,A1
	MOVE.W	(A1,D4.W),D0	* OFFSET
	MOVE.W	2(A1,D4.W),D1	* PUT
	ADD.W	D5,D0
	JSR	(A6)
	RTS
MANDEL
	LEA	SCR2,A2
	LEA	TAB_160(PC),A3
	MOVEQ	#0,D7	* D7=COLONNE
.WHILE_1
	CMP.W	#COL_MAX,D7
	BGT	.WEND1

	MOVEQ	#0,D6		* D6=LIGNE
.WHILE_2
	CMP.W	#LIG_MAX,D6
	BGT.S	.WEND2
	MOVEQ	#0,D0
	MOVE.W	INCX(PC),D0
	MULS	D7,D0
	ADD.W	X1(PC),D0		* D0=X*100=(X1+COLONNE*INCX)*100
	MOVE.W	D0,P

	MOVEQ	#0,D1
	MOVE.W	INCY(PC),D1
	MULS	D6,D1
	ADD.W	Y1(PC),D1		* D1=Y*100=(Y1+LIGNE*INCY)*100
	MOVE.W	D1,Q

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D4
.WHILE_3
	CMP.W	#LIMI,D2
	BGT.S	.WEND3
	CMP.L	#32000,D4
	BGT.S	.WEND3

	MOVE.L	D0,D4		* 	D4=AUX
	MOVE.L	D1,D5
	ADD.L	D4,D5		* X+Y
	SUB.L	D1,D0		* X-Y
	MULS	D5,D0		* (X+Y)*(X-Y)
	LSR.L	#7,D0
	LSR.L	#6,D0
	
	ADD.W	P(PC),D0		* D0=(X*X-Y*Y+P)*100

	MULS	D4,D1		* D1=Y*AUX
	LSR.L	#7,D1
	LSR.L	#5,D1
	ADD.W	Q(PC),D1

	MOVE.L	D1,D4		* D4=Y
	MULS	D4,D4		* D4=Y^2

	MOVE.L	D0,D5
	MULS	D5,D5
	ADD.L	D5,D4		* D4=X^2+Y^2
	LSR.L	#7,D4
	LSR.L	#6,D4
	ADDQ.W	#1,D2		* COMPT=COMPT+1
	BRA.S	.WHILE_3
.WEND3
	CMP.L	#32000,D4
	BLE.S	._ENDIF_1
	BSR	PLOT_IT
._ENDIF_1
	ADDQ.W	#1,D6
	BRA.S	.WHILE_2
.WEND2
	TST.W	ABORT
	BNE.S	.WEND1
	ADDQ.W	#1,D7
	BRA	.WHILE_1
.WEND1
	RTS

COL0
	RTS
COL1
	OR.W	D1,(A2,D0.W)
	RTS
COL2
	OR.W	D1,2(A2,D0.W)
	RTS
COL3
	OR.W	D1,(A2,D0.W)
	OR.W	D1,2(A2,D0.W)
	RTS
COL4
	OR.W	D1,4(A2,D0.W)
	RTS
COL5
	OR.W	D1,(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	RTS
COL6
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	RTS
COL7
	OR.W	D1,(A2,D0.W)
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	RTS
COL8
	OR.W	D1,6(A2,D0.W)
	RTS
COL9
	OR.W	D1,(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL10
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL11
	OR.W	D1,(A2,D0.W)
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL12
	OR.W	D1,4(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL13
	OR.W	D1,(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL14
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
COL15
	OR.W	D1,(A2,D0.W)
	OR.W	D1,2(A2,D0.W)
	OR.W	D1,4(A2,D0.W)
	OR.W	D1,6(A2,D0.W)
	RTS
TAB_COL
	DC.L	COL0,COL1,COL2,COL3,COL4,COL5,COL6,COL7
	DC.L	COL8,COL9,COL10,COL11,COL12,COL13,COL14
	DC.L	COL15
TAB_PUT
M	SET	0
	REPT	20
	DC.W	M,32768,M,16384,M,8192,M,4096,M,2048
	DC.W	M,1024,M,512,M,256,M,128,M,64,M,32,M,16,M,8
	DC.W	M,4,M,2,M,1
M	SET	M+8
	ENDR
PAL
	DC.W	$0,$10,$21,$132,$243,$354,$465,$576,$677
	DC.W	$776,$765,$654,$543,$432,$321,$210
PAL2
	DC.W	$0,$12,$123,$234,$345,$456,$567,$677,$777
	DC.W	$776,$765,$654,$543,$432,$321,$210
PAL3
	DC.W	$0,$100,$210,$321,$432,$543,$654,$765,$776
	DC.W	$677,$576,$465,$354,$243,$132,$21,$10

TAB_160
M	SET	0
	REPT	200
	DC.W	M
M	SET	M+160
	ENDR
X1
	DC.W	-1600*8
X2
	DC.W	1600*8
Y1
	DC.W	-1000*8
Y2
	DC.W	1000*8
INCX
	DS.W	1
INCY
	DS.W	1
P	
	DC.W	-940*8
Q
	DC.W	-300*8
PJUL
	DC.W	-940*8
QJUL
	DC.W	-300*8
VBL_FRAC
	CMP.B	#$1,$FFFC02
	BNE.S	PAS_ESC
	MOVE.W	#1,ABORT
PAS_ESC
	RTE

MOUSE_IT:
                MOVE    #$2700,SR
                cmpi.b  #$F7,$FFFC02
                BEQ.S   MOUSE_2
                MOVE.B  $FFFC02,KEY
                MOVE    #$2300,SR
                RTE
MOUSE_2:
                MOVE.L  #MOUSE_3,$0118.w
                MOVE    #$2300,SR
                RTE
MOUSE_3:
                MOVE    #$2700,SR
                MOVE.B  $FFFC02,BOUTON
                MOVE.L  #MOUSE_4,$0118.w
                MOVE    #$2300,SR
                RTE
MOUSE_4:
                MOVE    #$2700,SR
                MOVE.B  $FFFC02,XMOUSE
                MOVE.L  #MOUSE_5,$0118.w
                MOVE    #$2300,SR
                RTE
MOUSE_5:
                MOVE    #$2700,SR
                MOVE.B  $FFFC02,XMOUSE+1
                MOVE.L  #MOUSE_6,$0118.w
                MOVE    #$2300,SR
                RTE
MOUSE_6:
                MOVE    #$2700,SR
                MOVE.B  $FFFC02,YMOUSE
                MOVE.L  #MOUSE_7,$0118.w
                MOVE    #$2300,SR
                RTE
MOUSE_7:
                MOVE    #$2700,SR
                MOVE.B  $FFFC02,YMOUSE+1
                MOVE.L  #MOUSE_IT,$0118
                MOVE    #$2300,SR
NULL_IT:
                RTE

INIT_MOUSE:
                LEA     MOUSEABS(PC),A0
                MOVEQ   #4,D7
                BSR   WRITE_CLAV
                LEA     INIT_CORDS(PC),A0
                MOVEQ   #5,D7
                BSR   WRITE_CLAV
                MOVE    #$2700,SR
                MOVE.L  #MOUSE_IT,$0118.w
                MOVE    #$2300,SR
                RTS

*********************************************

WRITE_CLAV:
                LEA     $FFFC00,A1
DO_CLAVIER:
                MOVE.B  (A1),D2
                BTST    #1,D2
                BEQ	    DO_CLAVIER
                MOVE.B  (A0)+,2(A1)
                DBRA    D7,DO_CLAVIER
                RTS

********************************************

MOUSEABS:
                DC.B $09
                DC.B $01,$3F
                DC.B $00,$C7
INIT_CORDS:
                DC.B $0E,$00,$00,$98,$00,$58
TYPE
	DC.B	'M'
                EVEN

TAB_D
	DC.W	$FFFF
	DC.W	%0111111111111111
	DC.W	%0011111111111111
	DC.W	%0001111111111111
	DC.W	%0000111111111111
	DC.W	%0000011111111111
	DC.W	%0000001111111111
	DC.W	%0000000111111111
	DC.W	%0000000011111111
	DC.W	%0000000001111111
	DC.W	%0000000000111111
	DC.W	%0000000000011111
	DC.W	%0000000000001111
	DC.W	%0000000000000111
	DC.W	%0000000000000011
	DC.W	%0000000000000001
OLD_PAL
	DC.W	$FFF,$0,$F0,$0,$F00
	DCB.W	11,$0
TAB_CORD
	DC.W	22,0,35,15	* X1+
	DC.W	146,0,159,15	* X1-
	DC.W	182,0,195,15	* X2+
	DC.W	306,0,319,15	* X2-
	DC.W	22,16,35,31	* Y1+
	DC.W	146,16,159,31	* Y1-
	DC.W	182,16,195,31	* Y2+
	DC.W	306,16,319,31	* Y2-
	DC.W	22,32,35,47	* P+
	DC.W	146,32,159,47	* P-
	DC.W	182,32,195,47	* Q+
	DC.W	306,32,319,47	* Q-
	
M	SET	0
	REPT	8
	DC.W	32+M,70,63+M,85	* COL0-1-2-...
M	SET	M+32
	ENDR

M	SET	0
	REPT	8
	DC.W	32+M,86,63+M,101	* COL8-9-10...
M	SET	M+32
	ENDR

	DC.W	16,122,56,137	* JULIA
	DC.W	256,122,308,137	* MANDEL
	
	DC.W	0,153,60,168	* L PI1
	DC.W	61,153,121,168	* S PI1
	DC.W	122,153,188,168	* L PAR
	DC.W	189,153,255,168	* S PAR
	DC.W	256,153,318,168	* GRAPH
	DC.W	107,169,214,184	* QUIT

	DC.W	102,103,116,118	* R+
	DC.W	227,103,240,118	* R-
	DC.W	102,119,116,134	* V+
	DC.W	227,119,240,134	* V-
	DC.W	102,135,116,150	* B+
	DC.W	227,135,240,150	* B-

	DC.W	265,105,299,119	* VIEW
	DC.W	19,105,55,120	* ZOOM
	DC.W	215,169,244,184	* INIT COORDS
IMG
	INCBIN	FRACT.PI1
MOUSE_SPR
	DC.L	%11110000000000000000000000000000
	DC.L	%11100000000000000000000000000000
	DC.L	%11110000000000000000000000000000
	DC.L	%10111000000000000000000000000000
	DC.L	%00011100000000000000000000000000
	DC.L	%00001000000000000000000000000000
PAL_JULIA
	DC.W	$0,$10,$21,$132,$243,$354,$465,$576,$677
	DC.W	$776,$765,$654,$543,$432,$321,$210
TAB_FONC
	DC.L	X1_PLUS	* X1+
	DC.L	X1_MOINS	* X1-
	DC.L	X2_PLUS	* X2+
	DC.L	X2_MOINS	* X2-
	DC.L	Y1_PLUS	* Y1+
	DC.L	Y1_MOINS	* Y1-
	DC.L	Y2_PLUS	* Y2+
	DC.L	Y2_MOINS	* Y2-
	DC.L	P_PLUS	* P+
	DC.L	P_MOINS	* P-
	DC.L	Q_PLUS	* Q+
	DC.L	Q_MOINS	* Q-

	REPT	16
	DC.L	SEL_COLX
	ENDR
	DC.L	SEL_JULIA
	DC.L	SEL_MANDEL
	REPT	4
	DC.L	NULL
	ENDR
	DC.L	DRAW_FRACT * GRAPH IT
	DC.L	NULL	 * QUIT
	DC.L	R_PLUS	* ROUGE +
	DC.L	R_MOINS	* ROUGE -
	DC.L	V_PLUS	* VERT +
	DC.L	V_MOINS	* VERT -
	DC.L	B_PLUS	* BLEU +
	DC.L	B_MOINS	* BLEU -
	DC.L	VIEW
	DC.L	ZOOM
	DC.L	INIT_COORDS
FONCTION
	DC.W	0
SAVE
	DS.L	20
XMOUSE
	DS.W	1
YMOUSE
	DS.W	1
BOUTON
	DC.B	0
KEY
	DC.B	0
	EVEN
TAB_X_ASC
	DC.W	208,196,184,172,160,148,136,124
ASCENCEUR
	DC.L	%00000000000000000000000000000000
	DC.L	%11111111111100000000000000000000
	REPT	7
	DC.L	%00000000000100000000000000000000
	DC.L	%10000000000000000000000000000000
	ENDR
	DC.L	%11111111111100000000000000000000
	DC.L	%00000000000000000000000000000000
FNT_AZ
	INCBIN	COPYB3.IMG
FNT_09
	INCBIN	COPYB4.IMG
	DC.L	0,0
	DC.L	0,0
	DC.L	0,0
	DC.L	%00000010000000000000000000000000
	DC.L	%11111100000000000000000000000000
	DC.L	0,0
	DC.L	0,0
	DC.L	0,0
	REPT	14
	DC.L	%11111110000000000000000000000000
	ENDR
BUF_RED
	DC.L	SCR2
	REPT	9
	DC.L	0,0
	ENDR
BUF_GREEN
	DC.L	SCR2
	REPT	9
	DC.L	0,0
	ENDR
BUF_BLUE
	DC.L	SCR2
	REPT	9
	DC.L	0,0
	ENDR
BUF
	DC.L	$78000
	DCB.L	6