;	SMALL HTL INTRO, AS REQUESTED BY SLEDGE 
;	      CODING+MUSIC DONE BY LOTUS
;
;	  AT LINE +- 118 NAME OF GAMEFILE
;	  AT LINE +- 558 SCROLLTEXT

WHICHMUZAK=1 

        SECTION	TEXT

;---------------------------------
;	INTERRUPTS ON+NEWSETTINGS 
;---------------------------------
	MOVE.L $4(A7),BASE1
        CLR.L	    -(SP)
        MOVE.W      #$0020,-(SP)
        TRAP        #1
        ADDQ.L      #6,SP
        MOVE.L      D0,OLDSTACK
        JSR         INITROUT
	MOVEM.L	    PALLET1,D0-D7
	MOVEM.L	    D0-D7,$FFFF8240.W	
	MOVE.W	    #178-1,D0
PRECOL:	MOVE.W	    D0,-(SP)
	JSR	    COLCYCLE
	MOVE.W      (SP)+,D0
	DBF	    D0,PRECOL
	JSR	    CONVERTGREETINX
	JSR	    COPYGRAPH
	JSR	    SETGREETING
	JSR	    STARTINTERRUPTS
	JSR	    STARTMUSIC
	JSR	    FADE_IN
;---------------------------------
;	KEYCHECK ROUTINE
;---------------------------------
CHECKKEY:
        CMPI.B      #$39,KEY
        BNE.S       CHECKKEY
;---------------------------------
;	INTERRUPTS OFF+OLDSETTINGS 
;---------------------------------
	MOVE.W	    #$FFFF,TEST
	JSR	    FADE_OUT
	JSR	    STOPMUSIC
	JSR	    STOPINTERRUPTS
	JSR	    ENDROUT
        MOVE.L      OLDSTACK,-(SP)
        MOVE.W      #$0020,-(SP)
        TRAP        #1
        ADDQ.L      #6,SP
RELOCATE:
	MOVE.L BASE1(PC),A5
	pea	(a5)
	pea	(a5)
	LEA GAME(PC),A3
	MOVE.L $2(A3),A0
	ADD.L $6(A3),A0
	MOVE.L A0,BASE2
	ADD.L A3,A0
	LEA $1C(A0),A0
	MOVE.L $8(A5),D0
	LEA GAME+$1C(PC),A1
	TST.L (A0)
	BEQ.S QUIT
	ADD.L (A0)+,A1
NEXT1	ADD.L D0,(A1)
NEXT2	CLR.L D1
	MOVE.B (A0)+,D1
	TST.W D1
	BEQ.S QUIT
	CMP.B #$1,D1
	BNE.S NEXT3
	LEA $FE(A1),A1
	BRA.S NEXT2

NEXT3	ADD.L D1,A1
	BRA.S NEXT1

QUIT	MOVE.L $2(A3),$C(A5)
	MOVE.L $6(A3),$14(A5)
	MOVE.L $A(A3),$1C(A5)
	MOVE.L $8(A5),D0
	MOVE.L $C(A5),D1
	ADD.L D0,D1
	MOVE.L D1,$10(A5)
	MOVE.L $14(A5),D0
	ADD.L D0,D1
	MOVE.L D1,$18(A5)

	LEA COPY(PC),A0
	LEA $7FF00,A1
	MOVE.L A1,A5
	MOVEQ #$2F,D0
COPY_SET
	MOVE.B (A0)+,(A1)+
	DBF D0,COPY_SET

	LEA GAME+$1C(PC),A0
	MOVE.L BASE1(PC),A1
	LEA $100(A1),A1
	MOVE.L A1,A3
	MOVE.L BASE2(PC),A4
	ADD.L A1,A4
	MOVE.L #EOF,A2
	JMP (A5)

COPY	MOVE.L (A0)+,(A1)+
	CMP.L A2,A0
	BLT.S COPY

CLEAR	CLR.L (A4)+
	CMP.L A2,A4
	BLT.S CLEAR
	JMP (A3)

BASE1	DC.L $0
BASE2	DC.L $0
GAME	
	
EOF

;---------------------------------
;	INTERRUPTS SETTINGS 
;---------------------------------
STARTINTERRUPTS:
	BSR	    HBLON
	LEA	    NEWIRQ(PC),A0		
	MOVE.L      A0,$70.W
	RTS
STOPINTERRUPTS:
        MOVE.L	    OLDVBL(PC),$70.W
	JSR	    HBLOFF
	RTS
HBLON:	
	MOVE.W	SR,-(SP)		;SAVE OLD STATUS REG
	MOVE.W	#$2700,SR		;ALL INTERRUPTS OFF
	LEA	SAVEREG,A0		;SAVE TIMER REGISTERS
	MOVE.B	$FFFFFA07.W,(A0)+	;TIMER B INTERRUPT ENABLE REG
	MOVE.B	$FFFFFA09.W,(A0)+	;TIMER C INTERRUPT ENABLE REG
	MOVE.B	$FFFFFA13.W,(A0)+	;TIMER B MASK REG'A'
	MOVE.B	$FFFFFA17.W,(A0)+	;VECTOR REG
	MOVE.B	$FFFFFA1B.W,(A0)+	;TIMER B CONTROL REG
	MOVE.B	$FFFFFA21.W,(A0)	;TIMER B DATA REG
	MOVE.L	$118.W,OLD118
	MOVE.L	#NEWKEY,$118.W
	LEA	OLDVBL,A0		;SAVE OLD VBL
	MOVE.L	$70.W,(A0)	 
	LEA	OLDHBL,A0		;SAVE OLD HBL
	MOVE.L	$120.W,(A0)
	BCLR.B	#$5,$FFFFFA09.W		;SET TIMER C OFF
	OR.B	#%00000001,$FFFFFA07.W 	;ENABLE INTERRUPT TIMER B
	OR.B	#%00000001,$FFFFFA13.W 	;TIMER B ON
	BCLR	#3,$FFFFFA17.W		;SET AUTOMATIC END OF INTERRUPT 
 	LEA	HBL1(PC),A0		;SET NEW HBL VEC   
	MOVE.L	A0,$120.W
	MOVE.W	(SP)+,SR		;ALL INTERRUPTS ON
	RTS
HBLOFF: 
	MOVE.W	SR,-(SP)		;SAVE STATUS REG
	MOVE.W	#$2700,SR		;ALL INTERRUPTS OFF
	MOVE.L	OLD118,$118.W
	MOVE.L	OLDHBL,$120.W
	LEA	SAVEREG,A0		;SAVE TIMER REGISTERS
	MOVE.B	(A0)+,$FFFFFA07.W	;TIMER B INTERRUPT ENABLE REG
	MOVE.B	(A0)+,$FFFFFA09.W	;TIMER C INTERRUPT ENABLE REG
	MOVE.B	(A0)+,$FFFFFA13.W	;TIMER B MASK REG'A'
	MOVE.B	(A0)+,$FFFFFA17.W	;VECTOR REG
	MOVE.B	(A0)+,$FFFFFA1B.W	;TIMER B CONTROL REG
	MOVE.B	(A0),$FFFFFA21.W	;TIMER B DATA REG
	MOVE.W	(SP)+,SR	
	RTS
;---------------------------------
;	MUSIC SETTINGS 
;---------------------------------
STARTMUSIC:	
	MOVEQ	     #0,D0
	JSR	    MUSIC
	JSR	    MUSIC+18
	RTS
STOPMUSIC:	
	MOVE.L	    #$FF,D0
	JSR	    MUSIC
	JSR	    MUSIC+22
	RTS
;---------------------------------
;	TIMER B INTERUPTS 
;---------------------------------
HBL1:	
	MOVEM.L	D0-D7,-(SP)
	MOVEM.L	PALLET1,D0-D7
	MOVEM.L	D0-D7,$FFFF8240.W
	MOVEM.L	(SP)+,D0-D7
	CLR.B	 $fffffa1b.w
	MOVE.L	#RASTERBUFFER,HBL2+2
	MOVE.L	 #HBL2,$120.W	
	MOVE.B	 #1,$FFFFFA21.W	
	move.b   #8,$fffffa1b.w
	RTE
HBL2:	MOVE.W	RASTERBUFFER,$FFFF8242.W
	ADDQ.W	#2,HBL2+4
	RTE
;---------------------------------
;	KEY INTERUPTS 
;---------------------------------
NEWKEY:	
	MOVE.B	$FFFFFC02.W,KEY		
	RTE
;---------------------------------
;	VBL INTERUPTS 
;---------------------------------
NEWIRQ:
	CLR.B	    $FFFFFA1B.W		;STOP TIMER B
	MOVE.B	    #1,$FFFFFA21.W	
	MOVE.L	    #HBL1,$120.W	;SET FIRST HBL VECTOR
        MOVEM.L     D0-A6,-(SP)        
	BCLR	    #3,$FFFFFA17.W	;AUTOMATIC END OF INTERRUPT MODE
	MOVE.B	    #8,$FFFFFA1B.W	;START EVENT COUNT TIMER B
        MOVEM.L	    PALLET1,D0-D7
 	MOVEM.L     D0-D7,$FFFF8240.W
	JSR	    MUSIC+26
	TST.W	    TEST
	BNE.S       DONTCYCLE
	BSR.S	    COLCYCLE	
DONTCYCLE:
        MOVEM.L     (SP)+,D0-A6
        RTE

COLCYCLE:	
	MOVEM.L	    RASTERBUFFER+0*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+0*60
	MOVEM.L	    RASTERBUFFER+1*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+1*60
	MOVEM.L	    RASTERBUFFER+2*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+2*60
	MOVEM.L	    RASTERBUFFER+3*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+3*60
	MOVEM.L	    RASTERBUFFER+4*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+4*60
	MOVEM.L	    RASTERBUFFER+5*60+2(PC),D0-A6	
	MOVEM.L	    D0-A6,RASTERBUFFER+5*60
	MOVEM.L	    RASTERBUFFER+6*60+2(PC),D0-A1	
	MOVEM.L	    D0-A1,RASTERBUFFER+6*60
	MOVE.L	    RASTERPOINTER(PC),A0
	CMP.W       #-1,(A0)
	BNE.S  	    NOTENDTAB
	LEA	    REDCOL(PC),A0
NOTENDTAB:
	MOVE.W	    (A0)+,RASTERBUFFER+400
	MOVE.L	    A0,RASTERPOINTER
	RTS
;---------------------------------
X;	SMALL SUBROUTINES 
;---------------------------------
SETGREETING:	
	LEA	GREETINXBUFFER,A2		
	MOVE.L	$44E,A1
SETGREETINGLOOP1:
	MOVEQ	#20-1,D0
SETGREETINGLOOP2:
	MOVE.W	D0,-(SP)
	MOVE.L	(A2)+,A0
	MOVE.B	(A0),D0
	MOVE.B	1*160(A0),D1
	MOVE.B	2*160(A0),D2
	MOVE.B	3*160(A0),D3
	MOVE.B	4*160(A0),D4
	MOVE.B	5*160(A0),D5
	MOVE.B	6*160(A0),D6
	MOVE.B	7*160(A0),D7
	NOT.B	D0
	NOT.B	D1
	NOT.B	D2
	NOT.B	D3
	NOT.B	D4
	NOT.B	D5
	NOT.B	D6
	NOT.B	D7
	AND.B	D0,(A1)
	AND.B	D0,2(A1)
	AND.B	D0,4(A1)
	AND.B	D0,6(A1)
	AND.B	D1,1*160+0(A1)
	AND.B	D1,1*160+02(A1)
	AND.B	D1,1*160+04(A1)
	AND.B	D1,1*160+06(A1)
	AND.B	D2,2*160+0(A1)
	AND.B	D2,2*160+02(A1)
	AND.B	D2,2*160+04(A1)
	AND.B	D2,2*160+06(A1)
	AND.B	D3,3*160+0(A1)
	AND.B	D3,3*160+02(A1)
	AND.B	D3,3*160+04(A1)
	AND.B	D3,3*160+06(A1)
	AND.B	D4,4*160+0(A1)
	AND.B	D4,4*160+02(A1)
	AND.B	D4,4*160+04(A1)
	AND.B	D4,4*160+06(A1)
	AND.B	D5,5*160+0(A1)
	AND.B	D5,5*160+02(A1)
	AND.B	D5,5*160+04(A1)
	AND.B	D5,5*160+06(A1)
	AND.B	D6,6*160+0(A1)
	AND.B	D6,6*160+02(A1)
	AND.B	D6,6*160+04(A1)
	AND.B	D6,6*160+06(A1)
	AND.B	D7,7*160+0(A1)
	AND.B	D7,7*160+02(A1)
	AND.B	D7,7*160+04(A1)
	AND.B	D7,7*160+06(A1)
	MOVE.B	(A0),D0
	MOVE.B	1*160(A0),D1
	MOVE.B	2*160(A0),D2
	MOVE.B	3*160(A0),D3
	MOVE.B	4*160(A0),D4
	MOVE.B	5*160(A0),D5
	MOVE.B	6*160(A0),D6
	MOVE.B	7*160(A0),D7
	OR.B	D0,(A1)
	OR.B	D1,1*160(A1)
	OR.B	D2,2*160(A1)
	OR.B	D3,3*160(A1)
	OR.B	D4,4*160(A1)
	OR.B	D5,5*160(A1)
	OR.B	D6,6*160(A1)
	OR.B	D7,7*160(A1)
	ADDQ.L	#1,A1
	MOVE.L	(A2)+,A0
	MOVE.B	(A0),D0
	MOVE.B	1*160(A0),D1
	MOVE.B	2*160(A0),D2
	MOVE.B	3*160(A0),D3
	MOVE.B	4*160(A0),D4
	MOVE.B	5*160(A0),D5
	MOVE.B	6*160(A0),D6
	MOVE.B	7*160(A0),D7
	NOT.B	D0
	NOT.B	D1
	NOT.B	D2
	NOT.B	D3
	NOT.B	D4
	NOT.B	D5
	NOT.B	D6
	NOT.B	D7
	AND.B	D0,(A1)
	AND.B	D0,2(A1)
	AND.B	D0,4(A1)
	AND.B	D0,6(A1)
	AND.B	D1,1*160+0(A1)
	AND.B	D1,1*160+02(A1)
	AND.B	D1,1*160+04(A1)
	AND.B	D1,1*160+06(A1)
	AND.B	D2,2*160+0(A1)
	AND.B	D2,2*160+02(A1)
	AND.B	D2,2*160+04(A1)
	AND.B	D2,2*160+06(A1)
	AND.B	D3,3*160+0(A1)
	AND.B	D3,3*160+02(A1)
	AND.B	D3,3*160+04(A1)
	AND.B	D3,3*160+06(A1)
	AND.B	D4,4*160+0(A1)
	AND.B	D4,4*160+02(A1)
	AND.B	D4,4*160+04(A1)
	AND.B	D4,4*160+06(A1)
	AND.B	D5,5*160+0(A1)
	AND.B	D5,5*160+02(A1)
	AND.B	D5,5*160+04(A1)
	AND.B	D5,5*160+06(A1)
	AND.B	D6,6*160+0(A1)
	AND.B	D6,6*160+02(A1)
	AND.B	D6,6*160+04(A1)
	AND.B	D6,6*160+06(A1)
	AND.B	D7,7*160+0(A1)
	AND.B	D7,7*160+02(A1)
	AND.B	D7,7*160+04(A1)
	AND.B	D7,7*160+06(A1)
	MOVE.B	(A0),D0
	MOVE.B	1*160(A0),D1
	MOVE.B	2*160(A0),D2
	MOVE.B	3*160(A0),D3
	MOVE.B	4*160(A0),D4
	MOVE.B	5*160(A0),D5
	MOVE.B	6*160(A0),D6
	MOVE.B	7*160(A0),D7
	OR.B	D0,(A1)
	OR.B	D1,1*160(A1)
	OR.B	D2,2*160(A1)
	OR.B	D3,3*160(A1)
	OR.B	D4,4*160(A1)
	OR.B	D5,5*160(A1)
	OR.B	D6,6*160(A1)
	OR.B	D7,7*160(A1)
	ADDQ.L	#7,A1
	MOVE.W  (SP)+,D0
	DBF	D0,SETGREETINGLOOP2		
	LEA	8*160(A1),A1
	CMP.L	#-1,(A2)
	BNE	SETGREETINGLOOP1
	RTS

CONVERTGREETINX:
	LEA	GREETINX,A0
	LEA	GREETINXCONVERTTAB,A1
	LEA	GREETINXBUFFER,A2
CONVERTGREETINXLOOP:
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVE.B	(A0)+,D0
SEARCHLOOP:	MOVE.L	(A1),D1
	ADDQ.L	#8,A1
	CMP.B	D0,D1
	BNE.S	SEARCHLOOP
	CMPI.L	#-1,-8(A1)
	BEQ.S	NEXTCHAR
NOTFRAMED:	
	MOVE.L	-4(A1),(A2)+
	LEA	GREETINXCONVERTTAB,A1
NEXTCHAR:
	CMPI.B	#-1,(A0)
	BEQ.S	EXITGREETINXCONVERTLOOP
	BRA.S	CONVERTGREETINXLOOP
EXITGREETINXCONVERTLOOP:
	MOVE.L	#-1,(A2)
	LEA	GREETINXBUFFER,A0
	RTS

COPYGRAPH:	
	LEA	PIC+34,A0
	MOVE.L	$44E,A1
	MOVE.W	#8000-1,D0
COPLOOPJE:
	MOVE.L	(A0)+,(A1)+
	DBF	D0,COPLOOPJE	
	RTS

WAITSYN:
	MOVE.W	#14000-1,D0
P:	NOP
	DBF	D0,P		
	RTS

FADE_IN:	
	MOVEQ	#7,D6
NEXTTINT:
	LEA	PIC+2(PC),A0
	LEA	PALLET1(PC),A1
	BSR	NEXTCOL
	DBF	D6,NEXTTINT
	RTS

NEXTCOL:	
	MOVE.W	D6,-(A7)
	JSR	WAITSYN
	JSR	WAITSYN
	MOVEQ	#16-1,D7
BLUEFADE:
	MOVE.W	(A1),D0
	MOVE.W	(A0),D1
	ANDI.W	#7,D0
	ANDI.W	#7,D1
	CMP.W	D0,D1
	BLE.S	GRNFADE
	ADDQ.W	#1,(A1)
GRNFADE:	
	MOVE.W	(A1),D0
	MOVE.W	(A0),D1
	ANDI.W	#$70,D0
	ANDI.W	#$70,D1
	CMP.W	D0,D1
	BLE.S	REDFADE
	ADDI.W	#$10,(A1)
REDFADE:
	MOVE.W	(A1),D0
	MOVE.W	(A0),D1
	ANDI.W	#$700,D0
	ANDI.W	#$700,D1
	CMP.W	D0,D1
	BLE.S	CLRTINT
	ADDI.W	#$100,(A1)
CLRTINT:
	ANDI.W	#$777,(A1)
	LEA	2(A1),A1
	LEA	2(A0),A0
	DBF	D7,BLUEFADE
	MOVE.W	(A7)+,D6
	RTS 

FADE_OUT:
	MOVEQ	#7,D6
REMOVETINT:
	LEA	PALLET1,A1
	MOVEQ   #16-1,D3
	BSR	REMOVECOL
	MOVE.W   #200-1,D3
	LEA	RASTERBUFFER,A1
	BSR	REMOVECOL
	DBF	D6,REMOVETINT
	RTS

REMOVECOL:
	MOVE.W	D6,-(A7)
	JSR	WAITSYN
	MOVE.W	D3,D7
NEXTCOLOR:
	MOVE.W	(A1),D0 
	ANDI.W	#7,D0 
	BEQ.S	REMOVEBLUE 
	SUBQ.W	#1,(A1) 
REMOVEBLUE:
	MOVE.W	(A1),D0 
	ANDI.W	#$70,D0 
	BEQ.S	REMOVEGREEN 
	SUBI.W	#$10,(A1) 
REMOVEGREEN:
	MOVE.W	(A1),D0 
	ANDI.W	#$700,D0
	BEQ.S	REMOVERED 
	SUBI.W	#$100,(A1)
REMOVERED:
	ANDI.W	#$777,(A1)
	LEA	2(A1),A1
	DBF	D7,NEXTCOLOR
	MOVE.W	(A7)+,D6
	RTS 

;---------------------------------
;	INIT SETTINGS 
;---------------------------------
INITROUT:
	MOVE.B	    #$4,$484.W
        MOVE.W      #$0004,-(SP)        ;<- STORES RESOLUTION
        TRAP        #14
        ADDQ.L      #2,SP
        MOVE.W      D0,OLDRES
        MOVEM.L     $FFFF8240.w,D0-D7   ;<- STORES COLOR
        MOVEM.L     D0-D7,OLDPAL
        MOVE.W      #0,-(SP)            ;<- SWITCH RESOLUTION
        MOVE.L      #-1,-(SP)
        MOVE.L      #-1,-(SP)
        MOVE.W      #5,-(SP)
        TRAP        #14
        LEA         12(SP),SP
        MOVE.B      $00000484.W,OLDKEY
        MOVE.B      #2,$00000484.W
        MOVE.B      #$12,$FFFFFC02.w
        RTS
ENDROUT:
        MOVE.W      OLDRES,-(SP)
        MOVE.L      #-1,-(SP)
        MOVE.L      #-1,-(SP)
        MOVE.W      #5,-(SP)
        TRAP        #14
        LEA         12(SP),SP
        MOVE.B      OLDKEY,$00000484.w
        MOVE.B      #8,$FFFFFC02.w      ;<= MOUSE ON
        MOVEM.L     OLDPAL,D0-D7
        MOVEM.L     D0-D7,$FFFF8240.w
        RTS
;---------------------------------
;	BEGIN OF DATA SEGMENT
;---------------------------------
;	A-Z  0-9  :!.,@()?#;*=+-
GREETINX:	
	;ONE LINE IS 40 CHARACTERS LONG; MAXIMUM OF 24 LINES
	;	DCB.B 1*40,32 IS EEN OPEN REGEL
	
	DCB.B	11*40,32
	        ;                                         ;   
	DC.B	"     VERSION OF AN UNRELEASED GAME      "
	DC.B	"  COPY THIS DISK 9 SECTORS 82 TRACKS    "
	DC.B	"                                        "
	DC.B	"   GREETS TO THE FOLLOWING HOT LEADERS  "
	DC.B	"     MCA       EMPIRE     INNERCIRCLE   "
	DC.B	"                                        "
	DC.B	"      SPECIAL GREETS TO @ NEWLINE @     "
	DC.B 	"             AND  FILMNETSKY            "
	DC.B	"                                        "
	DC.B	"        INTRO+MUSIC BY IJSBLOKJE        "
	DC.B	"              GFX BY SENSE              "
	DC.B	-1
ENDGREETINX:
	EVEN
GREETINXBUFFER:	DS.L	(ENDGREETINX-GREETINX)
 		dc.l	-1	

	SECTION	DATA
GREETINXCONVERTTAB:
	DC.L	"A",SMALLCHARS+0*8,"B",SMALLCHARS+1+0*8
	DC.L	"C",SMALLCHARS+1*8,"D",SMALLCHARS+1+1*8
	DC.L	"E",SMALLCHARS+2*8,"F",SMALLCHARS+1+2*8
	DC.L	"G",SMALLCHARS+3*8,"H",SMALLCHARS+1+3*8
	DC.L	"I",SMALLCHARS+4*8,"J",SMALLCHARS+1+4*8
	DC.L	"K",SMALLCHARS+5*8,"L",SMALLCHARS+1+5*8
	DC.L	"M",SMALLCHARS+6*8,"N",SMALLCHARS+1+6*8
	DC.L	"O",SMALLCHARS+7*8,"P",SMALLCHARS+1+7*8
	DC.L	"Q",SMALLCHARS+8*8,"R",SMALLCHARS+1+8*8
	DC.L	"S",SMALLCHARS+9*8,"T",SMALLCHARS+1+9*8
	DC.L	"U",SMALLCHARS+10*8,"V",SMALLCHARS+1+10*8
	DC.L	"W",SMALLCHARS+11*8,"X",SMALLCHARS+1+11*8
	DC.L	"Y",SMALLCHARS+12*8,"Z",SMALLCHARS+1+12*8
	DC.L	"0",SMALLCHARS+13*8,"1",SMALLCHARS+1+13*8
	DC.L	"2",SMALLCHARS+14*8,"3",SMALLCHARS+1+14*8
	DC.L	"4",SMALLCHARS+15*8,"5",SMALLCHARS+1+15*8
	DC.L	"6",SMALLCHARS+16*8,"7",SMALLCHARS+1+16*8
	DC.L	"8",SMALLCHARS+17*8,"9",SMALLCHARS+1+17*8
	DC.L	":",SMALLCHARS+18*8,"!",SMALLCHARS+1+18*8
	DC.L	".",SMALLCHARS+19*8,",",SMALLCHARS+1+19*8
	DC.L	"@",SMALLCHARS+0*8+(8*160),"(",SMALLCHARS+1+0*8+(8*160)
	DC.L	")",SMALLCHARS+1*8+(8*160),"?",SMALLCHARS+1+1*8+(8*160)
	DC.L	"#",SMALLCHARS+2*8+(8*160),";",SMALLCHARS+1+2*8+(8*160)
	DC.L	"'",SMALLCHARS+3*8+(8*160),"*",SMALLCHARS+1+3*8+(8*160)
	DC.L	"=",SMALLCHARS+4*8+(8*160),"+",SMALLCHARS+1+4*8+(8*160)
	DC.L	"-",SMALLCHARS+5*8+(8*160)," ",SMALLCHARS+1+5*8+(8*160)
	DC.L	-1,-1
SMALLCHARS:
	INCBIN g:\hotline\SHORT\8X8FONT.BIN
	EVEN
RASTERBUFFER:
	DCB.W	201,0
REDCOL	
	dc.w	$100,$100,$200,$200,$300,$300,$400,$400,$500,$500,$600,$600,$700,$700
	dc.w	$710,$710,$720,$720,$730,$730,$740,$740,$750,$750,$760,$760,$770,$770
	dc.w	$670,$670,$570,$570,$470,$470,$370,$370,$270,$270,$170,$170,$070,$070
	dc.w	$071,$071,$072,$072,$073,$073,$074,$074,$075,$075,$076,$076,$077,$077
	dc.w	$067,$067,$057,$057,$047,$047,$037,$037,$027,$027,$017,$017,$007,$007
	dc.w	$006,$006,$005,$005,$004,$004,$003,$003,$002,$002,$001,$001,$000,$000
	DC.W	-1
;---------------------------------
;	MEMORY RESERVED 
;---------------------------------
RASTERPOINTER:	DC.L	REDCOL
SAVEREG:	DS.B	6
OLDHBL:		DS.L	1
WHICHSCREEN:    DS.B 	1
KEY:     	DS.B 	1	
OLDSTACK:       DS.L 	1
OLDRES:         DS.W 	1
OLDSCR:         DS.L 	1
OLDPAL:         DS.L 	8
OLDIRQ:         DS.L 	1
OLDKEY:         DS.B 	1
PALLET1:	DS.W 	16
PALLET2:	DS.W 	16
OLDVBL: 	DS.L	1
OLD118:		DS.L	1
TEST:		DS.W    1
;---------------------------------
;	INCBIN FILES 
;---------------------------------
PIC:		INCBIN g:\hotline\SHORT\HTL_MCA.PI1
MUSIC:		INCBIN g:\hotline\SHORT\GROOVY.MUS

                END





