;########################################################################
;#----------------------------------------------------------------------#
;#						#
;# DSP PARAMETRIC CURVES		       (C) 1995 GASTON.	#
;#						#
;# v 1.00, 28 August 1996.				#
;#						#
;#----------------------------------------------------------------------#
;########################################################################
;#----------------------------------------------------------------------#
;#						#
;# The following program displays on the screen several parts of	#
;# different parametric curves. A parametric curve is defined by its	#
;# coordinates X=sin(a)*sin(b) and Y=sin(c)*sin(d), the four angles	#
;# varying differently for each curve.			#
;#						#
;# Here, you can choose the number of parametric curves, and also the	#
;# size of the segment that is displayed.			#
;#						#
;#----------------------------------------------------------------------#
;#						#
;# TO DO :						#
;#						#
;# - DEGRADE_SIZE and WORM_NO become two variables, to be able to	#
;# change them during the execution of the demo.		#
;#						#
;#----------------------------------------------------------------------#
;########################################################################
;#----------------------------------------------------------------------#
;# CPUTIME	    | 0=do not display the cpu-time, 1=display it	#
;# STOPIMG	    | 0=normal mode, 1=press 'Esc' to freeze the demo	#
;# DEGRADE_SIZE | Size (in words) of the degrades		#
;# WORM_NO	    | Number of worms				#
;#----------------------------------------------------------------------#
CPUTIME		= 0
STOPIMG		= 0
DEGRADE_SIZE	= 176
WORM_NO		= 30
	opt	m+,o+,x-,w-
	opt	p=68030
	bra	END_PARAMETER_AREA
	include	init.s
END_PARAMETER_AREA:
;########################################################################
;#----------------------------------------------------------------------#
;# General initialisations of the demo.			#
;#----------------------------------------------------------------------#
;########################################################################
	bsr	SAVE_CONTEXT
	bsr	LOAD_DSP_PROG
	bsr	NEW_CONTEXT



;########################################################################
;#----------------------------------------------------------------------#
;# Specific initialisations of the demo ...			#
;#----------------------------------------------------------------------#
;########################################################################

;#----------------------------------------------------------------------#
;# Send the indispensable data to the Dsp.			#
;#----------------------------------------------------------------------#

are_u_ready:btst.b	#1,$ffffa202.w
	beq.s	are_u_ready
	lea	$ffffa204.w,a1

;#----------------------------------------------------------------------#
;# Send the sinus table with an angular accuracy of 0.2.		#
;#----------------------------------------------------------------------#

	lea	sinus,a0
	move.w	#360*5-1,d0
send_sin:	move.l	(a0)+,(a1)
	dbra	d0,send_sin

;#----------------------------------------------------------------------#
;# Send the degrade size, and also their number.		#
;#----------------------------------------------------------------------#

	move.w	#DEGRADE_SIZE,$ffffa206.w
	move.w	#WORM_NO,$ffffa206.w

;#----------------------------------------------------------------------#
;# Send the characteristics of every curve (initial angles, and	#
;# incrementing values of these angles per Vbl.			#
;#----------------------------------------------------------------------#

	lea	curves,a0
	clr.l	d1
	move.w	#8*WORM_NO-1,d0
send_crb:	move.w	(a0)+,d1
	move.l	d1,(a1)
	dbra	d0,send_crb

;#----------------------------------------------------------------------#
;# Send the address of a screen to fill in the clear-buffer.	#
;#----------------------------------------------------------------------#

	move.l	adr_ecran1,(a1)
	
	
	
;########################################################################
;#----------------------------------------------------------------------#
;# Beginning of the principal loop, wait for the Vbl ...		#
;#----------------------------------------------------------------------#	
;########################################################################

REPEAT:	bsr	VSYNC
	IFNE	STOPIMG
	cmpi.b	#1,$fffffc02.w
	beq.s	REPEAT
	ENDC



;########################################################################
;#----------------------------------------------------------------------#
;# Swap logical screen and physical screen.			#
;#----------------------------------------------------------------------#	
;########################################################################

	bsr	FLIP_SCREEN
	move.b	adr_ecran1+1,$ffff8201.w
	move.b	adr_ecran1+2,$ffff8203.w
	move.b	adr_ecran1+3,$ffff820d.w

	IFNE	CPUTIME
	move.l	#$ACDCBABA,$FFFF9800.w
	ENDC



;########################################################################
;#----------------------------------------------------------------------#	
;# Send the invisible screen address to the Dsp.		#
;#----------------------------------------------------------------------#	
;########################################################################

not_ready:	btst.b	#1,$ffffa202.w
	beq.s	not_ready
	move.l	adr_ecran2,$ffffa204.w



;########################################################################
;#----------------------------------------------------------------------#	
;# Clear all the points on the logical screen.			#
;#----------------------------------------------------------------------#	
;########################################################################

	ifeq	CPUTIME-1
	move.l	#$44336622,$ffff9800.w
	endc
	
wait4adr:	btst	#0,$ffffa202.w
	beq.s	wait4adr

	lea	$ffffa204.w,a0
	clr.w	d1
	move.w	#WORM_NO*DEGRADE_SIZE/16-1,d0
clear:	
	rept	16
	move.l	(a0),a1
	move.w	d1,(a1)
	endr
	dbra	d0,clear


	
;########################################################################
;#----------------------------------------------------------------------#	
;# Then we display all the curves, all the addresses of the points are	#
;# computed by the Dsp, the 68030 only have to plot a colour value at	#
;# this address.					#
;#----------------------------------------------------------------------#	
;########################################################################

	ifeq	CPUTIME-1
	move.l	#$6611aa44,$ffff9800.w
	endc
	
wait4adr2:	btst	#0,$ffffa202.w
	beq.s	wait4adr2
	
	lea	$ffffa204.w,a4
	moveq.w	#WORM_NO-1,d5
all_the_worms:
	lea	degrade(pc),a5
	moveq.w	#DEGRADE_SIZE/16-1,d6
one_worm:	
	rept	16
	move.l	(a4),a2
	move.w	(a5)+,(a2)
	endr
	dbra	d6,one_worm
	dbra	d5,all_the_worms



;########################################################################
;#----------------------------------------------------------------------#
;# Test if we have to quit, or to go back to the beginning of the loop.	#
;#----------------------------------------------------------------------#	
;########################################################################

	IFNE	CPUTIME
	clr.l	$FFFF9800.w
	ENDC
	cmpi.b	#57,$fffffc02.w	
	BNE	REPEAT



;########################################################################
;#----------------------------------------------------------------------#
;# Before quitting the demo, restoration of the initial context.	#
;#----------------------------------------------------------------------#	
;########################################################################

	bsr	RESTORE_CONTEXT
	clr.w	(sp)
	trap	#1


	
;########################################################################
;#----------------------------------------------------------------------#	
;# Save the original context at the beginning of the demo ...	#
;#----------------------------------------------------------------------#	
;########################################################################

SAVE_CONTEXT:
	SUPER
	GET_SCREEN
	GET_COLORS
	GET_MFP
	GET_CACR
	ADR_ECRAN	#ecran1,adr_ecran1
	ADR_ECRAN	#ecran2,adr_ecran2
	RTS



;########################################################################
;#----------------------------------------------------------------------#	
;# Restore the initial context before we can quit the demo ...	#
;#----------------------------------------------------------------------#	
;########################################################################

RESTORE_CONTEXT:
;	CLR_OLDPHYSBASE
;	CLR_OLDLOGBASE
	SET_SCREEN	old_logbase,old_physbase,old_modecode
	PUT_COLORS
	PUT_CACR
	PUT_MFP
	MOUSE_ON
	FLUSH_KEYBOARD
	USER
	RTS



;########################################################################
;#----------------------------------------------------------------------#	
;# Load a program into the Dsp ...				#
;#----------------------------------------------------------------------#	
;########################################################################

LOAD_DSP_PROG:
	CHARGE_P56	#prog_dsp,#size_dsp	
	RTS
	even



;########################################################################
;#----------------------------------------------------------------------#	
;# Installation of the new context, to run the demo ...		#
;#----------------------------------------------------------------------#	
;########################################################################

NEW_CONTEXT:
	move.w	#$2700,sr
	INI_VBL
	SET_CACR	#%100010001
	move.w	#$2300,sr
	MOUSE_OFF
	FLUSH_KEYBOARD
	clr.l	$ffff9800.w
	clr.w	$ffff8240.w
	CLRSCR	adr_ecran1,#384*240*2/4-1
	CLRSCR	adr_ecran2,#384*240*2/4-1
	;SET_SCREEN	adr_ecran1,adr_ecran2,#TV50_384_240_TC
	SET_SCREEN	adr_ecran1,adr_ecran2,#%001100100
	RTS



;########################################################################
;#----------------------------------------------------------------------#
;# The Data section.					#
;#----------------------------------------------------------------------#
;########################################################################

	SECTION DATA

;#----------------------------------------------------------------------#
;# Sinus table with an angular accuracy of 0.2.			#
;#----------------------------------------------------------------------#

sinus:	incbin	data\sinustab.dat

;#----------------------------------------------------------------------#
;# Colour degrade for the curves.				#
;#----------------------------------------------------------------------#

degrade:	incbin	data\degrade.dat
	
;#----------------------------------------------------------------------#
;# Characteristics of every curve:				#
;# dc.w angle_a, angle_b, angle_c, angle_d, inc_a, inc_b, inc_c, inc_d	#
;#----------------------------------------------------------------------#

curves:	incbin	data\courbe.dat

;#----------------------------------------------------------------------#
;# Dsp program that compute the plot addresses to display the curves.	#
;#----------------------------------------------------------------------#

prog_dsp:	incbin	dspcurve.p56

size_dsp	equ	(*-prog_dsp)/3
	even



;########################################################################
;#----------------------------------------------------------------------#
;# The Bss section.					#
;#----------------------------------------------------------------------#
;########################################################################

	SECTION BSS

adr_ecran1:	ds.l	1
adr_ecran2:	ds.l	1
ecran1:	ds.b	384*240*2+256
ecran2:	ds.b	384*240*2+256



;########################################################################
;#----------------------------------------------------------------------#
	END
;#----------------------------------------------------------------------#
;########################################################################
