;########################################################################
;#----------------------------------------------------------------------#
;#						#
;# DSP PARAMETRIC CURVES		       (C) 1995 GASTON.	#
;#						#
;# v 1.00, 28 August 1996.				#
;#						#
;#----------------------------------------------------------------------#
;########################################################################
;#----------------------------------------------------------------------#
;#						#
;# The following program displays on the screen several parts of	#
;# different parametric curves. A parametric curve is defined by its	#
;# coordinates X=sin(a)*sin(b) and Y=sin(c)*sin(d), the four angles	#
;# varying differently for each curve.			#
;#						#
;# Here, you can choose the size of the segment that is displayed, and	#
;# also the maximal number of parametric curves.		#
;#						#
;#----------------------------------------------------------------------#
;########################################################################



;#----------------------------------------------------------------------#
;# PBC	  | PBC register address			#
;# HSR	  | HSR register address			#
;# HTX	  | HTX register address			#
;# SIZE_MAX   | Maximal size of the segments that are displayed	#
;# NUMBER_MAX | Maximal number of parametric curves		#
;#----------------------------------------------------------------------#

PBC	equ	$ffe0
HSR	equ	$ffe9
HTX	equ	$ffeb
SIZE_MAX	equ	176
NUMBER_MAX	equ	36

	org	p:$0
	jmp	start
	org	p:$40
start	movep	#1,X:PBC	



;########################################################################
;#----------------------------------------------------------------------#
;# Receive the 360*5 sinus values (angular precision of 0.2).	#
;#----------------------------------------------------------------------#
;########################################################################

	move	#-1,m0
	move	#<sinus1,r0
	move	#-1,m4
	move	#<sinus2,r4
	do	#360*5,get_sinus_table
wsin	jclr	#0,X:HSR,wsin
	move	X:HTX,x0
	move	x0,y0
	move	x0,X:(r0)+	y0,Y:(r4)+
get_sinus_table



;########################################################################
;#----------------------------------------------------------------------#
;# Receive the size of the curves, and their number.		#
;#----------------------------------------------------------------------#
;########################################################################

wsize	jclr	#0,X:HSR,wsize
	move	X:HTX,x0
	move	x0,X:size

wnumber	jclr	#0,X:HSR,wnumber
	move	X:HTX,x0
	move	x0,X:number



;########################################################################
;#----------------------------------------------------------------------#
;# Receive the characteristics of the curves (initial angles, and	#
;# increment values).					#
;#----------------------------------------------------------------------#
;########################################################################

	move	#curve,r0
	do	#8,get_8_params
	move	X:number,n0
	do	n0,get_curves
wcurb	jclr	#0,X:HSR,wcurb
	move	X:HTX,x0
	move	x0,X:(r0)+
get_curves	nop
get_8_params



;########################################################################
;#----------------------------------------------------------------------#
;# Initialisation of the 2 clear-buffer with the address received.	#
;#----------------------------------------------------------------------#
;########################################################################

wadr	jclr	#0,X:HSR,wadr
	move	X:HTX,x0
	move	#clear_buff1,r0
	move	#clear_buff2,r1
	move	X:size,n0
	do	n0,init_buffer
	move	X:number,n0
	do	n0,inibuf
	move	x0,Y:(r0)+
	move	x0,Y:(r1)+
inibuf	nop
init_buffer



;########################################################################
;#----------------------------------------------------------------------#
;# General initialisations of the Dsp program.			#
;#----------------------------------------------------------------------#
;########################################################################

;#----------------------------------------------------------------------#
;# y1= 0.5 * screen height (in lines)			#
;# x1= 0.5 * screen width (in pixels)			#
;#----------------------------------------------------------------------#

	move	#>$78,y1
	move	#>$C0,x1

;#----------------------------------------------------------------------#
;# Circular buffers for the sinus table, else linear buffers.	#
;#----------------------------------------------------------------------#

	move	#360*5-1,m2
	move	m2,m4
	move	m2,m3
	move	m2,m5
	move	#-1,m6
	move	m6,m7

;#----------------------------------------------------------------------#
;# The pointer (to clear the screen) is initialized on the 1st buffer.	#
;#----------------------------------------------------------------------#
	move	#clear_buff1,r0
	move	r0,Y:buff_ptr



;########################################################################
;#----------------------------------------------------------------------#
;# A new Vbl is beginning, at this point we are synchro with the 68030.	#
;#----------------------------------------------------------------------#
;########################################################################

SYNCHRONISATION_VBL



;########################################################################
;#----------------------------------------------------------------------#
;# Receive from the 68030 the screen address.			#
;#----------------------------------------------------------------------#
;########################################################################

	move	#screen,r1
addrscr	jclr	#0,X:HSR,addrscr
	move	X:HTX,x0
	move	x0,X:(r1)



;########################################################################
;#----------------------------------------------------------------------#
;# Send to the 68030 the addresses to clear.			#
;#----------------------------------------------------------------------#
;########################################################################

	move	Y:buff_ptr,r7
	move	X:number,n0
	do	n0,clear_points
	move	X:size,n0
	do	n0,clear
clr	jclr	#1,X:HSR,clr
	move	Y:(r7)+,x0
	move	x0,X:HTX
clear	nop
clear_points



;########################################################################
;#----------------------------------------------------------------------#
;# Initialisations done each Vbl.				#
;#----------------------------------------------------------------------#
;########################################################################

	move	#curve,r6	; 1st curve of the list.
	move	Y:buff_ptr,r7	; Point on the buffer.
	move	#2,n2	; angle a varying from 2*0.2=0.4 deg.
	move	#2,n4	;  ...  b  ...
	move	#2,n3	;  ...  c  ...
	move	#2,n5	;  ...  d  ...



;########################################################################
;#----------------------------------------------------------------------#
;# For each worm, that is to say each part of a curve, the loop begins.	#
;#----------------------------------------------------------------------#
;########################################################################

	move	X:number,n0
	do	n0,all_the_worms



;########################################################################
;#----------------------------------------------------------------------#
;# Read the 4 angles a,b,c and d, and point on the next ones.	#
;#----------------------------------------------------------------------#
;########################################################################

	move	X:(r6)+,r2
	move	X:(r6)+,r4
	move	X:(r6)+,r3
	move	X:(r6)+,r5
	rep	#4
	move	X:(r6)+,x0



;########################################################################
;#----------------------------------------------------------------------#
;# x0 is loaded with sin(a) and y0 with sin(b).			#
;#----------------------------------------------------------------------#
;########################################################################

	move	X:(r2)+n2,x0 	Y:(r4)+n4,y0



;########################################################################
;#----------------------------------------------------------------------#
;# We display a magnificient worm ...			#
;#----------------------------------------------------------------------#
;########################################################################

	move	X:size,n0
	do	n0,loop



;########################################################################
;#----------------------------------------------------------------------#
;# Here come some very difficult computations, but that is really	#
;# simple for the Dsp, do not worry ! ...				#
;#----------------------------------------------------------------------#
;########################################################################

	mpyr	x0,y0,b	x1,a
			; b1 <=sin(a)*sin(b) and a <=width
	move	b1,x0	; x0 <=sin(a)*sin(b)
	macr	x0,x1,a	X:(r3)+n3,x0	Y:(r5)+n5,y0
			; a1 <=sin(a)*sin(b)*width+width
			; and x0 <=sin(c) and y0 <=sin(d)
	move	a1,n6	; n6 <=final X coordinate
	mpyr	x0,y0,a	y1,b	
			; a1 <=sin(c)*sin(d) and b <=height
	move	a1,x0	; x0 <=sin(c)*sin(d)
	macr	x0,y1,b	; b1 <=sin(c)*sin(d)*height+height
	move	b1,y0	; y0 <=final height
	mpy	y0,x1,b	n6,a1
			; b0 <=final height*width and
			; we restore the final X coordinate
	move	b0,b1	; b1 <=final height*width
	add	b,a	X:(r1),b
			; b1 <=screen address and
			; a1 <=width+height=pixel no
	addl	b,a	X:(r2)+n2,x0 	Y:(r4)+n4,y0	
			; a1 <=screen address+pixel offset
			; =pixel address
			; and x0 <=sin(a) and y0 <=sin(b)		



;########################################################################
;#----------------------------------------------------------------------#
;# We send the plot address to the 68030, and what is more, we store	#
;# the address in the buffer to clear the point later ...		#
;#----------------------------------------------------------------------#
;########################################################################

emit	jclr	#1,X:HSR,emit
	move	a1,X:HTX
	move	a1,Y:(r7)+
loop



;########################################################################
;#----------------------------------------------------------------------#
;# End of the display of one worm.				#
;#----------------------------------------------------------------------#
;########################################################################

	nop
all_the_worms



;########################################################################
;#----------------------------------------------------------------------#
;# We change the clear-buffer, and we put its address in buff_ptr.	#
;#----------------------------------------------------------------------#
;########################################################################

	move	Y:buff_ptr,x0
	move	#clear_buff1,a
	sub	x0,a
	tst	a
	jne	lab1
	move	#clear_buff2,x0
	move	x0,Y:buff_ptr
	jmp	lab2
lab1	move	#clear_buff1,x0
	move	x0,Y:buff_ptr
lab2



;########################################################################
;#----------------------------------------------------------------------#
;# Compute the new angles, and replace the old ones.		#
;#----------------------------------------------------------------------#
;########################################################################

	move	#curve,r6
	move	X:number,n0
	do	n0,change_angles
	move	r6,r0	; Temporary save value.
	move	X:(r6)+,r2	; Angle.
	move	X:(r6)+,r4
	move	X:(r6)+,r3
	move	X:(r6)+,r5
	move	X:(r6)+,n2	; Increment value.
	move	X:(r6)+,n4
	move	X:(r6)+,n3
	move	X:(r6)+,n5
	lua	(r2)+n2,r2	; Angle+Inc = New angle.
	lua	(r4)+n4,r4
	lua	(r3)+n3,r3
	lua	(r5)+n5,r5
	move	r2,X:(r0)+	; We store the new angle.
	move	r4,X:(r0)+
	move	r3,X:(r0)+
	move	r5,X:(r0)+
change_angles



;########################################################################
;#----------------------------------------------------------------------#
;# Go back to the beginning of the loop ...			#
;#----------------------------------------------------------------------#
;########################################################################

	jmp	SYNCHRONISATION_VBL



;########################################################################
;#----------------------------------------------------------------------#
;# The data in X memory ...				#	
;#----------------------------------------------------------------------#
;########################################################################

	ORG	X:$0

;#----------------------------------------------------------------------#
;# Sinus table with an angular precision of 0.2.		#
;#----------------------------------------------------------------------#

sinus1	ds	360*5

;#----------------------------------------------------------------------#
;# Screen address sent by the 68030.			#
;#----------------------------------------------------------------------#

screen	ds	1

;#----------------------------------------------------------------------#
;# Size of the curves and number of curves.			#
;#----------------------------------------------------------------------#

size	ds	1
number	ds	1

;#----------------------------------------------------------------------#
;# Different curves, defined by lines looking like the following one :	#
;# dc a,b,c,d,inc_a,inc_b,inc_c,inc_d,vbl_a,vbl_b,vbl_c,vbl_d.	#
;#----------------------------------------------------------------------#

curve	ds	8*NUMBER_MAX



;########################################################################
;#----------------------------------------------------------------------#
;# The data in Y memory ...				#	
;#----------------------------------------------------------------------#
;########################################################################
			
	ORG	Y:$0

;#----------------------------------------------------------------------#
;# The same table that in X:$0.				#
;#----------------------------------------------------------------------#

sinus2	ds	360*5

;#----------------------------------------------------------------------#
;# Cyclicaly points on the next two buffers.			#
;#----------------------------------------------------------------------#

buff_ptr	ds	1

;#----------------------------------------------------------------------#
;# 2 clear-buffers for 2 screen in memory.			#
;#----------------------------------------------------------------------#

clear_buff1	ds	SIZE_MAX*NUMBER_MAX
clear_buff2	ds	SIZE_MAX*NUMBER_MAX



;########################################################################
;#----------------------------------------------------------------------#
	END
;#----------------------------------------------------------------------#
;########################################################################
