	OPT	O+,W-,X-
	OUTPUT	A:\DEMO.PRG
NB_CHOIX=5

LECRAN=320			; LARGEUR DE L'ECRAN EN PIXEL
HECRAN=200			; HAUTEUR DE L'ECRAN EN PIXEL
FIRST_Z_CERCLE=2000
SPEED_Z_CERCLE=25
RAY_CERCLE=190
LL_SCR7=(4+40)*2
NB_POINT=90
NB_ETAPE=256
LEN_ETAPE=NB_POINT*4
BSTEP=1024/NB_ETAPE*4

DEBUG=0
LINK=0	; 1=> LINK
CPU	MACRO
	 IFEQ	LINK
	  CMP.B	#$F,$FFFFFC02
	  BNE.S	.\@
	  MOVE	#\1,$FFFF8240
.\@
	 ENDC
	ENDM

;;  STRUCTURE DE LA QUEUE Z
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	RSRESET
Z_QUEUE_Z		RS.W	1
ADR_NEXT_QUEUE_Z	RS.L	1
X_QUEUE_Z		RS.W	1
Y_QUEUE_Z		RS.W	1
LEN_1QUEUE_Z	RS.B	1

DEBUT

	IFEQ	LINK
	 CLR.L	-(SP)
	 MOVE	#32,-(SP)
	 TRAP	#1
	 ADDQ	#6,SP
	 MOVE.L	D0,OLD_SP
	ENDC

	LEA	PILE,SP
	MOVEM.L	$FFFF8240,D0-D7
	MOVEM.L	D0-D7,OLD_PAL
	
	MOVE	#2,-(SP)
	TRAP	#14
	ADDQ	#2,SP
	MOVE.L	D0,OLD_PHY

	MOVE	#4,-(SP)
	TRAP	#14
	ADDQ	#2,SP
	MOVE.W	D0,OLD_RES

	CLR.W -(sp)
	MOVE.L #-1,-(SP)
	MOVE.L #-1,-(SP)
	MOVE.W #5,-(SP)
	TRAP #14
	ADD.W #12,SP
	
	DC.W $A00A

	IFEQ	DEBUG
	move.b	#$12,$FFFFFC02.W	* mouse hs
	 MOVE.B	$FFFFFA07,OLDA07
	 MOVE.B $FFFFFA09,OLDA09
	 MOVE.B	$FFFFFA13,OLDA13
	 MOVE.B $FFFFFA15,OLDA15
	 MOVE.B	$FFFFFA17,OLDA17
	 MOVE.B	$FFFFFA1B,OLDA1B
	 MOVE.B	$FFFFFA21,OLDA21
	 MOVE.L	$70,OLD70
	 MOVE.L	$120,OLD120
	 AND.B	#$FE,$FFFFFA07
	 AND.B	#$FE,$FFFFFA13
	 AND.B #$8F,$FFFFFA09.W
	 AND.B #$8F,$FFFFFA15.W

	 SF	PAL_UP
	 SF	EXIT_FLAG
	 MOVE.L	#VBL,$70
	 CLR.L	RT_VBL
	 MOVE	#$2300,SR
	ENDC
	
	MOVE.L	#SCREEN+255,D0
	CLR.B	D0
	MOVE.L	D0,ECR1
	ADD.L	#32000+2560,D0
	MOVE.L	D0,ECR2

	MOVEQ	#1,D0
	JSR	MUSIK

	TST.B	$FFFFFC02
	TST.B	$FFFFFC02

	BSR	DOWN_BLACK
	BSR	SWAP_ECR
	BSR	CLS
	BSR	MAKE_PAL
	BSR	PRP_EUROSWAP
	BSR	PRP_APPEAR
	BSR	PRP_CNV_ASCII_MINI
	BSR	PRP_CNV_ASCII7
	BSR	PRP_SCR_7
	BSR	PRP_GENE
	BSR	RETAPE_LOG
	BSR	PRP_IMG1P
	SF	FLG_SLDD
	MOVE	#7,ETAPE_SLDD
	CLR	CPT_SLDD
	SF	FLG_FAPP
	MOVE	#100-16,Y_LOGO
	MOVE.L	#SCENARIO,PT_VBL
	ST	GET_NEW_VBL
	MOVE	#199-32,LIGNE_1P
	MOVE.L	#CONTROL_VBL,RT_VBL
	CLR	ETAPE_SLD
	CLR	CPT_SLD
	BSR	PRC_3D
	ST	PEU_GO_3D
.FIN	BRA.S	.FIN

SCENARIO	DC.L	LANCE_CERCLE1,PART_APPLOGO,LANCE_CERCLE2
	DC.L	PART_LOG_UP,LANCE_MAIN

LANCE_CERCLE1
	SF	FLG_AFF_CLR
	MOVE.L	#PART_CERCLE,RT_IN_VBL
	BSR	INIT_PART_CERCLE
	BSR	PART_CERCLE
	RTS
LANCE_CERCLE2
	ST	FLG_AFF_CLR
	MOVE.L	#PART_CERCLE,RT_IN_VBL
	BSR	INIT_PART_CERCLE
	BSR	PART_CERCLE
	RTS
INIT_PART_CERCLE
	SF	FLG_FCERCLE
	CLR	CPT_OUT
	MOVE	#FIRST_Z_CERCLE,Z_CERCLE
	RTS
LANCE_MAIN
	ST	PAL_UP
	BSR	PART_MAIN
	RTS

PART_MAIN
	BSR	AFF_IMG1P
	BSR	SCROLL_7
	TST.B	PEU_GO_3D
	BEQ.S	.P3D
	BSR	DO_3D
.P3D
	BSR	SIN_LOG
;	REPT	10
;	MOVE	#$333,$FFFF8240
;	MOVE	#$0,$FFFF8240
;	ENDR
	BSR	SWAP_ECR

	MOVEQ	#0,D0
	MOVE.B	$FFFFFC02,D0
	CMP	#$3B+$80,D0
	BLT.S	.PSEL
	CMP	#$3B+$80+NB_CHOIX-1,D0
	BGT.S	.PSEL
	SUB	#$3B+$80,D0
	MOVE	D0,CHOIX
	ST	FLG_SLDD
.PSEL	RTS

PART_CERCLE
	MOVEM.L	PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240

	BSR	GEST_CERCLE

	BSR	SWAP_ECR
	
	TST.B	FLG_FCERCLE
	BEQ.S	.AZA
	ST	GET_NEW_VBL
.AZA
	RTS

PART_APPLOGO
	MOVEM.L	PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240

	REPT	2
	 BSR	GEST_APPLOGO

	 TST.B	FLG_FAPP
	 BNE	.FLOOP
	ENDR
	RTS
.FLOOP
	BSR	RECO_PHY_ON_LOG
	ST	GET_NEW_VBL
	RTS

RECO_PHY_ON_LOG
	MOVE.L	ECR2,A0
	MOVE.L	ECR1,A1
	MOVE	#7999,D0
.RECO	MOVE.L	(A0)+,(A1)+
	DBRA	D0,.RECO
	RTS

PART_LOG_UP
	MOVEM.L	PAL,D0-D7
	MOVEM.L	D0-D7,$FFFF8240

	BSR	LOG_UP
	TST	Y_LOGO
	BGE	.LP
	BSR	RECO_PHY_ON_LOG
	ST	GET_NEW_VBL
.LP	RTS

;;  SORTIE DE LA DEMO
;;;;;;;;;;;;;;;;;;;;;;;
SORT_DEMO
	AND.B	#$FE,$FFFFFA07
	AND.B	#$FE,$FFFFFA13
	MOVE.L	OLD70,$70
	MOVE.L	OLD120,$120

	MOVE.B	OLDA15,$FFFFFA15
	MOVE.B	OLDA17,$FFFFFA17
	MOVE.B	OLDA1B,$FFFFFA1B
	MOVE.B	OLDA21,$FFFFFA21
	MOVE.B	OLDA13,$FFFFFA13
	MOVE.B	OLDA07,$FFFFFA07
	MOVE.B	OLDA09,$FFFFFA09

	TST.B	$FFFFFC02
	TST.B	$FFFFFC02

	MOVE.L	#$0707FFFF,$FFFF8800
	MOVE.L	#$08080000,$FFFF8800
	MOVE.L	#$09090000,$FFFF8800
	MOVE.L	#$0A0A0000,$FFFF8800

	MOVE.B	#3,$FFFFFC00.w *reset du clavier
	MOVE.B	#$96,$FFFFFC00.w

ATTDISPO
	btst #1,$fffffc00.W
	beq.s ATTDISPO
	move.b #$80,$fffffc02.w
ATTDISPO1
	btst #1,$fffffc00.W
	beq.s ATTDISPO1
	move.b #$01,$fffffc02.w


	MOVE	#$2300,SR

	MOVE.W OLD_RES,-(SP)	
	MOVE.L	OLD_PHY,D0
	MOVE.L D0,-(SP)
	MOVE.L D0,-(SP)
	MOVE.W #5,-(SP)
	TRAP #14
	ADD.W #12,SP
	
	
	MOVE	#0,-(SP)		; ETAPE SLD
.FADE	MOVE	#3,-(SP)
.LP	MOVE	#37,-(SP)
	TRAP	#14		; 3 VSYNC
	ADDQ	#2,SP
	SUBQ	#1,(SP)
	BGT.S	.LP
	ADDQ	#2,SP
		
	LEA	OLD_PAL,A0
	LEA	$FFFF8240,A1
	MOVE	(SP),D6		; ETAPE
	MOVEQ	#16,D7		; 16 COULEURS
	BSR	CALC_SLD
	ADDQ	#1,(SP)		; ETAPE+1
	CMP	#7,(SP)
	BLE	.FADE		; ON RESTORE L'ANCIENNE PALETTE
	ADDQ	#2,SP

	MOVE	#25,-(SP)
.WAIT	MOVE	#37,-(SP)
	TRAP	#14		; ATTEND UNE 1/2 SECONDE.
	ADDQ	#2,SP
	SUBQ	#1,(SP)
	BGT.S	.WAIT
	
.WCAR	MOVE	#2,-(SP)		; CLAVIER
	MOVE	#1,-(SP)
	TRAP	#13		; BCONSTAT
	ADDQ	#4,SP
	TST	D0		; CARACT DISPONIBLE ?
	BEQ	.NO_CAR
	MOVE	#7,-(SP)		; OUI ALORS ON LE LIT
	TRAP	#1		; ET ON REGARDE SUI IL Y EN A
	ADDQ	#2,SP		; D'AUTRES !
	BRA.S	.WCAR
.NO_CAR
;	MOVE	#$700,$FFFF8240
	DC.W $A009
	MOVE.L	OLD_SP,-(SP)
	MOVE	#32,-(SP)
	TRAP	#1		; RETOURNE MODE
	ADDQ	#6,SP		; UTILISATEUR +OLD PILE
	
	MOVE	CHOIX,-(SP)		; SORT, RETOURNE NUM CHOIX
	MOVE	#$4C,-(SP)		; DANS D0.
	TRAP	#1

;; IT VBL
;;;;;;;;;;;
	IFEQ	DEBUG
VBL	 MOVEM.L	D0-A6,-(SP)
	 TST.B	PAL_UP
	 BEQ.S	.NOP
	 MOVE	ETAPE_SLDD,D6
	 CMP	#7,D6
	 BNE.S	.AZPLS
	 MOVEM.L	PAL,D0-D7
	 MOVEM.L	D0-D7,$FFFF8240
	 BRA.S	.PLS
.AZPLS	 MOVEQ	#16,D7
	 LEA	PAL,A0
	 LEA	$FFFF8240,A1
	 BSR	CALC_SLD
.PLS	 
	 CLR.B	$FFFFFA1B
	 OR.B	#1,$FFFFFA07
	 OR.B	#1,$FFFFFA13
	 MOVE.B	#$40,$FFFFFA17
	 MOVE.L	#HBL,$120
	 MOVE.B	#32,$FFFFFA21
	 MOVE.B	#8,$FFFFFA1B
	 BSR	SLIDE_PAL1
.NOP
	 JSR	MUSIK+8

	 MOVE.L	RT_VBL,D0
	 BEQ.S	.NO_VBL
	 MOVE.L	D0,A0
	 JSR	(A0)
.NO_VBL
	 MOVEM.L	(SP)+,D0-A6
	 ADDQ	#1,SYNC
	 TST.B	EXIT_FLAG
	 BEQ.S	.PEXIT
	 MOVE.L	#SORT_DEMO,2(SP)	; SORT VERS ROUTINE SORTIE
	 MOVE	#$2700,(SP)		; COUPE VBL EN SORTANT
.PEXIT	 RTE

;;  ROUTINE DE CONTROL DE LA DEMO SOUS VBL, POUR LE PRECALCULE DE LA 3D
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CONTROL_VBL
	TST.B	GET_NEW_VBL
	BEQ.S	.GO
	MOVE.L	PT_VBL,A0
	MOVE.L	(A0)+,RT_IN_VBL
	MOVE.L	A0,PT_VBL
	SF	GET_NEW_VBL
.GO
	MOVE.L	RT_IN_VBL,D0
	BEQ.S	.OUT
	MOVE.L	D0,A0
	JSR	(A0)
.OUT	
	RTS

;;  IT HBL
;;;;;;;;;;;;
HBL
	 PEA	(A0)
	 PEA	(A1)
	 LEA	PAL3,A0
	 LEA	$FFFF8240.W,A1
	 REPT	8
	  MOVE.L	(A0)+,(A1)+
	 ENDR
	 MOVE.L	(SP)+,A1
	 MOVE.L	(SP)+,A0
	 CLR.B	$FFFFFA1B
	 RTE
	ENDC

;;  VSYNC
;;;;;;;;;;;
VSYNC
	IFEQ	DEBUG
	 MOVE	SYNC,D0
.BVSYNC	 CMP	SYNC,D0
	 BEQ.S	.BVSYNC
	ELSEIF
;	 MOVE	#$25,-(SP)
;	 TRAP	#14		; VSYNC
;	 ADDQ	#2,SP
	ENDC
	RTS

;; EFFACEMENT DE L'ECRAN
;;;;;;;;;;;;;;;;;;;;;;;;;;
CLS	
	MOVE.L	ECR1,A0
	MOVE.L	ECR2,A1
	MOVEQ	#0,D0
	MOVE	#7999,D1
.BCLS	MOVE.L	D0,(A0)+
	MOVE.L	D0,(A1)+
	DBRA	D1,.BCLS
	RTS

;;  SWAPPING D'ECRAN
;;;;;;;;;;;;;;;;;;;;;;
SWAP_ECR
	MOVE.L	ECR1,D0
	MOVE.L	ECR2,ECR1
	MOVE.L	D0,ECR2
	LSR	#8,D0
	MOVE.L	D0,$FFFF8200
	RTS
	
;; ROUTINE D'AFFICHAGE D'UN CERCLE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ENTREE:	D0=> RAYON
;	D3=> X CENTRE
;	D4=> Y CENTRE
CERCLE1
	ADD	D0,D0
	ADD	D0,D0

	ADD	D3,D3
	ADD	D3,D3
	
	ADD	D4,D4
	ADD	D4,D4


	MOVE	D0,-(SP)	; SAUVE LE RAYON
	MOVEQ	#0,D1	; D0,D1= X, Y	(TOUT *4)
	MOVEQ	#0,D2	; D2=ERREUR
	LEA	BUFF_V,A0
; D0-D4=> RESERVE
.LOOP
	MOVE	D3,D5	; XBASE
	ADD	D0,D5	; +X
	MOVE	D4,D6	; YBASE
	ADD	D1,D6	; +Y
	CMP	#HECRAN*4,D6
	BGE.S	.OCT_0_A_3
	MOVE	D5,2(A0,D6)	; OCTANT 7
	MOVE	D3,D5
	SUB	D0,D5	; X MIROIR H
	MOVE	D5,(A0,D6)	; OCTANT 4

	MOVE	D3,D5	; XBASE
	ADD	D1,D5
	MOVE	D4,D6
	ADD	D0,D6	; Y
	MOVE	D5,2(A0,D6)	; OCTANT 6
	MOVE	D3,D5	; XBASE
	SUB	D1,D5
	MOVE	D5,(A0,D6)	; OCTANT 5
.OCT_0_A_3
	MOVE	D3,D5
	ADD	D0,D5	; X
	MOVE	D4,D6
	SUB	D1,D6	; YBASE (-)
	BLT.S	.FOCTANT
	MOVE	D5,2(A0,D6)	; OCTANT 0
	MOVE	D3,D5
	SUB	D0,D5
	MOVE	D5,(A0,D6)	; OCTANT 3

	MOVE	D3,D5
	ADD	D1,D5	; X
	MOVE	D4,D6
	SUB	D0,D6	; Y
	BLT.S	.FOCTANT
	MOVE	D5,2(A0,D6)	; OCTANT 1
	MOVE	D3,D5
	SUB	D1,D5
	MOVE	D5,(A0,D6)	; OCTANT 2
.FOCTANT

	TST	D2
	BMI.S	.YMOINS
	SUB	D0,D2
	SUBQ	#4,D2
	SUBQ	#4,D0
.YMOINS
	ADDQ	#4,D1	
	ADD	D1,D2
	CMP	D0,D1
	BLE	.LOOP

	MOVE	(SP)+,D5	; D5=> RAYON*4
	MOVE	D4,D0	; TOUJOURS EN X*4 ET EN Y*4
	SUB	D5,D0	; D0=YMIN
	BGE.S	.PCL_UP
	MOVEQ	#0,D0
.PCL_UP
	MOVE	D4,D1
	ADD	D5,D1
	CMP	#(HECRAN-1)*4,D1
	BLT.S	.PCL_DOWN
	MOVE	#(HECRAN-1)*4,D1
.PCL_DOWN
	ADDQ	#4,D1	; LE DERNIER Y EST INCLUS=>+4
	SUB	D0,D1
	ASR	#2,D1	; D1=> NOMBRE DE LIGNE EN VERTICALE
	
	TST.B	FLG_AFF_CLR
	BNE.S	.CLEAR
	BSR	AFF_ALL_LIGNE	
	RTS
.CLEAR	BSR	AFF_ALL_LIGNE2
	RTS
;;  ROUTINE D'AFFICHAGE DE TOUTES LES LIGNES (PAR BALAYAGE VERTICAL)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  ENTREE:	D0=> Y DE DEPART *4
;;	D1=> NOMBRE DE LIGNE VERTICALE A AFFICHER
FLIGNE_RT	MACRO
	DBRA	D7,.BLIGNE
	RTS
	ENDM

AFF_ALL_LIGNE
	LEA	BUFF_V,A0
	ADD	D0,A0
	MOVE	D1,D7
	BEQ	.RTS	; SI 0 LIGNE A AFFICHER
	SUBQ	#1,D7	; CAUSE DBRA
	ASR	D0
	MOVE.L	ECR1,A1	; A1=> ECRAN
	LEA	TAB_Y,A2
	ADD	(A2,D0),A1	; A1=> ECRAN+Y

	LEA	TAB_X,A3	; A3=> TABLE DE CONVERSION DES X
	LEA	TAB_X2,A4	; A4=> 2EME TABLE DE CONVERSION DES X

	MOVEQ	#-1,D6	; D6=> -1 REMPLISSAGE LIGNE
	
.BLIGNE	MOVE.L	A1,A2	; A2=> ON Y AFFICHE
	LEA	160(A1),A1	; POUR LA PROCHAINE LIGNE
	
	MOVE	(A0)+,D0	; D0=> XMIN*4
	BGE.S	.PCL_G
	MOVEQ	#0,D0
.PCL_G	MOVE	(A0)+,D1	; D1=> XMAX*4
	CMP	#LECRAN*4,D1
	BLT.S	.PCL_D
	MOVE	#LECRAN*4,D1
.PCL_D
	MOVE.L	(A3,D0),D0	; VALEUR DE GAUCHE
	MOVE.L	(A4,D1),D1	; VALEUR DE DROITE
	ADD	D0,A2	; A2=> ECRAN+Y+POS X CETTE LIGNE
	SUB	D0,D1
	MOVE	D1,D2	; D2=> LARGEUR/16-1
	SWAP	D0
	SWAP	D1
	ASR	D2
	JMP	.TJMP_HLINE(PC,D2)
.RTS
	RTS
	OPT	O-
.TJMP_HLINE	BRA	.HLINE0
	BRA	.HLINE1
	BRA	.HLINE2
	BRA	.HLINE3
	BRA	.HLINE4
	BRA	.HLINE5
	BRA	.HLINE6
	BRA	.HLINE7
	BRA	.HLINE8
	BRA	.HLINE9
	BRA	.HLINE10
	BRA	.HLINE11
	BRA	.HLINE12
	BRA	.HLINE13
	BRA	.HLINE14
	BRA	.HLINE15
	BRA	.HLINE16
	BRA	.HLINE17
	BRA	.HLINE18
	BRA	.HLINE19
	BRA	.HLINE20
	OPT	O+
.HLINE0
	AND	D1,D0
	OR	D0,(A2)
	FLIGNE_RT
.HLINE1
	OR	D0,(A2)
	OR	D1,8(A2)
	FLIGNE_RT
.HLINE2
	OR	D0,(A2)
	MOVE	D6,8(A2)
	OR	D1,16(A2)
	FLIGNE_RT
.HLINE3
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	OR	D1,24(A2)
	FLIGNE_RT
.HLINE4
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	OR	D1,32(A2)
	FLIGNE_RT
.HLINE5
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	OR	D1,40(A2)
	FLIGNE_RT
.HLINE6
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	OR	D1,48(A2)
	FLIGNE_RT
.HLINE7
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	OR	D1,56(A2)
	FLIGNE_RT
.HLINE8
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	OR	D1,64(A2)
	FLIGNE_RT
.HLINE9
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	OR	D1,72(A2)
	FLIGNE_RT
.HLINE10
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	OR	D1,80(A2)
	FLIGNE_RT
.HLINE11
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	OR	D1,88(A2)
	FLIGNE_RT
.HLINE12
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	OR	D1,96(A2)
	FLIGNE_RT
.HLINE13
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,96(A2)
	OR	D1,104(A2)
	FLIGNE_RT
.HLINE14
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	OR	D1,112(A2)
	FLIGNE_RT
.HLINE15
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	OR	D1,120(A2)
	FLIGNE_RT
.HLINE16
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	OR	D1,128(A2)
	FLIGNE_RT
.HLINE17
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	OR	D1,136(A2)
	FLIGNE_RT
.HLINE18
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	OR	D1,144(A2)
	FLIGNE_RT
.HLINE19
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	MOVE	D6,144(A2)
	OR	D1,152(A2)
	FLIGNE_RT
.HLINE20
	OR	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	MOVE	D6,144(A2)
	MOVE	D6,152(A2)
	FLIGNE_RT

AFF_ALL_LIGNE2
	LEA	BUFF_V,A0
	ADD	D0,A0
	MOVE	D1,D7
	BEQ	.RTS	; SI 0 LIGNE A AFFICHER
	SUBQ	#1,D7	; CAUSE DBRA
	ASR	D0
	MOVE.L	ECR1,A1	; A1=> ECRAN
	LEA	TAB_Y,A2
	ADD	(A2,D0),A1	; A1=> ECRAN+Y

	LEA	TAB_X,A3	; A3=> TABLE DE CONVERSION DES X
	LEA	TAB_X2,A4	; A4=> 2EME TABLE DE CONVERSION DES X

	MOVEQ	#0,D6	; D6=> -1 REMPLISSAGE LIGNE
	
.BLIGNE	MOVE.L	A1,A2	; A2=> ON Y AFFICHE
	LEA	160(A1),A1	; POUR LA PROCHAINE LIGNE
	
	MOVE	(A0)+,D0	; D0=> XMIN*4
	BGE.S	.PCL_G
	MOVEQ	#0,D0
.PCL_G	MOVE	(A0)+,D1	; D1=> XMAX*4
	CMP	#LECRAN*4,D1
	BLT.S	.PCL_D
	MOVE	#LECRAN*4,D1
.PCL_D
	MOVE.L	(A3,D0),D0	; VALEUR DE GAUCHE
	MOVE.L	(A4,D1),D1	; VALEUR DE DROITE
	ADD	D0,A2	; A2=> ECRAN+Y+POS X CETTE LIGNE
	SUB	D0,D1
	MOVE	D1,D2	; D2=> LARGEUR/16-1
	SWAP	D0
	SWAP	D1
	ASR	D2
	NOT	D0
	NOT	D1
	JMP	.TJMP_HLINE(PC,D2)
.RTS
	RTS
	OPT	O-
.TJMP_HLINE	BRA	.HLINE0
	BRA	.HLINE1
	BRA	.HLINE2
	BRA	.HLINE3
	BRA	.HLINE4
	BRA	.HLINE5
	BRA	.HLINE6
	BRA	.HLINE7
	BRA	.HLINE8
	BRA	.HLINE9
	BRA	.HLINE10
	BRA	.HLINE11
	BRA	.HLINE12
	BRA	.HLINE13
	BRA	.HLINE14
	BRA	.HLINE15
	BRA	.HLINE16
	BRA	.HLINE17
	BRA	.HLINE18
	BRA	.HLINE19
	BRA	.HLINE20
	OPT	O+
.HLINE0
	OR	D1,D0
	AND	D0,(A2)
	FLIGNE_RT
.HLINE1
	AND	D0,(A2)
	AND	D1,8(A2)
	FLIGNE_RT
.HLINE2
	AND	D0,(A2)
	MOVE	D6,8(A2)
	AND	D1,16(A2)
	FLIGNE_RT
.HLINE3
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	AND	D1,24(A2)
	FLIGNE_RT
.HLINE4
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	AND	D1,32(A2)
	FLIGNE_RT
.HLINE5
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	AND	D1,40(A2)
	FLIGNE_RT
.HLINE6
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	AND	D1,48(A2)
	FLIGNE_RT
.HLINE7
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	AND	D1,56(A2)
	FLIGNE_RT
.HLINE8
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	AND	D1,64(A2)
	FLIGNE_RT
.HLINE9
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	AND	D1,72(A2)
	FLIGNE_RT
.HLINE10
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	AND	D1,80(A2)
	FLIGNE_RT
.HLINE11
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	AND	D1,88(A2)
	FLIGNE_RT
.HLINE12
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	AND	D1,96(A2)
	FLIGNE_RT
.HLINE13
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,96(A2)
	AND	D1,104(A2)
	FLIGNE_RT
.HLINE14
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	AND	D1,112(A2)
	FLIGNE_RT
.HLINE15
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	AND	D1,120(A2)
	FLIGNE_RT
.HLINE16
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	AND	D1,128(A2)
	FLIGNE_RT
.HLINE17
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	AND	D1,136(A2)
	FLIGNE_RT
.HLINE18
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	AND	D1,144(A2)
	FLIGNE_RT
.HLINE19
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	MOVE	D6,144(A2)
	AND	D1,152(A2)
	FLIGNE_RT
.HLINE20
	AND	D0,(A2)
	MOVE	D6,8(A2)
	MOVE	D6,16(A2)
	MOVE	D6,24(A2)
	MOVE	D6,32(A2)
	MOVE	D6,40(A2)
	MOVE	D6,48(A2)
	MOVE	D6,56(A2)
	MOVE	D6,64(A2)
	MOVE	D6,72(A2)
	MOVE	D6,80(A2)
	MOVE	D6,88(A2)
	MOVE	D6,104(A2)
	MOVE	D6,112(A2)
	MOVE	D6,120(A2)
	MOVE	D6,128(A2)
	MOVE	D6,136(A2)
	MOVE	D6,144(A2)
	MOVE	D6,152(A2)
	FLIGNE_RT

;;  GESTION DES CERCLES
;;;;;;;;;;;;;;;;;;;;;;;;;
GEST_CERCLE
	MOVE	Z_CERCLE,D1
	SUB	#SPEED_Z_CERCLE,D1
	BGT.S	.ZOKAY
	MOVEQ	#0,D1
	ADDQ	#1,CPT_OUT
	CMP	#2,CPT_OUT
	BLT.S	.ZOKAY
	ST	FLG_FCERCLE
.ZOKAY
	MOVE	D1,Z_CERCLE
	ADD	#256,D1
	
	MOVE.L	#RAY_CERCLE<<8,D0
	DIVS	D1,D0
	AND.L	#$FFFF,D0
	MOVE.L	#159,D3		; X CENTRE
	MOVE.L	#99,D4		; Y CENTRE
	BSR	CERCLE1		; AFFICHAGE DU CERCLE
	RTS

;;  PREPARATION DE LA PALETTE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MAKE_PAL
	LEA	PAL+4,A0
	LEA	PAL_LOGO,A1
	MOVEQ	#7-1,D0
.LP
	MOVE	(A1)+,(A0)+
	MOVE	#$5,(A0)+
	DBRA	D0,.LP
	RTS

;;  PREDECALAGE DU LOGO
;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_EUROSWAP
	LEA	LOGO,A0
	LEA	PRD_EUROSWAP,A1
	MOVE	#20*32-1,D0
.RECO	CLR	(A1)+
	MOVE.L	(A0)+,(A1)+
	MOVE	(A0)+,(A1)+
	ADDQ	#2,A0
	DBRA	D0,.RECO

	LEA	PRD_EUROSWAP,A0
	MOVE	#160*32*15/2-1,D0
.DECA
	MOVE	(A0)+,D1
	LSR	D1
	BCC.S	.OUT
	MOVE.B	#128,8(A1)
.OUT	OR	D1,(A1)+
	DBRA	D0,.DECA

	LEA	EURO_CRB,A0
	MOVE.L	A0,PT_CRB
	LEA	FEURO_CRB,A1
	MOVE	#31,D0
.RE	MOVE	(A0)+,(A1)+
	DBRA	D0,.RE
	RTS

;;  PREDECALAGE DE LA FORME D'APPARITION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
PRP_APPEAR
	LEA	APPEAR,A0
	LEA	PRD_APPEAR,A1
	MOVEQ	#32-1,D0
.RECO	MOVE	(A0)+,D1
	OR	(A0)+,D1
	OR	(A0)+,D1
	OR	(A0)+,D1
	MOVE	D1,(A1)+
	MOVE	D1,(A1)+
	CLR.L	(A1)+
	DBRA	D0,.RECO

	LEA	PRD_APPEAR,A0
	MOVE	#32*15-1,D0
.LP
	MOVE	(A0),D1
	SWAP	D1
	MOVE	4(A0),D1
	LSR.L	D1
	SWAP	D1
	MOVE	D1,(A1)+
	MOVE	D1,(A1)+
	SWAP	D1
	MOVE	D1,(A1)+
	MOVE	D1,(A1)+
	LEA	8(A0),A0
	DBRA	D0,.LP
	RTS

;;  GESTION DE L'APPARITION DU LOGO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GEST_APPLOGO
	MOVE	X_APP,D0
	ADDQ	#1,X_APP
	CMP	#304,D0
	BLT.S	.ZOKAY
	MOVE	#304,D0
	ST	FLG_FAPP
.ZOKAY
	MOVEQ	#15,D1
	AND	D0,D1
	SUB	D1,D0
	ASR	D0
	MOVE.L	ECR2,A1
	LEA	160*(100-16)(A1),A1
	ADD	D0,A1		; A1: DST ECRAN
	LEA	PRD_EUROSWAP,A0
	ADD	D0,A0		; A0: PARTIE LOG AFF
	LEA	PRD_APPEAR,A2
	LSL.L	#5+3,D1
	ADD.L	D1,A2		; A2: MASQUE APPARITION

	MOVEQ	#31,D7
.LP
	MOVEM.L	(A0)+,D0-D3
	MOVE.L	(A2)+,D4
	MOVE.L	(A2)+,D5
	AND.L	D4,D0
	AND.L	D4,D1
	AND.L	D5,D2
	AND.L	D5,D3

	MOVE.L	D0,D4
	OR.L	D1,D4
	MOVE.L	D4,D5
	SWAP	D4
	OR.L	D5,D4
	NOT.L	D4
	MOVE.L	D2,D5
	OR.L	D3,D5
	MOVE.L	D5,D6
	SWAP	D6
	OR.L	D6,D5
	NOT.L	D5

	AND.L	D4,(A1)
	OR.L	D0,(A1)+
	AND.L	(A1),D4
	OR.L	D1,D4
	MOVE.L	D4,(A1)+

	AND.L	D5,(A1)
	OR.L	D2,(A1)+
	AND.L	(A1),D5
	OR.L	D3,D5
	MOVE.L	D5,(A1)+

	LEA	160-16(A1),A1
	LEA	160-16(A0),A0
	DBRA	D7,.LP
	RTS

;;  MONTE DU LOGO
;;;;;;;;;;;;;;;;;;;
LOG_UP
	MOVE	Y_LOGO,D0
	BGE.S	.OK
	MOVEQ	#0,D0
.OK	MULU	#160,D0
	MOVE.L	ECR2,A6
	ADD	D0,A6
	LEA	PRD_EUROSWAP,A5
	
	MOVE	#32/4,-(SP)
.LP
X	SET	0
	REPT	4
	 MOVEM.L	(A5)+,D0-A4
	 MOVEM.L	D0-A4,X(A6)		; 52
	 MOVEM.L	(A5)+,D0-A4
	 MOVEM.L	D0-A4,X+52(A6)	; 104
	 MOVEM.L	(A5)+,D0-A3
	 MOVEM.L	D0-A3,X+104(A6)	; 152
	 ADDQ	#8,A5
X	 SET	X+160
	ENDR
	LEA	X(A6),A6
	SUBQ	#1,(SP)
	BGT	.LP
	ADDQ	#2,SP

	MOVEQ	#0,D1
	MOVE	#20-1,D7
.AZ	MOVE.L	D1,(A6)+
	MOVE.L	D1,(A6)+
	DBRA	D7,.AZ

	SUBQ	#1,Y_LOGO	
	RTS

;;  SIN LOG
;;;;;;;;;;;;;
SIN_LOG
	MOVE.L	PT_CRB,A0
	CMP.L	#FEURO_CRB,A0
	BLT.S	.PF
	LEA	EURO_CRB+50*2,A0
.PF	MOVE.L	A0,PT_CRB
	ADDQ.L	#2,PT_CRB

	MOVE.L	A0,A5
	MOVE.L	ECR1,A6
	MOVEQ	#31,D7
	MOVE.L	#PRD_EUROSWAP,.AUTO+2
.BL	MOVEQ	#0,D0
	MOVE	(A5)+,D0
	ADD.L	D0,D0
	ADD.L	D0,D0
.AUTO	LEA	PRD_EUROSWAP,A4
	ADD.L	D0,A4
	MOVEM.L	(A4)+,D0-D6/A0-A3
	MOVEM.L	D0-D6/A0-A3,(A6)	; 44
	MOVEM.L	(A4)+,D0-D6/A0-A3
	MOVEM.L	D0-D6/A0-A3,44(A6)	; 88
	MOVEM.L	(A4)+,D0-D6/A0-A3
	MOVEM.L	D0-D6/A0-A3,88(A6)	; 132
	MOVEM.L	(A4)+,D0-D6
	MOVEM.L	D0-D6,132(A6)
	LEA	160(A6),A6
	ADD.L	#160,.AUTO+2
	DBRA	D7,.BL
	RTS

;;  PREPARATION DE LA TABLE DE CONVERSION ASCII=> NUM CARAC DS FONTE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_CNV_ASCII7
	LEA	ORDRE_FNT7,A0
	LEA	TCNV_ASCII7,A1
	MOVE	#255,D0	; EFFACE LA TABLE
.BEFF	MOVE.B	#56-1,(A1,D0)	; MET DES ESPACES PARTOUT
	DBRA	D0,.BEFF
	
	MOVEQ	#0,D1
.BCNV	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BEQ.S	.FIN
	MOVE.B	D1,(A1,D0)
	ADDQ	#1,D1
	BRA	.BCNV
.FIN
	RTS

;;  PREPARATION DE LA TABLE DE CONVERSION ASCII=> NUM CARAC DS FONTE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_CNV_ASCII_MINI
	LEA	ORDRE_MINI,A0
	LEA	TCNV_ASCII_MINI,A1
	MOVE	#255,D0	; EFFACE LA TABLE
.BEFF	MOVE.B	#57-1,(A1,D0)	; MET DES ESPACES PARTOUT
	DBRA	D0,.BEFF
	
	MOVEQ	#0,D1
.BCNV	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BEQ.S	.FIN
	MOVE.B	D1,(A1,D0)
	ADDQ	#1,D1
	BRA	.BCNV
.FIN
	RTS

;;  PREPARATION DU SCROLL 7
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_SCR_7
	MOVE.L	#TEXT7A,PT_TEXT7
	LEA	TCNV_ASCII7,A0
	MOVEQ	#32,D0
	MOVE.B	(A0,D0),D0
	MULU	#7*2,D0
	ADD.L	#FNT7,D0
	MOVE.L	D0,ADR_L7
	CLR	DECA_7
	MOVE.L	#BUFF_SCR7,ADR_BUFF7
	MOVE	#4,POS_7

	LEA	CRBY_SCR,A0
	MOVE.L	A0,PT_CRBY
	MOVE.L	A0,OLDPT_CRBY
	MOVE.L	A0,OLDPT_CRBY2
	LEA	FCRB_Y,A1
	MOVE	#39,D0
.AZPO	MOVE	(A0)+,(A1)+
	DBRA	D0,.AZPO
	RTS

;;  SCROLL 7
;;;;;;;;;;;;;;
SCROLL_7
	BSR	AFF_L7

	MOVE.L	PT_CRBY,A2
	CMP.L	#FCRB_Y,A2
	BLT.S	.AZZA
	LEA	CRBY_SCR,A2
.AZZA	MOVE.L	A2,PT_CRBY
	ADDQ.L	#2,PT_CRBY
	MOVE.L	OLDPT_CRBY2,A0
	MOVE.L	OLDPT_CRBY,OLDPT_CRBY2
	MOVE.L	A2,OLDPT_CRBY

	MOVE.L	ECR1,A1
	LEA	160*32+6(A1),A1
	MOVE	#20-1,D7
	MOVEQ	#0,D0
.LEFF	MOVE.L	A1,A4
	ADD	(A0)+,A4
X	SET	0
	REPT	7
	MOVE	D0,X(A4)
X	SET	X+160
	ENDR
	ADDQ	#8,A1
	DBRA	D7,.LEFF

	MOVE.L	ADR_BUFF7,A0
	ADD	POS_7,A0
	MOVE.L	ECR1,A3
	LEA	160*32+6(A3),A3
	MOVEQ	#20-1,D7
	MOVEQ	#0,D0
.BAFF
	MOVE.L	A3,A1
	ADD	(A2)+,A1
X	SET	0
Y	SET	0
	REPT	7
	MOVE	Y(A0),X(A1)
X	SET	X+160
Y	SET	Y+LL_SCR7
	ENDR
	ADDQ	#2,A0
	ADDQ	#8,A3
	DBRA	D7,.BAFF
	
	BSR	MOVE_SCR7
	RTS

;;  AFFICHAGE DE LA LETTRE DANS LE BUFFER DE SCROLL 7
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AFF_L7
	MOVE.L	ADR_BUFF7,A0
	ADD	POS_7,A0
	LEA	40(A0),A1	; A1: DST 2
	LEA	-4(A0),A0	; A0: DST 1
	MOVE.L	ADR_L7,A2	; A2: LA LETTRE
	MOVE	DECA_7,D7	; D7: DECALAGE
	MOVE.L	#$FFFF0000,D1
	LSL.L	D7,D1	; D1: MSK
X	SET	0
	REPT	7
	MOVEQ	#0,D0
	MOVE	(A2)+,D0
	LSL.L	D7,D0
	AND.L	D1,X(A0)
	AND.L	D1,X(A1)
	OR.L	D0,X(A0)
	OR.L	D0,X(A1)
X	SET	X+LL_SCR7
	ENDR
	RTS

;;  DEPLACEMENT DU SCROLL 7
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MOVE_SCR7
	ADD.L	#7*LL_SCR7,ADR_BUFF7
	ADDQ	#2,DECA_7
	AND	#15,DECA_7
	BEQ.S	.ZERO
	RTS
.ZERO
	MOVE.L	#BUFF_SCR7,ADR_BUFF7
	ADDQ	#2,POS_7
	CMP	#40+4+4,POS_7
	BLT.S	.PFB
	MOVE	#4,POS_7
.PFB
	MOVE.L	PT_TEXT7,A0
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0
	BNE.S	.PFTXT
	LEA	TEXT7,A0
	MOVE.B	(A0)+,D0
.PFTXT	MOVE.L	A0,PT_TEXT7
	LEA	TCNV_ASCII7,A1
	MOVE.B	(A1,D0),D0
	MULU	#7*2,D0
	ADD.L	#FNT7,D0
	MOVE.L	D0,ADR_L7
	RTS

;;  GENERATION DU CODE POUR LES BALLES 8X8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_GENE
	LEA	TADR_GENE,A2	; A2: ADR CODE CHAQUE DECA
	LEA	GENE,A1		; A1: BUFF OU MET CODE
	MOVEQ	#0,D7		; D7: DECALAGE
.BDECA
	LEA	SPR8X8,A0		; A0: SPRITE
	MOVE.L	A1,(A2)+		; SAUVE ADR CODE THIS DECA
	MOVEQ	#0,D5		; D5: OFFSET ECRAN
	MOVEQ	#7,D6		; D6: CPT H
.LH
	MOVEQ	#0,D0
	MOVE	(A0)+,D0
	ROR.L	D7,D0
	MOVEQ	#0,D1
	MOVE	(A0)+,D1
	ROR.L	D7,D1
	BSR	.MK1
	SWAP	D0
	SWAP	D1
	ADDQ	#8,D5
	BSR	.MK1
	ADD	#152,D5
	DBRA	D6,.LH
	MOVE	#$4E75,(A1)+	; RTS
	ADDQ	#1,D7
	CMP	#16,D7
	BLT.S	.BDECA
	RTS
.MK1
	MOVE	D0,D2
	OR	D1,D2
	NOT	D2
	MOVE	D2,-(SP)
	SWAP	D2
	MOVE	(SP)+,D2
	TST	D0
	BEQ.S	.P0X
	TST	D1
	BEQ.S	.P10
.P11
	MOVE	#$2AE,(A1)+		; AND #$D2D2,D5(A6)
	MOVE.L	D2,(A1)+
	MOVE	D5,(A1)+
	MOVE	#$AE,(A1)+		; OR.L #$D0D1,D5(A6)
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	MOVE	D5,(A1)+
	RTS
.P10
	MOVE	#$2AE,(A1)+		; AND #$D2D2,D5(A6)
	MOVE.L	D2,(A1)+
	MOVE	D5,(A1)+
	MOVE	#$6E,(A1)+		; OR #$D0,D5(A6)
	MOVE	D0,(A1)+
	MOVE	D5,(A1)+
	RTS
.P0X
	TST	D1
	BEQ.S	.P00
	MOVE	#$2AE,(A1)+		; AND #$D2D2,D5(A6)
	MOVE.L	D2,(A1)+
	MOVE	D5,(A1)+
	MOVE	#$6E,(A1)+		; OR #$D1,D5+2(A6)
	MOVE	D1,(A1)+
	MOVE	D5,(A1)
	ADDQ	#2,(A1)+
.P00	RTS

;;  CALCUL DE LA MATRICE DE ROTATION SUR LES 3 AXES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ENTREE:	D0=> ANGLE AUTOUR AXE X (*4)
;;	D1=> ANGLE AUTOUR AXE Y (*4)
;;	D2=> ANGLE AUTOUR AXE Z (*4)
;;	A6=> BUFFER DE STOCKAGE DE LA MATRICE
; MATRICE:  A   B   C
;	D   E   F
;	G   H   I
; A=CB*CC
; B=-CA*CB*SC+SA*SB
; C=CB*SA*SC+CA*SB
; D=SC
; E=CA*CC
; F=-SA*CC
; G=-CC*SB
; H=CA*SB*SC+CB*SA
; I=-SA*SB*SC+CA*CB
CALC_MTR
COSA	EQUR	D0
COSB	EQUR	D2
COSC	EQUR	D4
SINA	EQUR	D1
SINB	EQUR	D3
SINC	EQUR	D5
	LEA	TCOS_SIN,A0
	MOVEM.W	(A0,D2),COSC/SINC	; COSZ, SINZ
	MOVEM.W	(A0,D1),COSB/SINB	; COSY, SINY
	MOVEM.W	(A0,D0),COSA/SINA	; COSX, SINX

RMC1	MACRO
	 ASL.L	#4,D6
	 SWAP	D6
	ENDM
RMC2	MACRO
	 ASL.L	#4,D7
	 SWAP	D7
	ENDM

	MOVE	COSB,D6
	MULS	COSC,D6
	RMC1
	MOVE	D6,(A6)+		; "A"

	MOVE	SINA,D6
	MULS	SINB,D6
	MOVE	COSA,D7
	MULS	COSB,D7
	RMC2
	MULS	SINC,D7
	SUB.L	D7,D6
	RMC1
	MOVE	D6,(A6)+		; "B"

	MOVE	COSA,D6
	MULS	SINB,D6
	MOVE	COSB,D7
	MULS	SINA,D7
	RMC2
	MULS	SINC,D7
	ADD.L	D7,D6
	RMC1
	MOVE	D6,(A6)+		; "C"

	MOVE	SINC,(A6)+		; "D"

	MOVE	COSA,D6
	MULS	COSC,D6
	RMC1
	MOVE	D6,(A6)+		; "E"

	MOVE	SINA,D6
	MULS	COSC,D6
	RMC1
	NEG	D6
	MOVE	D6,(A6)+		; "F"

	MOVE	COSC,D6
	MULS	SINB,D6
	RMC1
	NEG	D6
	MOVE	D6,(A6)+		; "G"

	MOVE	COSA,D6
	MULS	SINB,D6
	RMC1
	MULS	SINC,D6
	MOVE	SINA,D7
	MULS	COSB,D7
	ADD.L	D7,D6
	RMC1
	MOVE	D6,(A6)+		; "H"

	MOVE	COSA,D6
	MULS	COSB,D6
	MOVE	SINA,D7
	MULS	SINB,D7
	RMC2
	MULS	SINC,D7
	SUB.L	D7,D6
	RMC1
	MOVE	D6,(A6)+		; "I"
	RTS

;;  PRECALCULE DE LA ROTATION DU LOGO
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRC_3D
	CLR.L	X_ANG
	CLR	Z_ANG
	MOVE	#NB_ETAPE,-(SP)
	LEA	ANIM_LOG,A0
	MOVE.L	A0,PT_3D
.LOOP	PEA	(A0)
	BSR	ROT_OBJET
	BSR	SORT_Z
	MOVE.L	(SP)+,A0
	BSR	STOCK_XY
	ADD	#BSTEP,X_ANG
	ADD	#-2*BSTEP,Y_ANG
	ADD	#2*BSTEP,Z_ANG
	AND	#1023*4,X_ANG
	AND	#1023*4,Y_ANG
	AND	#1023*4,Z_ANG
	SUBQ	#1,(SP)
	BGT.S	.LOOP
	ADDQ	#2,SP
	RTS

;;  ROTATION DE TOUS LES OBJETS ET STOCKAGE DES POINTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ROT_OBJET
	LEA	BMTR1(PC),A6	; CALCUL DE LA MATRICE
	MOVEM.W	X_ANG,D0-D2		; DE ROTATION DU POINT
	BSR	CALC_MTR		; DE VUE DE L'OBSERVATEUR

	LEA	BUFF_POINT,A1	; A1: BUFFER STOCK POINT
	LEA	TCOS_SIN,A2		; A2; TABLE COS/SIN
	LEA	LOG_3D,A4

	MOVE	#NB_POINT-1,D7		; D7: NBRE DE PT
.LP	LEA	BMTR1(PC),A6
	MOVEM.W	(A4)+,D0-D2
	SUBQ	#4,D0
	SUBQ	#4,D1
	MOVE	D0,D3
	MULS	(A6)+,D3
	MOVE	D1,D4
	MULS	(A6)+,D4
	ADD.L	D4,D3
	MOVE	D2,D4
	MULS	(A6)+,D4
	ADD.L	D4,D3
	ASL.L	#4,D3
	SWAP	D3		; X'

	MOVE	D0,D4
	MULS	(A6)+,D4
	MOVE	D1,D5
	MULS	(A6)+,D5
	ADD.L	D5,D4
	MOVE	D2,D5
	MULS	(A6)+,D5
	ADD.L	D5,D4
	ASL.L	#4,D4
	SWAP	D4		;Y'

	MULS	(A6)+,D0
	MULS	(A6)+,D1
	MULS	(A6)+,D2
	ADD.L	D0,D2
	ADD.L	D1,D2
	ASL.L	#4,D2
	SWAP	D2		; Z'

	EXT.L	D3
	EXT.L	D4
	ASL.L	#8,D3
	ASL.L	#8,D4
	ADD	#256+200,D2
	DIVS	D2,D3
	DIVS	D2,D4
	ADD	#160,D3
	ADD	#96,D4
	MOVE	D3,(A1)+
	MOVE	D4,(A1)+
	MOVE	D2,(A1)+
	DBRA	D7,.LP
	RTS
BMTR1	DS.W	3*3


;;  TRIE LES POINTS
;;;;;;;;;;;;;;;;;;;;;
SORT_Z
	LEA	QUEUE_Z,A4
	MOVE.L	A4,A5
	CLR	(A4)+
	CLR.L	(A4)+
	CLR.L	(A4)+
	LEA	BUFF_POINT,A0
	MOVE	#NB_POINT-1,D7
.LOOP
	MOVEM.W	(A0)+,D4-D6
	LEA	QUEUE_Z,A4
	TST	(A4)+
	MOVE.L	(A4),D0
	BEQ.S	.INSERT2
	MOVE.L	D0,A3
.BEG_SORT
	REPT	6
	 CMP	(A3)+,D6		; SI MYZ<Z ALORS INSERT NEW
	 BGT.S	.INSERT1		; A LA PLACE
	 MOVE.L	(A3),D0		; SI PLUS D'AUTRES ON INSERT
	 BEQ.S	.INSERT1		; A LA FIN
	 MOVE.L	D0,A4		; SINON ON CONTINUE

	 CMP	(A4)+,D6
	 BGT.S	.INSERT2
	 MOVE.L	(A4),D0
	 BEQ.S	.INSERT2
	 MOVE.L	D0,A3
	ENDR
	BRA.S	.BEG_SORT
.INSERT2	MOVE.L	A4,A3
.INSERT1
	MOVE.L	(A3),D0		; D0: OLD ADR SUIVANT
	MOVE.L	A5,(A3)		; NEW ADR SUIVANT
	MOVE	D6,(A5)+		; NEW Z
	MOVE.L	D0,(A5)+		; NEW ADR SAUIVANT
	MOVE	D4,(A5)+		; NEW X
	MOVE	D5,(A5)+		; NEW Y
	DBRA	D7,.LOOP
	RTS

;;  STOCKAGE DES COORDONNEES X & Y DES POINTS APRES LE TRI
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
STOCK_XY
	LEA	TAB_Y,A2
	LEA	QUEUE_Z,A6
.LOOP	ADDQ	#2,A6		; SAUTE Z
	MOVE.L	(A6)+,D7
	MOVE	(A6)+,D0		; D0: X
	MOVE	(A6)+,D1		; D1: Y
	BGE.S	.YOK
	MOVEQ	#0,D1
.YOK
	CMP	#320-8,D0
	BCC.S	.OUT
	MOVEQ	#15,D2
	AND	D0,D2		; D2: DECA
	SUB	D2,D0
	ASR	D0		; D0: OFFSET X
	CMP	#200,D1
	BLT.S	.YOK2
	MOVE	#200,D1
.YOK2	ADD	D1,D1
	ADD	(A2,D1),D0		; D0: OFFSET X+Y
	MOVE	D0,(A0)+		; SAUVE OFFSET ECRAN
	ADD	D2,D2
	ADD	D2,D2
	MOVE	D2,(A0)+		; SAUVE DECALAGE*4
	TST.L	D7
	BEQ.S	.FIN
	MOVE.L	D7,A6
	BRA	.LOOP

.OUT	MOVE	#32000,(A0)+	; EN DEHORS ECRAN
	CLR	(A0)+		; NUM DECA*4
	TST.L	D7
	BEQ.S	.FIN
	MOVE.L	D7,A6
	BRA	.LOOP
.FIN	RTS

;;  ON "ZOOM" LE LOGO
;;;;;;;;;;;;;;;;;;;;;;;
RETAPE_LOG
	LEA	LOG_3D,A0
	MOVE	#NB_POINT*3-1,D0
.LP
	MOVE	(A0),D1
	MULU	#12,D1
	MOVE	D1,(A0)+
	DBRA	D0,.LP

	MOVE.L	#BEFF1,PTEFF1
	MOVE.L	#BEFF2,PTEFF2
	LEA	BEFF1,A0
	LEA	BEFF2,A1
	MOVE	#NB_POINT-1,D0
	MOVE.L	ECR1,D1
	ADD.L	#32*160,D1
.BEFF	MOVE.L	D1,(A0)+
	MOVE.L	D1,(A1)+
	DBRA	D0,.BEFF
	RTS

;;  ON AFFICHE LA 3D
;;;;;;;;;;;;;;;;;;;;;;
DO_3D
	MOVE.L	PTEFF2,A0
	MOVE.L	PTEFF1,PTEFF2
	MOVE.L	A0,PTEFF1
	MOVE	#NB_POINT-1,D0
	MOVEQ	#0,D1
.LP
	MOVE.L	(A0)+,A2
X	SET	0
	REPT	8
	 MOVE.L	D1,X(A2)
	 MOVE.L	D1,X+8(A2)
X	 SET	X+160
	ENDR
	DBRA	D0,.LP

	MOVE.L	PT_3D,A0
	CMP.L	#ANIM_LOG+LEN_ETAPE*NB_ETAPE,A0
	BLT.S	.PFANIM
	LEA	ANIM_LOG,A0
.PFANIM
	MOVE.L	ECR1,A1
	LEA	TADR_GENE,A2
	MOVE.L	PTEFF1,A3
	MOVE	#NB_POINT-1,D7
.LOOP
	MOVE.L	A1,A6
	ADD	(A0)+,A6		; DST ECRAN
	MOVE.L	A6,(A3)+
	MOVE	(A0)+,D0		; DECA*4
	MOVE.L	(A2,D0),A5		; ADR CODE GENE DECA
	JSR	(A5)		; JUMP TO CODE
	DBRA	D7,.LOOP
	MOVE.L	A0,PT_3D
	RTS

;;  SLIDE DE LA PALETTE DES VECTORS-BALLS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SLIDE_PAL1
	LEA	PAL2,A0
	LEA	PAL3,A1
	MOVEM.L	(A0),D0-D7
	MOVEM.L	D0-D7,(A1)
	ADDQ	#2,A0
	ADDQ	#2,A1
	MOVE	ETAPE_SLD,D6
	MOVEQ	#3,D7
	BSR	CALC_SLD

	CMP	#7,ETAPE_SLD
	BGE.S	.OUT
	ADDQ	#1,CPT_SLD
	CMP	#5,CPT_SLD
	BLT.S	.OUT
	ADDQ	#1,ETAPE_SLD
	CLR	CPT_SLD
.OUT
	LEA	PAL3,A0
	LEA	PAL3,A1
	MOVE	ETAPE_SLDD,D6
	CMP	#7,D6
	BEQ.S	.AZ
	MOVEQ	#16,D7
	BSR	CALC_SLD
.AZ
	TST.B	FLG_SLDD
	BEQ.S	.PS
	TST	ETAPE_SLDD
	BLE.S	.PSOUT
	ADDQ	#1,CPT_SLDD
	CMP	#5,CPT_SLDD
	BLT.S	.PS
	SUBQ	#1,ETAPE_SLDD
	CLR	CPT_SLDD
.PS
	RTS
.PSOUT	ST	EXIT_FLAG		; FIN DE LA DEMO
	RTS
;;  CALCULE D'UN SLIDE DE COULEUR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  ENTREE:	D7: NBRE DE COULEUR
;;	D6: ETAPE (0-7)
;;	A0: SOURCE
;;	A1: DESTINATION
CALC_SLD
	SUBQ	#1,D7
	BLE	.OUT
	EOR	#7,D6
	MOVE	D6,D5	; D6: BLEU
	LSL	#4,D5	; D5: VERT
	MOVE	D5,D4
	LSL	#4,D4	; D4: ROUGE
.LOOP
	MOVE	(A0)+,D0
	MOVE	D0,D1
	MOVE	D0,D2
	AND	#$700,D0
	AND	#$70,D1
	AND	#$7,D2

	SUB	D4,D0
	BGE.S	.ZOK
	MOVEQ	#0,D0
.ZOK
	SUB	D5,D1
	BGE.S	.YOK
	MOVEQ	#0,D1
.YOK
	SUB	D6,D2
	BGE.S	.XOK
	MOVEQ	#0,D2
.XOK
	OR	D2,D0
	OR	D1,D0
	MOVE	D0,(A1)+
	DBRA	D7,.LOOP
.OUT	RTS

;;  PREPARATION DE L'IMAGE UN PLAN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRP_IMG1P
	LEA	TEXT_MINI,A0
	LEA	TCNV_ASCII_MINI,A1
	LEA	MINI_FNT,A2
	MOVEQ	#0,D6		; D6: XCURS
	MOVEQ	#0,D7		; D7: YCURS
.LOOP
	MOVEQ	#0,D0
	MOVE.B	(A0)+,D0		; D0: CARACTERE ASCII
	BEQ	.FIN
	CMP.B	#13,D0
	BNE.S	.PAS_RET
	MOVEQ	#0,D6		; SI RETOUR DE LIGNE
	ADD	#40*8,D7
	BRA.S	.LOOP
.PAS_RET
	MOVE.B	(A1,D0),D0		; D0: POSITION DS FONTE
	LSL	#3,D0
	LEA	(A2,D0),A3		; A3: LETTRE
	LEA	IMG_1P,A4
	ADD	D6,A4
	ADD	D7,A4
X	SET	0
	REPT	8
	 MOVE.B	(A3)+,X(A4)
X	 SET	X+40
	ENDR
	ADDQ	#1,D6
	BRA	.LOOP
.FIN	RTS

;;  AFFICHAGE DE L'IMAGE 1 PLAN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AFF_IMG1P
	MOVE	LIGNE_1P,D0
	BMI	.FIN
	BSR	.LIGNE_AFF
	MOVE	#199-32,D0
	SUB	LIGNE_1P,D0
	BMI.S	.PA
	BSR	.LIGNE_AFF
.PA	;ADDQ	#1,CPT_1P
	;AND	#1,CPT_1P
	;BNE.S	.FIN
	SUBQ	#2,LIGNE_1P
.FIN	RTS
.LIGNE_AFF
	LEA	IMG_1P,A0
	MOVE.L	ECR1,A1
	MOVE.L	ECR2,A2
	ADDQ	#4,A1
	ADDQ	#4,A2
	LEA	160*32(A1),A1
	LEA	160*32(A2),A2
	MULU	#40,D0
	ADD	D0,A0
	ADD	D0,D0
	ADD	D0,D0
	ADD	D0,A1
	ADD	D0,A2
X	SET	0
	REPT	20
	 MOVE	(A0)+,D0
	 MOVE	D0,X(A1)
	 MOVE	D0,X(A2)
X	 SET	X+8
	ENDR
	RTS

;;  TOUTES LA PALETTES VERS LE NOIR
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DOWN_BLACK
	MOVE	#7,ETAPE_SLD
	MOVEM.L	$FFFF8240,D0-D7
	MOVEM.L	D0-D7,PAL3
.LOOP
	REPT	3
	 BSR	VSYNC
	ENDR
	LEA	PAL3,A0
	LEA	$FFFF8240,A1
	MOVE	ETAPE_SLD,D6
	MOVE	#16,D7
	BSR	CALC_SLD
	SUBQ	#1,ETAPE_SLD
	BGE.S	.LOOP
	RTS
	
;;  SECTION DATA
;;;;;;;;;;;;;;;;;;

PAL	DC.W	$000,$555,$001,$001,$222,$222,$222,$222
	DC.W	$777,$777,$777,$777,$777,$777,$777,$777

PAL_LOGO
	DC.W	$213,$223,$243,$057,$547,$740,$765	

***  PALETTE BOULE
PAL2	DC.W	$000,$122,$445,$677,$005,$005,$005,$005
	DC.W	$777,$777,$777,$777,$005,$005,$005,$005


; TABLE DE CONVERSION RAPIDE X=> OFF ECRAN, MASQUE
; FORMAT: MASQUE.W,OFFSET.W
TAB_X
X	SET	0
	REPT	LECRAN/16
	DC.W	$FFFF,X
	DC.W	$7FFF,X
	DC.W	$3FFF,X
	DC.W	$1FFF,X
	DC.W	$0FFF,X
	DC.W	$07FF,X
	DC.W	$03FF,X
	DC.W	$01FF,X
	DC.W	$00FF,X
	DC.W	$007F,X
	DC.W	$003F,X
	DC.W	$001F,X
	DC.W	$000F,X
	DC.W	$0007,X
	DC.W	$0003,X
	DC.W	$0001,X
X	SET	X+8
	ENDR
TAB_X2
X	SET	0
	REPT	LECRAN/16
	DC.W	$8000,X
	DC.W	$C000,X
	DC.W	$E000,X
	DC.W	$F000,X
	DC.W	$F800,X
	DC.W	$FC00,X
	DC.W	$FE00,X
	DC.W	$FF00,X
	DC.W	$FF80,X
	DC.W	$FFC0,X
	DC.W	$FFE0,X
	DC.W	$FFF0,X
	DC.W	$FFF8,X
	DC.W	$FFFC,X
	DC.W	$FFFE,X
	DC.W	$FFFF,X
X	SET	X+8
	ENDR

;;  TABLE DE PREMULTIPLICATION DES Y PAR 160
TAB_Y
X	SET	0
	REPT	210
	DC.W	X
X	SET	X+160
	ENDR

LOGO	INCBIN	EUROSWAP.IMG
	EVEN
APPEAR	INCBIN	APPEAR.IMG
	EVEN

EURO_CRB	INCBIN	EUROCRB.X
FEURO_CRB	DS.W	32

LOG_3D
	; E
	DC.W	-19,-2,0,-18,-2,0,-17,-2,0,-16,-2,0
	DC.W	-19,-1,0,-19,0,0,-18,0,0,-17,0,0,-19,1,0
	DC.W	-19,2,0,-18,2,0,-17,2,0,-16,2,0
	; U
	DC.W	-14,-2,0,-14,-1,0,-14,0,0,-14,1,0
	DC.W	-13,2,0,-12,2,0
	DC.W	-11,-2,0,-11,-1,0,-11,0,0,-11,1,0
	; R
	DC.W	-9,-2,0,-8,-2,0,-7,-2,0,-6,-1,0
	DC.W	-7,0,0,-7,1,0,-6,2,0
	DC.W	-9,-1,0,-8,0,0,-9,0,0,-9,1,0,-9,2,0
	; O
	DC.W	-3,-2,0,-2,-2,0,-1,-1,0,-1,0,0
	DC.W	-1,1,0,-2,2,0,-3,2,0,-4,1,0,-4,0,0,-4,-1,0
	; S
	DC.W	2,-2,0,3,-2,0,4,-2,0,1,-1,0,2,0,0,3,0,0
	DC.W	4,1,0,3,2,0,2,2,0,1,2,0
	; W
	DC.W	6,-2,0,6,-1,0,6,0,0,6,1,0,6,2,0
	DC.W	7,1,0,8,0,0,9,1,0
	DC.W	10,-2,0,10,-1,0,10,0,0,10,1,0,10,2,0
	; A
	DC.W	13,-2,0,14,-2,0,15,-1,0,15,0,0,15,1,0,15,2,0
	DC.W	14,0,0,13,0,0,12,-1,0,12,0,0,12,1,0,12,2,0
	; P
	DC.W	17,-2,0,18,-2,0,19,-2,0,20,-1,0,19,0,0,18,0,0
	DC.W	17,-1,0,17,0,0,17,1,0,17,2,0

FLOG_3D		
	;	1111111111                   11111111112
	;	9876543210987654321012345678901234567890
	;-2	1111 1  1 111   11   111 1   1  11  111
	;-1	1    1  1 1  1 1  1 1    1   1 1  1 1  1
	;0	111  1  1 111  1  1* 11  1 1 1 1111 111
	;1	1    1  1 1 1  1  1    1 11 11 1  1 1
	;2	1111  11  1  1  11  111  1   1 1  1 1

MINI_FNT	INCBIN	8X8_1P.FNT
	EVEN

ORDRE_MINI	DC.B	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	DC.B	"0123456789",'"',"'()!?-()+*"
	DC.B	"/.,;:%>< ",0
	EVEN

; 0 => FIN
; 13 => RETOUR DE LIGNE (ATTENTION, N'EST PAS AUTOMATIQUE)
; 21 LIGNES DE TEXTES AUTORISEES
TEXT_MINI
	DC.B	13
	DC.B	"THIS PROGRAMM IS THE MAIN LOADER",13
	DC.B	"I WISH THAT WILL WORK WELL !!!",13
	DC.B	13
	DC.B	"F1: CHOIX 1",13
	DC.B	"F2: CHOIX 2",13
	DC.B	"F3: CHOIX 3",13
	DC.B	"F4: CHOIX 4",13
	DC.B	"F5: CHOIX 5",13
	DC.B	"       HERE SOME TEXTS CAN BE WRITE ",13
	DC.B	" BUT FOR ME I WILL WRITE SOME BLABLA",13
	DC.B	"BECAUSE IT'S LATE AND TOMORROW I'M",13
	DC.B	"GOING BY CAR TO MY GRAND-MOTHER'S",13
	DC.B	"HOUSE...  THEN LET'S WRAPPP...",13
	DC.B	"SOME BBLALBLALALBLAL TEXT HERE ...",13
	DC.B	"THIS IS BLALABLABALBLABALBL",13
	DC.B	"I CHANGE THE BABABZEAEKLK",13
	DC.B	"ZAEIOPAEPAZEIOZEAIPZAOPE",13
	DC.B	0

; ^ => ?!
; $ => !!!
ORDRE_FNT7	DC.B	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	DC.B	"0123456789.:,-'!?()",'"',"^$/%~&@"
	DC.B	0
	EVEN

TEXT7A	DC.B	"HELLO BOYS AND GIRLS !!! YOU ARE NOW LOOKING AT A DEMO ESPECIALLY CODED BY STIX FROM ZUUL FOR EUROSWAP.        "
TEXT7
	DC.B	"IT IS NOW THE 17TH MAY OF THE YEAR 1993. I JUST HAVE THIS DAY TO FINISH THIS STUPID DEMO, BECAUSE TOMORROW I WILL "
	DC.B	"BE ON HOLLIDAY...  SOMES NEWS ABOUT ZUUL:     "
	DC.B	"NEXT ZUUL'S PRODUCTIONS ARE:     - THE XOTRION DEMO.     - FUTURE 3D WORLD.     - AND SOMES OTHERS...    "
	DC.B	" IT'S NOW TIME TO WRAP BECAUSE I MUST CONTINUE TO CODE THIS DEMO.         "
	DC.B	"I LET MY SISTER SPEAKING NOW: (MERCI POUR LA TAILLE...)    "
	DC.B	"CITOYEN, CITOYENNE, JE PRENDS MAINTENANT LA PAROLE POUR VOUS INFORMER DU TERRIBLE DANGER QUI VIENT FRAPPER A NOS PORTES. EN EFFET, SI NOUS PRENONS LA BASE X D'HYPERSENSORIALLITE Z NOUS OBTENONS ALORS UNE "
	DC.B	"SPHERE CUBIQUE D'HYPOTHENUSE Z MATERIALISEE PAR LA PERSEVERANCE INTERSTELLEREMENT TEMPORELLE. ET JE TIENS A VOUS, DIRE QUE CECI EST LA VERITABLE VRAIE  VERITE VERIDICTE. D'APRES CETTE DEMONSTRATION NOUS  "
	DC.B	"POUVONS DONC CONCLURE A LA CONCLUSION SUIVANTE: LA GOGOLLEMIE EST PARTOUT. OUI, JE DIS BIEN PARTOUT ET ELLE PEUT TOUCHER N'IMPORTE QUI; MEME VOUS, PETIT ETRE FEBRILE ET SANS DEFENSE... (D'AILLEUR, JE SAIS DE "
	DC.B	"QUOI JE PARLE CAR CHEZ MOI DEMEURE L'ETRE LE PLUS REPRESENTATIF DE LA MALADIE: MON FRERE...). BON, MAINTENANT, JE LAISSE LA PAROLE A QUELQU'UN D'AUTRE ET VOUS LAISSE EN PAIX, LIVRE A VOTRE SORT. GOGOLLEMENT "
	DC.B	"VOTRE ZEMILIE.       "
	DC.B	"                              "
	DC.B	0
	EVEN

FNT7	INCBIN	FNT16X7.FNT
	EVEN

CRBY_SCR	INCBIN	SCR16X7.Y
FCRB_Y	DS.W	40

MUSIK	INCBIN	TECHTRON.MUS
	EVEN

SPR8X8
*
**	MOTIF BOULE OPTIMISE EN 2 PLANS  
*	COPYB1.S PAR NEOCHROME
;	DC.W	$3C00,$0000,$7E00,$3C00
;	DC.W	$E100,$7E00,$C100,$7E00
;	DC.W	$C300,$7C00,$C300,$7C00
;	DC.W	$4E00,$3000,$3C00,$0000

		dc.w	$3C00,$0000,$2E00,$7000
		dc.w	$ED00,$7200,$9F00,$6000
		dc.w	$F900,$0600,$F500,$4E00
		dc.w	$7200,$0C00,$3C00,$0000

TCOS_SIN	INCBIN	TCOS_SIN.DAT
	EVEN

;;  SECTION BSS
;;;;;;;;;;;;;;;;;
	BSS
	DS.L	1000
PILE
SYNC		DS.W	1
ECR1		DS.L	1
ECR2		DS.L	1
Z_CERCLE		DS.W	1
CPT_OUT		DS.W	1
X_APP		DS.W	1
Y_LOGO		DS.W	1
PT_CRB		DS.L	1
PT_TEXT7		DS.L	1
DECA_7		DS.W	1
ADR_L7		DS.L	1
POS_7		DS.W	1
ADR_BUFF7		DS.L	1
PT_CRBY		DS.L	1
OLDPT_CRBY		DS.L	1
OLDPT_CRBY2		DS.L	1
X_ANG		DS.W	1
Y_ANG		DS.W	1
Z_ANG		DS.W	1
PT_3D		DS.L	1
RT_VBL		DS.L	1
PT_VBL		DS.L	1
PTEFF1		DS.L	1
PTEFF2		DS.L	1
RT_IN_VBL		DS.L	1
CPT_SLD		DS.W	1
ETAPE_SLD		DS.W	1
LIGNE_1P		DS.W	1
CPT_1P		DS.W	1
ETAPE_SLDD		DS.W	1
CPT_SLDD		DS.W	1
CHOIX		DS.W	1
OLD70		DS.L	1
OLD120		DS.L	1
OLD_PAL		DS.W	16
OLD_PHY		DS.L	1
OLD_SP		DS.L	1
OLD_RES		DS.W	1
FLG_FCERCLE		DS.B	1
FLG_AFF_CLR		DS.B	1
FLG_FAPP		DS.B	1
PAL_UP		DS.B	1
GET_NEW_VBL		DS.B	1
PEU_GO_3D		DS.B	1
FLG_SLDD		DS.B	1
EXIT_FLAG		DS.B	1
OLDA07		DS.B	1
OLDA09		DS.B	1
OLDA13		DS.B	1
OLDA15		DS.B	1
OLDA17		DS.B	1
OLDA1B		DS.B	1
OLDA21		DS.B	1
	EVEN

BEFF1		DS.L	200
BEFF2		DS.L	200
PAL3		DS.W	16
PRD_APPEAR		DS.B	32*8*16
PRD_EUROSWAP	DS.B	160*32*16
BUFF_V		DS.L	HECRAN*2
SCREEN		DS.B	64256+2560*2
BUFF_SCR7		DS.B	LL_SCR7*7*16
TCNV_ASCII7		DS.B	256
TCNV_ASCII_MINI	DS.B	256
TADR_GENE		DS.L	16
GENE		DS.B	5000
BUFF_POINT		DS.W	3*200
IMG_1P		DS.B	40*168
ANIM_LOG		DS.W	LEN_ETAPE*NB_ETAPE
QUEUE_Z		DS.B	LEN_1QUEUE_Z*200
