GPIP	EQU     $FFFFFA01
IERA	EQU	$FFFFFA07
ISRA	EQU	$FFFFFA0F
ISRB	EQU	$FFFFFA11
IPRA	EQU	$FFFFFA0B
IMRA	EQU	$FFFFFA13
TBCR	EQU	$FFFFFA1B
TBDR	EQU	$FFFFFA21
V_R	EQU	$FFFFFA17
KBD_CTRL EQU	$FFFFFC00
KBD_DATA EQU	$FFFFFC02
MFP_GPIP EQU	$FFFFFA01
	MOVE.L  SP,A5 
	MOVE.L  4(A5),A5
	MOVE.L  $C(A5),D0
	ADD.L   $14(A5),D0
	ADD.L   $1C(A5),D0
	ADD.L   #$500,D0
	MOVE.L  D0,D1
	ADD.L   A5,D1
	AND.L   #-2,D1
	MOVE.L  D1,SP
	MOVE.L  D0,-(SP)
	MOVE.L  A5,-(SP)
	CLR     -(SP)
	MOVE    #$4A,-(SP)
	TRAP    #1
	ADD     #12,SP
  	
	MOVE.L  #0,-(SP) 
  	MOVE    #$20,-(SP)
	TRAP    #1
	ADDQ    #6,SP

	MOVE	#2,-(SP)
	TRAP	#14
	ADDQ.L	#2,SP
	MOVE.L	D0,ADRESSE_PHYSIQUE

	LEA	TABLE_DES_POINTS,A0	
BOUCLE_DROITE:

	JSR	AFFICHE_DROITE_PAR_BRESENHAM

	MOVE	#7,-(SP)
	TRAP	#1
	ADDQ	#2,SP

	move	#0,-(sp)
	trap	#1
	addq	#2,sp


AFFICHE_DROITE_PAR_BRESENHAM:
	MOVEM	(A0)+,D0-D3
	MOVE.L	ADRESSE_PHYSIQUE,A1
	MOVE	D0,D4
	ADD	D4,D4
	ADD	D4,A1
	MOVE	D1,D4
	MULU	#640,D4
	ADD.L	D4,A1
	MOVE.L	A1,ADRESSE_DESTINATION

	MOVE	D3,D4
	MOVE	#640,D3
	SUB	D1,D4
	BEQ	TRACE_HORIZONTALE
	BGT.S	DYPOSITIF
	NEG	D4
	NEG	D3
DYPOSITIF:
	MOVE	D2,D5
	MOVEQ	#2,D2
	SUB	D0,D5
	BEQ	TRACE_VERTICALE
	BGT.S	DXPOSITIF
	NEG	D5
	NEG	D2
DXPOSITIF:
	CMP	D4,D5
	BLT.S	YMAJORITAIRE
	ADD	D2,D3
	BEQ	TRACE_DIAGONALE
	MOVE	D5,D6

	ADD	D4,D4
	MOVE	D4,D7
	SUB	D5,D7
	ADD	D5,D5
	NEG	D5   
	ADD	D4,D5
	
	TST	D7   
CALCULE_TRACE_BRESENHAM:
	BMI.S	SENSP1
	MOVE	#$F800,(A1)
	ADD	D3,A1	
	ADD	D5,D7	
	DBF	D6,CALCULE_TRACE_BRESENHAM
	RTS
SENSP1:
	MOVE	#$F800,(A1)
	ADD	D2,A1   
	ADD	D4,D7	
	DBF	D6,CALCULE_TRACE_BRESENHAM
	RTS
YMAJORITAIRE:
	EXG	D4,D5
	EXG	D2,D3
	ADD	D2,D3
	MOVE	D5,D6

	ADD	D4,D4
	MOVE	D4,D7
	SUB	D5,D7
	ADD	D5,D5
	NEG	D5   
	ADD	D4,D5
	
	TST	D7   
CALCULE_TRACE_BRESENHAM_BIS:
	BMI.S	SENSP1_BIS
	MOVE	#$F800,(A1)
	ADD	D3,A1	
	ADD	D5,D7	
	DBF	D6,CALCULE_TRACE_BRESENHAM_BIS	
	RTS
SENSP1_BIS:
	MOVE	#$F800,(A1)
	ADD	D2,A1   
	ADD	D4,D7	
	DBF	D6,CALCULE_TRACE_BRESENHAM_BIS
	RTS
TRACE_HORIZONTALE:
	MOVE	D2,D5
	MOVEQ	#2,D2
	SUB	D0,D5
	BGE.S	DXPOSITIF_BIS
	NEG	D2
	NEG	D5
DXPOSITIF_BIS:
	MOVE	D5,D6
CALCULE_TRACE_BRESENHAM_TER:
	MOVE	#$F800,(A1)
	ADD	D2,A1
	DBF	D6,CALCULE_TRACE_BRESENHAM_TER
	RTS	
TRACE_VERTICALE:
	MOVE	D4,D6
CALCULE_TRACE_BRESENHAM_QUATRE:
	MOVE	#$F800,(A1)
	ADD	D3,A1   
	DBF	D6,CALCULE_TRACE_BRESENHAM_QUATRE
	RTS	
TRACE_DIAGONALE:
	MOVE	D4,D6
CALCULE_TRACE_BRESENHAM_CINQ:
	MOVE	#$F800,(A1)
	ADD	D3,A1   
	DBF	D6,CALCULE_TRACE_BRESENHAM_CINQ
	RTS


BRESENHAM:
	MOVEM	(A0)+,D0-D3
	MOVE	D3,D4
	MOVEQ	#1,D3
	SUB	D1,D4
	BEQ	HORIZONTALE
	BGT.S	DY_POSITIF
	NEG	D4
	NEG	D3
DY_POSITIF:
	MOVE	D2,D5
	MOVEQ	#1,D2
	SUB	D0,D5
	BEQ	VERTICALE
	BGT.S	DX_POSITIF
	NEG	D5
	NEG	D2
DX_POSITIF:
	CMP	D4,D5
	BEQ	DIAGONALE
	BLT	Y_MAJORITAIRE
	MOVE	D5,D6

	move	d6,nb_points

	ADD	D4,D4
	MOVE	D4,D7
	SUB	D5,D7
	ADD	D5,D5
	NEG	D5   
	ADD	D4,D5
	
	TST	D7   
CALCULE_BRESENHAM:
	BMI.S	SENS_P1
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	ADD	D2,D0   
	ADD	D3,D1	
	ADD	D5,D7	
	DBF	D6,CALCULE_BRESENHAM
	RTS
SENS_P1:
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	ADD	D2,D0   
	ADD	D4,D7	
	DBF	D6,CALCULE_BRESENHAM
	RTS
Y_MAJORITAIRE:
	EXG	D4,D5
	EXG	D0,D1
	EXG	D2,D3
	MOVE	D5,D6

	move	d6,nb_points

	ADD	D4,D4
	MOVE	D4,D7
	SUB	D5,D7
	ADD	D5,D5
	NEG	D5   
	ADD	D4,D5
	
	TST	D7   
CALCULE_BRESENHAM_BIS:
	BMI.S	SENS_P1_BIS
	MOVE	D1,(A1)+
	MOVE	D0,(A1)+
	ADD	D2,D0   
	ADD	D3,D1	
	ADD	D5,D7	
	DBF	D6,CALCULE_BRESENHAM_BIS	
	RTS
SENS_P1_BIS:
	MOVE	D1,(A1)+
	MOVE	D0,(A1)+
	ADD	D2,D0   
	ADD	D4,D7	
	DBF	D6,CALCULE_BRESENHAM_BIS
	RTS
HORIZONTALE:
	MOVE	D2,D5
	MOVEQ	#1,D2
	SUB	D0,D5
	BGE.S	DX_POSITIF_BIS

	NEG	D2
	NEG	D5
DX_POSITIF_BIS:
	MOVE	D5,D6

	move	d6,nb_points

CALCULE_BRESENHAM_TER:
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	ADD	D2,D0
	DBF	D6,CALCULE_BRESENHAM_TER
	RTS	
VERTICALE:
	MOVE	D4,D6

	move	d6,nb_points

CALCULE_BRESENHAM_QUATRE:
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	ADD	D3,D1   
	DBF	D6,CALCULE_BRESENHAM_QUATRE
	RTS	
DIAGONALE:
	MOVE	D4,D6

	move	d6,nb_points

CALCULE_BRESENHAM_CINQ:
	MOVE	D0,(A1)+
	MOVE	D1,(A1)+
	ADD	D2,D0   
	ADD	D3,D1   
	DBF	D6,CALCULE_BRESENHAM_CINQ
	RTS


ADRESSE_DESTINATION	DC.L 0
NB_DONNEES	DC.B	0,0
OFFSET_X	DC.B	0
OFFSET_Y	DC.B	0
TOUCHES_SOURIS	DC.B	0,0
SPACE_BARRE	DC.W	0
ADRESSE_PHYSIQUE	DC.L	0
nb_points	dc.w	0
NB_DROITE	DC.W	7
HAUT_GAUCHE	DC.W	0
HAUT_DROITE	DC.W	0
NB_TRACE	DC.W	0
XI_YI	DS.W    2000
YF_YF	DS.W    2000
XQ_YQ   DS.W	2000
TABLE_DES_POINTS:
	DC.W	50,40,280,160
