;---------------------------------------------------------------------
; LIFE - Conway Game of Life simulation, 84 bytes! - final version by
; Tylisha C. Andersen - notable contributions by T.Remmel,V.Kaipetsky
;---------------------------------------------------------------------

.model tiny
.code
.186
org 100h

main:   mov   ax, 13h           ; set video mode 13h
        int   10h               ;
        mov   ds, ax            ; ds = 13h
        mov   bp, ds:[033Ch]    ; bp = random seed from BIOS tick count at
                                ; 0040:006C or 0013:033C
        mov   ax, cs            ; ax = code segment + 1000h for the buffer
        add   ax, 1000h         ; 
        mov   ds, ax            ; set ds and es to the buffer segment
        mov   es, ax            ;
                                ;
        xor   cx, cx            ; zero cx, for each byte in the buffer:
m_1:    imul  bp, 9421          ; generate random number
        inc   bp                ;
        mov   ax, bp            ; ax = random bit (0 or 1)
        shr   ax, 15            ;
        stosb                   ; write to buffer
        loop  m_1               ; loop
                                ; 
        push  0A000h            ; es = video memory, di = si - 322
        pop   es                ; since we go through the entire segment,
        lea   di, [si-322]      ; it doesn't matter what they start at
                                ;
m_2:    xchg  cx, ax            ; low bits of cl are now zero, at this point
                                ; bx is 3 for all but the first iteration:
m_3:    add   cl, [di+bx]       ; add in data for this column
        add   cl, [si+bx-2]     ;
        add   cl, [si+bx+318]   ;
        dec   bx                ; loop
        jnz   m_3               ;
                                ;
        mov   al, [si]          ; al = center cell value
        stosb                   ; set pixel on screen (increment di)
                                ;
        stc                     ; 3 set bits in surrounding square = birth
        rcr   al, cl            ; 4 set bits in surrounding square = stay
        and   al, 20h           ; carry is set, when we rotate it right by 3
                                ; the carry bit ends up on bit 5 and the cell
                                ; comes on in all cases;  when we rotate it
                                ; right by 4, bit 0 ends up in bit 5 and the
                                ; cell stays the same as it was
                                ;
        or    [si], al          ; or new value onto the cell in the buffer
        shr   byte ptr [di], 5  ; fix the cell -321 (we're done with it)
                                ;
        mov   bl, 3             ; set bx = 3 for accum. loop, video mode
        inc   si                ; loop while si is nonzero
        jnz   m_2               ;
                                ;
        mov   ah, 1             ; check for key press
        int   16h               ;
        jz    m_2               ; loop while no key pressed
                                ;
        xchg  ax, bx            ; restore text mode
        int   10h               ;
        ret                     ; return to DOS

end main
