;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   Various Support Stuff.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;


; shortcuts :)
b               equ byte ptr
w               equ word ptr
d               equ dword ptr
o               equ offset
s               equ seg

; initial / reset seed values
irseed1         equ 1234
irseed2         equ 5678
irseed3         equ 1234h
irseed4         equ 5678h

;
;  normalize a segment:offset (move most significant digits to segment)
;  destroys ax, alters segment:offset
;
@normalize      macro segr, offr
                push offr
                mov ax,segr
                shr offr,4
                add ax,offr
                mov segr,ax
                pop offr
                and offr,0fh
                endm

;
;  inline random number routine from Future Crew's Mental Surgery
;  fast random numbers that are a power of 2 (no mul or div needed)
;  do:  @rand  ->  and ax,mask
;
@rand           macro
                push ds bx cx dx
                mov ax,seg seed1
                mov ds,ax
                mov ax,seed1
                mov bx,seed2
                mov cx,seed3
                mov dx,seed4
                add ax,bx
                rol ax,cl
                xor ax,dx
                xchg cl,ch
                add bx,cx
                add dx,bx
                add cx,ax
                ror bx,1
                sbb ax,dx
                mov seed4,dx
                mov seed3,dx
                mov seed2,dx
                mov seed1,ax
                pop dx cx bx ds
                endm

;
; convert value in al to upper case
;
@toupper        macro inchar
                local toupskip
                ifdifi <inchar>,<al>
                mov al,inchar
                endif
                cmp al,97
                jl toupskip
                cmp al,122
                jg toupskip
                sub al,32
toupskip:
                endm

 
ifndef H_SUPPORT
;
;
;    Functions
;
;

extrn           pascal clrborder:far
extrn           pascal contrast:far
extrn           pascal cyclebck:far
extrn           pascal cyclefwd:far
extrn           pascal fileuname:far
extrn           pascal fillrandom:far
extrn           pascal itoa:far
extrn           pascal ltoa:far
extrn           pascal loadfile:far
extrn           pascal pattfill:far
extrn           pascal soundit:far

extrn           seed1:word
extrn           seed2:word
extrn           seed3:word
extrn           seed4:word

endif

