//#define PI 3.1415926535897932384626433832795
//#define SS 4

	static float PI=3.1415926535897932384626433832795;
	static uint SS=48;
	static float3 light_dir=normalize(float3(-1,1,0));
	static float3 v3InvWaveLength=float3(1/pow(0.65,4), 1/pow(0.57,4), 1/pow(0.475,4));

	static float fOuterRadius=61200;
	static float fInnerRadius=60000;
	static float fESun=3.;
	static float fESun_back=0.03;
	static float fKr=0.0065; // nagyobb ertek surubb atmoszfera
	static float fKm=0.0015;

	static float fKrESun=fKr*fESun;			// Kr * ESun
	static float fKmESun=fKm*fESun;			// Km * ESun
	static float fKrESun_back=fKr*fESun_back;			// Kr * ESun
	static float fKmESun_back=fKm*fESun_back;			// Km * ESun
	static float fKr4PI=fKr*4.0*PI;			// Kr * 4 * PI
	static float fKm4PI=fKm*4.0*PI;			// Km * 4 * PI
	static float fScale=1.0/(fOuterRadius-fInnerRadius);			// 1 / (fOuterRadius - fInnerRadius)
	static float fScaleDepth=0.25;		// The scale depth (i.e. the altitude at which the atmosphere's average density is found)
	static float fScaleOverScaleDepth=fScale/fScaleDepth;	// fScale / fScaleDepth
	static float fOuterRadius2=fOuterRadius*fOuterRadius;
	static float fInnerRadius2=fInnerRadius*fInnerRadius;

cbuffer CB : register(b0)
{
	uint	ct0,ct1;
	float	CX,CY;
};

Texture2D fsquad : register(t0);

float fake_noise(float2 co){
    return frac(sin(dot(co ,float2(12.9898,78.233))) * 43758.5453);
}

/*float4 mod289_f4(float4 x) {
  return x - floor(x / 289.) * 289.;
}*/

float4 permute(float4 x) {
	x+=34*x*x;
	return x-floor(x/289.)*289.;
}

float snoise(float3 v)
{ 
//	return 0;
  float2  C = float2(1.0/6.0, 1.0/3.0) ;
  float4  D = float4(0.0, 0.5, 1.0, 2.0);

// First corner
  float3 i  = floor(v + dot(v, C.yyy) );
  float3 x0 =   v - i + dot(i, C.xxx) ;

// Other corners
  float3 g = step(x0.yzx, x0);
  float3 l = 1.0 - g;
  float3 i1 = min( g, l.zxy );
  float3 i2 = max( g, l.zxy );

  //   x0 = x0 - 0.0 + 0.0 * C.xxx;
  //   x1 = x0 - i1  + 1.0 * C.xxx;
  //   x2 = x0 - i2  + 2.0 * C.xxx;
  //   x3 = x0 - 1.0 + 3.0 * C.xxx;
  float3 x1 = x0 - i1 + C.xxx;
  float3 x2 = x0 - i2 + C.yyy; // 2.0*C.x = 1/3 = C.y
  float3 x3 = x0 - D.yyy;      // -1.0+3.0*C.x = -0.5 = -D.y

// Permutations
  i -= floor(i / 289.) * 289.; 
  float4 p = permute( permute( permute( 
             i.z + float4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + float4(0.0, i1.y, i2.y, 1.0 )) 
           + i.x + float4(0.0, i1.x, i2.x, 1.0 ));

// Gradients: 7x7 points over a square, mapped onto an octahedron.
// The ring size 17*17 = 289 is close to a multiple of 49 (49*6 = 294)
  float3  ns = D.wyz/7. - D.xzx;

  float4 j = p - 49. * floor(p * ns.z * ns.z);  //  mod(p,7*7)

  float4 x_ = floor(j * ns.z);
  float4 y_ = floor(j - 7. * x_ );    // mod(j,N)

  float4 x = x_ *ns.x + ns.yyyy;
  float4 y = y_ *ns.x + ns.yyyy;
  float4 h = 1. - abs(x) - abs(y);

  float4 b0 = float4( x.xy, y.xy );
  float4 b1 = float4( x.zw, y.zw );

  //float4 s0 = float4(lessThan(b0,0.0))*2.0 - 1.0;
  //float4 s1 = float4(lessThan(b1,0.0))*2.0 - 1.0;
  float4 s0 = floor(b0)*2.0 + 1.0;
  float4 s1 = floor(b1)*2.0 + 1.0;
  float4 sh = -step(h, float4(0,0,0,0));

  float4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  float4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

  float3 p0 = normalize(float3(a0.xy,h.x));
  float3 p1 = normalize(float3(a0.zw,h.y));
  float3 p2 = normalize(float3(a1.xy,h.z));
  float3 p3 = normalize(float3(a1.zw,h.w));

// Mix final noise value
  float4 m = max(.6 - float4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  return 42. * dot( m*m*m*m, float4( dot(p0,x0), dot(p1,x1), 
                                dot(p2,x2), dot(p3,x3) ) );
}

float skylight_scale(float fCos)
{
	float x = 1.0 - fCos;
	return fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
}


void skylight_calc(out float4 cloud, out float3 atmosphere, out float3 v3Attenuate, out float3 v3Attenuate_back, float3 world_pos, float3 cam_pos)
{
	atmosphere=v3Attenuate=v3Attenuate_back=cloud=0;

	float3 world_to_camera=cam_pos-world_pos;

	// Get the ray from the camera to the vertex, and its length (which is the far point of the ray passing through the atmosphere)
	float3 v3Ray = -world_to_camera;//WorldPos.xyz-planet_eye_pos.xyz;
	float realFar = length(v3Ray);
	v3Ray /= realFar;

//	float fStartDepth, fStartAngle;
//	float3 v3Start;

	// Calculate the closest intersection of the ray with the outer atmosphere (which is the near point of the ray passing through the atmosphere)
	float B = 2.0 * dot(cam_pos, v3Ray);
	float C = dot(cam_pos,cam_pos) - fOuterRadius2;
	float fDet = B*B - 4.0 * C;
	if (fDet<0)
		return;

	float fNear = max(0,(-B - sqrt(fDet))/2);
	float fFar = max(0,min(realFar,(-B + sqrt(fDet))/2));

	float3 v3Start = cam_pos + v3Ray * fNear;
	fFar -= fNear;
	//fStartAngle = 0;//dot(v3Ray, v3Start) / fOuterRadius;
	float fStartDepth = exp((fInnerRadius-length(v3Start)) / fScaleDepth);

	float fStartOffset = fStartDepth*skylight_scale(0);//fStartAngle);

	// Initialize the scattering loop variables
	//gl_FrontColor = float4(0.0, 0.0, 0.0, 0.0);
	float fSampleLength = fFar / SS;
	float fScaledLength = fSampleLength * fScale;
	float3 v3SampleRay = v3Ray * fSampleLength;
	float3 v3SamplePoint = v3Start + v3SampleRay * fake_noise(world_pos*.01);

	// Now loop through the sample rays
	float3 v3FrontColor = 0;
	float3 v3FrontColor_back = 0;

	float cnum=.000001;
	for(uint i=0; i<SS; i++)
	{
		float fHeight = length(v3SamplePoint); ;//fHeight=max(fInnerRadius, fHeight); // ez a clamp kell
		float fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));

		float fLightAngle = dot(-light_dir, v3SamplePoint) / fHeight;
		float fLightAngle_back = dot(light_dir, v3SamplePoint) / fHeight;
		//float fCameraAngle = 0;//dot(v3Ray, v3SamplePoint) / fHeight;
		//fCameraAngle=saturate(fCameraAngle);  // es ez a saturate is
		float fScatter = (fStartOffset + fDepth*(skylight_scale(fLightAngle) - skylight_scale(/*fCameraAngle*/0)));
		float fScatter_back = (fStartOffset + fDepth*(skylight_scale(fLightAngle_back) - skylight_scale(/*fCameraAngle*/0)));

		v3Attenuate = exp(-fScatter * (v3InvWaveLength * fKr4PI + fKm4PI));
		v3Attenuate_back = exp(-fScatter_back * (v3InvWaveLength * fKr4PI + fKm4PI));
		v3FrontColor += v3Attenuate*fDepth*fScaledLength;
		v3FrontColor_back += v3Attenuate_back*fDepth*fScaledLength;

		float cw=1-(abs(fHeight-60500)/50);
		if (cw>0)
		{
			float3 cpos=v3SamplePoint/5000;
			float lc=0;
			for (int j=0;j<6;j++,cpos*=3,cw*=.75)
				if (j<2 || lc>.2)
					lc+=snoise(cpos)*cw;

			cloud.a+=saturate(lc-.5);
			cloud.rgb+=v3Attenuate*fESun;
			cloud.rgb+=v3Attenuate_back*fESun_back;
			cnum+=.7;
		}

		v3SamplePoint += v3SampleRay;
	}
	cloud/=cnum;
//cloud=0;

	float3 primary_color=v3FrontColor*v3InvWaveLength*fKrESun;
	float3 secondary_color=v3FrontColor*fKmESun;

	float3 primary_color_back=v3FrontColor_back*v3InvWaveLength*fKrESun_back;
//	float3 secondary_color_back=v3FrontColor_back*fKmESun_back;

//	static float g=-0.95;
//	static float g2=g*g;

	float fdot = dot(-light_dir, world_to_camera)/length(world_to_camera);
	float frlp = 0.75*(1.0+fdot*fdot);
//	float fmie = 1.5*((0.0975)/(2.9025))*(1.0+fdot*fdot)/pow(1.9025+1.9*fdot,1.5);
	float fmie = .0504*(1.0+fdot*fdot)/pow(1.9025+1.9*fdot,1.5);

	float fdot_back = dot(light_dir, world_to_camera)/length(world_to_camera);
	float frlp_back = 0.75*(1.0+fdot_back*fdot_back);
//	float fmie_back = 1.5*((1.0-g2)/(2.0+g2))*(1.0+fdot_back*fdot_back)/pow(1.0+g2-2.0*g*fdot_back,1.5);

	atmosphere=frlp*primary_color+fmie*secondary_color+frlp_back*primary_color_back;//+fmie_back*secondary_color_back;
	v3Attenuate*=fESun;
	v3Attenuate_back*=fESun_back;
}



float outro(float t)
{
	return (1-saturate(t))+saturate((t-85)/10)+
		(snoise(t)>t/10 ? 0.5 : 0.01)+
		sin(saturate((t-46)*.5)*PI)*0.3;
}//return saturate((t-10)/5)*0.95+0.05; }

float3 tonemap(float3 hdr_color, float t, float2 pos)
{
	hdr_color = max(0,hdr_color-0.004);
	hdr_color=(hdr_color*(6.2*hdr_color+0.5))/(hdr_color*(6.2*hdr_color+1.7)+0.06);

	hdr_color=lerp(hdr_color,frac(pos.y/CY*180)*/*float3(.8,.9,.9)**/fake_noise(pos/CX+frac(t)),min(1,outro(t)+0.01));
	return hdr_color;
}


static int ico_index[3*20]={0, 11, 5,0, 5, 1,0, 1, 7,0, 7, 10,0, 10, 11,1, 5, 9,5, 11, 4,11, 10, 2,10, 7, 6,7, 1, 8,3, 9, 4,3, 4, 2,3, 2, 6,3, 6, 8,3, 8, 9,4, 9, 5,2, 4, 11,6, 2, 10,8, 6, 7,9, 8, 1 };

float4 vp(float4 in_pos : SV_POSITION) : SV_POSITION { return in_pos; }

float4 vs(uint v:SV_VertexID):SV_POSITION
{
	float c=(1+sqrt(5))/2;
	int i=ico_index[v];
	float x[3]={0,0,0};
	x[i/4]=(i&1)*2-1;
	x[(i/4+1)%3]=-((i&2)*c-c);
	return float4(normalize(float3(x[0],x[1],x[2])),1);
}

float ph(float3 rpos)
{
//	return snoise(rpos);
//	return fInnerRadius*(saturate(snoise(rpos*16)+snoise(rpos*256)/5)/200+1);
	float desert=saturate(abs(rpos.y)*5);

	float gain=desert*.2+.2;//lerp(.2, .4/*mountain_params.x*/, desert);//0.4;
	float max_height=desert*.008+.002;//lerp(.002, .01, desert);//;//lerp(0.002, planet_params.x, desert);//0.01;
	//float plains=0.5;//mountain_params.y;//0.5;

	float sum=0;
	float amplitude=.5;
	float prev=1;

	float fbm_sum=0;
	float fbm_amp=.5;//0.5;

	prev=min(abs(snoise(rpos*4)*4), 1);

//	float time=(float)ct1/44100.0+80;
//	time=smoothstep(85,120,time);
	float time=smoothstep(3748500,5292000,ct1);//+3528000);
	float lacunarity=2.7-time;//(roughnoise*.05+1)*2.7; // lacunarity=2.7
	rpos*=lacunarity;
	for (uint i=0;i<2;i++)
	{
		float noise_sample=snoise(rpos);
		rpos*=lacunarity;
		fbm_sum+=noise_sample*pow(fbm_amp, -.8); // fbm_gain=0.8
		fbm_amp*=lacunarity;
	}

	float continent=fbm_sum;
//	float noise_sample;
	for (uint i=0;i<8;i++)
	{
		float noise_sample=snoise(rpos);

		float n=pow(1-abs(noise_sample),2);//ridge(noise_sample, offset);
		sum+=n*amplitude*prev;
		prev=n;
		rpos*=lacunarity;
		amplitude*=gain;

		if (i==0)
			gain*=pow(prev, .5);//plains);


		fbm_sum+=noise_sample*pow(fbm_amp, -.8); // fbm_gain=0.8
		fbm_amp*=lacunarity;
	}

	sum=sum*sum;
//	fbm_sum=min((fbm_sum+time*8)*8, 1); // fbm_shores=8.0
	fbm_sum=min(fbm_sum*8+time*128, 1); // fbm_shores=8.0
	sum+=max(continent/2, 0);
	sum*=fbm_sum;

	sum=lerp(sum,-.001,saturate(sum*-150+1));

	return fInnerRadius*(sum*max_height+1);
}

float3 drift(float t)
{
	t+=25;
	t/=4;
	return normalize(float3(sin(t*0.0375), sin(t*0.25)*.5+sin(t*0.05)*.2, cos(t*0.0375)))*60700;
}

float wp(out float4x4 view, out float3 campos)
{
	float time=(float)ct1/44100.0;
	//time=9;
	//time=12;
	//time=32;
	//time=48; // grass & land
	//time=40; // water specular
	//time=73; // desert
	//time=60;
	//time=7;0
	//time+=80;

	campos=drift(time)*(pow(max(0,time-48)*0.02,4)+1);
	float3 camto=drift(time+0.5)*.99;
	float3 zaxis=normalize(camto-campos);
	float3 xaxis=normalize(cross(campos, zaxis));
	float3 yaxis=cross(zaxis, xaxis);

	view[0]=float4(xaxis.x, yaxis.x, zaxis.x, 0);
	view[1]=float4(xaxis.y, yaxis.y, zaxis.y, 0);
	view[2]=float4(xaxis.z, yaxis.z, zaxis.z, 0);
	view[3]=float4(-dot(xaxis,campos),-dot(yaxis,campos),-dot(zaxis,campos),1);

	return time;
}

struct gst
{
	float4 o:SV_POSITION;
	float3 u:TEXCOORD0;
	float  l:TEXCOORD1;
};

float4 ps(gst g) : SV_TARGET
{
	float3 u=normalize(g.u);
	return float4(u*ph(u),g.l/32);
}

//[
void maings(float4 n[3], uint x, inout TriangleStream<gst> b, bool r)
{
	gst v[6];
	float4x4 w;
	float3 c;
	wp(w,c);

	for (uint i=0;i<3;i++)
		v[i].u=n[i];

	c/=60000;

	// backface culling
	float3 m=(n[0]+n[1]+n[2])/3;
	if (dot(normalize(m-c),m)>.3)
		return;

	bool a=1;
	for (uint i=0;i<3;i++)
	{
		float3 e=normalize(v[i].u+v[(i+1)%3].u);
		float h=distance(e,c)*.025; // kisebb ertek, erosebb subdivision 0.025
		if (length(v[i].u-v[(i+1)%3].u)>h) v[i+3].u=e; else {v[i+3].u=v[i].u;a=0;}
	}

	if (r^a)
	{
//		for (uint i=0;i<6;i++) v[i].o=r?mul(float4(v[i].u*60000/*ph(v[i].u)*/,1),w).xyzz*float4(CY/CX,1,1,1)-float4(0,0,1,0):float4(v[i].u,1);
		for (uint i=0;i<6;i++) v[i].o=r?mul(float4(v[i].u*ph(v[i].u),1),w).xyzz*float4(CY/CX,1,1,1)-float4(0,0,1,0):float4(v[i].u,1);
		x*=4;
		v[0].l=v[3].l=v[5].l=++x; b.Append(v[0]);b.Append(v[3]);b.Append(v[5]);b.RestartStrip();
		v[1].l=v[4].l=v[3].l=++x; b.Append(v[1]);b.Append(v[4]);b.Append(v[3]);b.RestartStrip();
		v[2].l=v[5].l=v[4].l=++x; b.Append(v[2]);b.Append(v[5]);b.Append(v[4]);b.RestartStrip();
		v[3].l=v[4].l=v[5].l=++x; b.Append(v[3]);b.Append(v[4]);b.Append(v[5]);b.RestartStrip();
	}
}

[maxvertexcount(12)]
void g0(triangle float4 i[3] : SV_POSITION, uint p:SV_PrimitiveId, inout TriangleStream<gst> b) // render
{
	maings(i,p,b,1);
}

[maxvertexcount(12)]
void g1(triangle float4 i[3] : SV_POSITION, uint p:SV_PrimitiveId, inout TriangleStream<gst> b) // subdiv
{
	maings(i,p,b,0);
}
//]

float4 v(uint v:SV_VertexID):SV_POSITION
{return float4((v&2)-.1,(v&1)-.1,0,.1);}


float3 p(float4 in_pos : SV_POSITION) : SV_TARGET
{
	float4x4 view;
	float3 campos;
	float t=wp(view,campos);

	float4 tex[3];
	tex[0]=fsquad.Load(in_pos);
	if (tex[0].a)//*tex[1].a*tex[2].a) // hat lesz egy csik a szelen, nem erdekes :)
	{
		tex[1]=fsquad.Load(in_pos,int2(1,0));
		tex[2]=fsquad.Load(in_pos,int2(0,1));
		float wire=saturate(abs(tex[1]-tex[0])+abs(tex[2]-tex[0])).a;

		float h=length(tex[0].xyz);
		float3 npos=tex[0]/h;
		float3 wnorm=normalize(cross(tex[1]-tex[0],tex[2]-tex[0]));

		float flatness=saturate(dot(wnorm, npos));
		float flatness_modifier=(1-flatness)*64;

		float l=dot(wnorm, -light_dir);

		float detail_noise=snoise(tex[0]*.2)*0.5+1;
		float4 col=float4(.01,.01,.01,detail_noise*.3-.1); // rock
		col=lerp(col,float4(.1,.15,.01,0)*detail_noise,pow(flatness,10)); // grass
		col=lerp(col,float4(1,1,1,.5)*detail_noise,saturate((h-60540)/5+flatness_modifier)); // snow
		col=lerp(float4(.2,.1,.02,.1)*(snoise(tex[0]*float3(.12,.0075,.0075))*0.3+1),col,saturate(saturate(abs(npos.y)*5)*2-1+flatness_modifier)); // sand
//		col*=1-smoothstep(85,90,t);
/*#if 0
		if (h<fInnerRadius) {col=0;col.a=detail_noise/2;}//float4(0,0,0,detail_noise/2);
		float s0=pow(saturate(dot(wnorm, normalize(-light_dir-normalize(tex[0]-campos)))), 100*col.w)*col.w*col.w;
#else*/
		if (h<fInnerRadius) {col=0;col.a=1/*detail_noise/2*/;}//float4(0,0,0,detail_noise/2);
		float3 vv=normalize(tex[0]-campos);
		float3 hv=normalize(-light_dir-vv);

		float s0=lerp(pow(saturate(dot(wnorm,hv)),col.w*100),1,pow(1-saturate(dot(vv,-hv)),5))*col.w*col.w;
/*		float hd=saturate(dot(vv,-hv));
		s0=lerp(s0,1,pow(1-hd,5));
		s0*=col.w*col.w;*/
//		return s0;
//#endif
		float4 cloud;
		float3 atm, att0, att1;
		skylight_calc(cloud, atm, att0, att1, tex[0],campos);

		//d0=0;
		//d1=(l*-.5+.5);
		//att1*=(l*-.5+.5)*4;

		att0*=saturate(abs(flatness-.95)*30)*.6+.4; // aoc


/*			float3 cpos=npos*60500/5000;
			float lc=0;
			float cw=1;
			for (int j=0;j<6;j++,cpos*=3,cw*=.75)
				lc+=snoise(cpos)*cw;
			float lofasz=saturate(lc-.1);
			lofasz=1-lofasz;
			lofasz=pow(lofasz,2);
			lofasz=saturate(lofasz+.2);
			//return lofasz;


			//return saturate(1-(lofasz*2))+cloud.rgb*cloud.a;
			atm*=lofasz;
			att0*=lofasz;*/

		//atm=0;
		//att0=1;

		//float wf=sin(pow(saturate((in_pos.x/CX-t+48)*.5),4)*PI);

		float wf=saturate((in_pos.x/CX-t+48)*.5);
		col=lerp(col,wire,sin(wf*wf*wf*wf*PI));
		return tonemap(lerp((att0*(saturate(l)*.95+.05)+att1*saturate(-l))*col+atm+s0*att0,cloud,cloud.a),t,in_pos);
	} else {
//		return 0;
		float3 vray=float3((in_pos.xy-float2(CX/2,CY/2))/(CY/2), 1);
		vray.y*=-1;
	//	vray.x*=-1;
		vray=normalize(mul((float3x3)view, vray));

		// stars
		float random = snoise(vray*150);
		random=pow(random/2+.5, 19)*0.375+0.0125;
		// cloud
		float cloud=0;
		for (int i=1;i<10;i+=2)
			cloud+=snoise(vray*i)/i;

		cloud=pow(cloud/2+.5, 2);

		float3 atm, att0, att1;
		float4 cld;
		skylight_calc(cld,atm, att0, att1, campos+vray*500000,campos);

		return	tonemap(float3(0.3,0.5,1.0)*random+
			float3(0.1,0.05,0.03)*cloud+lerp(atm,cld,cld.a)+pow(saturate(dot(vray,-light_dir)),999)*8,t,in_pos);
	}
}

float gn(float x){return exp(((x/8)*(x/8))/-2);}
float sq(float t, float f, float p){return frac(t*f)<abs((frac(t*p/2)-.5)*1.9)+.025 ? -1 : 1;}
float nf(float note){return pow(2.,note/12.)*440.;}
float dr(float it, float p, float r)
{
	float t=frac(it*p);
	float h=0.01;
	float f=sin(pow(t, 0.5)*PI*64.0);
	float v=t<h ? pow(t/h, 0.5) : 1.0f-pow(t-h, 0.8);
	f+=r*pow(v, 32.0f)*0.1f;
	return f*v;
}
// function, left freq, right freq, square phase speed, filter radius, amplification
// function, left timing, right timing, random value, filter radius, amplification
#define F(f, l, r, p, ra, v) for (int i=-128;i<128;i++) { float tf=i*(ra)/44100.+t; float g=gn(i)*v; s.x+=f(tf, l, p)*g; s.y+=f(tf, r, p)*g; }

float2 pw(float4 in_pos : SV_POSITION) : SV_TARGET
{
	//[
	float t; float2 s;
	//]

//	return 0;

	t=((in_pos.y-.5)*2048+in_pos.x-.5)/44100.;
//	t+=80;
	s=0;

	F(sq, nf(-40), nf(-40.15), 1./6, 1-saturate(t/16), .3);

	if (t>12)
		F(sq, nf(-28), nf(-28.15), 1./10, 1-saturate((t-12)/16), .1);

	if (t>36)
		F(sq, nf(-4), nf(-4.15), 1./40, 1-saturate((t-36)/16), .1);

	if (t>60)
		F(sq, nf(8), nf(8.15), 1./48, 1-saturate((t-60)/16), .05);

	if (t>16)
		F(dr, 2, 2, fake_noise(t+tf)*2-1, 8-saturate((t-16)/32)*8, 1.5);

	//s+=fake_noise(t);

	s=lerp(s,fake_noise(t)*24-12,outro(t));
	return s*0.021;
}


