#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN

#include <Windows.h>
#include <d3d11.h>
#include <mmsystem.h>
#include <d3dcompiler.h>
//#include <sal.h>
//#include <rpcsal.h>

#ifdef _DEBUG
#include <stdio.h>
#define D3DCHECK(x) if (FAILED((x))) ((char*)NULL)[0]=0;
//#define WIREFRAME 1
#else
#include "shader_code.h"
#define D3DCHECK(x) x;
#define FINAL 1
#endif
//#define DONTCRASH 1
//#define SHADERFILE 1



#define DEFINE_GUIDW(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) const GUID DECLSPEC_SELECTANY name = { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }
DEFINE_GUIDW(IID_ID3D11Texture2D,0x6f15aaf2,0xd208,0x4e89,0x9a,0xb4,0x48,0x95,0x35,0xd3,0x4f,0x9c);

	//signed short sound_data[SOUND_DIM*SOUND_DIM*2];

// define the size of the window
#define SOUND_DIM 2048
#define WINWIDTH 1280
#define WINHEIGHT 720
#define WINPOSX 0 
#define WINPOSY 0

#ifndef FINAL
ID3DBlob* scode;
ID3D11Device *pd3dDevice;
void compile_shader(const char* entry, ID3D11DeviceChild** shader)
{
	D3D11_SO_DECLARATION_ENTRY sodecl={0,"SV_POSITION",0,0,4,0};
	static char entry_stub[]="ss_5_0";
	entry_stub[0]=entry[0];

#ifdef _DEBUG
	if (*shader)
	{
		(*shader)->lpVtbl->Release(*shader);
		(*shader)=NULL;
	}

	ID3DBlob* error=NULL;
	if (SUCCEEDED(D3DCompileFromFile(L"shader.hlsl", NULL, NULL, entry, entry_stub, 0, 0, &scode, &error)))
	{
		if (entry[0]=='v')
			pd3dDevice->lpVtbl->CreateVertexShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
		else if (entry[0]=='p')
			pd3dDevice->lpVtbl->CreatePixelShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
		else if (entry[0]=='g')
		{
			if (entry[1]=='0')
				pd3dDevice->lpVtbl->CreateGeometryShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
			else
				pd3dDevice->lpVtbl->CreateGeometryShaderWithStreamOutput(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), &sodecl, 1, NULL, 0, D3D11_SO_NO_RASTERIZED_STREAM, NULL, shader);
		}
//		scode->lpVtbl->Release(scode);
	} else {
		if (error)
		{
			OutputDebugStringA(error->lpVtbl->GetBufferPointer(error));
			error->lpVtbl->Release(error);
		}
	}
#else

#ifdef DONTCRASH
	ID3DBlob* error=NULL;
	auto retval=D3DCompile(shader_hlsl, strlen(shader_hlsl), NULL, NULL, NULL, entry, entry_stub, 0, 0, &scode, &error);
	if (FAILED(retval))
	{
		OutputDebugStringA(error->lpVtbl->GetBufferPointer(error));
		ExitProcess(0);
	}
#else
#ifdef SHADERFILE
	auto retval=D3DCompileFromFile(L"shader.hlsl", NULL, NULL, entry, entry_stub, 0, 0, &scode, NULL);
#else
	auto retval=D3DCompile(shader_hlsl, strlen(shader_hlsl), NULL, NULL, NULL, entry, entry_stub, 0, 0, &scode, NULL);
#endif
#endif
	if (entry[0]=='v')
		pd3dDevice->lpVtbl->CreateVertexShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
	else if (entry[0]=='p')
		pd3dDevice->lpVtbl->CreatePixelShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
	else if (entry[0]=='g')
	{
		if (entry[1]=='0')
			pd3dDevice->lpVtbl->CreateGeometryShader(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), NULL, shader);
		else
			pd3dDevice->lpVtbl->CreateGeometryShaderWithStreamOutput(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), &sodecl, 1, NULL, 0, D3D11_SO_NO_RASTERIZED_STREAM, NULL, shader);
	}
#endif
}
#endif

typedef struct
{
	unsigned int	waveout_get_tag;
	unsigned int	current_time;
	float			res[2];
}  constant_buffer_t;

// Take away prolog and epilog, then put a minial prolog back manually with assembly below. The function never returns so no epilog is necessary.
__declspec( naked )  void __cdecl winmain()

{
	// Prolog
	//__asm enter 0x10, 0;
	__asm 
	{
		push ebp
        mov ebp,esp
        sub esp,__LOCAL_SIZE
	}
	
	{ // Extra scope to make compiler accept the __decalspec(naked) with local variables

	// D3D 11 device variables
	// Global Variables:
	IDXGISwapChain *pSwapChain;
	ID3D11RenderTargetView *pRenderTargetView;
	ID3D11DeviceContext *pImmediateContext;
	ID3D11VertexShader* pVertexShader;
	ID3D11PixelShader* pPixelShader;
	ID3D11PixelShader* pSoundShader;
	ID3D11Buffer* pConstantBuffer;
	ID3D11Texture2D* pDepthTexture;
	ID3D11DepthStencilView *pDepthRT;
	ID3D11VertexShader* pVertexSphere;
	ID3D11PixelShader* pPixelSphere;
	ID3D11VertexShader* pVertexPass;
	ID3D11GeometryShader* pGeometrySphere[2];
	ID3D11Texture2D*	pTargetTexture;
	ID3D11RenderTargetView*	pTargetRT;
	ID3D11ShaderResourceView* pTargetRV;

#ifdef FINAL
	ID3D11Device *pd3dDevice;
#endif

	// timer global variables
	constant_buffer_t cb_data = { TIME_SAMPLES,  0, WINWIDTH, WINHEIGHT };

	// the most simple window
	HWND hWnd = CreateWindow(L"edit", 0, WS_POPUP | WS_VISIBLE, WINPOSX, WINPOSY, WINWIDTH, WINHEIGHT, 0, 0, 0, 0);

	// don't show the cursor
	ShowCursor(FALSE);

#ifdef FINAL
	const static DXGI_SWAP_CHAIN_DESC sd = {{WINWIDTH, WINHEIGHT, {60, 1},  DXGI_FORMAT_R8G8B8A8_UNORM, DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED, DXGI_MODE_SCALING_UNSPECIFIED }, {1, 0}, DXGI_USAGE_RENDER_TARGET_OUTPUT, 1, NULL, FALSE, DXGI_SWAP_EFFECT_DISCARD, 0};
#else
	const static DXGI_SWAP_CHAIN_DESC sd = {{WINWIDTH, WINHEIGHT, {0, 0},  DXGI_FORMAT_R8G8B8A8_UNORM, DXGI_MODE_SCANLINE_ORDER_UNSPECIFIED, DXGI_MODE_SCALING_UNSPECIFIED }, {1, 0}, DXGI_USAGE_RENDER_TARGET_OUTPUT, 1, NULL, TRUE, DXGI_SWAP_EFFECT_SEQUENTIAL, 0};
#endif
	//
	DXGI_SWAP_CHAIN_DESC temp;
	temp = sd;
	temp.OutputWindow = hWnd;

 	D3D11CreateDeviceAndSwapChain(
			NULL,					// might fail with two adapters in machine
			D3D_DRIVER_TYPE_HARDWARE,
			NULL, 
#ifdef _DEBUG
			D3D11_CREATE_DEVICE_DEBUG,
#else
			0,//D3D11_CREATE_DEVICE_DEBUG,
#endif
			NULL,
			0,
			D3D11_SDK_VERSION,
			&temp,
			&pSwapChain,
			&pd3dDevice,
			NULL,
			&pImmediateContext);


	pSwapChain->lpVtbl->Present( pSwapChain, 1, 0 ); // clear

	// Create a back buffer render target, get a view on it to clear it later
	ID3D11Texture2D *pBackBuffer;
	const static D3D11_VIEWPORT vp = {0, 0, WINWIDTH, WINHEIGHT, 0, 1}; 
	D3DCHECK(pSwapChain->lpVtbl->GetBuffer( pSwapChain, 0, (REFIID ) &IID_ID3D11Texture2D, (LPVOID*)&(pBackBuffer) ));
	D3DCHECK(pd3dDevice->lpVtbl->CreateRenderTargetView( pd3dDevice, (ID3D11Resource*)pBackBuffer, NULL, &pRenderTargetView ));
	const static D3D11_TEXTURE2D_DESC depthtex = { WINWIDTH, WINHEIGHT, 1, 1, DXGI_FORMAT_D32_FLOAT, { 1, 0 }, D3D11_USAGE_DEFAULT, D3D11_BIND_DEPTH_STENCIL, 0, 0 };
	D3DCHECK(pd3dDevice->lpVtbl->CreateTexture2D(pd3dDevice, &depthtex, NULL, &pDepthTexture));
	D3DCHECK(pd3dDevice->lpVtbl->CreateDepthStencilView(pd3dDevice, pDepthTexture, NULL, &pDepthRT));
	const static D3D11_TEXTURE2D_DESC targtex = { WINWIDTH, WINHEIGHT, 1, 1, DXGI_FORMAT_R32G32B32A32_FLOAT, { 1, 0 }, D3D11_USAGE_DEFAULT, D3D11_BIND_RENDER_TARGET|D3D11_BIND_SHADER_RESOURCE, 0, 0 };
	D3DCHECK(pd3dDevice->lpVtbl->CreateTexture2D(pd3dDevice, &targtex, NULL, &pTargetTexture));
	D3DCHECK(pd3dDevice->lpVtbl->CreateRenderTargetView(pd3dDevice, pTargetTexture, NULL, &pTargetRT));
	D3DCHECK(pd3dDevice->lpVtbl->CreateShaderResourceView(pd3dDevice, pTargetTexture, NULL, &pTargetRV));

	// constant buffer
	const static D3D11_BUFFER_DESC bd = { sizeof(constant_buffer_t), D3D11_USAGE_DEFAULT, D3D11_BIND_CONSTANT_BUFFER, 0, 0, 0 };
	D3DCHECK(pd3dDevice->lpVtbl->CreateBuffer(pd3dDevice, &bd, NULL, &pConstantBuffer));

	// default shaders
#ifdef _DEBUG
	pPixelShader=NULL;
	pVertexShader=NULL;
	pSoundShader=NULL;
	pVertexSphere=NULL;
	pPixelSphere=NULL;
	pVertexPass=NULL;
	pGeometrySphere[0]=pGeometrySphere[1]=NULL;
#endif
#ifndef FINAL
	compile_shader("v", &pVertexShader);
	compile_shader("p", &pPixelShader);
	compile_shader("vs", &pVertexSphere);
	compile_shader("ps", &pPixelSphere);
	compile_shader("g0", &pGeometrySphere[0]);D3DCHECK(pGeometrySphere[0] ? S_OK : E_INVALIDARG);
	compile_shader("g1", &pGeometrySphere[1]);D3DCHECK(pGeometrySphere[1] ? S_OK : E_INVALIDARG);
	compile_shader("vp", &pVertexPass); // rogton ezutan jojjon az input layout, mert az scode most meg jot tartalmaz!!!!!
#else
	static const D3D11_SO_DECLARATION_ENTRY sodecl={0,"SV_POSITION",0,0,4,0};
	ID3DBlob* scode;

	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"pw","ps_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreatePixelShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pSoundShader);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"p","ps_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreatePixelShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pPixelShader);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"ps","ps_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreatePixelShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pPixelSphere);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"g0","gs_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreateGeometryShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pGeometrySphere[0]);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"g1","gs_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreateGeometryShaderWithStreamOutput(pd3dDevice, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), &sodecl, 1, NULL, 0, D3D11_SO_NO_RASTERIZED_STREAM, NULL,&pGeometrySphere[1]);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"v","vs_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreateVertexShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pVertexShader);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"vs","vs_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreateVertexShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pVertexSphere);
	D3DCompile(shader_hlsl,strlen(shader_hlsl),NULL,NULL,NULL,"vp","vs_5_0",0,0,&scode,NULL);
	pd3dDevice->lpVtbl->CreateVertexShader(pd3dDevice,scode->lpVtbl->GetBufferPointer(scode),scode->lpVtbl->GetBufferSize(scode),NULL,&pVertexPass);
#endif

	ID3D11InputLayout* pLayout;
	const static D3D11_INPUT_ELEMENT_DESC iadesc={"SV_POSITION", 0, DXGI_FORMAT_R32G32B32A32_FLOAT, 0, 0, D3D11_INPUT_PER_VERTEX_DATA, 0};
	D3DCHECK(pd3dDevice->lpVtbl->CreateInputLayout(pd3dDevice, &iadesc, 1, scode->lpVtbl->GetBufferPointer(scode), scode->lpVtbl->GetBufferSize(scode), &pLayout));
	pImmediateContext->lpVtbl->IASetPrimitiveTopology(pImmediateContext, D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST);
	pImmediateContext->lpVtbl->IASetInputLayout(pImmediateContext, pLayout);

/*	// vertexbuffer
	const static D3D11_BUFFER_DESC icodesc = { sizeof(constant_buffer_t), D3D11_USAGE_DEFAULT, D3D11_BIND_VERTEX_BUFFER, 0, 0, 0};
	const static D3D11_SUBRESOURCE_DATA icosub = { NULL, 0, 0 };
	pd3dDevice->lpVtbl->CreateBuffer(pd3dDevice, &icodesc, &icosub, &pIcosahedronBuffer);*/

#define NUMBUFF 15
#define BUFFSIZE 1024*1024*10

	ID3D11Buffer* pStreamBuffer[NUMBUFF];
	const static D3D11_BUFFER_DESC streamdesc = { BUFFSIZE, D3D11_USAGE_DEFAULT, D3D11_BIND_VERTEX_BUFFER|D3D11_BIND_STREAM_OUTPUT, 0, 0, 0};
	for (int i=0;i<NUMBUFF;i++)
		D3DCHECK(pd3dDevice->lpVtbl->CreateBuffer(pd3dDevice, &streamdesc, NULL, &pStreamBuffer[i]));

#if 1 // sound
	const static D3D11_TEXTURE2D_DESC wavetex = { SOUND_DIM, SOUND_DIM, 1, 1, DXGI_FORMAT_R16G16_SNORM, { 1, 0 }, D3D11_USAGE_DEFAULT, D3D11_BIND_RENDER_TARGET, 0, 0 };
	const static D3D11_TEXTURE2D_DESC wavestg = { SOUND_DIM, SOUND_DIM, 1, 1, DXGI_FORMAT_R16G16_SNORM, { 1, 0 }, D3D11_USAGE_STAGING, 0, D3D11_CPU_ACCESS_READ, 0 };
	const static D3D11_VIEWPORT vpw = {0, 0, SOUND_DIM, SOUND_DIM, 0, 1}; 

	ID3D11Texture2D* pWaveTex;
	ID3D11Texture2D* pWaveStg;
	ID3D11RenderTargetView *pWaveRt;

	D3DCHECK(pd3dDevice->lpVtbl->CreateTexture2D(pd3dDevice, &wavetex, NULL, &pWaveTex));
	D3DCHECK(pd3dDevice->lpVtbl->CreateTexture2D(pd3dDevice, &wavestg, NULL, &pWaveStg));
	D3DCHECK(pd3dDevice->lpVtbl->CreateRenderTargetView(pd3dDevice, pWaveTex, NULL, &pWaveRt));

#ifndef FINAL
	compile_shader("pw", &pSoundShader);
#endif
	HWAVEOUT hwo;

/*#ifdef _DEBUG
	if (pSoundShader)
	{
#endif*/
	D3DCHECK(pSoundShader ? S_OK : E_INVALIDARG);

	pImmediateContext->lpVtbl->OMSetRenderTargets(pImmediateContext, 1, &pWaveRt, NULL);
	pImmediateContext->lpVtbl->RSSetViewports( pImmediateContext, 1, &vpw );
	pImmediateContext->lpVtbl->VSSetShader(pImmediateContext, pVertexShader, NULL, 0);
	pImmediateContext->lpVtbl->PSSetShader(pImmediateContext, pSoundShader, NULL, 0);
	pImmediateContext->lpVtbl->Draw(pImmediateContext, 3, 0);
	pImmediateContext->lpVtbl->CopyResource(pImmediateContext, pWaveStg, pWaveTex);

	D3D11_MAPPED_SUBRESOURCE msw;
	D3DCHECK(pImmediateContext->lpVtbl->Map(pImmediateContext, pWaveStg, 0, D3D11_MAP_READ, 0, &msw));
	//memcpy(&sound_data[0], msw.pData, sizeof(sound_data));
	//pImmediateContext->lpVtbl->Unmap(pImmediateContext, pWaveStg, 0);

#if 0//def _DEBUG
	FILE *f=fopen("sound.bin", "wb");
	fwrite(msw.pData, SOUND_DIM*SOUND_DIM*4, 1, f);
	fclose(f);
#endif

	// sound
	const static WAVEFORMATEX wfx = {WAVE_FORMAT_PCM, 2, 44100, 44100*4, 4, 16, 0};
	waveOutOpen(&hwo,0, &wfx, NULL, NULL, 0);

//	static WAVEHDR wh = { &sound_data[0], sizeof(sound_data), 0, 0, WHDR_PREPARED, 0, 0, 0 };
	static WAVEHDR wh = { NULL, SOUND_DIM*SOUND_DIM*4, 0, 0, WHDR_PREPARED, 0, 0, 0 };
	wh.lpData=msw.pData;
	//waveOutPrepareHeader(hwo, &wh, sizeof(wh));
	waveOutWrite(hwo, &wh, sizeof(wh));
/*#ifdef _DEBUG
	}
#endif*/
#endif

#if defined(_DEBUG)
	while (1)
#else
	while (!GetAsyncKeyState(VK_ESCAPE) && (!(wh.dwFlags & WHDR_DONE)))
#endif
	{
#ifdef _DEBUG
		MSG msg;
		PeekMessage(&msg, hWnd, 0, 0, PM_REMOVE);
		if ((GetAsyncKeyState(VK_CONTROL) && GetAsyncKeyState('S')))
		{
			compile_shader("v", &pVertexShader);
			compile_shader("p", &pPixelShader);
			compile_shader("vs", &pVertexSphere);
			compile_shader("ps", &pPixelSphere);
			compile_shader("g0", &pGeometrySphere[0]);
			compile_shader("g1", &pGeometrySphere[1]);
			waveOutWrite(hwo, &wh, sizeof(wh));
		}

		if (!pVertexShader || !pPixelShader || !pVertexSphere || !pPixelSphere || !pGeometrySphere[0] || !pGeometrySphere[1])
		{
			static float ClearColorError[4] = { 1.0f, 0.125f, 0.3f, 1.0f };
			pImmediateContext->lpVtbl->ClearRenderTargetView(pImmediateContext, pRenderTargetView, ClearColorError );
			pSwapChain->lpVtbl->Present( pSwapChain, 1, 0 );
			continue;
		}
#endif

		waveOutGetPosition(hwo, (LPMMTIME)&cb_data, sizeof(MMTIME));

		pImmediateContext->lpVtbl->UpdateSubresource(pImmediateContext, pConstantBuffer, 0, NULL, &cb_data, sizeof(constant_buffer_t), 0);
		pImmediateContext->lpVtbl->PSSetConstantBuffers(pImmediateContext, 0, 1, &pConstantBuffer);
		pImmediateContext->lpVtbl->VSSetConstantBuffers(pImmediateContext, 0, 1, &pConstantBuffer);
		pImmediateContext->lpVtbl->GSSetConstantBuffers(pImmediateContext, 0, 1, &pConstantBuffer);

#define so_zero &vp.TopLeftX
#define so_stride &wfx.wBitsPerSample

		// set targets & clear depth
#ifndef FINAL
		pImmediateContext->lpVtbl->PSSetShaderResources(pImmediateContext, 0, 1, so_zero);
		static const UINT so_zeroes[4]={0,0,0,0};
#else
		#define so_zeroes bd.BindFlags
#endif
		pImmediateContext->lpVtbl->OMSetRenderTargets(pImmediateContext, 1, &pTargetRT, pDepthRT);
		pImmediateContext->lpVtbl->ClearRenderTargetView(pImmediateContext, pTargetRT, (const FLOAT*)&so_zeroes);
		pImmediateContext->lpVtbl->RSSetViewports( pImmediateContext, 1, &vp );
		pImmediateContext->lpVtbl->ClearDepthStencilView(pImmediateContext, pDepthRT, D3D11_CLEAR_DEPTH, 1, 0);

#ifdef WIREFRAME
		ID3D11RasterizerState *rs;
		D3D11_RASTERIZER_DESC rdesc = {0};
		rdesc.CullMode=D3D11_CULL_NONE;
		rdesc.FillMode=D3D11_FILL_WIREFRAME;
		pd3dDevice->lpVtbl->CreateRasterizerState(pd3dDevice, &rdesc, &rs);
		pImmediateContext->lpVtbl->RSSetState(pImmediateContext, rs);
		rs->lpVtbl->Release(rs);
#endif
		// ico -> streamout
		pImmediateContext->lpVtbl->SOSetTargets(pImmediateContext, 1, &pStreamBuffer[0], so_zero);
		pImmediateContext->lpVtbl->VSSetShader(pImmediateContext, pVertexSphere, NULL, 0);
		pImmediateContext->lpVtbl->PSSetShader(pImmediateContext, pPixelSphere, NULL, 0);
		pImmediateContext->lpVtbl->GSSetShader(pImmediateContext, pGeometrySphere[1], NULL, 0);
		pImmediateContext->lpVtbl->Draw(pImmediateContext, 3*20, 0);

		// streamout -> streamout
		pImmediateContext->lpVtbl->VSSetShader(pImmediateContext, pVertexPass, NULL, 0);
		for (int i=0;i<NUMBUFF-1;i++)
		{
			pImmediateContext->lpVtbl->SOSetTargets(pImmediateContext, 1, &pStreamBuffer[i+1], so_zero);
			pImmediateContext->lpVtbl->IASetVertexBuffers(pImmediateContext, 0, 1, &pStreamBuffer[i], so_stride, so_zero);
			pImmediateContext->lpVtbl->GSSetShader(pImmediateContext, pGeometrySphere[1], NULL, 0);
			pImmediateContext->lpVtbl->DrawAuto(pImmediateContext);

			pImmediateContext->lpVtbl->SOSetTargets(pImmediateContext, 0, NULL, NULL);
			pImmediateContext->lpVtbl->GSSetShader(pImmediateContext, pGeometrySphere[0], NULL, 0);
			pImmediateContext->lpVtbl->DrawAuto(pImmediateContext);
		}

#ifdef WIREFRAME
		pImmediateContext->lpVtbl->RSSetState(pImmediateContext, NULL);
#endif

		//pImmediateContext->lpVtbl->SOSetTargets(pImmediateContext, 0, NULL, NULL);
		//pImmediateContext->lpVtbl->IASetVertexBuffers(pImmediateContext, 0, 1, &so_zero, &so_zero, &so_zero);
		pImmediateContext->lpVtbl->GSSetShader(pImmediateContext, NULL, NULL, 0);

		pImmediateContext->lpVtbl->OMSetRenderTargets(pImmediateContext, 1, &pRenderTargetView, NULL);
		pImmediateContext->lpVtbl->PSSetShaderResources(pImmediateContext, 0, 1, &pTargetRV);

		// render stars
		pImmediateContext->lpVtbl->VSSetShader(pImmediateContext, pVertexShader, NULL, 0);
		pImmediateContext->lpVtbl->PSSetShader(pImmediateContext, pPixelShader, NULL, 0);
		pImmediateContext->lpVtbl->Draw(pImmediateContext, 3, 0);

#ifdef _DEBUG
		pSwapChain->lpVtbl->Present( pSwapChain, 0, 0 );
#else
		pSwapChain->lpVtbl->Present( pSwapChain, 1, 0 );
#endif
	}
	}

	ExitProcess(0);
}
