/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
digit =     [0-9];
letter =    [a-zA-Z_@];
suffix =    [$%&!#];
hex =       [a-fA-F0-9];
bin =       [0-1];
oct =       [0-7];
/* -- */
space           = [\40];
any             = [\1-\41\43-\377];
nescquote       = [^\\"];
doublequote     = ([\42][\42]);
schar           = nescquote | doublequote | any;
string          = '"' schar* '"';
invalidstr      = '"' schar* '\n';
name            = letter (letter|digit)* suffix*;
atcode          = '@' 'X' hex hex;
number          = (digit* | [+-] digit*);
exp             = [Ee] number;
doubl           = number "." (digit* | digit* exp);

%{
#define YYSTYPE char*
#include <stdio.h>
#include "pps_tab.h"
#pragma warn -rch
#pragma warn -ias

#define STRCONST 1
#define INTCONST 2
#define HEXCONST 3
#define SYMBOL   4
#define DBLCONST 5
#define BINCONST 6
#define OCTCONST 7

char *lookup(int type);
void beep(void);
extern lookupType;
char *zero(void);

char yytext[256];
char previousyytext[256];
int a;
int h;
char *p;
extern int lexn;
extern int linePart;

void count();
%}

%%
'\n'							{ return 0; }

";"|"'"|"#"                     { comment("\n"); }

name | atcode					{
								  count();
								  return check_type();
								}
atcode / space* ".."                   { count(); return check_type(); }
digit hex* [hH] / space* ".."          { count(); yylval = lookup(HEXCONST); return IDENTIFIER; }
digit digit* / space* ".."             { count(); yylval = lookup(INTCONST); return IDENTIFIER; }
digit digit* [Dd] / space* ".."        { count(); yylval = lookup(INTCONST); return IDENTIFIER; }
doubl / space* ".."              		{ count(); yylval = lookup(DBLCONST); return IDENTIFIER; }
bin bin* [Bb] / space* ".."            { count(); yylval = lookup(BINCONST); return IDENTIFIER; }
oct oct* [Oo] / space* ".."            { count(); yylval = lookup(BINCONST); return IDENTIFIER; }


digit hex* [hH]                 { count(); yylval = lookup(HEXCONST); return IDENTIFIER; }
digit digit*                    { count(); yylval = lookup(INTCONST); return IDENTIFIER; }
digit digit* [Dd]               { count(); yylval = lookup(INTCONST); return IDENTIFIER; }
string    						{ count(); yylval = lookup(STRCONST); return IDENTIFIER; }
doubl               			{ count(); yylval = lookup(DBLCONST); return IDENTIFIER; }
bin bin* [Bb]                   { count(); yylval = lookup(BINCONST); return IDENTIFIER; }
oct oct* [Oo]                   { count(); yylval = lookup(BINCONST); return IDENTIFIER; }
invalidstr                      { count(); yyerror("unterminated string"); yylval = zero(); return IDENTIFIER; }

"&&" | "&"      { count(); return(OP_AND); }
"||" | "|"      { count(); return(OP_OR); }
"!"             { count(); return(OP_NOT); }
"<=" | "=<"     { count(); return(OP_LE); }
">=" | "=>"     { count(); return(OP_AE); }
"=="            { count(); return(OP_EQ); }
"="      		{ count(); return('='); }
"!=" | "<>" | "=!" { count(); return(OP_NE); }
"<"             { count(); return(OP_LO); }
">"             { count(); return(OP_AB); }
"*"             { count(); if (lexn > 1) return('*'); else comment("\n");}
"/"             { count(); return('/'); }
"%"             { count(); return('%'); }
"^"             { count(); return('^'); }
"-"             { count(); return('-'); }
"+"             { count(); return('+'); }
":"             { count(); if (lexn==1) return(LABELMARKER); linePart++; return(':'); }
","             { count(); return(','); }
"("             { count(); return('('); }
")"             { count(); return(')'); }
"]"       		{ count(); return(']'); }
"["       		{ count(); return('['); }
".."            { count(); return(SUBRANGE); }

[ \t\v\f]		{ count(); }
.               { /* ignore bad characters */ }

%%

#pragma warn .rch
#pragma warn .ias

