/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if !defined( __TAGGER_H )
#define __TAGGER_H

#define Uses_TCollection
#define Uses_TScroller
#define Uses_TWindow
#define Uses_TListBox
#define Uses_TDialog
#include <tv.h>

#define cTaggerWindow     "\x40\x41\x42\x43\x44\x45\x46\x47"


class TTaggerList : public TListBox
{

public:

	TTaggerList(TRect& bounds, TScrollBar *aVScrollBar);
	virtual TPalette& getPalette() const;
//	TListBox *tagListBox;

private:

	virtual const char *streamableName() const
	{ return name; }

protected:

	TTaggerList( StreamableInit );
	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const name;
	static TStreamable *build();

};



class TTaggerWindow : public TWindow
{

public:

	TTaggerWindow( const int winnum );
	void update();
	void removeAll();
	void handleEvent(TEvent& event);
	TTaggerList *tagListBox;

private:

	void trackTag( int );
	virtual const char *streamableName() const
	{ return name; }

protected:

	TTaggerWindow( StreamableInit );
	virtual void write( opstream& );
	virtual void *read( ipstream& );

public:

	static const char * const name;
	static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TTaggerWindow& cl )
	{ return is >> (TStreamable&) cl; }
inline ipstream& operator >> ( ipstream& is, TTaggerWindow*& cl )
	{ return is >> (void *&) cl; }

inline opstream& operator << ( opstream& os, TTaggerWindow& cl )
	{ return os << (TStreamable&) cl; }
inline opstream& operator << ( opstream& os, TTaggerWindow* cl )
	{ return os << (TStreamable *) cl; }

//const int maxLineLength = 256;

#endif
