#include <process.h>
#include <io.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <dos.h>

int readKeyFile(char *str);
void correctfilename(char *filename);

void main(int argc, char **argv)
{
char chaine[255]="";
int ntry=0;
argc=argc;
char filename[255]="";

if (argc < 3)
	{
	printf("PowerPPL KeyFile Packager v1.0\n"
		   "\n"
		   "Usage :\n"
		   "PPKEYGEN FIRSTNAME LASTNAME\n");
	exit(-6);
    }

if (!access("PP.KEY", 0))
	{
    printf("Please, delete PP.KEY before running PPKEYGEN\n");
    exit(-1);
    }

if (!access("README.TXT", 0))
	{
    printf("Please, delete README.TXT before running PPKEYGEN\n");
    exit(-5);
    }

genkey:

if (spawnvp(P_WAIT, "PPKEY.EXE", argv) == -1)
	{
	printf("Error (%d) running PPKEY.EXE\n", errno);
    exit(-2);
    }

printf("\n");

if (readKeyFile(chaine))
	{
	printf("No keyfile found or Invalid keyfile");
    if (++ntry > 16)
    	{
        printf("\n\nToo many bad keys! Key generation failure\n");
        exit(-3);
        }
	printf(", retrying (%d)\n", ++ntry);
    if (!access("PP.KEY",0))
    	unlink("PP.KEY");
    goto genkey;
    }

printf("Key check OK!\n");

FILE * out;

if ((out = fopen("README.TXT", "wt")) == NULL)
	{
    printf("could not create instruction file!\n");
    exit(-4);
    }
fprintf(out, "PowerPPL KeyFile Informations :\n\n"
	   "Key File             : PP.KEY\n"
	   "Key Owner            : %s %s\n\n\n"
	   ,strupr(argv[1])
	   ,strupr(argv[2]));
fprintf(out, "Thanks for your support!\n\n"
			 "Put the file PP.KEY in your PowerPPL home directory (for example"
             "\"C:\\PP\" and run PowerPPL. All reminder screens should be removed\n\n"
             "In case of trouble, write to :\n\n"
			 "lone@mygale.org\n"
			 "or lone.runner@nuxes.frmug.fr.net\n"
             "or francis.gastellu@ace.epita.fr\n\n"
             "Thanks again for your support!\n");
fclose(out);

strcpy(filename, argv[1]);
if (strlen(filename) > 8)
	filename[8] = 0;

correctfilename(filename);

if (spawnlp(P_WAIT, "PKZIP.EXE", "PKZIP.EXE", "-m", filename, "PP.KEY", "README.TXT", NULL) == -1)
	{
	printf("Error (%d) running PKZIP.EXE\n", errno);
    exit(-2);
    }

printf("\nKey generated and packaged in file %s.ZIP !\n", filename);
}

int readKeyFile(char *str)
{

FILE *in;
int a;
unsigned int seed;
unsigned int sum=0;
unsigned int siz=0;
unsigned char c;
unsigned char e;
unsigned char f;
char *d = "X";
char hdr[19];

if ((in = fopen("PP.KEY", "rb"))
	== NULL)
{
   fprintf(stderr, "Cannot open input file.\n");
   return 1;
}

fread(&hdr, 17, 1, in);
hdr[17]=0;
if (!strcmp(hdr,"PowerPPL KeyFile "))
	{
	fread(&seed, sizeof(seed), 1, in);
	srand(seed);
	}
else
	randomize();


fread(&siz, sizeof(siz), 1, in);

for (a=0;a < siz;a++)
	{
	c = (unsigned char)random(95)+33;
	if (c > 80)
		{
		while (1)
			{
			if (fgetc(in) != random(95)+33)
				while (1)
					if (random(50) == 6) break;
			if (random(30) == 6) break;
			}
		c = (unsigned char)random(95)+33;
		}
	if (c > 50 && c < 100)
		c += random(95)+33;
	lp2:
	if (c <= 32)
		c += random(95)+33;
	if (c >= 127)
		c -= random(95)+33;
	if (c <= 32)
		goto lp2;
	f = fgetc(in);
	e = getc(in)-33;
	for (;e > 0;e--)
		f -= random(95)+33;

	d[0] = f ^ c;
	sum += d[0];
	if (feof(in) || strlen(str) > 250)
		break;
	strcat(str, d);
	}

f = fgetc(in);
e = getc(in)-33;
for (;e > 0;e--)
	f -= random(95)+33;

siz = f << 8;

f = fgetc(in);
e = getc(in)-33;
for (;e > 0;e--)
	f -= random(95)+33;

siz += f;

fclose(in);

return(siz != sum);

}

void correctfilename(char *file)
{
for (int a =0; a < strlen(file); a++)
	{
    switch (file[a])
    	{
		case '.':
		case '*':
		case '?':
		case '\\':
		case '/':
		case ':':
		case ';':
		case ',':
		case '=':
		case '+':
		case 34 :
		case '[':
		case ']':
		case '<':
		case '>':
        	file[a] = '_';
            break;
        }
    if (file[a] <= 31)
       	file[a] = '_';
	}
}
