/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1994-1998 Francis Gastellu
                      aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#define Uses_TRect
#define Uses_TEvent
#define Uses_TKeys
#define Uses_TDrawBuffer
#define Uses_TStreamableClass
#define Uses_TStreamable
#define Uses_TView
#define Uses_TWindow
#include <tv.h>
__link( RView )
__link( RWindow )

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <strstrea.h>
#include <iomanip.h>

#include "pcbcolor.h"
#include <stdio.h>


//
// TCTable functions
//

ushort curFg=15, curBg=0;
char *colorCode = "XX";

#pragma warn -ias
const char * const TCTable::name = "TCTable";
#pragma warn .ias


void TCTable::write( opstream& os )
{
	TView::write( os );
}


void *TCTable::read( ipstream& is )
{
	TView::read( is );
    return this;
}


TStreamable *TCTable::build()
{
	return new TCTable( streamableInit );
}


TStreamableClass RCTable( TCTable::name,
			 TCTable::build,
			 __DELTA(TCTable)
		       );


TCTable::TCTable(TRect& r) :
 TView( r )
{
}


void TCTable::draw()
{
	TDrawBuffer buf;
	char        color = getColor(6);
	unsigned char fg=0;

	buf.moveChar(0, ' ', color, 1);
	buf.moveChar(1, '', 15, 1);
	buf.moveChar(2, '', 15, 49);
	buf.moveChar(51, '', 15, 1);
	buf.moveChar(52, ' ', color, 2);
	writeLine(0, 0, size.x, 1, buf);

	for(int y = 0; y <= size.y-3; y++)
	{
	buf.moveChar(0, ' ', color, 1);
	buf.moveChar(1, '', 15, 1);
	buf.moveChar(2, ' ', 15, 1);
	for (fg = 15; fg !=255; fg--)
		{
		if ((y*16+fg) != 0)
			buf.moveChar(((16-fg)*3), 'X', y*16+fg, 2);
		else
			buf.moveChar(((16-fg)*3), ' ', y*16+fg, 2);
		buf.moveChar(((16-fg)*3)+2, ' ', 15, 1);
		buf.moveChar(51, '', 15, 1);
		buf.moveChar(52, ' ', 15, 2);
		}
	writeLine(0, y+1, size.x, 1, buf);
	}

	buf.moveChar(0, ' ', color, 1);
	buf.moveChar(1, '', 15, 1);
	buf.moveChar(2, '', 15, 49);
	buf.moveChar(51, '', 15, 1);
	buf.moveChar(52, ' ', 15, 2);
	writeLine(0, 17, size.x, 1, buf);

	buf.moveChar(0, ' ', color, 3);
	buf.moveChar(3, ' ', 15, 50);
	writeLine(0, 18, size.x, 1, buf);

	affPointer();
}


void TCTable::affPointer()
{
TDrawBuffer buf;

buf.moveChar(0, '', 15, 1);
if ((curBg*16+curFg) != 0)
	buf.moveChar(1, 'X', curBg*16+curFg, 2);
else
	buf.moveChar(1, ' ', 15, 2);
buf.moveChar(3, '', 15, 2);
writeLine(((16-curFg)*3)-1, curBg+1 , 4, 1, buf);
}

void TCTable::effPointer()
{
TDrawBuffer buf;

buf.moveChar(0, ' ', 15, 1);
if ((curBg*16+curFg) != 0)
	buf.moveChar(1, 'X', curBg*16+curFg, 2);
else
	buf.moveChar(1, ' ', 15, 2);
buf.moveChar(3, ' ', 15, 2);

writeLine(((16-curFg)*3)-1, curBg+1 , 4, 1, buf);
}

void TCTable::handleEvent(TEvent& event)
{
	TView::handleEvent(event);

	if (event.what == evMouseDown)
	{
	do
		{
		if(mouseInView(event.mouse.where))
		{
		TPoint spot = makeLocal(event.mouse.where);
		setCursor(spot.x, spot.y);
		}
		} while (mouseEvent(event, evMouseMove));
	clearEvent(event);
	}
	else
	{
	if (event.what == evKeyboard)
		{
		switch (event.keyDown.keyCode)
		{
		case kbHome:
			effPointer();
			curFg = 15;
			curBg = 0;
			affPointer();
			break;
		case kbEnd:
			effPointer();
			curFg = 0;
			curBg = 15;
			affPointer();
			break;
		case kbUp:
			effPointer();
			if (curBg > 0) curBg--; else curBg = 15;
			affPointer();
			break;
		case kbDown:
			effPointer();
			if (curBg < 15) curBg++; else curBg = 0;
			affPointer();
			break;
		case kbLeft:
			effPointer();
			if (curFg < 15) curFg++; else curFg = 0;
			affPointer();
			break;
		case kbRight:
			effPointer();
			if (curFg > 0) curFg--; else curFg = 15;
			affPointer();
			break;
		case kbIns:
		case kbEnter:
			event.what = evBroadcast;
			event.message.infoInt = (curBg*16+curFg);
			event.message.command = 1548;
			putEvent(event);
			clearEvent(event);
			return;
		case kbEsc:
			event.what = evCommand;
			event.message.command = cmClose;
			event.message.infoPtr = this->owner;
			putEvent(event);
			clearEvent(event);
			return;

		default:
			return;
		}
		event.what = evBroadcast;
		event.message.command = cmColorTableCmdBase;
		putEvent(event);
		clearEvent(event);
		}
	}
}


//
// TCReport functions
//

#pragma warn -ias
const char * const TCReport::name = "TCReport";
#pragma warn .ias


void TCReport::write( opstream& os )
{
	TView::write( os );
}


void *TCReport::read( ipstream& is )
{
	TView::read( is );
	return this;
}


TStreamable *TCReport::build()
{
	return new TCReport( streamableInit );
}


TStreamableClass RCReport( TCReport::name,
			  TCReport::build,
			  __DELTA(TCReport)
			);


TCReport::TCReport(TRect& r) :
 TView(r)
{
sprintf(colorCode, "%02X", curFg+16*curBg);
}


void TCReport::draw()
{
	TDrawBuffer buf;
	char        color = getColor(6);
	char        str[80];
	ostrstream  statusStr( str, sizeof str );

	statusStr
	  << "  Code: @X" << setw(2) << colorCode;

	buf.moveStr(0, str, color);
	buf.moveChar(12, ' ', color, 2);
	buf.moveStr(14, "Sample string using the selected color", curFg+16*curBg);
	buf.moveChar(52, ' ', color, 2);
	writeLine(0, 0, 54, 1, buf);
}


void TCReport::handleEvent(TEvent& event)
{
	TView::handleEvent(event);
	if (event.what == evBroadcast)
	{
	if (event.message.command == cmColorTableCmdBase)
		{
		sprintf(colorCode, "%02X", curFg+16*curBg);
		drawView();
		}
	}
}


//
// TColorChart functions
//

#pragma warn -ias
const char * const TColorChart::name = "TColorChart";
#pragma warn .ias


void TColorChart::write( opstream& os )
{
    TWindow::write( os );
}


void *TColorChart::read( ipstream& is )
{
    TWindow::read( is );
    return this;
}


TStreamable *TColorChart::build()
{
	return new TColorChart( streamableInit );
}


TStreamableClass RColorChart( TColorChart::name,
				  TColorChart::build,
				  __DELTA(TColorChart)
			    );


TColorChart::TColorChart() :
	TWindow(TRect(0, 0, 56, 23), "@Xnn Color Table", wnNoNumber),
	TWindowInit( &TColorChart::initFrame )
{
	TView *control;

	flags &= ~(wfGrow | wfZoom);
	palette = wpCyanWindow;

	TRect r = getExtent();
	r.grow(-1, -1);
	r.a.y = r.b.y - 1;
	control = new TCReport( r );
	control->options |= ofFramed;
	control->eventMask |= evBroadcast;
	insert(control);

	r = getExtent();
	r.grow(-1, -1);
	r.b.y = r.b.y - 2;
	control = new TCTable( r );
	control->options |= ofFramed;
//	control->blockCursor();
	insert(control);

	control->select();
}
