/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*
                           + Project Frontier +

 PPL Runtime

 PPL BINARY RPN GRAMMAR FILE 

*/

%{
#include "c:\bc\lang\ppl_type.h"
#include "c:\bc\lang\ppl.h"
#include "c:\bc\lang\funcs.h"
#include "c:\bc\lang\arrays.h"
#define YYSTYPE pplvar*
#include <math.h>
%}

%token F_ADD F_SUB F_POW F_MUL F_DIV F_MOD
%token F_UNEGATIVE F_UPOSITIVE F_UNOT
%token F_CMP_EQU F_CMP_NEQ F_CMP_BEL F_CMP_BOE F_CMP_ABO F_CMP_AOE
%token F_BOOL_AND F_BOOL_OR

/* PPL Functions */
%token F_LEN F_LOWER F_UPPER F_MID F_LEFT F_RIGHT F_SPACE F_FERR F_CHR F_ASC
%token F_INSTR F_ABORT F_LTRIM F_RTRIM F_TRIM F_RANDOM F_DATE F_TIME F_U_NAME
%token F_U_LDATE F_U_LTIME F_U_LDIR F_U_LOGONS F_U_FUL F_U_FDL F_U_BDLDAY
%token F_U_TIMEON F_U_BDL F_U_BUL F_YEAR F_MONTH F_DAY F_DOW F_HOUR F_MIN
%token F_SEC F_TIMEAP F_VER F_NOCHAR F_YESCHAR F_STRIPATX F_REPLACE F_STRIP
%token F_INKEY F_STRING F_MASK_PWD F_MASK_ALPHA F_MASK_NUM F_MASK_ALNUM
%token F_MASK_FILE F_MASK_PATH F_MASK_ASCII F_CURCONF F_PCBDAT F_PPEPATH
%token F_VALDATE F_VALTIME F_U_MSGRD F_U_MSGWR F_PCBNODE F_READLINE
%token F_SYSOPSEC F_ONLOCAL F_UN_STAT F_UN_NAME F_UN_CITY F_UN_OPER F_CURSEC
%token F_GETTOKEN F_MINLEFT F_MINON F_GETENV F_CALLID F_REGAL F_REGAH F_REGBL
%token F_REGBH F_REGCL F_REGCH F_REGDL F_REGDH F_REGAX F_REGBX F_REGCX
%token F_REGDX F_REGSI F_REGDI F_REGF F_REGCF F_REGDS F_REGES F_B2W F_PEEK
%token F_PEEKW F_MKADDR F_EXIST F_I2S F_S2I F_CARRIER F_TOKENSTR F_CDON
%token F_LANGEXT F_ANSION F_VALCC F_FMTCC F_CCTYPE F_GETX F_GETY F_AND F_OR
%token F_XOR F_NOT F_U_PWDHIST F_U_PWDLC F_U_PWDTC F_U_STAT F_DEFCOLOR F_ABS
%token F_GRAFMODE F_PSA F_FILEINF F_PPENAME F_MKDATE F_CURCOLOR F_KINKEY
%token F_MINKEY F_MAXNODE F_SLPATH F_HELPPATH F_TEMPPATH F_MODEM F_LOGGEDON
%token F_CALLNUM F_MGETBYTE F_TOKCOUNT F_U_RECNUM F_U_INCONF F_PEEKDW
%token F_DBGLEVEL F_SCRTEXT F_SHOWSTAT F_PAGESTAT F_REPLACESTR F_STRIPSTR
%token F_TOBIGSTR F_TOBOOLEAN F_TOBYTE F_TODATE F_TODOUBLE F_TOEDATE
%token F_TOINTEGER F_TOMONEY F_TOREAL F_TOSHORT F_TOINT F_TOTIME F_TODWORD
%token F_TOWORD F_MIXED F_ALIAS F_CONFREG F_CONFEXP F_CONFSEL F_CONFSYS
%token F_CONFMW F_LPRINTED F_ISNONSTOP F_ERRCORRECT F_CONFALIAS F_USERALIAS
%token F_CURUSER F_U_LMR F_CHATSTAT F_DEFANS F_LASTANS F_MEGANUM F_EVTTIMEADJ
%token F_ISBITSET F_FMTREAL F_FLAGCNT F_KBDBUFSIZE F_PPLBUFSIZE F_KBDFILUSED
%token F_LOMSGNUM F_HIMSGNUM F_DRIVESPACE F_OUTBYTES F_HICONFNUM F_INBYTES
%token F_CRC32 F_PCBMAC F_ACTMSGNUM F_STACKLEFT F_STACKERR F_DGETALIAS F_DBOF
%token F_DCHANGED F_DDECIMALS F_DDELETED F_DEOF F_DERR F_DFIELDS F_DLENGTH
%token F_DNAME F_DRECCOUNT F_DRECNO F_DTYPE F_FNEXT F_DNEXT F_TODDATE
%token F_DCLOSEALL F_DOPEN F_DCLOSE F_DSETALIAS F_DPACK F_DLOCKF F_DLOCK
%token F_DLOCKR F_DUNLOCK F_DNOPEN F_DNCLOSE F_DNCLOSEALL F_DNEW F_DADD
%token F_DAPPEND F_DTOP F_DGO F_DBOTTOM F_DSKIP F_DBLANK F_DDELETE F_DRECALL
%token F_DTAG F_DSEEK F_DFBLANK F_DGET F_DPUT F_DFCOPY F_DSELECT F_DCHKSTAT
%token F_PCBACCOUNT F_PCBACCSTAT F_DERRMSG F_ACCOUNT F_SCANMSGHDR F_CHECKRIP
%token F_RIPVER F_QWKLIMITS F_FINDFIRST F_FINDNEXT F_USELMRS F_CONFINFO
%token F_TINKEY F_CWD F_INSTRR F_FDORDAKA F_FDORDORG F_FDORDAREA F_FDOQRD
%token F_GETDRIVE F_SETDRIVE F_BS2I F_BD2I F_I2BS F_I2BD F_FTELL F_OS
%token F_DSCRTEXT F_DGETX F_DGETY F_DUALSCR F_CONFNAME F_SYSTEMPATH
%token F_BETA F_SCREENCLEARED F_CALL F_LASTEXITVALUE F_FREE F_COMINIT
%token F_GETCOMSTAT F_GETUARTTYPE F_GETPROFILE F_FRTDAT F_FILEMATCH
%token F_GETNEXTMSG F_HIMSGNUMC F_LOMSGNUMC F_ROOTPATH F_TOSDATE F_LANGFILE

/* Frontier Functions */
/* none */

%token VAR
%token SEPAR SEPAR2 SEPAR3
%token TABLE_BEGIN TABLE1 TABLE2 TABLE3 LONETABLE
%token FUNC_BEGIN FUNC

%pure_parser

     %% /* Grammar rules and actions follow */

exp_list
    : exp                		{ fppe_pushvar($1);				}
    | exp_list SEPAR exp 		{ fppe_pushvar($3);				}
    ;

exp
    /* Simple Variable 											*/

    : VAR                      /*{ $$ = fppe_pushvar($1);         }*/
    /* Table base 												*/
    | LONETABLE
    /* Function   												*/
    | FUNC_BEGIN FUNC          { $$ = fppe_execFunc($2);        }
    | FUNC_BEGIN exp_list FUNC { $$ = fppe_execFunc($3);        }

    /* Tables                                                   */

    | TABLE_BEGIN exp TABLE1            { $$ = fppe_copytable1var($2, $3); }
    | TABLE_BEGIN exp SEPAR2 exp TABLE2 { $$ = fppe_copytable2var($2, $4, $5); }
    | TABLE_BEGIN exp SEPAR2 exp SEPAR2 exp TABLE3 { $$ = fppe_copytable3var($2, $4, $6, $7); }


    /* Mathematic Operator 										*/

    | exp exp F_ADD             { $$ = ppl_F_ADD(&$1);          }
    | exp exp F_SUB  			{ $$ = ppl_F_SUB(&$1);     		}
    | exp exp F_MUL  			{ $$ = ppl_F_MUL(&$1);     		}
    | exp exp F_DIV  			{ $$ = ppl_F_DIV(&$1);     		}
    | exp exp F_POW  			{ $$ = ppl_F_POW(&$1);     		}
    | exp exp F_MOD  			{ $$ = ppl_F_MOD(&$1);     		}

    /* Unary operators    										*/

    | exp F_UNEGATIVE   		{ $$ = ppl_F_UNEGATIVE(&$1);	}
    | exp F_UPOSITIVE   		{ $$ = ppl_F_UPOSITIVE(&$1);	}
    | exp F_UNOT        		{ $$ = ppl_F_UNOT(&$1);     	}

    /* Comparison operators    									*/

	| exp exp F_CMP_EQU 		{ $$ = ppl_F_CMP_EQU(&$1);     	}
	| exp exp F_CMP_NEQ 		{ $$ = ppl_F_CMP_NEQ(&$1);     	}
	| exp exp F_CMP_BEL 		{ $$ = ppl_F_CMP_BEL(&$1);     	}
	| exp exp F_CMP_BOE 		{ $$ = ppl_F_CMP_BOE(&$1);     	}
	| exp exp F_CMP_ABO 		{ $$ = ppl_F_CMP_ABO(&$1);     	}
	| exp exp F_CMP_AOE 		{ $$ = ppl_F_CMP_AOE(&$1);     	}

    /* Boolean Operators										*/

	| exp exp F_BOOL_AND        { $$ = ppl_F_BOOL_AND(&$1);  	}
	| exp exp F_BOOL_OR         { $$ = ppl_F_BOOL_OR(&$1);   	}

	/* PPL Functions 											*/

    | exp F_LEN                 { $$ = ppl_F_LEN(&$1);     	}
	| exp F_LOWER               { $$ = ppl_F_LOWER(&$1);     	}
	| exp F_UPPER               { $$ = ppl_F_UPPER(&$1);     	}
	| exp exp exp F_MID         { $$ = ppl_F_MID(&$1);     	}
	| exp exp F_LEFT            { $$ = ppl_F_LEFT(&$1);     	}
	| exp exp F_RIGHT           { $$ = ppl_F_RIGHT(&$1);     	}
	| exp F_SPACE               { $$ = ppl_F_SPACE(&$1);     	}
	| exp F_FERR                { $$ = ppl_F_FERR(&$1);     	}
	| exp F_CHR                 { $$ = ppl_F_CHR(&$1);     	}
	| exp F_ASC                 { $$ = ppl_F_ASC(&$1);     	}
    | exp exp F_INSTR           { $$ = ppl_F_INSTR(&$1);     	}
	| F_ABORT                   { $$ = ppl_F_ABORT(&$1);     	}
	| exp exp F_LTRIM           { $$ = ppl_F_LTRIM(&$1);     	}
	| exp exp F_RTRIM           { $$ = ppl_F_RTRIM(&$1);     	}
	| exp exp F_TRIM            { $$ = ppl_F_TRIM(&$1);     	}
	| exp F_RANDOM              { $$ = ppl_F_RANDOM(&$1);     	}
	| F_DATE                    { $$ = ppl_F_DATE(&$1);     	}
	| F_TIME                    { $$ = ppl_F_TIME(&$1);     	}
	| F_U_NAME                  { $$ = ppl_F_U_NAME(&$1);     	}
    | F_U_LDATE                 { $$ = ppl_F_U_LDATE(&$1);     	}
	| F_U_LTIME                 { $$ = ppl_F_U_LTIME(&$1);     	}
	| F_U_LDIR                  { $$ = ppl_F_U_LDIR(&$1);     	}
	| F_U_LOGONS                { $$ = ppl_F_U_LOGONS(&$1);     	}
	| F_U_FUL                   { $$ = ppl_F_U_FUL(&$1);     	}
	| F_U_FDL                   { $$ = ppl_F_U_FDL(&$1);     	}
	| F_U_BDLDAY                { $$ = ppl_F_U_BDLDAY(&$1);     	}
    | F_U_TIMEON                { $$ = ppl_F_U_TIMEON(&$1);     	}
	| F_U_BDL                   { $$ = ppl_F_U_BDL(&$1);     	}
	| F_U_BUL                   { $$ = ppl_F_U_BUL(&$1);     	}
	| exp F_YEAR                { $$ = ppl_F_YEAR(&$1);     	}
	| exp F_MONTH               { $$ = ppl_F_MONTH(&$1);     	}
	| exp F_DAY                 { $$ = ppl_F_DAY(&$1);     	}
	| exp F_DOW                 { $$ = ppl_F_DOW(&$1);     	}
	| exp F_HOUR                { $$ = ppl_F_HOUR(&$1);     	}
	| exp F_MIN                 { $$ = ppl_F_MIN(&$1);     	}
    | exp F_SEC                 { $$ = ppl_F_SEC(&$1);     	}
	| exp F_TIMEAP              { $$ = ppl_F_TIMEAP(&$1);     	}
	| F_VER                     { $$ = ppl_F_VER(&$1);     	}
	| F_NOCHAR                  { $$ = ppl_F_NOCHAR(&$1);     	}
	| F_YESCHAR                 { $$ = ppl_F_YESCHAR(&$1);     	}
	| exp F_STRIPATX            { $$ = ppl_F_STRIPATX(&$1);     	}
	| exp exp exp F_REPLACE     { $$ = ppl_F_REPLACE(&$1);     	}
	| exp exp F_STRIP           { $$ = ppl_F_STRIP(&$1);     	}
    | F_INKEY                   { $$ = ppl_F_INKEY(&$1);     	}
	| exp F_STRING              { $$ = ppl_F_STRING(&$1);     	}
	| F_MASK_PWD                { $$ = ppl_F_MASK_PWD(&$1);     	}
	| F_MASK_ALPHA              { $$ = ppl_F_MASK_ALPHA(&$1);     	}
	| F_MASK_NUM                { $$ = ppl_F_MASK_NUM(&$1);     	}
	| F_MASK_ALNUM              { $$ = ppl_F_MASK_ALNUM(&$1);     	}
	| F_MASK_FILE               { $$ = ppl_F_MASK_FILE(&$1);     	}
	| F_MASK_PATH               { $$ = ppl_F_MASK_PATH(&$1);     	}
	| F_MASK_ASCII              { $$ = ppl_F_MASK_ASCII(&$1);     	}
	| F_CURCONF                 { $$ = ppl_F_CURCONF(&$1);     	}
	| F_PCBDAT                  { $$ = ppl_F_PCBDAT(&$1);     	}
	| F_PPEPATH                 { $$ = ppl_F_PPEPATH(&$1);     	}
	| exp F_VALDATE             { $$ = ppl_F_VALDATE(&$1);     	}
	| exp F_VALTIME             { $$ = ppl_F_VALTIME(&$1);     	}
	| F_U_MSGRD                 { $$ = ppl_F_U_MSGRD(&$1);     	}
	| F_U_MSGWR                 { $$ = ppl_F_U_MSGWR(&$1);     	}
	| F_PCBNODE                 { $$ = ppl_F_PCBNODE(&$1);     	}
	| exp exp F_READLINE        { $$ = ppl_F_READLINE(&$1);     	}
	| F_SYSOPSEC                { $$ = ppl_F_SYSOPSEC(&$1);     	}
	| F_ONLOCAL                 { $$ = ppl_F_ONLOCAL(&$1);     	}
	| F_UN_STAT                 { $$ = ppl_F_UN_STAT(&$1);     	}
	| F_UN_NAME                 { $$ = ppl_F_UN_NAME(&$1);     	}
	| F_UN_CITY                 { $$ = ppl_F_UN_CITY(&$1);     	}
	| F_UN_OPER                 { $$ = ppl_F_UN_OPER(&$1);     	}
	| F_CURSEC                  { $$ = ppl_F_CURSEC(&$1);     	}
	| F_GETTOKEN                { $$ = ppl_F_GETTOKEN(&$1);     	}
	| F_MINLEFT                 { $$ = ppl_F_MINLEFT(&$1);     	}
	| F_MINON                   { $$ = ppl_F_MINON(&$1);     	}
	| exp F_GETENV              { $$ = ppl_F_GETENV(&$1);     	}
	| F_CALLID                  { $$ = ppl_F_CALLID(&$1);     	}
	| F_REGAL                   { $$ = ppl_F_REGAL(&$1);     	}
	| F_REGAH                   { $$ = ppl_F_REGAH(&$1);     	}
	| F_REGBL                   { $$ = ppl_F_REGBL(&$1);     	}
    | F_REGBH                   { $$ = ppl_F_REGBH(&$1);     	}
	| F_REGCL                   { $$ = ppl_F_REGCL(&$1);     	}
	| F_REGCH                   { $$ = ppl_F_REGCH(&$1);     	}
	| F_REGDL                   { $$ = ppl_F_REGDL(&$1);     	}
	| F_REGDH                   { $$ = ppl_F_REGDH(&$1);     	}
	| F_REGAX                   { $$ = ppl_F_REGAX(&$1);     	}
	| F_REGBX                   { $$ = ppl_F_REGBX(&$1);     	}
	| F_REGCX                   { $$ = ppl_F_REGCX(&$1);     	}
    | F_REGDX                   { $$ = ppl_F_REGDX(&$1);     	}
	| F_REGSI                   { $$ = ppl_F_REGSI(&$1);     	}
	| F_REGDI                   { $$ = ppl_F_REGDI(&$1);     	}
	| F_REGF                    { $$ = ppl_F_REGF(&$1);     	}
	| F_REGCF                   { $$ = ppl_F_REGCF(&$1);     	}
	| F_REGDS                   { $$ = ppl_F_REGDS(&$1);     	}
	| F_REGES                   { $$ = ppl_F_REGES(&$1);     	}
	| exp exp F_B2W             { $$ = ppl_F_B2W(&$1);     	}
	| exp F_PEEK                { $$ = ppl_F_PEEK(&$1);     	}
    | exp F_PEEKW               { $$ = ppl_F_PEEKW(&$1);     	}
	| exp exp F_MKADDR          { $$ = ppl_F_MKADDR(&$1);     	}
	| exp F_EXIST               { $$ = ppl_F_EXIST(&$1);     	}
	| exp exp F_I2S             { $$ = ppl_F_I2S(&$1);     	}
	| exp exp F_S2I             { $$ = ppl_F_S2I(&$1);     	}
	| F_CARRIER                 { $$ = ppl_F_CARRIER(&$1);     	}
	| F_TOKENSTR                { $$ = ppl_F_TOKENSTR(&$1);     	}
	| F_CDON                    { $$ = ppl_F_CDON(&$1);         }
    | F_LANGEXT                 { $$ = ppl_F_LANGEXT(&$1);         }
	| F_ANSION                  { $$ = ppl_F_ANSION(&$1);         }
	| exp F_VALCC               { $$ = ppl_F_VALCC(&$1);         }
	| exp F_FMTCC               { $$ = ppl_F_FMTCC(&$1);         }
	| exp F_CCTYPE              { $$ = ppl_F_CCTYPE(&$1);         }
	| F_GETX                    { $$ = ppl_F_GETX(&$1);         }
	| F_GETY                    { $$ = ppl_F_GETY(&$1);         }
	| F_DGETX                   { $$ = ppl_F_DGETX(&$1);         }
	| F_DGETY                   { $$ = ppl_F_DGETY(&$1);         }
	| exp exp F_AND             { $$ = ppl_F_AND(&$1);         }
	| exp exp F_OR              { $$ = ppl_F_OR(&$1);         }
    | exp exp F_XOR             { $$ = ppl_F_XOR(&$1);         }
	| exp F_NOT                 { $$ = ppl_F_NOT(&$1);         }
	| exp F_U_PWDHIST           { $$ = ppl_F_U_PWDHIST(&$1);         }
	| F_U_PWDLC                 { $$ = ppl_F_U_PWDLC(&$1);         }
	| F_U_PWDTC                 { $$ = ppl_F_U_PWDTC(&$1);         }
	| exp F_U_STAT              { $$ = ppl_F_U_STAT(&$1);         }
	| F_DEFCOLOR                { $$ = ppl_F_DEFCOLOR(&$1);         }
	| exp F_ABS                 { $$ = ppl_F_ABS(&$1);         }
	| F_GRAFMODE                { $$ = ppl_F_GRAFMODE(&$1);         }
	| exp F_PSA                 { $$ = ppl_F_PSA(&$1);         }
	| exp exp F_FILEINF         { $$ = ppl_F_FILEINF(&$1);         }
	| F_PPENAME                 { $$ = ppl_F_PPENAME(&$1);         }
	| exp exp exp F_MKDATE      { $$ = ppl_F_MKDATE(&$1);         }
	| F_CURCOLOR                { $$ = ppl_F_CURCOLOR(&$1);         }
	| F_KINKEY                  { $$ = ppl_F_KINKEY(&$1);         }
	| F_MINKEY                  { $$ = ppl_F_MINKEY(&$1);         }
	| F_MAXNODE                 { $$ = ppl_F_MAXNODE(&$1);         }
	| F_SLPATH                  { $$ = ppl_F_SLPATH(&$1);         }
	| F_HELPPATH                { $$ = ppl_F_HELPPATH(&$1);         }
	| F_TEMPPATH                { $$ = ppl_F_TEMPPATH(&$1);         }
	| F_MODEM                   { $$ = ppl_F_MODEM(&$1);         }
	| F_LOGGEDON                { $$ = ppl_F_LOGGEDON(&$1);         }
	| F_CALLNUM                 { $$ = ppl_F_CALLNUM(&$1);         }
	| F_MGETBYTE                { $$ = ppl_F_MGETBYTE(&$1);         }
	| F_TOKCOUNT                { $$ = ppl_F_TOKCOUNT(&$1);         }
	| exp F_U_RECNUM            { $$ = ppl_F_U_RECNUM(&$1);         }
	| exp exp F_U_INCONF        { $$ = ppl_F_U_INCONF(&$1);         }
	| exp F_PEEKDW              { $$ = ppl_F_PEEKDW(&$1);         }
	| exp F_DBGLEVEL            { $$ = ppl_F_DBGLEVEL(&$1);         }
	| exp exp exp exp F_SCRTEXT { $$ = ppl_F_SCRTEXT(&$1);         }
	| exp exp exp exp F_DSCRTEXT{ $$ = ppl_F_DSCRTEXT(&$1);         }
	| F_SHOWSTAT                { $$ = ppl_F_SHOWSTAT(&$1);         }
	| F_PAGESTAT                { $$ = ppl_F_PAGESTAT(&$1);         }
	| exp exp exp F_REPLACESTR  { $$ = ppl_F_REPLACESTR(&$1);         }
	| exp exp F_STRIPSTR        { $$ = ppl_F_STRIPSTR(&$1);         }
	| exp F_TOBIGSTR            { $$ = ppl_F_TOBIGSTR(&$1);         }
	| exp F_TOBOOLEAN           { $$ = ppl_F_TOBOOLEAN(&$1);         }
	| exp F_TOBYTE              { $$ = ppl_F_TOBYTE(&$1);         }
	| exp F_TODATE              { $$ = ppl_F_TODATE(&$1);         }
	| exp F_TODOUBLE            { $$ = ppl_F_TODOUBLE(&$1);         }
	| exp F_TOEDATE             { $$ = ppl_F_TOEDATE(&$1);         }
	| exp F_TOINTEGER           { $$ = ppl_F_TOINTEGER(&$1);         }
	| exp F_TOMONEY             { $$ = ppl_F_TOMONEY(&$1);         }
	| exp F_TOREAL              { $$ = ppl_F_TOREAL(&$1);         }
	| exp F_TOSHORT             { $$ = ppl_F_TOSHORT(&$1);         }
	| exp F_TOINT               { $$ = ppl_F_TOINT(&$1);         }
	| exp F_TOTIME              { $$ = ppl_F_TOTIME(&$1);         }
	| exp F_TODWORD             { $$ = ppl_F_TODWORD(&$1);         }
	| exp F_TOWORD              { $$ = ppl_F_TOWORD(&$1);         }
	| exp F_MIXED               { $$ = ppl_F_MIXED(&$1);         }
	| F_ALIAS                   { $$ = ppl_F_ALIAS(&$1);         }
	| exp F_CONFREG             { $$ = ppl_F_CONFREG(&$1);         }
	| exp F_CONFEXP             { $$ = ppl_F_CONFEXP(&$1);         }
	| exp F_CONFSEL             { $$ = ppl_F_CONFSEL(&$1);         }
	| exp F_CONFSYS             { $$ = ppl_F_CONFSYS(&$1);         }
	| exp F_CONFMW              { $$ = ppl_F_CONFMW(&$1);         }
	| F_LPRINTED                { $$ = ppl_F_LPRINTED(&$1);         }
	| F_ISNONSTOP               { $$ = ppl_F_ISNONSTOP(&$1);         }
	| F_ERRCORRECT              { $$ = ppl_F_ERRCORRECT(&$1);         }
	| F_CONFALIAS               { $$ = ppl_F_CONFALIAS(&$1);         }
	| F_USERALIAS               { $$ = ppl_F_USERALIAS(&$1);         }
	| F_CURUSER                 { $$ = ppl_F_CURUSER(&$1);         }
	| exp F_U_LMR               { $$ = ppl_F_U_LMR(&$1);         }
	| F_CHATSTAT                { $$ = ppl_F_CHATSTAT(&$1);         }
	| F_DEFANS                  { $$ = ppl_F_DEFANS(&$1);         }
	| F_LASTANS                 { $$ = ppl_F_LASTANS(&$1);         }
	| exp F_MEGANUM             { $$ = ppl_F_MEGANUM(&$1);         }
	| F_EVTTIMEADJ              { $$ = ppl_F_EVTTIMEADJ(&$1);         }
    | exp exp F_ISBITSET        { $$ = ppl_F_ISBITSET(&$1);         }
	| exp exp exp F_FMTREAL     { $$ = ppl_F_FMTREAL(&$1);         }
	| F_FLAGCNT                 { $$ = ppl_F_FLAGCNT(&$1);         }
	| F_KBDBUFSIZE              { $$ = ppl_F_KBDBUFSIZE(&$1);         }
	| F_PPLBUFSIZE              { $$ = ppl_F_PPLBUFSIZE(&$1);         }
	| F_KBDFILUSED              { $$ = ppl_F_KBDFILUSED(&$1);         }
    | F_LOMSGNUM                { $$ = ppl_F_LOMSGNUM(&$1);         }
	| F_HIMSGNUM                { $$ = ppl_F_HIMSGNUM(&$1);         }
	| exp F_DRIVESPACE          { $$ = ppl_F_DRIVESPACE(&$1);         }
	| F_OUTBYTES                { $$ = ppl_F_OUTBYTES(&$1);         }
	| F_HICONFNUM               { $$ = ppl_F_HICONFNUM(&$1);         }
	| F_INBYTES                 { $$ = ppl_F_INBYTES(&$1);         }
	| exp exp F_CRC32           { $$ = ppl_F_CRC32(&$1);         }
	| exp F_PCBMAC              { $$ = ppl_F_PCBMAC(&$1);         }
	| F_ACTMSGNUM               { $$ = ppl_F_ACTMSGNUM(&$1);         }
	| F_STACKLEFT               { $$ = ppl_F_STACKLEFT(&$1);         }
	| F_STACKERR                { $$ = ppl_F_STACKERR(&$1);         }
	| exp F_DGETALIAS           { $$ = ppl_F_DGETALIAS(&$1);         }
	| exp F_DBOF                { $$ = ppl_F_DBOF(&$1);         }
    | exp F_DCHANGED            { $$ = ppl_F_DCHANGED(&$1);         }
	| exp exp F_DDECIMALS       { $$ = ppl_F_DDECIMALS(&$1);         }
	| exp F_DDELETED            { $$ = ppl_F_DDELETED(&$1);         }
	| exp F_DEOF                { $$ = ppl_F_DEOF(&$1);         }
	| exp F_DERR                { $$ = ppl_F_DERR(&$1);         }
	| exp F_DFIELDS             { $$ = ppl_F_DFIELDS(&$1);         }
	| exp exp F_DLENGTH         { $$ = ppl_F_DLENGTH(&$1);         }
	| exp exp F_DNAME           { $$ = ppl_F_DNAME(&$1);         }
	| exp F_DRECCOUNT           { $$ = ppl_F_DRECCOUNT(&$1);         }
	| exp F_DRECNO              { $$ = ppl_F_DRECNO(&$1);         }
	| exp exp F_DTYPE           { $$ = ppl_F_DTYPE(&$1);         }
	| F_FNEXT                   { $$ = ppl_F_FNEXT(&$1);         }
	| F_DNEXT                   { $$ = ppl_F_DNEXT(&$1);         }
	| exp F_TODDATE             { $$ = ppl_F_TODDATE(&$1);         }
	| F_DCLOSEALL               { $$ = ppl_F_DCLOSEALL(&$1);         }
    | exp exp exp F_DOPEN       { $$ = ppl_F_DOPEN(&$1);         }
	| exp F_DCLOSE              { $$ = ppl_F_DCLOSE(&$1);         }
	| exp exp F_DSETALIAS       { $$ = ppl_F_DSETALIAS(&$1);         }
	| exp F_DPACK               { $$ = ppl_F_DPACK(&$1);         }
	| exp F_DLOCKF              { $$ = ppl_F_DLOCKF(&$1);         }
	| exp F_DLOCK               { $$ = ppl_F_DLOCK(&$1);         }
    | exp exp F_DLOCKR          { $$ = ppl_F_DLOCKR(&$1);         }
	| exp F_DUNLOCK             { $$ = ppl_F_DUNLOCK(&$1);         }
	| exp exp F_DNOPEN          { $$ = ppl_F_DNOPEN(&$1);         }
	| exp exp F_DNCLOSE         { $$ = ppl_F_DNCLOSE(&$1);         }
	| exp F_DNCLOSEALL          { $$ = ppl_F_DNCLOSEALL(&$1);         }
	| exp F_DNEW                { $$ = ppl_F_DNEW(&$1);         }
	| exp F_DADD                { $$ = ppl_F_DADD(&$1);         }
	| exp F_DAPPEND             { $$ = ppl_F_DAPPEND(&$1);         }
	| exp F_DTOP                { $$ = ppl_F_DTOP(&$1);         }
	| exp exp F_DGO             { $$ = ppl_F_DGO(&$1);         }
	| exp F_DBOTTOM             { $$ = ppl_F_DBOTTOM(&$1);         }
	| exp exp F_DSKIP           { $$ = ppl_F_DSKIP(&$1);         }
	| exp F_DBLANK              { $$ = ppl_F_DBLANK(&$1);         }
	| exp F_DDELETE             { $$ = ppl_F_DDELETE(&$1);         }
	| exp F_DRECALL             { $$ = ppl_F_DRECALL(&$1);         }
	| exp exp F_DTAG            { $$ = ppl_F_DTAG(&$1);         }
	| exp exp F_DSEEK           { $$ = ppl_F_DSEEK(&$1);         }
	| exp exp F_DFBLANK         { $$ = ppl_F_DFBLANK(&$1);         }
	| exp exp F_DGET            { $$ = ppl_F_DGET(&$1);         }
	| exp exp exp F_DPUT        { $$ = ppl_F_DPUT(&$1);         }
	| exp exp exp exp F_DFCOPY  { $$ = ppl_F_DFCOPY(&$1);         }
	| exp F_DSELECT             { $$ = ppl_F_DSELECT(&$1);         }
	| exp F_DCHKSTAT            { $$ = ppl_F_DCHKSTAT(&$1);         }
	| exp F_PCBACCOUNT          { $$ = ppl_F_PCBACCOUNT(&$1);         }
	| exp F_PCBACCSTAT          { $$ = ppl_F_PCBACCSTAT(&$1);         }
	| exp F_DERRMSG             { $$ = ppl_F_DERRMSG(&$1);         }
	| exp F_ACCOUNT             { $$ = ppl_F_ACCOUNT(&$1);         }
	| exp exp exp exp F_SCANMSGHDR { $$ = ppl_F_SCANMSGHDR(&$1);     	}
	| F_CHECKRIP                { $$ = ppl_F_CHECKRIP(&$1);         }
	| F_RIPVER                  { $$ = ppl_F_RIPVER(&$1);         }
	| exp F_QWKLIMITS           { $$ = ppl_F_QWKLIMITS(&$1);         }
	| exp F_FINDFIRST           { $$ = ppl_F_FINDFIRST(&$1);         }
	| F_FINDNEXT                { $$ = ppl_F_FINDNEXT(&$1);         }
	| F_USELMRS                 { $$ = ppl_F_USELMRS(&$1);         }
	| exp exp F_CONFINFO        { $$ = ppl_F_CONFINFO(&$1);         }
    | exp F_TINKEY              { $$ = ppl_F_TINKEY(&$1);         }
	| F_CWD                     { $$ = ppl_F_CWD(&$1);         }
	| exp exp F_INSTRR          { $$ = ppl_F_INSTRR(&$1);         }
	| exp F_FDORDAKA            { $$ = ppl_F_FDORDAKA(&$1);         }
	| exp F_FDORDORG            { $$ = ppl_F_FDORDORG(&$1);         }
	| exp F_FDORDAREA           { $$ = ppl_F_FDORDAREA(&$1);         }
	| exp exp exp exp exp exp F_FDOQRD { $$ = ppl_F_FDOQRD(&$1); 	}
	| F_GETDRIVE                { $$ = ppl_F_GETDRIVE(&$1);         }
	| exp F_SETDRIVE            { $$ = ppl_F_SETDRIVE(&$1);         }
	| exp F_BS2I                { $$ = ppl_F_BS2I(&$1);         }
	| exp F_BD2I                { $$ = ppl_F_BD2I(&$1);         }
	| exp F_I2BS                { $$ = ppl_F_I2BS(&$1);         }
	| exp F_I2BD                { $$ = ppl_F_I2BD(&$1);         }
	| exp F_FTELL               { $$ = ppl_F_FTELL(&$1);         }
	| F_OS                      { $$ = ppl_F_OS(&$1);         }
	| F_DUALSCR                 { $$ = ppl_F_DUALSCR(&$1);         }
	| exp F_CONFNAME            { $$ = ppl_F_CONFNAME(&$1);       }
	| F_SYSTEMPATH              { $$ = ppl_F_SYSTEMPATH(&$1);       }
	| F_BETA                    { $$ = ppl_F_BETA(&$1);       }
	| F_SCREENCLEARED           { $$ = ppl_F_SCREENCLEARED(&$1);       }
    | exp F_CALL                { $$ = ppl_F_CALL(&$1); }
    | F_LASTEXITVALUE           { $$ = ppl_F_LASTEXITVALUE(&$1); }
    | F_FREE                    { $$ = ppl_F_FREE(&$1); }
    | F_COMINIT                 { $$ = ppl_F_COMINIT(&$1); }
    | F_GETCOMSTAT              { $$ = ppl_F_GETCOMSTAT(&$1); }
    | F_GETUARTTYPE             { $$ = ppl_F_GETUARTTYPE(&$1); }
    | exp exp exp F_GETPROFILE  { $$ = ppl_F_GETPROFILE(&$1); }
    | F_FRTDAT                  { $$ = ppl_F_FRTDAT(&$1); }
    | exp exp F_FILEMATCH       { $$ = ppl_F_FILEMATCH(&$1); }
    | exp exp exp exp exp exp exp exp exp exp exp F_GETNEXTMSG { $$ = ppl_F_GETNEXTMSG(&$1); }
    | exp F_HIMSGNUMC           { $$ = ppl_F_HIMSGNUMC(&$1); }
    | exp F_LOMSGNUMC           { $$ = ppl_F_LOMSGNUMC(&$1); }
    | F_ROOTPATH				{ $$ = ppl_F_ROOTPATH(&$1); }
	| exp F_TOSDATE             { $$ = ppl_F_TOSDATE(&$1);         }
    | F_LANGFILE                { $$ = ppl_F_LANGFILE(&$1);         }
    ;

    %%

