/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

FRONTIER.SYS functions

*/


#include <stdio.h>
#include <share.h>
#include "..\lang\frtsys.h"
#include "..\com\sharing.h"
#include "..\com\pcbdat.h"
#include "..\com\system.h"


void FRTsys_make(void)
{
FILE *fSys;

if ((fSys = fopen_share("FRONTIER.SYS", "wb", SH_DENYRW)) == NULL)
	{
	fppe_runtimeError("Cannot create FRONTIER.SYS");
	return;
    }

fwrite(comPort, 5, 1, fSys);
fwrite(&comBase, 2, 1, fSys);
fwrite(&comIrq, 2, 1, fSys);
fwrite(&errorcorrect, 2, 1, fSys);
fclose(fSys);
}

void FRTsys_read(void)
{
FILE *fSys;

if ((fSys = fopen_share("FRONTIER.SYS", "rb", SH_DENYWR)) == NULL)
	return;

fread(comPort, 5, 1, fSys);
fread(&comBase, 2, 1, fSys);
fread(&comIrq, 2, 1, fSys);
fread(&errorcorrect, 2, 1, fSys);
fclose(fSys);
}


