/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef __TPA_H
#define __TPA_H

#include <stdio.h>

typedef struct {
	FILE *file;
    unsigned int staticSize;
    unsigned int dynamicSize;
    unsigned version;
	} TPArec;

typedef struct {
	char name[25];
    char version[5];
    unsigned int staticSize;
    unsigned int dynamicSize;
    } IDrec;

#ifdef __cplusplus
extern "C" {
#endif

	TPArec *openTPA(char *base);
	void closeTPA(TPArec *tpa);
	void getTPA(TPArec *tpa, void *data, int size, int conf, int dynamic, long u);
	void putTPA(TPArec *tpa, void *data, int size, int conf, int dynamic, long u);
	long getTPAlong(TPArec *tpa, int conf, int dynamic, long u);
	unsigned int getTPAint(TPArec *tpa, int conf, int dynamic, long u);
	void createAllTPANewEntry(long userNumber);
	void createTPANewEntry(char *TPAname, long userNumber);

#ifdef __cplusplus
}
#endif

#endif
