/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef __MSGS_H
#define __MSGS_H

#pragma option -a-

#include <stdio.h>
#include "..\com\mbfieee.h"
#include "..\com\msgs.h"

typedef struct {
  long     offset;
  long     number;
  char     receiver[25];
  char     sender[25];
  char     status;
  unsigned date;
  char     reserved[3];
} indextype;

typedef struct {
  bsreal HiMsg;
  bsreal LoMsg;
  bsreal NActive;
  bsreal NCallers;
  char locked[6];
  char reserved[106];
  } MBHdr;

typedef struct {
	FILE *MsgsFile;
    FILE *IndexFile;
    FILE *OldIndexFile;
    MBHdr Header;
    char *basename;
    } MessageBaseType;

typedef struct {
       char statusFlag;
       bsreal num;
       bsreal refNum;
       char nBlocks;
       char date[8];
       char time[5];
       char to[25];
       bsreal replyDate;
       char replyTime[5];
       char replyStatus;
       char from[25];
       char subject[25];
       char password[12];
       unsigned char activeStatus;
       char echoStatus;
       char reserved1[4];
       char extendedHdrFlags;
       char reserved2;
	} MsgHdr;

#ifdef __cplusplus
extern "C" {
#endif

	void openMessageBase(MessageBaseType *mb);
	void readHeader(MessageBaseType *mb, long number, MsgHdr *msgHeader);
	void writeHeader(MessageBaseType *mb, long number, MsgHdr *msgHeader);
	int checkOpenMessageBase(MessageBaseType *mb);
	void lockMsgBase(MessageBaseType *mb);
	void unlockMsgBase(MessageBaseType *mb);
	void initMessageBase(MessageBaseType *mb, char *basename);
	void closeMessageBase(MessageBaseType *mb);
	void insertMessage(int conf, char *filename);
	void retrieveMessage(int conf, long msg, char *filename);
	void setRead(int conf, long msg, int reply);
	void setUnread(int conf, long msg);
	void setKillHeaderStatus(MessageBaseType *mb, long number, int bool);
	void setKillMsgStatus(long conf, long msgNum, int bool);
	void readMsgBaseHeader(MessageBaseType *mb);
	void writeMsgBaseHeader(MessageBaseType *mb);
	long getNextMsg(int conf, long start, int inc, char *from, char *fromalias, char *to, char *toalias, char *subject, char *text, long fromdate, int seeall);
	void checkSync(MessageBaseType *mb);

#ifdef __cplusplus
}
#endif

	extern char messageFields[10][19];

#endif
