#define BYTE unsigned char
#define _interrupt interrupt
#define _far far
#define IN_PORT(port)           inportb(port)
#define IN_PORTW(port)          inport(port)
#define OUT_PORT(port, val)     outportb(port, val)
#define OUT_PORTW(port, val)    outport(port, val)

#define KEYPORT        0x60        /* keyboard scan code port       */
#define keyport()      IN_PORT(KEYPORT)

#define shift() 		(keys[0x36] || keys[0x2A])
#define ctrl() 			(keys[0x1D] || ekeys[0x1D])
#define alt() 			(keys[0x38] || ekeys[0x38])
#define picEdge()       outportb(0x20, 0x20)

#ifdef __cplusplus
extern "C" {
#endif

	void keyboardisr(void);
	void remkeyboardisr(void);
	void interrupt newkbisr(void);
	void interrupt newbreakisr(void);
	int keyspressed(void);           /* returns number of keys being held down */

	extern volatile char keys[128];            // array of key states
	extern volatile char ekeys[128];           // array of AT key states
    extern volatile int keyPressed;
	extern volatile char k;
	extern volatile char ek;
	extern volatile char kf;

#ifdef __cplusplus
}
#endif
