;
;
; Filename     : vars2.inc
; Included from: 3D2.ASM
; Description  : Defined Variables for 3D2.ASM
;
; Written by: John McCarthy
;             1316 Redwood Lane
;             Pickering, Ontario.
;             Canada, Earth, Milky Way (for those out-of-towners)
;             L1X 1C5
;
; Internet/Usenet:  BRIAN.MCCARTHY@CANREM.COM
;         Fidonet:  Brian McCarthy 1:229/15
;   RIME/Relaynet: ->CRS
;
; Home phone, (905) 831-1944, don't call at 2 am eh!
;
; John Mccarthy would really love to work for a company programming Robots
; or doing some high intensive CPU work.  Hint. Hint.
;
; Send me your protected mode source code!
; Send me your Objects!
; But most of all, Send me a postcard!!!!
;
;

           align 16

; table of current limitations/restraints - to be used as reference by  user
; at run-time to determine if object code has been assembled with ample room
; for data/variables/point/surfaces etc...

asm_version        dw 30h
asm_maxpoints      dw maxpoints
asm_maxsurfaces    dw maxsurfaces
asm_maxpolys       dw maxpolys
asm_maxobjects     dw maxobjects
asm_number_spaces  dw number_of_spaces
asm_xsize          dw xmax-xmin
asm_ysize          dw ymax-ymin
asm_usez           dw usez
asm_useborders     dw useborders
asm_use_half_stars dw use_half_stars
asm_cameraobject   dw cameraobject
asm_xmode          dw xmode
asm_ratiox         dw ratiox
asm_ratioy         dw ratioy
asm_xactual        dw xactual
asm_yactual        dw yactual
asm_pages          dw pages
asm_shapes         dw numberofshapes
asm_bitmaps        dw numberofbitmaps
asm_xpals          dw numberofpals

           align 16

objbase    dd numberofshapes dup (0)    ; memory locations of shapes (offsets)
bitbase    dd numberofbitmaps dup (0)   ; memory locations of bitmaps
bitx       dd numberofbitmaps dup (0)   ; x base size of bitmaps (for 3d)
bity       dd numberofbitmaps dup (0)   ; y base size of bitmaps
xreftable  dd numberofpals dup (o nullpalette) ; offsets to palette cross referance tables
stonetbl   dd numberofstones dup (0)    ; offsets to stones textures

x1         dw ?                     ; points for line draw
y1         dw ?
x2         dw ?
y2         dw ?
rise       dw ?                     ; counter for draw loop
xp         dd maxpoints dup (?)     ; points breakdown, after rotated, 2d,
yp         dd maxpoints dup (?)     ; x,y points after 3d, are actual location.
zp         dd maxpoints dup (?)     ; z useless, only good during sort of sides
sides      dw maxsurfaces*maxpolys dup (?) ; visible sides only here (clockwize)
order      dd maxsurfaces dup (?)   ; what order to draw surfaces in.
zeds       dd maxsurfaces dup (?)   ; z values of first point in side, for sort
surfcolors dw maxsurfaces dup (?)   ; colours for those sides, high and low
colors12   dd 0                     ; colours for sides 1&2
textures   dw maxsurfaces dup (?)   ; commands/textures for sides
texture12  dd 0                     ; textures for sides 1&2
command    dd 0                     ; current command in load_surfaces loop
showing    dd 0                     ; how many visible sides (total)
pointindex dd 0                     ; indexer to points, xs[],ys[],zs[]
lindex     dd ?                     ; last indexer to points,
offsides   dd offset sides          ; gets inc'd when object plotted
numsides   dd ?                     ; number of sides total, gets trashed
numpoints  dd ?                     ; number of points, gets trashed
whichside  dd ?                     ; which side am i doing now
           dw 0                     ; reserved - leave blank
           tbsize = ymax-ymin
           if tbsize lt xmax-xmin
           tbsize = xmax-xmin
           endif
firstbyte  dw tbsize dup(1000)      ; table of start and end x points
           dw 1000                  ; end flag, permanent
           dw 0                     ; reserved - leave blank
lastbyte   dw tbsize dup(-1000)
oney       dd 1000                  ; y start for one polygon draw
leftmost   dw 1000                  ; only used for fakelineg routine (note g)
colq       db ?                     ; colour of this side
lamflag    db ?                     ; is lambert matrix set up for this object?
           align 16
currobj    dd ?                     ; current object number (for shading)
xupdate    dw xmax,xmin-1           ; x,y update for clearing entire picture
yupdate    dw ymax,ymin-1
lxupdate   dw xmax,xmin-1           ; last x,y update
lyupdate   dw ymax,ymin-1
_old_traces_past dd 0
xad        dd ?                     ; 3d offset of object
yad        dd ?
zad        dd ?
vxcos      dd ?
vxsin      dd ?
vycos      dd ?
vysin      dd ?
vzcos      dd ?
vzsin      dd ?
palxrefx   dd ?                     ; temp xreferance holder
steel      db ?                     ; steel flag, -1 = don't use
steelc     db ?                     ; base colour for steel, taken from colq
polytype   dd ?                     ; offset for polytype (fakeline)
minzc      dd ?                     ; minz (for each object)
btolr      dd ?                     ; tolerance (for each object)
fex        dw ?

; variables for multiple object routine, you modify these!

           align 16
xs         dd maxobjects+1 dup (0)  ; locations of objects
ys         dd maxobjects+1 dup (0)
zs         dd maxobjects+1 dup (0)
xadds      dd maxobjects+1 dup (0)  ; linear velocities of objects
yadds      dd maxobjects+1 dup (0)
zadds      dd maxobjects+1 dup (0)
vxs        dw maxobjects+1 dup (0)  ; angles of objects
vys        dw maxobjects+1 dup (0)
vzs        dw maxobjects+1 dup (0)
vxadds     dw maxobjects+1 dup (0)  ; anglular velocities
vyadds     dw maxobjects+1 dup (0)
vzadds     dw maxobjects+1 dup (0)
lcount     dw maxobjects+1 dup (0)  ; linear counter
acount     dw maxobjects+1 dup (0)  ; angular counter
xsfinal    dd maxobjects+1 dup (0)  ; final locations of objects
ysfinal    dd maxobjects+1 dup (0)
zsfinal    dd maxobjects+1 dup (0)
vxsfinal   dw maxobjects+1 dup (0)  ; final angles of objects
vysfinal   dw maxobjects+1 dup (0)
vzsfinal   dw maxobjects+1 dup (0)
whatshape  dw maxobjects+1 dup (0)  ; shapes of objects or bitmaps (0,1,2...)
palxref    db maxobjects+1 dup (0)  ; palette cross reference for each object
userotate  db maxobjects+1 dup (0)  ; rotation type,0 = full,1 = camera
           align 16
onoff      db maxobjects+1 dup (0)  ; is object on/off

;
;
;
;
;
;

; flags to disable/enable routines: disable = -1, enable >=0

use_clear  dd yes                 ; flag to use clear_fill routine, default=use
wfollow    dd no                  ; what object are we following, -1 = none
wherelook  dd no                  ; what object do we force camera to look at

oldspeed   dd ?                   ; how fast to move, temp counter

; camera variables = was last object in object list, now is zero'th

eyex       equ d [xs+cameraobject*4] ; camera location
eyey       equ d [ys+cameraobject*4]
eyez       equ d [zs+cameraobject*4]
eyeax      equ w [vxs+cameraobject*2] ; angles for camera
eyeay      equ w [vys+cameraobject*2]
eyeaz      equ w [vzs+cameraobject*2]
eyexadds   equ d [xadds+cameraobject*4] ; eye location velocity
eyeyadds   equ d [yadds+cameraobject*4]
eyezadds   equ d [zadds+cameraobject*4]
eyevxadds  equ w [vxadds+cameraobject*2] ; eye angular velocities
eyevyadds  equ w [vyadds+cameraobject*2]
eyevzadds  equ w [vzadds+cameraobject*2]
eyelcount  equ w [lcount+cameraobject*2] ; eye linear count (how many times to move)
eyeacount  equ w [acount+cameraobject*2] ; eye angular count
eyefinalx  equ d [xsfinal+cameraobject*4] ; final camera position
eyefinaly  equ d [ysfinal+cameraobject*4]
eyefinalz  equ d [zsfinal+cameraobject*4]
eyefinalax equ w [vxsfinal+cameraobject*2] ; final camera angle
eyefinalay equ w [vysfinal+cameraobject*2]
eyefinalaz equ w [vzsfinal+cameraobject*2]

           align 16

ecosx      dd ?              ; multipliers of eyeax and eyeaz
esinx      dd ?              ; reset at begining of each new frame
ecosy      dd ?
esiny      dd ?
ecosz      dd ?
esinz      dd ?

vcosx      dd ?              ; temp storage for object matrix calculation
vsinx      dd ?              ; can be used if needed during draw
vcosy      dd ?
vsiny      dd ?
vcosz      dd ?
vsinz      dd ?

vmatrix    dd 9 dup (?)      ; 3x3 rotation matrix for object (includes eye)
tmatrix    dd 9 dup (?)      ; 3x3 temp rotation matrix for hierarchys
ematrix    dd 9 dup (?)      ; 3x3 rotation matrix for eye
lmatrix    dd 3 dup (?)      ; 1x3 z resultant matrix for lambert shading

y_angle_of_sun dd 2000h      ; where is the sun? for shading

; clipping variables in memory locations, pre-calculated!
; xactual and yactual basically don't change but clipping can to allow
; windows (rear view mirror, view airplanes menu, auxilary views, rear gunner)
;
; when flipping between windows, also flip wfollow, wherelook
; oldspeed, lxupdate, lyupdate, camera variables/angles/speeds (obviously).

cliplt      dw xcenter+xmin     ; xcenter+xmin
cliprt      dw xcenter+xmax-1   ; xcenter+xmax-1
cliptp      dw ycenter+ymin     ; ycenter+ymin
clipbt      dw ycenter+ymax-1   ; ycenter+ymax-1

xcent       dw xcenter
ycent       dw ycenter
ycents1     dw ycenter-1
ycentp1     dw ycenter+1

xmaxxcent   dw xmax+xcenter

ymaxycent   dw ymax+ycenter

xmins       dw xmin
xmins1      dw xmin-1
xmaxs       dw xmax
xmaxs1      dw xmax-1

ymins       dw ymin
ymins1      dw ymin-1
ymaxs       dw ymax
ymaxs1      dw ymax-1

xmit        dd xmin-tolerance   ; tolerance is max object size/ratio
xmat        dd xmax+tolerance
ymit        dd ymin-tolerance
ymat        dd ymax+tolerance

; variables for icon scale routine

bitmap        dd ?
destwidth     dw ?
destheight    dw ?
destx         dw ?
desty         dw ?

sourcewidth   dw ?              ; workspace for icon scale routine
sourceheight  dw ?
decisionx     dw ?
decisiony     dw ?
clippedwidth  dw ?
clippedheight dw ?

background dw 0                 ; background colour, must be in high and low!

           public objbase    ; make sure these are here even if you don't
           public bitbase    ; use them.  tlink will fail if not present.!
           public bitx
           public bity
           public xreftable
           public stonetbl

           public xs
           public ys
           public zs
           public xadds
           public yadds
           public zadds
           public vxs
           public vys
           public vzs
           public vxadds
           public vyadds
           public vzadds
           public xsfinal
           public ysfinal
           public zsfinal
           public vxsfinal
           public vysfinal
           public vzsfinal
           public lcount
           public acount
           public whatshape
           public userotate

           public eyex
           public eyey
           public eyez
           public eyeax
           public eyeay
           public eyeaz
           public eyexadds
           public eyeyadds
           public eyezadds
           public eyevxadds
           public eyevyadds
           public eyevzadds
           public eyefinalx
           public eyefinaly
           public eyefinalz
           public eyefinalax
           public eyefinalay
           public eyefinalaz
           public eyelcount
           public eyeacount

           public onoff

           public vmatrix
           public tmatrix
           public ematrix
           public lmatrix
           public y_angle_of_sun

           public background

           public bitmap
           public destwidth
           public destheight
           public destx
           public desty

           public use_clear
           public wfollow
           public wherelook

           public x1
           public y1
           public x2
           public y2
           public colq
           public steel

           public lxupdate
           public lyupdate
           public xupdate
           public yupdate

           public oney
           public firstbyte
           public lastbyte
           public showing
           public _old_traces_past

           public cliplt
           public cliprt
           public cliptp
           public clipbt
           public xcent
           public ycent
           public xmins
           public xmins1
           public xmaxs
           public xmaxs1
           public ymins
           public ymins1
           public ymaxs
           public ymaxs1

           public asm_version
           public asm_maxpoints
           public asm_maxsurfaces
           public asm_maxpolys
           public asm_maxobjects
           public asm_number_spaces
           public asm_xsize
           public asm_ysize
           public asm_usez
           public asm_useborders
           public asm_use_half_stars
           public asm_cameraobject
           public asm_xmode
           public asm_ratiox
           public asm_ratioy
           public asm_xactual
           public asm_yactual
           public asm_pages

