
; wxvsa256.asm
;
; Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

PUBLIC SetVESASelector_, VESACopy256To256_, SetVESAData_, VESAClear256_

; EDX = Bank Number
SetBank MACRO
  push AX
  push BX
  push EDX
  xor  BX, BX
  mov  EDX, BankNumber
  mov  AX, 4F05h
  int  10h
  pop  EDX
  pop  BX
  pop  AX
ENDM

.DATA
  ScreenWd  DD 0
  ScreenHt  DD 0
  ScreenLen DD 0
  BankNumber DD 0

  SrcWd DD 0
  SrcHt DD 0

.CODE
.386

; VOID SetVESASelector ( SHORT Selector )
; EAX = Selector

SetVESASelector_ PROC
  ret 
SetVESASelector_ ENDP


; VOID SetVESAData ( LONG SrcWidth, LONG SrcHeight, LONG SrcLen );
; EAX = SrcWidth, EDX = Srcheight, EBX = SrcLen

SetVESAData_ PROC C
  mov  ScreenWd, EAX
  mov  ScreenHt, EDX
  mov  ScreenLen, EBX
  ret
SetVESAData_ ENDP


; VOID VESACopy256To256 ( BYTE *Src, LONG AddSrc, LONG SrcWd, LONg SrcHt,
;                         LONG DestCx, LONG DestCy );
;
; EAX = Src, EDX = AddSrc, EBX = SrcWd, ECX = SrcHt
VESACopy256to256_ PROC C, DestCx:DWORD,DestCy:DWORD
  push EDI
  push ESI

  mov  ESI, EAX   ; ESI = Src
  mov  SrcWd, EBX
  mov  SrcHt, ECX
  
  sub  EDX, EBX
  mov  EBX, EDX   ; EBX = AddSrc - SrcWd

  mov  EDI, 0A0000h
  mov  EAX, DestCy
  mov  EDX, ScreenLen
  mul  DX  
  add  EAX, DestCx
  adc  EDX, 0        ; EDX is the Bank Number
  and  EAX, 0FFFFh
  mov  BankNumber, EDX
  
  SetBank 
  
  add  EDI, EAX
  
  mov  EDX, ScreenLen
  sub  EDX, SrcWd
  cld

  Copy256OutLoop :
    mov ECX, SrcWd
    mov EAX, ECX
    and EAX, 03h
    shr ECX, 2
    rep movsd
    mov ECX, EAX
    rep movsb
    add ESI, EBX
    add EDI, EDX
    cmp EDI, 0AFFFFh
    jle DoNext
      inc BankNumber
      SetBank
      and EDI, 0AFFFFh

    DoNext :
      dec SrcHt
    jnz Copy256OutLoop

  pop  ESI
  pop  EDI
  ret
VESACopy256to256_ ENDP

; VOID VESAClear256 ( BYTE Color );
;
; EAX = Color
VESAClear256_ PROC C
  push EDI
  push ESI
  push EBX
  push ECX
  push EDX

  mov  AH, AL
  mov  CX, AX
  shl  EAX, 16  
  mov  AX, CX
  
  mov  EDI, 0A0000h
  mov  BankNumber, 0
  
  SetBank 
  
  mov  EDX, ScreenLen
  sub  EDX, ScreenWd
  mov  ESI, ScreenHt
  cld

  Clear256OutLoop :
    mov ECX, ScreenWd
    mov EBX, ECX
    and EBX, 03h
    shr ECX, 2
    rep stosd
    mov ECX, EBX
    rep stosb
    add EDI, EDX
    cmp EDI, 0AFFFFh
    jle DoNextClear
      inc BankNumber
      SetBank 
      and EDI, 0AFFFFh
    
    DoNextClear :
      dec ESI
    jnz Clear256OutLoop

  pop  EDX
  pop  ECX
  pop  EBX
  pop  ESI
  pop  EDI
  ret
VESAClear256_ ENDP

END
