
; wdib256.asm
;
; Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

PUBLIC TransBlt256To256_, WaitForRetraceMany_, WaitForRetraceOnce_
PUBLIC WaitForRetraceTerminate_
PUBLIC ScaleBlt256To256_, Affine256To256_

.DATA
  U  DD 0
  V  DD 0
  Du DD 0
  Dv DD 0
  SrcAdd DD 4 dup (0)


InitClockCycle MACRO
  push EAX
  push ECX
  push EDX
  xor  EAX, EAX
  xor  EDX, EDX
  mov  ECX, 010h
  wrmsr
  pop  EDX
  pop  ECX
  pop  EAX
ENDM

GetElapsedClock MACRO
  push ECX
  xor  EAX, EAX
  xor  EDX, EDX
  mov  ECX, 010h
  rdmsr
  pop  ECX
ENDM

.CODE
.386

; VOID WaitForRetraceMany ( LONG Count )
;
; EAX = Count

WaitForRetraceMany_ PROC C
  push ECX
  push EDX
  mov  ECX, EAX
  mov  EDX, 03DAh
  
  WFRLoop :
    WaitManyEnd :
      in   al, dx
      test al, 08h
      jnz   WaitManyEnd 
      
    WaitManyStart :
      in   al, dx
      test al, 08h
      jz   WaitManyStart
        
    cmp ECX, 0
    jle EndWaitMany
    dec ECX
    jmp WFRLoop  
    
  EndWaitMany :
        
  pop  EDX
  pop  ECX
  ret
WaitForRetraceMany_ ENDP


; VOID WaitForRetraceOnce ()
WaitForRetraceOnce_ PROC C
  push EDX
  mov  EDX, 03DAh
  
  WaitOnceEnd :
    in   al, dx
    test al, 08h
    jnz   WaitOnceEnd 
      
  WaitOnceStart :
    in   al, dx
    test al, 08h
    jz   WaitOnceStart
        
  pop  EDX
  ret
WaitForRetraceOnce_ ENDP

; VOID WaitForRetraceTermin ()
WaitForRetraceTerminate_ PROC C
  push EDX
  mov  EDX, 03DAh
  
  WaitTerminate :
    in   al, dx
    test al, 08h
    jnz   WaitTerminate
      
  pop  EDX
  ret
WaitForRetraceTerminate_ ENDP

; VOID TransBlt256To256 ( BYTE *Dest, BYTE *Src, LONG Wd, BYTE TransColor )
;
; EAX = Dest, EDX = Src, EBX = Wd, ECX = TransColor

TransBlt256To256_ PROC C
  push EDI
  push ESI

  mov  EDI, EAX
  mov  ESI, EDX
  mov  AH, CL
  mov  ECX, EBX
  cld

  TransLoop :
    mov AL, [ESI]
    inc ESI
    cmp AH, AL
    je  Skip
      mov [EDI], AL

    Skip :
      inc EDI
      dec ECX
    jnz TransLoop

  pop  ESI
  pop  EDI
  ret
TransBlt256To256_ ENDP


; VOID ScaleBlt ( BYTE *Dest, BYTE *Src, LONG Wd, DWORD Error, DWORD AddError )
;
; EAX = Dest, EDX = Src, EBX = Wd, ECX = Error

ScaleBlt256To256_ PROC C AddError:DWORD
  push EBP
  push ESI
  push EDI
  
  mov  EDI, EAX
  mov  ESI, EDX
  
  xchg EBX, ECX  ; ECX is the loop count, EBX is the Error  
  mov  EDX, AddError
  mov  EBP, 0
  cld 
  ;InitClockCycle

  ScaleLoop :
    mov AL, [ESI+EBP] 
    add EBX, EDX
    mov EBP, EBX
    mov [EDI], AL
    shr EBP, 16
    inc EDI
    dec ECX
    jnz ScaleLoop
    
  ;GetElapsedClock

  pop  EDI
  pop  ESI
  pop  EBP
  ret
ScaleBlt256To256_ ENDP


; VOID SetSrcAdd ( LONG Add1, LONG Add2 )
;
; EAX = U, EDX = V, EBX = Du, ECX = Dv

; VOID SetAffineUV ( LONG U, LONG V, LONG Du, LONG Dv )
;
; EAX = U, EDX = V, EBX = Du, ECX = Dv

SetAffineUV_ PROC C 

SetAffineUV_ ENDP


; VOID Affine256To256 ( BYTE *Dest, BYTE *Src, LONG Wd )
;  
; EAX = Dest, EDX = Src, EBX = Wd

Affine256To256_ PROC C 
  push EBP
  push ESI
  push EDI
  
  mov  EDI, EAX
  mov  ESI, EDX
  
  LoopAffine256 :
  
    loop LoopAffine256
  
  pop  EDI
  pop  ESI
  pop  EBP
  ret
Affine256To256_ ENDP

END


