#include "sphere.h"

static double sphere_points[62*3] = {
-0.53843,-0.00000,0.87120,
0.53843,-0.00000,0.87120,
-0.53843,0.00000,-0.87120,
0.53843,0.00000,-0.87120,
-0.00000,0.87120,0.53843,
0.00000,0.87120,-0.53843,
0.00000,-0.87120,0.53843,
-0.00000,-0.87120,-0.53843,
0.87120,0.53843,0.00000,
-0.87120,0.53843,-0.00000,
0.87120,-0.53843,-0.00000,
-0.87120,-0.53843,0.00000,
0.00000,0.00000,1.00000,
-0.30902,0.50000,0.80902,
-0.30902,-0.50000,0.80902,
-0.80902,0.30902,0.50000,
-0.80902,-0.30902,0.50000,
0.30902,0.50000,0.80902,
0.30902,-0.50000,0.80902,
0.80902,0.30902,0.50000,
0.80902,-0.30902,0.50000,
0.00000,0.00000,-1.00000,
-0.30902,0.50000,-0.80902,
-0.30902,-0.50000,-0.80902,
-0.80902,0.30902,-0.50000,
-0.80902,-0.30902,-0.50000,
0.30902,0.50000,-0.80902,
0.30902,-0.50000,-0.80902,
0.80902,0.30902,-0.50000,
0.80902,-0.30902,-0.50000,
0.00000,1.00000,0.00000,
0.50000,0.80902,0.30902,
-0.50000,0.80902,0.30902,
0.50000,0.80902,-0.30902,
-0.50000,0.80902,-0.30902,
0.00000,-1.00000,0.00000,
0.50000,-0.80902,0.30902,
-0.50000,-0.80902,0.30902,
0.50000,-0.80902,-0.30902,
-0.50000,-0.80902,-0.30902,
1.00000,0.00000,0.00000,
-1.00000,0.00000,0.00000,
0.00000,0.35600,0.93201,
-0.57602,0.57602,0.57602,
-0.35600,0.93201,0.00000,
0.35600,0.93201,0.00000,
0.57602,0.57602,0.57602,
0.93201,0.00000,0.35600,
0.93201,0.00000,-0.35600,
0.57602,0.57602,-0.57602,
0.00000,0.35600,-0.93201,
0.00000,-0.35600,-0.93201,
0.57602,-0.57602,-0.57602,
0.35600,-0.93201,0.00000,
-0.35600,-0.93201,0.00000,
-0.57602,-0.57602,0.57602,
0.00000,-0.35600,0.93201,
0.57602,-0.57602,0.57602,
-0.93201,0.00000,0.35600,
-0.93201,0.00000,-0.35600,
-0.57602,0.57602,-0.57602,
-0.57602,-0.57602,-0.57602};

static int sphere_quads[60*4] = {
  0, 12, 42, 13,
  0, 13, 43, 15,
  0, 14, 56, 12,
  0, 15, 58, 16,
  0, 16, 55, 14,
  1, 12, 56, 18,
  1, 17, 42, 12,
  1, 18, 57, 20,
  1, 19, 46, 17,
  1, 20, 47, 19,
  2, 21, 51, 23,
  2, 22, 50, 21,
  2, 23, 61, 25,
  2, 24, 60, 22,
  2, 25, 59, 24,
  3, 21, 50, 26,
  3, 26, 49, 28,
  3, 27, 51, 21,
  3, 28, 48, 29,
  3, 29, 52, 27,
  4, 13, 42, 17,
  4, 17, 46, 31,
  4, 30, 44, 32,
  4, 31, 45, 30,
  4, 32, 43, 13,
  5, 22, 60, 34,
  5, 26, 50, 22,
  5, 30, 45, 33,
  5, 33, 49, 26,
  5, 34, 44, 30,
  6, 14, 55, 37,
  6, 18, 56, 14,
  6, 35, 53, 36,
  6, 36, 57, 18,
  6, 37, 54, 35,
  7, 23, 51, 27,
  7, 27, 52, 38,
  7, 35, 54, 39,
  7, 38, 53, 35,
  7, 39, 61, 23,
  8, 19, 47, 40,
  8, 28, 49, 33,
  8, 31, 46, 19,
  8, 33, 45, 31,
  8, 40, 48, 28,
  9, 15, 43, 32,
  9, 24, 59, 41,
  9, 32, 44, 34,
  9, 34, 60, 24,
  9, 41, 58, 15,
 10, 20, 57, 36,
 10, 29, 48, 40,
 10, 36, 53, 38,
 10, 38, 52, 29,
 10, 40, 47, 20,
 11, 16, 58, 41,
 11, 25, 61, 39,
 11, 37, 55, 16,
 11, 39, 54, 37,
 11, 41, 59, 25 };

void prepare_sphere_list ()
{
#define SC	0.5
	vec3 normal,v0,v1,v2,v3;
	
	glNewList(SPHERE_LIST, GL_COMPILE);
	glBegin(GL_QUADS);
	for (int i=0; i<60; i++) {
		v0.x=sphere_points[sphere_quads[i*4+0]*3+0]*SC;
		v0.y=sphere_points[sphere_quads[i*4+0]*3+1]*SC;
		v0.z=sphere_points[sphere_quads[i*4+0]*3+2]*SC;
		
		v1.x=sphere_points[sphere_quads[i*4+1]*3+0]*SC;
		v1.y=sphere_points[sphere_quads[i*4+1]*3+1]*SC;
		v1.z=sphere_points[sphere_quads[i*4+1]*3+2]*SC;

		v2.x=sphere_points[sphere_quads[i*4+2]*3+0]*SC;
		v2.y=sphere_points[sphere_quads[i*4+2]*3+1]*SC;
		v2.z=sphere_points[sphere_quads[i*4+2]*3+2]*SC;
		
		v3.x=sphere_points[sphere_quads[i*4+3]*3+0]*SC;
		v3.y=sphere_points[sphere_quads[i*4+3]*3+1]*SC;
		v3.z=sphere_points[sphere_quads[i*4+3]*3+2]*SC;
		
		normal=normalize(cross(v0-v1,v1-v2));
		glNormal3f(normal.x, normal.y, normal.z);
		glVertex3f(v0.x,v0.y,v0.z);
		glVertex3f(v1.x,v1.y,v1.z);
		glVertex3f(v2.x,v2.y,v2.z);
		glVertex3f(v3.x,v3.y,v3.z);
	}
	glEnd();
	glEndList();
}

