// created by eL 2003 http://eL.zde.cz eL@email.cz
//
// hardcoding

#include <_mingw.h>
#include <iostream>
#include <windows.h>
#include <math.h>
#include <bassmod.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include "vec3.h"
#include <sdl/sdl.h>
#include <stdlib.h>
#include "torus.h"
#include "sphere.h"
#include "texture.h"

char musicName[] = "purememx.xm";

#define PI          ((double) 3.1415926535897929)
#define NUM_FX		30
#define TEXTURE0	1

HSYNC hsync5,hsync6,hsync7,hsync8,hsync11,hsync12,hsync15,hsync17;

GLfloat fxLength[NUM_FX] = {0,0,0,0,0,500, 400, 3500, 500, 0,0,400,400,0,0,400,0,0,300};

int width,height,bpp,flags = 0;

vec3 camera = { 0,0,-3 };
BOOL camera_change;

vec3 points[TORUS_POINTS];
vec3 pNormals[TORUS_POINTS];
vec3 fNormals[TORUS_QUADS];

GLfloat fx[NUM_FX];
GLfloat fx11_volume;
GLfloat startTime;
Uint32 startTime2 = 0;
Uint32 startTime_label = 0;
int torus_part = 1;
int sphere_part = 0;

#define NUM_CIRCLE	10

vec3 circle_rotate[NUM_CIRCLE];
GLfloat circle_radius[NUM_CIRCLE];

#define NUM_BAR	18

GLfloat bar_startTime[NUM_BAR] = {0,0,0,0,0,0, 0,0,0,0,0,0, 0,0,0,0,0,0};
GLfloat bar_x[NUM_BAR];
GLfloat bar_dir[NUM_BAR];
GLfloat bar_rad[NUM_BAR];

int startEndTime = 0;

double rnd() { return rand()/32767.0; }	// <0,1)

#include "temp1.h"

void FPS ()
{
	static float fps           = 0.0f;						
    static float previousTime  = 0.0f;	
    char pChar[100];
	float currentTime = (SDL_GetTicks() * 0.001f);
    ++fps;	// Increment the FPS counter
    if( currentTime - previousTime > 1.0f ) {
	    previousTime = currentTime;
		sprintf( pChar, "fps:: %f", fps );
		SDL_WM_SetCaption(pChar, 0);
        fps = 0.0f;
    }
}

void quitGL ()
{ SDL_ShowCursor(SDL_ENABLE); BASSMOD_Free(); SDL_Quit(); exit(0); }

void draw_cube ()
{
    glBegin(GL_QUADS);
    glNormal3f( 0.0F, 0.0F, 1.0F); glVertex3f( 0.5F, 0.5F, 0.5F); glVertex3f(-0.5F, 0.5F, 0.5F); glVertex3f(-0.5F,-0.5F, 0.5F); glVertex3f( 0.5F,-0.5F, 0.5F);
    glNormal3f( 0.0F, 0.0F,-1.0F); glVertex3f(-0.5F,-0.5F,-0.5F); glVertex3f(-0.5F, 0.5F,-0.5F); glVertex3f( 0.5F, 0.5F,-0.5F); glVertex3f( 0.5F,-0.5F,-0.5F);
    glNormal3f( 0.0F, 1.0F, 0.0F); glVertex3f( 0.5F, 0.5F, 0.5F); glVertex3f( 0.5F, 0.5F,-0.5F); glVertex3f(-0.5F, 0.5F,-0.5F); glVertex3f(-0.5F, 0.5F, 0.5F);
    glNormal3f( 0.0F,-1.0F, 0.0F); glVertex3f(-0.5F,-0.5F,-0.5F); glVertex3f( 0.5F,-0.5F,-0.5F); glVertex3f( 0.5F,-0.5F, 0.5F); glVertex3f(-0.5F,-0.5F, 0.5F);
    glNormal3f( 1.0F, 0.0F, 0.0F); glVertex3f( 0.5F, 0.5F, 0.5F); glVertex3f( 0.5F,-0.5F, 0.5F); glVertex3f( 0.5F,-0.5F,-0.5F); glVertex3f( 0.5F, 0.5F,-0.5F);
    glNormal3f(-1.0F, 0.0F, 0.0F); glVertex3f(-0.5F,-0.5F,-0.5F); glVertex3f(-0.5F,-0.5F, 0.5F); glVertex3f(-0.5F, 0.5F, 0.5F); glVertex3f(-0.5F, 0.5F,-0.5F);
    glEnd();
}


void process_fx ()
{
	GLfloat time = SDL_GetTicks();
	
	prepare_points_and_normals();
	
	for (int i=0; i<NUM_FX; i++) {
		if (fx[i]!=-1.0) {
			switch (i) {
				case 5: do_fx5(); break;
				case 6: do_fx6(); break;
				case 7: do_fx7(); break;
				case 8: do_fx8(); break;
				case 11: do_fx11(); break;
				case 12: do_fx12(); break;
				case 15: do_fx15(); break;
				case 17: do_fx17(); break;
				default: break;
			}
			if (time-fx[i]>fxLength[i]) fx[i]=-1.0;
		}
	}
}

void process_bars ()
{
	GLfloat time = SDL_GetTicks();
	for (int i=0; i<NUM_BAR; i++) {
		if (bar_startTime[i]!=0.0) {
			GLfloat t=time-bar_startTime[i];
			glColor4f(1,1,1,0.3);
			if (t>1000) glColor4f(1,1,1,(1.0-(t-1000)/1000.0)*0.3);
			GLfloat x = bar_x[i]+t*0.0002*bar_dir[i];
			glRectf(x-bar_rad[i],0,x+bar_rad[i],3);
			if (t>2000) bar_startTime[i]=0.0;
		}
	}
}


void CALLBACK mySync5 (HSYNC handle, DWORD data, DWORD user) 
{ fx[5]=SDL_GetTicks(); camera_change=FALSE; }

void CALLBACK mySync6 (HSYNC handle, DWORD data, DWORD user)
{ fx[6]=SDL_GetTicks(); }

void CALLBACK mySync7 (HSYNC handle, DWORD data, DWORD user)
{ if (LOWORD(data)>70) fx[7]=SDL_GetTicks(); }

void CALLBACK mySync8 (HSYNC handle, DWORD data, DWORD user)
{ fx[8]=SDL_GetTicks(); }

void CALLBACK mySync11 (HSYNC handle, DWORD data, DWORD user)
{ fx[11]=SDL_GetTicks(); fx11_volume = (double)HIWORD(data)/64.0; }

void CALLBACK mySync12 (HSYNC handle, DWORD data, DWORD user)
{ fx[12]=SDL_GetTicks(); }

void CALLBACK mySync15 (HSYNC handle, DWORD data, DWORD user)
{ if (fx[15]==-1) fx[15]=SDL_GetTicks(); }

void CALLBACK mySync17 (HSYNC handle, DWORD data, DWORD user)
{ fx[17]=SDL_GetTicks(); }

void CALLBACK mySync_pos0 (HSYNC handle, DWORD data, DWORD user)
{ startTime2=SDL_GetTicks(); }

void CALLBACK mySync_pos1 (HSYNC handle, DWORD data, DWORD user)
{ startTime_label=SDL_GetTicks(); }

void CALLBACK mySync_pos2 (HSYNC handle, DWORD data, DWORD user)
{ startEndTime=SDL_GetTicks(); }

void CALLBACK mySyncBar (HSYNC handle, DWORD data, DWORD user)
{
	for (int i=0; i<NUM_BAR; i++) {
		if (bar_startTime[i]==0.0) {
			bar_x[i]=rnd()*3.0+0.5;
			if (rand()&1) bar_dir[i]=-1.0; else bar_dir[i]=1.0;
			bar_startTime[i]=SDL_GetTicks();
			bar_rad[i]=rnd()*0.6+0.1;
			return;
		}
	}
}

void draw_spheres ()
{
	glPushMatrix();
	glEnable(GL_COLOR_MATERIAL);
	for (int i=0; i<5; i++) {
		glPushMatrix();
		glRotatef(SDL_GetTicks()*0.03, 0.5,0.3,-0.4);
		glRotatef(360/5*i,0,0,1);
		glTranslatef(1.6,0,0);
		//glScalef(0.5,0.5,0.5);
		//glScalef(0.2,0.5,0.5);
		glRotatef(SDL_GetTicks()*0.05, 0.4,0.2,0.6);
		
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		glColor3f(0.5,0.5,0.5);
		glEnable(GL_POLYGON_OFFSET_FILL);
		glPolygonOffset(2.0,2.0);
		glCallList(SPHERE_LIST);
		glColor3f(0.0,0.0,0.0);
 		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
 		glEnable(GL_POLYGON_OFFSET_LINE);
 		glPolygonOffset(1.0,1.0);
		glCallList(SPHERE_LIST);
		
		glDisable(GL_POLYGON_OFFSET_FILL);
		glDisable(GL_POLYGON_OFFSET_LINE);
		glPopMatrix();
	}
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glPopMatrix();
}

void set_2d ()		//special
{
	glPushMatrix();
	glViewport(0,0,width,height);
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho(0,4,0,3,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDepthMask(GL_FALSE);
	glDisable(GL_LIGHTING);
}

void restore_2d ()
{
	glEnable(GL_LIGHTING);
	glDepthMask(GL_TRUE);
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

void draw_texture0 ()
{
	set_2d();
	
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
 	glEnable(GL_TEXTURE_2D);
	
 	glBindTexture(GL_TEXTURE_2D, TEXTURE0);
 	glTranslatef(2,1,0);
 	glScalef(2,2,1);
 	glBegin(GL_QUADS);
	glTexCoord2f(0,0); glVertex3f(0,-1,0);
	glTexCoord2f(1,0); glVertex3f(1,-1,0);
	glTexCoord2f(1,1); glVertex3f(1,0,0);
	glTexCoord2f(0,1); glVertex3f(0,0,0);
	glEnd();
	
 	glDisable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	restore_2d();
}

void display ()
{
	double t;
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	
	if (sphere_part) {
		gluLookAt(camera.x, camera.y, camera.z, 0,0,0, 0,1,0);
		double time = SDL_GetTicks()*0.0001;
  		t = 8 * time + 0.5 * (cos(time * 0.41 + 0.123) + cos(time * 0.51 + 0.234) +
                   		      cos(time * 0.61 + 0.623) + cos(time * 0.21 + 0.723));
  		glRotatef(2.4 * t, 1,0,0);
  		glRotatef(2.5 * t, 0,1,0);
  		glRotatef(2.6 * t, 0,0,1);
		glPushMatrix();
		draw_spheres();
		glPopMatrix();
		set_2d();
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		process_bars();
		restore_2d();
	}
	if (torus_part) {//&&(SDL_GetTicks()-startTime2<290)) {	//part1 (torus)
		gluLookAt(camera.x,camera.y,camera.z,  0,0,0, 0,1,0 );
		double time = SDL_GetTicks()*0.001;
  		t = 8 * time + 0.5 * (cos(time * 0.41 + 0.123) + cos(time * 0.51 + 0.234) +
                   		      cos(time * 0.61 + 0.623) + cos(time * 0.21 + 0.723));
  		glRotatef(2.4 * t, 1,0,0);
  		glRotatef(2.5 * t, 0,1,0);
  		glRotatef(2.6 * t, 0,0,1);
		glPushMatrix();
		//glRotatef(SDL_GetTicks()*0.001, -0.4,0.6,0.8);
 		glRotatef(SDL_GetTicks()*0.02, 0.3,0.5,-0.4);
		process_fx();
		glDisable(GL_BLEND);
  		glPushMatrix();
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		glColor4f(0.5,0.5,0.5,0.5);
		glEnable(GL_POLYGON_OFFSET_FILL);
		glPolygonOffset(2.0, 2.0);
		draw_torus();
		glPopMatrix();
		glPushMatrix();
		glColor4f(0.0,0.0,0.0,0.5);
 		glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
 		glEnable(GL_POLYGON_OFFSET_LINE);
 		glPolygonOffset(1.0,1.0);
		draw_torus();
		glPopMatrix();
		glDisable(GL_POLYGON_OFFSET_FILL);
		glDisable(GL_POLYGON_OFFSET_LINE);
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
		glEnable(GL_BLEND);
		glPopMatrix();
	}

	t=SDL_GetTicks()-startTime;
	if (t<8000) {
		set_2d();
		glDisable(GL_LIGHTING);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.3,0.3,0.3,1-t/8000);
		glRectf(0,0,4,3);
		glEnable(GL_LIGHTING);
		restore_2d();
	}
	t=SDL_GetTicks()-startEndTime;
	if ((startEndTime)&&(t<150000)) {
		if (t>14900) quitGL();	//end of demo
		set_2d();
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.3,0.3,0.3,t/15000);
		glRectf(0,0,4,3);
		restore_2d();
	}
 	t=SDL_GetTicks()-startTime2;
	if ((startTime2)&&(t<2000)) {
		if ((t>1900)&&(!sphere_part)) {
  			torus_part=0;
  			sphere_part=1;
  			BASSMOD_MusicRemoveSync(hsync5);
  			BASSMOD_MusicRemoveSync(hsync6);
  			BASSMOD_MusicRemoveSync(hsync7);
  			BASSMOD_MusicRemoveSync(hsync8);
  			BASSMOD_MusicRemoveSync(hsync11);
  			BASSMOD_MusicRemoveSync(hsync12);
  			BASSMOD_MusicRemoveSync(hsync15);
  			BASSMOD_MusicRemoveSync(hsync17);
 			
    		BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(2,-1), &mySyncBar, 0);
    		//BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(11,-1), &mySyncBar, 0);
    		BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(19,-1), &mySyncBar, 0);
		}
		set_2d();
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.3,0.3,0.3,t/2000.0);
		glRectf(0,0,4,3);
		restore_2d();
	}
	
	if ((startTime_label)&&(SDL_GetTicks()-startTime_label<=6000+4000)) {
		glColor4f(1,1,1,1);
		t=SDL_GetTicks()-startTime_label;
		if (t<3000)
			glColor4f(1,1,1,t/3000.0);
		if (t>3000+4000)
			glColor4f(1,1,1,1.0-(t-7000)/3000.0);
		draw_texture0();
	}

	FPS();
	glFlush();
	SDL_GL_SwapBuffers();
}

void initGL (int w, int h)
{
	srand(SDL_GetTicks());
 	//GLfloat mat_specular[4] = { 0.5,0.5,0.5,1.0 };
	
	glClearColor(0.3,0.3,0.3,0.0);
	glShadeModel(GL_FLAT);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_DITHER);
	//glEnable(GL_NORMALIZE);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_CULL_FACE);
	//glEnable(GL_LINE_SMOOTH);
	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE);
	//glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
	//glMaterialf(GL_FRONT, GL_SHININESS, 10.0);
	
	glViewport(0,0,w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, (double)w/h, 0.1, 500.0);
	glMatrixMode(GL_MODELVIEW);
	
	prepare_points_and_normals();
	for (int i=0; i<NUM_FX; i++) fx[i]=-1;
	
	prepare_sphere_list();

 	//load texture
	unsigned *teximage;
	int texwid, texht;
	int texcomps;

	teximage = read_texture("image2.rgb", &texwid, &texht, &texcomps);
 	glBindTexture(GL_TEXTURE_2D, TEXTURE0);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, texwid, texht, 0, GL_RGBA, GL_UNSIGNED_BYTE, teximage);
	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, texwid, texht, GL_RGBA, GL_UNSIGNED_BYTE, teximage);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	delete teximage;
	
	for (int i=0; i<NUM_CIRCLE; i++) {
		circle_radius[i]=rnd()+1.0;
		circle_rotate[i].x=rnd();
		circle_rotate[i].y=rnd();
		circle_rotate[i].z=rnd();
	}
}


void process_events (void)
{
	SDL_Event event;
	while (SDL_PollEvent(&event)) {
		switch (event.type) {
			case SDL_KEYDOWN:
				if (event.key.keysym.sym==SDLK_ESCAPE) quitGL(); break;
			break;
			case SDL_QUIT: quitGL(); break;
		}
	}
}

int main (int argc, char* argv[])
{
	const SDL_VideoInfo* info = NULL;
	if (SDL_Init(SDL_INIT_VIDEO)<0) quitGL();
	info=SDL_GetVideoInfo();
	width=800; height=600;
	bpp=info->vfmt->BitsPerPixel;
	SDL_GL_SetAttribute(SDL_GL_RED_SIZE,5);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE,5);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE,5);	
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE,16);
	SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 16);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1);
	flags=SDL_OPENGL | SDL_FULLSCREEN;
	if (SDL_SetVideoMode(width,height,bpp,flags)==0) quitGL();
	initGL(width,height);
	SDL_ShowCursor(SDL_DISABLE);

	BASSMOD_Init(-1,44100,0);
 	BASSMOD_MusicLoad(FALSE,musicName,0,0,BASS_MUSIC_RAMPS);
	
 	hsync5=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(5,-1), &mySync5, 0);
	hsync6=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(6,-1), &mySync6, 0);
	hsync7=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(7,-1), &mySync7, 0);
	hsync8=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(8,-1), &mySync8, 0);
	hsync11=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(11,-1), &mySync11, 0);
	hsync12=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(12,-1), &mySync12, 0);
	hsync15=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(15,-1), &mySync15, 0);
	hsync17=BASSMOD_MusicSetSync(BASS_SYNC_MUSICINST, MAKELONG(17,-1), &mySync17, 0);
	
	BASSMOD_MusicSetSync(BASS_SYNC_POS | BASS_SYNC_ONETIME, MAKELONG(28,0), &mySync_pos0, 0);
	BASSMOD_MusicSetSync(BASS_SYNC_POS | BASS_SYNC_ONETIME, MAKELONG(25,0), &mySync_pos1, 1);
	BASSMOD_MusicSetSync(BASS_SYNC_POS | BASS_SYNC_ONETIME, MAKELONG(34,0), &mySync_pos2, 2);
	
	BASSMOD_MusicPlay();
	
	startTime = SDL_GetTicks();

	while (1) {
		process_events();
		display();
	}
}
