/*

  Virtual Disk Library v2.2 by CCT (cct@kki.net.pl)

  (29.01.2001)
*/

#ifndef __stdio_h__
#include <stdio.h>
#endif 

#ifndef _VDISK_H
#define _VDISK_H

#define VDISK_MAX_FILES 512
#define VDISK_FILENAME_LENGTH 256

typedef struct
{
 char filename[VDISK_FILENAME_LENGTH];
 int filesize;
 int fptr;
} files;

typedef struct
{
 char magic[20];
 int files;
 files file[VDISK_MAX_FILES];
} _vdisk;

// actually only one vdisk can be loaded :>
_vdisk vdisk;

typedef struct
{
 int nr;
 int pos;
 int size;
 FILE *file;
 void *ptr;

//0 - vdisk
//1 - stdio
 int mode;
} FILEV;

//- usage
// ret=vdiskinit("disk.res")
//
// if ret==TRUE virtual disk succesfully loaded
//--------------------------------
int vdiskinit(char *);

//- usage
//
// is the same like stdio :>
//
// vdisk first is looking for file in disk.res, and if he found nothing,
// he looking for file in hdd :> blah, sorry for my poor english :)))
//--------------------------------

int freadv(void *, int , int , FILEV *);
FILEV *fopenv(char *, char *);
int fclosev(FILEV *);
int fseekv(FILEV *, int , int );
int ftellv(FILEV *);
int feofv(FILEV *);
char getcv(FILEV *);

#endif