// vdisk library example code by CCT

#include <conio.h>
#include "vdisk.h"

int main()
{
 int result;
 FILEV *f;

// loading virtual disk 'example.res' (created by vdisk.exe)
 result=vdiskinit("example.res");
 if(!result) 
 {
  printf("example.res not found\n");
  return 0;
 }

// opening readme.txt (from virtualdisk)
 f=fopenv("readme.txt", "rb");
 if(f==NULL)
 {
  printf("readme.txt not found\n");
  return 0;
 }

// printing readme.txt on the screen :>
 while(!feofv(f))
 {
  printf("%c",getcv(f));
 }

//closing file
 fclosev(f);

//waiting fot enter :>
 getch();

// ...and now the coolest part of the library...

// opening example.c (note: example.c is not included in 'example.res' :) )
 f=fopenv("example.c", "rb");
 if(f==NULL)
 {
  printf("example.c not found\n");
  return 0;
 }

// printing example.c on the screen :>
 while(!feofv(f))
 {
  printf("%c",getcv(f));
 }

// closing file
 fclosev(f);

 return 0;
}

//... so the usage is the same as in stdio.h :)
