
(*
** Sound Recognition v2.0
** Written by Bas van Gaalen and Sandor van Kollenburg in
**   September and November '96 as a schoolproject.
**
** Version 2 features Frequency Indepandant Sound Recognition (FISR)!
**
** Use numberkeys on gray keypad to change the record-
**   and detectionlevels. And press L to switch between
**   Detection mode and Learning mode.
*)

{$q- Overflowchecking off }
{$r- Rangechecking off }
{$x+ Extended syntax on }
{$s- Stackchecking off }
{$n+ Use coprocessor }
{$e- Use emulation }

{$m 50000,0,655360}

program sound_recognition;

uses
  dos,crt,_fft,types,svga,gui,u_ffpcx,u_pal,u_kb;

const
  signalaxis=70;                                         { Drawing constants }
  signalrange=60;
  grid=10;
  plotzoom=1;

  {treshold=25;}

type
  commentstr=string[20];
  shortstr=commentstr;

  coordrec=record
    x,y:word;
  end;

  sprrec=record                                          { Soundprint record }
    name:commentstr;
    treshold:byte;
    peak:array[0..4] of coordrec;
  end;

const
  nofsprs=5;
  spr:array[1..nofsprs] of sprrec=(
    (name:'Piano';
     treshold:10;
     peak:((x: 49; y:80),
           (x: 97; y:10),
           (x:147; y: 8),
           (x:196; y:12),
           (x:246; y: 7))),
    (name:'Piano';
     treshold:10;
     peak:((x: 55; y:80),
           (x:110; y: 5),
           (x:165; y: 1),
           (x:220; y: 2),
           (x:276; y: 2))),
    (name:'Synth Brass';
     treshold:30;
     peak:((x: 49; y:54),
           (x: 97; y:80),
           (x:146; y:59),
           (x:195; y:36),
           (x:243; y:42))),
    (name:'Synth Brass';
     treshold:30;
     peak:((x: 49; y:77),
           (x: 97; y:80),
           (x:146; y:61),
           (x:195; y:26),
           (x:243; y:35))),
    (name:'Synth Brass';
     treshold:30;
     peak:((x: 49; y:80),
           (x: 97; y:53),
           (x:146; y:30),
           (x:195; y:13),
           (x:243; y:21)))
  );

var
  old1c,                                           { Pointer to timerhandler }
  oldexit:pointer;                                   { Pointer to exit-chain }

(* Global procedures/functions ---------------------------------------------*)

procedure clearstruc(var struc; size:word);            { MAKE 32-BIT CODE!!! }
begin
  fillchar(struc,size,0);
end;

(* Meter draw routines -----------------------------------------------------*)

procedure draw_rv(rv:byte); { Record Volume }
var
  barlen:word;
begin
  barlen:=round(82*rv/7);
  fbox(11,yres-108,19,yres-26-barlen,black);
  fbox(11,yres-25-barlen,19,yres-25,blue);
end;

procedure draw_dv(dv:byte); { Detection Volume }
var
  barlen:word;
begin
  barlen:=round(82*dv/7);
  fbox(31,yres-108,39,yres-26-barlen,black);
  fbox(31,yres-25-barlen,39,yres-25,blue);
end;

procedure draw_dt(dt:byte); { Detection Treshold }
var
  barlen:word;
begin
  barlen:=round(82*dt/15);
  fbox(51,yres-108,59,yres-26-barlen,black);
  fbox(51,yres-25-barlen,59,yres-25,blue);
end;

(* Plot/Display routines ---------------------------------------------------*)

procedure plotsignal(pd,d:sampletype; maxvals,y:word; pc,c:byte);
var
  i,max:word;
  tmp:integer;
  col:byte;
begin
  { Draw horizontal axis }
  max:=maxvals;
  if max>xres-1 then max:=xres-1;
  { Draw the signal }
  for i:=1 to max do begin
    tmp:=round(pd[slack+i])-128;
    if tmp<-signalrange then tmp:=-signalrange
    else if tmp>signalrange then tmp:=signalrange;
    if ((y+tmp) mod grid=0) or (i mod grid=0) then col:=darkgray else col:=pc;
    if tmp=0 then col:=lightgray;
    putpixel(i,y+tmp,col);

    tmp:=round(d[slack+i])-128;
    if tmp<-signalrange then tmp:=-signalrange
    else if tmp>signalrange then tmp:=signalrange;
    putpixel(i,y+tmp,c);
  end;
end;

procedure plotmag(pm,m:magstruc; maxvals,x,y:word; zf,pc,c:byte);
var
  i,j,v:word;
  col:byte;
begin
  { Draw the spectrum }
  for i:=1 to maxvals do
    for j:=0 to zf-1 do begin
      verline((i-1)*zf+j+x,y-round(pm[i]),y,pc);
      v:=round(m[i]);
      if v>20 then col:=white else col:=c;
      verline((i-1)*zf+j+x,y-v,y,col);
    end;
end;

(* Global exit-procedure ---------------------------------------------------*)

procedure newexit; far;
var
  msg:string[80];
begin
  { Restore exit-chain }
  exitproc:=oldexit;
  { Optionally display error message }
  if (exitcode>0) and (erroraddr=nil) then begin
    case exitcode of
       2:msg:='No VESA support';
       3:msg:='Requested VESA mode not supported';
      10:msg:='Fontfile not found';
      11:msg:='Header of fontfile corrupt - not a valid font';
      12:msg:='Error reading data of fontfile';
    else msg:='Unknown error...';
    end;
    writeln('Error: ',msg);
  end;
end;

(* Initialization ----------------------------------------------------------*)

procedure init;
type
  bufptr=^buftyp;
  buftyp=array[0..65000] of byte;
var
  f:file;
  di:searchrec;
  pal:pal_type;
  buf:bufptr;
  i:word;
begin
  { Add new exit-procedure to exit-chain }
  oldexit:=exitproc;
  exitproc:=@newexit;

  { Detect GUI-errorcodes }
  if GUI_Error<>GUI_Err_Okay then halt(GUI_Error);

  { 'Create' credits area }
  horline(0,yres-115,xres-1,white);
  horline(1,yres-114,xres-2,white);
  verline(0,yres-114,yres-1,white);
  verline(1,yres-114,yres-1,white);
  horline(1,yres-1,xres-1,darkgray);
  horline(2,yres-2,xres-2,darkgray);
  verline(xres-1,yres-114,yres-2,darkgray);
  verline(xres-2,yres-113,yres-3,darkgray);
  fbox(2,yres-113,xres-3,yres-3,lightgray);
  horline(xres-110,yres-109,xres-9,darkgray);
  verline(xres-110,yres-108,yres-8,darkgray);
  horline(xres-110,yres-7,xres-8,white);
  verline(xres-8,yres-109,yres-8,white);
  sdrawstr(270,yres-95,'Sound Recognition v2.0',yellow,darkgray,mainfont);
  sdrawstr(270,yres-75,'Design and Implementation by:',white,darkgray,mainfont);
  sdrawstr(290,yres-61,'Bas van Gaalen & Sandor Kollenburg',white,darkgray,mainfont);
  sdrawstr(270,yres-41,'Soundblaster hardware routines by:',white,darkgray,mainfont);
  sdrawstr(290,yres-27,'Romesh Prakashpalan',white,darkgray,mainfont);

  getmem(buf,4+100*100);
  assign(f,'sr.raw');
  reset(f,1);
  blockread(f,pal,768);
  blockread(f,buf^[4],100*100);
  close(f);
  setpal(pal);
  buf^[0]:=100; buf^[1]:=0;
  buf^[2]:=100; buf^[3]:=0;
  drawimage(xres-109,yres-108,buf^);
  freemem(buf,4+100*100);

  { 'Create' information area }
  sdrawstr(80,yres-100,'rv = record volume',lightgreen,darkgray,mainfont);
  sdrawstr(80,yres-86,'dv = detection volume',lightgreen,darkgray,mainfont);
  sdrawstr(80,yres-72,'dt = detection treshold',lightgreen,darkgray,mainfont);

  { Level-meters }
  sdrawstr(10,yres-20,'rv',white,darkgray,mainfont);
  sdrawstr(30,yres-20,'dv',white,darkgray,mainfont);
  sdrawstr(50,yres-20,'dt',white,darkgray,mainfont);
  for i:=0 to 2 do begin
    horline(10+i*20,yres-109,19+i*20,darkgray);
    verline(10+i*20,yres-108,yres-25,darkgray);
    horline(10+i*20,yres-24,20+i*20,white);
    verline(20+i*20,yres-109,yres-24,white);
  end;
  draw_rv(recordvolume);
  draw_dv(detectvolume);
  draw_dt(detecttreshold);

  { Drawgrid }
  i:=signalaxis-signalrange;
  while i<=signalaxis+signalrange do begin
    horline(0,i,xres-1,darkgray);
    inc(i,grid);
  end;
  i:=0;
  while i<=xres-1 do begin
    verline(i,signalaxis-signalrange,signalaxis+signalrange,darkgray);
    inc(i,grid);
  end;
  horline(0,signalaxis,xres-1,lightgray);

  { Draw boxes }
  drawstr(80-25,150,'Input Signal',white,mainfont);
  horline(79-25,251,80-25+plotzoom*maxfpr,darkgray);
  horline(79-25,250-81,80-25+plotzoom*maxfpr,darkgray);
  verline(79-25,250-80,250,darkgray);
  verline(80-25+plotzoom*maxfpr,250-80,250,darkgray);
end;

(*--------------------------------------------------------------------------*)

function compare(m:magstruc; maxvals:word):commentstr;
var
  mulfac:real;
  i,idx,max,mwidth,scaled,imax:word;
  diff:integer;
  j,v,nspr:byte;
  found:boolean;
begin
  { Search highest peek from input }
  mwidth:=sizeof(m);
  i:=20; { Highpass 'filter' }
  max:=0;
  while (max<>80) and (i<mwidth) do begin
    v:=m[i];
    if v>max then begin max:=v; idx:=i; end;
    inc(i);
  end;

  { For every instrument, scale and compare... }
  nspr:=1;
  found:=false;
  while (nspr<=nofsprs) and (not found) do begin
    with spr[nspr] do begin
      mulfac:=idx/peak[0].x;
      diff:=0;
      for i:=0 to 4 do begin
        scaled:=round(peak[i].x*mulfac);
        if scaled<mwidth then begin
          { Search regional maximum }
          max:=0;
          for j:=scaled-2 to scaled+2 do begin
            v:=m[j];
            if v>max then begin max:=v; imax:=j; end;
          end;
          inc(diff,abs(integer(m[imax])-integer(peak[i].y)));
        end;
      end;
      found:=diff<treshold;
    end;
    if not found then inc(nspr);
  end;

  { Return result }
  if found then compare:=spr[nspr].name else compare:='';
end;

(* SuperVGA input procedure ------------------------------------------------*)

procedure svgainput(x,y:word; var s:string; max:byte);
var
  tmp:string;
  key:word;
  i:byte;
  leave:boolean;
begin
  fillchar(tmp,sizeof(tmp),0);
  i:=0;
  leave:=false;
  repeat
    while (port[$3da] and 8)=8 do;
    while (port[$3da] and 8)<>8 do;
    fbox(x,y,x+pLength(tmp,mainfont)+10,y+12,black);
    drawstr(x,y,tmp+'.',white,mainfont);
    key:=getekey;
    case key of
      ord(#32),ord(#35)..ord(#165):if i<max then begin
        if i=0 then tmp:=tmp+upcase(chr(key))
        else tmp:=tmp+chr(key);
        inc(i);
      end;
      crsrbs:if i>0 then begin
        delete(tmp,length(tmp),1);
        dec(i);
      end;
      crsrcr:begin
        s:=tmp;
        leave:=true;
      end;
      crsresc:leave:=true;
    end;
  until leave;
end;

(*--------------------------------------------------------------------------*)

procedure main;
var
  f:file;
  outfname:pathstr;
  sndprtname,numstr,name:commentstr;
  data:datastruc;
  pmag,mag,pdmag,dmag:magstruc;
  pbuf,buf:sampletype;
  i,key:word;
  saverv,savedv,savedt:byte;
begin
  clearstruc(buf,sizeof(buf));
  clearstruc(mag,sizeof(mag));
  clearstruc(dmag,sizeof(dmag));
  saverv:=recordvolume;
  savedv:=detectvolume;
  savedt:=detecttreshold;
  repeat
    if detect then begin { Detect key or input signal: key }
      key:=getekey;
      case key of
        crsrhome,ord('7'):if recordvolume<7 then begin
          inc(recordvolume);
          draw_rv(recordvolume);
        end;
        crsrend,ord('1'):if recordvolume>1 then begin
          dec(recordvolume);
          draw_rv(recordvolume);
        end;
        crsrup,ord('8'):if detectvolume<7 then begin
          inc(detectvolume);
          draw_dv(detectvolume);
        end;
        crsrdown,ord('2'):if detectvolume>1 then begin
          dec(detectvolume);
          draw_dv(detectvolume);
        end;
        crsrpgup,ord('9'):if detecttreshold<15 then begin
          inc(detecttreshold);
          draw_dt(detecttreshold);
        end;
        crsrpgdn,ord('3'):if detecttreshold>1 then begin
          dec(detecttreshold);
          draw_dt(detecttreshold);
        end;
        crsrleft,ord('4'):begin
          recordvolume:=saverv;
          draw_rv(recordvolume);
        end;
        19456,ord('5'):begin
          detectvolume:=savedv;
          draw_dv(detectvolume);
        end;
        crsrright,ord('6'):begin
          detecttreshold:=savedt;
          draw_dt(detecttreshold);
        end;
        ord('S'):begin { Signal Save = Shift-'S' }
          assign(f,'signal.dat');
          rewrite(f,1);
          blockwrite(f,mag,sizeof(mag));
          close(f);
        end;
        ord(' '):fbox(100,320,xres-100,332,black);
        crsresc:exit;
      end;
    end
    else begin { ...input signal }
      move(buf,pbuf,sizeof(buf));
      sampler(buf);
      plotsignal(pbuf,buf,fftsize,signalaxis,black,white);
      clearstruc(data,sizeof(data));
      for i:=0 to fftsize-1 do data[i].re:=buf[slack+i];
      fft(data,fftsize);
      move(mag,pmag,sizeof(mag));
      convert(data,mag,maxfpr);
      plotmag(pmag,mag,maxfpr,80-25,250,plotzoom,black,lightgreen);
      sndprtname:=compare(mag,maxfpr);
      move(dmag,pdmag,sizeof(dmag));
      clearstruc(dmag,sizeof(dmag));
      if sndprtname<>'' then begin
        fbox(100,320,xres-100,332,black);
        drawstr((xres-plength(sndprtname,mainfont)) div 2,320,sndprtname,white,mainfont);
        {move(cspr^.print,dmag,sizeof(magstruc));}
      end;
    end;
  until false;
end;

(*--------------------------------------------------------------------------*)

begin
  init;
  main;
end.
