
(*
** Quickdraw the soundprint-data for manual comparison
** Written by Bas van Gaalen, Sep-Oct '96
*)

program soundprints;

uses
  graph,dos,crt,_fft;                       { Include _fft for msgstruc only }

type
  sorttype=(horizontal,vertical);

(*- User constants ---------------------------------------------------------*)

const
  sorton:sorttype=vertical;                    { Sort horizontal or vertical }
  infmask='spr\*.spr';                { Filemask of files to display '*.spr' }
  bgipath='i:\bgi';                                  { Path to BGI directory }

(*- Internal structures ----------------------------------------------------*)

type
  commentstr=string[20];
  sprrec=record                                          { Soundprint record }
    name:commentstr;
    print:magstruc;
  end;
  sprptr=^sprtyp;                                     { Soundprint structure }
  sprtyp=array[0..65200 div sizeof(sprrec)] of sprrec;

var
  f:file;
  spr:sprptr;
  sprnum:word;

(*- Dynamic-array quicksort routine ----------------------------------------*)

{$s-}
procedure quicksort(l,r:integer);
var tmprec:sprrec; x:commentstr; i,j:integer;
begin
  i:=l; j:=r; x:=spr^[(l+r) div 2].name;
  repeat
    while spr^[i].name<x do inc(i);
    while x<spr^[j].name do dec(j);
    if i<=j then begin
      tmprec:=spr^[i];
      spr^[i]:=spr^[j];
      spr^[j]:=tmprec;
      inc(i); dec(j);
    end;
  until i>J;
  if l<j then quicksort(l,j);
  if i<r then quicksort(i,r);
end;
{$s+}

(*- Initialization ---------------------------------------------------------*)

procedure init;
var
  path:pathstr; name:namestr; ext:extstr;
  di:searchrec;
  i:word;
  dr,md,err:integer;
begin
  { Initialize graphicsmode }
  dr:=detect;
  initgraph(dr,md,bgipath);
  err:=graphresult;
  if err<>grok then halt(1);
  { Figure out number of spr-files... }
  sprnum:=0;
  findfirst(infmask,anyfile,di);
  while doserror=0 do begin
    findnext(di);
    inc(sprnum);
  end;
  getmem(spr,sprnum*sizeof(sprrec));
  { Read the Soundprint data }
  fsplit(infmask,path,name,ext);
  i:=0;
  findfirst(infmask,anyfile,di);
  while doserror=0 do begin
    assign(f,path+di.name);
    reset(f,sizeof(commentstr)+sizeof(magstruc));
    blockread(f,spr^[i],1);
    close(f);
    findnext(di);
    inc(i);
  end;
  { Sort the data on names }
  quicksort(0,sprnum-1);
end;

(*- Draw the frequency spectra ---------------------------------------------*)

procedure draw;
var
  tstr:string;
  idx,i,j,max,x,y:word;
  last:byte;
begin
  j:=0; x:=0; y:=0;
  last:=sprnum-1; if last>35 then last:=35;
  for j:=0 to last do begin
    { Draw index of maximum }
    setcolor(lightgray);
    max:=0;
    for i:=0 to maxfpr-1 do
      if spr^[j].print[i]>max then begin
        max:=spr^[j].print[i];
        idx:=i;
      end;
    str(idx,tstr);
    outtextxy(x+70,y+82,'('+tstr+')');
    { Draw instrumentname }
    setcolor(white);
    outtextxy(x,y+82,copy(spr^[j].name,1,8));
    { Draw soundprint }
    for i:=0 to maxfpr-1 do begin
      if round(spr^[j].print[i])<20 then setcolor(blue) else setcolor(lightblue);
      line(x+i,(y+80),x+i,(y+80)-round((5/8)*spr^[j].print[i]));
    end;
    { Next print }
    if sorton=horizontal then begin
      inc(x,105);
      if x>600 then begin
        x:=0;
        inc(y,70);
      end;
    end
    else begin
      inc(y,70);
      if y>400 then begin
        y:=0;
        inc(x,105);
      end;
    end;
  end;
  while not keypressed do;
  while keypressed do readkey;
end;

(*--------------------------------------------------------------------------*)

begin
  init;
  draw;
  freemem(spr,sprnum*sizeof(sprrec));
  closegraph;
end.
